// Copyright 2020 by FireEye, Inc.
// You may not use this file except in compliance with the license. The license should have been received with this file. You may obtain a copy of the license at:
// https://github.com/fireeye/red_team_tool_countermeasures/blob/master/LICENSE.txt
rule APT_Backdoor_Win_DShell_1
{
    meta:
        description = "This rule is looking for sections of an integer array which contains the encoded payload along with a selection of Windows functions that are present within a DShell payload"
        md5 = "152fc2320790aa16ef9b6126f47c3cca"
        rev = 4
        author = "FireEye"
    strings:
        $e0 = ",0,"
        $e1 = ",1,"
        $e2 = ",2,"
        $e3 = ",3,"
        $e4 = ",4,"
        $e5 = ",5,"
        $e6 = ",6,"
        $e7 = ",7,"
        $e8 = ",8,"
        $e9 = ",9,"
        $e10 = ",10,"
        $e11 = ",11,"
        $e12 = ",12,"
        $e13 = ",13,"
        $e14 = ",14,"
        $e15 = ",15,"
        $e16 = ",16,"
        $e17 = ",17,"
        $e18 = ",18,"
        $e19 = ",19,"
        $e20 = ",20,"
        $e21 = ",21,"
        $e22 = ",22,"
        $e23 = ",23,"
        $e24 = ",24,"
        $e25 = ",25,"
        $e26 = ",26,"
        $e27 = ",27,"
        $e28 = ",28,"
        $e29 = ",29,"
        $e30 = ",30,"
        $e31 = ",31,"
        $e32 = ",32,"
        $e33 = ",33,"
        $e34 = ",34,"
        $e35 = ",35,"
        $e36 = ",36,"
        $e37 = ",37,"
        $e38 = ",38,"
        $e39 = ",39,"
        $e40 = ",40,"
        $e41 = ",41,"
        $e42 = ",42,"
        $e43 = ",43,"
        $e44 = ",44,"
        $e45 = ",45,"
        $e46 = ",46,"
        $e47 = ",47,"
        $e48 = ",48,"
        $e49 = ",49,"
        $e50 = ",50,"
        $e51 = ",51,"
        $e52 = ",52,"
        $e53 = ",53,"
        $e54 = ",54,"
        $e55 = ",55,"
        $e56 = ",56,"
        $e57 = ",57,"
        $e58 = ",58,"
        $e59 = ",59,"
        $e60 = ",60,"
        $e61 = ",61,"
        $e62 = ",62,"
        $e63 = ",63,"
        $e64 = ",64,"
        $s1 = "GetACP"
        $s2 = "GetOEMCP"
        $s3 = "GetCPInfo"
        $s4 = "WriteConsoleA"
        $s5 = "FindFirstFileA"
        $s6 = "FileTimeToDosDateTime"
        $s7 = "FindNextFileA"
        $s8 = "GetStringTypeA"
        $s9 = "GetFileType"
        $s10 = "CreateFileA"
        $s11 = "GlobalAlloc"
        $s12 = "GlobalFree"
        $s13 = "GetTickCount"
        $s14 = "GetProcessHeap"
        $s15 = "UnhandledExceptionFilter"
        $s16 = "ExitProcess"
        $s17 = "GetModuleFileNameA"
        $s18 = "LCMapStringA"
        $s19 = "GetLocalTime"
        $s20 = "CreateThread"
        $s21 = "ExitThread"
        $s22 = "SetConsoleCtrlHandler"
        $s23 = "FreeEnvironmentStringsA"
        $s24 = "GetVersion"
        $s25 = "GetEnvironmentStrings"
        $s26 = "SetHandleCount"
        $s27 = "SetFilePointer"
        $s28 = "DeleteFileA"
        $s29 = "HeapAlloc"
        $s30 = "HeapReAlloc"
        $s31 = "HeapFree"
        $s32 = "GetCommandLineA"
        $s33 = "GetThreadContext"
        $s34 = "SuspendThread"
        $s35 = "FindFirstFileW"
        $s36 = "FindNextFileW"
        $s37 = "FindClose"
        $s38 = "CreateSemaphoreA"
        $s39 = "ReleaseSemaphore"
        $s40 = "ExpandEnvironmentStringsW"
        $s41 = "lstrlenW"
        $s42 = "GetModuleHandleA"
        $s43 = "GetEnvironmentVariableA"
        $s44 = "RtlCaptureContext"
        $s45 = "GlobalMemoryStatus"
        $s46 = "VirtualAlloc"
        $s47 = "Sleep"
        $s48 = "SystemTimeToTzSpecificLocalTime"
        $s49 = "TzSpecificLocalTimeToSystemTime"
        $s50 = "GetTimeZoneInformation"
        $s51 = "TryEnterCriticalSection"
        $s52 = "LoadLibraryA"
        $s53 = "VirtualFree"
        $s54 = "GetExitCodeThread"
        $s55 = "WaitForSingleObject"
        $s56 = "ResumeThread"
        $s57 = "DuplicateHandle"
        $s58 = "GetCurrentProcess"
        $s59 = "GetCurrentThread"
        $s60 = "GetCurrentThreadId"
        $s61 = "InitializeCriticalSection"
        $s62 = "DeleteCriticalSection"
        $s63 = "SwitchToThread"
        $s64 = "LeaveCriticalSection"
        $s65 = "EnterCriticalSection"
        $s66 = "FormatMessageW"
        $s67 = "SetLastError"
        $s68 = "GetEnvironmentVariableW"
        $s69 = "FreeEnvironmentStringsW"
        $s70 = "GetEnvironmentStringsW"
        $s71 = "SetEnvironmentVariableW"
        $s72 = "GetSystemInfo"
        $s73 = "QueryPerformanceFrequency"
        $s74 = "QueryPerformanceCounter"
        $s75 = "CreateProcessW"
        $s76 = "GetStdHandle"
        $s77 = "GetHandleInformation"
        $s78 = "SetHandleInformation"
        $s79 = "WriteFile"
        $s80 = "GetConsoleOutputCP"
        $s81 = "FreeLibrary"
        $s82 = "GetConsoleScreenBufferInfo"
        $s83 = "MultiByteToWideChar"
        $s84 = "RaiseException"
        $s85 = "RtlUnwind"
        $s86 = "GetCurrentDirectoryW"
        $s87 = "IsDebuggerPresent"
        $s88 = "LocalFree"
        $s89 = "WideCharToMultiByte"
        $s90 = "GetCommandLineW"
        $s91 = "ReadFile"
        $s92 = "GetFileSize"
        $s93 = "CloseHandle"
        $s94 = "CreateFileW"
        $s95 = "LoadLibraryW"
        $s96 = "GetProcAddress"
        $s97 = "GetFileAttributesW"
        $s98 = "GetLastError"
        $s99 = "CommandLineToArgvW"
        $s100 = "MessageBoxA"
        $s101 = "RegEnumValueW"
        $s102 = "RegEnumKeyExW"
        $s103 = "RegDeleteValueW"
        $s104 = "RegFlushKey"
        $s105 = "RegQueryInfoKeyW"
        $s106 = "RegDeleteKeyW"
        $s107 = "RegQueryValueExW"
        $s108 = "RegSetValueExW"
        $s109 = "RegOpenKeyW"
        $s110 = "RegOpenKeyExW"
        $s111 = "RegCreateKeyExW"
        $s112 = "RegCloseKey"
    condition:
        (uint16(0) == 0x5A4D and uint32(uint32(0x3C)) == 0x00004550) and filesize > 500KB and 105 of ($s*) and $s112 in (3000..4000) and 40 of ($e*)
}