VMware Exploitation
===================

Pull requests are welcome.

## Research 

### 2020

- ["Detailing Two VMware Workstation TOCTOU Vulnerabilities" by Reno Robert](https://www.zerodayinitiative.com/blog/2020/10/22/detailing-two-vmware-workstation-toctou-vulnerabilities) [article]
- ["SpeedPwning VMware Workstation: Failing at Pwn2Own, but doing it fast" by Corentin Bayet and Bruno Pujos](https://www.synacktiv.com/sites/default/files/2020-10/Speedpwning_VMware_Workstation.pdf) [slides]
- ["Pwning VMware, Part 2: ZDI-19-421, a UHCI bug"](https://nafod.net/blog/2020/02/29/zdi-19-421-uhci.html) [article]
- ["CVE-2020-3947: Use-After-Free Vulnerability in the VMware Workstation DHCP Component" by KP Choubey](https://www.zerodayinitiative.com/blog/2020/4/1/cve-2020-3947-use-after-free-vulnerability-in-the-vmware-workstation-dhcp-component) [article]

### 2019

- "The Great Escape of ESXi" (36C3) [[video](https://www.youtube.com/watch?v=XHDwsvywX50)] [[slides](https://docs.google.com/presentation/d/19UhOPKQvxpIyfFiEH4ylRIDcbl57Ekqrvyk2K_el47c/edit?usp=sharing)]
- ["Taking Control of VMware through the Universal Host Controller Interface: Part 1" by Abdul-Aziz Hariri](https://www.zerodayinitiative.com/blog/2019/5/7/taking-control-of-vmware-through-the-universal-host-controller-interface-part-1) [article]
- ["Taking Control of VMware through the Universal Host Controller Interface: Part 2" by Abdul-Aziz Hariri](https://www.zerodayinitiative.com/blog/2019/8/15/taking-control-of-vmware-through-the-universal-host-control-interface-part-2) [article]
- ["Breaking Turtles All the Way Down: An Exploitation Chain to Break out of VMware ESXi" by Hanqing Zhao et al.](https://www.usenix.org/system/files/woot19-paper_zhao.pdf) [paper]

### 2018

- "Straight outta VMware: Modern exploitation of the SVGA device for guest-to-host escape exploits" by Zisis Sialveras [[slides #1](https://i.blackhat.com/eu-18/Thu-Dec-6/eu-18-Sialveras-Straight-Outta-VMware-Modern-Exploitation-Of-The-SVGA-Device-For-Guest-To-Host-Escapes.pdf)] [[slides #2](https://census-labs.com/media/straightouttavmware-bluehatv18.pdf)] [[video](https://www.youtube.com/watch?v=o36N5wi_ZFs)] [[paper](https://census-labs.com/media/straightouttavmware-wp.pdf)]  [[article](https://census-labs.com/news/2019/01/11/straight-outta-vmware-microsoft-bluehat-v18-black-hat-europe-2018/)]
- ["CVE-2018-6973 Analysis" by Bruno Botelho](http://blog.utxsec.com/?p=66) [article]
- ["VMware Exploitation Through Uninitialized Buffers" by Abdul-Aziz Hariri](https://www.thezdi.com/blog/2018/3/1/vmware-exploitation-through-uninitialized-buffers) [article]
- ["Automating VMware RPC Request Sniffing" by Abdul-Aziz Hariri](https://www.thezdi.com/blog/2018/1/19/automating-vmware-rpc-request-sniffing) [article]
- ["L'art de l'évasion" by Brian Gorenc, Abdul-Aziz Hariri and Jasiel Spelman (OffensiveCon)](https://www.youtube.com/watch?v=UzMpw3-VZl8) [video]
- ["A bunch of Red Pills: VMware Escapes" by Marco Grassi, Azureyang, Jackyxty](https://keenlab.tencent.com/en/2018/04/23/A-bunch-of-Red-Pills-VMware-Escapes/) [article]
- ["Wandering through the Shady Corners of VMware Workstation/Fusion"](https://comsecuris.com/blog/posts/vmware_vgpu_shader_vulnerabilities/) [article]
- ["Modern VMWARE Exploitation Techniques" by Brian Gorenc, Jasiel Spelman, Abdul Aziz Hariri (Infiltrate)](https://vimeo.com/269257039) [video]

### 2017

- ["VMware's Launch Escape System" by Abdul-Aziz Hariri](https://www.thezdi.com/blog/2017/12/21/vmwares-launch-escape-system) [article]
- ["Out of The Truman Show: VM escape in VMware gracefully" by Lei Shi and Mei Wang](https://www.slideshare.net/MSbluehat/bluehat-v17-out-of-the-truman-show-vm-escape-in-vmware-gracefully) [slides]
- "VMware Escapology: How to Houdini The Hypervisor" by AbdulAziz Hariri and Joshua Smith [[article](https://www.thezdi.com/blog/2017/10/04/vmware-escapology-how-to-houdini-the-hypervisor)] [[video](https://www.youtube.com/watch?v=uRemWLNBSZg)] [[code](https://github.com/thezdi/derbycon2017)]
- ["Use-After-Silence: Exploiting a quietly patched UAF in VMware" by Abdul-Aziz Hariri](https://www.thezdi.com/blog/2017/6/26/use-after-silence-exploiting-a-quietly-patched-uaf-in-vmware) [article]
- ["Analyzing a Patch of a Virtual Machine Escape on VMware" by Yakun Zhang](https://www.mcafee.com/blogs/other-blogs/mcafee-labs/analyzing-patch-of-a-virtual-machine-escape-on-vmware/) [article]
- "Leveraging VMware's RPC interface for fun and profit" (ZeroNights) [[slides](https://2017.zeronights.org/wp-content/uploads/materials/ZN17_ZDIteam_Leveraging%20VMware_s%20RPC%20Interface.pdf)] [[slides #2)](https://ruxcon.org.au/assets/2017/slides/ForTheGreaterGood.pdf)] [[video](https://www.youtube.com/watch?v=h0YX8SDuou4)]
- ["The Weak Bug - Exploiting a Heap Overflow in VMware"](http://acez.re/the-weak-bug-exploiting-a-heap-overflow-in-vmware/) [article]
- "[How to exploit cve 2017 4901"](https://github.com/unamer/vmware_escape/wiki/How-to-exploit-cve-2017-4901) [article]
- ["Escape from VMware Workstation by using \"Hearthstone\""](https://cansecwest.com/slides/2017/CSW2017_QinghaoTang_XinleiYing_vmware_escape.pdf) [slides]
- "The Great Escapes of VMware: A Retrospective Case Study of VMware Guest-to-Host Escape Vulnerabilities" by Debasish Mandal and Yakun Zhang (Blackhat Europe) [[slides](https://www.blackhat.com/docs/eu-17/materials/eu-17-Mandal-The-Great-Escapes-Of-Vmware-A-Retrospective-Case-Study-Of-Vmware-G2H-Escape-Vulnerabilities.pdf)] [[video](https://www.youtube.com/watch?v=p0OaGMlBb2k)]
- "Pythonizing the VMware Backdoor" by Abdul-Aziz Hariri [[article](https://www.thezdi.com/blog/2017/8/1/pythonizing-the-vmware-backdoor)]

### 2016

- ["Windows Metafiles: An Analysis of the EMF Attack Surface & Recent Vulnerabilities" by Mateusz "j00ru" Jurczyk](https://j00ru.vexillium.org/slides/2016/metafiles_full.pdf) [slides]
- ["50 Shades Of Fuzzing" by Peter Hlavaty and Marco Grassi](https://papers.put.as/papers/macosx/2016/50_Shades_Of_Fuzzing.pdf) [slides]

### 2015

- ["Escaping VMware Workstation through COM1" by Kostya Kortchinsky](https://www.exploit-db.com/docs/english/37276-escaping-vmware-workstation-through-com1.pdf) [article]

### 2008

- ["Cloudburst: A VMware Guest to Host Escape Story" by Kostya Kortchinsky](https://www.blackhat.com/presentations/bh-usa-09/KORTCHINSKY/BHUSA09-Kortchinsky-Cloudburst-SLIDES.pdf) [slides]

### 2007

- ["An Empirical Study into the Security Exposure to Hosts of Hostile Virtualized Environments" by Tavis Ormandy](http://taviso.decsystem.org/virtsec.pdf) [whitepaper]

## Exploits

- https://www.exploit-db.com/search?q=vmware
- https://github.com/unamer/vmware_escape

## CTF tasks

- Real World CTF 2018 Finals (Station Escape): [writeup 1](https://zhuanlan.zhihu.com/p/52140921), [writeup 2](https://nafod.net/blog/2019/12/21/station-escape-vmware-pwn.html)

## Misc

- https://www.vmware.com/security/advisories.html
- https://sites.google.com/site/chitchatvmback/backdoor
- https://github.com/vmware/open-vm-tools
- https://sourceforge.net/projects/vmware-svga
- http://sysprogs.com/legacy/articles/kdvmware/guestrpc.shtml

## ZDI demos 

- [Demonstrating a VMware Guest-to-Host Escape](https://www.youtube.com/watch?v=NDuWcGn5hTQ)
- [Automating VMware RPC Request Sniffing](https://www.youtube.com/watch?v=ArE35aphCHQ)
- [Demonstration of Use-After-free Escalation in VMware](https://www.youtube.com/watch?v=XAV3JcizbwM)
- [CPython RPC Demonstration](https://www.youtube.com/watch?v=nrajtut6kEE)
- [Demonstrating the vmware_copy_pirate Metasploit Post-Exploitation Module](https://www.youtube.com/watch?v=4R-jJej_TKE)
