
# awesome-vm-exploit [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

Sharing some useful archives about vm and qemu escape exploit.

I want to collect what I can find. Also be welcome to provide me with issues.

In [computer security](https://en.wikipedia.org/wiki/Computer_security), **virtual machine escape** is the process of breaking out of a [virtual machine](https://en.wikipedia.org/wiki/Virtual_machine) and interacting with the host [operating system](https://en.wikipedia.org/wiki/Operating_system).

## VMware

### Writeup and Exploit

* [VMware Escape Exploit - CVE-2017-4901](https://github.com/unamer/vmware_escape)
* [利用一个堆溢出漏洞实现VMware逃逸-CVE-2017-4901](https://zhuanlan.zhihu.com/p/27733895?utm_medium=social&utm_source=wechat_timeline&from=timeline&isappinstalled=1)
* [A-bunch-of-Red-Pills-VMware-Escapes](https://keenlab.tencent.com/en/2018/04/23/A-bunch-of-Red-Pills-VMware-Escapes/)
* [eu-17-Mandal-The-Great-Escapes-Of-Vmware-A-Retrospective-Case-Study-Of-Vmware-G2H-Escape-Vulnerabilities](https://www.blackhat.com/docs/eu-17/materials/eu-17-Mandal-The-Great-Escapes-Of-Vmware-A-Retrospective-Case-Study-Of-Vmware-G2H-Escape-Vulnerabilities.pdf)
* [Vmware-exploit GitHub repositor](https://github.com/xairy/vmware-exploitation)

## Virtualbox

### Basic

* [virtualbox technical background](https://www.virtualbox.org/manual/ch10.html)

### Writeup and Exploit

* [VirtualBox E1000 Guest-to-Host Escape](https://github.com/MorteNoir1/virtualbox_e1000_0day)
* [Oracle VirtualBox < 5.1.30 / < 5.2-rc1 - GUest to Host Escape](https://www.exploit-db.com/exploits/43878/)
* [VirtualBox 5.2.6.r120293 -VM Escape](https://www.exploit-db.com/exploits/45372/)
* [Pwn2Own 2018 Virtualbox 的漏洞分析及利用介绍：thinking_outside_the_virtualbox](https://github.com/phoenhex/files/blob/master/slides/thinking_outside_the_virtualbox.pdf)

##  Qemu

### Writeup and Exploit

* [VM escape - QEMU Case Study](http://www.phrack.org/papers/vm-escape-qemu-case-study.html)
* [Qemu - Escape - analysis - CVE-2015-7504 and CVE-2015-7512](https://www.anquanke.com/post/id/83015)
* [Some Qemu escape exploit](https://github.com/dangokyo/QEMU_ESCAPE)
* [CVE-2020-14364 QEMU逃逸 漏洞分析 ](https://mp.weixin.qq.com/s/MQyczZXRfOsIQewNf7cfXw)

## Docker

### Basic

* [eu-15-Bettini-Vulnerability-Exploitation-In-Docker-Container-Environments](https://www.blackhat.com/docs/eu-15/materials/eu-15-Bettini-Vulnerability-Exploitation-In-Docker-Container-Environments.pdf)
* [CSW2016-Docker-Escape-Techonology](https://cansecwest.com/slides/2016/CSW2016_Wang_DockerEscapeTechnology.pdf)


### Writeup and Exploit

* [Docker 容器逃逸案例分析](https://yq.aliyun.com/articles/57803?utm_source=qq)
* [escaping-docker-container-using-waitid-cve-2017-5123](https://www.twistlock.com/labs-blog/escaping-docker-container-using-waitid-cve-2017-5123/)

##  Hyper-V

* [awesome-hyper-v-exploitation](https://github.com/shogunlab/awesome-hyper-v-exploitation)

## Misc

* [google group vmkernelnewbies(has some good basic intro)](https://groups.google.com/forum/#!forum/vmkernelnewbies)
* [XEN D2T2-Shangcong-Luan-Xen-Hypervisor-VM-Escape](http://conference.hitb.org/hitbsecconf2016ams/wp-content/uploads/2015/11/D2T2-Shangcong-Luan-Xen-Hypervisor-VM-Escape.pdf)
* [vmware exploitation(list)](https://github.com/xairy/vmware-exploitation)

## CTFs

### Writeup and Exploit

* [realword ctf - state-of-the-art_vm](https://xz.aliyun.com/t/2513)
* [HITB 2017 - babyqemu](https://kitctf.de/writeups/hitb2017/babyqemu)
* [0CTF 2017 - QEMU EScape](https://blog.eadom.net/writeups/qemu-escape-vm-escape-from-0ctf-2017-finals-writeup/)
