#ifndef ICLIENTRENDERABLE_H
#define ICLIENTRENDERABLE_H

typedef unsigned short ClientShadowHandle_t;
typedef unsigned short ClientRenderHandle_t;
typedef unsigned short ModelInstanceHandle_t;
typedef unsigned char uint8_t;

class IClientUnknown;
class IBaseEntity;
struct model_t;

#include "ibaseentity.h"

class IClientRenderable
{
  public:

	virtual IClientUnknown* GetIClientUnknown() = 0;
	virtual vec3 const& GetRenderOrigin(void) = 0;
	virtual vec3 const& GetRenderAngles(void) = 0;
	virtual bool ShouldDraw(void) = 0;
	virtual void* IsTransparent_() = 0;
	virtual void* UsesPowerOfTwoFrameBufferTexture_() = 0;
	virtual void* UsesFullFrameBufferTexture_() = 0;
	virtual ClientShadowHandle_t GetShadowHandle() const = 0;
	virtual ClientRenderHandle_t& RenderHandle() = 0;
	virtual const model_t* GetModel() const = 0;
	virtual int DrawModel(int flags, const int /*RenderableInstance_t*/ &instance) = 0;
	virtual int GetBody() = 0;
	virtual void ComputeFxBlend_() = 0;
	virtual void* GetFxBlend_() = 0;
	virtual void GetColorModulation(float* color) = 0;
	virtual bool LODTest() = 0;
	virtual bool SetupBones(matrix3x4_t *pBoneToWorldOut, int nMaxBones, int boneMask, float currentTime) = 0;
	virtual void SetupWeights(const matrix3x4_t *pBoneToWorld, int nFlexWeightCount, float *pFlexWeights, float *pFlexDelayedWeights) = 0;
	virtual void DoAnimationEvents(void) = 0;
	virtual void* /*IPVSNotify*/ GetPVSNotifyInterface() = 0;
	virtual void GetRenderBounds(vec3& mins, vec3& maxs) = 0;
	virtual void GetRenderBoundsWorldspace(vec3& mins, vec3& maxs) = 0;
	virtual void GetShadowRenderBounds(vec3 &mins, vec3 &maxs, int /*ShadowType_t*/ shadowType) = 0;
	virtual bool ShouldReceiveProjectedTextures(int flags) = 0;
	virtual bool GetShadowCastDistance(float* pDist, int /*ShadowType_t*/ shadowType) const = 0;
	virtual bool GetShadowCastDirection(vec3* pDirection, int /*ShadowType_t*/ shadowType) const = 0;
	virtual bool IsShadowDirty() = 0;
	virtual void MarkShadowDirty(bool bDirty) = 0;
	virtual IClientRenderable* GetShadowParent() = 0;
	virtual IClientRenderable* FirstShadowChild() = 0;
	virtual IClientRenderable* NextShadowPeer() = 0;
	virtual int /*ShadowType_t*/ ShadowCastType() = 0;
	virtual void CreateModelInstance() = 0;
	virtual ModelInstanceHandle_t GetModelInstance() = 0;
	virtual const matrix3x4_t& RenderableToWorldTransform() = 0;
	virtual int LookupAttachment(const char *pAttachmentName) = 0;
	virtual bool GetAttachment(int number, vec3 &origin, vec3 &angles) = 0;
	virtual bool GetAttachment(int number, matrix3x4_t &matrix) = 0;
	virtual float* GetRenderClipPlane(void) = 0;
	virtual int GetSkin() = 0;
	virtual bool IsTwoPass() = 0;
	virtual void OnThreadedDrawSetup() = 0;
	virtual bool UsesFlexDelayedWeights() = 0;
	virtual void RecordToolMessage() = 0;
	virtual bool IgnoresZBuffer() = 0;
};

#endif
