exports.definition = [
  '#%RAML 0.8\\n                    ',
  'title: "Muse: Mule Sales Enablement API"\\n                    ',
  'version: v1\\n                    ',
  'baseUri: http://examples.ramlicio.us/muse\\n                    ',
  'schemas:\\n                    ',
  '  - presentation: |\\n                    ',
  '      {  "$schema": "http://json-schema.org/draft-03/schema",\\n                    ',
  '         "type": "object",\\n                    ',
  '         "description": "A product presentation",\\n                    ',
  '         "properties": {\\n                    ',
  '           "id":  { "type": "string" },\\n                    ',
  '           "title":  { "type": "string" },\\n                    ',
  '           "description":  { "type": "string" },\\n                    ',
  '           "fileUrl":  { "type": "string" },\\n                    ',
  '           "productId":  { "type": "string" }\\n                    ',
  '         },\\n                    ',
  '         "required": [ "id", "title", "fileUrl", "productId" ]\\n                    ',
  '      }\\n                    ',
  '  - presentations: |\\n                    ',
  '      {  "$schema": "http://json-schema.org/draft-03/schema",\\n                    ',
  '         "type": "array",\\n                    ',
  '         "description": "Multiple product presentations",\\n                    ',
  '         "items": {\\n                    ',
  '           "type": "object",\\n                    ',
  '           "properties": {\\n                    ',
  '             "id":  { "type": "string" },\\n                    ',
  '             "title":  { "type": "string" },\\n                    ',
  '             "description":  { "type": "string" },\\n                    ',
  '             "fileUrl":  { "type": "string" },\\n                    ',
  '             "productId":  { "type": "string" }\\n                    ',
  '           },\\n                    ',
  '           "required": [ "id", "title", "fileUrl", "productId" ]\\n                    ',
  '         }\\n                    ',
  '      }\\n                    ',
  '  - product: |\\n                    ',
  '      {  "$schema": "http://json-schema.org/draft-03/schema",\\n                    ',
  '         "type": "object",\\n                    ',
  '         "description": "A product",\\n                    ',
  '         "properties": {\\n                    ',
  '           "id":  { "type": "string" },\\n                    ',
  '           "name":  { "type": "string" },\\n                    ',
  '           "description":  { "type": "string" },\\n                    ',
  '           "imageUrl":  { "type": "string" },\\n                    ',
  '           "region": { "type": "string" }\\n                    ',
  '         },\\n                    ',
  '         "required": [ "id", "name", "region" ]\\n                    ',
  '      }\\n                    ',
  '  - products: |\\n                    ',
  '      {  "$schema": "http://json-schema.org/draft-03/schema",\\n                    ',
  '         "type": "array",\\n                    ',
  '         "description": "Multiple products",\\n                    ',
  '         "items": {\\n                    ',
  '           "type": "object",\\n                    ',
  '           "properties": {\\n                    ',
  '             "id":  { "type": "string" },\\n                    ',
  '             "name":  { "type": "string" },\\n                    ',
  '             "description":  { "type": "string" },\\n                    ',
  '             "imageUrl":  { "type": "string" },\\n                    ',
  '             "region":  { "type": "string" }\\n                    ',
  '           },\\n                    ',
  '           "required": [ "id", "name", "region" ]\\n                    ',
  '         }\\n                    ',
  '      }\\n                    ',
  'resourceTypes:\\n                    ',
  '  - base:\\n                    ',
  '      get?:\\n                    ',
  '        responses: &standardResponses\\n                    ',
  '          200:\\n                    ',
  '            description: OK\\n                    ',
  '      put?:\\n                    ',
  '        responses: *standardResponses\\n                    ',
  '      patch?:\\n                    ',
  '        responses: *standardResponses\\n                    ',
  '      post?:\\n                    ',
  '        responses:\\n                    ',
  '          201:\\n                    ',
  '            description: Created\\n                    ',
  '      delete?:\\n                    ',
  '        responses: *standardResponses\\n                    ',
  '  - collection:\\n                    ',
  '      type: base\\n                    ',
  '      get:\\n                    ',
  '        is: [ paged ]\\n                    ',
  '        responses:\\n                    ',
  '          200:\\n                    ',
  '            body:\\n                    ',
  '              application/json:\\n                    ',
  '                schema: <<schema | !pluralize>>\\n                    ',
  '      post:\\n                    ',
  '        body:\\n                    ',
  '          application/json:\\n                    ',
  '            schema: <<schema>>\\n                    ',
  '        responses:\\n                    ',
  '          201:\\n                    ',
  '            body:\\n                    ',
  '              application/json:\\n                    ',
  '                schema: <<schema>>\\n                    ',
  '  - member:\\n                    ',
  '      type: base\\n                    ',
  '      get:\\n                    ',
  '        responses:\\n                    ',
  '          200:\\n                    ',
  '            body:\\n                    ',
  '              application/json:\\n                    ',
  '                schema: <<schema>>\\n                    ',
  '      put:\\n                    ',
  '        body:\\n                    ',
  '          application/json:\\n                    ',
  '            schema: <<schema>>\\n                    ',
  '        responses:\\n                    ',
  '          200:\\n                    ',
  '            body:\\n                    ',
  '              application/json:\\n                    ',
  '                schema: <<schema>>\\n                    ',
  '      patch:\\n                    ',
  '        body:\\n                    ',
  '          application/json:\\n                    ',
  '            schema: <<schema>>\\n                    ',
  '        responses:\\n                    ',
  '          200:\\n                    ',
  '            body:\\n                    ',
  '              application/json:\\n                    ',
  '                schema: <<schema>>\\n                    ',
  '      delete:\\n                    ',
  'traits:\\n                    ',
  '  - paged:\\n                    ',
  '      displayName: paged\\n                    ',
  '      queryParameters:\\n                    ',
  '        start:\\n                    ',
  '          description: The first page to return\\n                    ',
  '          type: number\\n                    ',
  '        pages:\\n                    ',
  '          description: The number of pages to return\\n                    ',
  '          type: number\\n                    ',
  '  - secured:\\n                    ',
  '      displayName: secured\\n                    ',
  '      headers:\\n                    ',
  '        Authorization:\\n                    ',
  '          description: The auth token for this request\\n                    ',
  '      responses:\\n                    ',
  '        401:\\n                    ',
  '          description: Unauthorized\\n                    ',
  '/presentations: &presentations\\n                    ',
  '  type: { collection: { schema: presentation } }\\n                    ',
  '  is: [ secured ]\\n                    ',
  '  get:\\n                    ',
  '    queryParameters:\\n                    ',
  '      title:\\n                    ',
  '        description: Filter by title\\n                    ',
  '  /{presentationId}:\\n                    ',
  '    type: { member: { schema: presentation } }\\n                    ',
  '    is: [ secured ]\\n                    ',
  '/products:\\n                    ',
  '  type: { collection: { schema: product } }\\n                    ',
  '  is: [ secured ]\\n                    ',
  '  get:\\n                    ',
  '    queryParameters:\\n                    ',
  '      region:\\n                    ',
  '        description: Filter by region\\n                    ',
  '  /{productId}:\\n                    ',
  '    type: { member: { schema: product } }\\n                    ',
  '    is: [ secured ]\\n                    ',
  '    /presentations: *presentations\\n                    '
];
