/*******************************************************************************

	ZXlate.c
	
		Zone(tm) translation routines.
	
	Copyright  Electric Gravity, Inc. 1995. All rights reserved.
	Written by Hoon Im
	Created on Tuesday, 25, 1995.
	
	Change History (most recent first):
	----------------------------------------------------------------------------
	Rev	 |	Date	 |	Who	 |	What
	----------------------------------------------------------------------------
	2		12/12/96	HI		Remove MSVCRT.DLL dependency.
	1		04/08/96	HI		Modified prototype of ZTranslateText() to
								include conversion parameter. Also added
								functionality to convert ascii value from/to
								standard (unix/pc) and platform.
	0		07/25/95	HI		Created.
	 
*******************************************************************************/


#include <windows.h>

#include "zone.h"
#include "zonemem.h"

#if 0


#define zCharLineFeed			_T('\n')
#define zCharReturn				_T('\r')

#define GetNext(p)				(*(p)++)
#define PeekNext(p)				(*(p))


/* -------- Globals -------- */
#ifdef __ZWindows__
static uchar				gToSystemTable[] =
		{
			0x00,	0x01,	0x02,	0x03,	0x04,	0x05,	0x06,	0x07,
			0x08,	0x09,	0x0A,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,
			0x10,	0x11,	0x12,	0x13,	0x14,	0x15,	0x16,	0x17,
			0x18,	0x19,	0x1A,	0x1B,	0x1C,	0x1D,	0x1E,	0x1F,
			0x20,	0x21,	0x22,	0x23,	0x24,	0x25,	0x26,	0x27,
			0x28,	0x29,	0x2A,	0x2B,	0x2C,	0x2D,	0x2E,	0x2F,
			0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,
			0x38,	0x39,	0x3A,	0x3B,	0x3C,	0x3D,	0x3E,	0x3F,
			0x40,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,
			0x48,	0x49,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,
			0x50,	0x51,	0x52,	0x53,	0x54,	0x55,	0x56,	0x57,
			0x58,	0x59,	0x5A,	0x5B,	0x5C,	0x5D,	0x5E,	0x5F,
			0x60,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,
			0x68,	0x69,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,
			0x70,	0x71,	0x72,	0x73,	0x74,	0x75,	0x76,	0x77,
			0x78,	0x79,	0x7A,	0x7B,	0x7C,	0x7D,	0x7E,	0x7F,
			0x80,	0x81,	0x82,	0x83,	0x84,	0x85,	0x86,	0x87,
			0x88,	0x89,	0x8A,	0x8B,	0x8C,	0x8D,	0x8E,	0x8F,
			0x90,	0x91,	0x92,	0x93,	0x94,	0x95,	0x96,	0x97,
			0x98,	0x99,	0x9A,	0x9B,	0x9C,	0x9D,	0x9E,	0x9F,
			0xA0,	0xA1,	0xA2,	0xA3,	0xA4,	0xA5,	0xA6,	0xA7,
			0xA8,	0xA9,	0xAA,	0xAB,	0xAC,	0xAD,	0xAE,	0xAF,
			0xB0,	0xB1,	0xB2,	0xB3,	0xB4,	0xB5,	0xB6,	0xB7,
			0xB8,	0xB9,	0xBA,	0xBB,	0xBC,	0xBD,	0xBE,	0xBF,
			0xC0,	0xC1,	0xC2,	0xC3,	0xC4,	0xC5,	0xC6,	0xC7,
			0xC8,	0xC9,	0xCA,	0xCB,	0xCC,	0xCD,	0xCE,	0xCF,
			0xD0,	0xD1,	0xD2,	0xD3,	0xD4,	0xD5,	0xD6,	0xD7,
			0xD8,	0xD9,	0xDA,	0xDB,	0xDC,	0xDD,	0xDE,	0xDF,
			0xE0,	0xE1,	0xE2,	0xE3,	0xE4,	0xE5,	0xE6,	0xE7,
			0xE8,	0xE9,	0xEA,	0xEB,	0xEC,	0xED,	0xEE,	0xEF,
			0xF0,	0xF1,	0xF2,	0xF3,	0xF4,	0xF5,	0xF6,	0xF7,
			0xF8,	0xF9,	0xFA,	0xFB,	0xFC,	0xFD,	0xFE,	0xFF
		};
static uchar				gToStandardTable[] =
		{
			0x00,	0x01,	0x02,	0x03,	0x04,	0x05,	0x06,	0x07,
			0x08,	0x09,	0x0A,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,
			0x10,	0x11,	0x12,	0x13,	0x14,	0x15,	0x16,	0x17,
			0x18,	0x19,	0x1A,	0x1B,	0x1C,	0x1D,	0x1E,	0x1F,
			0x20,	0x21,	0x22,	0x23,	0x24,	0x25,	0x26,	0x27,
			0x28,	0x29,	0x2A,	0x2B,	0x2C,	0x2D,	0x2E,	0x2F,
			0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,
			0x38,	0x39,	0x3A,	0x3B,	0x3C,	0x3D,	0x3E,	0x3F,
			0x40,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,
			0x48,	0x49,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,
			0x50,	0x51,	0x52,	0x53,	0x54,	0x55,	0x56,	0x57,
			0x58,	0x59,	0x5A,	0x5B,	0x5C,	0x5D,	0x5E,	0x5F,
			0x60,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,
			0x68,	0x69,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,
			0x70,	0x71,	0x72,	0x73,	0x74,	0x75,	0x76,	0x77,
			0x78,	0x79,	0x7A,	0x7B,	0x7C,	0x7D,	0x7E,	0x7F,
			0x80,	0x81,	0x82,	0x83,	0x84,	0x85,	0x86,	0x87,
			0x88,	0x89,	0x8A,	0x8B,	0x8C,	0x8D,	0x8E,	0x8F,
			0x90,	0x91,	0x92,	0x93,	0x94,	0x95,	0x96,	0x97,
			0x98,	0x99,	0x9A,	0x9B,	0x9C,	0x9D,	0x9E,	0x9F,
			0xA0,	0xA1,	0xA2,	0xA3,	0xA4,	0xA5,	0xA6,	0xA7,
			0xA8,	0xA9,	0xAA,	0xAB,	0xAC,	0xAD,	0xAE,	0xAF,
			0xB0,	0xB1,	0xB2,	0xB3,	0xB4,	0xB5,	0xB6,	0xB7,
			0xB8,	0xB9,	0xBA,	0xBB,	0xBC,	0xBD,	0xBE,	0xBF,
			0xC0,	0xC1,	0xC2,	0xC3,	0xC4,	0xC5,	0xC6,	0xC7,
			0xC8,	0xC9,	0xCA,	0xCB,	0xCC,	0xCD,	0xCE,	0xCF,
			0xD0,	0xD1,	0xD2,	0xD3,	0xD4,	0xD5,	0xD6,	0xD7,
			0xD8,	0xD9,	0xDA,	0xDB,	0xDC,	0xDD,	0xDE,	0xDF,
			0xE0,	0xE1,	0xE2,	0xE3,	0xE4,	0xE5,	0xE6,	0xE7,
			0xE8,	0xE9,	0xEA,	0xEB,	0xEC,	0xED,	0xEE,	0xEF,
			0xF0,	0xF1,	0xF2,	0xF3,	0xF4,	0xF5,	0xF6,	0xF7,
			0xF8,	0xF9,	0xFA,	0xFB,	0xFC,	0xFD,	0xFE,	0xFF
		};
#endif

#ifdef __ZMacintosh__
static uchar				gToSystemTable[] =
		{
			0x00,	0x01,	0x02,	0x03,	0x04,	0x05,	0x06,	0x07,
			0x08,	0x09,	0x0D,	0x0B,	0x0C,	0x0D,	0x0E,	0x0F,
			0x10,	0x11,	0x12,	0x13,	0x14,	0x15,	0x16,	0x17,
			0x18,	0x19,	0x1A,	0x1B,	0x1C,	0x1D,	0x1E,	0x1F,
			0x20,	0x21,	0x22,	0x23,	0x24,	0x25,	0x26,	0x27,
			0x28,	0x29,	0x2A,	0x2B,	0x2C,	0x2D,	0x2E,	0x2F,
			0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,
			0x38,	0x39,	0x3A,	0x3B,	0x3C,	0x3D,	0x3E,	0x3F,
			0x40,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,
			0x48,	0x49,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,
			0x50,	0x51,	0x52,	0x53,	0x54,	0x55,	0x56,	0x57,
			0x58,	0x59,	0x5A,	0x5B,	0x5C,	0x5D,	0x5E,	0x5F,
			0x60,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,
			0x68,	0x69,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,
			0x70,	0x71,	0x72,	0x73,	0x74,	0x75,	0x76,	0x77,
			0x78,	0x79,	0x7A,	0x7B,	0x7C,	0x7D,	0x7E,	0x7F,
			0xA5,	0xAA,	0xAD,	0xB0,	0xB3,	0xB7,	0xBA,	0xBD,
			0xC3,	0xC5,	0xC9,	0xD1,	0xD4,	0xD9,	0xDA,	0xB6,
			0xC6,	0xCE,	0xE2,	0xE3,	0xE4,	0xF0,	0xF6,	0xF7,
			0xF9,	0xFA,	0xFB,	0xFD,	0xFE,	0xFF,	0xF5,	0xC4,
			0xCA,	0xC1,	0xA2,	0xA3,	0xDB,	0xB4,	0xCF,	0xA4,
			0xAC,	0xA9,	0xBB,	0xC7,	0xC2,	0xD0,	0xA8,	0xF8,
			0xA1,	0xB1,	0xD3,	0xD2,	0xAB,	0xB5,	0xA6,	0xE1,
			0xFC,	0xD5,	0xBC,	0xC8,	0xB9,	0xB8,	0xB2,	0xC0,
			0xCB,	0xE7,	0xE5,	0xCC,	0x80,	0x81,	0xAE,	0x82,
			0xE9,	0x83,	0xE6,	0xE8,	0xED,	0xEA,	0xEB,	0xEC,
			0xDC,	0x84,	0xF1,	0xEE,	0xEF,	0xCD,	0x85,	0xD7,
			0xAF,	0xF4,	0xF2,	0xF3,	0x86,	0xA0,	0xDE,	0xA7,
			0x88,	0x87,	0x89,	0x8B,	0x8A,	0x8C,	0xBE,	0x8D,
			0x8F,	0x8E,	0x90,	0x91,	0x93,	0x92,	0x94,	0x95,
			0xDD,	0x96,	0x98,	0x97,	0x99,	0x9B,	0x9A,	0xD6,
			0xBF,	0x9D,	0x9C,	0x9E,	0x9F,	0xE0,	0xDF,	0xD8
		};
static uchar				gToStandardTable[] =
		{
			0x00,	0x01,	0x02,	0x03,	0x04,	0x05,	0x06,	0x07,
			0x08,	0x09,	0x0A,	0x0B,	0x0C,	0x0A,	0x0E,	0x0F,
			0x10,	0x11,	0x12,	0x13,	0x14,	0x15,	0x16,	0x17,
			0x18,	0x19,	0x1A,	0x1B,	0x1C,	0x1D,	0x1E,	0x1F,
			0x20,	0x21,	0x22,	0x23,	0x24,	0x25,	0x26,	0x27,
			0x28,	0x29,	0x2A,	0x2B,	0x2C,	0x2D,	0x2E,	0x2F,
			0x30,	0x31,	0x32,	0x33,	0x34,	0x35,	0x36,	0x37,
			0x38,	0x39,	0x3A,	0x3B,	0x3C,	0x3D,	0x3E,	0x3F,
			0x40,	0x41,	0x42,	0x43,	0x44,	0x45,	0x46,	0x47,
			0x48,	0x49,	0x4A,	0x4B,	0x4C,	0x4D,	0x4E,	0x4F,
			0x50,	0x51,	0x52,	0x53,	0x54,	0x55,	0x56,	0x57,
			0x58,	0x59,	0x5A,	0x5B,	0x5C,	0x5D,	0x5E,	0x5F,
			0x60,	0x61,	0x62,	0x63,	0x64,	0x65,	0x66,	0x67,
			0x68,	0x69,	0x6A,	0x6B,	0x6C,	0x6D,	0x6E,	0x6F,
			0x70,	0x71,	0x72,	0x73,	0x74,	0x75,	0x76,	0x77,
			0x78,	0x79,	0x7A,	0x7B,	0x7C,	0x7D,	0x7E,	0x7F,
			0xC4,	0xC5,	0xC7,	0xC9,	0xD1,	0xD6,	0xDC,	0xE1,
			0xE0,	0xE2,	0xE4,	0xE3,	0xE5,	0xE7,	0xE9,	0xE8,
			0xEA,	0xEB,	0xED,	0xEC,	0xEE,	0xEF,	0xF1,	0xF3,
			0xF2,	0xF4,	0xF6,	0xF5,	0xFA,	0xF9,	0xFB,	0xFC,
			0xDD,	0xB0,	0xA2,	0xA3,	0xA7,	0x80,	0xB6,	0xDF,
			0xAE,	0xA9,	0x81,	0xB4,	0xA8,	0x82,	0xC6,	0xD8,
			0x83,	0xB1,	0xBE,	0x84,	0xA5,	0xB5,	0x8F,	0x85,
			0xBD,	0xBC,	0x86,	0xAA,	0xBA,	0x87,	0xE6,	0xF8,
			0xBF,	0xA1,	0xAC,	0x88,	0x9F,	0x89,	0x90,	0xAB,
			0xBB,	0x8A,	0xA0,	0xC0,	0xC3,	0xD5,	0x91,	0xA6,
			0xAD,	0x8B,	0xB3,	0xB2,	0x8C,	0xB9,	0xF7,	0xD7,
			0xFF,	0x8D,	0x8E,	0xA4,	0xD0,	0xF0,	0xDE,	0xFE,
			0xFD,	0xB7,	0x92,	0x93,	0x94,	0xC2,	0xCA,	0xC1,
			0xCB,	0xC8,	0xCD,	0xCE,	0xCF,	0xCC,	0xD3,	0xD4,
			0x95,	0xD2,	0xDA,	0xDB,	0xD9,	0x9E,	0x96,	0x97,
			0xAF,	0x98,	0x99,	0x9A,	0xB8,	0x9B,	0x9C,	0x9D
		};
#endif


/*******************************************************************************
		EXPORTED ROUTINES
*******************************************************************************/
/*
	ZTranslateText()
	
	Translates the given null-terminated text into the platform format. It
	basically handles the conversion of line feed and carriage return characters
	into the text.
	
	It returns a new pointer to the translated text.
	
	Mac:	\r
	Unix:	\n
	PC:		\r\n
	
	Method: Since it does not know the eventual length of the text, it simply
	allocates a buffer twice the size of the given text (assuming the worst
	case of every character converting to 2 characters). After the translation,
	it reallocates the buffer to the correct size. (WINDOWS ONLY)
*/
char* ZTranslateText(char* text, int16 conversion)
{
	int16			len, len2;
	char*			dst;
	char*			src;
	char*			newText;
	char			curByte;
	
	
	/* Allocate the temporary buffer. */
	len2 = lstrlen(text) + 1;
#ifdef __ZWindows__
	len2 *= 2;
#endif
	newText = ZMalloc(len2);
	
	dst = newText;
	src = text;
	len = 0;
	while ((curByte = GetNext(src)) != '\0')
	{
		if (curByte == zCharLineFeed || curByte == zCharReturn)
		{
#ifdef __ZMacintosh__
			/*
				Convert all line feeds and carriage returns into carriage returns.
			*/
			*dst++ = zCharReturn;
			len++;
#endif

#ifdef __ZUnix__
			/*
				Convert all line feeds and carriage returns into line feeds.
			*/
			*dst++ = zCharLineFeed;
			len++;
#endif

#ifdef __ZWindows__
			/*
				Convert all line feeds and carriage returns into line feed and
				carriage return combination.
			*/
			*dst++ = zCharReturn;
			len++;
			*dst++ = zCharLineFeed;
			len++;
#endif
			
			/*
				If it is a carriage return and the next character is a line feed,
				then consume the next character.
			*/
			if (curByte == zCharReturn && PeekNext(src) == zCharLineFeed)
				curByte = GetNext(src);
		}
		else
		{
			if (conversion == zToSystem)
				*dst++ = (char) gToSystemTable[(uchar) curByte];
			else
				*dst++ = (char) gToStandardTable[(uchar) curByte];
			len++;
		}
	}
	*dst = '\0';
	len++;
	
	/* Reallocate the buffer. */
	if (len != len2)
		newText = ZRealloc(newText, len);
	
	return (newText);
}


#endif // 0 - commented out (no one uses it)