/*******************************************************************************

	Misc.c
	
		Miscellaneous routines.
	
	Copyright  Electric Gravity, Inc. 1994. All rights reserved.
	Written by Hoon Im, Kevin Binkley
	Created on Saturday, November 12, 1994 10:04:52 PM
	
	Change History (most recent first):
	----------------------------------------------------------------------------
	Rev	 |	Date	 |	Who	 |	What
    ----------------------------------------------------------------------------
	8		2/09/96		CHB		Added ZLaunchURL().
    7       1/09/97  craigli    #ifdef'd zone.ini code
    6       12/16/96    HI      Changed ZMemCpy() to memcpy().
	5		12/12/96	HI		Remove MSVCRT.DLL dependency.
	4		11/08/96	HI		Conditional removal of fonts and colors for
								ZONECLI_DLL.
    3       10/28/96 craigli    Added GetPrivateProfile commands.
    2       10/23/96    HI      Changed ZParseVillageCommandLine().
	1		10/23/96	HI		Changed ZParseVillageCommandLine() to accept
								char* for serverAddr and parse the server address
								as a string instead of as a number.
	0		11/12/94	HI		Created.
	 
*******************************************************************************/


#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>

#include "zoneint.h"
#include "zonecli.h"
#include "zonemem.h"


/* -------- Globals -------- */

#ifndef ZONECLI_DLL

/* -------- Predefined Colors -------- */
ZColor			zColorBlack			=	{	0,	0x00,	0x00,	0x00};
ZColor			zColorDarkGray		=	{	0,	0x33,	0x33,	0x33};
ZColor			zColorGray			=	{	0,	0x80,	0x80,	0x80};
ZColor			zColorLightGray		=	{	0,	0xC0,	0xC0,	0xC0};
ZColor			zColorWhite			=	{	0,	0xFF,	0xFF,	0xFF};
ZColor			zColorRed			=	{	0,	0xFF,	0x00,	0x00};
ZColor			zColorGreen			=	{	0,	0x00,	0xFF,	0x00};
ZColor			zColorBlue			=	{	0,	0x00,	0x00,	0xFF};
ZColor			zColorYellow		=	{	0,	0xFF,	0xFF,	0x00};
ZColor			zColorCyan			=	{	0,	0x00,	0xFF,	0xFF};
ZColor			zColorMagenta		=	{	0,	0xFF,	0x00,	0xFF};

/* -------- Predefined Font Objects -------- */
ZFont			zFontSystem12Normal;
ZFont			zFontApp9Normal;
ZFont			zFontApp9Bold;
ZFont			zFontApp12Normal;
ZFont			zFontApp12Bold;

#endif


/* -------- Internal Routines -------- */


/*******************************************************************************
	EXPORTED ROUTINES
*******************************************************************************/

/*
	ZRectIntersect()
	
	Returns TRUE if rectA and rectB overlap; otherwise, it returns FALSE.

	Also stores the intersection into rectC. If rectC is NULL, then it
	does not return the intersection.

	Either rectA or rectB can be specified as rectC.
*/
ZBool ZRectIntersection(ZRect *rectA, ZRect *rectB, ZRect *rectC)
{
	ZBool		intersects = FALSE;
	int16		left, right, top, bottom;
	
	
	left = MAX(rectA->left, rectB->left);
	right = MIN(rectA->right, rectB->right);
	if (right - left > 0)
	{
		top = MAX(rectA->top, rectB->top);
		bottom = MIN(rectA->bottom, rectB->bottom);
		if (bottom - top > 0)
		{
			intersects = TRUE;
			
			if (rectC != NULL)
			{
				rectC->left = left;
				rectC->right = right;
				rectC->top = top;
				rectC->bottom = bottom;
			}
		}
	}
	
	return (intersects);
}


/*
	ZRectUnion()
	
	Determines the union of rectA and rectB and stores into rectC.

	Either rectA or rectB can be specified as rectC.
*/
void ZRectUnion(ZRect *rectA, ZRect *rectB, ZRect *rectC)
{
	int16		left, right, top, bottom;
	
	
	left = MIN(rectA->left, rectB->left);
	right = MAX(rectA->right, rectB->right);
	top = MIN(rectA->top, rectB->top);
	bottom = MAX(rectA->bottom, rectB->bottom);
	if (rectC != NULL)
	{
		rectC->left = left;
		rectC->right = right;
		rectC->top = top;
		rectC->bottom = bottom;
	}
}


/*
	ZRectEmpty()
	
	Returns TRUE if rect is empty. A rectangle is empty if it does not contain a pixel
	inside it.
*/
ZBool ZRectEmpty(ZRect *rect)
{
	return (rect->right - rect->left <= 0 && rect->bottom - rect->top <= 0);
}


/*
	ZPointInRect()
	
	Returns TRUE if point is inside or on the boundry of rect. Otherwise, it returns
	FALSE.
*/
ZBool ZPointInRect(ZPoint *point, ZRect *rect)
{
	return (rect->left <= point->x && point->x < rect->right &&
			rect->top <= point->y && point->y < rect->bottom);
}


/*
	ZRectOffset()
	
	Moves the rectangle by dx and dy.
*/
void ZRectOffset(ZRect *rect, int16 dx, int16 dy)
{
	rect->left += dx;
	rect->right += dx;
	rect->top += dy;
	rect->bottom += dy;
}


/*
	ZRectInset()
	
	Insets the rectangle by dx and dy. It outsets the rectangle if
	dx and dy are negative.
*/
void ZRectInset(ZRect *rect, int16 dx, int16 dy)
{
	rect->left += dx;
	rect->right -= dx;
	rect->top += dy;
	rect->bottom -= dy;
}


/*
	ZCenterRectToRect()
	
	Centers rectA to rectB.
*/
void ZCenterRectToRect(ZRect* rectA, ZRect* rectB, uint16 flags)
{
	int16			width, height;
	
	
	width = ZRectWidth(rectA);
	height = ZRectHeight(rectA);
	
	if (flags == 0 || (flags & zCenterHorizontal))
	{
		rectA->left = (rectB->left + rectB->right + rectA->left - rectA->right) / 2;
		rectA->right = rectA->left + width;
	}
	
	if (flags == 0 || (flags & zCenterVertical))
	{
		rectA->top = (rectB->top + rectB->bottom + rectA->top - rectA->bottom) / 2;
		rectA->bottom = rectA->top + height;
	}
}


/*
	ZPointOffset()
	
	Moves the point by dx and dy.
*/
void ZPointOffset(ZPoint* point, int16 dx, int16 dy)
{
	point->x += dx;
	point->y += dy;
}


/*
	ZGetSystemColorTable()
	
	Returns a copy of the Zone(tm) system color table. It copies it instead
	of returning the pointer to it to protect the system color table.
*/
ZColorTable* ZGetSystemColorTable(void)
{
#define zNumSystemColors			256
	static ZColor		systemColors[zNumSystemColors] =
			{
#if 0
				{0x00, 0xFF, 0xFF, 0xFF}, {0x01, 0xFF, 0xFB, 0xF0}, {0x02, 0xFF, 0xFF, 0x99},
				{0x03, 0xFF, 0xFF, 0x66}, {0x04, 0xFF, 0xFF, 0x33}, {0x05, 0xFF, 0xFF, 0x00},
				{0x06, 0xFF, 0xCC, 0xFF}, {0x07, 0xFF, 0xCC, 0xCC}, {0x08, 0xFF, 0xCC, 0x99},
				{0x09, 0xFF, 0xCC, 0x66}, {0x0A, 0xFF, 0xCC, 0x33}, {0x0B, 0xFF, 0xCC, 0x00},
				{0x0C, 0xFF, 0x99, 0xFF}, {0x0D, 0xFF, 0x99, 0xCC}, {0x0E, 0xFF, 0x99, 0x99},
				{0x0F, 0xFF, 0x99, 0x66}, {0x10, 0xFF, 0x99, 0x33}, {0x11, 0xFF, 0x99, 0x00},
				{0x12, 0xFF, 0x66, 0xFF}, {0x13, 0xFF, 0x66, 0xCC}, {0x14, 0xFF, 0x66, 0x99},
				{0x15, 0xFF, 0x66, 0x66}, {0x16, 0xFF, 0x66, 0x33}, {0x17, 0xFF, 0x66, 0x00},
				{0x18, 0xFF, 0x33, 0xFF}, {0x19, 0xFF, 0x33, 0xCC}, {0x1A, 0xFF, 0x33, 0x99},
				{0x1B, 0xFF, 0x33, 0x66}, {0x1C, 0xFF, 0x33, 0x33}, {0x1D, 0xFF, 0x33, 0x00},
				{0x1E, 0xFF, 0x00, 0xFF}, {0x1F, 0xFF, 0x00, 0xCC}, {0x20, 0xFF, 0x00, 0x99},
				{0x21, 0xFF, 0x00, 0x66}, {0x22, 0xFF, 0x00, 0x33}, {0x23, 0xFF, 0x00, 0x00},
				{0x24, 0xCC, 0xFF, 0xFF}, {0x25, 0xC0, 0xDC, 0xC0}, {0x26, 0xCC, 0xFF, 0x99},
				{0x27, 0xCC, 0xFF, 0x66}, {0x28, 0xCC, 0xFF, 0x33}, {0x29, 0xCC, 0xFF, 0x00},
				{0x2A, 0xCC, 0xCC, 0xFF}, {0x2B, 0xC0, 0xC0, 0xC0}, {0x2C, 0xCC, 0xCC, 0x99},
				{0x2D, 0xCC, 0xCC, 0x66}, {0x2E, 0xCC, 0xCC, 0x33}, {0x2F, 0xCC, 0xCC, 0x00},
				{0x30, 0xCC, 0x99, 0xFF}, {0x31, 0xCC, 0x99, 0xCC}, {0x32, 0xCC, 0x99, 0x99},
				{0x33, 0xCC, 0x99, 0x66}, {0x34, 0xCC, 0x99, 0x33}, {0x35, 0xCC, 0x99, 0x00},
				{0x36, 0xCC, 0x66, 0xFF}, {0x37, 0xCC, 0x66, 0xCC}, {0x38, 0xCC, 0x66, 0x99},
				{0x39, 0xCC, 0x66, 0x66}, {0x3A, 0xCC, 0x66, 0x33}, {0x3B, 0xCC, 0x66, 0x00},
				{0x3C, 0xCC, 0x33, 0xFF}, {0x3D, 0xCC, 0x33, 0xCC}, {0x3E, 0xCC, 0x33, 0x99},
				{0x3F, 0xCC, 0x33, 0x66}, {0x40, 0xCC, 0x33, 0x33}, {0x41, 0xCC, 0x33, 0x00},
				{0x42, 0xCC, 0x00, 0xFF}, {0x43, 0xCC, 0x00, 0xCC}, {0x44, 0xCC, 0x00, 0x99},
				{0x45, 0xCC, 0x00, 0x66}, {0x46, 0xCC, 0x00, 0x33}, {0x47, 0xCC, 0x00, 0x00},
				{0x48, 0x99, 0xFF, 0xFF}, {0x49, 0x99, 0xFF, 0xCC}, {0x4A, 0x99, 0xFF, 0x99},
				{0x4B, 0x99, 0xFF, 0x66}, {0x4C, 0x99, 0xFF, 0x33}, {0x4D, 0x99, 0xFF, 0x00},
				{0x4E, 0xA6, 0xCA, 0xF0}, {0x4F, 0x99, 0xCC, 0xCC}, {0x50, 0x99, 0xCC, 0x99},
				{0x51, 0x99, 0xCC, 0x66}, {0x52, 0x99, 0xCC, 0x33}, {0x53, 0x99, 0xCC, 0x00},
				{0x54, 0x99, 0x99, 0xFF}, {0x55, 0x99, 0x99, 0xCC}, {0x56, 0x99, 0x99, 0x99},
				{0x57, 0x99, 0x99, 0x66}, {0x58, 0x99, 0x99, 0x33}, {0x59, 0x80, 0x80, 0x00},
				{0x5A, 0x99, 0x66, 0xFF}, {0x5B, 0x99, 0x66, 0xCC}, {0x5C, 0x99, 0x66, 0x99},
				{0x5D, 0x99, 0x66, 0x66}, {0x5E, 0x99, 0x66, 0x33}, {0x5F, 0x99, 0x66, 0x00},
				{0x60, 0x99, 0x33, 0xFF}, {0x61, 0x99, 0x33, 0xCC}, {0x62, 0x99, 0x33, 0x99},
				{0x63, 0x99, 0x33, 0x66}, {0x64, 0x99, 0x33, 0x33}, {0x65, 0x99, 0x33, 0x00},
				{0x66, 0x99, 0x00, 0xFF}, {0x67, 0x99, 0x00, 0xCC}, {0x68, 0x80, 0x00, 0x80},
				{0x69, 0x99, 0x00, 0x66}, {0x6A, 0x99, 0x00, 0x33}, {0x6B, 0x99, 0x00, 0x00},
				{0x6C, 0x66, 0xFF, 0xFF}, {0x6D, 0x66, 0xFF, 0xCC}, {0x6E, 0x66, 0xFF, 0x99},
				{0x6F, 0x66, 0xFF, 0x66}, {0x70, 0x66, 0xFF, 0x33}, {0x71, 0x66, 0xFF, 0x00},
				{0x72, 0x66, 0xCC, 0xFF}, {0x73, 0x66, 0xCC, 0xCC}, {0x74, 0x66, 0xCC, 0x99},
				{0x75, 0x66, 0xCC, 0x66}, {0x76, 0x66, 0xCC, 0x33}, {0x77, 0x66, 0xCC, 0x00},
				{0x78, 0x66, 0x99, 0xFF}, {0x79, 0x66, 0x99, 0xCC}, {0x7A, 0x66, 0x99, 0x99},
				{0x7B, 0x66, 0x99, 0x66}, {0x7C, 0x66, 0x99, 0x33}, {0x7D, 0x66, 0x99, 0x00},
				{0x7E, 0x66, 0x66, 0xFF}, {0x7F, 0x66, 0x66, 0xCC}, {0x80, 0x66, 0x66, 0x99},
				{0x81, 0x66, 0x66, 0x66}, {0x82, 0x66, 0x66, 0x33}, {0x83, 0x66, 0x66, 0x00},
				{0x84, 0x66, 0x33, 0xFF}, {0x85, 0x66, 0x33, 0xCC}, {0x86, 0x66, 0x33, 0x99},
				{0x87, 0x66, 0x33, 0x66}, {0x88, 0x66, 0x33, 0x33}, {0x89, 0x66, 0x33, 0x00},
				{0x8A, 0x66, 0x00, 0xFF}, {0x8B, 0x66, 0x00, 0xCC}, {0x8C, 0x66, 0x00, 0x99},
				{0x8D, 0x66, 0x00, 0x66}, {0x8E, 0x66, 0x00, 0x33}, {0x8F, 0x66, 0x00, 0x00},
				{0x90, 0x33, 0xFF, 0xFF}, {0x91, 0x33, 0xFF, 0xCC}, {0x92, 0x33, 0xFF, 0x99},
				{0x93, 0x33, 0xFF, 0x66}, {0x94, 0x33, 0xFF, 0x33}, {0x95, 0x33, 0xFF, 0x00},
				{0x96, 0x33, 0xCC, 0xFF}, {0x97, 0x33, 0xCC, 0xCC}, {0x98, 0x33, 0xCC, 0x99},
				{0x99, 0x33, 0xCC, 0x66}, {0x9A, 0x33, 0xCC, 0x33}, {0x9B, 0x33, 0xCC, 0x00},
				{0x9C, 0x33, 0x99, 0xFF}, {0x9D, 0x33, 0x99, 0xCC}, {0x9E, 0x33, 0x99, 0x99},
				{0x9F, 0x33, 0x99, 0x66}, {0xA0, 0x33, 0x99, 0x33}, {0xA1, 0x33, 0x99, 0x00},
				{0xA2, 0x33, 0x66, 0xFF}, {0xA3, 0x33, 0x66, 0xCC}, {0xA4, 0x33, 0x66, 0x99},
				{0xA5, 0x33, 0x66, 0x66}, {0xA6, 0x33, 0x66, 0x33}, {0xA7, 0x33, 0x66, 0x00},
				{0xA8, 0x33, 0x33, 0xFF}, {0xA9, 0x33, 0x33, 0xCC}, {0xAA, 0x33, 0x33, 0x99},
				{0xAB, 0x33, 0x33, 0x66}, {0xAC, 0x33, 0x33, 0x33}, {0xAD, 0x33, 0x33, 0x00},
				{0xAE, 0x33, 0x00, 0xFF}, {0xAF, 0x33, 0x00, 0xCC}, {0xB0, 0x33, 0x00, 0x99},
				{0xB1, 0x33, 0x00, 0x66}, {0xB2, 0x33, 0x00, 0x33}, {0xB3, 0x33, 0x00, 0x00},
				{0xB4, 0x00, 0xFF, 0xFF}, {0xB5, 0x00, 0xFF, 0xCC}, {0xB6, 0x00, 0xFF, 0x99},
				{0xB7, 0x00, 0xFF, 0x66}, {0xB8, 0x00, 0xFF, 0x33}, {0xB9, 0x00, 0xFF, 0x00},
				{0xBA, 0x00, 0xCC, 0xFF}, {0xBB, 0x00, 0xCC, 0xCC}, {0xBC, 0x00, 0xCC, 0x99},
				{0xBD, 0x00, 0xCC, 0x66}, {0xBE, 0x00, 0xCC, 0x33}, {0xBF, 0x00, 0xCC, 0x00},
				{0xC0, 0x00, 0x99, 0xFF}, {0xC1, 0x00, 0x99, 0xCC}, {0xC2, 0x00, 0x80, 0x80},
				{0xC3, 0x00, 0x99, 0x66}, {0xC4, 0x00, 0x99, 0x33}, {0xC5, 0x00, 0x99, 0x00},
				{0xC6, 0x00, 0x66, 0xFF}, {0xC7, 0x00, 0x66, 0xCC}, {0xC8, 0x00, 0x66, 0x99},
				{0xC9, 0x00, 0x66, 0x66}, {0xCA, 0x00, 0x66, 0x33}, {0xCB, 0x00, 0x66, 0x00},
				{0xCC, 0x00, 0x33, 0xFF}, {0xCD, 0x00, 0x33, 0xCC}, {0xCE, 0x00, 0x33, 0x99},
				{0xCF, 0x00, 0x33, 0x66}, {0xD0, 0x00, 0x33, 0x33}, {0xD1, 0x00, 0x33, 0x00},
				{0xD2, 0x00, 0x00, 0xFF}, {0xD3, 0x00, 0x00, 0xCC}, {0xD4, 0x00, 0x00, 0x99},
				{0xD5, 0x00, 0x00, 0x66}, {0xD6, 0x00, 0x00, 0x33}, {0xD7, 0xEE, 0x00, 0x00},
				{0xD8, 0xDD, 0x00, 0x00}, {0xD9, 0xBB, 0x00, 0x00}, {0xDA, 0xAA, 0x00, 0x00},
				{0xDB, 0x80, 0x00, 0x00}, {0xDC, 0x77, 0x00, 0x00}, {0xDD, 0x55, 0x00, 0x00},
				{0xDE, 0x44, 0x00, 0x00}, {0xDF, 0x22, 0x00, 0x00}, {0xE0, 0x11, 0x00, 0x00},
				{0xE1, 0x00, 0xEE, 0x00}, {0xE2, 0x00, 0xDD, 0x00}, {0xE3, 0x00, 0xBB, 0x00},
				{0xE4, 0x00, 0xAA, 0x00}, {0xE5, 0x00, 0x80, 0x00}, {0xE6, 0x00, 0x77, 0x00},
				{0xE7, 0x00, 0x55, 0x00}, {0xE8, 0x00, 0x44, 0x00}, {0xE9, 0x00, 0x22, 0x00},
				{0xEA, 0x00, 0x11, 0x00}, {0xEB, 0x00, 0x00, 0xEE}, {0xEC, 0x00, 0x00, 0xDD},
				{0xED, 0x00, 0x00, 0xBB}, {0xEE, 0x00, 0x00, 0xAA}, {0xEF, 0x00, 0x00, 0x80},
				{0xF0, 0x00, 0x00, 0x77}, {0xF1, 0x00, 0x00, 0x55}, {0xF2, 0x00, 0x00, 0x44},
				{0xF3, 0x00, 0x00, 0x22}, {0xF4, 0x00, 0x00, 0x11}, {0xF5, 0xEE, 0xEE, 0xEE},
				{0xF6, 0xDD, 0xDD, 0xDD}, {0xF7, 0xBB, 0xBB, 0xBB}, {0xF8, 0xA0, 0xA0, 0xA4},
				{0xF9, 0x80, 0x80, 0x80}, {0xFA, 0x77, 0x77, 0x77}, {0xFB, 0x55, 0x55, 0x55},
				{0xFC, 0x44, 0x44, 0x44}, {0xFD, 0x22, 0x22, 0x22}, {0xFE, 0x11, 0x11, 0x11},
				{0xFF, 0x00, 0x00, 0x00}
#else
				{0x00, 0x00, 0x00, 0x00}, {0x01, 0x80, 0x00, 0x00}, {0x02, 0x00, 0x80, 0x00}, {0x03, 0x80, 0x80, 0x00},
				{0x04, 0x00, 0x00, 0x80}, {0x05, 0x80, 0x00, 0x80}, {0x06, 0x00, 0x80, 0x80}, {0x07, 0xC0, 0xC0, 0xC0},
				{0x08, 0xC0, 0xDC, 0xC0}, {0x09, 0xA6, 0xCA, 0xF0}, {0x0A, 0x04, 0x04, 0x04}, {0x0B, 0x08, 0x08, 0x08},
				{0x0C, 0x0C, 0x0C, 0x0C}, {0x0D, 0x11, 0x11, 0x11}, {0x0E, 0x16, 0x16, 0x16}, {0x0F, 0x1C, 0x1C, 0x1C},
				{0x10, 0x22, 0x22, 0x22}, {0x11, 0x29, 0x29, 0x29}, {0x12, 0x55, 0x55, 0x55}, {0x13, 0x4D, 0x4D, 0x4D},
				{0x14, 0x42, 0x42, 0x42}, {0x15, 0x39, 0x39, 0x39}, {0x16, 0xFF, 0x7C, 0x80}, {0x17, 0xFF, 0x50, 0x50},
				{0x18, 0xD6, 0x00, 0x93}, {0x19, 0xCC, 0xEC, 0xFF}, {0x1A, 0xEF, 0xD6, 0xC6}, {0x1B, 0xE7, 0xE7, 0xD6},
				{0x1C, 0xAD, 0xA9, 0x90}, {0x1D, 0x33, 0x00, 0x00}, {0x1E, 0x66, 0x00, 0x00}, {0x1F, 0x99, 0x00, 0x00},
				{0x20, 0xCC, 0x00, 0x00}, {0x21, 0x00, 0x33, 0x00}, {0x22, 0x33, 0x33, 0x00}, {0x23, 0x66, 0x33, 0x00},
				{0x24, 0x99, 0x33, 0x00}, {0x25, 0xCC, 0x33, 0x00}, {0x26, 0xFF, 0x33, 0x00}, {0x27, 0x00, 0x66, 0x00},
				{0x28, 0x33, 0x66, 0x00}, {0x29, 0x66, 0x66, 0x00}, {0x2A, 0x99, 0x66, 0x00}, {0x2B, 0xCC, 0x66, 0x00},
				{0x2C, 0xFF, 0x66, 0x00}, {0x2D, 0x00, 0x99, 0x00}, {0x2E, 0x33, 0x99, 0x00}, {0x2F, 0x66, 0x99, 0x00},
				{0x30, 0x99, 0x99, 0x00}, {0x31, 0xCC, 0x99, 0x00}, {0x32, 0xFF, 0x99, 0x00}, {0x33, 0x00, 0xCC, 0x00},
				{0x34, 0x33, 0xCC, 0x00}, {0x35, 0x66, 0xCC, 0x00}, {0x36, 0x99, 0xCC, 0x00}, {0x37, 0xCC, 0xCC, 0x00},
				{0x38, 0xFF, 0xCC, 0x00}, {0x39, 0x66, 0xFF, 0x00}, {0x3A, 0x99, 0xFF, 0x00}, {0x3B, 0xCC, 0xFF, 0x00},
				{0x3C, 0x00, 0x00, 0x33}, {0x3D, 0x33, 0x00, 0x33}, {0x3E, 0x66, 0x00, 0x33}, {0x3F, 0x99, 0x00, 0x33},
				{0x40, 0xCC, 0x00, 0x33}, {0x41, 0xFF, 0x00, 0x33}, {0x42, 0x00, 0x33, 0x33}, {0x43, 0x33, 0x33, 0x33},
				{0x44, 0x66, 0x33, 0x33}, {0x45, 0x99, 0x33, 0x33}, {0x46, 0xCC, 0x33, 0x33}, {0x47, 0xFF, 0x33, 0x33},
				{0x48, 0x00, 0x66, 0x33}, {0x49, 0x33, 0x66, 0x33}, {0x4A, 0x66, 0x66, 0x33}, {0x4B, 0x99, 0x66, 0x33},
				{0x4C, 0xCC, 0x66, 0x33}, {0x4D, 0xFF, 0x66, 0x33}, {0x4E, 0x00, 0x99, 0x33}, {0x4F, 0x33, 0x99, 0x33},
				{0x50, 0x66, 0x99, 0x33}, {0x51, 0x99, 0x99, 0x33}, {0x52, 0xCC, 0x99, 0x33}, {0x53, 0xFF, 0x99, 0x33},
				{0x54, 0x00, 0xCC, 0x33}, {0x55, 0x33, 0xCC, 0x33}, {0x56, 0x66, 0xCC, 0x33}, {0x57, 0x99, 0xCC, 0x33},
				{0x58, 0xCC, 0xCC, 0x33}, {0x59, 0xFF, 0xCC, 0x33}, {0x5A, 0x33, 0xFF, 0x33}, {0x5B, 0x66, 0xFF, 0x33},
				{0x5C, 0x99, 0xFF, 0x33}, {0x5D, 0xCC, 0xFF, 0x33}, {0x5E, 0xFF, 0xFF, 0x33}, {0x5F, 0x00, 0x00, 0x66},
				{0x60, 0x33, 0x00, 0x66}, {0x61, 0x66, 0x00, 0x66}, {0x62, 0x99, 0x00, 0x66}, {0x63, 0xCC, 0x00, 0x66},
				{0x64, 0xFF, 0x00, 0x66}, {0x65, 0x00, 0x33, 0x66}, {0x66, 0x33, 0x33, 0x66}, {0x67, 0x66, 0x33, 0x66},
				{0x68, 0x99, 0x33, 0x66}, {0x69, 0xCC, 0x33, 0x66}, {0x6A, 0xFF, 0x33, 0x66}, {0x6B, 0x00, 0x66, 0x66},
				{0x6C, 0x33, 0x66, 0x66}, {0x6D, 0x66, 0x66, 0x66}, {0x6E, 0x99, 0x66, 0x66}, {0x6F, 0xCC, 0x66, 0x66},
				{0x70, 0x00, 0x99, 0x66}, {0x71, 0x33, 0x99, 0x66}, {0x72, 0x66, 0x99, 0x66}, {0x73, 0x99, 0x99, 0x66},
				{0x74, 0xCC, 0x99, 0x66}, {0x75, 0xFF, 0x99, 0x66}, {0x76, 0x00, 0xCC, 0x66}, {0x77, 0x33, 0xCC, 0x66},
				{0x78, 0x99, 0xCC, 0x66}, {0x79, 0xCC, 0xCC, 0x66}, {0x7A, 0xFF, 0xCC, 0x66}, {0x7B, 0x00, 0xFF, 0x66},
				{0x7C, 0x33, 0xFF, 0x66}, {0x7D, 0x99, 0xFF, 0x66}, {0x7E, 0xCC, 0xFF, 0x66}, {0x7F, 0xFF, 0x00, 0xCC},
				{0x80, 0xCC, 0x00, 0xFF}, {0x81, 0x00, 0x99, 0x99}, {0x82, 0x99, 0x33, 0x99}, {0x83, 0x99, 0x00, 0x99},
				{0x84, 0xCC, 0x00, 0x99}, {0x85, 0x00, 0x00, 0x99}, {0x86, 0x33, 0x33, 0x99}, {0x87, 0x66, 0x00, 0x99},
				{0x88, 0xCC, 0x33, 0x99}, {0x89, 0xFF, 0x00, 0x99}, {0x8A, 0x00, 0x66, 0x99}, {0x8B, 0x33, 0x66, 0x99},
				{0x8C, 0x66, 0x33, 0x99}, {0x8D, 0x99, 0x66, 0x99}, {0x8E, 0xCC, 0x66, 0x99}, {0x8F, 0xFF, 0x33, 0x99},
				{0x90, 0x33, 0x99, 0x99}, {0x91, 0x66, 0x99, 0x99}, {0x92, 0x99, 0x99, 0x99}, {0x93, 0xCC, 0x99, 0x99},
				{0x94, 0xFF, 0x99, 0x99}, {0x95, 0x00, 0xCC, 0x99}, {0x96, 0x33, 0xCC, 0x99}, {0x97, 0x66, 0xCC, 0x66},
				{0x98, 0x99, 0xCC, 0x99}, {0x99, 0xCC, 0xCC, 0x99}, {0x9A, 0xFF, 0xCC, 0x99}, {0x9B, 0x00, 0xFF, 0x99},
				{0x9C, 0x33, 0xFF, 0x99}, {0x9D, 0x66, 0xCC, 0x99}, {0x9E, 0x99, 0xFF, 0x99}, {0x9F, 0xCC, 0xFF, 0x99},
				{0xA0, 0xFF, 0xFF, 0x99}, {0xA1, 0x00, 0x00, 0xCC}, {0xA2, 0x33, 0x00, 0x99}, {0xA3, 0x66, 0x00, 0xCC},
				{0xA4, 0x99, 0x00, 0xCC}, {0xA5, 0xCC, 0x00, 0xCC}, {0xA6, 0x00, 0x33, 0x99}, {0xA7, 0x33, 0x33, 0xCC},
				{0xA8, 0x66, 0x33, 0xCC}, {0xA9, 0x99, 0x33, 0xCC}, {0xAA, 0xCC, 0x33, 0xCC}, {0xAB, 0xFF, 0x33, 0xCC},
				{0xAC, 0x00, 0x66, 0xCC}, {0xAD, 0x33, 0x66, 0xCC}, {0xAE, 0x66, 0x66, 0x99}, {0xAF, 0x99, 0x66, 0xCC},
				{0xB0, 0xCC, 0x66, 0xCC}, {0xB1, 0xFF, 0x66, 0x99}, {0xB2, 0x00, 0x99, 0xCC}, {0xB3, 0x33, 0x99, 0xCC},
				{0xB4, 0x66, 0x99, 0xCC}, {0xB5, 0x99, 0x99, 0xCC}, {0xB6, 0xCC, 0x99, 0xCC}, {0xB7, 0xFF, 0x99, 0xCC},
				{0xB8, 0x00, 0xCC, 0xCC}, {0xB9, 0x33, 0xCC, 0xCC}, {0xBA, 0x66, 0xCC, 0xCC}, {0xBB, 0x99, 0xCC, 0xCC},
				{0xBC, 0xCC, 0xCC, 0xCC}, {0xBD, 0xFF, 0xCC, 0xCC}, {0xBE, 0x00, 0xFF, 0xCC}, {0xBF, 0x33, 0xFF, 0xCC},
				{0xC0, 0x66, 0xFF, 0x99}, {0xC1, 0x99, 0xFF, 0xCC}, {0xC2, 0xCC, 0xFF, 0xCC}, {0xC3, 0xFF, 0xFF, 0xCC},
				{0xC4, 0x33, 0x00, 0xCC}, {0xC5, 0x66, 0x00, 0xFF}, {0xC6, 0x99, 0x00, 0xFF}, {0xC7, 0x00, 0x33, 0xCC},
				{0xC8, 0x33, 0x33, 0xFF}, {0xC9, 0x66, 0x33, 0xFF}, {0xCA, 0x99, 0x33, 0xFF}, {0xCB, 0xCC, 0x33, 0xFF},
				{0xCC, 0xFF, 0x33, 0xFF}, {0xCD, 0x00, 0x66, 0xFF}, {0xCE, 0x33, 0x66, 0xFF}, {0xCF, 0x66, 0x66, 0xCC},
				{0xD0, 0x99, 0x66, 0xFF}, {0xD1, 0xCC, 0x66, 0xFF}, {0xD2, 0xFF, 0x66, 0xCC}, {0xD3, 0x00, 0x99, 0xFF},
				{0xD4, 0x33, 0x99, 0xFF}, {0xD5, 0x66, 0x99, 0xFF}, {0xD6, 0x99, 0x99, 0xFF}, {0xD7, 0xCC, 0x99, 0xFF},
				{0xD8, 0xFF, 0x99, 0xFF}, {0xD9, 0x00, 0xCC, 0xFF}, {0xDA, 0x33, 0xCC, 0xFF}, {0xDB, 0x66, 0xCC, 0xFF},
				{0xDC, 0x99, 0xCC, 0xFF}, {0xDD, 0xCC, 0xCC, 0xFF}, {0xDE, 0xFF, 0xCC, 0xFF}, {0xDF, 0x33, 0xFF, 0xFF},
				{0xE0, 0x66, 0xFF, 0xCC}, {0xE1, 0x99, 0xFF, 0xFF}, {0xE2, 0xCC, 0xFF, 0xFF}, {0xE3, 0xFF, 0x66, 0x66},
				{0xE4, 0x66, 0xFF, 0x66}, {0xE5, 0xFF, 0xFF, 0x66}, {0xE6, 0x66, 0x66, 0xFF}, {0xE7, 0xFF, 0x66, 0xFF},
				{0xE8, 0x66, 0xFF, 0xFF}, {0xE9, 0xA5, 0x00, 0x21}, {0xEA, 0x5F, 0x5F, 0x5F}, {0xEB, 0x77, 0x77, 0x77},
				{0xEC, 0x86, 0x86, 0x86}, {0xED, 0x96, 0x96, 0x96}, {0xEE, 0xCB, 0xCB, 0xCB}, {0xEF, 0xB2, 0xB2, 0xB2},
				{0xF0, 0xD7, 0xD7, 0xD7}, {0xF1, 0xDD, 0xDD, 0xDD}, {0xF2, 0xE3, 0xE3, 0xE3}, {0xF3, 0xEA, 0xEA, 0xEA},
				{0xF4, 0xF1, 0xF1, 0xF1}, {0xF5, 0xF8, 0xF8, 0xF8}, {0xF6, 0xFF, 0xFB, 0xF0}, {0xF7, 0xA0, 0xA0, 0xA4},
				{0xF8, 0x80, 0x80, 0x80}, {0xF9, 0xFF, 0x00, 0x00}, {0xFA, 0x00, 0xFF, 0x00}, {0xFB, 0xFF, 0xFF, 0x00},
				{0xFC, 0x00, 0x00, 0xFF}, {0xFD, 0xFF, 0x00, 0xFF}, {0xFE, 0x00, 0xFF, 0xFF}, {0xFF, 0xFF, 0xFF, 0xFF}
#endif
			}; 
	ZColorTable*		colors;
	
	
	colors = (ZColorTable*) ZMalloc(sizeof(ZColorTable) + sizeof(ZColor) * (zNumSystemColors - 1));
	if (colors != NULL)
	{
		colors->numColors = zNumSystemColors;
		memcpy((BYTE*) colors->colors, (BYTE*) systemColors, sizeof(systemColors));
	}
	
	return (colors);
}


TCHAR* ZGetProgramDataFileName(TCHAR* dataFileName)
{
#ifdef ZONECLI_DLL
	ClientDllGlobals	pGlobals = (ClientDllGlobals) ZGetClientGlobalPointer();
#endif

	
	return (ZGenerateDataFileName(NULL, dataFileName));
}


TCHAR* ZGetCommonDataFileName(TCHAR* dataFileName)
{
	return (ZGenerateDataFileName(NULL, dataFileName));
}


void ZParseVillageCommandLine(TCHAR* commandLine, TCHAR* programName,
		TCHAR* serverAddr, uint16* serverPort)
{
    ZASSERT( !"Implement me!" );
    /*
	char*				cmdLine;
    char*               token;
#if ZONE_INI
    char                pszIni[] = "c:\\program files\\zone\\zone.ini";
#endif

	if (commandLine != NULL)
	{
		cmdLine = (char*) ZMalloc(lstrlen(commandLine) + 1);
		lstrcpy(cmdLine, (char*) commandLine);

        // Get the program name. 
        token = strtok(cmdLine, "|");
        ZASSERT(token);
        lstrcpy(programName, token);

#if ZONE_INI
        // get defaults from ini file 
        GetPrivateProfileString( programName, "ServerName", "", serverAddr, 128, pszIni );
        *serverPort = (uint16) GetPrivateProfileInt( programName, "ServerPort", 0xFFFF, pszIni );
#else
        serverAddr[0] = '\0';
        *serverPort = 0;
#endif

        // parse any command line parameters 
        token = strtok(NULL, "|");
        if ( token )
            sscanf(token, "%s %hu", serverAddr, serverPort);


		ZFree(cmdLine);
	}
    */
}


ZBool ZLaunchURL( TCHAR* pszURL )
{
    ZASSERT( !"Implement me!" );
    return FALSE;
    /*
	TCHAR buff[512], app[512], cmd[512], *p;
	DWORD result, bytes, type, i;
	BOOL quotes, hasPercent;
	HKEY hkey;

	// parameter paranoia
	if ( !pszURL || !lstrlen(pszURL) )
		return FALSE;

	// get file type
	result = RegOpenKeyEx( HKEY_CLASSES_ROOT, _T(".htm"), 0, KEY_READ, &hkey );
	if ( ERROR_SUCCESS != result )
	{
		result = RegOpenKeyEx( HKEY_CLASSES_ROOT, _T(".html"), 0, KEY_READ, &hkey );
		if ( ERROR_SUCCESS != result )
			return FALSE;
	}
	type = REG_SZ;
	bytes = sizeof(buff);
	result = RegQueryValueEx( hkey, NULL, 0, &type, (BYTE*) buff, &bytes );
	RegCloseKey( hkey );
	if ( ERROR_SUCCESS != result )
		return FALSE;

	// get open command
    // PCWTODO: Does this need to be localized?
	lstrcat( buff, _T("\\shell\\open\\command") );
	result = RegOpenKeyEx( HKEY_CLASSES_ROOT, buff, 0, KEY_READ, &hkey );
	if ( ERROR_SUCCESS != result )
		return FALSE;	
	type = REG_SZ;
	bytes = sizeof(buff);
	result = RegQueryValueEx( hkey, NULL, 0, &type, (BYTE*) buff, &bytes );
	RegCloseKey( hkey );
	if ( ERROR_SUCCESS != result )
		return FALSE;

	// parse application path
	for ( quotes = FALSE, p = app, i = 0; i < bytes; i++ )
	{
		if ( buff[i] == _T('\"') )
		{
			quotes = !quotes;
			continue;
		}
		else if ( buff[i] == _T(' ') )
		{
			if ( !quotes )
				break;
		}
		*p++ = buff[i];
	}
	*p = '\0';

	// parse command line, i.e. what's leftover
	if ( i < bytes )
	{
		lstrcpy( cmd, &buff[ i + 1 ] );
		lstrcat( cmd, " " );
	}
	else
		cmd[0] = '\0';

	// get rid of %1 if it exists
	// move to percent sign in string
	for(i=0;cmd[i]!=0;i++)
	{
		if(cmd[i]=='%')
		{
			cmd[i]=0;
			lstrcat( cmd, " " );
			break;
		}
	}

	
	lstrcat( cmd, pszURL );

	// run the browser
	if ( (int) ShellExecute( NULL, NULL, app, cmd, NULL, SW_SHOW )  <= 32 )
		return FALSE;
	else
		return TRUE;
    */
}

/*******************************************************************************
	INTERNAL ROUTINES
*******************************************************************************/
