//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once
#include <d3dm.h>
#include "PrimRast.h"
#include "TestCases.h"

//
// Test Case Parameters
//
typedef struct _PRIM_RAST_TESTS {
	RENDER_FUNC       RenderFunc;
	D3DMPRIMITIVETYPE PrimType;
	D3DMSHADEMODE     ShadeMode;
	D3DMFILLMODE      FillMode;
	DRAW_RANGE        DrawRange;
	COLOR_WRITE_MASK  ColorWriteMask;
	D3DMFORMAT        Format;
} PRIM_RAST_TESTS, *LPPRIM_RAST_TESTS;

__declspec(selectany) PRIM_RAST_TESTS PrimRastCases[D3DMQA_PRIMRASTTEST_COUNT] = {
//
// |       RENDER_FUNC        |  D3DMPRIMITIVETYPE  |   D3DMSHADEMODE    |   D3DMFILLMODE    |  DRAW_RANGE    | COLOR_WRITE_MASK |       D3DMFORMAT       |
// |                          |                     |                    |                   |                |                  |                        |
// |                          |                     |                    |                   |  Low  |  High  |                  |                        |
// +--------------------------+---------------------+--------------------+-------------------+-------+--------+------------------+------------------------+
{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
//{         D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},


{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
//{  D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

//
// Fixed-point primitive rasterization
//
{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},

{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},

};
