//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once

//
// Structure to conveniently pass around information about
// generated geometry
//
typedef struct _GEOMETRY_DESC {
	UINT uiPrimCount;
	UINT uiVertCount;
	LPDIRECT3DMOBILEVERTEXBUFFER *ppVB;
} GEOMETRY_DESC;

//
// Generated geometry algorithms provide primitives in a
// couple different orientations, for more thorough testing
//
typedef enum _PRIM_DIRECTION {
	PRIM_DIR1 = 1,
	PRIM_DIR2
} PRIM_DIRECTION;

//
// Indicates which frustum plane should be violated by the
// generated geometry (e.g., TRANSLATE_TO_NEGX implies
// left frustum plane)
//
typedef enum _TRANSLATE_DIR {
	TRANSLATE_TO_NEGX = 1,
	TRANSLATE_TO_POSX,
	TRANSLATE_TO_POSY,
	TRANSLATE_TO_NEGY,
	TRANSLATE_TO_NEGZ,
	TRANSLATE_TO_POSZ
} TRANSLATE_DIR;


#define FILL_SOLID    0x00000001
#define FILL_LINE     0x00000002
#define FILL_POINT    0x00000004
#define SHADE_GOURAUD 0x00000008
#define SHADE_FLAT    0x00000010
#define FVF_DIFFUSE   0x00000020
#define FVF_SPECULAR  0x00000040
#define PLANE_LEFT    0x00000080
#define PLANE_RIGHT   0x00000100
#define PLANE_TOP     0x00000200
#define PLANE_BOTTOM  0x00000400
#define PLANE_NEAR    0x00000800
#define PLANE_FAR     0x00001000
#define PRIM_TRIANGLE 0x00002000
#define PRIM_LINE     0x00004000

//
// Permutations that are exposed through tux
//
static CONST DWORD dwClipTestPermutations[] = {
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  0
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  1
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  2
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  3
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  4
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, //  5
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, //  6
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, //  7
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, //  8
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, //  9
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 10
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 11
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 12
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 13
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 14
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 15
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 16
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 17
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 18
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 19
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 20
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 21
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 22
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 23
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 24
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 25
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 26
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 27
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 28
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 29
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 30
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 31
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 32
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 33
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 34
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , // 35
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 36
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 37
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 38
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 39
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 40
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , // 41
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 42
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 43
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 44
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 45
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 46
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , // 47
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 48
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 49
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 50
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 51
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 52
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, // 53
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 54
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 55
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 56
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 57
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 58
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, // 59
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 60
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 61
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 62
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 63
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 64
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, // 65
PRIM_TRIANGLE|PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 66
PRIM_TRIANGLE|PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 67
PRIM_TRIANGLE|PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 68
PRIM_TRIANGLE|PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 69
PRIM_TRIANGLE|PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 70
PRIM_TRIANGLE|PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, // 71
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 72
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 73
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 74
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 75
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 76
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_SOLID, // 77
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 78
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 79
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 80
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 81
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 82
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_SOLID, // 83
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 84
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 85
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 86
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 87
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 88
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_SOLID, // 89
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 90
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 91
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 92
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 93
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 94
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_SOLID, // 95
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 96
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 97
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 98
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , // 99
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , //100
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_LINE , //101
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //102
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //103
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //104
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //105
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //106
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_LINE , //107
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //108
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //109
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //110 
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //111 
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //112 
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_LINE , //113 
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //114 
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //115 
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //116 
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //117 
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //118 
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_LINE , //119 
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //120 
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //121 
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //122 
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //123 
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //124 
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_GOURAUD|FILL_POINT, //125 
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //126 
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //127 
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //128 
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //129 
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //130 
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_GOURAUD|FILL_POINT, //131 
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //132 
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //133 
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //134 
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //135 
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //136 
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |      0     |SHADE_FLAT   |FILL_POINT, //137 
PRIM_LINE    |PLANE_LEFT  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, //138
PRIM_LINE    |PLANE_RIGHT |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, //139
PRIM_LINE    |PLANE_TOP   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, //140
PRIM_LINE    |PLANE_BOTTOM|FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, //141
PRIM_LINE    |PLANE_NEAR  |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT, //142
PRIM_LINE    |PLANE_FAR   |FVF_DIFFUSE |FVF_SPECULAR|SHADE_FLAT   |FILL_POINT  //143
};
