//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once
#include <windows.h>
#include <d3dm.h>
#include "TestCases.h"

namespace AlphaTestNamespace
{
#define _M(_a) D3DM_MAKE_D3DMVALUE(_a)

#define countof(x) (sizeof(x) / sizeof(*x))

#define D3DMQA_TWTEXWIDTH 64
#define D3DMQA_TWTEXHEIGHT 64

    HRESULT CreateAndPrepareTexture(
        LPDIRECT3DMOBILEDEVICE   pDevice, 
        D3DMFORMAT               Format,
        D3DMCOLOR                Color,
        DWORD                    dwTableIndex, 
        LPDIRECT3DMOBILETEXTURE *ppTexture);

    HRESULT CreateAndPrepareVertexBuffer(
        LPDIRECT3DMOBILEDEVICE        pDevice, 
        HWND                          hWnd,
        DWORD                         dwTableIndex, 
        LPDIRECT3DMOBILEVERTEXBUFFER *ppVertexBuffer, 
        UINT                         *pVertexBufferStride);

    HRESULT SetupTextureStages(
        LPDIRECT3DMOBILEDEVICE pDevice, 
        DWORD                  dwTableIndex);

    HRESULT SetupRenderStates(
        LPDIRECT3DMOBILEDEVICE pDevice, 
        DWORD                  dwTableIndex);

    UINT GetPrimitiveCount(DWORD dwTableIndex);

#define FLOAT_DONTCARE 1.0f

    //////////////////////////////////////////////
    //
    // Geometry definitions
    //
    /////////////////////////////////////////////

#define D3DMQA_PRIMTYPE D3DMPT_TRIANGLESTRIP

    //    (1)        (2) 
    //     +--------+  +
    //     |       /  /|
    //     |      /  / |
    //     |     /  /  |
    //     |    /  /   |
    //     |   /  /    |
    //     |  /  /     |
    //     | /  /      | 
    //     |/  /       |
    //     +  +--------+
    //    (3)         (4)
    //

#define POSX1  0.0f
#define POSY1  0.0f
#define POSZ1  0.0f

#define POSX2  1.0f
#define POSY2  0.0f
#define POSZ2  0.0f

#define POSX3  0.0f
#define POSY3  1.0f
#define POSZ3  0.0f

#define POSX4  1.0f
#define POSY4  1.0f
#define POSZ4  0.0f

#include "TwoDTextures.h"

    enum TextureFill {
        tfGradient,
        tfSolid,
        tfBlocks
    };

    typedef struct _ALPHATEST_FRAMES {
        D3DMFORMAT          TextureFormat;
        D3DMCOLOR           FillColor;
        const TCHAR * const tszFrameDescription;
    } ALPHATEST_FRAMES;

    typedef struct _ALPHATEST_TESTS {
        DWORD       dwFVF;
        UINT        uiFVFSize;
        PBYTE       pVertexData;
        DWORD       uiNumVerts;
        TextureFill TexFill;
        DWORD       dwCmpFunc;
        DWORD       dwRefAlpha;
        DWORD       dwAlphaOp;
        DWORD       dwAlphaArg1;
        DWORD       dwAlphaArg2;
    } ALPHATEST_TESTS;

    __declspec(selectany) ALPHATEST_FRAMES AlphaTestFrames [D3DMQA_ALPHATESTTEST_FRAMECOUNT] = {
        // Non-alpha formats
        D3DMFMT_R5G6B5,   D3DMCOLOR_XRGB(255,255,255), _T("Format: R5G6B5;   Color: White"),
        D3DMFMT_X8R8G8B8, D3DMCOLOR_XRGB(255,255,255), _T("Format: X8R8G8B8; Color: White"),
        D3DMFMT_R8G8B8,   D3DMCOLOR_XRGB(255,255,255), _T("Format: R8G8B8;   Color: White"),
        // Alpha formats
        D3DMFMT_A1R5G5B5, D3DMCOLOR_XRGB(255,255,255), _T("Format: A1R5G5B5; Color: White"),
        D3DMFMT_A4R4G4B4, D3DMCOLOR_XRGB(255,255,255), _T("Format: A4R4G4B4; Color: White"),
        D3DMFMT_A8R3G3B2, D3DMCOLOR_XRGB(255,255,255), _T("Format: A8R3G3B2; Color: White"),
        D3DMFMT_A8R8G8B8, D3DMCOLOR_XRGB(255,255,255), _T("Format: A8R8G8B8; Color: White"),
    };


    __declspec(selectany) ALPHATEST_TESTS AlphaTestCases [D3DMQA_ALPHATESTTEST_COUNT] = {      
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,         0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,         1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,       126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,       127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,       128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,       254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_ALWAYS,       255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,          0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,          1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,        126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,        127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,        128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,        254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NEVER,        255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,           0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,           1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,         126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,         127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,         128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,         254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESS,         255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,          0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,          1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,        126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,        127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,        128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,        254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_EQUAL,        255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,      0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,      1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,    126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,    127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,    128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,    254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_LESSEQUAL,    255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,        0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,        1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,      126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,      127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,      128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,      254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATER,      255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,       0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,       1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,     126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,     127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,     128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,     254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_NOTEQUAL,     255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL,   0, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL,   1, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL, 126, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL, 127, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL, 128, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL, 254, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_FVF, sizeof(D3DMALPHATESTTEST_TWOD), (PBYTE)&AlphaTestTwoD, countof(AlphaTestTwoD),   tfBlocks, D3DMCMP_GREATEREQUAL, 255, D3DMTOP_SELECTARG1, D3DMTA_TEXTURE, D3DMTA_CURRENT, 
        
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,         0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,         1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,       126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,       127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,       128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,       254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_ALWAYS,       255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,          0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,          1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,        126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,        127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,        128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,        254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NEVER,        255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,           0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,           1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,         126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,         127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,         128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,         254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESS,         255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,          0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,          1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,        126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,        127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,        128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,        254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_EQUAL,        255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,      0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,      1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,    126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,    127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,    128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,    254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_LESSEQUAL,    255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,        0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,        1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,      126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,      127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,      128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,      254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATER,      255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,       0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,       1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,     126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,     127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,     128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,     254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_NOTEQUAL,     255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL,   0, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL,   1, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL, 126, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL, 127, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL, 128, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL, 254, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks),   tfSolid, D3DMCMP_GREATEREQUAL, 255, D3DMTOP_SELECTARG1, D3DMTA_DIFFUSE, D3DMTA_CURRENT,
        
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,         0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,         1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,       126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,       127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,       128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,       254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_ALWAYS,       255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,          0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,          1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,        126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,        127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,        128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,        254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NEVER,        255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,           0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,           1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,         126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,         127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,         128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,         254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESS,         255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,          0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,          1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,        126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,        127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,        128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,        254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_EQUAL,        255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,      0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,      1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,    126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,    127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,    128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,    254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_LESSEQUAL,    255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,        0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,        1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,      126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,      127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,      128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,      254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATER,      255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,       0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,       1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,     126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,     127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,     128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,     254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_NOTEQUAL,     255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL,   0, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL,   1, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL, 126, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL, 127, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL, 128, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL, 254, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
        D3DMFVFTEST_TWOD_COLOR_FVF, sizeof(D3DMALPHATESTTEST_TWOD_COLOR), (PBYTE)&AlphaTestTwoDAlphaDifBlocks, countof(AlphaTestTwoDAlphaDifBlocks), tfSolid, D3DMCMP_GREATEREQUAL, 255, D3DMTOP_MODULATE, D3DMTA_TEXTURE, D3DMTA_DIFFUSE, 
    };
};

