//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#ifndef __TUXSTUFF_H__
#define __TUXSTUFF_H__

#include "pppauth.h"
#include <cmdline.h>
#include <tux.h>

// Test function prototypes (TestProc's)
TESTPROCAPI RASAuthTest						(UINT, TPPARAM, LPFUNCTION_TABLE_ENTRY);

#define PPP_AUTH_BASE	0

// BASE is a unique value assigned to a given tester or component.  This value,
// when combined with each of the following test's unique IDs, allows every 
// test case within the entire team to be uniquely identified.

#define BASE 0x00010000

// Our function table that we pass to Tux
static FUNCTION_TABLE_ENTRY g_lpFTE[] = {
TEXT(   "RAS Authentication Tests"                                     ), 1,									0,					0, NULL,
TEXT(   "PPTP Tests (PAP)"                               ), 2,									0,					0, NULL,
TEXT(         "PPTP_PAP_PROHIBIT_PAP"                      ), 3,                  USE_PAP | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 1, RASAuthTest,
TEXT(         "PPTP_PAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_PAP | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 2, RASAuthTest,
TEXT(         "PPTP_PAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_PAP | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 3, RASAuthTest,
TEXT(         "PPTP_PAP_PROHIBIT_CHAP"                     ), 3,                  USE_PAP | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 4, RASAuthTest,
TEXT(         "PPTP_PAP_PROHIBIT_EAP"                      ), 3,                  USE_PAP | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 5, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_ENC_PW"                    ), 3,                  USE_PAP | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 6, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_PAP | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 7, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_PAP | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 8, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_PAP | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 9, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_PAP | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 10, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_PAP | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 11, RASAuthTest,
TEXT(         "PPTP_PAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_PAP | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 12, RASAuthTest,
TEXT(   "PPTP Tests (MSCHAP)"                            ), 2,									0,					0, NULL,
TEXT(         "PPTP_MSCHAP_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAP | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 101, RASAuthTest,
TEXT(         "PPTP_MSCHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAP | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 102, RASAuthTest,
TEXT(         "PPTP_MSCHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAP | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 103, RASAuthTest,
TEXT(         "PPTP_MSCHAP_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAP | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 104, RASAuthTest,
TEXT(         "PPTP_MSCHAP_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAP | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 105, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 106, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 107, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 108, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 109, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 110, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 111, RASAuthTest,
TEXT(         "PPTP_MSCHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAP | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 112, RASAuthTest,
TEXT(   "PPTP Tests (MSCHAPv2)"                               ), 2,									0,					0, NULL,
TEXT(         "PPTP_MSCHAPv2_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAPv2 | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 201, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAPv2 | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 202, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAPv2 | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 203, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAPv2 | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 204, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAPv2 | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 205, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 206, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 207, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 208, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 209, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 210, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 211, RASAuthTest,
TEXT(         "PPTP_MSCHAPv2_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAPv2 | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 212, RASAuthTest,
TEXT(   "PPTP Tests (EAP)"                               ), 2,									0,					0, NULL,
TEXT(         "PPTP_EAP_PROHIBIT_PAP"                      ), 3,                  USE_EAP | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 301, RASAuthTest,
TEXT(         "PPTP_EAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_EAP | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 302, RASAuthTest,
TEXT(         "PPTP_EAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_EAP | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 303, RASAuthTest,
TEXT(         "PPTP_EAP_PROHIBIT_CHAP"                     ), 3,                  USE_EAP | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 304, RASAuthTest,
TEXT(         "PPTP_EAP_PROHIBIT_EAP"                      ), 3,                  USE_EAP | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 305, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_ENC_PW"                    ), 3,                  USE_EAP | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 306, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_EAP | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 307, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_EAP | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 308, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_EAP | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 309, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_EAP | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 310, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_EAP | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 311, RASAuthTest,
TEXT(         "PPTP_EAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_EAP | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 312, RASAuthTest,
TEXT(   "PPTP Tests (MD5CHAP)"                               ), 2,									0,					0, NULL,
TEXT(         "PPTP_MD5CHAP_PROHIBIT_PAP"                      ), 3,                  USE_CHAP | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 401, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_CHAP | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 402, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_CHAP | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 403, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_PROHIBIT_CHAP"                     ), 3,                  USE_CHAP | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 404, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_PROHIBIT_EAP"                      ), 3,                  USE_CHAP | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 405, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 406, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 407, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 408, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 409, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 410, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 411, RASAuthTest,
TEXT(         "PPTP_MD5CHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_CHAP | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 412, RASAuthTest,
TEXT(   "PPTP Tests (NODCC)"                               ), 2,									0,					0, NULL,
TEXT(         "PPTP_NODCC_PROHIBIT_PAP"                      ), 3,                  USE_NODCC | USE_PPTP | PROHIBIT_PAP, PPP_AUTH_BASE+ 501, RASAuthTest,
TEXT(         "PPTP_NODCC_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_NODCC | USE_PPTP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 502, RASAuthTest,
TEXT(         "PPTP_NODCC_PROHIBIT_MSCHAP"                   ), 3,                  USE_NODCC | USE_PPTP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 503, RASAuthTest,
TEXT(         "PPTP_NODCC_PROHIBIT_CHAP"                     ), 3,                  USE_NODCC | USE_PPTP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 504, RASAuthTest,
TEXT(         "PPTP_NODCC_PROHIBIT_EAP"                      ), 3,                  USE_NODCC | USE_PPTP | PROHIBIT_EAP, PPP_AUTH_BASE+ 505, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_ENC_PW"                    ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 506, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 507, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_DATA_ENC"                  ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 508, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 509, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 510, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 511, RASAuthTest,
TEXT(         "PPTP_NODCC_REQUIRE_NO_FLAGS"                  ), 3,                  USE_NODCC | USE_PPTP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 512, RASAuthTest,
TEXT(   "L2TP Tests (PAP)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_PAP_PROHIBIT_PAP"                      ), 3,                  USE_PAP | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 601, RASAuthTest,
TEXT(         "L2TP_PAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_PAP | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 602, RASAuthTest,
TEXT(         "L2TP_PAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_PAP | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 603, RASAuthTest,
TEXT(         "L2TP_PAP_PROHIBIT_CHAP"                     ), 3,                  USE_PAP | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 604, RASAuthTest,
TEXT(         "L2TP_PAP_PROHIBIT_EAP"                      ), 3,                  USE_PAP | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 605, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_ENC_PW"                    ), 3,                  USE_PAP | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 606, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_PAP | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 607, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_PAP | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 608, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_PAP | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 609, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_PAP | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 610, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_PAP | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 611, RASAuthTest,
TEXT(         "L2TP_PAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_PAP | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 612, RASAuthTest,
TEXT(   "L2TP Tests (MSCHAP)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_MSCHAP_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAP | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 701, RASAuthTest,
TEXT(         "L2TP_MSCHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAP | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 702, RASAuthTest,
TEXT(         "L2TP_MSCHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAP | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 703, RASAuthTest,
TEXT(         "L2TP_MSCHAP_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAP | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 704, RASAuthTest,
TEXT(         "L2TP_MSCHAP_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAP | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 705, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 706, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 707, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 708, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 709, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 710, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 711, RASAuthTest,
TEXT(         "L2TP_MSCHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAP | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 712, RASAuthTest,
TEXT(   "L2TP Tests (MSCHAPv2)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_MSCHAPv2_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAPv2 | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 801, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAPv2 | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 802, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAPv2 | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 803, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAPv2 | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 804, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAPv2 | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 805, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 806, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 807, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 808, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 809, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 810, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 811, RASAuthTest,
TEXT(         "L2TP_MSCHAPv2_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAPv2 | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 812, RASAuthTest,
TEXT(   "L2TP Tests (EAP)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_EAP_PROHIBIT_PAP"                      ), 3,                  USE_EAP | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 901, RASAuthTest,
TEXT(         "L2TP_EAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_EAP | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 902, RASAuthTest,
TEXT(         "L2TP_EAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_EAP | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 903, RASAuthTest,
TEXT(         "L2TP_EAP_PROHIBIT_CHAP"                     ), 3,                  USE_EAP | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 904, RASAuthTest,
TEXT(         "L2TP_EAP_PROHIBIT_EAP"                      ), 3,                  USE_EAP | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 905, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_ENC_PW"                    ), 3,                  USE_EAP | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 906, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_EAP | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 907, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_EAP | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 908, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_EAP | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 909, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_EAP | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 910, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_EAP | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 911, RASAuthTest,
TEXT(         "L2TP_EAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_EAP | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 912, RASAuthTest,
TEXT(   "L2TP Tests (MD5CHAP)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_MD5CHAP_PROHIBIT_PAP"                      ), 3,                  USE_CHAP | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 1001, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_CHAP | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1002, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_CHAP | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1003, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_PROHIBIT_CHAP"                     ), 3,                  USE_CHAP | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1004, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_PROHIBIT_EAP"                      ), 3,                  USE_CHAP | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 1005, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1006, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1007, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1008, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1009, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1010, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1011, RASAuthTest,
TEXT(         "L2TP_MD5CHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_CHAP | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1012, RASAuthTest,
TEXT(   "L2TP Tests (NODCC)"                               ), 2,									0,					0, NULL,
TEXT(         "L2TP_NODCC_PROHIBIT_PAP"                      ), 3,                  USE_NODCC | USE_L2TP | PROHIBIT_PAP, PPP_AUTH_BASE+ 1101, RASAuthTest,
TEXT(         "L2TP_NODCC_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_NODCC | USE_L2TP | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1102, RASAuthTest,
TEXT(         "L2TP_NODCC_PROHIBIT_MSCHAP"                   ), 3,                  USE_NODCC | USE_L2TP | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1103, RASAuthTest,
TEXT(         "L2TP_NODCC_PROHIBIT_CHAP"                     ), 3,                  USE_NODCC | USE_L2TP | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1104, RASAuthTest,
TEXT(         "L2TP_NODCC_PROHIBIT_EAP"                      ), 3,                  USE_NODCC | USE_L2TP | PROHIBIT_EAP, PPP_AUTH_BASE+ 1105, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_ENC_PW"                    ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1106, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1107, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_DATA_ENC"                  ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1108, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1109, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1110, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1111, RASAuthTest,
TEXT(         "L2TP_NODCC_REQUIRE_NO_FLAGS"                  ), 3,                  USE_NODCC | USE_L2TP | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1112, RASAuthTest,
TEXT(   "DCC Tests (PAP)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_PAP_PROHIBIT_PAP"                      ), 3,                  USE_PAP | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1201, RASAuthTest,
TEXT(         "DCC_PAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_PAP | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1202, RASAuthTest,
TEXT(         "DCC_PAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_PAP | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1203, RASAuthTest,
TEXT(         "DCC_PAP_PROHIBIT_CHAP"                     ), 3,                  USE_PAP | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1204, RASAuthTest,
TEXT(         "DCC_PAP_PROHIBIT_EAP"                      ), 3,                  USE_PAP | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1205, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_ENC_PW"                    ), 3,                  USE_PAP | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1206, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_PAP | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1207, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_PAP | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1208, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_PAP | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1209, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_PAP | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1210, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_PAP | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1211, RASAuthTest,
TEXT(         "DCC_PAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_PAP | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1212, RASAuthTest,
TEXT(   "DCC Tests (MSCHAP)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_MSCHAP_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAP | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1301, RASAuthTest,
TEXT(         "DCC_MSCHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAP | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1302, RASAuthTest,
TEXT(         "DCC_MSCHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAP | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1303, RASAuthTest,
TEXT(         "DCC_MSCHAP_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAP | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1304, RASAuthTest,
TEXT(         "DCC_MSCHAP_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAP | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1305, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1306, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1307, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1308, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1309, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1310, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1311, RASAuthTest,
TEXT(         "DCC_MSCHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAP | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1312, RASAuthTest,
TEXT(   "DCC Tests (MSCHAPv2)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_MSCHAPv2_PROHIBIT_PAP"                      ), 3,                  USE_MSCHAPv2 | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1401, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_MSCHAPv2 | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1402, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_PROHIBIT_MSCHAP"                   ), 3,                  USE_MSCHAPv2 | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1403, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_PROHIBIT_CHAP"                     ), 3,                  USE_MSCHAPv2 | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1404, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_PROHIBIT_EAP"                      ), 3,                  USE_MSCHAPv2 | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1405, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_ENC_PW"                    ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1406, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1407, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_DATA_ENC"                  ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1408, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1409, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1410, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1411, RASAuthTest,
TEXT(         "DCC_MSCHAPv2_REQUIRE_NO_FLAGS"                  ), 3,                  USE_MSCHAPv2 | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1412, RASAuthTest,
TEXT(   "DCC Tests (EAP)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_EAP_PROHIBIT_PAP"                      ), 3,                  USE_EAP | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1501, RASAuthTest,
TEXT(         "DCC_EAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_EAP | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1502, RASAuthTest,
TEXT(         "DCC_EAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_EAP | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1503, RASAuthTest,
TEXT(         "DCC_EAP_PROHIBIT_CHAP"                     ), 3,                  USE_EAP | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1504, RASAuthTest,
TEXT(         "DCC_EAP_PROHIBIT_EAP"                      ), 3,                  USE_EAP | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1505, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_ENC_PW"                    ), 3,                  USE_EAP | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1506, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_EAP | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1507, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_EAP | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1508, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_EAP | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1509, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_EAP | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1510, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_EAP | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1511, RASAuthTest,
TEXT(         "DCC_EAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_EAP | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1512, RASAuthTest,
TEXT(   "DCC Tests (MD5CHAP)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_MD5CHAP_PROHIBIT_PAP"                      ), 3,                  USE_CHAP | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1601, RASAuthTest,
TEXT(         "DCC_MD5CHAP_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_CHAP | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1602, RASAuthTest,
TEXT(         "DCC_MD5CHAP_PROHIBIT_MSCHAP"                   ), 3,                  USE_CHAP | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1603, RASAuthTest,
TEXT(         "DCC_MD5CHAP_PROHIBIT_CHAP"                     ), 3,                  USE_CHAP | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1604, RASAuthTest,
TEXT(         "DCC_MD5CHAP_PROHIBIT_EAP"                      ), 3,                  USE_CHAP | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1605, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_ENC_PW"                    ), 3,                  USE_CHAP | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1606, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_CHAP | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1607, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_DATA_ENC"                  ), 3,                  USE_CHAP | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1608, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_CHAP | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1609, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_CHAP | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1610, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_CHAP | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1611, RASAuthTest,
TEXT(         "DCC_MD5CHAP_REQUIRE_NO_FLAGS"                  ), 3,                  USE_CHAP | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1612, RASAuthTest,
TEXT(   "DCC Tests (NODCC)"                               ), 2,									0,					0, NULL,
TEXT(         "DCC_NODCC_PROHIBIT_PAP"                      ), 3,                  USE_NODCC | USE_DCC | PROHIBIT_PAP, PPP_AUTH_BASE+ 1701, RASAuthTest,
TEXT(         "DCC_NODCC_PROHIBIT_MSCHAPV2"                 ), 3,                  USE_NODCC | USE_DCC | PROHIBIT_MSCHAPV2, PPP_AUTH_BASE+ 1702, RASAuthTest,
TEXT(         "DCC_NODCC_PROHIBIT_MSCHAP"                   ), 3,                  USE_NODCC | USE_DCC | PROHIBIT_MSCHAP, PPP_AUTH_BASE+ 1703, RASAuthTest,
TEXT(         "DCC_NODCC_PROHIBIT_CHAP"                     ), 3,                  USE_NODCC | USE_DCC | PROHIBIT_CHAP, PPP_AUTH_BASE+ 1704, RASAuthTest,
TEXT(         "DCC_NODCC_PROHIBIT_EAP"                      ), 3,                  USE_NODCC | USE_DCC | PROHIBIT_EAP, PPP_AUTH_BASE+ 1705, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_ENC_PW"                    ), 3,                  USE_NODCC | USE_DCC | REQUIRE_ENC_PW, PPP_AUTH_BASE+ 1706, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_MS_ENC_PW"                 ), 3,                  USE_NODCC | USE_DCC | REQUIRE_MS_ENC_PW, PPP_AUTH_BASE+ 1707, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_DATA_ENC"                  ), 3,                  USE_NODCC | USE_DCC | REQUIRE_DATA_ENC, PPP_AUTH_BASE+ 1708, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_ENC_MS_PW"                 ), 3,                  USE_NODCC | USE_DCC | REQUIRE_ENC_MS_PW, PPP_AUTH_BASE+ 1709, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_MS_DATA_ENC"               ), 3,                  USE_NODCC | USE_DCC | REQUIRE_MS_DATA_ENC, PPP_AUTH_BASE+ 1710, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_MS_DATA_ENC_PW"            ), 3,                  USE_NODCC | USE_DCC | REQUIRE_MS_DATA_ENC_PW, PPP_AUTH_BASE+ 1711, RASAuthTest,
TEXT(         "DCC_NODCC_REQUIRE_NO_FLAGS"                  ), 3,                  USE_NODCC | USE_DCC | REQUIRE_NO_FLAGS, PPP_AUTH_BASE+ 1712, RASAuthTest,
NULL,													   0,								 0,					 0, NULL  // marks end of list
};

#endif // __TUXSTUFF_H__
