//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#include "bencheng.h"
#include "otak.h"
#include "surface.h"
#include "stretchcoordinates.h"
#include "rgn.h"
#include "dispperfdata.h"

#ifndef ALHPABLEND_H
#define ALPHABLEND_H

typedef BOOL (WINAPI * PFNALPHABLEND)(HDC tdcDest, int nXOriginDest, int nYOriginDest, int nWidthDest, int nHeightDest, HDC tdcSrc, int nXOriginSrc, int nYOriginSrc, int nWidthSrc, int nHeightSrc, BLENDFUNCTION blendFunction);

class CAlphaBlendTestSuite : public CTestSuite
{
    public:
        CAlphaBlendTestSuite(CSection * Section) : CTestSuite(Section), m_pfnAlphaBlend(NULL),
                                            m_Dest(Section), m_Source(Section), m_StretchCoordinates(Section), m_Rgn(Section), m_DispPerfData(),
                                            m_hdcDest(NULL), m_hdcSource(NULL), m_tsBlendFunctionName(NULL),
                                            m_BlendFunction(NULL), m_nBlendFunctionIndex(0), m_nMaxBlendFunctionIndex(0)
                                            { g_pCOtakLog->Log(OTAK_VERBOSE, TEXT("In CAlphaBlendTestSuite overloaded constructor.")); }
         ~CAlphaBlendTestSuite() { g_pCOtakLog->Log(OTAK_VERBOSE, TEXT("In CAlphaBlendTestSuite destructor.")); }

        virtual BOOL Initialize(TestSuiteInfo *);
        virtual BOOL PreRun(TestInfo *);
        virtual BOOL Run();
        virtual BOOL AddPostRunData(TestInfo *);
        virtual BOOL PostRun();
        virtual BOOL Cleanup();

private:
        CAlphaBlendTestSuite() { g_pCOtakLog->Log(OTAK_VERBOSE, TEXT("In CAlphaBlendTestSuite base constructor.")); }

        HINSTANCE m_hinstCoreDLL;
        PFNALPHABLEND m_pfnAlphaBlend;

        int m_nIterationCount;
        class CSurface m_Dest;
        class CSurface m_Source;
        class CStretchCoordinates m_StretchCoordinates;
        class CRgn m_Rgn;
        class CDispPerfData m_DispPerfData;

        HDC m_hdcDest;
        HDC m_hdcSource;
        struct StretchCoordinates m_sCoordinateInUse;

        BLENDFUNCTION * m_BlendFunction;
        TSTRING * m_tsBlendFunctionName;
        int m_nBlendFunctionIndex, m_nMaxBlendFunctionIndex;

#ifndef UNDER_CE
        DWORD m_dwOldBatchLimit;
#endif

        BOOL InitializeBlendFunction(TestSuiteInfo *);
        BOOL InitializeFunctionPointer();

};
#endif
