//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#pragma once
#include <d3dm.h>
#include "PrimRast.h"
#include "TestCases.h"

//
// Test Case Parameters
//
typedef struct _PRIM_RAST_TESTS {
	RENDER_FUNC       RenderFunc;
	D3DMPRIMITIVETYPE PrimType;
	D3DMSHADEMODE     ShadeMode;
	D3DMFILLMODE      FillMode;
	DRAW_RANGE        DrawRange;
	COLOR_WRITE_MASK  ColorWriteMask;
	D3DMFORMAT        Format;
} PRIM_RAST_TESTS, *LPPRIM_RAST_TESTS;

__declspec(selectany) PRIM_RAST_TESTS PrimRastCases[D3DMQA_PRIMRASTTEST_COUNT] = {
//
// |       RENDER_FUNC        |  D3DMPRIMITIVETYPE  |   D3DMSHADEMODE    |   D3DMFILLMODE    |  DRAW_RANGE    | COLOR_WRITE_MASK |       D3DMFORMAT       |
// |                          |                     |                    |                   |                |                  |                        |
// |                          |                     |                    |                   |  Low  |  High  |                  |                        |
// +--------------------------+---------------------+--------------------+-------------------+-------+--------+------------------+------------------------+
{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
//{         D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},


{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.1f,   0.8f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
//{  D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XXB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGX, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RXB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_XGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_POINT,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT, D3DMFILL_WIREFRAME,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FLOAT},

//
// Fixed-point primitive rasterization
//
{           D3DM_DRAWPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{           D3DM_DRAWPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},

{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_POINTLIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,      D3DMPT_LINELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,     D3DMPT_LINESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,  D3DMPT_TRIANGLELIST,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE, D3DMPT_TRIANGLESTRIP,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},
{    D3DM_DRAWINDEXEDPRIMITIVE,   D3DMPT_TRIANGLEFAN,      D3DMSHADE_FLAT,     D3DMFILL_SOLID,  {0.0f,   1.0f},   COLOR_WRITE_RGB, D3DMFMT_D3DMVALUE_FIXED},

};
