//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#pragma once
#include <d3dm.h>


INT StencilFuncTest(LPDIRECT3DMOBILEDEVICE pDevice, HWND hWnd, UINT uiTestPermutation);
INT StencilPassTest(LPDIRECT3DMOBILEDEVICE pDevice, HWND hWnd, UINT uiTestPermutation);
INT StencilMaskTest(LPDIRECT3DMOBILEDEVICE pDevice, HWND hWnd, UINT uiTestPermutation);

//
// D3DMRS_STENCILFUNC Testing structures, tables, declarations, defines:
// 

typedef struct _STENCILFUNCTEST {
	D3DMFORMAT Format;
	DWORD StencilEnable;
	DWORD StencilMask;
	DWORD StencilWriteMask;
	D3DMSTENCILOP StencilZFail;
	D3DMSTENCILOP StencilFail;
	D3DMSTENCILOP StencilPass;
	D3DMCMPFUNC StencilFunc;
	DWORD StencilRef;
	DWORD InitialStencilValue;
	D3DMCOLOR ColorExpect;
} STENCILFUNCTEST;

static struct _STENCILFUNCCONSTS {
	static const D3DMCOLOR ColorFail = D3DMCOLOR_XRGB(255,0,0);
	static const D3DMCOLOR ColorPass = D3DMCOLOR_XRGB(0,255,0);
	static const D3DMCOLOR TestCaseCount = 72;
} STENCILFUNCCONSTS;

static const STENCILFUNCTEST StencilFuncTests[STENCILFUNCCONSTS.TestCaseCount] = {
//
// |   Format   |StencilEnable|StencilMask|StencilWriteMask|     StencilZFail     |     StencilFail      |     StencilPass      |     StencilFunc     | StencilRef |InitialStencilValue|ColorExpect|
// |(D3DMFORMAT)|   (DWORD)   |  (DWORD)  |    (DWORD)     |    (D3DMSTENCILOP)   |    (D3DMSTENCILOP)   |    (D3DMSTENCILOP)   |    (D3DMCMPFUNC)    |  (DWORD)   |    (DWORD)        |(D3DMCOLOR)|
// +------------+-------------+-----------+----------------+----------------------+----------------------+----------------------+---------------------+------------+-------------------+-----------+
//                    

//
// D3DMRS_STENCILFUNC tests (REF>STENCIL; REF==STENCIL; REF<STENCIL) for D3DMFMT_D15S1 (24 cases)
//
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorFail},
																																														 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorPass},
																																														 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorFail},
																																								 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorPass},
																																								 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorFail},
																																								 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorPass},
																																								 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorFail},
																																								 
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000000,           0x00000001, STENCILFUNCCONSTS.ColorPass},

//
// D3DMRS_STENCILFUNC tests (REF>STENCIL; REF==STENCIL; REF<STENCIL) for D3DMFMT_D24S8 (24 cases)
//
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																														
//
// D3DMRS_STENCILFUNC tests (REF>STENCIL; REF==STENCIL; REF<STENCIL) for D3DMFMT_D24X4S4 (24 cases)
//
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NEVER       ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESS        ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_EQUAL       ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_LESSEQUAL   ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_NOTEQUAL    ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATEREQUAL,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorFail},
																																																   
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000000, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000001, STENCILFUNCCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_ALWAYS      ,  0x00000001,           0x00000002, STENCILFUNCCONSTS.ColorPass},
};



//
// D3DMRS_STENCILPASS/D3DMRS_STENCILFAIL,  Testing structures, tables, declarations, defines:
// 

typedef struct _STENCILPASSTEST {
	D3DMFORMAT Format;
	DWORD StencilEnable;
	DWORD StencilMask;
	DWORD StencilWriteMask;
	D3DMSTENCILOP StencilZFail;
	D3DMSTENCILOP StencilFail;
	D3DMSTENCILOP StencilPass;
	D3DMCMPFUNC StencilFunc;
	DWORD StencilRef;
	DWORD InitialStencilValue;
	DWORD StencilValueExpect;
	D3DMCOLOR ColorExpect;
} STENCILPASSTEST;

static struct _STENCILPASSCONSTS {
	static const D3DMCOLOR ColorBack = D3DMCOLOR_XRGB(0,255,0);
	static const D3DMCOLOR ColorFront = D3DMCOLOR_XRGB(0,0,255);
	static const D3DMCOLOR TestCaseCount = 48;
} STENCILPASSCONSTS;

static const STENCILPASSTEST StencilPassTests[STENCILPASSCONSTS.TestCaseCount] = {
//
// |  Format    |StencilEnable|StencilMask|StencilWriteMask|     StencilZFail     |     StencilFail      |     StencilPass      |     StencilFunc     | StencilRef |InitialStencilValue|StencilValueExpect|ColorExpect|
// |(D3DMFORMAT)|   (DWORD)   |  (DWORD)  |    (DWORD)     |    (D3DMSTENCILOP)   |    (D3DMSTENCILOP)    |    (D3DMSTENCILOP)  |    (D3DMCMPFUNC)    |  (DWORD)   |    (DWORD)        |    (DWORD)       |(D3DMCOLOR)|
// +------------+-------------+-----------+----------------+----------------------+----------------------+----------------------+---------------------+------------+-------------------+------------------+-----------+
//                    

//
// D3DMRS_STENCILPASS Tests for D3DMFMT_D15S1 (8 cases)
//
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP   ,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_ZERO   ,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_REPLACE,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCRSAT,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECRSAT,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INVERT ,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCR   ,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECR   ,        D3DMCMP_GREATER,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},


//
// D3DMRS_STENCILPASS Tests for D3DMFMT_D24S8 (8 cases)
//
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP   ,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_ZERO   ,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_REPLACE,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCRSAT,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECRSAT,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INVERT ,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCR   ,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECR   ,        D3DMCMP_GREATER,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},


//
// D3DMRS_STENCILPASS Tests for D3DMFMT_D24X4S4 (8 cases)
//
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP   ,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_ZERO   ,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_REPLACE,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCRSAT,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECRSAT,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INVERT ,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_INCR   ,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_DECR   ,        D3DMCMP_GREATER,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront},


//
// D3DMRS_STENCILFAIL Tests for D3DMFMT_D15S1 (8 cases)
//
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_ZERO   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_REPLACE,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INVERT ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D15S1,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x00000001,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
																																										
																																										
//																																										
// D3DMRS_STENCILFAIL Tests for D3DMFMT_D24S8 (8 cases)																													
//																																										
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_ZERO   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_REPLACE,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INVERT ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24S8,        TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x000000FF,         0x00000000,        0x000000FF, STENCILPASSCONSTS.ColorFront},
																																						
																																						
//																																						
// D3DMRS_STENCILFAIL Tests for D3DMFMT_D24X4S4 (8 cases)																									
//																																						
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_ZERO   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_REPLACE,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECRSAT,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x00000000, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INVERT ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_INCR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x00000001, STENCILPASSCONSTS.ColorFront},
{  D3DMFMT_D24X4S4,      TRUE, 0xFFFFFFFF,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_DECR   ,D3DMSTENCILOP_KEEP,             D3DMCMP_LESS,  0x0000000F,         0x00000000,        0x0000000F, STENCILPASSCONSTS.ColorFront}
																																										
};


//
// D3DMRS_STENCILMASK Testing structures, tables, declarations, defines:
// 

typedef struct _STENCILMASKTEST {
	D3DMFORMAT Format;
	DWORD StencilEnable;
	DWORD StencilMask;
	DWORD StencilWriteMask;
	D3DMSTENCILOP StencilZFail;
	D3DMSTENCILOP StencilFail;
	D3DMSTENCILOP StencilPass;
	D3DMCMPFUNC StencilFunc;
	DWORD StencilRef;
	DWORD InitialStencilValue;
	D3DMCOLOR ColorExpect;
} STENCILMASKTEST;

static struct _STENCILMASKCONSTS {
	static const D3DMCOLOR ColorFail = D3DMCOLOR_XRGB(255,0,0);
	static const D3DMCOLOR ColorPass = D3DMCOLOR_XRGB(0,255,0);
	static const D3DMCOLOR TestCaseCount = 26;
} STENCILMASKCONSTS;

static const STENCILMASKTEST StencilMaskTests[STENCILMASKCONSTS.TestCaseCount] = {
//
// |   Format   |StencilEnable|StencilMask|StencilWriteMask|     StencilZFail     |     StencilFail      |     StencilPass      |     StencilFunc     | StencilRef |InitialStencilValue|ColorExpect|
// |(D3DMFORMAT)|   (DWORD)   |  (DWORD)  |    (DWORD)     |    (D3DMSTENCILOP)   |    (D3DMSTENCILOP)   |    (D3DMSTENCILOP)   |    (D3DMCMPFUNC)    |  (DWORD)   |    (DWORD)        |(D3DMCOLOR)|
// +------------+-------------+-----------+----------------+----------------------+----------------------+----------------------+---------------------+------------+-------------------+-----------+
//                    

//
// D3DMRS_STENCILMASK Tests (26 cases)
//

{  D3DMFMT_D15S1,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000000,           0x00000001, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0x00000001,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILMASKCONSTS.ColorPass},
{  D3DMFMT_D15S1,        TRUE, 0x00000001,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D15S1,        TRUE, 0x00000001,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000000,           0x00000001, STENCILMASKCONSTS.ColorFail},

{  D3DMFMT_D24S8,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000002,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000004,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000000, STENCILMASKCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000004, STENCILMASKCONSTS.ColorPass},
{  D3DMFMT_D24S8,        TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000008, STENCILMASKCONSTS.ColorPass},

{  D3DMFMT_D24X4S4,      TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000000, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000001, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000000,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000001,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000002,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000004,           0x00000002, STENCILMASKCONSTS.ColorFail},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000000, STENCILMASKCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000004, STENCILMASKCONSTS.ColorPass},
{  D3DMFMT_D24X4S4,      TRUE, 0x00000002,      0xFFFFFFFF,     D3DMSTENCILOP_KEEP,     D3DMSTENCILOP_KEEP,  D3DMSTENCILOP_KEEP,    D3DMCMP_GREATER     ,  0x00000003,           0x00000008, STENCILMASKCONSTS.ColorPass}
};

