/*
 * Adapted from The MIT License (MIT)
 *
 * Copyright (c) 2018-2020 DaPorkchop_
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 *
 * Any persons and/or organizations using this software must include the above copyright notice and this permission notice,
 * provide sufficient credit to the original authors of the project (IE: DaPorkchop_), as well as provide a link to the original project.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package net.daporkchop.lib.imaging.bitmap.impl;

import lombok.Getter;
import lombok.experimental.Accessors;
import net.daporkchop.lib.imaging.bitmap.PBitmap;
import net.daporkchop.lib.imaging.util.exception.BitmapCoordinatesOutOfBoundsException;

/**
 * Base implementation of {@link PBitmap}.
 *
 * @author DaPorkchop_
 */
@Getter
@Accessors(fluent = true)
public abstract class AbstractBitmap implements PBitmap {
    //together these fields make a long, so field alignment is all good
    protected final int width;
    protected final int height;

    public AbstractBitmap(int width, int height)    {
        if (width <= 0 || height <= 0)  {
            throw new IllegalArgumentException("width and height must be >0!");
        }

        this.width = width;
        this.height = height;
    }

    protected final void assertInBounds(int x, int y) throws BitmapCoordinatesOutOfBoundsException {
        if (x < 0 || x >= this.width || y < 0 || y >= this.width)   {
            throw new BitmapCoordinatesOutOfBoundsException(x, y);
        }
    }
}
