/*
 * Adapted from The MIT License (MIT)
 *
 * Copyright (c) 2018-2020 DaPorkchop_
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 *
 * Any persons and/or organizations using this software must include the above copyright notice and this permission notice,
 * provide sufficient credit to the original authors of the project (IE: DaPorkchop_), as well as provide a link to the original project.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package net.daporkchop.lib.common.ref.attachment;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

/**
 * @author DaPorkchop_
 */
@Getter
@Setter
@Accessors(fluent = true, chain = true)
public final class SoftAttachedRef<V, A> extends SoftReference<V> implements AttachedRef<V, A> {
    protected A attachment;

    public SoftAttachedRef(V referent) {
        super(referent);
    }

    public SoftAttachedRef(V referent, A attachment) {
        super(referent);

        this.attachment = attachment;
    }

    public SoftAttachedRef(V referent, ReferenceQueue<? super V> q) {
        super(referent, q);
    }

    public SoftAttachedRef(V referent, A attachment, ReferenceQueue<? super V> q) {
        super(referent, q);

        this.attachment = attachment;
    }
}
