/*
 * Adapted from The MIT License (MIT)
 *
 * Copyright (c) 2018-2020 DaPorkchop_
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
 * is furnished to do so, subject to the following conditions:
 *
 * Any persons and/or organizations using this software must include the above copyright notice and this permission notice,
 * provide sufficient credit to the original authors of the project (IE: DaPorkchop_), as well as provide a link to the original project.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package nbt;

import io.netty.buffer.Unpooled;
import net.daporkchop.lib.binary.oio.StreamUtil;
import net.daporkchop.lib.binary.stream.DataIn;
import net.daporkchop.lib.binary.stream.DataOut;
import net.daporkchop.lib.nbt.NBTFormat;
import net.daporkchop.lib.nbt.stream.encode.NBTEncoder;
import org.junit.Test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

import static net.daporkchop.lib.common.util.PValidation.*;

/**
 * @author DaPorkchop_
 */
public class StreamingEncodeTest {
    @Test
    public void testHelloWorld() throws IOException {
        byte[] arr;
        try (InputStream in = ObjectTreeTest.class.getResourceAsStream("/hello_world.nbt")) {
            arr = StreamUtil.toByteArray(in);
        }

        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (NBTEncoder encoder = NBTEncoder.beginCompound(DataOut.wrap(baos), "hello world")) {
            encoder.putString("name", "Bananrama");
        }

        checkState(Arrays.equals(arr, baos.toByteArray()));

        System.out.println(NBTFormat.BIG_ENDIAN.readCompound(DataIn.wrap(Unpooled.wrappedBuffer(baos.toByteArray()))));

        baos.reset();
        try (NBTEncoder encoder = NBTEncoder.beginCompound(DataOut.wrap(baos), "hello world")) {
            try (NBTEncoder string = encoder.startString("name"))   {
                string.appendString("Bananrama");
            }
        }

        checkState(Arrays.equals(arr, baos.toByteArray()));
    }
}
