/* File automatically generated by Parser/asdl_c.py. */


/*
   __version__ 82160.

   This module must be committed separately after each AST grammar change;
   The __version__ number is set to the revision number of the commit
   containing the grammar change.
*/

#include "Python.h"
#include "Python-ast.h"

static PyTypeObject AST_type;
static PyTypeObject *mod_type;
static PyObject* ast2obj_mod(void*);
static PyTypeObject *Module_type;
static char *Module_fields[]={
        "body",
};
static PyTypeObject *Interactive_type;
static char *Interactive_fields[]={
        "body",
};
static PyTypeObject *Expression_type;
static char *Expression_fields[]={
        "body",
};
static PyTypeObject *Suite_type;
static char *Suite_fields[]={
        "body",
};
static PyTypeObject *stmt_type;
static char *stmt_attributes[] = {
        "lineno",
        "col_offset",
};
static PyObject* ast2obj_stmt(void*);
static PyTypeObject *FunctionDef_type;
static char *FunctionDef_fields[]={
        "name",
        "args",
        "body",
        "decorator_list",
};
static PyTypeObject *ClassDef_type;
static char *ClassDef_fields[]={
        "name",
        "bases",
        "body",
        "decorator_list",
};
static PyTypeObject *Return_type;
static char *Return_fields[]={
        "value",
};
static PyTypeObject *Delete_type;
static char *Delete_fields[]={
        "targets",
};
static PyTypeObject *Assign_type;
static char *Assign_fields[]={
        "targets",
        "value",
};
static PyTypeObject *AugAssign_type;
static char *AugAssign_fields[]={
        "target",
        "op",
        "value",
};
static PyTypeObject *Print_type;
static char *Print_fields[]={
        "dest",
        "values",
        "nl",
};
static PyTypeObject *For_type;
static char *For_fields[]={
        "target",
        "iter",
        "body",
        "orelse",
};
static PyTypeObject *While_type;
static char *While_fields[]={
        "test",
        "body",
        "orelse",
};
static PyTypeObject *If_type;
static char *If_fields[]={
        "test",
        "body",
        "orelse",
};
static PyTypeObject *With_type;
static char *With_fields[]={
        "context_expr",
        "optional_vars",
        "body",
};
static PyTypeObject *Raise_type;
static char *Raise_fields[]={
        "type",
        "inst",
        "tback",
};
static PyTypeObject *TryExcept_type;
static char *TryExcept_fields[]={
        "body",
        "handlers",
        "orelse",
};
static PyTypeObject *TryFinally_type;
static char *TryFinally_fields[]={
        "body",
        "finalbody",
};
static PyTypeObject *Assert_type;
static char *Assert_fields[]={
        "test",
        "msg",
};
static PyTypeObject *Import_type;
static char *Import_fields[]={
        "names",
};
static PyTypeObject *ImportFrom_type;
static char *ImportFrom_fields[]={
        "module",
        "names",
        "level",
};
static PyTypeObject *Exec_type;
static char *Exec_fields[]={
        "body",
        "globals",
        "locals",
};
static PyTypeObject *Global_type;
static char *Global_fields[]={
        "names",
};
static PyTypeObject *Expr_type;
static char *Expr_fields[]={
        "value",
};
static PyTypeObject *Pass_type;
static PyTypeObject *Break_type;
static PyTypeObject *Continue_type;
static PyTypeObject *expr_type;
static char *expr_attributes[] = {
        "lineno",
        "col_offset",
};
static PyObject* ast2obj_expr(void*);
static PyTypeObject *BoolOp_type;
static char *BoolOp_fields[]={
        "op",
        "values",
};
static PyTypeObject *BinOp_type;
static char *BinOp_fields[]={
        "left",
        "op",
        "right",
};
static PyTypeObject *UnaryOp_type;
static char *UnaryOp_fields[]={
        "op",
        "operand",
};
static PyTypeObject *Lambda_type;
static char *Lambda_fields[]={
        "args",
        "body",
};
static PyTypeObject *IfExp_type;
static char *IfExp_fields[]={
        "test",
        "body",
        "orelse",
};
static PyTypeObject *Dict_type;
static char *Dict_fields[]={
        "keys",
        "values",
};
static PyTypeObject *Set_type;
static char *Set_fields[]={
        "elts",
};
static PyTypeObject *ListComp_type;
static char *ListComp_fields[]={
        "elt",
        "generators",
};
static PyTypeObject *SetComp_type;
static char *SetComp_fields[]={
        "elt",
        "generators",
};
static PyTypeObject *DictComp_type;
static char *DictComp_fields[]={
        "key",
        "value",
        "generators",
};
static PyTypeObject *GeneratorExp_type;
static char *GeneratorExp_fields[]={
        "elt",
        "generators",
};
static PyTypeObject *Yield_type;
static char *Yield_fields[]={
        "value",
};
static PyTypeObject *Compare_type;
static char *Compare_fields[]={
        "left",
        "ops",
        "comparators",
};
static PyTypeObject *Call_type;
static char *Call_fields[]={
        "func",
        "args",
        "keywords",
        "starargs",
        "kwargs",
};
static PyTypeObject *Repr_type;
static char *Repr_fields[]={
        "value",
};
static PyTypeObject *Num_type;
static char *Num_fields[]={
        "n",
};
static PyTypeObject *Str_type;
static char *Str_fields[]={
        "s",
};
static PyTypeObject *Attribute_type;
static char *Attribute_fields[]={
        "value",
        "attr",
        "ctx",
};
static PyTypeObject *Subscript_type;
static char *Subscript_fields[]={
        "value",
        "slice",
        "ctx",
};
static PyTypeObject *Name_type;
static char *Name_fields[]={
        "id",
        "ctx",
};
static PyTypeObject *List_type;
static char *List_fields[]={
        "elts",
        "ctx",
};
static PyTypeObject *Tuple_type;
static char *Tuple_fields[]={
        "elts",
        "ctx",
};
static PyTypeObject *expr_context_type;
static PyObject *Load_singleton, *Store_singleton, *Del_singleton,
*AugLoad_singleton, *AugStore_singleton, *Param_singleton;
static PyObject* ast2obj_expr_context(expr_context_ty);
static PyTypeObject *Load_type;
static PyTypeObject *Store_type;
static PyTypeObject *Del_type;
static PyTypeObject *AugLoad_type;
static PyTypeObject *AugStore_type;
static PyTypeObject *Param_type;
static PyTypeObject *slice_type;
static PyObject* ast2obj_slice(void*);
static PyTypeObject *Ellipsis_type;
static PyTypeObject *Slice_type;
static char *Slice_fields[]={
        "lower",
        "upper",
        "step",
};
static PyTypeObject *ExtSlice_type;
static char *ExtSlice_fields[]={
        "dims",
};
static PyTypeObject *Index_type;
static char *Index_fields[]={
        "value",
};
static PyTypeObject *boolop_type;
static PyObject *And_singleton, *Or_singleton;
static PyObject* ast2obj_boolop(boolop_ty);
static PyTypeObject *And_type;
static PyTypeObject *Or_type;
static PyTypeObject *operator_type;
static PyObject *Add_singleton, *Sub_singleton, *Mult_singleton,
*Div_singleton, *Mod_singleton, *Pow_singleton, *LShift_singleton,
*RShift_singleton, *BitOr_singleton, *BitXor_singleton, *BitAnd_singleton,
*FloorDiv_singleton;
static PyObject* ast2obj_operator(operator_ty);
static PyTypeObject *Add_type;
static PyTypeObject *Sub_type;
static PyTypeObject *Mult_type;
static PyTypeObject *Div_type;
static PyTypeObject *Mod_type;
static PyTypeObject *Pow_type;
static PyTypeObject *LShift_type;
static PyTypeObject *RShift_type;
static PyTypeObject *BitOr_type;
static PyTypeObject *BitXor_type;
static PyTypeObject *BitAnd_type;
static PyTypeObject *FloorDiv_type;
static PyTypeObject *unaryop_type;
static PyObject *Invert_singleton, *Not_singleton, *UAdd_singleton,
*USub_singleton;
static PyObject* ast2obj_unaryop(unaryop_ty);
static PyTypeObject *Invert_type;
static PyTypeObject *Not_type;
static PyTypeObject *UAdd_type;
static PyTypeObject *USub_type;
static PyTypeObject *cmpop_type;
static PyObject *Eq_singleton, *NotEq_singleton, *Lt_singleton, *LtE_singleton,
*Gt_singleton, *GtE_singleton, *Is_singleton, *IsNot_singleton, *In_singleton,
*NotIn_singleton;
static PyObject* ast2obj_cmpop(cmpop_ty);
static PyTypeObject *Eq_type;
static PyTypeObject *NotEq_type;
static PyTypeObject *Lt_type;
static PyTypeObject *LtE_type;
static PyTypeObject *Gt_type;
static PyTypeObject *GtE_type;
static PyTypeObject *Is_type;
static PyTypeObject *IsNot_type;
static PyTypeObject *In_type;
static PyTypeObject *NotIn_type;
static PyTypeObject *comprehension_type;
static PyObject* ast2obj_comprehension(void*);
static char *comprehension_fields[]={
        "target",
        "iter",
        "ifs",
};
static PyTypeObject *excepthandler_type;
static char *excepthandler_attributes[] = {
        "lineno",
        "col_offset",
};
static PyObject* ast2obj_excepthandler(void*);
static PyTypeObject *ExceptHandler_type;
static char *ExceptHandler_fields[]={
        "type",
        "name",
        "body",
};
static PyTypeObject *arguments_type;
static PyObject* ast2obj_arguments(void*);
static char *arguments_fields[]={
        "args",
        "vararg",
        "kwarg",
        "defaults",
};
static PyTypeObject *keyword_type;
static PyObject* ast2obj_keyword(void*);
static char *keyword_fields[]={
        "arg",
        "value",
};
static PyTypeObject *alias_type;
static PyObject* ast2obj_alias(void*);
static char *alias_fields[]={
        "name",
        "asname",
};


static int
ast_type_init(PyObject *self, PyObject *args, PyObject *kw)
{
    Py_ssize_t i, numfields = 0;
    int res = -1;
    PyObject *key, *value, *fields;
    fields = PyObject_GetAttrString((PyObject*)Py_TYPE(self), "_fields");
    if (!fields)
        PyErr_Clear();
    if (fields) {
        numfields = PySequence_Size(fields);
        if (numfields == -1)
            goto cleanup;
    }
    res = 0; /* if no error occurs, this stays 0 to the end */
    if (PyTuple_GET_SIZE(args) > 0) {
        if (numfields != PyTuple_GET_SIZE(args)) {
            PyErr_Format(PyExc_TypeError, "%.400s constructor takes %s"
                         "%zd positional argument%s",
                         Py_TYPE(self)->tp_name,
                         numfields == 0 ? "" : "either 0 or ",
                         numfields, numfields == 1 ? "" : "s");
            res = -1;
            goto cleanup;
        }
        for (i = 0; i < PyTuple_GET_SIZE(args); i++) {
            /* cannot be reached when fields is NULL */
            PyObject *name = PySequence_GetItem(fields, i);
            if (!name) {
                res = -1;
                goto cleanup;
            }
            res = PyObject_SetAttr(self, name, PyTuple_GET_ITEM(args, i));
            Py_DECREF(name);
            if (res < 0)
                goto cleanup;
        }
    }
    if (kw) {
        i = 0;  /* needed by PyDict_Next */
        while (PyDict_Next(kw, &i, &key, &value)) {
            res = PyObject_SetAttr(self, key, value);
            if (res < 0)
                goto cleanup;
        }
    }
  cleanup:
    Py_XDECREF(fields);
    return res;
}

/* Pickling support */
static PyObject *
ast_type_reduce(PyObject *self, PyObject *unused)
{
    PyObject *res;
    PyObject *dict = PyObject_GetAttrString(self, "__dict__");
    if (dict == NULL) {
        if (PyErr_ExceptionMatches(PyExc_AttributeError))
            PyErr_Clear();
        else
            return NULL;
    }
    if (dict) {
        res = Py_BuildValue("O()O", Py_TYPE(self), dict);
        Py_DECREF(dict);
        return res;
    }
    return Py_BuildValue("O()", Py_TYPE(self));
}

static PyMethodDef ast_type_methods[] = {
    {"__reduce__", ast_type_reduce, METH_NOARGS, NULL},
    {NULL}
};

static PyTypeObject AST_type = {
    PyVarObject_HEAD_INIT(&PyType_Type, 0)
    "_ast.AST",
    sizeof(PyObject),
    0,
    0,                       /* tp_dealloc */
    0,                       /* tp_print */
    0,                       /* tp_getattr */
    0,                       /* tp_setattr */
    0,                       /* tp_compare */
    0,                       /* tp_repr */
    0,                       /* tp_as_number */
    0,                       /* tp_as_sequence */
    0,                       /* tp_as_mapping */
    0,                       /* tp_hash */
    0,                       /* tp_call */
    0,                       /* tp_str */
    PyObject_GenericGetAttr, /* tp_getattro */
    PyObject_GenericSetAttr, /* tp_setattro */
    0,                       /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE, /* tp_flags */
    0,                       /* tp_doc */
    0,                       /* tp_traverse */
    0,                       /* tp_clear */
    0,                       /* tp_richcompare */
    0,                       /* tp_weaklistoffset */
    0,                       /* tp_iter */
    0,                       /* tp_iternext */
    ast_type_methods,        /* tp_methods */
    0,                       /* tp_members */
    0,                       /* tp_getset */
    0,                       /* tp_base */
    0,                       /* tp_dict */
    0,                       /* tp_descr_get */
    0,                       /* tp_descr_set */
    0,                       /* tp_dictoffset */
    (initproc)ast_type_init, /* tp_init */
    PyType_GenericAlloc,     /* tp_alloc */
    PyType_GenericNew,       /* tp_new */
    PyObject_Del,            /* tp_free */
};


static PyTypeObject* make_type(char *type, PyTypeObject* base, char**fields, int num_fields)
{
    PyObject *fnames, *result;
    int i;
    fnames = PyTuple_New(num_fields);
    if (!fnames) return NULL;
    for (i = 0; i < num_fields; i++) {
        PyObject *field = PyString_FromString(fields[i]);
        if (!field) {
            Py_DECREF(fnames);
            return NULL;
        }
        PyTuple_SET_ITEM(fnames, i, field);
    }
    result = PyObject_CallFunction((PyObject*)&PyType_Type, "s(O){sOss}",
                    type, base, "_fields", fnames, "__module__", "_ast");
    Py_DECREF(fnames);
    return (PyTypeObject*)result;
}

static int add_attributes(PyTypeObject* type, char**attrs, int num_fields)
{
    int i, result;
    PyObject *s, *l = PyTuple_New(num_fields);
    if (!l)
        return 0;
    for (i = 0; i < num_fields; i++) {
        s = PyString_FromString(attrs[i]);
        if (!s) {
            Py_DECREF(l);
            return 0;
        }
        PyTuple_SET_ITEM(l, i, s);
    }
    result = PyObject_SetAttrString((PyObject*)type, "_attributes", l) >= 0;
    Py_DECREF(l);
    return result;
}

/* Conversion AST -> Python */

static PyObject* ast2obj_list(asdl_seq *seq, PyObject* (*func)(void*))
{
    int i, n = asdl_seq_LEN(seq);
    PyObject *result = PyList_New(n);
    PyObject *value;
    if (!result)
        return NULL;
    for (i = 0; i < n; i++) {
        value = func(asdl_seq_GET(seq, i));
        if (!value) {
            Py_DECREF(result);
            return NULL;
        }
        PyList_SET_ITEM(result, i, value);
    }
    return result;
}

static PyObject* ast2obj_object(void *o)
{
    if (!o)
        o = Py_None;
    Py_INCREF((PyObject*)o);
    return (PyObject*)o;
}
#define ast2obj_identifier ast2obj_object
#define ast2obj_string ast2obj_object
static PyObject* ast2obj_bool(bool b)
{
    return PyBool_FromLong(b);
}

static PyObject* ast2obj_int(long b)
{
    return PyInt_FromLong(b);
}

/* Conversion Python -> AST */

static int obj2ast_object(PyObject* obj, PyObject** out, PyArena* arena)
{
    if (obj == Py_None)
        obj = NULL;
    if (obj)
        PyArena_AddPyObject(arena, obj);
    Py_XINCREF(obj);
    *out = obj;
    return 0;
}

static int obj2ast_identifier(PyObject* obj, PyObject** out, PyArena* arena)
{
    if (!PyString_CheckExact(obj) && obj != Py_None) {
        PyErr_Format(PyExc_TypeError,
                    "AST identifier must be of type str");
        return 1;
    }
    return obj2ast_object(obj, out, arena);
}

static int obj2ast_string(PyObject* obj, PyObject** out, PyArena* arena)
{
    if (!PyString_CheckExact(obj) && !PyUnicode_CheckExact(obj)) {
        PyErr_SetString(PyExc_TypeError,
                       "AST string must be of type str or unicode");
        return 1;
    }
    return obj2ast_object(obj, out, arena);
}

static int obj2ast_int(PyObject* obj, int* out, PyArena* arena)
{
    int i;
    if (!PyInt_Check(obj) && !PyLong_Check(obj)) {
        PyObject *s = PyObject_Repr(obj);
        if (s == NULL) return 1;
        PyErr_Format(PyExc_ValueError, "invalid integer value: %.400s",
                     PyString_AS_STRING(s));
        Py_DECREF(s);
        return 1;
    }

    i = (int)PyLong_AsLong(obj);
    if (i == -1 && PyErr_Occurred())
        return 1;
    *out = i;
    return 0;
}

static int obj2ast_bool(PyObject* obj, bool* out, PyArena* arena)
{
    if (!PyBool_Check(obj)) {
        PyObject *s = PyObject_Repr(obj);
        if (s == NULL) return 1;
        PyErr_Format(PyExc_ValueError, "invalid boolean value: %.400s",
                     PyString_AS_STRING(s));
        Py_DECREF(s);
        return 1;
    }

    *out = (obj == Py_True);
    return 0;
}

static int add_ast_fields(void)
{
    PyObject *empty_tuple, *d;
    if (PyType_Ready(&AST_type) < 0)
        return -1;
    d = AST_type.tp_dict;
    empty_tuple = PyTuple_New(0);
    if (!empty_tuple ||
        PyDict_SetItemString(d, "_fields", empty_tuple) < 0 ||
        PyDict_SetItemString(d, "_attributes", empty_tuple) < 0) {
        Py_XDECREF(empty_tuple);
        return -1;
    }
    Py_DECREF(empty_tuple);
    return 0;
}


static int init_types(void)
{
        static int initialized;
        if (initialized) return 1;
        if (add_ast_fields() < 0) return 0;
        mod_type = make_type("mod", &AST_type, NULL, 0);
        if (!mod_type) return 0;
        if (!add_attributes(mod_type, NULL, 0)) return 0;
        Module_type = make_type("Module", mod_type, Module_fields, 1);
        if (!Module_type) return 0;
        Interactive_type = make_type("Interactive", mod_type,
                                     Interactive_fields, 1);
        if (!Interactive_type) return 0;
        Expression_type = make_type("Expression", mod_type, Expression_fields,
                                    1);
        if (!Expression_type) return 0;
        Suite_type = make_type("Suite", mod_type, Suite_fields, 1);
        if (!Suite_type) return 0;
        stmt_type = make_type("stmt", &AST_type, NULL, 0);
        if (!stmt_type) return 0;
        if (!add_attributes(stmt_type, stmt_attributes, 2)) return 0;
        FunctionDef_type = make_type("FunctionDef", stmt_type,
                                     FunctionDef_fields, 4);
        if (!FunctionDef_type) return 0;
        ClassDef_type = make_type("ClassDef", stmt_type, ClassDef_fields, 4);
        if (!ClassDef_type) return 0;
        Return_type = make_type("Return", stmt_type, Return_fields, 1);
        if (!Return_type) return 0;
        Delete_type = make_type("Delete", stmt_type, Delete_fields, 1);
        if (!Delete_type) return 0;
        Assign_type = make_type("Assign", stmt_type, Assign_fields, 2);
        if (!Assign_type) return 0;
        AugAssign_type = make_type("AugAssign", stmt_type, AugAssign_fields, 3);
        if (!AugAssign_type) return 0;
        Print_type = make_type("Print", stmt_type, Print_fields, 3);
        if (!Print_type) return 0;
        For_type = make_type("For", stmt_type, For_fields, 4);
        if (!For_type) return 0;
        While_type = make_type("While", stmt_type, While_fields, 3);
        if (!While_type) return 0;
        If_type = make_type("If", stmt_type, If_fields, 3);
        if (!If_type) return 0;
        With_type = make_type("With", stmt_type, With_fields, 3);
        if (!With_type) return 0;
        Raise_type = make_type("Raise", stmt_type, Raise_fields, 3);
        if (!Raise_type) return 0;
        TryExcept_type = make_type("TryExcept", stmt_type, TryExcept_fields, 3);
        if (!TryExcept_type) return 0;
        TryFinally_type = make_type("TryFinally", stmt_type, TryFinally_fields,
                                    2);
        if (!TryFinally_type) return 0;
        Assert_type = make_type("Assert", stmt_type, Assert_fields, 2);
        if (!Assert_type) return 0;
        Import_type = make_type("Import", stmt_type, Import_fields, 1);
        if (!Import_type) return 0;
        ImportFrom_type = make_type("ImportFrom", stmt_type, ImportFrom_fields,
                                    3);
        if (!ImportFrom_type) return 0;
        Exec_type = make_type("Exec", stmt_type, Exec_fields, 3);
        if (!Exec_type) return 0;
        Global_type = make_type("Global", stmt_type, Global_fields, 1);
        if (!Global_type) return 0;
        Expr_type = make_type("Expr", stmt_type, Expr_fields, 1);
        if (!Expr_type) return 0;
        Pass_type = make_type("Pass", stmt_type, NULL, 0);
        if (!Pass_type) return 0;
        Break_type = make_type("Break", stmt_type, NULL, 0);
        if (!Break_type) return 0;
        Continue_type = make_type("Continue", stmt_type, NULL, 0);
        if (!Continue_type) return 0;
        expr_type = make_type("expr", &AST_type, NULL, 0);
        if (!expr_type) return 0;
        if (!add_attributes(expr_type, expr_attributes, 2)) return 0;
        BoolOp_type = make_type("BoolOp", expr_type, BoolOp_fields, 2);
        if (!BoolOp_type) return 0;
        BinOp_type = make_type("BinOp", expr_type, BinOp_fields, 3);
        if (!BinOp_type) return 0;
        UnaryOp_type = make_type("UnaryOp", expr_type, UnaryOp_fields, 2);
        if (!UnaryOp_type) return 0;
        Lambda_type = make_type("Lambda", expr_type, Lambda_fields, 2);
        if (!Lambda_type) return 0;
        IfExp_type = make_type("IfExp", expr_type, IfExp_fields, 3);
        if (!IfExp_type) return 0;
        Dict_type = make_type("Dict", expr_type, Dict_fields, 2);
        if (!Dict_type) return 0;
        Set_type = make_type("Set", expr_type, Set_fields, 1);
        if (!Set_type) return 0;
        ListComp_type = make_type("ListComp", expr_type, ListComp_fields, 2);
        if (!ListComp_type) return 0;
        SetComp_type = make_type("SetComp", expr_type, SetComp_fields, 2);
        if (!SetComp_type) return 0;
        DictComp_type = make_type("DictComp", expr_type, DictComp_fields, 3);
        if (!DictComp_type) return 0;
        GeneratorExp_type = make_type("GeneratorExp", expr_type,
                                      GeneratorExp_fields, 2);
        if (!GeneratorExp_type) return 0;
        Yield_type = make_type("Yield", expr_type, Yield_fields, 1);
        if (!Yield_type) return 0;
        Compare_type = make_type("Compare", expr_type, Compare_fields, 3);
        if (!Compare_type) return 0;
        Call_type = make_type("Call", expr_type, Call_fields, 5);
        if (!Call_type) return 0;
        Repr_type = make_type("Repr", expr_type, Repr_fields, 1);
        if (!Repr_type) return 0;
        Num_type = make_type("Num", expr_type, Num_fields, 1);
        if (!Num_type) return 0;
        Str_type = make_type("Str", expr_type, Str_fields, 1);
        if (!Str_type) return 0;
        Attribute_type = make_type("Attribute", expr_type, Attribute_fields, 3);
        if (!Attribute_type) return 0;
        Subscript_type = make_type("Subscript", expr_type, Subscript_fields, 3);
        if (!Subscript_type) return 0;
        Name_type = make_type("Name", expr_type, Name_fields, 2);
        if (!Name_type) return 0;
        List_type = make_type("List", expr_type, List_fields, 2);
        if (!List_type) return 0;
        Tuple_type = make_type("Tuple", expr_type, Tuple_fields, 2);
        if (!Tuple_type) return 0;
        expr_context_type = make_type("expr_context", &AST_type, NULL, 0);
        if (!expr_context_type) return 0;
        if (!add_attributes(expr_context_type, NULL, 0)) return 0;
        Load_type = make_type("Load", expr_context_type, NULL, 0);
        if (!Load_type) return 0;
        Load_singleton = PyType_GenericNew(Load_type, NULL, NULL);
        if (!Load_singleton) return 0;
        Store_type = make_type("Store", expr_context_type, NULL, 0);
        if (!Store_type) return 0;
        Store_singleton = PyType_GenericNew(Store_type, NULL, NULL);
        if (!Store_singleton) return 0;
        Del_type = make_type("Del", expr_context_type, NULL, 0);
        if (!Del_type) return 0;
        Del_singleton = PyType_GenericNew(Del_type, NULL, NULL);
        if (!Del_singleton) return 0;
        AugLoad_type = make_type("AugLoad", expr_context_type, NULL, 0);
        if (!AugLoad_type) return 0;
        AugLoad_singleton = PyType_GenericNew(AugLoad_type, NULL, NULL);
        if (!AugLoad_singleton) return 0;
        AugStore_type = make_type("AugStore", expr_context_type, NULL, 0);
        if (!AugStore_type) return 0;
        AugStore_singleton = PyType_GenericNew(AugStore_type, NULL, NULL);
        if (!AugStore_singleton) return 0;
        Param_type = make_type("Param", expr_context_type, NULL, 0);
        if (!Param_type) return 0;
        Param_singleton = PyType_GenericNew(Param_type, NULL, NULL);
        if (!Param_singleton) return 0;
        slice_type = make_type("slice", &AST_type, NULL, 0);
        if (!slice_type) return 0;
        if (!add_attributes(slice_type, NULL, 0)) return 0;
        Ellipsis_type = make_type("Ellipsis", slice_type, NULL, 0);
        if (!Ellipsis_type) return 0;
        Slice_type = make_type("Slice", slice_type, Slice_fields, 3);
        if (!Slice_type) return 0;
        ExtSlice_type = make_type("ExtSlice", slice_type, ExtSlice_fields, 1);
        if (!ExtSlice_type) return 0;
        Index_type = make_type("Index", slice_type, Index_fields, 1);
        if (!Index_type) return 0;
        boolop_type = make_type("boolop", &AST_type, NULL, 0);
        if (!boolop_type) return 0;
        if (!add_attributes(boolop_type, NULL, 0)) return 0;
        And_type = make_type("And", boolop_type, NULL, 0);
        if (!And_type) return 0;
        And_singleton = PyType_GenericNew(And_type, NULL, NULL);
        if (!And_singleton) return 0;
        Or_type = make_type("Or", boolop_type, NULL, 0);
        if (!Or_type) return 0;
        Or_singleton = PyType_GenericNew(Or_type, NULL, NULL);
        if (!Or_singleton) return 0;
        operator_type = make_type("operator", &AST_type, NULL, 0);
        if (!operator_type) return 0;
        if (!add_attributes(operator_type, NULL, 0)) return 0;
        Add_type = make_type("Add", operator_type, NULL, 0);
        if (!Add_type) return 0;
        Add_singleton = PyType_GenericNew(Add_type, NULL, NULL);
        if (!Add_singleton) return 0;
        Sub_type = make_type("Sub", operator_type, NULL, 0);
        if (!Sub_type) return 0;
        Sub_singleton = PyType_GenericNew(Sub_type, NULL, NULL);
        if (!Sub_singleton) return 0;
        Mult_type = make_type("Mult", operator_type, NULL, 0);
        if (!Mult_type) return 0;
        Mult_singleton = PyType_GenericNew(Mult_type, NULL, NULL);
        if (!Mult_singleton) return 0;
        Div_type = make_type("Div", operator_type, NULL, 0);
        if (!Div_type) return 0;
        Div_singleton = PyType_GenericNew(Div_type, NULL, NULL);
        if (!Div_singleton) return 0;
        Mod_type = make_type("Mod", operator_type, NULL, 0);
        if (!Mod_type) return 0;
        Mod_singleton = PyType_GenericNew(Mod_type, NULL, NULL);
        if (!Mod_singleton) return 0;
        Pow_type = make_type("Pow", operator_type, NULL, 0);
        if (!Pow_type) return 0;
        Pow_singleton = PyType_GenericNew(Pow_type, NULL, NULL);
        if (!Pow_singleton) return 0;
        LShift_type = make_type("LShift", operator_type, NULL, 0);
        if (!LShift_type) return 0;
        LShift_singleton = PyType_GenericNew(LShift_type, NULL, NULL);
        if (!LShift_singleton) return 0;
        RShift_type = make_type("RShift", operator_type, NULL, 0);
        if (!RShift_type) return 0;
        RShift_singleton = PyType_GenericNew(RShift_type, NULL, NULL);
        if (!RShift_singleton) return 0;
        BitOr_type = make_type("BitOr", operator_type, NULL, 0);
        if (!BitOr_type) return 0;
        BitOr_singleton = PyType_GenericNew(BitOr_type, NULL, NULL);
        if (!BitOr_singleton) return 0;
        BitXor_type = make_type("BitXor", operator_type, NULL, 0);
        if (!BitXor_type) return 0;
        BitXor_singleton = PyType_GenericNew(BitXor_type, NULL, NULL);
        if (!BitXor_singleton) return 0;
        BitAnd_type = make_type("BitAnd", operator_type, NULL, 0);
        if (!BitAnd_type) return 0;
        BitAnd_singleton = PyType_GenericNew(BitAnd_type, NULL, NULL);
        if (!BitAnd_singleton) return 0;
        FloorDiv_type = make_type("FloorDiv", operator_type, NULL, 0);
        if (!FloorDiv_type) return 0;
        FloorDiv_singleton = PyType_GenericNew(FloorDiv_type, NULL, NULL);
        if (!FloorDiv_singleton) return 0;
        unaryop_type = make_type("unaryop", &AST_type, NULL, 0);
        if (!unaryop_type) return 0;
        if (!add_attributes(unaryop_type, NULL, 0)) return 0;
        Invert_type = make_type("Invert", unaryop_type, NULL, 0);
        if (!Invert_type) return 0;
        Invert_singleton = PyType_GenericNew(Invert_type, NULL, NULL);
        if (!Invert_singleton) return 0;
        Not_type = make_type("Not", unaryop_type, NULL, 0);
        if (!Not_type) return 0;
        Not_singleton = PyType_GenericNew(Not_type, NULL, NULL);
        if (!Not_singleton) return 0;
        UAdd_type = make_type("UAdd", unaryop_type, NULL, 0);
        if (!UAdd_type) return 0;
        UAdd_singleton = PyType_GenericNew(UAdd_type, NULL, NULL);
        if (!UAdd_singleton) return 0;
        USub_type = make_type("USub", unaryop_type, NULL, 0);
        if (!USub_type) return 0;
        USub_singleton = PyType_GenericNew(USub_type, NULL, NULL);
        if (!USub_singleton) return 0;
        cmpop_type = make_type("cmpop", &AST_type, NULL, 0);
        if (!cmpop_type) return 0;
        if (!add_attributes(cmpop_type, NULL, 0)) return 0;
        Eq_type = make_type("Eq", cmpop_type, NULL, 0);
        if (!Eq_type) return 0;
        Eq_singleton = PyType_GenericNew(Eq_type, NULL, NULL);
        if (!Eq_singleton) return 0;
        NotEq_type = make_type("NotEq", cmpop_type, NULL, 0);
        if (!NotEq_type) return 0;
        NotEq_singleton = PyType_GenericNew(NotEq_type, NULL, NULL);
        if (!NotEq_singleton) return 0;
        Lt_type = make_type("Lt", cmpop_type, NULL, 0);
        if (!Lt_type) return 0;
        Lt_singleton = PyType_GenericNew(Lt_type, NULL, NULL);
        if (!Lt_singleton) return 0;
        LtE_type = make_type("LtE", cmpop_type, NULL, 0);
        if (!LtE_type) return 0;
        LtE_singleton = PyType_GenericNew(LtE_type, NULL, NULL);
        if (!LtE_singleton) return 0;
        Gt_type = make_type("Gt", cmpop_type, NULL, 0);
        if (!Gt_type) return 0;
        Gt_singleton = PyType_GenericNew(Gt_type, NULL, NULL);
        if (!Gt_singleton) return 0;
        GtE_type = make_type("GtE", cmpop_type, NULL, 0);
        if (!GtE_type) return 0;
        GtE_singleton = PyType_GenericNew(GtE_type, NULL, NULL);
        if (!GtE_singleton) return 0;
        Is_type = make_type("Is", cmpop_type, NULL, 0);
        if (!Is_type) return 0;
        Is_singleton = PyType_GenericNew(Is_type, NULL, NULL);
        if (!Is_singleton) return 0;
        IsNot_type = make_type("IsNot", cmpop_type, NULL, 0);
        if (!IsNot_type) return 0;
        IsNot_singleton = PyType_GenericNew(IsNot_type, NULL, NULL);
        if (!IsNot_singleton) return 0;
        In_type = make_type("In", cmpop_type, NULL, 0);
        if (!In_type) return 0;
        In_singleton = PyType_GenericNew(In_type, NULL, NULL);
        if (!In_singleton) return 0;
        NotIn_type = make_type("NotIn", cmpop_type, NULL, 0);
        if (!NotIn_type) return 0;
        NotIn_singleton = PyType_GenericNew(NotIn_type, NULL, NULL);
        if (!NotIn_singleton) return 0;
        comprehension_type = make_type("comprehension", &AST_type,
                                       comprehension_fields, 3);
        if (!comprehension_type) return 0;
        excepthandler_type = make_type("excepthandler", &AST_type, NULL, 0);
        if (!excepthandler_type) return 0;
        if (!add_attributes(excepthandler_type, excepthandler_attributes, 2))
            return 0;
        ExceptHandler_type = make_type("ExceptHandler", excepthandler_type,
                                       ExceptHandler_fields, 3);
        if (!ExceptHandler_type) return 0;
        arguments_type = make_type("arguments", &AST_type, arguments_fields, 4);
        if (!arguments_type) return 0;
        keyword_type = make_type("keyword", &AST_type, keyword_fields, 2);
        if (!keyword_type) return 0;
        alias_type = make_type("alias", &AST_type, alias_fields, 2);
        if (!alias_type) return 0;
        initialized = 1;
        return 1;
}

static int obj2ast_mod(PyObject* obj, mod_ty* out, PyArena* arena);
static int obj2ast_stmt(PyObject* obj, stmt_ty* out, PyArena* arena);
static int obj2ast_expr(PyObject* obj, expr_ty* out, PyArena* arena);
static int obj2ast_expr_context(PyObject* obj, expr_context_ty* out, PyArena*
                                arena);
static int obj2ast_slice(PyObject* obj, slice_ty* out, PyArena* arena);
static int obj2ast_boolop(PyObject* obj, boolop_ty* out, PyArena* arena);
static int obj2ast_operator(PyObject* obj, operator_ty* out, PyArena* arena);
static int obj2ast_unaryop(PyObject* obj, unaryop_ty* out, PyArena* arena);
static int obj2ast_cmpop(PyObject* obj, cmpop_ty* out, PyArena* arena);
static int obj2ast_comprehension(PyObject* obj, comprehension_ty* out, PyArena*
                                 arena);
static int obj2ast_excepthandler(PyObject* obj, excepthandler_ty* out, PyArena*
                                 arena);
static int obj2ast_arguments(PyObject* obj, arguments_ty* out, PyArena* arena);
static int obj2ast_keyword(PyObject* obj, keyword_ty* out, PyArena* arena);
static int obj2ast_alias(PyObject* obj, alias_ty* out, PyArena* arena);

mod_ty
Module(asdl_seq * body, PyArena *arena)
{
        mod_ty p;
        p = (mod_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Module_kind;
        p->v.Module.body = body;
        return p;
}

mod_ty
Interactive(asdl_seq * body, PyArena *arena)
{
        mod_ty p;
        p = (mod_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Interactive_kind;
        p->v.Interactive.body = body;
        return p;
}

mod_ty
Expression(expr_ty body, PyArena *arena)
{
        mod_ty p;
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Expression");
                return NULL;
        }
        p = (mod_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Expression_kind;
        p->v.Expression.body = body;
        return p;
}

mod_ty
Suite(asdl_seq * body, PyArena *arena)
{
        mod_ty p;
        p = (mod_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Suite_kind;
        p->v.Suite.body = body;
        return p;
}

stmt_ty
FunctionDef(identifier name, arguments_ty args, asdl_seq * body, asdl_seq *
            decorator_list, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for FunctionDef");
                return NULL;
        }
        if (!args) {
                PyErr_SetString(PyExc_ValueError,
                                "field args is required for FunctionDef");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = FunctionDef_kind;
        p->v.FunctionDef.name = name;
        p->v.FunctionDef.args = args;
        p->v.FunctionDef.body = body;
        p->v.FunctionDef.decorator_list = decorator_list;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
ClassDef(identifier name, asdl_seq * bases, asdl_seq * body, asdl_seq *
         decorator_list, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for ClassDef");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = ClassDef_kind;
        p->v.ClassDef.name = name;
        p->v.ClassDef.bases = bases;
        p->v.ClassDef.body = body;
        p->v.ClassDef.decorator_list = decorator_list;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Return(expr_ty value, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Return_kind;
        p->v.Return.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Delete(asdl_seq * targets, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Delete_kind;
        p->v.Delete.targets = targets;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Assign(asdl_seq * targets, expr_ty value, int lineno, int col_offset, PyArena
       *arena)
{
        stmt_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Assign");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Assign_kind;
        p->v.Assign.targets = targets;
        p->v.Assign.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
AugAssign(expr_ty target, operator_ty op, expr_ty value, int lineno, int
          col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for AugAssign");
                return NULL;
        }
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for AugAssign");
                return NULL;
        }
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for AugAssign");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = AugAssign_kind;
        p->v.AugAssign.target = target;
        p->v.AugAssign.op = op;
        p->v.AugAssign.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Print(expr_ty dest, asdl_seq * values, bool nl, int lineno, int col_offset,
      PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Print_kind;
        p->v.Print.dest = dest;
        p->v.Print.values = values;
        p->v.Print.nl = nl;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
For(expr_ty target, expr_ty iter, asdl_seq * body, asdl_seq * orelse, int
    lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for For");
                return NULL;
        }
        if (!iter) {
                PyErr_SetString(PyExc_ValueError,
                                "field iter is required for For");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = For_kind;
        p->v.For.target = target;
        p->v.For.iter = iter;
        p->v.For.body = body;
        p->v.For.orelse = orelse;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
While(expr_ty test, asdl_seq * body, asdl_seq * orelse, int lineno, int
      col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for While");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = While_kind;
        p->v.While.test = test;
        p->v.While.body = body;
        p->v.While.orelse = orelse;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
If(expr_ty test, asdl_seq * body, asdl_seq * orelse, int lineno, int
   col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for If");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = If_kind;
        p->v.If.test = test;
        p->v.If.body = body;
        p->v.If.orelse = orelse;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
With(expr_ty context_expr, expr_ty optional_vars, asdl_seq * body, int lineno,
     int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!context_expr) {
                PyErr_SetString(PyExc_ValueError,
                                "field context_expr is required for With");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = With_kind;
        p->v.With.context_expr = context_expr;
        p->v.With.optional_vars = optional_vars;
        p->v.With.body = body;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Raise(expr_ty type, expr_ty inst, expr_ty tback, int lineno, int col_offset,
      PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Raise_kind;
        p->v.Raise.type = type;
        p->v.Raise.inst = inst;
        p->v.Raise.tback = tback;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
TryExcept(asdl_seq * body, asdl_seq * handlers, asdl_seq * orelse, int lineno,
          int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = TryExcept_kind;
        p->v.TryExcept.body = body;
        p->v.TryExcept.handlers = handlers;
        p->v.TryExcept.orelse = orelse;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
TryFinally(asdl_seq * body, asdl_seq * finalbody, int lineno, int col_offset,
           PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = TryFinally_kind;
        p->v.TryFinally.body = body;
        p->v.TryFinally.finalbody = finalbody;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Assert(expr_ty test, expr_ty msg, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for Assert");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Assert_kind;
        p->v.Assert.test = test;
        p->v.Assert.msg = msg;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Import(asdl_seq * names, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Import_kind;
        p->v.Import.names = names;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
ImportFrom(identifier module, asdl_seq * names, int level, int lineno, int
           col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = ImportFrom_kind;
        p->v.ImportFrom.module = module;
        p->v.ImportFrom.names = names;
        p->v.ImportFrom.level = level;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Exec(expr_ty body, expr_ty globals, expr_ty locals, int lineno, int col_offset,
     PyArena *arena)
{
        stmt_ty p;
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Exec");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Exec_kind;
        p->v.Exec.body = body;
        p->v.Exec.globals = globals;
        p->v.Exec.locals = locals;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Global(asdl_seq * names, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Global_kind;
        p->v.Global.names = names;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Expr(expr_ty value, int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Expr");
                return NULL;
        }
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Expr_kind;
        p->v.Expr.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Pass(int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Pass_kind;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Break(int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Break_kind;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

stmt_ty
Continue(int lineno, int col_offset, PyArena *arena)
{
        stmt_ty p;
        p = (stmt_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Continue_kind;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
BoolOp(boolop_ty op, asdl_seq * values, int lineno, int col_offset, PyArena
       *arena)
{
        expr_ty p;
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for BoolOp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = BoolOp_kind;
        p->v.BoolOp.op = op;
        p->v.BoolOp.values = values;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
BinOp(expr_ty left, operator_ty op, expr_ty right, int lineno, int col_offset,
      PyArena *arena)
{
        expr_ty p;
        if (!left) {
                PyErr_SetString(PyExc_ValueError,
                                "field left is required for BinOp");
                return NULL;
        }
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for BinOp");
                return NULL;
        }
        if (!right) {
                PyErr_SetString(PyExc_ValueError,
                                "field right is required for BinOp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = BinOp_kind;
        p->v.BinOp.left = left;
        p->v.BinOp.op = op;
        p->v.BinOp.right = right;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
UnaryOp(unaryop_ty op, expr_ty operand, int lineno, int col_offset, PyArena
        *arena)
{
        expr_ty p;
        if (!op) {
                PyErr_SetString(PyExc_ValueError,
                                "field op is required for UnaryOp");
                return NULL;
        }
        if (!operand) {
                PyErr_SetString(PyExc_ValueError,
                                "field operand is required for UnaryOp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = UnaryOp_kind;
        p->v.UnaryOp.op = op;
        p->v.UnaryOp.operand = operand;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Lambda(arguments_ty args, expr_ty body, int lineno, int col_offset, PyArena
       *arena)
{
        expr_ty p;
        if (!args) {
                PyErr_SetString(PyExc_ValueError,
                                "field args is required for Lambda");
                return NULL;
        }
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for Lambda");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Lambda_kind;
        p->v.Lambda.args = args;
        p->v.Lambda.body = body;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
IfExp(expr_ty test, expr_ty body, expr_ty orelse, int lineno, int col_offset,
      PyArena *arena)
{
        expr_ty p;
        if (!test) {
                PyErr_SetString(PyExc_ValueError,
                                "field test is required for IfExp");
                return NULL;
        }
        if (!body) {
                PyErr_SetString(PyExc_ValueError,
                                "field body is required for IfExp");
                return NULL;
        }
        if (!orelse) {
                PyErr_SetString(PyExc_ValueError,
                                "field orelse is required for IfExp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = IfExp_kind;
        p->v.IfExp.test = test;
        p->v.IfExp.body = body;
        p->v.IfExp.orelse = orelse;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Dict(asdl_seq * keys, asdl_seq * values, int lineno, int col_offset, PyArena
     *arena)
{
        expr_ty p;
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Dict_kind;
        p->v.Dict.keys = keys;
        p->v.Dict.values = values;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Set(asdl_seq * elts, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Set_kind;
        p->v.Set.elts = elts;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
ListComp(expr_ty elt, asdl_seq * generators, int lineno, int col_offset,
         PyArena *arena)
{
        expr_ty p;
        if (!elt) {
                PyErr_SetString(PyExc_ValueError,
                                "field elt is required for ListComp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = ListComp_kind;
        p->v.ListComp.elt = elt;
        p->v.ListComp.generators = generators;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
SetComp(expr_ty elt, asdl_seq * generators, int lineno, int col_offset, PyArena
        *arena)
{
        expr_ty p;
        if (!elt) {
                PyErr_SetString(PyExc_ValueError,
                                "field elt is required for SetComp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = SetComp_kind;
        p->v.SetComp.elt = elt;
        p->v.SetComp.generators = generators;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
DictComp(expr_ty key, expr_ty value, asdl_seq * generators, int lineno, int
         col_offset, PyArena *arena)
{
        expr_ty p;
        if (!key) {
                PyErr_SetString(PyExc_ValueError,
                                "field key is required for DictComp");
                return NULL;
        }
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for DictComp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = DictComp_kind;
        p->v.DictComp.key = key;
        p->v.DictComp.value = value;
        p->v.DictComp.generators = generators;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
GeneratorExp(expr_ty elt, asdl_seq * generators, int lineno, int col_offset,
             PyArena *arena)
{
        expr_ty p;
        if (!elt) {
                PyErr_SetString(PyExc_ValueError,
                                "field elt is required for GeneratorExp");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = GeneratorExp_kind;
        p->v.GeneratorExp.elt = elt;
        p->v.GeneratorExp.generators = generators;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Yield(expr_ty value, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Yield_kind;
        p->v.Yield.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Compare(expr_ty left, asdl_int_seq * ops, asdl_seq * comparators, int lineno,
        int col_offset, PyArena *arena)
{
        expr_ty p;
        if (!left) {
                PyErr_SetString(PyExc_ValueError,
                                "field left is required for Compare");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Compare_kind;
        p->v.Compare.left = left;
        p->v.Compare.ops = ops;
        p->v.Compare.comparators = comparators;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Call(expr_ty func, asdl_seq * args, asdl_seq * keywords, expr_ty starargs,
     expr_ty kwargs, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        if (!func) {
                PyErr_SetString(PyExc_ValueError,
                                "field func is required for Call");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Call_kind;
        p->v.Call.func = func;
        p->v.Call.args = args;
        p->v.Call.keywords = keywords;
        p->v.Call.starargs = starargs;
        p->v.Call.kwargs = kwargs;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Repr(expr_ty value, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Repr");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Repr_kind;
        p->v.Repr.value = value;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Num(object n, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        if (!n) {
                PyErr_SetString(PyExc_ValueError,
                                "field n is required for Num");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Num_kind;
        p->v.Num.n = n;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Str(string s, int lineno, int col_offset, PyArena *arena)
{
        expr_ty p;
        if (!s) {
                PyErr_SetString(PyExc_ValueError,
                                "field s is required for Str");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Str_kind;
        p->v.Str.s = s;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Attribute(expr_ty value, identifier attr, expr_context_ty ctx, int lineno, int
          col_offset, PyArena *arena)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Attribute");
                return NULL;
        }
        if (!attr) {
                PyErr_SetString(PyExc_ValueError,
                                "field attr is required for Attribute");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Attribute");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Attribute_kind;
        p->v.Attribute.value = value;
        p->v.Attribute.attr = attr;
        p->v.Attribute.ctx = ctx;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Subscript(expr_ty value, slice_ty slice, expr_context_ty ctx, int lineno, int
          col_offset, PyArena *arena)
{
        expr_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Subscript");
                return NULL;
        }
        if (!slice) {
                PyErr_SetString(PyExc_ValueError,
                                "field slice is required for Subscript");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Subscript");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Subscript_kind;
        p->v.Subscript.value = value;
        p->v.Subscript.slice = slice;
        p->v.Subscript.ctx = ctx;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Name(identifier id, expr_context_ty ctx, int lineno, int col_offset, PyArena
     *arena)
{
        expr_ty p;
        if (!id) {
                PyErr_SetString(PyExc_ValueError,
                                "field id is required for Name");
                return NULL;
        }
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Name");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Name_kind;
        p->v.Name.id = id;
        p->v.Name.ctx = ctx;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
List(asdl_seq * elts, expr_context_ty ctx, int lineno, int col_offset, PyArena
     *arena)
{
        expr_ty p;
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for List");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = List_kind;
        p->v.List.elts = elts;
        p->v.List.ctx = ctx;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

expr_ty
Tuple(asdl_seq * elts, expr_context_ty ctx, int lineno, int col_offset, PyArena
      *arena)
{
        expr_ty p;
        if (!ctx) {
                PyErr_SetString(PyExc_ValueError,
                                "field ctx is required for Tuple");
                return NULL;
        }
        p = (expr_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Tuple_kind;
        p->v.Tuple.elts = elts;
        p->v.Tuple.ctx = ctx;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

slice_ty
Ellipsis(PyArena *arena)
{
        slice_ty p;
        p = (slice_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Ellipsis_kind;
        return p;
}

slice_ty
Slice(expr_ty lower, expr_ty upper, expr_ty step, PyArena *arena)
{
        slice_ty p;
        p = (slice_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Slice_kind;
        p->v.Slice.lower = lower;
        p->v.Slice.upper = upper;
        p->v.Slice.step = step;
        return p;
}

slice_ty
ExtSlice(asdl_seq * dims, PyArena *arena)
{
        slice_ty p;
        p = (slice_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = ExtSlice_kind;
        p->v.ExtSlice.dims = dims;
        return p;
}

slice_ty
Index(expr_ty value, PyArena *arena)
{
        slice_ty p;
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for Index");
                return NULL;
        }
        p = (slice_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = Index_kind;
        p->v.Index.value = value;
        return p;
}

comprehension_ty
comprehension(expr_ty target, expr_ty iter, asdl_seq * ifs, PyArena *arena)
{
        comprehension_ty p;
        if (!target) {
                PyErr_SetString(PyExc_ValueError,
                                "field target is required for comprehension");
                return NULL;
        }
        if (!iter) {
                PyErr_SetString(PyExc_ValueError,
                                "field iter is required for comprehension");
                return NULL;
        }
        p = (comprehension_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->target = target;
        p->iter = iter;
        p->ifs = ifs;
        return p;
}

excepthandler_ty
ExceptHandler(expr_ty type, expr_ty name, asdl_seq * body, int lineno, int
              col_offset, PyArena *arena)
{
        excepthandler_ty p;
        p = (excepthandler_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->kind = ExceptHandler_kind;
        p->v.ExceptHandler.type = type;
        p->v.ExceptHandler.name = name;
        p->v.ExceptHandler.body = body;
        p->lineno = lineno;
        p->col_offset = col_offset;
        return p;
}

arguments_ty
arguments(asdl_seq * args, identifier vararg, identifier kwarg, asdl_seq *
          defaults, PyArena *arena)
{
        arguments_ty p;
        p = (arguments_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->args = args;
        p->vararg = vararg;
        p->kwarg = kwarg;
        p->defaults = defaults;
        return p;
}

keyword_ty
keyword(identifier arg, expr_ty value, PyArena *arena)
{
        keyword_ty p;
        if (!arg) {
                PyErr_SetString(PyExc_ValueError,
                                "field arg is required for keyword");
                return NULL;
        }
        if (!value) {
                PyErr_SetString(PyExc_ValueError,
                                "field value is required for keyword");
                return NULL;
        }
        p = (keyword_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->arg = arg;
        p->value = value;
        return p;
}

alias_ty
alias(identifier name, identifier asname, PyArena *arena)
{
        alias_ty p;
        if (!name) {
                PyErr_SetString(PyExc_ValueError,
                                "field name is required for alias");
                return NULL;
        }
        p = (alias_ty)PyArena_Malloc(arena, sizeof(*p));
        if (!p)
                return NULL;
        p->name = name;
        p->asname = asname;
        return p;
}


PyObject*
ast2obj_mod(void* _o)
{
        mod_ty o = (mod_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        switch (o->kind) {
        case Module_kind:
                result = PyType_GenericNew(Module_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Module.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Interactive_kind:
                result = PyType_GenericNew(Interactive_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Interactive.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Expression_kind:
                result = PyType_GenericNew(Expression_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Expression.body);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Suite_kind:
                result = PyType_GenericNew(Suite_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Suite.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        }
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_stmt(void* _o)
{
        stmt_ty o = (stmt_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        switch (o->kind) {
        case FunctionDef_kind:
                result = PyType_GenericNew(FunctionDef_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_identifier(o->v.FunctionDef.name);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "name", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_arguments(o->v.FunctionDef.args);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "args", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.FunctionDef.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.FunctionDef.decorator_list,
                                     ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "decorator_list", value) ==
                    -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case ClassDef_kind:
                result = PyType_GenericNew(ClassDef_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_identifier(o->v.ClassDef.name);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "name", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ClassDef.bases, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "bases", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ClassDef.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ClassDef.decorator_list,
                                     ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "decorator_list", value) ==
                    -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Return_kind:
                result = PyType_GenericNew(Return_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Return.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Delete_kind:
                result = PyType_GenericNew(Delete_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Delete.targets, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "targets", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Assign_kind:
                result = PyType_GenericNew(Assign_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Assign.targets, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "targets", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Assign.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case AugAssign_kind:
                result = PyType_GenericNew(AugAssign_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.AugAssign.target);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "target", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_operator(o->v.AugAssign.op);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "op", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.AugAssign.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Print_kind:
                result = PyType_GenericNew(Print_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Print.dest);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "dest", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.Print.values, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "values", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_bool(o->v.Print.nl);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "nl", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case For_kind:
                result = PyType_GenericNew(For_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.For.target);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "target", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.For.iter);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "iter", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.For.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.For.orelse, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "orelse", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case While_kind:
                result = PyType_GenericNew(While_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.While.test);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "test", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.While.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.While.orelse, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "orelse", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case If_kind:
                result = PyType_GenericNew(If_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.If.test);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "test", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.If.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.If.orelse, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "orelse", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case With_kind:
                result = PyType_GenericNew(With_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.With.context_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "context_expr", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.With.optional_vars);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "optional_vars", value) ==
                    -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.With.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Raise_kind:
                result = PyType_GenericNew(Raise_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Raise.type);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "type", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Raise.inst);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "inst", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Raise.tback);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "tback", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case TryExcept_kind:
                result = PyType_GenericNew(TryExcept_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.TryExcept.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.TryExcept.handlers,
                                     ast2obj_excepthandler);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "handlers", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.TryExcept.orelse, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "orelse", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case TryFinally_kind:
                result = PyType_GenericNew(TryFinally_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.TryFinally.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.TryFinally.finalbody, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "finalbody", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Assert_kind:
                result = PyType_GenericNew(Assert_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Assert.test);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "test", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Assert.msg);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "msg", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Import_kind:
                result = PyType_GenericNew(Import_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Import.names, ast2obj_alias);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "names", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case ImportFrom_kind:
                result = PyType_GenericNew(ImportFrom_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_identifier(o->v.ImportFrom.module);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "module", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ImportFrom.names, ast2obj_alias);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "names", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_int(o->v.ImportFrom.level);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "level", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Exec_kind:
                result = PyType_GenericNew(Exec_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Exec.body);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Exec.globals);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "globals", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Exec.locals);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "locals", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Global_kind:
                result = PyType_GenericNew(Global_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Global.names, ast2obj_identifier);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "names", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Expr_kind:
                result = PyType_GenericNew(Expr_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Expr.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Pass_kind:
                result = PyType_GenericNew(Pass_type, NULL, NULL);
                if (!result) goto failed;
                break;
        case Break_kind:
                result = PyType_GenericNew(Break_type, NULL, NULL);
                if (!result) goto failed;
                break;
        case Continue_kind:
                result = PyType_GenericNew(Continue_type, NULL, NULL);
                if (!result) goto failed;
                break;
        }
        value = ast2obj_int(o->lineno);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "lineno", value) < 0)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_int(o->col_offset);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "col_offset", value) < 0)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_expr(void* _o)
{
        expr_ty o = (expr_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        switch (o->kind) {
        case BoolOp_kind:
                result = PyType_GenericNew(BoolOp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_boolop(o->v.BoolOp.op);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "op", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.BoolOp.values, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "values", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case BinOp_kind:
                result = PyType_GenericNew(BinOp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.BinOp.left);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "left", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_operator(o->v.BinOp.op);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "op", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.BinOp.right);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "right", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case UnaryOp_kind:
                result = PyType_GenericNew(UnaryOp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_unaryop(o->v.UnaryOp.op);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "op", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.UnaryOp.operand);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "operand", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Lambda_kind:
                result = PyType_GenericNew(Lambda_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_arguments(o->v.Lambda.args);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "args", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Lambda.body);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case IfExp_kind:
                result = PyType_GenericNew(IfExp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.IfExp.test);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "test", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.IfExp.body);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.IfExp.orelse);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "orelse", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Dict_kind:
                result = PyType_GenericNew(Dict_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Dict.keys, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "keys", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.Dict.values, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "values", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Set_kind:
                result = PyType_GenericNew(Set_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Set.elts, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elts", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case ListComp_kind:
                result = PyType_GenericNew(ListComp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.ListComp.elt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elt", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ListComp.generators,
                                     ast2obj_comprehension);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "generators", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case SetComp_kind:
                result = PyType_GenericNew(SetComp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.SetComp.elt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elt", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.SetComp.generators,
                                     ast2obj_comprehension);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "generators", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case DictComp_kind:
                result = PyType_GenericNew(DictComp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.DictComp.key);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "key", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.DictComp.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.DictComp.generators,
                                     ast2obj_comprehension);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "generators", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case GeneratorExp_kind:
                result = PyType_GenericNew(GeneratorExp_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.GeneratorExp.elt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elt", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.GeneratorExp.generators,
                                     ast2obj_comprehension);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "generators", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Yield_kind:
                result = PyType_GenericNew(Yield_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Yield.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Compare_kind:
                result = PyType_GenericNew(Compare_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Compare.left);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "left", value) == -1)
                        goto failed;
                Py_DECREF(value);
                {
                        int i, n = asdl_seq_LEN(o->v.Compare.ops);
                        value = PyList_New(n);
                        if (!value) goto failed;
                        for(i = 0; i < n; i++)
                                PyList_SET_ITEM(value, i, ast2obj_cmpop((cmpop_ty)asdl_seq_GET(o->v.Compare.ops, i)));
                }
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ops", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.Compare.comparators, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "comparators", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Call_kind:
                result = PyType_GenericNew(Call_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Call.func);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "func", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.Call.args, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "args", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.Call.keywords, ast2obj_keyword);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "keywords", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Call.starargs);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "starargs", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Call.kwargs);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "kwargs", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Repr_kind:
                result = PyType_GenericNew(Repr_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Repr.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Num_kind:
                result = PyType_GenericNew(Num_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_object(o->v.Num.n);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "n", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Str_kind:
                result = PyType_GenericNew(Str_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_string(o->v.Str.s);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "s", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Attribute_kind:
                result = PyType_GenericNew(Attribute_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Attribute.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_identifier(o->v.Attribute.attr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "attr", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr_context(o->v.Attribute.ctx);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ctx", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Subscript_kind:
                result = PyType_GenericNew(Subscript_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Subscript.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_slice(o->v.Subscript.slice);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "slice", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr_context(o->v.Subscript.ctx);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ctx", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Name_kind:
                result = PyType_GenericNew(Name_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_identifier(o->v.Name.id);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "id", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr_context(o->v.Name.ctx);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ctx", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case List_kind:
                result = PyType_GenericNew(List_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.List.elts, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elts", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr_context(o->v.List.ctx);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ctx", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Tuple_kind:
                result = PyType_GenericNew(Tuple_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.Tuple.elts, ast2obj_expr);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "elts", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr_context(o->v.Tuple.ctx);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "ctx", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        }
        value = ast2obj_int(o->lineno);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "lineno", value) < 0)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_int(o->col_offset);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "col_offset", value) < 0)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject* ast2obj_expr_context(expr_context_ty o)
{
        switch(o) {
                case Load:
                        Py_INCREF(Load_singleton);
                        return Load_singleton;
                case Store:
                        Py_INCREF(Store_singleton);
                        return Store_singleton;
                case Del:
                        Py_INCREF(Del_singleton);
                        return Del_singleton;
                case AugLoad:
                        Py_INCREF(AugLoad_singleton);
                        return AugLoad_singleton;
                case AugStore:
                        Py_INCREF(AugStore_singleton);
                        return AugStore_singleton;
                case Param:
                        Py_INCREF(Param_singleton);
                        return Param_singleton;
                default:
                        /* should never happen, but just in case ... */
                        PyErr_Format(PyExc_SystemError, "unknown expr_context found");
                        return NULL;
        }
}
PyObject*
ast2obj_slice(void* _o)
{
        slice_ty o = (slice_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        switch (o->kind) {
        case Ellipsis_kind:
                result = PyType_GenericNew(Ellipsis_type, NULL, NULL);
                if (!result) goto failed;
                break;
        case Slice_kind:
                result = PyType_GenericNew(Slice_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Slice.lower);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "lower", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Slice.upper);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "upper", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.Slice.step);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "step", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case ExtSlice_kind:
                result = PyType_GenericNew(ExtSlice_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_list(o->v.ExtSlice.dims, ast2obj_slice);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "dims", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        case Index_kind:
                result = PyType_GenericNew(Index_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.Index.value);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "value", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        }
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject* ast2obj_boolop(boolop_ty o)
{
        switch(o) {
                case And:
                        Py_INCREF(And_singleton);
                        return And_singleton;
                case Or:
                        Py_INCREF(Or_singleton);
                        return Or_singleton;
                default:
                        /* should never happen, but just in case ... */
                        PyErr_Format(PyExc_SystemError, "unknown boolop found");
                        return NULL;
        }
}
PyObject* ast2obj_operator(operator_ty o)
{
        switch(o) {
                case Add:
                        Py_INCREF(Add_singleton);
                        return Add_singleton;
                case Sub:
                        Py_INCREF(Sub_singleton);
                        return Sub_singleton;
                case Mult:
                        Py_INCREF(Mult_singleton);
                        return Mult_singleton;
                case Div:
                        Py_INCREF(Div_singleton);
                        return Div_singleton;
                case Mod:
                        Py_INCREF(Mod_singleton);
                        return Mod_singleton;
                case Pow:
                        Py_INCREF(Pow_singleton);
                        return Pow_singleton;
                case LShift:
                        Py_INCREF(LShift_singleton);
                        return LShift_singleton;
                case RShift:
                        Py_INCREF(RShift_singleton);
                        return RShift_singleton;
                case BitOr:
                        Py_INCREF(BitOr_singleton);
                        return BitOr_singleton;
                case BitXor:
                        Py_INCREF(BitXor_singleton);
                        return BitXor_singleton;
                case BitAnd:
                        Py_INCREF(BitAnd_singleton);
                        return BitAnd_singleton;
                case FloorDiv:
                        Py_INCREF(FloorDiv_singleton);
                        return FloorDiv_singleton;
                default:
                        /* should never happen, but just in case ... */
                        PyErr_Format(PyExc_SystemError, "unknown operator found");
                        return NULL;
        }
}
PyObject* ast2obj_unaryop(unaryop_ty o)
{
        switch(o) {
                case Invert:
                        Py_INCREF(Invert_singleton);
                        return Invert_singleton;
                case Not:
                        Py_INCREF(Not_singleton);
                        return Not_singleton;
                case UAdd:
                        Py_INCREF(UAdd_singleton);
                        return UAdd_singleton;
                case USub:
                        Py_INCREF(USub_singleton);
                        return USub_singleton;
                default:
                        /* should never happen, but just in case ... */
                        PyErr_Format(PyExc_SystemError, "unknown unaryop found");
                        return NULL;
        }
}
PyObject* ast2obj_cmpop(cmpop_ty o)
{
        switch(o) {
                case Eq:
                        Py_INCREF(Eq_singleton);
                        return Eq_singleton;
                case NotEq:
                        Py_INCREF(NotEq_singleton);
                        return NotEq_singleton;
                case Lt:
                        Py_INCREF(Lt_singleton);
                        return Lt_singleton;
                case LtE:
                        Py_INCREF(LtE_singleton);
                        return LtE_singleton;
                case Gt:
                        Py_INCREF(Gt_singleton);
                        return Gt_singleton;
                case GtE:
                        Py_INCREF(GtE_singleton);
                        return GtE_singleton;
                case Is:
                        Py_INCREF(Is_singleton);
                        return Is_singleton;
                case IsNot:
                        Py_INCREF(IsNot_singleton);
                        return IsNot_singleton;
                case In:
                        Py_INCREF(In_singleton);
                        return In_singleton;
                case NotIn:
                        Py_INCREF(NotIn_singleton);
                        return NotIn_singleton;
                default:
                        /* should never happen, but just in case ... */
                        PyErr_Format(PyExc_SystemError, "unknown cmpop found");
                        return NULL;
        }
}
PyObject*
ast2obj_comprehension(void* _o)
{
        comprehension_ty o = (comprehension_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        result = PyType_GenericNew(comprehension_type, NULL, NULL);
        if (!result) return NULL;
        value = ast2obj_expr(o->target);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "target", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_expr(o->iter);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "iter", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_list(o->ifs, ast2obj_expr);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "ifs", value) == -1)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_excepthandler(void* _o)
{
        excepthandler_ty o = (excepthandler_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        switch (o->kind) {
        case ExceptHandler_kind:
                result = PyType_GenericNew(ExceptHandler_type, NULL, NULL);
                if (!result) goto failed;
                value = ast2obj_expr(o->v.ExceptHandler.type);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "type", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_expr(o->v.ExceptHandler.name);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "name", value) == -1)
                        goto failed;
                Py_DECREF(value);
                value = ast2obj_list(o->v.ExceptHandler.body, ast2obj_stmt);
                if (!value) goto failed;
                if (PyObject_SetAttrString(result, "body", value) == -1)
                        goto failed;
                Py_DECREF(value);
                break;
        }
        value = ast2obj_int(o->lineno);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "lineno", value) < 0)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_int(o->col_offset);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "col_offset", value) < 0)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_arguments(void* _o)
{
        arguments_ty o = (arguments_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        result = PyType_GenericNew(arguments_type, NULL, NULL);
        if (!result) return NULL;
        value = ast2obj_list(o->args, ast2obj_expr);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "args", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_identifier(o->vararg);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "vararg", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_identifier(o->kwarg);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "kwarg", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_list(o->defaults, ast2obj_expr);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "defaults", value) == -1)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_keyword(void* _o)
{
        keyword_ty o = (keyword_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        result = PyType_GenericNew(keyword_type, NULL, NULL);
        if (!result) return NULL;
        value = ast2obj_identifier(o->arg);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "arg", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_expr(o->value);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "value", value) == -1)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}

PyObject*
ast2obj_alias(void* _o)
{
        alias_ty o = (alias_ty)_o;
        PyObject *result = NULL, *value = NULL;
        if (!o) {
                Py_INCREF(Py_None);
                return Py_None;
        }

        result = PyType_GenericNew(alias_type, NULL, NULL);
        if (!result) return NULL;
        value = ast2obj_identifier(o->name);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "name", value) == -1)
                goto failed;
        Py_DECREF(value);
        value = ast2obj_identifier(o->asname);
        if (!value) goto failed;
        if (PyObject_SetAttrString(result, "asname", value) == -1)
                goto failed;
        Py_DECREF(value);
        return result;
failed:
        Py_XDECREF(value);
        Py_XDECREF(result);
        return NULL;
}


int
obj2ast_mod(PyObject* obj, mod_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;


        if (obj == Py_None) {
                *out = NULL;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Module_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* body;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Module field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Module");
                        return 1;
                }
                *out = Module(body, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Interactive_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* body;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Interactive field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Interactive");
                        return 1;
                }
                *out = Interactive(body, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Expression_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty body;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &body, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Expression");
                        return 1;
                }
                *out = Expression(body, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Suite_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* body;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Suite field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Suite");
                        return 1;
                }
                *out = Suite(body, arena);
                if (*out == NULL) goto failed;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of mod, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_stmt(PyObject* obj, stmt_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        int lineno;
        int col_offset;

        if (obj == Py_None) {
                *out = NULL;
                return 0;
        }
        if (PyObject_HasAttrString(obj, "lineno")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "lineno");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &lineno, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"lineno\" missing from stmt");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "col_offset")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "col_offset");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &col_offset, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"col_offset\" missing from stmt");
                return 1;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)FunctionDef_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                identifier name;
                arguments_ty args;
                asdl_seq* body;
                asdl_seq* decorator_list;

                if (PyObject_HasAttrString(obj, "name")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "name");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_identifier(tmp, &name, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"name\" missing from FunctionDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "args")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "args");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_arguments(tmp, &args, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"args\" missing from FunctionDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "FunctionDef field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from FunctionDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "decorator_list")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "decorator_list");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "FunctionDef field \"decorator_list\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        decorator_list = asdl_seq_new((int)len, arena);
                        if (decorator_list == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(decorator_list, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"decorator_list\" missing from FunctionDef");
                        return 1;
                }
                *out = FunctionDef(name, args, body, decorator_list, lineno,
                                   col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)ClassDef_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                identifier name;
                asdl_seq* bases;
                asdl_seq* body;
                asdl_seq* decorator_list;

                if (PyObject_HasAttrString(obj, "name")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "name");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_identifier(tmp, &name, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"name\" missing from ClassDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "bases")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "bases");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ClassDef field \"bases\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        bases = asdl_seq_new((int)len, arena);
                        if (bases == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(bases, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"bases\" missing from ClassDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ClassDef field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from ClassDef");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "decorator_list")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "decorator_list");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ClassDef field \"decorator_list\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        decorator_list = asdl_seq_new((int)len, arena);
                        if (decorator_list == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(decorator_list, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"decorator_list\" missing from ClassDef");
                        return 1;
                }
                *out = ClassDef(name, bases, body, decorator_list, lineno,
                                col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Return_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        value = NULL;
                }
                *out = Return(value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Delete_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* targets;

                if (PyObject_HasAttrString(obj, "targets")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "targets");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Delete field \"targets\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        targets = asdl_seq_new((int)len, arena);
                        if (targets == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(targets, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"targets\" missing from Delete");
                        return 1;
                }
                *out = Delete(targets, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Assign_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* targets;
                expr_ty value;

                if (PyObject_HasAttrString(obj, "targets")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "targets");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Assign field \"targets\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        targets = asdl_seq_new((int)len, arena);
                        if (targets == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(targets, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"targets\" missing from Assign");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Assign");
                        return 1;
                }
                *out = Assign(targets, value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)AugAssign_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty target;
                operator_ty op;
                expr_ty value;

                if (PyObject_HasAttrString(obj, "target")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "target");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &target, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"target\" missing from AugAssign");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "op")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "op");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_operator(tmp, &op, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"op\" missing from AugAssign");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from AugAssign");
                        return 1;
                }
                *out = AugAssign(target, op, value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Print_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty dest;
                asdl_seq* values;
                bool nl;

                if (PyObject_HasAttrString(obj, "dest")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "dest");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &dest, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        dest = NULL;
                }
                if (PyObject_HasAttrString(obj, "values")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "values");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Print field \"values\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        values = asdl_seq_new((int)len, arena);
                        if (values == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(values, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"values\" missing from Print");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "nl")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "nl");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_bool(tmp, &nl, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"nl\" missing from Print");
                        return 1;
                }
                *out = Print(dest, values, nl, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)For_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty target;
                expr_ty iter;
                asdl_seq* body;
                asdl_seq* orelse;

                if (PyObject_HasAttrString(obj, "target")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "target");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &target, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"target\" missing from For");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "iter")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "iter");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &iter, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"iter\" missing from For");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "For field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from For");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "orelse")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "orelse");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "For field \"orelse\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        orelse = asdl_seq_new((int)len, arena);
                        if (orelse == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(orelse, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"orelse\" missing from For");
                        return 1;
                }
                *out = For(target, iter, body, orelse, lineno, col_offset,
                           arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)While_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty test;
                asdl_seq* body;
                asdl_seq* orelse;

                if (PyObject_HasAttrString(obj, "test")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "test");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &test, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"test\" missing from While");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "While field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from While");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "orelse")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "orelse");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "While field \"orelse\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        orelse = asdl_seq_new((int)len, arena);
                        if (orelse == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(orelse, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"orelse\" missing from While");
                        return 1;
                }
                *out = While(test, body, orelse, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)If_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty test;
                asdl_seq* body;
                asdl_seq* orelse;

                if (PyObject_HasAttrString(obj, "test")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "test");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &test, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"test\" missing from If");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "If field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from If");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "orelse")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "orelse");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "If field \"orelse\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        orelse = asdl_seq_new((int)len, arena);
                        if (orelse == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(orelse, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"orelse\" missing from If");
                        return 1;
                }
                *out = If(test, body, orelse, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)With_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty context_expr;
                expr_ty optional_vars;
                asdl_seq* body;

                if (PyObject_HasAttrString(obj, "context_expr")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "context_expr");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &context_expr, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"context_expr\" missing from With");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "optional_vars")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "optional_vars");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &optional_vars, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        optional_vars = NULL;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "With field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from With");
                        return 1;
                }
                *out = With(context_expr, optional_vars, body, lineno,
                            col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Raise_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty type;
                expr_ty inst;
                expr_ty tback;

                if (PyObject_HasAttrString(obj, "type")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "type");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &type, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        type = NULL;
                }
                if (PyObject_HasAttrString(obj, "inst")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "inst");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &inst, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        inst = NULL;
                }
                if (PyObject_HasAttrString(obj, "tback")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "tback");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &tback, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        tback = NULL;
                }
                *out = Raise(type, inst, tback, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)TryExcept_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* body;
                asdl_seq* handlers;
                asdl_seq* orelse;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "TryExcept field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from TryExcept");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "handlers")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "handlers");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "TryExcept field \"handlers\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        handlers = asdl_seq_new((int)len, arena);
                        if (handlers == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                excepthandler_ty value;
                                res = obj2ast_excepthandler(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(handlers, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"handlers\" missing from TryExcept");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "orelse")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "orelse");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "TryExcept field \"orelse\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        orelse = asdl_seq_new((int)len, arena);
                        if (orelse == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(orelse, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"orelse\" missing from TryExcept");
                        return 1;
                }
                *out = TryExcept(body, handlers, orelse, lineno, col_offset,
                                 arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)TryFinally_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* body;
                asdl_seq* finalbody;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "TryFinally field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from TryFinally");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "finalbody")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "finalbody");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "TryFinally field \"finalbody\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        finalbody = asdl_seq_new((int)len, arena);
                        if (finalbody == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(finalbody, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"finalbody\" missing from TryFinally");
                        return 1;
                }
                *out = TryFinally(body, finalbody, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Assert_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty test;
                expr_ty msg;

                if (PyObject_HasAttrString(obj, "test")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "test");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &test, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"test\" missing from Assert");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "msg")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "msg");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &msg, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        msg = NULL;
                }
                *out = Assert(test, msg, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Import_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* names;

                if (PyObject_HasAttrString(obj, "names")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "names");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Import field \"names\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        names = asdl_seq_new((int)len, arena);
                        if (names == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                alias_ty value;
                                res = obj2ast_alias(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(names, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"names\" missing from Import");
                        return 1;
                }
                *out = Import(names, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)ImportFrom_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                identifier module;
                asdl_seq* names;
                int level;

                if (PyObject_HasAttrString(obj, "module")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "module");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_identifier(tmp, &module, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        module = NULL;
                }
                if (PyObject_HasAttrString(obj, "names")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "names");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ImportFrom field \"names\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        names = asdl_seq_new((int)len, arena);
                        if (names == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                alias_ty value;
                                res = obj2ast_alias(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(names, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"names\" missing from ImportFrom");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "level")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "level");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_int(tmp, &level, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        level = 0;
                }
                *out = ImportFrom(module, names, level, lineno, col_offset,
                                  arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Exec_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty body;
                expr_ty globals;
                expr_ty locals;

                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &body, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Exec");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "globals")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "globals");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &globals, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        globals = NULL;
                }
                if (PyObject_HasAttrString(obj, "locals")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "locals");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &locals, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        locals = NULL;
                }
                *out = Exec(body, globals, locals, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Global_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* names;

                if (PyObject_HasAttrString(obj, "names")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "names");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Global field \"names\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        names = asdl_seq_new((int)len, arena);
                        if (names == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                identifier value;
                                res = obj2ast_identifier(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(names, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"names\" missing from Global");
                        return 1;
                }
                *out = Global(names, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Expr_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Expr");
                        return 1;
                }
                *out = Expr(value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Pass_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {

                *out = Pass(lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Break_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {

                *out = Break(lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Continue_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {

                *out = Continue(lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of stmt, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_expr(PyObject* obj, expr_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        int lineno;
        int col_offset;

        if (obj == Py_None) {
                *out = NULL;
                return 0;
        }
        if (PyObject_HasAttrString(obj, "lineno")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "lineno");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &lineno, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"lineno\" missing from expr");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "col_offset")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "col_offset");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &col_offset, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"col_offset\" missing from expr");
                return 1;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)BoolOp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                boolop_ty op;
                asdl_seq* values;

                if (PyObject_HasAttrString(obj, "op")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "op");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_boolop(tmp, &op, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"op\" missing from BoolOp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "values")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "values");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "BoolOp field \"values\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        values = asdl_seq_new((int)len, arena);
                        if (values == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(values, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"values\" missing from BoolOp");
                        return 1;
                }
                *out = BoolOp(op, values, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)BinOp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty left;
                operator_ty op;
                expr_ty right;

                if (PyObject_HasAttrString(obj, "left")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "left");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &left, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"left\" missing from BinOp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "op")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "op");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_operator(tmp, &op, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"op\" missing from BinOp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "right")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "right");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &right, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"right\" missing from BinOp");
                        return 1;
                }
                *out = BinOp(left, op, right, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)UnaryOp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                unaryop_ty op;
                expr_ty operand;

                if (PyObject_HasAttrString(obj, "op")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "op");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_unaryop(tmp, &op, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"op\" missing from UnaryOp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "operand")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "operand");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &operand, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"operand\" missing from UnaryOp");
                        return 1;
                }
                *out = UnaryOp(op, operand, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Lambda_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                arguments_ty args;
                expr_ty body;

                if (PyObject_HasAttrString(obj, "args")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "args");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_arguments(tmp, &args, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"args\" missing from Lambda");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &body, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from Lambda");
                        return 1;
                }
                *out = Lambda(args, body, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)IfExp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty test;
                expr_ty body;
                expr_ty orelse;

                if (PyObject_HasAttrString(obj, "test")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "test");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &test, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"test\" missing from IfExp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &body, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from IfExp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "orelse")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "orelse");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &orelse, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"orelse\" missing from IfExp");
                        return 1;
                }
                *out = IfExp(test, body, orelse, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Dict_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* keys;
                asdl_seq* values;

                if (PyObject_HasAttrString(obj, "keys")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "keys");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Dict field \"keys\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        keys = asdl_seq_new((int)len, arena);
                        if (keys == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(keys, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"keys\" missing from Dict");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "values")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "values");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Dict field \"values\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        values = asdl_seq_new((int)len, arena);
                        if (values == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(values, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"values\" missing from Dict");
                        return 1;
                }
                *out = Dict(keys, values, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Set_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* elts;

                if (PyObject_HasAttrString(obj, "elts")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "elts");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Set field \"elts\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        elts = asdl_seq_new((int)len, arena);
                        if (elts == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(elts, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elts\" missing from Set");
                        return 1;
                }
                *out = Set(elts, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)ListComp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty elt;
                asdl_seq* generators;

                if (PyObject_HasAttrString(obj, "elt")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "elt");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &elt, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elt\" missing from ListComp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "generators")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "generators");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ListComp field \"generators\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        generators = asdl_seq_new((int)len, arena);
                        if (generators == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                comprehension_ty value;
                                res = obj2ast_comprehension(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(generators, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"generators\" missing from ListComp");
                        return 1;
                }
                *out = ListComp(elt, generators, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)SetComp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty elt;
                asdl_seq* generators;

                if (PyObject_HasAttrString(obj, "elt")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "elt");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &elt, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elt\" missing from SetComp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "generators")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "generators");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "SetComp field \"generators\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        generators = asdl_seq_new((int)len, arena);
                        if (generators == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                comprehension_ty value;
                                res = obj2ast_comprehension(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(generators, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"generators\" missing from SetComp");
                        return 1;
                }
                *out = SetComp(elt, generators, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)DictComp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty key;
                expr_ty value;
                asdl_seq* generators;

                if (PyObject_HasAttrString(obj, "key")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "key");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &key, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"key\" missing from DictComp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from DictComp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "generators")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "generators");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "DictComp field \"generators\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        generators = asdl_seq_new((int)len, arena);
                        if (generators == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                comprehension_ty value;
                                res = obj2ast_comprehension(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(generators, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"generators\" missing from DictComp");
                        return 1;
                }
                *out = DictComp(key, value, generators, lineno, col_offset,
                                arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)GeneratorExp_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty elt;
                asdl_seq* generators;

                if (PyObject_HasAttrString(obj, "elt")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "elt");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &elt, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elt\" missing from GeneratorExp");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "generators")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "generators");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "GeneratorExp field \"generators\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        generators = asdl_seq_new((int)len, arena);
                        if (generators == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                comprehension_ty value;
                                res = obj2ast_comprehension(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(generators, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"generators\" missing from GeneratorExp");
                        return 1;
                }
                *out = GeneratorExp(elt, generators, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Yield_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        value = NULL;
                }
                *out = Yield(value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Compare_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty left;
                asdl_int_seq* ops;
                asdl_seq* comparators;

                if (PyObject_HasAttrString(obj, "left")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "left");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &left, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"left\" missing from Compare");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ops")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "ops");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Compare field \"ops\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        ops = asdl_int_seq_new((int)len, arena);
                        if (ops == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                cmpop_ty value;
                                res = obj2ast_cmpop(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(ops, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ops\" missing from Compare");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "comparators")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "comparators");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Compare field \"comparators\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        comparators = asdl_seq_new((int)len, arena);
                        if (comparators == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(comparators, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"comparators\" missing from Compare");
                        return 1;
                }
                *out = Compare(left, ops, comparators, lineno, col_offset,
                               arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Call_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty func;
                asdl_seq* args;
                asdl_seq* keywords;
                expr_ty starargs;
                expr_ty kwargs;

                if (PyObject_HasAttrString(obj, "func")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "func");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &func, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"func\" missing from Call");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "args")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "args");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Call field \"args\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        args = asdl_seq_new((int)len, arena);
                        if (args == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(args, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"args\" missing from Call");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "keywords")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "keywords");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Call field \"keywords\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        keywords = asdl_seq_new((int)len, arena);
                        if (keywords == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                keyword_ty value;
                                res = obj2ast_keyword(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(keywords, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"keywords\" missing from Call");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "starargs")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "starargs");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &starargs, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        starargs = NULL;
                }
                if (PyObject_HasAttrString(obj, "kwargs")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "kwargs");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &kwargs, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        kwargs = NULL;
                }
                *out = Call(func, args, keywords, starargs, kwargs, lineno,
                            col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Repr_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Repr");
                        return 1;
                }
                *out = Repr(value, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Num_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                object n;

                if (PyObject_HasAttrString(obj, "n")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "n");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_object(tmp, &n, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"n\" missing from Num");
                        return 1;
                }
                *out = Num(n, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Str_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                string s;

                if (PyObject_HasAttrString(obj, "s")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "s");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_string(tmp, &s, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"s\" missing from Str");
                        return 1;
                }
                *out = Str(s, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Attribute_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;
                identifier attr;
                expr_context_ty ctx;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Attribute");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "attr")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "attr");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_identifier(tmp, &attr, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"attr\" missing from Attribute");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ctx")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "ctx");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr_context(tmp, &ctx, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ctx\" missing from Attribute");
                        return 1;
                }
                *out = Attribute(value, attr, ctx, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Subscript_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;
                slice_ty slice;
                expr_context_ty ctx;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Subscript");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "slice")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "slice");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_slice(tmp, &slice, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"slice\" missing from Subscript");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ctx")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "ctx");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr_context(tmp, &ctx, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ctx\" missing from Subscript");
                        return 1;
                }
                *out = Subscript(value, slice, ctx, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Name_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                identifier id;
                expr_context_ty ctx;

                if (PyObject_HasAttrString(obj, "id")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "id");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_identifier(tmp, &id, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"id\" missing from Name");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ctx")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "ctx");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr_context(tmp, &ctx, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ctx\" missing from Name");
                        return 1;
                }
                *out = Name(id, ctx, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)List_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* elts;
                expr_context_ty ctx;

                if (PyObject_HasAttrString(obj, "elts")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "elts");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "List field \"elts\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        elts = asdl_seq_new((int)len, arena);
                        if (elts == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(elts, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elts\" missing from List");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ctx")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "ctx");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr_context(tmp, &ctx, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ctx\" missing from List");
                        return 1;
                }
                *out = List(elts, ctx, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Tuple_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* elts;
                expr_context_ty ctx;

                if (PyObject_HasAttrString(obj, "elts")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "elts");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "Tuple field \"elts\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        elts = asdl_seq_new((int)len, arena);
                        if (elts == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                expr_ty value;
                                res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(elts, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"elts\" missing from Tuple");
                        return 1;
                }
                if (PyObject_HasAttrString(obj, "ctx")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "ctx");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr_context(tmp, &ctx, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"ctx\" missing from Tuple");
                        return 1;
                }
                *out = Tuple(elts, ctx, lineno, col_offset, arena);
                if (*out == NULL) goto failed;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of expr, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_expr_context(PyObject* obj, expr_context_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        isinstance = PyObject_IsInstance(obj, (PyObject *)Load_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Load;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Store_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Store;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Del_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Del;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)AugLoad_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = AugLoad;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)AugStore_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = AugStore;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Param_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Param;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of expr_context, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_slice(PyObject* obj, slice_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;


        if (obj == Py_None) {
                *out = NULL;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Ellipsis_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {

                *out = Ellipsis(arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Slice_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty lower;
                expr_ty upper;
                expr_ty step;

                if (PyObject_HasAttrString(obj, "lower")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "lower");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &lower, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        lower = NULL;
                }
                if (PyObject_HasAttrString(obj, "upper")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "upper");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &upper, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        upper = NULL;
                }
                if (PyObject_HasAttrString(obj, "step")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "step");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &step, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        step = NULL;
                }
                *out = Slice(lower, upper, step, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)ExtSlice_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                asdl_seq* dims;

                if (PyObject_HasAttrString(obj, "dims")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "dims");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ExtSlice field \"dims\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        dims = asdl_seq_new((int)len, arena);
                        if (dims == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                slice_ty value;
                                res = obj2ast_slice(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(dims, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"dims\" missing from ExtSlice");
                        return 1;
                }
                *out = ExtSlice(dims, arena);
                if (*out == NULL) goto failed;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)Index_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty value;

                if (PyObject_HasAttrString(obj, "value")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "value");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &value, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from Index");
                        return 1;
                }
                *out = Index(value, arena);
                if (*out == NULL) goto failed;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of slice, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_boolop(PyObject* obj, boolop_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        isinstance = PyObject_IsInstance(obj, (PyObject *)And_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = And;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Or_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Or;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of boolop, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_operator(PyObject* obj, operator_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        isinstance = PyObject_IsInstance(obj, (PyObject *)Add_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Add;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Sub_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Sub;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Mult_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Mult;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Div_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Div;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Mod_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Mod;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Pow_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Pow;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)LShift_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = LShift;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)RShift_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = RShift;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)BitOr_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = BitOr;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)BitXor_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = BitXor;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)BitAnd_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = BitAnd;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)FloorDiv_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = FloorDiv;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of operator, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_unaryop(PyObject* obj, unaryop_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        isinstance = PyObject_IsInstance(obj, (PyObject *)Invert_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Invert;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Not_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Not;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)UAdd_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = UAdd;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)USub_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = USub;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of unaryop, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_cmpop(PyObject* obj, cmpop_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        isinstance = PyObject_IsInstance(obj, (PyObject *)Eq_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Eq;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)NotEq_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = NotEq;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Lt_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Lt;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)LtE_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = LtE;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Gt_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Gt;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)GtE_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = GtE;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)Is_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = Is;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)IsNot_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = IsNot;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)In_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = In;
                return 0;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject *)NotIn_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                *out = NotIn;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of cmpop, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_comprehension(PyObject* obj, comprehension_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        expr_ty target;
        expr_ty iter;
        asdl_seq* ifs;

        if (PyObject_HasAttrString(obj, "target")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "target");
                if (tmp == NULL) goto failed;
                res = obj2ast_expr(tmp, &target, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"target\" missing from comprehension");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "iter")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "iter");
                if (tmp == NULL) goto failed;
                res = obj2ast_expr(tmp, &iter, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"iter\" missing from comprehension");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "ifs")) {
                int res;
                Py_ssize_t len;
                Py_ssize_t i;
                tmp = PyObject_GetAttrString(obj, "ifs");
                if (tmp == NULL) goto failed;
                if (!PyList_Check(tmp)) {
                        PyErr_Format(PyExc_TypeError, "comprehension field \"ifs\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                        goto failed;
                }
                len = PyList_GET_SIZE(tmp);
                ifs = asdl_seq_new((int)len, arena);
                if (ifs == NULL) goto failed;
                for (i = 0; i < len; i++) {
                        expr_ty value;
                        res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                        if (res != 0) goto failed;
                        asdl_seq_SET(ifs, i, value);
                }
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"ifs\" missing from comprehension");
                return 1;
        }
        *out = comprehension(target, iter, ifs, arena);
        return 0;
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_excepthandler(PyObject* obj, excepthandler_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        int isinstance;

        int lineno;
        int col_offset;

        if (obj == Py_None) {
                *out = NULL;
                return 0;
        }
        if (PyObject_HasAttrString(obj, "lineno")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "lineno");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &lineno, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"lineno\" missing from excepthandler");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "col_offset")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "col_offset");
                if (tmp == NULL) goto failed;
                res = obj2ast_int(tmp, &col_offset, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"col_offset\" missing from excepthandler");
                return 1;
        }
        isinstance = PyObject_IsInstance(obj, (PyObject*)ExceptHandler_type);
        if (isinstance == -1) {
                return 1;
        }
        if (isinstance) {
                expr_ty type;
                expr_ty name;
                asdl_seq* body;

                if (PyObject_HasAttrString(obj, "type")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "type");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &type, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        type = NULL;
                }
                if (PyObject_HasAttrString(obj, "name")) {
                        int res;
                        tmp = PyObject_GetAttrString(obj, "name");
                        if (tmp == NULL) goto failed;
                        res = obj2ast_expr(tmp, &name, arena);
                        if (res != 0) goto failed;
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        name = NULL;
                }
                if (PyObject_HasAttrString(obj, "body")) {
                        int res;
                        Py_ssize_t len;
                        Py_ssize_t i;
                        tmp = PyObject_GetAttrString(obj, "body");
                        if (tmp == NULL) goto failed;
                        if (!PyList_Check(tmp)) {
                                PyErr_Format(PyExc_TypeError, "ExceptHandler field \"body\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                                goto failed;
                        }
                        len = PyList_GET_SIZE(tmp);
                        body = asdl_seq_new((int)len, arena);
                        if (body == NULL) goto failed;
                        for (i = 0; i < len; i++) {
                                stmt_ty value;
                                res = obj2ast_stmt(PyList_GET_ITEM(tmp, i), &value, arena);
                                if (res != 0) goto failed;
                                asdl_seq_SET(body, i, value);
                        }
                        Py_XDECREF(tmp);
                        tmp = NULL;
                } else {
                        PyErr_SetString(PyExc_TypeError, "required field \"body\" missing from ExceptHandler");
                        return 1;
                }
                *out = ExceptHandler(type, name, body, lineno, col_offset,
                                     arena);
                if (*out == NULL) goto failed;
                return 0;
        }

        tmp = PyObject_Repr(obj);
        if (tmp == NULL) goto failed;
        PyErr_Format(PyExc_TypeError, "expected some sort of excepthandler, but got %.400s", PyString_AS_STRING(tmp));
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_arguments(PyObject* obj, arguments_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        asdl_seq* args;
        identifier vararg;
        identifier kwarg;
        asdl_seq* defaults;

        if (PyObject_HasAttrString(obj, "args")) {
                int res;
                Py_ssize_t len;
                Py_ssize_t i;
                tmp = PyObject_GetAttrString(obj, "args");
                if (tmp == NULL) goto failed;
                if (!PyList_Check(tmp)) {
                        PyErr_Format(PyExc_TypeError, "arguments field \"args\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                        goto failed;
                }
                len = PyList_GET_SIZE(tmp);
                args = asdl_seq_new((int)len, arena);
                if (args == NULL) goto failed;
                for (i = 0; i < len; i++) {
                        expr_ty value;
                        res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                        if (res != 0) goto failed;
                        asdl_seq_SET(args, i, value);
                }
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"args\" missing from arguments");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "vararg")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "vararg");
                if (tmp == NULL) goto failed;
                res = obj2ast_identifier(tmp, &vararg, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                vararg = NULL;
        }
        if (PyObject_HasAttrString(obj, "kwarg")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "kwarg");
                if (tmp == NULL) goto failed;
                res = obj2ast_identifier(tmp, &kwarg, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                kwarg = NULL;
        }
        if (PyObject_HasAttrString(obj, "defaults")) {
                int res;
                Py_ssize_t len;
                Py_ssize_t i;
                tmp = PyObject_GetAttrString(obj, "defaults");
                if (tmp == NULL) goto failed;
                if (!PyList_Check(tmp)) {
                        PyErr_Format(PyExc_TypeError, "arguments field \"defaults\" must be a list, not a %.200s", tmp->ob_type->tp_name);
                        goto failed;
                }
                len = PyList_GET_SIZE(tmp);
                defaults = asdl_seq_new((int)len, arena);
                if (defaults == NULL) goto failed;
                for (i = 0; i < len; i++) {
                        expr_ty value;
                        res = obj2ast_expr(PyList_GET_ITEM(tmp, i), &value, arena);
                        if (res != 0) goto failed;
                        asdl_seq_SET(defaults, i, value);
                }
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"defaults\" missing from arguments");
                return 1;
        }
        *out = arguments(args, vararg, kwarg, defaults, arena);
        return 0;
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_keyword(PyObject* obj, keyword_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        identifier arg;
        expr_ty value;

        if (PyObject_HasAttrString(obj, "arg")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "arg");
                if (tmp == NULL) goto failed;
                res = obj2ast_identifier(tmp, &arg, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"arg\" missing from keyword");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "value")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "value");
                if (tmp == NULL) goto failed;
                res = obj2ast_expr(tmp, &value, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"value\" missing from keyword");
                return 1;
        }
        *out = keyword(arg, value, arena);
        return 0;
failed:
        Py_XDECREF(tmp);
        return 1;
}

int
obj2ast_alias(PyObject* obj, alias_ty* out, PyArena* arena)
{
        PyObject* tmp = NULL;
        identifier name;
        identifier asname;

        if (PyObject_HasAttrString(obj, "name")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "name");
                if (tmp == NULL) goto failed;
                res = obj2ast_identifier(tmp, &name, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                PyErr_SetString(PyExc_TypeError, "required field \"name\" missing from alias");
                return 1;
        }
        if (PyObject_HasAttrString(obj, "asname")) {
                int res;
                tmp = PyObject_GetAttrString(obj, "asname");
                if (tmp == NULL) goto failed;
                res = obj2ast_identifier(tmp, &asname, arena);
                if (res != 0) goto failed;
                Py_XDECREF(tmp);
                tmp = NULL;
        } else {
                asname = NULL;
        }
        *out = alias(name, asname, arena);
        return 0;
failed:
        Py_XDECREF(tmp);
        return 1;
}


PyMODINIT_FUNC
init_ast(void)
{
        PyObject *m, *d;
        if (!init_types()) return;
        m = Py_InitModule3("_ast", NULL, NULL);
        if (!m) return;
        d = PyModule_GetDict(m);
        if (PyDict_SetItemString(d, "AST", (PyObject*)&AST_type) < 0) return;
        if (PyModule_AddIntConstant(m, "PyCF_ONLY_AST", PyCF_ONLY_AST) < 0)
                return;
        if (PyModule_AddStringConstant(m, "__version__", "82160") < 0)
                return;
        if (PyDict_SetItemString(d, "mod", (PyObject*)mod_type) < 0) return;
        if (PyDict_SetItemString(d, "Module", (PyObject*)Module_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Interactive", (PyObject*)Interactive_type)
            < 0) return;
        if (PyDict_SetItemString(d, "Expression", (PyObject*)Expression_type) <
            0) return;
        if (PyDict_SetItemString(d, "Suite", (PyObject*)Suite_type) < 0) return;
        if (PyDict_SetItemString(d, "stmt", (PyObject*)stmt_type) < 0) return;
        if (PyDict_SetItemString(d, "FunctionDef", (PyObject*)FunctionDef_type)
            < 0) return;
        if (PyDict_SetItemString(d, "ClassDef", (PyObject*)ClassDef_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Return", (PyObject*)Return_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Delete", (PyObject*)Delete_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Assign", (PyObject*)Assign_type) < 0)
            return;
        if (PyDict_SetItemString(d, "AugAssign", (PyObject*)AugAssign_type) <
            0) return;
        if (PyDict_SetItemString(d, "Print", (PyObject*)Print_type) < 0) return;
        if (PyDict_SetItemString(d, "For", (PyObject*)For_type) < 0) return;
        if (PyDict_SetItemString(d, "While", (PyObject*)While_type) < 0) return;
        if (PyDict_SetItemString(d, "If", (PyObject*)If_type) < 0) return;
        if (PyDict_SetItemString(d, "With", (PyObject*)With_type) < 0) return;
        if (PyDict_SetItemString(d, "Raise", (PyObject*)Raise_type) < 0) return;
        if (PyDict_SetItemString(d, "TryExcept", (PyObject*)TryExcept_type) <
            0) return;
        if (PyDict_SetItemString(d, "TryFinally", (PyObject*)TryFinally_type) <
            0) return;
        if (PyDict_SetItemString(d, "Assert", (PyObject*)Assert_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Import", (PyObject*)Import_type) < 0)
            return;
        if (PyDict_SetItemString(d, "ImportFrom", (PyObject*)ImportFrom_type) <
            0) return;
        if (PyDict_SetItemString(d, "Exec", (PyObject*)Exec_type) < 0) return;
        if (PyDict_SetItemString(d, "Global", (PyObject*)Global_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Expr", (PyObject*)Expr_type) < 0) return;
        if (PyDict_SetItemString(d, "Pass", (PyObject*)Pass_type) < 0) return;
        if (PyDict_SetItemString(d, "Break", (PyObject*)Break_type) < 0) return;
        if (PyDict_SetItemString(d, "Continue", (PyObject*)Continue_type) < 0)
            return;
        if (PyDict_SetItemString(d, "expr", (PyObject*)expr_type) < 0) return;
        if (PyDict_SetItemString(d, "BoolOp", (PyObject*)BoolOp_type) < 0)
            return;
        if (PyDict_SetItemString(d, "BinOp", (PyObject*)BinOp_type) < 0) return;
        if (PyDict_SetItemString(d, "UnaryOp", (PyObject*)UnaryOp_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Lambda", (PyObject*)Lambda_type) < 0)
            return;
        if (PyDict_SetItemString(d, "IfExp", (PyObject*)IfExp_type) < 0) return;
        if (PyDict_SetItemString(d, "Dict", (PyObject*)Dict_type) < 0) return;
        if (PyDict_SetItemString(d, "Set", (PyObject*)Set_type) < 0) return;
        if (PyDict_SetItemString(d, "ListComp", (PyObject*)ListComp_type) < 0)
            return;
        if (PyDict_SetItemString(d, "SetComp", (PyObject*)SetComp_type) < 0)
            return;
        if (PyDict_SetItemString(d, "DictComp", (PyObject*)DictComp_type) < 0)
            return;
        if (PyDict_SetItemString(d, "GeneratorExp",
            (PyObject*)GeneratorExp_type) < 0) return;
        if (PyDict_SetItemString(d, "Yield", (PyObject*)Yield_type) < 0) return;
        if (PyDict_SetItemString(d, "Compare", (PyObject*)Compare_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Call", (PyObject*)Call_type) < 0) return;
        if (PyDict_SetItemString(d, "Repr", (PyObject*)Repr_type) < 0) return;
        if (PyDict_SetItemString(d, "Num", (PyObject*)Num_type) < 0) return;
        if (PyDict_SetItemString(d, "Str", (PyObject*)Str_type) < 0) return;
        if (PyDict_SetItemString(d, "Attribute", (PyObject*)Attribute_type) <
            0) return;
        if (PyDict_SetItemString(d, "Subscript", (PyObject*)Subscript_type) <
            0) return;
        if (PyDict_SetItemString(d, "Name", (PyObject*)Name_type) < 0) return;
        if (PyDict_SetItemString(d, "List", (PyObject*)List_type) < 0) return;
        if (PyDict_SetItemString(d, "Tuple", (PyObject*)Tuple_type) < 0) return;
        if (PyDict_SetItemString(d, "expr_context",
            (PyObject*)expr_context_type) < 0) return;
        if (PyDict_SetItemString(d, "Load", (PyObject*)Load_type) < 0) return;
        if (PyDict_SetItemString(d, "Store", (PyObject*)Store_type) < 0) return;
        if (PyDict_SetItemString(d, "Del", (PyObject*)Del_type) < 0) return;
        if (PyDict_SetItemString(d, "AugLoad", (PyObject*)AugLoad_type) < 0)
            return;
        if (PyDict_SetItemString(d, "AugStore", (PyObject*)AugStore_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Param", (PyObject*)Param_type) < 0) return;
        if (PyDict_SetItemString(d, "slice", (PyObject*)slice_type) < 0) return;
        if (PyDict_SetItemString(d, "Ellipsis", (PyObject*)Ellipsis_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Slice", (PyObject*)Slice_type) < 0) return;
        if (PyDict_SetItemString(d, "ExtSlice", (PyObject*)ExtSlice_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Index", (PyObject*)Index_type) < 0) return;
        if (PyDict_SetItemString(d, "boolop", (PyObject*)boolop_type) < 0)
            return;
        if (PyDict_SetItemString(d, "And", (PyObject*)And_type) < 0) return;
        if (PyDict_SetItemString(d, "Or", (PyObject*)Or_type) < 0) return;
        if (PyDict_SetItemString(d, "operator", (PyObject*)operator_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Add", (PyObject*)Add_type) < 0) return;
        if (PyDict_SetItemString(d, "Sub", (PyObject*)Sub_type) < 0) return;
        if (PyDict_SetItemString(d, "Mult", (PyObject*)Mult_type) < 0) return;
        if (PyDict_SetItemString(d, "Div", (PyObject*)Div_type) < 0) return;
        if (PyDict_SetItemString(d, "Mod", (PyObject*)Mod_type) < 0) return;
        if (PyDict_SetItemString(d, "Pow", (PyObject*)Pow_type) < 0) return;
        if (PyDict_SetItemString(d, "LShift", (PyObject*)LShift_type) < 0)
            return;
        if (PyDict_SetItemString(d, "RShift", (PyObject*)RShift_type) < 0)
            return;
        if (PyDict_SetItemString(d, "BitOr", (PyObject*)BitOr_type) < 0) return;
        if (PyDict_SetItemString(d, "BitXor", (PyObject*)BitXor_type) < 0)
            return;
        if (PyDict_SetItemString(d, "BitAnd", (PyObject*)BitAnd_type) < 0)
            return;
        if (PyDict_SetItemString(d, "FloorDiv", (PyObject*)FloorDiv_type) < 0)
            return;
        if (PyDict_SetItemString(d, "unaryop", (PyObject*)unaryop_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Invert", (PyObject*)Invert_type) < 0)
            return;
        if (PyDict_SetItemString(d, "Not", (PyObject*)Not_type) < 0) return;
        if (PyDict_SetItemString(d, "UAdd", (PyObject*)UAdd_type) < 0) return;
        if (PyDict_SetItemString(d, "USub", (PyObject*)USub_type) < 0) return;
        if (PyDict_SetItemString(d, "cmpop", (PyObject*)cmpop_type) < 0) return;
        if (PyDict_SetItemString(d, "Eq", (PyObject*)Eq_type) < 0) return;
        if (PyDict_SetItemString(d, "NotEq", (PyObject*)NotEq_type) < 0) return;
        if (PyDict_SetItemString(d, "Lt", (PyObject*)Lt_type) < 0) return;
        if (PyDict_SetItemString(d, "LtE", (PyObject*)LtE_type) < 0) return;
        if (PyDict_SetItemString(d, "Gt", (PyObject*)Gt_type) < 0) return;
        if (PyDict_SetItemString(d, "GtE", (PyObject*)GtE_type) < 0) return;
        if (PyDict_SetItemString(d, "Is", (PyObject*)Is_type) < 0) return;
        if (PyDict_SetItemString(d, "IsNot", (PyObject*)IsNot_type) < 0) return;
        if (PyDict_SetItemString(d, "In", (PyObject*)In_type) < 0) return;
        if (PyDict_SetItemString(d, "NotIn", (PyObject*)NotIn_type) < 0) return;
        if (PyDict_SetItemString(d, "comprehension",
            (PyObject*)comprehension_type) < 0) return;
        if (PyDict_SetItemString(d, "excepthandler",
            (PyObject*)excepthandler_type) < 0) return;
        if (PyDict_SetItemString(d, "ExceptHandler",
            (PyObject*)ExceptHandler_type) < 0) return;
        if (PyDict_SetItemString(d, "arguments", (PyObject*)arguments_type) <
            0) return;
        if (PyDict_SetItemString(d, "keyword", (PyObject*)keyword_type) < 0)
            return;
        if (PyDict_SetItemString(d, "alias", (PyObject*)alias_type) < 0) return;
}


PyObject* PyAST_mod2obj(mod_ty t)
{
    init_types();
    return ast2obj_mod(t);
}

/* mode is 0 for "exec", 1 for "eval" and 2 for "single" input */
mod_ty PyAST_obj2mod(PyObject* ast, PyArena* arena, int mode)
{
    mod_ty res;
    PyObject *req_type[3];
    char *req_name[3];
    int isinstance;

    req_type[0] = (PyObject*)Module_type;
    req_type[1] = (PyObject*)Expression_type;
    req_type[2] = (PyObject*)Interactive_type;

    req_name[0] = "Module";
    req_name[1] = "Expression";
    req_name[2] = "Interactive";

    assert(0 <= mode && mode <= 2);

    init_types();

    isinstance = PyObject_IsInstance(ast, req_type[mode]);
    if (isinstance == -1)
        return NULL;
    if (!isinstance) {
        PyErr_Format(PyExc_TypeError, "expected %s node, got %.400s",
                     req_name[mode], Py_TYPE(ast)->tp_name);
        return NULL;
    }
    if (obj2ast_mod(ast, &res, arena) != 0)
        return NULL;
    else
        return res;
}

int PyAST_Check(PyObject* obj)
{
    init_types();
    return PyObject_IsInstance(obj, (PyObject*)&AST_type);
}


