/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.htmlparser.util.Translate;

public class LinkProcessor
implements Serializable {
    private String baseUrl = null;

    public String extract(String link, String base) {
        String ret;
        try {
            link = null == link ? "" : this.stripQuotes(link);
            if (null != this.getBaseUrl()) {
                base = this.getBaseUrl();
            }
            if (null == base || "".equals(link)) {
                ret = link;
            } else {
                URL url = this.constructUrl(link, base);
                ret = url.toExternalForm();
            }
        }
        catch (MalformedURLException murle) {
            ret = link;
        }
        return Translate.decode(ret);
    }

    public String stripQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && 1 < string.length()) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.startsWith("'") && string.endsWith("'") && 1 < string.length()) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public URL constructUrl(String link, String base) throws MalformedURLException {
        int index;
        URL url = new URL(new URL(base), link);
        String path = url.getFile();
        boolean modified = false;
        boolean absolute = link.startsWith("/");
        if (!absolute) {
            while (path.startsWith("/.")) {
                if (path.startsWith("/../")) {
                    path = path.substring(3);
                    modified = true;
                    continue;
                }
                if (!path.startsWith("/./") && !path.startsWith("/.")) break;
                path = path.substring(2);
                modified = true;
            }
        }
        while (-1 != (index = path.indexOf("/\\"))) {
            path = path.substring(0, index + 1) + path.substring(index + 2);
            modified = true;
        }
        if (modified) {
            url = new URL(url, path);
        }
        return url;
    }

    public static String fixSpaces(String url) {
        int index = url.indexOf(32);
        if (-1 != index) {
            int length = url.length();
            StringBuffer returnURL = new StringBuffer(length * 3);
            returnURL.append(url.substring(0, index));
            for (int i = index; i < length; ++i) {
                char ch = url.charAt(i);
                if (ch == ' ') {
                    returnURL.append("%20");
                    continue;
                }
                returnURL.append(ch);
            }
            url = returnURL.toString();
        }
        return url;
    }

    public static boolean isURL(String resourceLocn) {
        boolean ret;
        try {
            URL url = new URL(resourceLocn);
            ret = true;
        }
        catch (MalformedURLException murle) {
            ret = false;
        }
        return ret;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public static String removeLastSlash(String baseUrl) {
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }
}

