/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLine {
    public static boolean VERBOSE = false;
    protected List commands = new ArrayList();
    protected List flags = new ArrayList();
    protected List names = new ArrayList();
    protected Map values = new HashMap();

    public CommandLine(String chars, String[] args) {
        for (int i = 0; i < chars.length(); ++i) {
            this.addCommand(chars.charAt(i));
        }
        this.parse(args);
    }

    public CommandLine(String[] args) {
        this.parse(args);
    }

    protected void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String thisArg = args[i];
            String nextArg = null;
            if (i < args.length - 1) {
                nextArg = args[i + 1];
            }
            if (thisArg.startsWith("-")) {
                Character chr;
                if (thisArg.length() > 2 && this.commands.contains(chr = new Character(thisArg.charAt(1)))) {
                    String key = chr.toString();
                    String val = thisArg.substring(2);
                    if (VERBOSE) {
                        System.out.println("Value " + key + "=" + val);
                    }
                    this.values.put(key, val);
                }
                if (nextArg != null && !nextArg.startsWith("-")) {
                    String key = thisArg.substring(1);
                    String val = nextArg;
                    if (VERBOSE) {
                        System.out.println("Value " + key + "=" + val);
                    }
                    this.values.put(key, val);
                    ++i;
                    continue;
                }
                String flag = thisArg.substring(1);
                this.flags.add(flag);
                if (!VERBOSE) continue;
                System.out.println("Flag " + flag);
                continue;
            }
            if (VERBOSE) {
                System.out.println("Name " + thisArg);
            }
            this.names.add(thisArg);
        }
    }

    public void addCommand(char command) {
        this.commands.add(new Character(command));
    }

    public boolean hasValue(String key) {
        return this.values.containsKey(key);
    }

    public String getValue(String key) {
        return (String)this.values.get(key);
    }

    public boolean getFlag(String key) {
        return this.flags.contains(key);
    }

    public int getNameCount() {
        return this.names.size();
    }

    public String getName(int index) {
        return (String)this.names.get(index);
    }

    public static void main(String[] args) {
        CommandLine cmd = new CommandLine("f", args);
    }
}

