/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexerapplications.thumbelina.Thumbelina;

public class ThumbelinaFrame
extends JFrame
implements WindowListener,
ActionListener,
ItemListener,
PropertyChangeListener {
    private static final String TITLE = "Thumbelina";
    private static final String FRAMESIZE = "FrameSize";
    private static final int BORDERPERCENT = 5;
    private static final String MRULENGTH = "MRULength";
    private static final String MRUMAX = "MRUMax";
    private static final String MRUPREFIX = "MRUListItem";
    private static final String GOOGLEQUERY = "GoogleQuery";
    private static final String DEFAULTGOOGLEQUERY = "thumbs";
    private static final String[] DEFAULTMRULIST = new String[]{"www.a2zcds.com", "www.stoneschool.com/Japan/", "www.tommys-bookmarks.com", "www.unitedmedia.com/comics/dilbert/archive", "www.pastelartists.com"};
    private static final boolean USE_MOZILLA_HEADERS = false;
    private static final String STATUSBARSTATE = "StatusBarVisible";
    private static final String HISTORYLISTSTATE = "HistoryListVisible";
    private static final String SEQUENCERACTIVE = "SequencerActive";
    private static final String BACKGROUNDTHREADACTIVE = "BackgroundThreadActive";
    private static final String DISPLAYSPEED = "DisplaySpeed";
    protected JMenuBar mMenu;
    protected JMenu mURL;
    protected JMenuItem mOpen;
    protected JMenuItem mGoogle;
    protected JSeparator mSeparator1;
    protected JSeparator mSeparator2;
    protected JMenuItem mExit;
    protected JMenu mView;
    protected JCheckBoxMenuItem mStatusVisible;
    protected JCheckBoxMenuItem mHistoryVisible;
    protected JMenu mCommand;
    protected JMenuItem mReset;
    protected JMenuItem mClear;
    protected JMenu mHelp;
    protected JMenuItem mAbout;

    public ThumbelinaFrame() {
        this(new Thumbelina());
    }

    public ThumbelinaFrame(String url) throws MalformedURLException {
        this(new Thumbelina(url));
    }

    public ThumbelinaFrame(URL url) {
        this(new Thumbelina(url));
    }

    public ThumbelinaFrame(Thumbelina thumbelina) {
        this.setTitle(TITLE);
        thumbelina.addPropertyChangeListener(this);
        this.getContentPane().add((Component)thumbelina, "Center");
        this.addWindowListener(this);
        this.makeMenu();
        this.setJMenuBar(this.mMenu);
        this.restoreSize();
        this.initState();
        this.updateMenu();
    }

    public Thumbelina getThumbelina() {
        return (Thumbelina)this.getContentPane().getComponent(0);
    }

    public void initState() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (-1 == prefs.getInt(MRULENGTH, -1)) {
            for (int i = 0; i < DEFAULTMRULIST.length; ++i) {
                this.updateMRU(DEFAULTMRULIST[i]);
            }
        }
        this.getThumbelina().setStatusBarVisible(prefs.getBoolean(STATUSBARSTATE, this.getThumbelina().getStatusBarVisible()));
        this.mStatusVisible.setSelected(this.getThumbelina().getStatusBarVisible());
        this.getThumbelina().setHistoryListVisible(prefs.getBoolean(HISTORYLISTSTATE, this.getThumbelina().getHistoryListVisible()));
        this.mHistoryVisible.setSelected(this.getThumbelina().getHistoryListVisible());
        this.getThumbelina().setSequencerActive(prefs.getBoolean(SEQUENCERACTIVE, this.getThumbelina().getSequencerActive()));
        this.getThumbelina().setBackgroundThreadActive(prefs.getBoolean(BACKGROUNDTHREADACTIVE, this.getThumbelina().getBackgroundThreadActive()));
        this.getThumbelina().setSpeed(prefs.getInt(DISPLAYSPEED, this.getThumbelina().getSpeed()));
    }

    public void saveState() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (0 == this.getExtendedState()) {
            prefs.put(FRAMESIZE, this.toString(this.getBounds()));
        }
        prefs.putBoolean(STATUSBARSTATE, this.getThumbelina().getStatusBarVisible());
        prefs.putBoolean(HISTORYLISTSTATE, this.getThumbelina().getHistoryListVisible());
        prefs.putBoolean(SEQUENCERACTIVE, this.getThumbelina().getSequencerActive());
        prefs.putBoolean(BACKGROUNDTHREADACTIVE, this.getThumbelina().getBackgroundThreadActive());
        prefs.putInt(DISPLAYSPEED, this.getThumbelina().getSpeed());
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public void initSize() {
        Toolkit tk = this.getToolkit();
        Dimension dim = tk.getScreenSize();
        int borderx = dim.width * 5 / 100;
        int bordery = dim.height * 5 / 100;
        this.setBounds(borderx, bordery, dim.width - 2 * borderx, dim.height - 2 * bordery);
    }

    public void restoreSize() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String size = prefs.get(FRAMESIZE, "");
        if ("".equals(size)) {
            this.initSize();
        } else {
            try {
                Rectangle rectangle = this.fromString(size);
                if (this.rational(rectangle)) {
                    this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    this.initSize();
                }
            }
            catch (IllegalArgumentException iae) {
                this.initSize();
            }
        }
    }

    protected String toString(Rectangle r) {
        return "[" + r.x + "," + r.y + "," + r.width + "," + r.height + "]";
    }

    protected Rectangle fromString(String value) throws IllegalArgumentException {
        Rectangle ret;
        try {
            int[] values;
            if (value.startsWith("[") && value.endsWith("]")) {
                String guts = value.substring(1, value.length() - 1) + ",";
                int current = 0;
                values = new int[4];
                for (int i = 0; i < 4; ++i) {
                    int index = guts.indexOf(",", current);
                    if (-1 == index) {
                        throw new IllegalArgumentException("invalid format \"" + value + "\"");
                    }
                    values[i] = Integer.parseInt(guts.substring(current, index));
                    current = index + 1;
                }
            } else {
                throw new IllegalArgumentException("invalid format \"" + value + "\"");
            }
            ret = new Rectangle(values[0], values[1], values[2], values[3]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.getMessage());
        }
        return ret;
    }

    private boolean rational(Rectangle r) {
        Toolkit tk = this.getToolkit();
        Dimension winsize = tk.getScreenSize();
        return r.x >= r.width / -10 && r.y >= 0 && r.width > 0 && r.height > 0 && r.x + r.width <= winsize.width + r.width / 10 && r.y + r.height <= winsize.height + r.height / 10;
    }

    public void makeMenu() {
        this.mMenu = new JMenuBar();
        this.mURL = new JMenu();
        this.mOpen = new JMenuItem();
        this.mGoogle = new JMenuItem();
        this.mSeparator1 = new JSeparator();
        this.mSeparator2 = new JSeparator();
        this.mExit = new JMenuItem();
        this.mView = new JMenu();
        this.mStatusVisible = new JCheckBoxMenuItem();
        this.mHistoryVisible = new JCheckBoxMenuItem();
        this.mHelp = new JMenu();
        this.mAbout = new JMenuItem();
        this.mCommand = new JMenu();
        this.mReset = new JMenuItem();
        this.mClear = new JMenuItem();
        this.mURL.setMnemonic('U');
        this.mURL.setText("URL");
        this.mOpen.setMnemonic('O');
        this.mOpen.setText("Open");
        this.mOpen.setToolTipText("Open a URL.");
        this.mURL.add(this.mOpen);
        this.mGoogle.setMnemonic('G');
        this.mGoogle.setText("Google");
        this.mGoogle.setToolTipText("Search Google.");
        this.mURL.add(this.mGoogle);
        this.mURL.add(this.mSeparator1);
        this.mURL.add(this.mSeparator2);
        this.mExit.setMnemonic('E');
        this.mExit.setText("Exit");
        this.mExit.setToolTipText("Quit Thumbelina.");
        this.mURL.add(this.mExit);
        this.mMenu.add(this.mURL);
        this.mView.setMnemonic('V');
        this.mView.setText("View");
        this.mStatusVisible.setMnemonic('S');
        this.mStatusVisible.setSelected(this.getThumbelina().getStatusBarVisible());
        this.mStatusVisible.setText("Status Bar");
        this.mStatusVisible.setToolTipText("Show/Hide the status bar.");
        this.mView.add(this.mStatusVisible);
        this.mHistoryVisible.setMnemonic('H');
        this.mHistoryVisible.setSelected(this.getThumbelina().getHistoryListVisible());
        this.mHistoryVisible.setText("History List");
        this.mHistoryVisible.setToolTipText("Show/Hide the history list.");
        this.mView.add(this.mHistoryVisible);
        this.mMenu.add(this.mView);
        this.mCommand.setMnemonic('C');
        this.mCommand.setText("Command");
        this.mReset.setMnemonic('R');
        this.mReset.setText("Reset");
        this.mReset.setToolTipText("Reset Thumbelina.");
        this.mClear.setMnemonic('L');
        this.mClear.setText("Clear");
        this.mClear.setToolTipText("Clear display.");
        this.mCommand.add(this.mReset);
        this.mCommand.add(this.mClear);
        this.mCommand.add(this.mHelp);
        this.mMenu.add(this.mCommand);
        this.mHelp.setMnemonic('H');
        this.mHelp.setText("Help");
        this.mAbout.setMnemonic('A');
        this.mAbout.setText("About");
        this.mAbout.setToolTipText("Information about Thumbelina.");
        this.mHelp.add(this.mAbout);
        this.mMenu.add(this.mHelp);
        this.mOpen.addActionListener(this);
        this.mGoogle.addActionListener(this);
        this.mExit.addActionListener(this);
        this.mStatusVisible.addItemListener(this);
        this.mHistoryVisible.addItemListener(this);
        this.mReset.addActionListener(this);
        this.mClear.addActionListener(this);
        this.mAbout.addActionListener(this);
    }

    public void updateMenu() {
        int i;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        int start = -1;
        int end = -1;
        for (i = 0; i < this.mURL.getItemCount(); ++i) {
            Component component = this.mURL.getMenuComponent(i);
            if (component == this.mSeparator1) {
                start = i + 1;
                continue;
            }
            if (component != this.mSeparator2) continue;
            end = i;
        }
        if (-1 != start && -1 != end) {
            for (i = start; i < end; ++i) {
                this.mURL.remove(start);
            }
            int count = prefs.getInt(MRULENGTH, 0);
            for (i = 0; i < count; ++i) {
                String string = prefs.get(MRUPREFIX + i, "");
                if ("".equals(string)) continue;
                JMenuItem item = new JMenuItem();
                item.setActionCommand(string);
                if (string.length() > 40) {
                    string = string.substring(0, 38) + "...";
                }
                item.setText(string);
                item.addActionListener(this);
                this.mURL.add((Component)item, start++);
            }
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.exit();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String action = actionEvent.getActionCommand();
        if (action.equals("Open")) {
            this.open();
        } else if (action.equals("Google")) {
            this.googlesearch();
        } else if (action.equals("Reset")) {
            this.getThumbelina().reset();
        } else if (action.equals("Clear")) {
            this.getThumbelina().getPicturePanel().reset();
        } else if (action.equals("About")) {
            this.about();
        } else if (action.equals("Exit")) {
            this.exit();
        } else {
            this.getThumbelina().open(action);
            this.updateMRU(action);
            this.updateMenu();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        boolean visible;
        ItemSelectable source = event.getItemSelectable();
        boolean bl = visible = 1 == event.getStateChange();
        if (source == this.mStatusVisible) {
            this.getThumbelina().setStatusBarVisible(visible);
        } else if (source == this.mHistoryVisible) {
            this.getThumbelina().setHistoryListVisible(visible);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("currentURL")) {
            String url = (String)event.getNewValue();
            if (null == url) {
                this.setTitle(TITLE);
            } else {
                this.setTitle("Thumbelina - " + url);
            }
        }
    }

    public void updateMRU(String url) {
        int i;
        if (url.startsWith("http://")) {
            url = url.substring(7);
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        int count = prefs.getInt(MRULENGTH, -1);
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < count; ++i) {
            String string = prefs.get(MRUPREFIX + i, "");
            if ("".equals(string) || url.equalsIgnoreCase(string)) continue;
            list.add(string);
        }
        list.add(0, url);
        int max = prefs.getInt(MRUMAX, -1);
        if (-1 == max) {
            max = 8;
        }
        while (list.size() > max) {
            list.remove(max);
        }
        prefs.putInt(MRULENGTH, list.size());
        prefs.putInt(MRUMAX, max);
        for (i = 0; i < list.size(); ++i) {
            prefs.put(MRUPREFIX + i, (String)list.get(i));
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    public void open() {
        String result = JOptionPane.showInputDialog(this, "Enter the URL:", "Open URL", -1);
        if (null != result) {
            this.getThumbelina().open(result);
            this.updateMRU(result);
            this.updateMenu();
        }
    }

    public void googlesearch() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String query = prefs.get(GOOGLEQUERY, DEFAULTGOOGLEQUERY);
        try {
            query = (String)JOptionPane.showInputDialog(this, "Enter the search term:", "Search Google", -1, null, null, query);
            if (null != query) {
                String terms = query.replace(' ', '+');
                StringBuffer buffer = new StringBuffer(1024);
                buffer.append("http://www.google.ca/search?");
                buffer.append("q=");
                buffer.append(terms);
                buffer.append("&ie=UTF-8");
                buffer.append("&oe=UTF-8");
                buffer.append("&hl=en");
                buffer.append("&btnG=Google+Search");
                buffer.append("&meta=");
                URL url = new URL(buffer.toString());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
                connection.setRequestProperty("Accept-Language", "en-ca");
                connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; trieste; .NET CLR 1.1.4322; .NET CLR 1.0.3705)");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setUseCaches(false);
                Lexer lexer = new Lexer(connection);
                URL[][] results = this.getThumbelina().extractImageLinks(lexer, url);
                this.getThumbelina().reset();
                for (int i = 0; i < results[1].length; ++i) {
                    String found = results[1][i].toExternalForm();
                    if (-1 != found.indexOf("google")) continue;
                    this.getThumbelina().append(results[1][i]);
                }
                prefs.put(GOOGLEQUERY, query);
                try {
                    prefs.flush();
                }
                catch (BackingStoreException bse) {
                    bse.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void about() {
        URL url;
        try {
            url = new URL("http://sourceforge.net/sflogo.php?group_id=24399");
        }
        catch (MalformedURLException murle) {
            url = null;
        }
        JOptionPane.showMessageDialog(this, "Scan and display the images behind thumbnails.\n\nAn example application using the HTML Parser project.\nVisit http://htmlparser.sourceforge.org for the latest\nversion and source code.\n", "Thumbelina - About", -1, new ImageIcon(url));
    }

    public void exit() {
        this.saveState();
        System.exit(0);
    }

    public static void main(String[] args) {
        System.setProperty("sun.net.client.defaultReadTimeout", "7000");
        System.setProperty("sun.net.client.defaultConnectTimeout", "7000");
        String url = null;
        if (0 != args.length) {
            if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("-?")) {
                Thumbelina.help();
            } else {
                url = args[0];
            }
        }
        try {
            ThumbelinaFrame frame = new ThumbelinaFrame(url);
            frame.setVisible(true);
        }
        catch (MalformedURLException murle) {
            System.err.println(murle.getMessage());
            Thumbelina.help();
        }
    }
}

