package captcha

// This file has been generated from .wav files using generate.go.

var waveHeader = []byte{
	0x52, 0x49, 0x46, 0x46, 0x00, 0x00, 0x00, 0x00, 0x57, 0x41, 0x56, 0x45,
	0x66, 0x6d, 0x74, 0x20, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
	0x40, 0x1f, 0x00, 0x00, 0x40, 0x1f, 0x00, 0x00, 0x01, 0x00, 0x08, 0x00,
	0x64, 0x61, 0x74, 0x61,
}

// Byte slices contain raw 8 kHz unsigned 8-bit PCM data (without wav header).

var digitSounds = map[string][][]byte{
	"en": [][]byte{
		{ // 0
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x7d,
			0x7e, 0x7c, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x82, 0x81,
			0x83, 0x82, 0x84, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8a,
			0x8c, 0x8a, 0x8b, 0x8b, 0x8a, 0x8a, 0x88, 0x88, 0x86, 0x84, 0x82,
			0x80, 0x7e, 0x7c, 0x7c, 0x7b, 0x7c, 0x79, 0x77, 0x78, 0x76, 0x75,
			0x73, 0x75, 0x75, 0x75, 0x73, 0x72, 0x71, 0x73, 0x76, 0x70, 0x76,
			0x71, 0x77, 0x75, 0x74, 0x78, 0x73, 0x79, 0x76, 0x76, 0x75, 0x75,
			0x75, 0x79, 0x7f, 0x80, 0x81, 0x83, 0x88, 0x8d, 0x90, 0x91, 0x91,
			0x94, 0x98, 0x97, 0x97, 0x95, 0x94, 0x93, 0x92, 0x8d, 0x8a, 0x86,
			0x84, 0x81, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x81, 0x81, 0x85, 0x81,
			0x85, 0x85, 0x86, 0x88, 0x84, 0x83, 0x7d, 0x79, 0x77, 0x77, 0x77,
			0x75, 0x72, 0x75, 0x75, 0x75, 0x72, 0x73, 0x72, 0x76, 0x76, 0x74,
			0x74, 0x75, 0x77, 0x78, 0x79, 0x76, 0x79, 0x78, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7e, 0x7e, 0x7f, 0x7b, 0x7e, 0x7c, 0x7e, 0x7f, 0x80, 0x80,
			0x7f, 0x85, 0x84, 0x89, 0x85, 0x89, 0x8c, 0x8e, 0x8e, 0x8d, 0x90,
			0x90, 0x91, 0x8c, 0x8d, 0x89, 0x8c, 0x8a, 0x88, 0x89, 0x84, 0x87,
			0x85, 0x86, 0x83, 0x84, 0x82, 0x7f, 0x85, 0x81, 0x81, 0x7e, 0x80,
			0x7d, 0x7e, 0x7e, 0x79, 0x7c, 0x7a, 0x7a, 0x79, 0x79, 0x77, 0x78,
			0x79, 0x77, 0x76, 0x79, 0x78, 0x79, 0x77, 0x79, 0x79, 0x79, 0x78,
			0x78, 0x7a, 0x78, 0x7b, 0x79, 0x7a, 0x79, 0x7b, 0x7b, 0x79, 0x7c,
			0x79, 0x7d, 0x7c, 0x7d, 0x7d, 0x7c, 0x7e, 0x7d, 0x7f, 0x7c, 0x7f,
			0x7c, 0x7f, 0x7f, 0x82, 0x81, 0x82, 0x84, 0x82, 0x89, 0x82, 0x8a,
			0x83, 0x8b, 0x88, 0x86, 0x8b, 0x85, 0x8d, 0x86, 0x89, 0x84, 0x89,
			0x88, 0x84, 0x84, 0x83, 0x85, 0x83, 0x82, 0x80, 0x84, 0x81, 0x83,
			0x7f, 0x80, 0x82, 0x7e, 0x81, 0x7c, 0x7f, 0x7d, 0x7c, 0x7c, 0x7b,
			0x7d, 0x7a, 0x7d, 0x79, 0x7c, 0x7b, 0x7a, 0x7d, 0x79, 0x7d, 0x7d,
			0x7b, 0x7d, 0x79, 0x7e, 0x7d, 0x79, 0x7d, 0x7a, 0x7d, 0x7f, 0x7b,
			0x7d, 0x7c, 0x7d, 0x7d, 0x7a, 0x7e, 0x7c, 0x7e, 0x7e, 0x7c, 0x7e,
			0x7f, 0x81, 0x7f, 0x7d, 0x81, 0x80, 0x82, 0x80, 0x81, 0x84, 0x85,
			0x87, 0x84, 0x85, 0x86, 0x8a, 0x85, 0x88, 0x85, 0x8b, 0x87, 0x88,
			0x87, 0x84, 0x89, 0x84, 0x86, 0x81, 0x84, 0x84, 0x82, 0x83, 0x81,
			0x81, 0x83, 0x81, 0x80, 0x7e, 0x82, 0x7c, 0x80, 0x7e, 0x7b, 0x82,
			0x78, 0x7f, 0x7c, 0x79, 0x7e, 0x77, 0x7c, 0x7e, 0x7a, 0x7b, 0x7a,
			0x7c, 0x7d, 0x77, 0x7b, 0x7a, 0x7e, 0x7e, 0x7a, 0x7e, 0x7a, 0x7d,
			0x7a, 0x7b, 0x7c, 0x7b, 0x7e, 0x7b, 0x7a, 0x7f, 0x7c, 0x7c, 0x7d,
			0x7b, 0x7f, 0x7e, 0x7f, 0x7c, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82,
			0x82, 0x85, 0x82, 0x88, 0x83, 0x88, 0x84, 0x88, 0x89, 0x85, 0x88,
			0x85, 0x8a, 0x85, 0x86, 0x85, 0x86, 0x86, 0x83, 0x81, 0x84, 0x85,
			0x81, 0x7f, 0x80, 0x81, 0x81, 0x7e, 0x7c, 0x7e, 0x85, 0x7c, 0x7b,
			0x7d, 0x81, 0x7f, 0x77, 0x7d, 0x77, 0x85, 0x79, 0x78, 0x7e, 0x78,
			0x82, 0x72, 0x7e, 0x7c, 0x7b, 0x80, 0x76, 0x7f, 0x7e, 0x7a, 0x76,
			0x7d, 0x7c, 0x76, 0x7b, 0x75, 0x7b, 0x7a, 0x77, 0x77, 0x77, 0x7e,
			0x7c, 0x7a, 0x7a, 0x83, 0x87, 0x7d, 0x86, 0x84, 0x8c, 0x8a, 0x87,
			0x89, 0x8b, 0x90, 0x87, 0x88, 0x86, 0x8f, 0x89, 0x83, 0x89, 0x86,
			0x89, 0x89, 0x7c, 0x87, 0x88, 0x80, 0x81, 0x7f, 0x87, 0x82, 0x81,
			0x7d, 0x85, 0x84, 0x7a, 0x7e, 0x7f, 0x7b, 0x83, 0x78, 0x79, 0x82,
			0x78, 0x7c, 0x76, 0x7b, 0x78, 0x7b, 0x78, 0x72, 0x7e, 0x76, 0x6f,
			0x78, 0x74, 0x6a, 0x77, 0x6b, 0x6a, 0x6c, 0x6d, 0x64, 0x6a, 0x71,
			0x6b, 0x77, 0x79, 0x7d, 0x84, 0x8d, 0x88, 0x90, 0x9a, 0x96, 0x98,
			0x9c, 0x9d, 0x9a, 0x9a, 0x95, 0x94, 0x93, 0x8b, 0x87, 0x87, 0x83,
			0x82, 0x84, 0x7f, 0x82, 0x84, 0x84, 0x82, 0x89, 0x8b, 0x86, 0x8e,
			0x8b, 0x87, 0x86, 0x85, 0x80, 0x7b, 0x7e, 0x78, 0x76, 0x71, 0x6e,
			0x6d, 0x64, 0x69, 0x66, 0x66, 0x61, 0x62, 0x61, 0x59, 0x62, 0x54,
			0x5e, 0x62, 0x5d, 0x6f, 0x71, 0x7e, 0x82, 0x8d, 0x94, 0x9d, 0xa5,
			0xa1, 0xaf, 0xad, 0xad, 0xa8, 0xa8, 0xa3, 0x9b, 0x96, 0x89, 0x88,
			0x81, 0x78, 0x75, 0x75, 0x75, 0x74, 0x77, 0x7c, 0x83, 0x88, 0x90,
			0x95, 0x9a, 0xa0, 0x9d, 0x9f, 0x9c, 0x93, 0x8b, 0x83, 0x7c, 0x74,
			0x6c, 0x65, 0x60, 0x5d, 0x59, 0x57, 0x56, 0x56, 0x55, 0x55, 0x50,
			0x51, 0x4f, 0x51, 0x57, 0x5e, 0x7a, 0x81, 0x82, 0x93, 0xa3, 0xaa,
			0xa6, 0xae, 0xb7, 0xb5, 0xae, 0xa4, 0xa5, 0x9f, 0x8e, 0x84, 0x80,
			0x7d, 0x72, 0x6c, 0x70, 0x73, 0x72, 0x75, 0x7e, 0x88, 0x8f, 0x96,
			0x9e, 0xa8, 0xad, 0xa7, 0xa5, 0xa1, 0x97, 0x8c, 0x82, 0x7b, 0x72,
			0x6b, 0x65, 0x61, 0x5d, 0x58, 0x59, 0x59, 0x55, 0x54, 0x54, 0x4e,
			0x4b, 0x4a, 0x4b, 0x52, 0x5d, 0x77, 0x87, 0x84, 0x91, 0xaa, 0xb0,
			0xa6, 0xae, 0xb8, 0xb2, 0xaa, 0xa2, 0x9b, 0x96, 0x8b, 0x7d, 0x77,
			0x79, 0x70, 0x69, 0x70, 0x76, 0x76, 0x7b, 0x83, 0x8f, 0x97, 0x9d,
			0xa5, 0xa9, 0xaf, 0xa9, 0xa0, 0x9e, 0x94, 0x85, 0x7b, 0x76, 0x6e,
			0x66, 0x64, 0x61, 0x60, 0x5f, 0x5e, 0x5e, 0x5f, 0x5c, 0x58, 0x57,
			0x50, 0x4a, 0x47, 0x4e, 0x53, 0x64, 0x86, 0x7f, 0x81, 0xa4, 0xb1,
			0xa8, 0xa8, 0xb8, 0xb7, 0xaa, 0xa4, 0x9d, 0x97, 0x8c, 0x7e, 0x74,
			0x73, 0x73, 0x69, 0x69, 0x74, 0x7a, 0x7d, 0x84, 0x90, 0x9a, 0xa0,
			0xa6, 0xa8, 0xab, 0xab, 0x9e, 0x96, 0x90, 0x85, 0x78, 0x70, 0x6f,
			0x69, 0x65, 0x65, 0x67, 0x67, 0x66, 0x67, 0x66, 0x66, 0x61, 0x5b,
			0x56, 0x4d, 0x48, 0x47, 0x4e, 0x55, 0x6a, 0x86, 0x82, 0x8a, 0xa6,
			0xb4, 0xad, 0xa9, 0xb5, 0xb5, 0xa9, 0x9d, 0x93, 0x8b, 0x7f, 0x74,
			0x6a, 0x66, 0x6b, 0x6d, 0x6d, 0x74, 0x82, 0x8d, 0x91, 0x99, 0xa4,
			0xab, 0xab, 0xaa, 0xa7, 0xa0, 0x97, 0x89, 0x7c, 0x75, 0x6e, 0x65,
			0x62, 0x68, 0x69, 0x68, 0x6d, 0x72, 0x73, 0x71, 0x73, 0x71, 0x6e,
			0x68, 0x5f, 0x55, 0x4b, 0x47, 0x45, 0x4a, 0x52, 0x64, 0x80, 0x87,
			0x8a, 0xa0, 0xb3, 0xb4, 0xaa, 0xae, 0xb3, 0xa9, 0x9a, 0x8c, 0x83,
			0x79, 0x71, 0x6a, 0x63, 0x68, 0x72, 0x76, 0x7a, 0x86, 0x95, 0x9b,
			0x9d, 0xa2, 0xa6, 0xa5, 0xa0, 0x99, 0x8e, 0x86, 0x7e, 0x73, 0x6c,
			0x6a, 0x6d, 0x6d, 0x71, 0x78, 0x7d, 0x84, 0x84, 0x81, 0x7f, 0x7a,
			0x73, 0x68, 0x5e, 0x55, 0x4b, 0x46, 0x42, 0x40, 0x3f, 0x44, 0x4d,
			0x62, 0x84, 0x98, 0xa0, 0xa9, 0xbc, 0xc3, 0xb7, 0xab, 0xa3, 0x9b,
			0x8e, 0x7b, 0x6b, 0x5f, 0x5d, 0x62, 0x63, 0x66, 0x6e, 0x7f, 0x91,
			0x98, 0x99, 0xa0, 0xa8, 0xa8, 0xa2, 0x9a, 0x92, 0x8b, 0x84, 0x7a,
			0x72, 0x6e, 0x6c, 0x71, 0x74, 0x75, 0x7a, 0x82, 0x89, 0x8b, 0x8b,
			0x8b, 0x88, 0x83, 0x7b, 0x71, 0x6a, 0x63, 0x5c, 0x55, 0x51, 0x4f,
			0x4e, 0x4e, 0x4d, 0x4b, 0x4f, 0x5e, 0x75, 0x93, 0xa7, 0xa7, 0xa7,
			0xb1, 0xbb, 0xaf, 0x95, 0x87, 0x82, 0x7c, 0x73, 0x68, 0x62, 0x63,
			0x6d, 0x7c, 0x83, 0x86, 0x8c, 0x97, 0xa1, 0xa1, 0x9a, 0x94, 0x91,
			0x8e, 0x88, 0x7e, 0x76, 0x74, 0x75, 0x76, 0x76, 0x78, 0x7b, 0x82,
			0x87, 0x8a, 0x8c, 0x8d, 0x8e, 0x8d, 0x89, 0x80, 0x77, 0x71, 0x6b,
			0x65, 0x5e, 0x59, 0x58, 0x58, 0x57, 0x55, 0x55, 0x58, 0x57, 0x55,
			0x53, 0x56, 0x66, 0x7c, 0x99, 0xab, 0xa9, 0xa2, 0xa5, 0xac, 0xa7,
			0x94, 0x84, 0x7d, 0x79, 0x77, 0x75, 0x6e, 0x69, 0x6e, 0x7c, 0x8a,
			0x8e, 0x8e, 0x90, 0x98, 0x9f, 0x9d, 0x93, 0x89, 0x85, 0x86, 0x83,
			0x7d, 0x76, 0x74, 0x77, 0x7c, 0x7f, 0x7e, 0x7f, 0x84, 0x8c, 0x8f,
			0x8c, 0x88, 0x85, 0x84, 0x82, 0x7b, 0x72, 0x6b, 0x67, 0x67, 0x67,
			0x65, 0x62, 0x61, 0x61, 0x61, 0x62, 0x60, 0x60, 0x62, 0x61, 0x60,
			0x5d, 0x5b, 0x5e, 0x6a, 0x88, 0xa8, 0xb0, 0xa3, 0x97, 0x9d, 0xab,
			0xa8, 0x93, 0x81, 0x7a, 0x7b, 0x7b, 0x78, 0x75, 0x75, 0x76, 0x7e,
			0x8b, 0x95, 0x97, 0x93, 0x91, 0x95, 0x95, 0x8f, 0x85, 0x7e, 0x7b,
			0x78, 0x77, 0x78, 0x77, 0x76, 0x77, 0x7d, 0x85, 0x89, 0x89, 0x8c,
			0x92, 0x93, 0x8f, 0x88, 0x83, 0x7f, 0x79, 0x73, 0x6e, 0x6b, 0x69,
			0x67, 0x65, 0x65, 0x64, 0x64, 0x64, 0x61, 0x60, 0x60, 0x61, 0x62,
			0x62, 0x60, 0x5e, 0x5e, 0x64, 0x6c, 0x73, 0x77, 0x80, 0x96, 0xae,
			0xb2, 0xa3, 0x94, 0x93, 0x97, 0x91, 0x82, 0x79, 0x79, 0x7a, 0x7a,
			0x7b, 0x81, 0x89, 0x8d, 0x8e, 0x90, 0x93, 0x93, 0x8f, 0x88, 0x83,
			0x7d, 0x76, 0x70, 0x70, 0x74, 0x77, 0x77, 0x78, 0x7e, 0x88, 0x91,
			0x95, 0x94, 0x91, 0x8d, 0x8b, 0x88, 0x84, 0x7f, 0x79, 0x74, 0x71,
			0x71, 0x73, 0x75, 0x75, 0x76, 0x79, 0x7c, 0x7b, 0x77, 0x73, 0x70,
			0x6b, 0x65, 0x5f, 0x5b, 0x5a, 0x5d, 0x61, 0x64, 0x62, 0x5d, 0x59,
			0x56, 0x54, 0x52, 0x53, 0x5d, 0x76, 0x9c, 0xbb, 0xc1, 0xb4, 0xa6,
			0xa4, 0xa8, 0xa1, 0x91, 0x81, 0x77, 0x73, 0x72, 0x72, 0x74, 0x79,
			0x7f, 0x84, 0x8a, 0x93, 0x9b, 0x9c, 0x95, 0x8d, 0x89, 0x85, 0x7f,
			0x77, 0x70, 0x6c, 0x6b, 0x6c, 0x70, 0x75, 0x7a, 0x7f, 0x85, 0x8c,
			0x92, 0x95, 0x93, 0x8f, 0x8a, 0x86, 0x83, 0x80, 0x7c, 0x79, 0x78,
			0x79, 0x7b, 0x7c, 0x7a, 0x7a, 0x7c, 0x7e, 0x7d, 0x79, 0x76, 0x76,
			0x74, 0x72, 0x6e, 0x6c, 0x6d, 0x6d, 0x6b, 0x68, 0x66, 0x68, 0x6a,
			0x6a, 0x66, 0x65, 0x69, 0x6b, 0x67, 0x62, 0x61, 0x6a, 0x87, 0xaf,
			0xc2, 0xb7, 0xa0, 0x94, 0x9e, 0xa5, 0x98, 0x83, 0x74, 0x6e, 0x6e,
			0x73, 0x7d, 0x87, 0x85, 0x82, 0x89, 0x93, 0x95, 0x8e, 0x86, 0x87,
			0x8b, 0x86, 0x7d, 0x77, 0x72, 0x6d, 0x6a, 0x6c, 0x76, 0x7e, 0x7f,
			0x7f, 0x83, 0x8b, 0x90, 0x8f, 0x8b, 0x89, 0x88, 0x86, 0x85, 0x82,
			0x80, 0x7e, 0x7c, 0x7c, 0x7e, 0x81, 0x82, 0x81, 0x82, 0x84, 0x82,
			0x7d, 0x78, 0x75, 0x74, 0x74, 0x73, 0x74, 0x75, 0x74, 0x74, 0x73,
			0x73, 0x73, 0x71, 0x6f, 0x6e, 0x6b, 0x68, 0x66, 0x68, 0x6a, 0x68,
			0x68, 0x6a, 0x69, 0x67, 0x6a, 0x78, 0x9b, 0xc0, 0xc5, 0xb1, 0x9b,
			0x93, 0x92, 0x89, 0x7e, 0x76, 0x6f, 0x6a, 0x71, 0x7f, 0x8c, 0x8f,
			0x8b, 0x8e, 0x97, 0x98, 0x92, 0x8a, 0x81, 0x78, 0x73, 0x74, 0x75,
			0x73, 0x75, 0x7b, 0x81, 0x84, 0x85, 0x85, 0x84, 0x82, 0x7f, 0x7f,
			0x80, 0x81, 0x81, 0x7f, 0x7d, 0x7e, 0x83, 0x8c, 0x91, 0x8d, 0x89,
			0x86, 0x83, 0x81, 0x7f, 0x7e, 0x7c, 0x79, 0x79, 0x7b, 0x7c, 0x7c,
			0x7a, 0x7a, 0x79, 0x77, 0x75, 0x75, 0x75, 0x74, 0x75, 0x79, 0x7a,
			0x77, 0x74, 0x73, 0x72, 0x6e, 0x6c, 0x6c, 0x6b, 0x6b, 0x6c, 0x6d,
			0x6d, 0x6e, 0x71, 0x73, 0x76, 0x8a, 0xab, 0xbd, 0xb5, 0xa2, 0x95,
			0x8d, 0x84, 0x7c, 0x77, 0x6f, 0x6b, 0x74, 0x84, 0x8d, 0x8d, 0x8f,
			0x94, 0x94, 0x8f, 0x8d, 0x87, 0x7b, 0x73, 0x75, 0x79, 0x79, 0x78,
			0x7b, 0x7e, 0x81, 0x83, 0x84, 0x82, 0x80, 0x80, 0x81, 0x7f, 0x7c,
			0x7c, 0x7c, 0x7a, 0x7c, 0x81, 0x85, 0x88, 0x8f, 0x90, 0x8a, 0x88,
			0x86, 0x82, 0x7d, 0x7a, 0x7a, 0x79, 0x79, 0x7d, 0x7d, 0x7b, 0x7a,
			0x7b, 0x7c, 0x7b, 0x7c, 0x7d, 0x7c, 0x7a, 0x79, 0x77, 0x75, 0x72,
			0x71, 0x71, 0x70, 0x70, 0x71, 0x71, 0x6f, 0x6d, 0x6c, 0x6c, 0x6b,
			0x6d, 0x6e, 0x6f, 0x72, 0x73, 0x7b, 0x91, 0xb0, 0xbd, 0xb1, 0x9e,
			0x8b, 0x7f, 0x7d, 0x7f, 0x7a, 0x70, 0x74, 0x80, 0x8c, 0x95, 0x97,
			0x94, 0x8e, 0x89, 0x89, 0x84, 0x7e, 0x78, 0x73, 0x75, 0x7c, 0x84,
			0x86, 0x84, 0x86, 0x89, 0x87, 0x83, 0x7f, 0x7a, 0x73, 0x74, 0x77,
			0x79, 0x7b, 0x7c, 0x7e, 0x85, 0x8b, 0x8c, 0x88, 0x84, 0x80, 0x7e,
			0x7e, 0x81, 0x88, 0x89, 0x84, 0x86, 0x86, 0x84, 0x81, 0x7c, 0x77,
			0x74, 0x77, 0x7c, 0x7f, 0x80, 0x7e, 0x7c, 0x7b, 0x7c, 0x7b, 0x78,
			0x75, 0x70, 0x6f, 0x73, 0x75, 0x76, 0x75, 0x75, 0x74, 0x72, 0x73,
			0x6f, 0x6b, 0x6c, 0x6b, 0x6c, 0x6c, 0x6c, 0x6e, 0x6f, 0x7e, 0xa1,
			0xbc, 0xbe, 0xad, 0x95, 0x7e, 0x75, 0x7b, 0x7f, 0x79, 0x77, 0x7d,
			0x86, 0x93, 0x9c, 0x97, 0x8d, 0x87, 0x84, 0x7f, 0x7f, 0x7e, 0x78,
			0x76, 0x7b, 0x81, 0x86, 0x8a, 0x8b, 0x85, 0x7e, 0x7d, 0x7b, 0x79,
			0x78, 0x76, 0x73, 0x73, 0x7c, 0x86, 0x8a, 0x89, 0x87, 0x83, 0x81,
			0x80, 0x7d, 0x77, 0x78, 0x80, 0x86, 0x8b, 0x90, 0x8d, 0x84, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7b, 0x78, 0x7a, 0x7e, 0x7e, 0x7e, 0x7b,
			0x75, 0x75, 0x78, 0x7a, 0x7c, 0x7a, 0x77, 0x75, 0x76, 0x76, 0x75,
			0x75, 0x75, 0x75, 0x76, 0x75, 0x73, 0x72, 0x72, 0x72, 0x70, 0x6c,
			0x69, 0x6a, 0x6f, 0x7f, 0x9c, 0xb6, 0xb9, 0xac, 0x96, 0x83, 0x7a,
			0x7a, 0x7f, 0x7e, 0x7d, 0x7f, 0x85, 0x8f, 0x96, 0x94, 0x8e, 0x87,
			0x81, 0x7f, 0x80, 0x7f, 0x7b, 0x7a, 0x79, 0x7a, 0x80, 0x86, 0x88,
			0x89, 0x86, 0x80, 0x7b, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x7a, 0x80,
			0x86, 0x86, 0x82, 0x7f, 0x7d, 0x7e, 0x83, 0x8a, 0x8c, 0x8b, 0x8a,
			0x87, 0x81, 0x7d, 0x7b, 0x7b, 0x7c, 0x7e, 0x80, 0x7f, 0x80, 0x7e,
			0x7a, 0x77, 0x73, 0x72, 0x73, 0x75, 0x79, 0x7c, 0x7c, 0x79, 0x77,
			0x76, 0x76, 0x78, 0x79, 0x79, 0x77, 0x75, 0x75, 0x75, 0x76, 0x77,
			0x75, 0x74, 0x74, 0x75, 0x74, 0x73, 0x71, 0x6d, 0x6a, 0x6b, 0x7a,
			0x99, 0xb0, 0xb6, 0xb1, 0x9c, 0x85, 0x7b, 0x7e, 0x86, 0x89, 0x86,
			0x81, 0x7b, 0x7f, 0x8a, 0x92, 0x96, 0x8f, 0x84, 0x7d, 0x7d, 0x83,
			0x88, 0x88, 0x81, 0x79, 0x75, 0x79, 0x81, 0x87, 0x88, 0x82, 0x7c,
			0x78, 0x79, 0x7d, 0x80, 0x7f, 0x7c, 0x7a, 0x7a, 0x7c, 0x7f, 0x82,
			0x81, 0x80, 0x82, 0x84, 0x87, 0x89, 0x87, 0x82, 0x7d, 0x7b, 0x7b,
			0x7d, 0x80, 0x80, 0x7f, 0x7c, 0x79, 0x77, 0x77, 0x79, 0x79, 0x79,
			0x79, 0x79, 0x78, 0x79, 0x7a, 0x7a, 0x7a, 0x7a, 0x79, 0x77, 0x77,
			0x77, 0x77, 0x77, 0x79, 0x7c, 0x7c, 0x7d, 0x7e, 0x7b, 0x79, 0x78,
			0x79, 0x79, 0x78, 0x77, 0x72, 0x6b, 0x66, 0x65, 0x76, 0x94, 0xa9,
			0xb6, 0xb3, 0x9e, 0x88, 0x7d, 0x7e, 0x85, 0x8b, 0x8e, 0x88, 0x81,
			0x7f, 0x81, 0x87, 0x8e, 0x92, 0x90, 0x87, 0x7f, 0x7c, 0x7f, 0x84,
			0x88, 0x86, 0x82, 0x7c, 0x78, 0x78, 0x7b, 0x7e, 0x80, 0x80, 0x7d,
			0x7a, 0x7a, 0x7b, 0x7e, 0x83, 0x84, 0x83, 0x80, 0x7d, 0x7e, 0x80,
			0x84, 0x86, 0x86, 0x83, 0x7e, 0x7c, 0x7c, 0x80, 0x84, 0x84, 0x80,
			0x7a, 0x74, 0x72, 0x75, 0x7a, 0x7d, 0x7e, 0x7b, 0x76, 0x73, 0x74,
			0x76, 0x79, 0x7c, 0x7c, 0x79, 0x76, 0x76, 0x78, 0x7b, 0x7d, 0x7f,
			0x7d, 0x7a, 0x79, 0x79, 0x79, 0x7b, 0x7c, 0x7b, 0x7a, 0x79, 0x78,
			0x77, 0x76, 0x74, 0x72, 0x6f, 0x6c, 0x6e, 0x7a, 0x8b, 0x9a, 0xa5,
			0xa7, 0x9f, 0x94, 0x8b, 0x87, 0x87, 0x8c, 0x8e, 0x8c, 0x86, 0x80,
			0x7c, 0x7e, 0x84, 0x8b, 0x8e, 0x8d, 0x89, 0x83, 0x81, 0x80, 0x81,
			0x83, 0x83, 0x81, 0x7d, 0x79, 0x76, 0x75, 0x78, 0x7b, 0x7e, 0x80,
			0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7e, 0x7d, 0x7a,
			0x79, 0x7b, 0x7f, 0x84, 0x88, 0x8a, 0x89, 0x86, 0x83, 0x80, 0x7e,
			0x7e, 0x7f, 0x7d, 0x7c, 0x7a, 0x78, 0x77, 0x79, 0x7a, 0x7b, 0x7b,
			0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x7d, 0x7b, 0x79, 0x78, 0x77, 0x77,
			0x79, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7b, 0x7b,
			0x7a, 0x79, 0x77, 0x76, 0x75, 0x75, 0x76, 0x77, 0x7e, 0x86, 0x8c,
			0x93, 0x95, 0x93, 0x91, 0x8e, 0x8c, 0x8c, 0x8e, 0x90, 0x8e, 0x8b,
			0x87, 0x82, 0x81, 0x81, 0x83, 0x86, 0x87, 0x87, 0x86, 0x85, 0x85,
			0x84, 0x84, 0x85, 0x84, 0x82, 0x7f, 0x7c, 0x79, 0x78, 0x78, 0x79,
			0x7b, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x7f, 0x7f,
			0x7d, 0x7b, 0x7b, 0x7c, 0x7c, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7c, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7b, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7e,
			0x80, 0x83, 0x85, 0x86, 0x86, 0x86, 0x86, 0x86, 0x88, 0x89, 0x8a,
			0x8b, 0x8b, 0x8b, 0x8a, 0x89, 0x88, 0x88, 0x88, 0x89, 0x88, 0x87,
			0x86, 0x85, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x79, 0x79, 0x79,
			0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x79,
			0x79, 0x79, 0x7a, 0x79, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x82, 0x83, 0x83,
			0x83, 0x84, 0x84, 0x83, 0x84, 0x84, 0x84, 0x85, 0x85, 0x84, 0x84,
			0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x82, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d,
			0x7d, 0x7c, 0x7b, 0x7b, 0x7a, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
		},
		{ // 1
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x84,
			0x8a, 0x8f, 0x93, 0x94, 0x95, 0x95, 0x94, 0x91, 0x8f, 0x8d, 0x8c,
			0x8b, 0x8a, 0x8a, 0x89, 0x87, 0x85, 0x83, 0x82, 0x80, 0x80, 0x81,
			0x82, 0x82, 0x81, 0x7f, 0x7e, 0x7d, 0x7c, 0x7a, 0x79, 0x79, 0x78,
			0x77, 0x77, 0x79, 0x7b, 0x7d, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d,
			0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7a, 0x79, 0x79, 0x78, 0x77, 0x77,
			0x77, 0x78, 0x77, 0x76, 0x75, 0x75, 0x75, 0x76, 0x75, 0x75, 0x74,
			0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x75, 0x77, 0x7a, 0x7e, 0x84,
			0x8a, 0x91, 0x98, 0x9c, 0x9e, 0x9f, 0x9d, 0x9a, 0x97, 0x94, 0x93,
			0x92, 0x91, 0x90, 0x8e, 0x8a, 0x85, 0x80, 0x7d, 0x7a, 0x7a, 0x7a,
			0x7c, 0x7f, 0x81, 0x83, 0x83, 0x83, 0x82, 0x81, 0x7f, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x77, 0x74, 0x72, 0x71, 0x70, 0x70,
			0x70, 0x71, 0x70, 0x6e, 0x6c, 0x6a, 0x6a, 0x6b, 0x6c, 0x6d, 0x6d,
			0x6a, 0x68, 0x6a, 0x6f, 0x78, 0x85, 0x92, 0x9f, 0xa7, 0xab, 0xac,
			0xaa, 0xa7, 0xa2, 0x9c, 0x98, 0x94, 0x92, 0x91, 0x8f, 0x8c, 0x87,
			0x81, 0x7b, 0x76, 0x74, 0x74, 0x77, 0x7a, 0x7e, 0x81, 0x84, 0x85,
			0x84, 0x84, 0x82, 0x81, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7d, 0x7b, 0x7a, 0x79, 0x77,
			0x76, 0x75, 0x73, 0x72, 0x71, 0x6f, 0x6d, 0x6b, 0x69, 0x69, 0x6a,
			0x6a, 0x6a, 0x6b, 0x6b, 0x69, 0x67, 0x69, 0x6d, 0x75, 0x81, 0x8f,
			0x9c, 0xa6, 0xab, 0xad, 0xac, 0xa9, 0xa4, 0x9d, 0x97, 0x92, 0x8f,
			0x8d, 0x8c, 0x8a, 0x88, 0x85, 0x81, 0x7e, 0x7c, 0x7d, 0x7f, 0x81,
			0x83, 0x84, 0x84, 0x82, 0x80, 0x7e, 0x7d, 0x7e, 0x7f, 0x82, 0x85,
			0x87, 0x87, 0x86, 0x84, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7d, 0x77, 0x71, 0x69, 0x62, 0x5b, 0x56, 0x53, 0x52, 0x52, 0x52,
			0x52, 0x52, 0x51, 0x4f, 0x50, 0x59, 0x66, 0x7b, 0x92, 0xa8, 0xb9,
			0xbe, 0xbb, 0xb1, 0x9f, 0x8c, 0x7a, 0x6e, 0x69, 0x6c, 0x77, 0x85,
			0x94, 0xa1, 0xa7, 0xa7, 0xa0, 0x97, 0x8b, 0x82, 0x7c, 0x78, 0x78,
			0x79, 0x7c, 0x80, 0x82, 0x84, 0x86, 0x87, 0x87, 0x87, 0x85, 0x84,
			0x82, 0x81, 0x80, 0x82, 0x83, 0x86, 0x87, 0x85, 0x82, 0x7c, 0x73,
			0x6a, 0x62, 0x5d, 0x5a, 0x59, 0x5b, 0x5c, 0x5d, 0x5c, 0x5c, 0x5b,
			0x57, 0x50, 0x4e, 0x54, 0x63, 0x7b, 0x95, 0xaf, 0xbe, 0xbe, 0xb9,
			0xa8, 0x92, 0x7d, 0x6c, 0x64, 0x66, 0x71, 0x81, 0x94, 0xa3, 0xac,
			0xab, 0xa3, 0x96, 0x87, 0x7a, 0x74, 0x72, 0x76, 0x7c, 0x81, 0x86,
			0x88, 0x86, 0x83, 0x80, 0x7f, 0x80, 0x82, 0x85, 0x89, 0x8b, 0x8b,
			0x8a, 0x88, 0x85, 0x82, 0x7f, 0x7c, 0x79, 0x76, 0x72, 0x6f, 0x6c,
			0x6a, 0x67, 0x63, 0x61, 0x5e, 0x5c, 0x5b, 0x5a, 0x57, 0x55, 0x52,
			0x51, 0x5b, 0x6a, 0x83, 0x9e, 0xb3, 0xbf, 0xbd, 0xae, 0x96, 0x7d,
			0x69, 0x5f, 0x63, 0x72, 0x87, 0x9c, 0xaa, 0xaf, 0xaa, 0x9c, 0x8d,
			0x7d, 0x74, 0x71, 0x76, 0x7f, 0x87, 0x8d, 0x8d, 0x8a, 0x83, 0x7a,
			0x75, 0x72, 0x75, 0x7c, 0x84, 0x8e, 0x93, 0x95, 0x93, 0x8e, 0x88,
			0x81, 0x7d, 0x7a, 0x79, 0x7a, 0x7a, 0x7a, 0x78, 0x76, 0x72, 0x6d,
			0x67, 0x62, 0x5e, 0x5c, 0x5b, 0x59, 0x58, 0x57, 0x55, 0x54, 0x56,
			0x61, 0x71, 0x89, 0xa3, 0xb4, 0xbc, 0xb5, 0xa3, 0x8b, 0x74, 0x66,
			0x64, 0x70, 0x83, 0x97, 0xa6, 0xab, 0xa7, 0x9a, 0x8b, 0x7e, 0x76,
			0x76, 0x7b, 0x83, 0x8a, 0x8c, 0x8a, 0x85, 0x7e, 0x79, 0x76, 0x78,
			0x7a, 0x7e, 0x82, 0x85, 0x89, 0x8a, 0x8a, 0x8a, 0x89, 0x88, 0x87,
			0x87, 0x87, 0x86, 0x85, 0x81, 0x7c, 0x77, 0x73, 0x71, 0x71, 0x72,
			0x73, 0x71, 0x6c, 0x66, 0x5d, 0x56, 0x51, 0x4d, 0x4b, 0x4c, 0x4f,
			0x5f, 0x75, 0x8c, 0xa9, 0xb7, 0xb9, 0xaf, 0x96, 0x7e, 0x68, 0x61,
			0x68, 0x7c, 0x95, 0xa7, 0xb1, 0xad, 0x9e, 0x8c, 0x7a, 0x70, 0x70,
			0x78, 0x85, 0x8f, 0x93, 0x8f, 0x85, 0x7b, 0x73, 0x73, 0x78, 0x80,
			0x86, 0x87, 0x83, 0x7d, 0x79, 0x7c, 0x83, 0x8e, 0x96, 0x9a, 0x97,
			0x8d, 0x82, 0x79, 0x74, 0x76, 0x7b, 0x81, 0x85, 0x85, 0x81, 0x79,
			0x71, 0x69, 0x64, 0x61, 0x61, 0x62, 0x62, 0x60, 0x5d, 0x58, 0x54,
			0x4f, 0x54, 0x66, 0x7b, 0x95, 0xac, 0xb8, 0xb5, 0xa3, 0x8b, 0x75,
			0x6a, 0x6e, 0x7d, 0x93, 0xa2, 0xa7, 0xa1, 0x93, 0x85, 0x7b, 0x7b,
			0x80, 0x87, 0x8e, 0x8e, 0x89, 0x82, 0x7a, 0x78, 0x7a, 0x80, 0x87,
			0x8b, 0x8a, 0x82, 0x77, 0x6d, 0x67, 0x68, 0x72, 0x84, 0x96, 0xa3,
			0xa7, 0x9e, 0x8f, 0x7e, 0x72, 0x71, 0x79, 0x85, 0x90, 0x94, 0x90,
			0x85, 0x77, 0x6b, 0x65, 0x65, 0x67, 0x6c, 0x6f, 0x6f, 0x6b, 0x65,
			0x5f, 0x5a, 0x58, 0x57, 0x57, 0x5c, 0x68, 0x78, 0x89, 0xa2, 0xb2,
			0xae, 0xa6, 0x94, 0x81, 0x78, 0x77, 0x7f, 0x8c, 0x95, 0x99, 0x97,
			0x90, 0x88, 0x85, 0x83, 0x83, 0x83, 0x81, 0x7f, 0x7e, 0x7e, 0x82,
			0x87, 0x8a, 0x89, 0x82, 0x78, 0x6f, 0x6a, 0x6d, 0x76, 0x81, 0x8a,
			0x8d, 0x8a, 0x83, 0x7c, 0x7d, 0x83, 0x8d, 0x96, 0x96, 0x90, 0x88,
			0x81, 0x7f, 0x81, 0x83, 0x83, 0x80, 0x7b, 0x76, 0x74, 0x75, 0x77,
			0x77, 0x75, 0x73, 0x6f, 0x6d, 0x6e, 0x6c, 0x6b, 0x68, 0x68, 0x67,
			0x65, 0x65, 0x60, 0x5e, 0x5e, 0x76, 0x9b, 0xaf, 0xbf, 0xb7, 0x9d,
			0x7f, 0x65, 0x62, 0x70, 0x8a, 0x9c, 0xa0, 0x9d, 0x8a, 0x7f, 0x7f,
			0x81, 0x8c, 0x91, 0x91, 0x8a, 0x7d, 0x73, 0x6f, 0x76, 0x80, 0x88,
			0x8e, 0x8c, 0x85, 0x7b, 0x72, 0x6e, 0x6e, 0x74, 0x7d, 0x85, 0x8b,
			0x89, 0x85, 0x81, 0x7d, 0x7e, 0x83, 0x8a, 0x8f, 0x92, 0x8c, 0x82,
			0x7b, 0x78, 0x7b, 0x81, 0x87, 0x87, 0x83, 0x7b, 0x75, 0x72, 0x73,
			0x76, 0x78, 0x78, 0x76, 0x75, 0x74, 0x72, 0x72, 0x72, 0x70, 0x6f,
			0x6f, 0x6d, 0x6d, 0x6b, 0x68, 0x62, 0x5c, 0x6c, 0x92, 0xb4, 0xc4,
			0xbf, 0xa3, 0x7c, 0x63, 0x62, 0x76, 0x90, 0x9f, 0x9c, 0x92, 0x85,
			0x7e, 0x84, 0x8d, 0x90, 0x8a, 0x7e, 0x72, 0x6e, 0x75, 0x81, 0x8e,
			0x93, 0x8e, 0x83, 0x7a, 0x77, 0x79, 0x7c, 0x7e, 0x7c, 0x79, 0x77,
			0x7a, 0x7e, 0x83, 0x86, 0x86, 0x83, 0x7e, 0x7a, 0x7a, 0x7d, 0x84,
			0x8c, 0x90, 0x91, 0x8d, 0x84, 0x7d, 0x79, 0x7a, 0x7e, 0x83, 0x86,
			0x85, 0x81, 0x7e, 0x7b, 0x79, 0x78, 0x78, 0x76, 0x74, 0x73, 0x72,
			0x71, 0x71, 0x72, 0x74, 0x75, 0x76, 0x74, 0x70, 0x6c, 0x68, 0x66,
			0x64, 0x64, 0x64, 0x6a, 0x84, 0xa7, 0xbf, 0xc1, 0xac, 0x89, 0x6d,
			0x64, 0x6e, 0x83, 0x91, 0x91, 0x88, 0x82, 0x83, 0x8a, 0x91, 0x92,
			0x8a, 0x7e, 0x77, 0x77, 0x7d, 0x84, 0x88, 0x88, 0x85, 0x82, 0x82,
			0x84, 0x82, 0x7c, 0x75, 0x70, 0x71, 0x79, 0x80, 0x85, 0x87, 0x87,
			0x85, 0x85, 0x84, 0x80, 0x7b, 0x78, 0x7b, 0x84, 0x8d, 0x92, 0x90,
			0x87, 0x80, 0x7d, 0x7e, 0x80, 0x81, 0x80, 0x7e, 0x7b, 0x7b, 0x7d,
			0x7d, 0x79, 0x75, 0x72, 0x71, 0x72, 0x73, 0x73, 0x72, 0x73, 0x73,
			0x74, 0x75, 0x73, 0x70, 0x6e, 0x6d, 0x6d, 0x6d, 0x6e, 0x6d, 0x6d,
			0x70, 0x70, 0x6d, 0x72, 0x88, 0xa5, 0xb6, 0xaf, 0x9a, 0x86, 0x7d,
			0x83, 0x8b, 0x8d, 0x87, 0x81, 0x83, 0x8c, 0x94, 0x92, 0x8a, 0x83,
			0x80, 0x81, 0x81, 0x7d, 0x77, 0x75, 0x7d, 0x86, 0x8a, 0x88, 0x84,
			0x81, 0x81, 0x80, 0x7d, 0x78, 0x74, 0x74, 0x78, 0x7c, 0x80, 0x84,
			0x85, 0x86, 0x88, 0x87, 0x84, 0x81, 0x83, 0x8a, 0x90, 0x8d, 0x84,
			0x7f, 0x7f, 0x80, 0x82, 0x82, 0x80, 0x7f, 0x7f, 0x7e, 0x7d, 0x79,
			0x76, 0x75, 0x76, 0x75, 0x74, 0x72, 0x70, 0x71, 0x72, 0x72, 0x72,
			0x72, 0x72, 0x72, 0x73, 0x74, 0x71, 0x6d, 0x6c, 0x6d, 0x72, 0x74,
			0x72, 0x6f, 0x6f, 0x74, 0x7b, 0x83, 0x8b, 0x8d, 0x91, 0x9b, 0xa0,
			0x9e, 0x99, 0x93, 0x90, 0x8d, 0x8a, 0x87, 0x86, 0x87, 0x89, 0x89,
			0x88, 0x84, 0x80, 0x80, 0x7f, 0x80, 0x82, 0x84, 0x83, 0x80, 0x7e,
			0x7e, 0x7f, 0x7d, 0x7a, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7b,
			0x7d, 0x7e, 0x7f, 0x81, 0x81, 0x81, 0x85, 0x89, 0x8a, 0x87, 0x86,
			0x89, 0x8b, 0x8a, 0x87, 0x86, 0x85, 0x82, 0x81, 0x7f, 0x7f, 0x80,
			0x80, 0x7e, 0x7a, 0x77, 0x76, 0x73, 0x73, 0x74, 0x75, 0x75, 0x74,
			0x73, 0x73, 0x74, 0x74, 0x72, 0x71, 0x70, 0x6f, 0x6f, 0x6f, 0x6f,
			0x6f, 0x6f, 0x72, 0x72, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x74, 0x75,
			0x75, 0x77, 0x80, 0x86, 0x83, 0x88, 0x93, 0x97, 0x96, 0x97, 0x99,
			0x9e, 0x9e, 0x9b, 0x9b, 0x9c, 0x9a, 0x99, 0x96, 0x90, 0x8b, 0x89,
			0x85, 0x82, 0x80, 0x7e, 0x7f, 0x7e, 0x7b, 0x79, 0x7a, 0x7a, 0x78,
			0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x79, 0x78, 0x78,
			0x7b, 0x7d, 0x80, 0x85, 0x88, 0x86, 0x89, 0x91, 0x90, 0x8b, 0x8a,
			0x8e, 0x8f, 0x8c, 0x87, 0x85, 0x86, 0x84, 0x7e, 0x7a, 0x75, 0x73,
			0x73, 0x70, 0x6c, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6c, 0x6c, 0x6c,
			0x6e, 0x6f, 0x70, 0x70, 0x71, 0x72, 0x72, 0x73, 0x75, 0x74, 0x72,
			0x73, 0x73, 0x73, 0x74, 0x74, 0x73, 0x74, 0x72, 0x72, 0x74, 0x77,
			0x80, 0x85, 0x82, 0x89, 0x98, 0x98, 0x94, 0x99, 0x9d, 0x9f, 0xa2,
			0x9f, 0x9d, 0xa0, 0x9e, 0x9a, 0x97, 0x91, 0x8d, 0x8d, 0x89, 0x84,
			0x83, 0x83, 0x80, 0x80, 0x7e, 0x7b, 0x7b, 0x7a, 0x77, 0x77, 0x77,
			0x75, 0x76, 0x75, 0x74, 0x75, 0x76, 0x75, 0x76, 0x78, 0x79, 0x7b,
			0x7c, 0x7d, 0x80, 0x84, 0x87, 0x89, 0x8a, 0x8d, 0x91, 0x91, 0x8e,
			0x8e, 0x8f, 0x8e, 0x8b, 0x88, 0x85, 0x83, 0x80, 0x7c, 0x78, 0x75,
			0x73, 0x71, 0x6e, 0x6c, 0x6d, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6f,
			0x6e, 0x6e, 0x6e, 0x6f, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x75,
			0x77, 0x79, 0x77, 0x76, 0x77, 0x79, 0x79, 0x77, 0x77, 0x79, 0x7b,
			0x81, 0x84, 0x85, 0x8b, 0x93, 0x94, 0x94, 0x97, 0x9a, 0x9e, 0x9f,
			0x9d, 0x9e, 0xa1, 0xa0, 0x9d, 0x9b, 0x97, 0x93, 0x92, 0x8d, 0x87,
			0x86, 0x85, 0x83, 0x81, 0x7f, 0x7d, 0x7d, 0x7b, 0x79, 0x79, 0x78,
			0x75, 0x75, 0x75, 0x73, 0x72, 0x73, 0x72, 0x73, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7c, 0x7e, 0x81, 0x83, 0x85, 0x86, 0x8b, 0x8f, 0x8d,
			0x8c, 0x8e, 0x8f, 0x8d, 0x8a, 0x87, 0x86, 0x86, 0x83, 0x7f, 0x7c,
			0x79, 0x78, 0x76, 0x73, 0x71, 0x71, 0x70, 0x6f, 0x6e, 0x6e, 0x6e,
			0x6e, 0x6e, 0x6d, 0x6e, 0x6e, 0x6d, 0x6e, 0x70, 0x70, 0x70, 0x72,
			0x72, 0x74, 0x76, 0x77, 0x78, 0x7a, 0x7a, 0x7a, 0x7b, 0x7a, 0x7b,
			0x7c, 0x7a, 0x7a, 0x80, 0x81, 0x7d, 0x7d, 0x86, 0x8b, 0x86, 0x84,
			0x8c, 0x94, 0x92, 0x8f, 0x92, 0x97, 0x9a, 0x99, 0x97, 0x98, 0x9a,
			0x99, 0x96, 0x93, 0x91, 0x8f, 0x8d, 0x8b, 0x87, 0x85, 0x85, 0x83,
			0x7f, 0x7d, 0x7d, 0x7b, 0x79, 0x78, 0x77, 0x78, 0x77, 0x76, 0x75,
			0x76, 0x76, 0x76, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7b, 0x7c,
			0x7e, 0x80, 0x80, 0x81, 0x85, 0x86, 0x84, 0x85, 0x88, 0x88, 0x86,
			0x86, 0x86, 0x86, 0x86, 0x84, 0x82, 0x82, 0x82, 0x80, 0x7e, 0x7d,
			0x7c, 0x7c, 0x7b, 0x79, 0x78, 0x79, 0x78, 0x77, 0x77, 0x77, 0x76,
			0x77, 0x77, 0x76, 0x76, 0x76, 0x77, 0x77, 0x76, 0x77, 0x78, 0x78,
			0x78, 0x79, 0x79, 0x79, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x7e,
			0x7f, 0x80, 0x82, 0x84, 0x83, 0x83, 0x85, 0x86, 0x86, 0x86, 0x86,
			0x86, 0x85, 0x85, 0x84, 0x83, 0x81, 0x80, 0x7e, 0x7d, 0x7c, 0x7b,
			0x7a, 0x79, 0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78,
			0x78, 0x78, 0x79, 0x7a, 0x7a, 0x7a, 0x7b, 0x7c, 0x7c, 0x7b, 0x7b,
			0x7d, 0x7d, 0x7d, 0x7c, 0x7e, 0x7f, 0x7e, 0x7d, 0x7f, 0x80, 0x80,
			0x81, 0x83, 0x84, 0x84, 0x85, 0x87, 0x88, 0x88, 0x8a, 0x8b, 0x8c,
			0x8c, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d, 0x8c, 0x8c, 0x8b, 0x8a, 0x89,
			0x88, 0x87, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7f, 0x7e, 0x7d, 0x7c,
			0x7c, 0x7b, 0x7a, 0x7a, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x79, 0x79,
			0x79, 0x79, 0x79, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7a, 0x7b, 0x7b,
			0x7a, 0x7a, 0x7b, 0x7b, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7a, 0x7b,
			0x7b, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f,
			0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7e,
			0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81,
			0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x85, 0x85, 0x85, 0x85, 0x86,
			0x86, 0x86, 0x85, 0x86, 0x86, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82,
			0x81, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82,
			0x83, 0x84, 0x83, 0x84, 0x85, 0x85, 0x85, 0x86, 0x85, 0x85, 0x86,
			0x86, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x83, 0x81,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c,
			0x7c, 0x7b, 0x7b, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7b,
			0x7b, 0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f,
		},
		{ // 2
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x7e, 0x7d,
			0x80, 0x7e, 0x7e, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x83, 0x7f,
			0x82, 0x7e, 0x83, 0x7e, 0x80, 0x80, 0x7d, 0x83, 0x7b, 0x81, 0x7d,
			0x81, 0x7b, 0x83, 0x7d, 0x7f, 0x83, 0x7b, 0x83, 0x7e, 0x7f, 0x82,
			0x7e, 0x7d, 0x83, 0x7c, 0x83, 0x82, 0x7a, 0x84, 0x80, 0x80, 0x80,
			0x80, 0x7e, 0x7a, 0x84, 0x7a, 0x7f, 0x86, 0x78, 0x80, 0x81, 0x7f,
			0x81, 0x81, 0x84, 0x76, 0x89, 0x7d, 0x7d, 0x8f, 0x7c, 0x87, 0x7f,
			0x82, 0x7a, 0x79, 0x7c, 0x73, 0x7e, 0x7e, 0x7a, 0x81, 0x7f, 0x81,
			0x80, 0x87, 0x81, 0x7f, 0x84, 0x7e, 0x83, 0x7d, 0x84, 0x77, 0x87,
			0x79, 0x7d, 0x82, 0x7c, 0x80, 0x7c, 0x82, 0x7c, 0x82, 0x7e, 0x83,
			0x81, 0x7f, 0x7b, 0x85, 0x7a, 0x85, 0x80, 0x7b, 0x84, 0x7a, 0x81,
			0x7b, 0x83, 0x80, 0x82, 0x7a, 0x82, 0x84, 0x7b, 0x84, 0x7e, 0x82,
			0x84, 0x7d, 0x88, 0x7c, 0x85, 0x81, 0x7e, 0x7f, 0x7e, 0x83, 0x7a,
			0x7e, 0x7d, 0x7d, 0x7d, 0x81, 0x7d, 0x89, 0x7a, 0x82, 0x80, 0x85,
			0x7f, 0x7b, 0x8a, 0x74, 0x85, 0x78, 0x81, 0x7d, 0x81, 0x80, 0x7a,
			0x85, 0x7e, 0x81, 0x7e, 0x83, 0x7d, 0x83, 0x77, 0x81, 0x82, 0x79,
			0x82, 0x83, 0x85, 0x7e, 0x87, 0x7e, 0x82, 0x83, 0x79, 0x80, 0x85,
			0x78, 0x79, 0x8d, 0x7e, 0x7e, 0x87, 0x7e, 0x7a, 0x81, 0x76, 0x7e,
			0x8a, 0x7b, 0x7f, 0x83, 0x7f, 0x7e, 0x84, 0x7a, 0x7d, 0x83, 0x7f,
			0x7d, 0x7e, 0x85, 0x7d, 0x80, 0x7e, 0x7d, 0x80, 0x81, 0x7d, 0x7b,
			0x84, 0x83, 0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x7e, 0x7c, 0x82, 0x7e,
			0x7c, 0x80, 0x84, 0x81, 0x7d, 0x83, 0x80, 0x7d, 0x85, 0x79, 0x7a,
			0x87, 0x7d, 0x79, 0x86, 0x80, 0x7b, 0x86, 0x7f, 0x7f, 0x86, 0x80,
			0x7b, 0x82, 0x7f, 0x79, 0x7c, 0x79, 0x7c, 0x7c, 0x7f, 0x7d, 0x7e,
			0x85, 0x7c, 0x7f, 0x83, 0x83, 0x81, 0x81, 0x82, 0x84, 0x87, 0x81,
			0x7c, 0x83, 0x83, 0x7c, 0x7d, 0x7f, 0x82, 0x7f, 0x7e, 0x7f, 0x80,
			0x80, 0x7f, 0x83, 0x82, 0x82, 0x84, 0x84, 0x83, 0x85, 0x84, 0x80,
			0x80, 0x7f, 0x7a, 0x7a, 0x79, 0x74, 0x77, 0x76, 0x72, 0x74, 0x78,
			0x76, 0x73, 0x7b, 0x7b, 0x76, 0x77, 0x75, 0x6f, 0x6a, 0x6b, 0x69,
			0x63, 0x63, 0x5f, 0x62, 0x60, 0x6e, 0x82, 0x7f, 0x89, 0x99, 0xa2,
			0xa4, 0xa8, 0xa9, 0xa6, 0xa7, 0xa2, 0x9a, 0x92, 0x90, 0x86, 0x7d,
			0x80, 0x7d, 0x7a, 0x7a, 0x7e, 0x85, 0x8e, 0x91, 0x91, 0x99, 0x9e,
			0x9b, 0x97, 0x9b, 0x98, 0x8d, 0x8c, 0x88, 0x7d, 0x7b, 0x7c, 0x78,
			0x75, 0x7a, 0x7a, 0x78, 0x78, 0x75, 0x73, 0x70, 0x6a, 0x64, 0x62,
			0x60, 0x5d, 0x5a, 0x58, 0x59, 0x58, 0x53, 0x55, 0x5d, 0x58, 0x59,
			0x59, 0x6a, 0x8a, 0x87, 0x8a, 0xa1, 0xb3, 0xb3, 0xb1, 0xb8, 0xb1,
			0xb3, 0xaa, 0x9b, 0x94, 0x90, 0x86, 0x76, 0x78, 0x7c, 0x79, 0x77,
			0x7e, 0x88, 0x8d, 0x94, 0x97, 0x9a, 0x9e, 0x9b, 0x95, 0x8e, 0x8c,
			0x8a, 0x83, 0x7f, 0x80, 0x80, 0x7e, 0x7d, 0x82, 0x85, 0x87, 0x86,
			0x84, 0x81, 0x7d, 0x78, 0x71, 0x6a, 0x63, 0x5d, 0x58, 0x55, 0x54,
			0x52, 0x54, 0x57, 0x58, 0x58, 0x59, 0x5e, 0x5c, 0x59, 0x55, 0x73,
			0x8e, 0x89, 0x96, 0xa8, 0xb8, 0xb8, 0xb9, 0xb6, 0xaf, 0xb2, 0xa3,
			0x92, 0x88, 0x86, 0x7b, 0x6d, 0x72, 0x72, 0x72, 0x77, 0x7b, 0x85,
			0x90, 0x9b, 0x9b, 0x9d, 0xa2, 0xa1, 0x98, 0x8f, 0x89, 0x82, 0x7d,
			0x78, 0x75, 0x7a, 0x7e, 0x7f, 0x81, 0x88, 0x8c, 0x8d, 0x8d, 0x89,
			0x84, 0x80, 0x79, 0x72, 0x6d, 0x66, 0x61, 0x5d, 0x5a, 0x58, 0x58,
			0x57, 0x57, 0x5c, 0x5e, 0x5c, 0x58, 0x5c, 0x5c, 0x57, 0x5b, 0x6d,
			0x88, 0x90, 0x99, 0xa9, 0xb5, 0xbb, 0xb8, 0xb4, 0xae, 0xaa, 0xa0,
			0x8e, 0x81, 0x7b, 0x75, 0x6f, 0x6d, 0x70, 0x75, 0x7b, 0x84, 0x8e,
			0x99, 0x9f, 0xa2, 0xa2, 0x9e, 0x97, 0x8e, 0x84, 0x79, 0x73, 0x6f,
			0x65, 0x64, 0x6d, 0x78, 0x81, 0x89, 0x93, 0x9b, 0xa0, 0x9e, 0x99,
			0x95, 0x90, 0x86, 0x7b, 0x71, 0x6d, 0x69, 0x66, 0x63, 0x5f, 0x60,
			0x61, 0x61, 0x61, 0x64, 0x66, 0x65, 0x66, 0x67, 0x65, 0x61, 0x5d,
			0x58, 0x57, 0x55, 0x5a, 0x73, 0x87, 0x92, 0x9e, 0xaa, 0xb6, 0xb7,
			0xb5, 0xad, 0xa4, 0xa4, 0x9a, 0x89, 0x7d, 0x78, 0x73, 0x6d, 0x6e,
			0x6f, 0x75, 0x81, 0x8b, 0x92, 0x98, 0xa1, 0xa4, 0xa0, 0x9d, 0x97,
			0x8d, 0x81, 0x77, 0x6d, 0x65, 0x62, 0x64, 0x68, 0x70, 0x7a, 0x86,
			0x8f, 0x97, 0x9f, 0xa1, 0x9f, 0x99, 0x8f, 0x84, 0x7e, 0x76, 0x6d,
			0x66, 0x66, 0x69, 0x68, 0x6b, 0x6e, 0x71, 0x73, 0x72, 0x71, 0x6c,
			0x6a, 0x66, 0x5e, 0x5b, 0x56, 0x51, 0x50, 0x4f, 0x4b, 0x49, 0x4c,
			0x59, 0x79, 0x95, 0x9d, 0xa3, 0xb1, 0xbd, 0xc0, 0xbc, 0xad, 0xa1,
			0x9c, 0x93, 0x82, 0x6e, 0x67, 0x6b, 0x6c, 0x6a, 0x6e, 0x77, 0x83,
			0x8f, 0x9b, 0x9e, 0x9d, 0xa2, 0xa1, 0x9a, 0x91, 0x87, 0x7b, 0x72,
			0x6c, 0x66, 0x61, 0x64, 0x6c, 0x73, 0x7a, 0x84, 0x8e, 0x97, 0x9c,
			0x9f, 0x9e, 0x9a, 0x91, 0x86, 0x7d, 0x77, 0x73, 0x6f, 0x6b, 0x6b,
			0x70, 0x75, 0x77, 0x75, 0x77, 0x7a, 0x7a, 0x78, 0x73, 0x70, 0x6a,
			0x65, 0x62, 0x5a, 0x53, 0x53, 0x57, 0x57, 0x52, 0x54, 0x59, 0x56,
			0x56, 0x58, 0x7a, 0xaa, 0xad, 0xa3, 0xa5, 0xb8, 0xc0, 0xb9, 0xb2,
			0x91, 0x80, 0x8f, 0x8e, 0x76, 0x5e, 0x63, 0x6c, 0x76, 0x82, 0x7c,
			0x7b, 0x89, 0xa3, 0xac, 0x9b, 0x95, 0x92, 0x92, 0x95, 0x8a, 0x74,
			0x64, 0x6d, 0x76, 0x6f, 0x6a, 0x68, 0x71, 0x7f, 0x89, 0x88, 0x82,
			0x8b, 0x96, 0x98, 0x94, 0x8b, 0x87, 0x84, 0x82, 0x7e, 0x76, 0x74,
			0x74, 0x77, 0x7a, 0x7a, 0x79, 0x7a, 0x7f, 0x83, 0x80, 0x7e, 0x7c,
			0x7a, 0x77, 0x74, 0x6e, 0x66, 0x65, 0x68, 0x66, 0x63, 0x63, 0x62,
			0x65, 0x6b, 0x6c, 0x68, 0x67, 0x6a, 0x6b, 0x67, 0x61, 0x60, 0x73,
			0x94, 0xa3, 0x9f, 0x9b, 0xa1, 0xab, 0xb6, 0xb6, 0xa2, 0x8e, 0x8d,
			0x90, 0x8a, 0x7d, 0x70, 0x68, 0x70, 0x81, 0x82, 0x79, 0x79, 0x85,
			0x95, 0x9e, 0xa0, 0x99, 0x90, 0x91, 0x95, 0x90, 0x83, 0x78, 0x70,
			0x69, 0x6d, 0x71, 0x6d, 0x69, 0x6f, 0x7a, 0x82, 0x87, 0x86, 0x82,
			0x86, 0x91, 0x95, 0x90, 0x85, 0x7e, 0x7d, 0x81, 0x82, 0x7d, 0x78,
			0x74, 0x77, 0x7c, 0x7f, 0x7d, 0x79, 0x7a, 0x7e, 0x7f, 0x7b, 0x77,
			0x73, 0x71, 0x73, 0x72, 0x6f, 0x6d, 0x6d, 0x6e, 0x6d, 0x6b, 0x6a,
			0x6b, 0x6b, 0x6c, 0x6d, 0x6c, 0x6a, 0x69, 0x69, 0x67, 0x66, 0x64,
			0x67, 0x79, 0x8f, 0x9f, 0xa6, 0xa7, 0xa6, 0xa9, 0xb4, 0xb8, 0xae,
			0x9e, 0x91, 0x89, 0x85, 0x85, 0x7d, 0x70, 0x6b, 0x6e, 0x76, 0x7d,
			0x83, 0x86, 0x88, 0x8f, 0x97, 0x9c, 0x9b, 0x96, 0x8e, 0x84, 0x7d,
			0x79, 0x72, 0x6c, 0x67, 0x64, 0x65, 0x6c, 0x76, 0x7b, 0x7f, 0x84,
			0x8a, 0x8f, 0x95, 0x97, 0x94, 0x92, 0x8e, 0x87, 0x83, 0x80, 0x7c,
			0x77, 0x72, 0x6e, 0x6c, 0x71, 0x79, 0x7d, 0x7d, 0x7c, 0x7b, 0x7d,
			0x81, 0x81, 0x7c, 0x75, 0x70, 0x6d, 0x6c, 0x6c, 0x6c, 0x69, 0x68,
			0x69, 0x6a, 0x6d, 0x6f, 0x72, 0x72, 0x71, 0x72, 0x74, 0x75, 0x73,
			0x71, 0x70, 0x6d, 0x6b, 0x6d, 0x7c, 0x92, 0x9f, 0xa7, 0xa8, 0xa5,
			0xa4, 0xa9, 0xb3, 0xb2, 0xa9, 0x9d, 0x8d, 0x81, 0x7d, 0x7e, 0x7c,
			0x79, 0x77, 0x73, 0x74, 0x7c, 0x86, 0x8f, 0x94, 0x97, 0x93, 0x8e,
			0x8c, 0x8b, 0x88, 0x82, 0x7b, 0x70, 0x68, 0x67, 0x67, 0x6b, 0x71,
			0x77, 0x7b, 0x80, 0x86, 0x8c, 0x91, 0x95, 0x94, 0x90, 0x8b, 0x86,
			0x81, 0x7d, 0x79, 0x74, 0x6f, 0x6d, 0x6e, 0x6f, 0x71, 0x75, 0x78,
			0x79, 0x7b, 0x7d, 0x7f, 0x7f, 0x7e, 0x7a, 0x75, 0x73, 0x71, 0x71,
			0x71, 0x6f, 0x6d, 0x6b, 0x6c, 0x6d, 0x6e, 0x70, 0x73, 0x76, 0x78,
			0x79, 0x79, 0x77, 0x75, 0x75, 0x74, 0x74, 0x73, 0x72, 0x72, 0x73,
			0x7d, 0x90, 0x9e, 0xa8, 0xac, 0xaa, 0xa6, 0xa5, 0xaa, 0xac, 0xab,
			0xa5, 0x99, 0x8a, 0x7d, 0x77, 0x75, 0x77, 0x7a, 0x79, 0x76, 0x74,
			0x77, 0x7e, 0x86, 0x8f, 0x93, 0x93, 0x8f, 0x89, 0x83, 0x7e, 0x7c,
			0x7a, 0x78, 0x74, 0x6f, 0x6c, 0x6d, 0x71, 0x78, 0x80, 0x87, 0x8a,
			0x8b, 0x8b, 0x89, 0x88, 0x87, 0x87, 0x85, 0x81, 0x7c, 0x75, 0x70,
			0x6f, 0x70, 0x72, 0x74, 0x77, 0x77, 0x77, 0x77, 0x79, 0x7b, 0x7c,
			0x7d, 0x7c, 0x7a, 0x76, 0x72, 0x70, 0x70, 0x71, 0x72, 0x72, 0x72,
			0x73, 0x74, 0x75, 0x78, 0x7c, 0x7e, 0x7f, 0x7e, 0x7d, 0x7c, 0x79,
			0x79, 0x78, 0x76, 0x75, 0x74, 0x74, 0x73, 0x72, 0x74, 0x7c, 0x89,
			0x97, 0xa3, 0xab, 0xac, 0xa8, 0xa3, 0xa0, 0x9e, 0x9f, 0x9e, 0x9b,
			0x93, 0x88, 0x7f, 0x79, 0x78, 0x7b, 0x7f, 0x83, 0x83, 0x81, 0x80,
			0x80, 0x81, 0x84, 0x85, 0x84, 0x81, 0x7b, 0x75, 0x71, 0x71, 0x73,
			0x77, 0x7a, 0x7b, 0x7b, 0x7b, 0x7c, 0x80, 0x82, 0x84, 0x84, 0x82,
			0x80, 0x7e, 0x7c, 0x7b, 0x7b, 0x7c, 0x7b, 0x7a, 0x79, 0x78, 0x78,
			0x78, 0x78, 0x78, 0x79, 0x79, 0x78, 0x77, 0x76, 0x75, 0x75, 0x76,
			0x76, 0x77, 0x77, 0x77, 0x76, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76,
			0x74, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x79, 0x78, 0x7c, 0x85,
			0x8f, 0x99, 0xa0, 0xa4, 0xa2, 0x9f, 0x9c, 0x9b, 0x9b, 0x9d, 0x9e,
			0x9b, 0x96, 0x90, 0x89, 0x84, 0x83, 0x83, 0x85, 0x85, 0x85, 0x83,
			0x81, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7c, 0x79, 0x75, 0x72, 0x72,
			0x74, 0x76, 0x7a, 0x7c, 0x7c, 0x7b, 0x7a, 0x7a, 0x7a, 0x7c, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7c,
			0x7a, 0x79, 0x78, 0x78, 0x79, 0x79, 0x79, 0x78, 0x78, 0x77, 0x77,
			0x77, 0x77, 0x77, 0x77, 0x78, 0x78, 0x78, 0x79, 0x79, 0x79, 0x78,
			0x78, 0x78, 0x78, 0x79, 0x79, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x7a,
			0x7a, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81,
			0x82, 0x84, 0x85, 0x87, 0x89, 0x8a, 0x8b, 0x8d, 0x8e, 0x8e, 0x8e,
			0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8d, 0x8c, 0x8b, 0x8a, 0x89,
			0x88, 0x87, 0x86, 0x86, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7b, 0x7a, 0x7a, 0x79, 0x79,
			0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7a,
			0x7a, 0x7a, 0x7a, 0x79, 0x79, 0x78, 0x78, 0x77, 0x77, 0x77, 0x78,
			0x78, 0x78, 0x78, 0x77, 0x77, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7b,
			0x7b, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80,
			0x80, 0x81, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0x84, 0x84,
			0x84, 0x83, 0x83, 0x83, 0x84, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84,
			0x84, 0x84, 0x83, 0x83, 0x83, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
		},
		{ // 3
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x80,
			0x80, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x81, 0x80, 0x7d, 0x7e, 0x80, 0x7e, 0x80, 0x81, 0x7f, 0x80, 0x7f,
			0x7d, 0x81, 0x83, 0x7f, 0x7e, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x7e,
			0x80, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x82, 0x81, 0x7e, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7e, 0x7e, 0x80,
			0x80, 0x82, 0x81, 0x7e, 0x80, 0x81, 0x80, 0x80, 0x7e, 0x7d, 0x7f,
			0x7e, 0x7d, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7f, 0x80,
			0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x81, 0x7f,
			0x81, 0x80, 0x80, 0x81, 0x7e, 0x80, 0x7d, 0x7e, 0x7f, 0x7b, 0x7f,
			0x7e, 0x7f, 0x80, 0x7f, 0x82, 0x7e, 0x7e, 0x82, 0x7f, 0x81, 0x83,
			0x81, 0x82, 0x84, 0x85, 0x80, 0x80, 0x7e, 0x7b, 0x7d, 0x7d, 0x7e,
			0x80, 0x83, 0x81, 0x7e, 0x81, 0x81, 0x7e, 0x7f, 0x81, 0x7e, 0x80,
			0x82, 0x7e, 0x7f, 0x80, 0x7c, 0x7d, 0x7e, 0x7f, 0x7d, 0x84, 0x89,
			0x7f, 0x7e, 0x82, 0x80, 0x81, 0x80, 0x84, 0x82, 0x7e, 0x7d, 0x75,
			0x78, 0x80, 0x7b, 0x7c, 0x82, 0x83, 0x7e, 0x7d, 0x83, 0x81, 0x83,
			0x86, 0x85, 0x84, 0x83, 0x85, 0x86, 0x84, 0x84, 0x88, 0x8b, 0x8a,
			0x89, 0x88, 0x84, 0x83, 0x84, 0x84, 0x80, 0x80, 0x82, 0x87, 0x86,
			0x82, 0x87, 0x84, 0x7e, 0x78, 0x74, 0x70, 0x69, 0x67, 0x6c, 0x70,
			0x70, 0x6f, 0x6e, 0x71, 0x73, 0x6e, 0x6f, 0x71, 0x6d, 0x6f, 0x71,
			0x6f, 0x6a, 0x6d, 0x77, 0x82, 0x8a, 0x90, 0x97, 0x98, 0x99, 0x9c,
			0x9c, 0x9a, 0x97, 0x97, 0x97, 0x94, 0x93, 0x92, 0x90, 0x91, 0x8f,
			0x90, 0x8f, 0x8b, 0x88, 0x85, 0x83, 0x80, 0x7e, 0x79, 0x76, 0x74,
			0x70, 0x6d, 0x6b, 0x69, 0x66, 0x63, 0x65, 0x66, 0x66, 0x62, 0x5e,
			0x5d, 0x5c, 0x59, 0x57, 0x5b, 0x66, 0x77, 0x89, 0x92, 0x92, 0x93,
			0x99, 0xa0, 0xa3, 0x9f, 0x99, 0x95, 0x93, 0x91, 0x8c, 0x85, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x82, 0x86, 0x89, 0x8a, 0x8d, 0x91, 0x97,
			0x9b, 0x9b, 0x97, 0x90, 0x8a, 0x88, 0x87, 0x81, 0x7b, 0x77, 0x76,
			0x75, 0x74, 0x75, 0x74, 0x71, 0x6c, 0x69, 0x6a, 0x6c, 0x68, 0x62,
			0x5d, 0x5a, 0x5a, 0x58, 0x56, 0x5b, 0x69, 0x7b, 0x8b, 0x93, 0x92,
			0x91, 0x94, 0x9b, 0xa1, 0xa0, 0x9d, 0x99, 0x94, 0x8f, 0x88, 0x82,
			0x80, 0x80, 0x81, 0x7e, 0x7d, 0x7f, 0x84, 0x88, 0x8d, 0x90, 0x93,
			0x96, 0x97, 0x95, 0x91, 0x8e, 0x8b, 0x87, 0x82, 0x7d, 0x79, 0x75,
			0x73, 0x72, 0x6f, 0x6c, 0x6a, 0x69, 0x6a, 0x6b, 0x6b, 0x69, 0x66,
			0x63, 0x61, 0x5e, 0x59, 0x55, 0x56, 0x62, 0x76, 0x8b, 0x99, 0x9a,
			0x93, 0x8c, 0x8d, 0x98, 0xa5, 0xaa, 0xa6, 0x9a, 0x8d, 0x84, 0x80,
			0x80, 0x82, 0x84, 0x82, 0x7e, 0x7b, 0x7a, 0x7d, 0x82, 0x89, 0x91,
			0x97, 0x9b, 0x9b, 0x96, 0x91, 0x8d, 0x8b, 0x89, 0x85, 0x7e, 0x76,
			0x70, 0x70, 0x72, 0x72, 0x6f, 0x6c, 0x6a, 0x69, 0x68, 0x65, 0x61,
			0x5f, 0x5d, 0x5b, 0x59, 0x55, 0x53, 0x55, 0x60, 0x75, 0x8c, 0x9c,
			0x9f, 0x98, 0x8e, 0x8d, 0x98, 0xa5, 0xac, 0xa8, 0x9b, 0x8b, 0x7f,
			0x7c, 0x7f, 0x83, 0x84, 0x81, 0x7a, 0x74, 0x74, 0x7a, 0x85, 0x8f,
			0x96, 0x9a, 0x9c, 0x9b, 0x98, 0x95, 0x91, 0x8e, 0x8a, 0x84, 0x7c,
			0x75, 0x70, 0x70, 0x70, 0x6f, 0x6b, 0x67, 0x63, 0x62, 0x62, 0x60,
			0x5d, 0x5c, 0x5b, 0x59, 0x56, 0x51, 0x50, 0x56, 0x64, 0x7a, 0x90,
			0x9e, 0x9f, 0x98, 0x90, 0x90, 0x9a, 0xa6, 0xac, 0xa7, 0x98, 0x87,
			0x7b, 0x78, 0x7b, 0x80, 0x83, 0x7f, 0x79, 0x75, 0x76, 0x7f, 0x8a,
			0x94, 0x9b, 0x9e, 0x9e, 0x9d, 0x9d, 0x9b, 0x97, 0x91, 0x88, 0x7f,
			0x76, 0x70, 0x6c, 0x69, 0x66, 0x63, 0x61, 0x5f, 0x5d, 0x5b, 0x59,
			0x57, 0x56, 0x56, 0x56, 0x56, 0x54, 0x51, 0x50, 0x57, 0x69, 0x85,
			0x9e, 0xa9, 0xa3, 0x94, 0x8a, 0x8d, 0x9c, 0xaa, 0xad, 0xa2, 0x8d,
			0x7a, 0x71, 0x74, 0x7d, 0x83, 0x83, 0x7d, 0x77, 0x77, 0x7d, 0x89,
			0x96, 0xa1, 0xa8, 0xa8, 0xa4, 0x9e, 0x9a, 0x97, 0x94, 0x8e, 0x83,
			0x76, 0x6c, 0x66, 0x64, 0x64, 0x63, 0x5f, 0x59, 0x54, 0x52, 0x56,
			0x5b, 0x5a, 0x55, 0x52, 0x53, 0x56, 0x59, 0x54, 0x4e, 0x4e, 0x5b,
			0x76, 0x94, 0xa8, 0xa8, 0x9b, 0x8e, 0x8d, 0x98, 0xa6, 0xac, 0xa5,
			0x93, 0x80, 0x74, 0x73, 0x79, 0x7f, 0x80, 0x7d, 0x79, 0x78, 0x7d,
			0x87, 0x93, 0x9e, 0xa5, 0xa7, 0xa4, 0x9e, 0x98, 0x92, 0x8e, 0x89,
			0x81, 0x77, 0x6e, 0x67, 0x65, 0x64, 0x62, 0x5e, 0x5a, 0x58, 0x59,
			0x5c, 0x5e, 0x5f, 0x5e, 0x5c, 0x5a, 0x59, 0x58, 0x55, 0x4f, 0x4b,
			0x4f, 0x61, 0x7f, 0x9b, 0xa7, 0x9f, 0x91, 0x8c, 0x99, 0xad, 0xb3,
			0xa6, 0x8d, 0x7c, 0x7b, 0x85, 0x8a, 0x83, 0x75, 0x6a, 0x6c, 0x79,
			0x87, 0x8e, 0x8c, 0x89, 0x8d, 0x9b, 0xab, 0xb3, 0xae, 0x9e, 0x8f,
			0x86, 0x85, 0x83, 0x7d, 0x73, 0x69, 0x62, 0x5f, 0x60, 0x62, 0x64,
			0x62, 0x5d, 0x5b, 0x5b, 0x5a, 0x5c, 0x5f, 0x63, 0x63, 0x61, 0x5c,
			0x57, 0x54, 0x50, 0x4c, 0x4c, 0x57, 0x70, 0x8f, 0xa3, 0xa3, 0x96,
			0x8d, 0x93, 0xa6, 0xb3, 0xab, 0x95, 0x81, 0x7c, 0x83, 0x88, 0x83,
			0x77, 0x6d, 0x6e, 0x78, 0x84, 0x8a, 0x8b, 0x8b, 0x90, 0x9a, 0xa6,
			0xab, 0xa7, 0x9d, 0x94, 0x8e, 0x89, 0x82, 0x79, 0x72, 0x6f, 0x6c,
			0x68, 0x61, 0x5d, 0x5e, 0x61, 0x62, 0x5f, 0x5c, 0x5f, 0x66, 0x6a,
			0x64, 0x5c, 0x5a, 0x5f, 0x64, 0x62, 0x5b, 0x55, 0x53, 0x51, 0x50,
			0x55, 0x69, 0x87, 0x9c, 0x9a, 0x8a, 0x87, 0x9b, 0xb5, 0xb9, 0xa3,
			0x89, 0x81, 0x90, 0x9c, 0x92, 0x78, 0x66, 0x6c, 0x7e, 0x85, 0x7c,
			0x73, 0x7a, 0x8d, 0x9a, 0x9a, 0x96, 0x9a, 0xa4, 0xa7, 0x9d, 0x8f,
			0x88, 0x87, 0x85, 0x7d, 0x73, 0x6d, 0x6d, 0x6d, 0x6b, 0x68, 0x67,
			0x69, 0x6a, 0x68, 0x65, 0x62, 0x62, 0x63, 0x68, 0x6b, 0x67, 0x62,
			0x61, 0x61, 0x5d, 0x58, 0x57, 0x5d, 0x66, 0x68, 0x65, 0x69, 0x7c,
			0x97, 0xa3, 0x9c, 0x94, 0x98, 0xa3, 0xa5, 0x99, 0x8b, 0x85, 0x84,
			0x80, 0x7b, 0x79, 0x77, 0x74, 0x76, 0x7c, 0x84, 0x8b, 0x8c, 0x8d,
			0x91, 0x96, 0x99, 0x97, 0x93, 0x8e, 0x8c, 0x8c, 0x87, 0x7e, 0x78,
			0x7c, 0x83, 0x82, 0x7b, 0x77, 0x7d, 0x81, 0x7b, 0x72, 0x6e, 0x6d,
			0x66, 0x5c, 0x5c, 0x62, 0x6a, 0x71, 0x77, 0x77, 0x79, 0x80, 0x80,
			0x77, 0x6f, 0x6e, 0x6a, 0x60, 0x59, 0x59, 0x5a, 0x52, 0x47, 0x45,
			0x4b, 0x5e, 0x79, 0x89, 0x88, 0x8c, 0xa3, 0xb7, 0xb1, 0x9c, 0x9b,
			0xab, 0xa9, 0x8e, 0x7b, 0x83, 0x88, 0x79, 0x69, 0x6f, 0x7f, 0x80,
			0x79, 0x7d, 0x8d, 0x94, 0x90, 0x8e, 0x92, 0x94, 0x8f, 0x87, 0x84,
			0x86, 0x86, 0x7f, 0x78, 0x7a, 0x7f, 0x82, 0x83, 0x87, 0x8e, 0x90,
			0x8e, 0x8e, 0x8d, 0x87, 0x81, 0x7b, 0x73, 0x6c, 0x65, 0x5e, 0x5a,
			0x59, 0x59, 0x57, 0x5b, 0x65, 0x6e, 0x76, 0x7a, 0x79, 0x74, 0x6d,
			0x65, 0x5d, 0x59, 0x59, 0x58, 0x56, 0x57, 0x5b, 0x5a, 0x58, 0x5a,
			0x56, 0x54, 0x74, 0x95, 0x88, 0x7e, 0x9e, 0xbe, 0xa6, 0x8b, 0xa6,
			0xbc, 0xa0, 0x82, 0x93, 0xa1, 0x85, 0x6f, 0x7a, 0x85, 0x79, 0x72,
			0x7c, 0x85, 0x86, 0x84, 0x88, 0x8d, 0x91, 0x92, 0x8a, 0x87, 0x88,
			0x84, 0x79, 0x75, 0x7a, 0x77, 0x6f, 0x72, 0x7d, 0x82, 0x82, 0x8a,
			0x96, 0x9b, 0x98, 0x97, 0x9b, 0x97, 0x8c, 0x86, 0x83, 0x7d, 0x74,
			0x6f, 0x6e, 0x6b, 0x66, 0x63, 0x64, 0x62, 0x60, 0x61, 0x65, 0x63,
			0x61, 0x63, 0x66, 0x69, 0x68, 0x63, 0x63, 0x65, 0x62, 0x61, 0x65,
			0x66, 0x62, 0x62, 0x64, 0x66, 0x64, 0x60, 0x52, 0x67, 0x9a, 0x84,
			0x70, 0xa0, 0xba, 0x9d, 0x91, 0xb8, 0xb9, 0x96, 0x94, 0xa5, 0x9d,
			0x82, 0x80, 0x85, 0x7d, 0x74, 0x73, 0x7b, 0x78, 0x76, 0x7b, 0x80,
			0x84, 0x84, 0x8a, 0x8d, 0x8c, 0x8a, 0x87, 0x86, 0x7f, 0x79, 0x76,
			0x73, 0x71, 0x71, 0x74, 0x77, 0x7b, 0x7f, 0x83, 0x86, 0x88, 0x8b,
			0x8d, 0x8f, 0x90, 0x8e, 0x8d, 0x8d, 0x8a, 0x84, 0x82, 0x82, 0x7d,
			0x7a, 0x7d, 0x7c, 0x77, 0x78, 0x7a, 0x78, 0x76, 0x75, 0x74, 0x75,
			0x71, 0x6c, 0x6d, 0x6e, 0x6b, 0x68, 0x6b, 0x6c, 0x6a, 0x6d, 0x6d,
			0x69, 0x6c, 0x6f, 0x6a, 0x6b, 0x6f, 0x6c, 0x65, 0x66, 0x5f, 0x5f,
			0x83, 0x7c, 0x6f, 0x93, 0xa0, 0x94, 0x96, 0xac, 0xaa, 0x9d, 0xa0,
			0xa1, 0x9c, 0x8c, 0x84, 0x88, 0x7e, 0x71, 0x74, 0x79, 0x73, 0x70,
			0x7b, 0x81, 0x7e, 0x85, 0x8c, 0x8a, 0x8b, 0x8d, 0x8e, 0x89, 0x82,
			0x85, 0x82, 0x7a, 0x76, 0x77, 0x77, 0x73, 0x72, 0x76, 0x7b, 0x7a,
			0x7d, 0x87, 0x85, 0x85, 0x8b, 0x89, 0x87, 0x87, 0x87, 0x85, 0x85,
			0x85, 0x85, 0x87, 0x83, 0x81, 0x82, 0x7f, 0x7d, 0x7e, 0x7f, 0x7b,
			0x78, 0x79, 0x79, 0x75, 0x75, 0x75, 0x75, 0x75, 0x72, 0x72, 0x73,
			0x70, 0x6e, 0x6f, 0x6e, 0x6c, 0x6c, 0x6b, 0x6a, 0x6c, 0x6d, 0x6e,
			0x6c, 0x6b, 0x68, 0x66, 0x63, 0x5e, 0x7e, 0x7a, 0x6a, 0x8f, 0x9a,
			0x8c, 0x95, 0xa9, 0xa0, 0x9a, 0xa2, 0xa1, 0x9b, 0x92, 0x92, 0x91,
			0x85, 0x7c, 0x80, 0x7f, 0x73, 0x76, 0x7c, 0x7a, 0x79, 0x81, 0x85,
			0x81, 0x86, 0x8b, 0x8b, 0x89, 0x88, 0x89, 0x86, 0x7f, 0x80, 0x7f,
			0x77, 0x79, 0x79, 0x77, 0x77, 0x78, 0x7a, 0x7c, 0x7e, 0x80, 0x82,
			0x83, 0x85, 0x86, 0x87, 0x88, 0x87, 0x88, 0x87, 0x84, 0x84, 0x84,
			0x80, 0x7d, 0x7f, 0x7a, 0x76, 0x78, 0x76, 0x74, 0x74, 0x75, 0x75,
			0x74, 0x76, 0x75, 0x77, 0x77, 0x78, 0x7a, 0x77, 0x78, 0x7a, 0x77,
			0x76, 0x75, 0x74, 0x72, 0x71, 0x74, 0x72, 0x74, 0x73, 0x71, 0x71,
			0x6d, 0x6c, 0x68, 0x71, 0x7a, 0x71, 0x7d, 0x8a, 0x87, 0x89, 0x96,
			0x98, 0x95, 0x9b, 0x9f, 0x9c, 0x98, 0x99, 0x98, 0x90, 0x8c, 0x8d,
			0x88, 0x80, 0x81, 0x82, 0x7b, 0x7b, 0x7f, 0x7e, 0x7d, 0x7f, 0x83,
			0x81, 0x81, 0x84, 0x83, 0x83, 0x82, 0x82, 0x81, 0x7f, 0x7e, 0x7e,
			0x7c, 0x7a, 0x7c, 0x7b, 0x7a, 0x7c, 0x7d, 0x7d, 0x7e, 0x81, 0x82,
			0x82, 0x84, 0x85, 0x84, 0x84, 0x83, 0x82, 0x80, 0x7e, 0x7d, 0x7b,
			0x79, 0x79, 0x76, 0x75, 0x75, 0x74, 0x73, 0x73, 0x75, 0x74, 0x74,
			0x77, 0x77, 0x75, 0x77, 0x77, 0x76, 0x76, 0x76, 0x75, 0x74, 0x72,
			0x78, 0x77, 0x77, 0x7d, 0x7e, 0x7d, 0x79, 0x78, 0x75, 0x71, 0x6f,
			0x71, 0x7c, 0x75, 0x78, 0x87, 0x83, 0x84, 0x8d, 0x90, 0x8e, 0x93,
			0x96, 0x95, 0x95, 0x95, 0x95, 0x91, 0x90, 0x8f, 0x8b, 0x88, 0x87,
			0x86, 0x83, 0x82, 0x83, 0x82, 0x81, 0x82, 0x81, 0x80, 0x80, 0x81,
			0x80, 0x7f, 0x7f, 0x7f, 0x7c, 0x7c, 0x7c, 0x7a, 0x7a, 0x7a, 0x7a,
			0x7a, 0x7a, 0x7b, 0x7c, 0x7c, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d,
			0x7d, 0x7c, 0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7c, 0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7e, 0x7e, 0x7d, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x80,
			0x82, 0x82, 0x82, 0x83, 0x84, 0x84, 0x84, 0x86, 0x85, 0x86, 0x87,
			0x87, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x87, 0x86,
			0x84, 0x84, 0x82, 0x80, 0x7f, 0x7d, 0x7c, 0x7a, 0x79, 0x79, 0x78,
			0x77, 0x77, 0x76, 0x76, 0x76, 0x76, 0x76, 0x76, 0x77, 0x77, 0x78,
			0x78, 0x79, 0x7a, 0x79, 0x7b, 0x7b, 0x7a, 0x7c, 0x7b, 0x7b, 0x7d,
			0x7c, 0x7c, 0x7d, 0x7c, 0x7c, 0x7e, 0x7d, 0x7c, 0x7e, 0x7e, 0x7c,
			0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7c, 0x7d,
			0x7e, 0x7d, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x81, 0x82, 0x83, 0x85, 0x86, 0x86, 0x88, 0x89, 0x8a,
			0x8b, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8b, 0x8b, 0x8a,
			0x89, 0x88, 0x87, 0x86, 0x85, 0x85, 0x83, 0x82, 0x81, 0x80, 0x7e,
			0x7d, 0x7c, 0x7b, 0x79, 0x79, 0x78, 0x77, 0x77, 0x77, 0x77, 0x77,
			0x77, 0x77, 0x77, 0x78, 0x78, 0x78, 0x79, 0x79, 0x7a, 0x7a, 0x7a,
			0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7c, 0x7e, 0x7f, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7c,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x82,
			0x83, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84,
			0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81,
			0x81, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80,
		},
		{ // 4
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x82, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7e, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x80,
			0x81, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x82, 0x7f, 0x7e,
			0x80, 0x80, 0x80, 0x7f, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x80,
			0x7f, 0x80, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x81,
			0x7e, 0x80, 0x81, 0x7d, 0x80, 0x7f, 0x80, 0x81, 0x7e, 0x80, 0x81,
			0x81, 0x82, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x7d, 0x7c, 0x7e, 0x82, 0x82, 0x80, 0x7f, 0x7e, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x82, 0x81, 0x7f, 0x7e, 0x80, 0x7f,
			0x80, 0x81, 0x7f, 0x7e, 0x7f, 0x81, 0x80, 0x7d, 0x7e, 0x80, 0x80,
			0x82, 0x80, 0x7c, 0x80, 0x81, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x80,
			0x80, 0x7e, 0x7e, 0x80, 0x7f, 0x80, 0x7e, 0x7e, 0x80, 0x82, 0x81,
			0x7f, 0x81, 0x82, 0x7f, 0x7f, 0x82, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e,
			0x80, 0x83, 0x81, 0x80, 0x7f, 0x7d, 0x80, 0x81, 0x7f, 0x80, 0x80,
			0x7e, 0x7e, 0x7e, 0x80, 0x81, 0x7f, 0x7e, 0x7e, 0x7f, 0x83, 0x82,
			0x81, 0x80, 0x7f, 0x80, 0x7e, 0x7d, 0x80, 0x82, 0x81, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7d, 0x80, 0x82, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e,
			0x80, 0x83, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x80, 0x83, 0x81, 0x7e, 0x80, 0x81,
			0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x7e, 0x7e, 0x82, 0x80,
			0x7d, 0x7f, 0x83, 0x81, 0x7f, 0x7c, 0x7e, 0x83, 0x80, 0x80, 0x80,
			0x81, 0x80, 0x7b, 0x7a, 0x7f, 0x82, 0x83, 0x82, 0x7d, 0x7e, 0x7f,
			0x7f, 0x80, 0x7e, 0x7f, 0x81, 0x81, 0x80, 0x7f, 0x7d, 0x7d, 0x7d,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7d,
			0x7f, 0x7e, 0x7e, 0x7d, 0x7b, 0x7b, 0x7c, 0x80, 0x81, 0x81, 0x82,
			0x83, 0x86, 0x88, 0x8a, 0x8d, 0x8e, 0x8c, 0x8b, 0x8a, 0x87, 0x86,
			0x85, 0x85, 0x85, 0x85, 0x85, 0x82, 0x7f, 0x7d, 0x7d, 0x7d, 0x7f,
			0x83, 0x82, 0x7d, 0x79, 0x76, 0x72, 0x6f, 0x6c, 0x6a, 0x6b, 0x6c,
			0x6c, 0x6c, 0x6a, 0x65, 0x62, 0x63, 0x62, 0x60, 0x5e, 0x5e, 0x63,
			0x6b, 0x7a, 0x8e, 0xa1, 0xac, 0xad, 0xae, 0xa9, 0xa0, 0x97, 0x8d,
			0x87, 0x84, 0x82, 0x83, 0x83, 0x83, 0x81, 0x7f, 0x7d, 0x7b, 0x7d,
			0x80, 0x83, 0x89, 0x8c, 0x90, 0x92, 0x93, 0x91, 0x8c, 0x89, 0x86,
			0x84, 0x84, 0x84, 0x83, 0x80, 0x7e, 0x7a, 0x76, 0x74, 0x71, 0x70,
			0x6f, 0x6d, 0x6a, 0x66, 0x63, 0x5f, 0x5c, 0x5a, 0x58, 0x57, 0x55,
			0x55, 0x5e, 0x6c, 0x80, 0x98, 0xad, 0xb8, 0xb9, 0xb4, 0xa9, 0x99,
			0x8a, 0x7d, 0x75, 0x74, 0x75, 0x79, 0x7e, 0x80, 0x81, 0x80, 0x7f,
			0x80, 0x83, 0x88, 0x8f, 0x96, 0x9a, 0x9b, 0x97, 0x8f, 0x86, 0x7d,
			0x76, 0x74, 0x76, 0x7b, 0x80, 0x85, 0x87, 0x85, 0x83, 0x80, 0x7d,
			0x7c, 0x7b, 0x7a, 0x78, 0x74, 0x6f, 0x69, 0x64, 0x60, 0x5d, 0x5b,
			0x5c, 0x5d, 0x5f, 0x62, 0x67, 0x71, 0x7e, 0x8f, 0xa0, 0xae, 0xb8,
			0xb9, 0xb2, 0xa5, 0x95, 0x86, 0x79, 0x72, 0x6f, 0x71, 0x75, 0x7a,
			0x7d, 0x80, 0x81, 0x81, 0x83, 0x86, 0x8b, 0x91, 0x98, 0x9c, 0x9c,
			0x99, 0x91, 0x86, 0x7c, 0x73, 0x6f, 0x6f, 0x73, 0x78, 0x7e, 0x83,
			0x85, 0x85, 0x83, 0x80, 0x7e, 0x7d, 0x7e, 0x7d, 0x7c, 0x79, 0x74,
			0x6e, 0x67, 0x61, 0x5d, 0x5b, 0x5b, 0x5c, 0x5f, 0x62, 0x66, 0x6e,
			0x79, 0x87, 0x98, 0xa6, 0xb2, 0xb7, 0xb5, 0xad, 0xa0, 0x91, 0x81,
			0x76, 0x6e, 0x6a, 0x6c, 0x70, 0x74, 0x79, 0x7d, 0x81, 0x84, 0x88,
			0x8c, 0x90, 0x95, 0x98, 0x99, 0x98, 0x93, 0x8b, 0x81, 0x78, 0x71,
			0x6d, 0x70, 0x75, 0x7c, 0x84, 0x89, 0x8b, 0x8a, 0x88, 0x85, 0x81,
			0x7e, 0x7c, 0x7a, 0x79, 0x77, 0x75, 0x70, 0x6b, 0x66, 0x61, 0x5e,
			0x5d, 0x5c, 0x5e, 0x60, 0x63, 0x68, 0x71, 0x7d, 0x8c, 0x9a, 0xa8,
			0xb1, 0xb3, 0xb0, 0xa7, 0x9a, 0x8c, 0x7f, 0x75, 0x6f, 0x6e, 0x70,
			0x74, 0x79, 0x7e, 0x82, 0x86, 0x88, 0x8c, 0x8f, 0x92, 0x95, 0x95,
			0x93, 0x8e, 0x87, 0x7f, 0x77, 0x73, 0x71, 0x73, 0x79, 0x7f, 0x85,
			0x8a, 0x8c, 0x8b, 0x88, 0x84, 0x80, 0x7c, 0x79, 0x77, 0x75, 0x74,
			0x73, 0x71, 0x6e, 0x6b, 0x69, 0x67, 0x67, 0x67, 0x65, 0x65, 0x64,
			0x63, 0x63, 0x69, 0x72, 0x7e, 0x90, 0xa0, 0xae, 0xb9, 0xba, 0xb5,
			0xaa, 0x9b, 0x8b, 0x7d, 0x74, 0x6e, 0x6c, 0x6e, 0x70, 0x74, 0x78,
			0x7a, 0x7e, 0x82, 0x87, 0x8c, 0x92, 0x98, 0x9a, 0x9a, 0x96, 0x8d,
			0x84, 0x78, 0x6f, 0x69, 0x67, 0x6b, 0x74, 0x7f, 0x8a, 0x93, 0x98,
			0x96, 0x91, 0x8a, 0x82, 0x7c, 0x77, 0x74, 0x74, 0x74, 0x74, 0x74,
			0x73, 0x72, 0x70, 0x6e, 0x6c, 0x6b, 0x6a, 0x69, 0x68, 0x66, 0x65,
			0x64, 0x63, 0x67, 0x6e, 0x7b, 0x8b, 0x9b, 0xab, 0xb6, 0xba, 0xb7,
			0xad, 0x9f, 0x90, 0x82, 0x77, 0x70, 0x6d, 0x6d, 0x6f, 0x72, 0x76,
			0x79, 0x7d, 0x81, 0x86, 0x8b, 0x91, 0x96, 0x99, 0x9a, 0x95, 0x8e,
			0x84, 0x78, 0x6d, 0x65, 0x62, 0x63, 0x6a, 0x76, 0x82, 0x8e, 0x98,
			0x9d, 0x9e, 0x9a, 0x93, 0x8b, 0x82, 0x7a, 0x73, 0x6f, 0x6b, 0x6a,
			0x6a, 0x6b, 0x6e, 0x72, 0x77, 0x7c, 0x7f, 0x80, 0x7f, 0x7b, 0x75,
			0x6d, 0x65, 0x5e, 0x58, 0x57, 0x5a, 0x63, 0x72, 0x84, 0x99, 0xab,
			0xb8, 0xbd, 0xbb, 0xb3, 0xa6, 0x96, 0x87, 0x79, 0x70, 0x6a, 0x68,
			0x69, 0x6c, 0x71, 0x76, 0x7c, 0x82, 0x88, 0x8e, 0x93, 0x98, 0x9b,
			0x9a, 0x96, 0x8f, 0x84, 0x78, 0x6d, 0x64, 0x60, 0x60, 0x65, 0x6f,
			0x7b, 0x88, 0x93, 0x9b, 0x9f, 0x9f, 0x9a, 0x94, 0x8c, 0x84, 0x7c,
			0x75, 0x6f, 0x6b, 0x69, 0x68, 0x6a, 0x6d, 0x71, 0x77, 0x7d, 0x81,
			0x84, 0x82, 0x7e, 0x78, 0x70, 0x69, 0x63, 0x5e, 0x5d, 0x5d, 0x60,
			0x64, 0x6b, 0x76, 0x83, 0x92, 0xa1, 0xae, 0xb7, 0xb8, 0xb4, 0xac,
			0x9f, 0x91, 0x82, 0x77, 0x70, 0x6b, 0x6c, 0x6e, 0x71, 0x76, 0x79,
			0x7e, 0x82, 0x87, 0x8c, 0x90, 0x93, 0x93, 0x91, 0x8d, 0x86, 0x7e,
			0x76, 0x70, 0x6c, 0x6b, 0x6e, 0x73, 0x79, 0x82, 0x8a, 0x90, 0x95,
			0x96, 0x94, 0x8f, 0x89, 0x82, 0x7c, 0x78, 0x75, 0x74, 0x75, 0x76,
			0x77, 0x78, 0x79, 0x79, 0x79, 0x7a, 0x7a, 0x79, 0x78, 0x76, 0x74,
			0x71, 0x6e, 0x6c, 0x6a, 0x68, 0x67, 0x67, 0x67, 0x67, 0x68, 0x68,
			0x70, 0x7d, 0x8a, 0x9d, 0xad, 0xb6, 0xba, 0xb4, 0xa7, 0x96, 0x84,
			0x76, 0x6b, 0x69, 0x6c, 0x70, 0x78, 0x7d, 0x7e, 0x7f, 0x80, 0x81,
			0x84, 0x8a, 0x90, 0x94, 0x97, 0x97, 0x8f, 0x87, 0x7c, 0x70, 0x68,
			0x63, 0x64, 0x69, 0x73, 0x7d, 0x84, 0x8a, 0x8d, 0x8b, 0x8b, 0x8a,
			0x88, 0x89, 0x88, 0x87, 0x86, 0x84, 0x80, 0x7d, 0x7c, 0x7e, 0x7f,
			0x83, 0x86, 0x86, 0x85, 0x82, 0x7e, 0x79, 0x75, 0x73, 0x72, 0x73,
			0x74, 0x75, 0x75, 0x75, 0x74, 0x72, 0x71, 0x70, 0x6e, 0x6d, 0x6c,
			0x6b, 0x6a, 0x6a, 0x69, 0x67, 0x66, 0x65, 0x6a, 0x7a, 0x8a, 0x9c,
			0xb0, 0xb8, 0xb7, 0xaf, 0xa0, 0x8c, 0x7a, 0x70, 0x6b, 0x6c, 0x74,
			0x7b, 0x7e, 0x81, 0x80, 0x7c, 0x7c, 0x81, 0x89, 0x92, 0x9c, 0xa0,
			0x9b, 0x92, 0x85, 0x75, 0x6a, 0x64, 0x63, 0x69, 0x72, 0x7c, 0x83,
			0x87, 0x89, 0x88, 0x86, 0x86, 0x87, 0x88, 0x8a, 0x89, 0x87, 0x81,
			0x7a, 0x74, 0x71, 0x72, 0x77, 0x7e, 0x87, 0x8f, 0x95, 0x97, 0x95,
			0x91, 0x8a, 0x81, 0x7a, 0x73, 0x6f, 0x6e, 0x6f, 0x73, 0x76, 0x7a,
			0x7c, 0x7d, 0x7e, 0x7c, 0x78, 0x76, 0x72, 0x70, 0x6f, 0x6e, 0x6d,
			0x6b, 0x69, 0x68, 0x67, 0x67, 0x66, 0x64, 0x65, 0x68, 0x76, 0x8a,
			0x9e, 0xaf, 0xba, 0xb9, 0xad, 0x9a, 0x86, 0x77, 0x6d, 0x6e, 0x76,
			0x7e, 0x84, 0x86, 0x83, 0x7f, 0x7c, 0x7e, 0x86, 0x90, 0x99, 0x9f,
			0x9b, 0x8e, 0x80, 0x72, 0x69, 0x66, 0x6b, 0x75, 0x7c, 0x80, 0x82,
			0x80, 0x7d, 0x7d, 0x80, 0x84, 0x88, 0x8a, 0x88, 0x84, 0x7f, 0x7b,
			0x78, 0x78, 0x7b, 0x7e, 0x80, 0x85, 0x87, 0x89, 0x8b, 0x8c, 0x8a,
			0x89, 0x86, 0x83, 0x7e, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d,
			0x7b, 0x7b, 0x7b, 0x79, 0x77, 0x75, 0x73, 0x71, 0x6f, 0x70, 0x70,
			0x71, 0x72, 0x72, 0x72, 0x72, 0x71, 0x70, 0x6e, 0x6c, 0x6c, 0x70,
			0x73, 0x75, 0x7c, 0x91, 0xa7, 0xb2, 0xb1, 0xa8, 0x9a, 0x88, 0x79,
			0x78, 0x7e, 0x82, 0x82, 0x81, 0x80, 0x7e, 0x7f, 0x87, 0x91, 0x96,
			0x95, 0x8f, 0x89, 0x82, 0x7a, 0x78, 0x7a, 0x7b, 0x7b, 0x7a, 0x7b,
			0x7d, 0x7c, 0x7d, 0x80, 0x82, 0x83, 0x82, 0x81, 0x81, 0x81, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x80, 0x85, 0x8a,
			0x8d, 0x8e, 0x8d, 0x8a, 0x85, 0x7f, 0x7c, 0x7b, 0x7b, 0x7c, 0x7c,
			0x7e, 0x7e, 0x7d, 0x7c, 0x7c, 0x7d, 0x7c, 0x7a, 0x78, 0x75, 0x72,
			0x70, 0x70, 0x71, 0x72, 0x72, 0x72, 0x73, 0x74, 0x74, 0x75, 0x74,
			0x71, 0x6f, 0x6d, 0x6b, 0x6a, 0x6a, 0x6d, 0x71, 0x78, 0x8f, 0xad,
			0xba, 0xb2, 0x9f, 0x92, 0x89, 0x80, 0x7e, 0x85, 0x89, 0x87, 0x7e,
			0x79, 0x7f, 0x88, 0x8c, 0x8d, 0x8d, 0x8d, 0x8a, 0x84, 0x81, 0x81,
			0x7f, 0x79, 0x75, 0x78, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x7e, 0x82, 0x85, 0x82, 0x7e, 0x7c, 0x7d, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x83, 0x89, 0x8d, 0x8e, 0x8c, 0x89, 0x84,
			0x7f, 0x7c, 0x7b, 0x7d, 0x7e, 0x7f, 0x7e, 0x7d, 0x7b, 0x7b, 0x7c,
			0x7c, 0x7b, 0x7a, 0x79, 0x79, 0x79, 0x76, 0x73, 0x72, 0x73, 0x75,
			0x76, 0x76, 0x77, 0x77, 0x75, 0x72, 0x71, 0x71, 0x72, 0x71, 0x70,
			0x70, 0x71, 0x70, 0x6d, 0x6f, 0x80, 0x9e, 0xb5, 0xb4, 0xa0, 0x8d,
			0x8a, 0x8d, 0x8c, 0x87, 0x83, 0x81, 0x80, 0x7e, 0x7e, 0x86, 0x8e,
			0x8e, 0x88, 0x84, 0x88, 0x8e, 0x8c, 0x83, 0x7c, 0x7a, 0x7d, 0x7e,
			0x7c, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7f, 0x81, 0x80, 0x7c, 0x7a,
			0x7c, 0x82, 0x85, 0x81, 0x7c, 0x7a, 0x7c, 0x7f, 0x80, 0x7f, 0x81,
			0x84, 0x84, 0x82, 0x83, 0x87, 0x8a, 0x86, 0x7f, 0x7b, 0x7e, 0x80,
			0x7e, 0x79, 0x79, 0x7d, 0x81, 0x81, 0x7d, 0x78, 0x75, 0x74, 0x75,
			0x78, 0x7a, 0x7a, 0x77, 0x76, 0x77, 0x78, 0x78, 0x76, 0x76, 0x76,
			0x77, 0x78, 0x79, 0x79, 0x78, 0x78, 0x78, 0x77, 0x76, 0x74, 0x74,
			0x73, 0x71, 0x72, 0x7e, 0x93, 0xa4, 0xa5, 0x97, 0x89, 0x88, 0x91,
			0x95, 0x8e, 0x83, 0x7e, 0x82, 0x87, 0x88, 0x86, 0x86, 0x86, 0x86,
			0x85, 0x87, 0x8a, 0x8c, 0x87, 0x7f, 0x7b, 0x7d, 0x81, 0x82, 0x80,
			0x7d, 0x7b, 0x7c, 0x7e, 0x81, 0x82, 0x81, 0x7e, 0x7d, 0x7d, 0x7f,
			0x82, 0x84, 0x85, 0x83, 0x80, 0x7d, 0x7e, 0x81, 0x82, 0x80, 0x7d,
			0x7d, 0x81, 0x83, 0x81, 0x7d, 0x7c, 0x7c, 0x7c, 0x7a, 0x79, 0x79,
			0x7b, 0x7a, 0x79, 0x78, 0x79, 0x79, 0x78, 0x79, 0x7b, 0x7b, 0x79,
			0x77, 0x77, 0x79, 0x7a, 0x7a, 0x7a, 0x7b, 0x7d, 0x7c, 0x7b, 0x79,
			0x7a, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b,
			0x79, 0x78, 0x7a, 0x80, 0x89, 0x8e, 0x8d, 0x87, 0x83, 0x85, 0x8a,
			0x8c, 0x8a, 0x88, 0x88, 0x8a, 0x8a, 0x8a, 0x89, 0x89, 0x89, 0x89,
			0x89, 0x8a, 0x8c, 0x8b, 0x89, 0x86, 0x84, 0x83, 0x84, 0x85, 0x86,
			0x86, 0x84, 0x82, 0x81, 0x82, 0x83, 0x82, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7e, 0x7c, 0x7c, 0x7d, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7d, 0x7d, 0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x7a, 0x7b, 0x7b, 0x7a,
			0x79, 0x77, 0x78, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x78, 0x79,
			0x7a, 0x7a, 0x79, 0x78, 0x7a, 0x7d, 0x7d, 0x7a, 0x79, 0x7a, 0x7b,
			0x7c, 0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x7f, 0x7d, 0x7d,
			0x80, 0x83, 0x82, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x81, 0x81, 0x80, 0x81, 0x83, 0x85, 0x84, 0x84, 0x85,
			0x86, 0x85, 0x85, 0x85, 0x87, 0x88, 0x88, 0x88, 0x87, 0x87, 0x87,
			0x87, 0x87, 0x87, 0x88, 0x89, 0x89, 0x88, 0x87, 0x88, 0x89, 0x88,
			0x86, 0x86, 0x87, 0x88, 0x86, 0x84, 0x83, 0x83, 0x82, 0x81, 0x81,
			0x81, 0x81, 0x80, 0x7e, 0x7e, 0x7d, 0x7b, 0x7a, 0x7a, 0x7a, 0x7a,
			0x79, 0x79, 0x7a, 0x7a, 0x79, 0x78, 0x77, 0x79, 0x7a, 0x7a, 0x7a,
			0x79, 0x79, 0x79, 0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7b, 0x7a, 0x7a,
			0x7c, 0x7d, 0x7b, 0x7a, 0x7b, 0x7e, 0x7f, 0x7d, 0x7b, 0x7c, 0x7d,
			0x7d, 0x7c, 0x7c, 0x7e, 0x7e, 0x7c, 0x7b, 0x7d, 0x7f, 0x7e, 0x7c,
			0x7c, 0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x82, 0x83, 0x82, 0x81, 0x81,
			0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84,
			0x85, 0x85, 0x85, 0x85, 0x85, 0x84, 0x84, 0x84, 0x85, 0x84, 0x85,
			0x85, 0x85, 0x84, 0x83, 0x83, 0x83, 0x82, 0x80, 0x81, 0x82, 0x82,
			0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7c, 0x7c,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x80,
			0x82, 0x82, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81,
			0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83,
			0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
		},
		{ // 5
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x7f, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x82, 0x82, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x80,
			0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x81,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7d, 0x7f, 0x7f, 0x7e, 0x80,
			0x80, 0x7e, 0x7f, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7e, 0x7e, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x7f, 0x7e,
			0x7f, 0x7f, 0x80, 0x84, 0x83, 0x7f, 0x7e, 0x80, 0x80, 0x80, 0x7f,
			0x81, 0x80, 0x7c, 0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x82, 0x81,
			0x80, 0x81, 0x7e, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x7f, 0x7e, 0x7e,
			0x7f, 0x80, 0x7f, 0x7f, 0x7d, 0x7e, 0x81, 0x80, 0x7d, 0x80, 0x80,
			0x81, 0x7f, 0x7d, 0x80, 0x80, 0x81, 0x7f, 0x7e, 0x80, 0x7f, 0x80,
			0x7f, 0x7e, 0x82, 0x81, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x81, 0x7f,
			0x7f, 0x81, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x81, 0x81,
			0x7d, 0x81, 0x83, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x80, 0x7f, 0x7e,
			0x7e, 0x81, 0x83, 0x80, 0x7f, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x7f,
			0x82, 0x80, 0x7d, 0x81, 0x7f, 0x7d, 0x7d, 0x86, 0x80, 0x78, 0x7e,
			0x82, 0x82, 0x7f, 0x7b, 0x80, 0x84, 0x7f, 0x7d, 0x7c, 0x80, 0x80,
			0x81, 0x80, 0x7c, 0x82, 0x81, 0x80, 0x7e, 0x7d, 0x82, 0x80, 0x7d,
			0x81, 0x81, 0x81, 0x7f, 0x7c, 0x84, 0x81, 0x7b, 0x7d, 0x84, 0x85,
			0x7b, 0x7d, 0x83, 0x81, 0x7d, 0x7e, 0x80, 0x7f, 0x81, 0x80, 0x7e,
			0x7f, 0x81, 0x80, 0x7e, 0x81, 0x7e, 0x81, 0x82, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x79, 0x7a, 0x7f, 0x81, 0x81, 0x7f, 0x81, 0x80, 0x7a,
			0x7e, 0x81, 0x80, 0x80, 0x80, 0x82, 0x80, 0x80, 0x7e, 0x7d, 0x80,
			0x80, 0x7e, 0x81, 0x80, 0x7f, 0x81, 0x7f, 0x82, 0x80, 0x81, 0x81,
			0x83, 0x86, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x82, 0x83, 0x81, 0x80,
			0x84, 0x84, 0x83, 0x83, 0x84, 0x83, 0x7d, 0x7e, 0x7b, 0x79, 0x7c,
			0x7a, 0x74, 0x7b, 0x7f, 0x7c, 0x7b, 0x7c, 0x7e, 0x7a, 0x7a, 0x7a,
			0x7a, 0x78, 0x75, 0x77, 0x81, 0x86, 0x85, 0x85, 0x82, 0x7b, 0x73,
			0x71, 0x73, 0x77, 0x7a, 0x83, 0x86, 0x82, 0x84, 0x88, 0x88, 0x87,
			0x8b, 0x8b, 0x88, 0x8c, 0x90, 0x90, 0x92, 0x97, 0x95, 0x8f, 0x90,
			0x91, 0x8e, 0x8d, 0x8c, 0x85, 0x7d, 0x7a, 0x79, 0x7b, 0x7d, 0x7d,
			0x7a, 0x78, 0x72, 0x69, 0x65, 0x66, 0x68, 0x6c, 0x72, 0x6b, 0x61,
			0x5a, 0x55, 0x4e, 0x4e, 0x76, 0xae, 0xc7, 0xc3, 0xb4, 0x89, 0x59,
			0x4d, 0x58, 0x6d, 0x86, 0xa2, 0xa7, 0x95, 0x89, 0x86, 0x82, 0x81,
			0x87, 0x84, 0x7b, 0x7b, 0x82, 0x83, 0x88, 0x90, 0x90, 0x8a, 0x85,
			0x85, 0x84, 0x86, 0x8c, 0x8e, 0x88, 0x80, 0x7c, 0x79, 0x7c, 0x81,
			0x85, 0x85, 0x81, 0x78, 0x6d, 0x67, 0x68, 0x6e, 0x73, 0x73, 0x6f,
			0x67, 0x5e, 0x5a, 0x53, 0x58, 0x83, 0xb2, 0xc4, 0xbe, 0xa5, 0x74,
			0x4c, 0x4a, 0x5f, 0x7a, 0x97, 0xac, 0xa3, 0x8d, 0x82, 0x7c, 0x7a,
			0x84, 0x8d, 0x84, 0x7c, 0x7e, 0x80, 0x86, 0x94, 0x95, 0x8a, 0x83,
			0x80, 0x7e, 0x84, 0x8d, 0x8f, 0x8b, 0x85, 0x7b, 0x76, 0x7a, 0x81,
			0x87, 0x86, 0x81, 0x7c, 0x77, 0x70, 0x69, 0x6a, 0x6f, 0x72, 0x73,
			0x6d, 0x69, 0x62, 0x5f, 0x5d, 0x5b, 0x80, 0xb1, 0xc6, 0xc0, 0xa2,
			0x6f, 0x45, 0x45, 0x5f, 0x7f, 0x9f, 0xb0, 0x9f, 0x87, 0x7b, 0x78,
			0x7d, 0x8b, 0x92, 0x87, 0x7b, 0x7a, 0x7f, 0x88, 0x94, 0x95, 0x88,
			0x7c, 0x78, 0x7d, 0x89, 0x92, 0x91, 0x8e, 0x86, 0x7c, 0x75, 0x77,
			0x7c, 0x80, 0x86, 0x86, 0x81, 0x7e, 0x77, 0x6b, 0x66, 0x6d, 0x75,
			0x77, 0x77, 0x70, 0x68, 0x60, 0x5e, 0x56, 0x5b, 0x8b, 0xb7, 0xc4,
			0xb9, 0x98, 0x65, 0x46, 0x4f, 0x69, 0x89, 0xa5, 0xaa, 0x96, 0x84,
			0x7c, 0x79, 0x82, 0x8d, 0x8b, 0x80, 0x7a, 0x7b, 0x80, 0x8d, 0x9a,
			0x97, 0x88, 0x7a, 0x73, 0x78, 0x89, 0x94, 0x92, 0x8d, 0x84, 0x77,
			0x70, 0x78, 0x80, 0x83, 0x89, 0x8a, 0x82, 0x7b, 0x75, 0x6a, 0x64,
			0x6c, 0x70, 0x70, 0x73, 0x70, 0x6a, 0x66, 0x66, 0x5d, 0x69, 0x98,
			0xb8, 0xbb, 0xaa, 0x85, 0x57, 0x48, 0x5c, 0x7a, 0x99, 0xaa, 0xa2,
			0x89, 0x78, 0x74, 0x7c, 0x8a, 0x90, 0x8a, 0x81, 0x7c, 0x7d, 0x85,
			0x8e, 0x8e, 0x87, 0x7f, 0x7c, 0x80, 0x8b, 0x92, 0x91, 0x8a, 0x80,
			0x78, 0x77, 0x7d, 0x84, 0x87, 0x85, 0x81, 0x7b, 0x77, 0x72, 0x6d,
			0x6e, 0x72, 0x74, 0x71, 0x6c, 0x67, 0x64, 0x61, 0x65, 0x66, 0x61,
			0x82, 0xaf, 0xbd, 0xb3, 0x98, 0x69, 0x49, 0x54, 0x70, 0x8b, 0xa2,
			0xa8, 0x93, 0x81, 0x7c, 0x7a, 0x82, 0x8c, 0x8a, 0x7e, 0x78, 0x7c,
			0x85, 0x91, 0x9b, 0x93, 0x7e, 0x74, 0x76, 0x7a, 0x89, 0x97, 0x98,
			0x90, 0x85, 0x78, 0x72, 0x78, 0x80, 0x88, 0x8d, 0x88, 0x7f, 0x78,
			0x72, 0x6b, 0x67, 0x6c, 0x72, 0x72, 0x71, 0x6c, 0x65, 0x62, 0x62,
			0x60, 0x60, 0x62, 0x7b, 0xa7, 0xbc, 0xb4, 0x98, 0x70, 0x54, 0x59,
			0x71, 0x8c, 0x9f, 0xa2, 0x95, 0x84, 0x7c, 0x7b, 0x7f, 0x87, 0x88,
			0x7f, 0x7d, 0x81, 0x86, 0x8b, 0x8e, 0x89, 0x81, 0x7f, 0x82, 0x85,
			0x8a, 0x8e, 0x8a, 0x83, 0x80, 0x7f, 0x7f, 0x81, 0x87, 0x88, 0x87,
			0x86, 0x7f, 0x73, 0x6b, 0x6b, 0x6d, 0x72, 0x76, 0x73, 0x6c, 0x6a,
			0x6a, 0x68, 0x67, 0x66, 0x63, 0x61, 0x52, 0x5b, 0x92, 0xba, 0xc4,
			0xb3, 0x87, 0x52, 0x45, 0x5f, 0x80, 0x9f, 0xaf, 0xa1, 0x86, 0x7b,
			0x7c, 0x83, 0x8c, 0x8b, 0x84, 0x7b, 0x78, 0x81, 0x8b, 0x8e, 0x8c,
			0x86, 0x7e, 0x7e, 0x83, 0x86, 0x8a, 0x8a, 0x88, 0x85, 0x84, 0x81,
			0x7c, 0x7b, 0x7f, 0x84, 0x88, 0x89, 0x87, 0x81, 0x79, 0x72, 0x6c,
			0x6c, 0x70, 0x70, 0x6e, 0x6d, 0x6e, 0x6c, 0x67, 0x68, 0x65, 0x62,
			0x60, 0x59, 0x68, 0x88, 0xa9, 0xb6, 0xa7, 0x86, 0x61, 0x56, 0x65,
			0x81, 0x99, 0xa5, 0x99, 0x88, 0x7e, 0x7c, 0x84, 0x8c, 0x8b, 0x86,
			0x82, 0x80, 0x86, 0x89, 0x89, 0x86, 0x82, 0x82, 0x81, 0x80, 0x82,
			0x7f, 0x7b, 0x79, 0x7c, 0x84, 0x90, 0x95, 0x8f, 0x85, 0x7a, 0x76,
			0x7d, 0x86, 0x88, 0x84, 0x7f, 0x77, 0x72, 0x77, 0x7c, 0x7b, 0x7b,
			0x77, 0x6d, 0x65, 0x63, 0x64, 0x61, 0x61, 0x63, 0x65, 0x62, 0x60,
			0x5f, 0x5d, 0x85, 0xb5, 0xc1, 0xb4, 0x8f, 0x5a, 0x44, 0x5a, 0x7c,
			0x9f, 0xaf, 0xa0, 0x84, 0x76, 0x7b, 0x87, 0x91, 0x8f, 0x81, 0x75,
			0x79, 0x84, 0x8e, 0x92, 0x8d, 0x7f, 0x74, 0x73, 0x7a, 0x85, 0x88,
			0x84, 0x7d, 0x79, 0x7a, 0x7f, 0x87, 0x92, 0x98, 0x95, 0x86, 0x77,
			0x71, 0x76, 0x80, 0x89, 0x8c, 0x88, 0x7f, 0x77, 0x73, 0x72, 0x75,
			0x79, 0x76, 0x6f, 0x6a, 0x6c, 0x6e, 0x70, 0x70, 0x69, 0x69, 0x69,
			0x66, 0x63, 0x61, 0x57, 0x5a, 0x8f, 0xc3, 0xce, 0xb6, 0x89, 0x58,
			0x45, 0x61, 0x87, 0xa2, 0xac, 0xa0, 0x87, 0x7a, 0x7e, 0x83, 0x89,
			0x8a, 0x83, 0x7c, 0x7e, 0x85, 0x89, 0x88, 0x82, 0x79, 0x78, 0x80,
			0x88, 0x8a, 0x83, 0x78, 0x6f, 0x70, 0x79, 0x81, 0x85, 0x86, 0x85,
			0x83, 0x81, 0x7d, 0x7a, 0x7c, 0x82, 0x8a, 0x90, 0x94, 0x91, 0x85,
			0x79, 0x72, 0x73, 0x7e, 0x89, 0x8c, 0x85, 0x7b, 0x75, 0x72, 0x74,
			0x77, 0x77, 0x75, 0x71, 0x6e, 0x6f, 0x71, 0x74, 0x75, 0x74, 0x71,
			0x71, 0x72, 0x71, 0x6d, 0x66, 0x60, 0x5f, 0x79, 0xa9, 0xc5, 0xba,
			0x96, 0x6c, 0x52, 0x59, 0x78, 0x96, 0xa4, 0xa5, 0x96, 0x85, 0x7f,
			0x7e, 0x7c, 0x7a, 0x7c, 0x7e, 0x83, 0x8c, 0x8e, 0x89, 0x82, 0x7c,
			0x7c, 0x7e, 0x80, 0x80, 0x7e, 0x7c, 0x7c, 0x7d, 0x7e, 0x7d, 0x7c,
			0x81, 0x85, 0x85, 0x83, 0x80, 0x7d, 0x7c, 0x7d, 0x7e, 0x7e, 0x82,
			0x86, 0x8c, 0x96, 0x96, 0x87, 0x77, 0x71, 0x73, 0x7a, 0x83, 0x88,
			0x88, 0x83, 0x7b, 0x73, 0x71, 0x75, 0x7a, 0x7d, 0x7b, 0x75, 0x72,
			0x74, 0x77, 0x78, 0x74, 0x71, 0x6f, 0x71, 0x74, 0x73, 0x6f, 0x6f,
			0x73, 0x74, 0x71, 0x6c, 0x65, 0x6a, 0x86, 0xaa, 0xbd, 0xb0, 0x8e,
			0x6b, 0x5e, 0x68, 0x7d, 0x90, 0x9a, 0x9b, 0x96, 0x91, 0x89, 0x7e,
			0x74, 0x70, 0x75, 0x82, 0x8f, 0x92, 0x8e, 0x88, 0x7f, 0x7a, 0x7b,
			0x7e, 0x7f, 0x80, 0x81, 0x7f, 0x7b, 0x7a, 0x7a, 0x7c, 0x80, 0x81,
			0x81, 0x84, 0x86, 0x83, 0x7f, 0x7c, 0x7c, 0x7e, 0x82, 0x84, 0x83,
			0x8a, 0x94, 0x93, 0x85, 0x76, 0x71, 0x75, 0x80, 0x8a, 0x8b, 0x85,
			0x80, 0x7b, 0x76, 0x74, 0x77, 0x7a, 0x7c, 0x7d, 0x79, 0x75, 0x72,
			0x73, 0x75, 0x76, 0x75, 0x75, 0x74, 0x73, 0x74, 0x74, 0x71, 0x70,
			0x72, 0x73, 0x73, 0x71, 0x70, 0x70, 0x6f, 0x77, 0x8a, 0x9c, 0xa7,
			0xa8, 0x98, 0x80, 0x70, 0x6c, 0x73, 0x82, 0x94, 0x9e, 0x9e, 0x96,
			0x89, 0x7e, 0x79, 0x78, 0x78, 0x7d, 0x84, 0x8a, 0x8f, 0x90, 0x8c,
			0x84, 0x7c, 0x74, 0x72, 0x76, 0x7c, 0x83, 0x87, 0x85, 0x80, 0x7c,
			0x7c, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x82,
			0x86, 0x89, 0x8a, 0x8a, 0x89, 0x85, 0x7f, 0x7b, 0x7b, 0x7c, 0x7e,
			0x80, 0x83, 0x84, 0x82, 0x7e, 0x78, 0x75, 0x74, 0x72, 0x73, 0x75,
			0x79, 0x7e, 0x7f, 0x7b, 0x75, 0x70, 0x6f, 0x70, 0x72, 0x74, 0x74,
			0x75, 0x76, 0x76, 0x73, 0x71, 0x74, 0x75, 0x73, 0x6e, 0x6d, 0x6c,
			0x72, 0x85, 0x9b, 0xac, 0xaa, 0x9e, 0x8e, 0x80, 0x77, 0x73, 0x78,
			0x83, 0x94, 0x9d, 0x9b, 0x93, 0x8d, 0x86, 0x7e, 0x76, 0x72, 0x77,
			0x81, 0x8a, 0x8d, 0x8d, 0x8c, 0x87, 0x80, 0x79, 0x76, 0x76, 0x79,
			0x7d, 0x7f, 0x80, 0x82, 0x82, 0x7f, 0x7c, 0x7d, 0x80, 0x7f, 0x7c,
			0x80, 0x82, 0x84, 0x87, 0x88, 0x83, 0x82, 0x85, 0x87, 0x83, 0x80,
			0x7e, 0x7e, 0x7e, 0x81, 0x81, 0x7e, 0x7e, 0x7e, 0x7c, 0x7a, 0x79,
			0x78, 0x76, 0x78, 0x77, 0x76, 0x77, 0x78, 0x78, 0x77, 0x76, 0x75,
			0x73, 0x72, 0x71, 0x6f, 0x6f, 0x70, 0x6f, 0x71, 0x75, 0x76, 0x72,
			0x6f, 0x71, 0x72, 0x70, 0x6e, 0x6f, 0x7a, 0x8d, 0xa1, 0xae, 0xa9,
			0x9c, 0x93, 0x8a, 0x7c, 0x71, 0x75, 0x81, 0x8c, 0x92, 0x96, 0x99,
			0x98, 0x90, 0x84, 0x7b, 0x76, 0x76, 0x78, 0x7d, 0x84, 0x89, 0x8b,
			0x8a, 0x87, 0x83, 0x7f, 0x7b, 0x76, 0x75, 0x76, 0x77, 0x79, 0x7e,
			0x83, 0x86, 0x85, 0x85, 0x84, 0x81, 0x7d, 0x7a, 0x7b, 0x7d, 0x7f,
			0x83, 0x85, 0x88, 0x8b, 0x87, 0x83, 0x84, 0x84, 0x81, 0x7e, 0x7c,
			0x7c, 0x7e, 0x7e, 0x7b, 0x7c, 0x7c, 0x79, 0x76, 0x75, 0x76, 0x78,
			0x77, 0x74, 0x76, 0x78, 0x75, 0x72, 0x72, 0x74, 0x70, 0x6e, 0x71,
			0x72, 0x74, 0x74, 0x72, 0x71, 0x74, 0x75, 0x72, 0x75, 0x78, 0x74,
			0x78, 0x7f, 0x81, 0x85, 0x8b, 0x98, 0xa6, 0xa8, 0x9b, 0x93, 0x91,
			0x8b, 0x82, 0x7d, 0x80, 0x88, 0x8c, 0x8e, 0x8e, 0x8f, 0x90, 0x8e,
			0x89, 0x83, 0x81, 0x7f, 0x7c, 0x7b, 0x7c, 0x7d, 0x7e, 0x81, 0x82,
			0x80, 0x7f, 0x7e, 0x7e, 0x7b, 0x7b, 0x7b, 0x7b, 0x7d, 0x7e, 0x80,
			0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x7d, 0x7e, 0x81, 0x85, 0x8d, 0x87,
			0x83, 0x88, 0x8b, 0x82, 0x78, 0x7d, 0x7e, 0x80, 0x7f, 0x7a, 0x7b,
			0x7e, 0x81, 0x79, 0x77, 0x79, 0x77, 0x75, 0x75, 0x77, 0x77, 0x7a,
			0x78, 0x73, 0x73, 0x74, 0x73, 0x70, 0x70, 0x70, 0x72, 0x75, 0x75,
			0x73, 0x72, 0x75, 0x73, 0x6e, 0x6d, 0x70, 0x74, 0x75, 0x75, 0x76,
			0x77, 0x7e, 0x8a, 0x9c, 0xa4, 0x9b, 0x99, 0xa0, 0xa5, 0x9b, 0x8e,
			0x8b, 0x8d, 0x90, 0x8b, 0x84, 0x81, 0x86, 0x8e, 0x8a, 0x83, 0x82,
			0x87, 0x8b, 0x88, 0x85, 0x83, 0x86, 0x87, 0x84, 0x80, 0x7c, 0x7f,
			0x7f, 0x7b, 0x78, 0x78, 0x7b, 0x7c, 0x7d, 0x7e, 0x7e, 0x80, 0x82,
			0x83, 0x82, 0x81, 0x82, 0x82, 0x83, 0x83, 0x82, 0x80, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7f, 0x81, 0x82, 0x82, 0x82, 0x80, 0x7f, 0x7d, 0x7c,
			0x7b, 0x79, 0x78, 0x78, 0x78, 0x78, 0x77, 0x78, 0x79, 0x78, 0x79,
			0x7b, 0x7c, 0x7b, 0x7b, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7b, 0x7b,
			0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7a, 0x7a, 0x7b, 0x7d, 0x7d,
			0x7b, 0x7c, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x82, 0x83,
			0x82, 0x82, 0x82, 0x83, 0x84, 0x86, 0x88, 0x89, 0x89, 0x89, 0x89,
			0x89, 0x88, 0x87, 0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x80, 0x80,
			0x7f, 0x7e, 0x7c, 0x7c, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d,
			0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x7e, 0x7e, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d,
			0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7c, 0x7c, 0x7b, 0x7a,
			0x7a, 0x7b, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7b,
			0x7c, 0x7c, 0x7c, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x81, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x89, 0x88,
			0x88, 0x88, 0x88, 0x88, 0x87, 0x88, 0x88, 0x87, 0x86, 0x85, 0x85,
			0x84, 0x84, 0x84, 0x84, 0x84, 0x82, 0x82, 0x82, 0x82, 0x80, 0x81,
			0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7f, 0x7d,
			0x7c, 0x7d, 0x7b, 0x7c, 0x7c, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
			0x7c, 0x7b, 0x7b, 0x7d, 0x7c, 0x79, 0x7d, 0x7d, 0x7a, 0x7a, 0x7a,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x81, 0x7e, 0x7d, 0x7d, 0x7f, 0x80,
			0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x81,
			0x81, 0x82, 0x81, 0x82, 0x81, 0x80, 0x82, 0x82, 0x82, 0x81, 0x81,
			0x82, 0x82, 0x81, 0x81, 0x81, 0x83, 0x82, 0x80, 0x82, 0x82, 0x82,
			0x81, 0x81, 0x81, 0x82, 0x83, 0x82, 0x81, 0x82, 0x80, 0x82, 0x83,
			0x80, 0x80, 0x82, 0x81, 0x80, 0x81, 0x81, 0x82, 0x81, 0x80, 0x82,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7d, 0x80, 0x7e, 0x7b,
			0x7d, 0x7f, 0x7e, 0x7e, 0x7c, 0x7d, 0x80, 0x7e, 0x7e, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7d, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x81,
			0x82, 0x7f, 0x7f, 0x81, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81,
			0x7f, 0x7e, 0x81, 0x80, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x7e, 0x7e,
			0x80, 0x82, 0x80, 0x7f, 0x7f, 0x81, 0x80, 0x7f, 0x81, 0x7e, 0x7e,
			0x81, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x82, 0x7f, 0x7e, 0x82, 0x7f,
			0x7e, 0x7f, 0x7e, 0x81, 0x80, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e,
			0x80, 0x82, 0x7f, 0x7e, 0x80, 0x7f, 0x81, 0x7f, 0x7d, 0x80, 0x83,
			0x83, 0x7c, 0x81, 0x82, 0x7e, 0x82, 0x7d, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x82, 0x7f, 0x81, 0x7e, 0x80, 0x81, 0x7c, 0x80, 0x81, 0x7f,
			0x80, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x81,
			0x81, 0x7e, 0x7c, 0x81, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x81, 0x7f,
			0x7d, 0x80, 0x80, 0x7f, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x81,
			0x7e, 0x7f, 0x80, 0x7e, 0x7f, 0x7f, 0x7d, 0x7e, 0x7e, 0x7d, 0x80,
			0x80, 0x81, 0x82, 0x80, 0x7f, 0x81, 0x81, 0x7e, 0x81, 0x81, 0x7e,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x80,
			0x7f, 0x81, 0x81, 0x7e, 0x7f, 0x81, 0x7f, 0x7f, 0x7e, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x7f, 0x7e, 0x7f, 0x80, 0x7f,
			0x7d, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x81,
			0x81, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x80,
			0x7d, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x81,
			0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7d, 0x7e, 0x81,
			0x7f, 0x7e, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x82, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x81, 0x7f, 0x81,
			0x81, 0x7f, 0x80, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x80,
			0x81, 0x80, 0x7e, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x81,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x81, 0x80, 0x7f, 0x81, 0x81,
			0x7f, 0x7f, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x7e,
			0x7e, 0x80, 0x81, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80,
		},
		{ // 6
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x80,
			0x7f, 0x80, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x7f,
			0x81, 0x7e, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x80,
			0x80, 0x7e, 0x82, 0x7e, 0x81, 0x7f, 0x81, 0x7f, 0x81, 0x7e, 0x80,
			0x7f, 0x7f, 0x80, 0x7e, 0x83, 0x7f, 0x83, 0x7c, 0x81, 0x7e, 0x81,
			0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7c, 0x84, 0x7b, 0x83, 0x7c, 0x82,
			0x80, 0x80, 0x80, 0x7e, 0x81, 0x7d, 0x81, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x81, 0x7e, 0x81, 0x7d, 0x81, 0x7d, 0x81, 0x7d, 0x82, 0x7e,
			0x80, 0x81, 0x7f, 0x80, 0x7f, 0x81, 0x7d, 0x81, 0x7d, 0x82, 0x7f,
			0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x7f, 0x7f,
			0x80, 0x7f, 0x7e, 0x81, 0x7f, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x81,
			0x80, 0x7f, 0x82, 0x7e, 0x83, 0x7e, 0x80, 0x7e, 0x82, 0x80, 0x7f,
			0x7e, 0x7f, 0x81, 0x7e, 0x81, 0x7d, 0x82, 0x7c, 0x82, 0x7d, 0x80,
			0x83, 0x7c, 0x82, 0x7d, 0x84, 0x80, 0x7f, 0x81, 0x7e, 0x81, 0x7d,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7d, 0x80, 0x7e,
			0x85, 0x7e, 0x81, 0x7f, 0x7d, 0x83, 0x7b, 0x83, 0x7d, 0x80, 0x7f,
			0x7e, 0x81, 0x7e, 0x83, 0x7d, 0x82, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7e, 0x81, 0x7c, 0x83, 0x7e, 0x80, 0x81, 0x7f, 0x81, 0x7e, 0x82,
			0x7c, 0x82, 0x7f, 0x7d, 0x83, 0x7d, 0x82, 0x7e, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x81, 0x7f, 0x82, 0x7e, 0x80,
			0x81, 0x7e, 0x82, 0x7e, 0x7f, 0x81, 0x7e, 0x7f, 0x7f, 0x80, 0x82,
			0x7e, 0x7f, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x80, 0x80, 0x80, 0x7e,
			0x7f, 0x81, 0x81, 0x7f, 0x80, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x80,
			0x81, 0x7e, 0x81, 0x7d, 0x81, 0x7e, 0x80, 0x81, 0x7d, 0x84, 0x7e,
			0x80, 0x7f, 0x7e, 0x82, 0x7e, 0x81, 0x7f, 0x7e, 0x81, 0x81, 0x7c,
			0x80, 0x81, 0x7f, 0x82, 0x7d, 0x81, 0x7f, 0x81, 0x7f, 0x7e, 0x81,
			0x7f, 0x80, 0x7d, 0x81, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x80, 0x81,
			0x80, 0x7f, 0x80, 0x81, 0x7d, 0x7f, 0x80, 0x7e, 0x81, 0x7e, 0x80,
			0x80, 0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x81, 0x7f, 0x81,
			0x7e, 0x80, 0x7e, 0x7d, 0x82, 0x7d, 0x82, 0x7f, 0x7d, 0x83, 0x7f,
			0x7d, 0x82, 0x7e, 0x81, 0x81, 0x7b, 0x82, 0x80, 0x7e, 0x81, 0x7c,
			0x82, 0x82, 0x7c, 0x80, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x81,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x82, 0x80, 0x80,
			0x7e, 0x80, 0x80, 0x7d, 0x82, 0x7e, 0x81, 0x82, 0x7c, 0x81, 0x7e,
			0x80, 0x81, 0x7d, 0x83, 0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f,
			0x7f, 0x82, 0x7d, 0x80, 0x7f, 0x7d, 0x82, 0x7e, 0x7f, 0x81, 0x7e,
			0x83, 0x7c, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x80, 0x7e, 0x82, 0x7d,
			0x81, 0x7f, 0x81, 0x80, 0x7b, 0x81, 0x7e, 0x83, 0x7d, 0x7e, 0x80,
			0x7f, 0x81, 0x7c, 0x7d, 0x82, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x80,
			0x82, 0x7c, 0x82, 0x80, 0x7c, 0x82, 0x7d, 0x7f, 0x7e, 0x82, 0x80,
			0x7b, 0x84, 0x82, 0x82, 0x84, 0x7d, 0x7e, 0x85, 0x7f, 0x7f, 0x7c,
			0x80, 0x82, 0x7a, 0x84, 0x7a, 0x82, 0x84, 0x7c, 0x82, 0x7c, 0x85,
			0x7f, 0x83, 0x80, 0x7f, 0x85, 0x81, 0x82, 0x7c, 0x82, 0x80, 0x80,
			0x80, 0x7c, 0x84, 0x7f, 0x80, 0x81, 0x7d, 0x81, 0x80, 0x7e, 0x7f,
			0x7e, 0x7e, 0x7c, 0x7b, 0x7a, 0x76, 0x79, 0x75, 0x74, 0x75, 0x6f,
			0x70, 0x6e, 0x6a, 0x68, 0x68, 0x70, 0x79, 0x81, 0x82, 0x8d, 0x95,
			0x99, 0xa0, 0x9e, 0x9d, 0xa1, 0xa0, 0x99, 0x92, 0x8a, 0x84, 0x80,
			0x75, 0x6e, 0x6f, 0x71, 0x72, 0x74, 0x7a, 0x86, 0x92, 0x9c, 0xa1,
			0xa9, 0xaf, 0xac, 0xa5, 0x9c, 0x96, 0x89, 0x7d, 0x70, 0x65, 0x62,
			0x5b, 0x55, 0x52, 0x55, 0x58, 0x5a, 0x5b, 0x5c, 0x60, 0x5d, 0x59,
			0x54, 0x52, 0x4d, 0x4d, 0x51, 0x56, 0x7c, 0x92, 0x8c, 0x98, 0xae,
			0xb5, 0xb3, 0xb2, 0xaa, 0xaa, 0xab, 0x97, 0x85, 0x81, 0x77, 0x6e,
			0x6b, 0x66, 0x69, 0x75, 0x7d, 0x80, 0x8d, 0x99, 0x9d, 0xa2, 0xa3,
			0x9f, 0x9b, 0x94, 0x89, 0x82, 0x7a, 0x71, 0x6e, 0x6f, 0x70, 0x76,
			0x7e, 0x84, 0x8b, 0x8e, 0x8d, 0x8b, 0x87, 0x7f, 0x79, 0x71, 0x68,
			0x62, 0x5e, 0x5b, 0x57, 0x57, 0x57, 0x55, 0x53, 0x4f, 0x57, 0x89,
			0xa0, 0x8a, 0x93, 0xb1, 0xb7, 0xaf, 0xa3, 0x95, 0x9e, 0x9f, 0x81,
			0x6e, 0x75, 0x75, 0x70, 0x6d, 0x66, 0x74, 0x89, 0x87, 0x82, 0x96,
			0xa4, 0x9f, 0x9b, 0x96, 0x94, 0x94, 0x88, 0x75, 0x71, 0x74, 0x6e,
			0x6b, 0x6c, 0x71, 0x7b, 0x82, 0x84, 0x8b, 0x91, 0x91, 0x8f, 0x86,
			0x80, 0x7b, 0x73, 0x71, 0x6f, 0x6b, 0x73, 0x77, 0x71, 0x75, 0x71,
			0x6e, 0x6d, 0x61, 0x55, 0x54, 0x4b, 0x41, 0x76, 0x9c, 0x85, 0x8f,
			0xb2, 0xbc, 0xb9, 0xb2, 0x9f, 0xa0, 0xa4, 0x84, 0x68, 0x6b, 0x69,
			0x5f, 0x60, 0x63, 0x71, 0x8c, 0x96, 0x8d, 0x9a, 0xad, 0xa5, 0x9a,
			0x91, 0x8a, 0x84, 0x77, 0x64, 0x60, 0x6b, 0x6b, 0x66, 0x71, 0x80,
			0x88, 0x92, 0x96, 0x97, 0x9d, 0x99, 0x8a, 0x7f, 0x7d, 0x7b, 0x73,
			0x71, 0x72, 0x73, 0x78, 0x7d, 0x7b, 0x7e, 0x87, 0x86, 0x80, 0x7c,
			0x75, 0x71, 0x70, 0x65, 0x5e, 0x61, 0x62, 0x5c, 0x5a, 0x58, 0x5e,
			0x92, 0xab, 0x91, 0x92, 0xb2, 0xb6, 0xa1, 0x98, 0x87, 0x86, 0x8d,
			0x6f, 0x5c, 0x74, 0x80, 0x76, 0x7a, 0x88, 0x93, 0x9d, 0x97, 0x8b,
			0x96, 0x9a, 0x87, 0x79, 0x7b, 0x7c, 0x76, 0x6d, 0x6b, 0x78, 0x81,
			0x7a, 0x78, 0x80, 0x85, 0x86, 0x81, 0x7e, 0x84, 0x8b, 0x86, 0x83,
			0x88, 0x88, 0x84, 0x82, 0x81, 0x80, 0x82, 0x81, 0x7b, 0x7c, 0x7f,
			0x7c, 0x79, 0x78, 0x78, 0x78, 0x77, 0x75, 0x75, 0x78, 0x75, 0x6f,
			0x71, 0x71, 0x6b, 0x6b, 0x6b, 0x68, 0x67, 0x67, 0x6b, 0x92, 0xb0,
			0x9d, 0x94, 0xae, 0xb2, 0x97, 0x8b, 0x7d, 0x78, 0x83, 0x73, 0x61,
			0x73, 0x85, 0x81, 0x7e, 0x89, 0x93, 0x9c, 0x98, 0x86, 0x86, 0x8f,
			0x84, 0x72, 0x75, 0x7d, 0x78, 0x76, 0x76, 0x7d, 0x86, 0x83, 0x7b,
			0x81, 0x8a, 0x85, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7a, 0x7f, 0x83,
			0x81, 0x81, 0x88, 0x8a, 0x85, 0x83, 0x84, 0x85, 0x83, 0x7f, 0x7d,
			0x7d, 0x7c, 0x7a, 0x7a, 0x7a, 0x79, 0x78, 0x79, 0x79, 0x78, 0x78,
			0x78, 0x76, 0x75, 0x75, 0x76, 0x75, 0x76, 0x76, 0x70, 0x71, 0x75,
			0x6e, 0x6b, 0x6c, 0x6d, 0x64, 0x77, 0xab, 0xa7, 0x8b, 0x97, 0xba,
			0xa7, 0x84, 0x89, 0x90, 0x88, 0x7a, 0x7c, 0x78, 0x7f, 0x88, 0x81,
			0x7e, 0x8c, 0x95, 0x8b, 0x83, 0x86, 0x8f, 0x88, 0x7e, 0x7c, 0x83,
			0x82, 0x78, 0x75, 0x7a, 0x82, 0x7c, 0x74, 0x77, 0x7f, 0x7f, 0x7b,
			0x7f, 0x84, 0x84, 0x7f, 0x7d, 0x80, 0x81, 0x81, 0x81, 0x82, 0x84,
			0x87, 0x86, 0x84, 0x83, 0x83, 0x81, 0x7d, 0x7e, 0x7f, 0x7e, 0x7c,
			0x7b, 0x7a, 0x7b, 0x7b, 0x7a, 0x79, 0x79, 0x79, 0x78, 0x78, 0x78,
			0x77, 0x78, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x78, 0x78, 0x77,
			0x75, 0x77, 0x76, 0x73, 0x6f, 0x75, 0x81, 0x7d, 0x77, 0x87, 0x9b,
			0x93, 0x88, 0x92, 0x9e, 0x93, 0x85, 0x8c, 0x92, 0x87, 0x7e, 0x82,
			0x85, 0x81, 0x7e, 0x81, 0x83, 0x85, 0x87, 0x86, 0x85, 0x86, 0x89,
			0x83, 0x7f, 0x81, 0x83, 0x7c, 0x78, 0x7b, 0x7c, 0x78, 0x76, 0x7a,
			0x7d, 0x7e, 0x7e, 0x7f, 0x82, 0x83, 0x81, 0x7e, 0x7e, 0x7e, 0x7d,
			0x7b, 0x7c, 0x7e, 0x7c, 0x7b, 0x7c, 0x7e, 0x7e, 0x7e, 0x7f, 0x80,
			0x7f, 0x7f, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d,
			0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
			0x7f, 0x80, 0x80, 0x81, 0x82, 0x82, 0x81, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x80, 0x81, 0x82, 0x82, 0x7f, 0x83, 0x85, 0x82, 0x7c,
			0x7a, 0x7d, 0x80, 0x7e, 0x7c, 0x7c, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x81, 0x80, 0x7d, 0x7e,
			0x81, 0x82, 0x7f, 0x7b, 0x7e, 0x80, 0x82, 0x7f, 0x7d, 0x7f, 0x82,
			0x84, 0x81, 0x81, 0x7d, 0x82, 0x83, 0x7f, 0x81, 0x80, 0x84, 0x83,
			0x82, 0x83, 0x81, 0x81, 0x80, 0x7e, 0x7d, 0x7e, 0x80, 0x81, 0x7e,
			0x7b, 0x7d, 0x83, 0x80, 0x7f, 0x7d, 0x81, 0x83, 0x80, 0x80, 0x7e,
			0x7d, 0x82, 0x81, 0x7d, 0x7c, 0x80, 0x83, 0x7f, 0x7f, 0x7a, 0x81,
			0x81, 0x82, 0x7f, 0x7c, 0x80, 0x81, 0x85, 0x7b, 0x7d, 0x81, 0x82,
			0x80, 0x7c, 0x7e, 0x80, 0x86, 0x80, 0x7d, 0x7c, 0x82, 0x88, 0x7c,
			0x7c, 0x7d, 0x82, 0x83, 0x7e, 0x7c, 0x7e, 0x80, 0x83, 0x80, 0x7a,
			0x7f, 0x81, 0x85, 0x7f, 0x7b, 0x7e, 0x7f, 0x82, 0x81, 0x7b, 0x7e,
			0x82, 0x81, 0x81, 0x79, 0x81, 0x81, 0x83, 0x7f, 0x7d, 0x80, 0x80,
			0x84, 0x78, 0x7f, 0x7e, 0x83, 0x7e, 0x7c, 0x7f, 0x81, 0x85, 0x7c,
			0x7c, 0x7e, 0x85, 0x81, 0x7f, 0x7a, 0x85, 0x82, 0x80, 0x7f, 0x77,
			0x81, 0x81, 0x81, 0x7d, 0x7c, 0x81, 0x83, 0x81, 0x7a, 0x81, 0x82,
			0x83, 0x7d, 0x7c, 0x82, 0x80, 0x81, 0x7a, 0x80, 0x80, 0x80, 0x7e,
			0x7c, 0x82, 0x7f, 0x82, 0x7c, 0x7f, 0x81, 0x81, 0x80, 0x7b, 0x81,
			0x81, 0x81, 0x7d, 0x80, 0x7e, 0x82, 0x80, 0x7c, 0x80, 0x7d, 0x84,
			0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x7d, 0x82, 0x7e, 0x82,
			0x7d, 0x7e, 0x82, 0x7f, 0x80, 0x7d, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x83, 0x80, 0x80, 0x7e, 0x7f, 0x82, 0x7e, 0x80, 0x7f, 0x80,
			0x81, 0x7e, 0x7e, 0x7f, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x7e, 0x83,
			0x7f, 0x7e, 0x7e, 0x7e, 0x84, 0x7b, 0x7f, 0x80, 0x7e, 0x83, 0x7e,
			0x80, 0x7e, 0x83, 0x81, 0x7e, 0x7f, 0x7e, 0x84, 0x7e, 0x7d, 0x80,
			0x7f, 0x81, 0x7e, 0x7e, 0x7f, 0x82, 0x81, 0x7f, 0x7f, 0x7f, 0x82,
			0x7e, 0x80, 0x7e, 0x80, 0x81, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x81,
			0x7d, 0x81, 0x7e, 0x83, 0x7f, 0x7f, 0x81, 0x7c, 0x82, 0x7e, 0x81,
			0x7d, 0x81, 0x81, 0x80, 0x7f, 0x7d, 0x82, 0x7e, 0x81, 0x7e, 0x7f,
			0x82, 0x7e, 0x81, 0x7d, 0x80, 0x81, 0x7e, 0x82, 0x7f, 0x7f, 0x7f,
			0x81, 0x80, 0x7e, 0x81, 0x7f, 0x7e, 0x80, 0x82, 0x7e, 0x7d, 0x80,
			0x82, 0x7d, 0x7c, 0x82, 0x7f, 0x81, 0x7e, 0x80, 0x81, 0x7c, 0x80,
			0x7f, 0x80, 0x80, 0x7d, 0x83, 0x7f, 0x80, 0x7f, 0x7d, 0x82, 0x7d,
			0x81, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x80,
			0x81, 0x80, 0x7d, 0x7f, 0x82, 0x7e, 0x7d, 0x81, 0x80, 0x81, 0x7e,
			0x80, 0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x82, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7e, 0x7e, 0x82, 0x7e, 0x80, 0x7e, 0x80, 0x81, 0x7f,
			0x80, 0x7d, 0x80, 0x81, 0x7f, 0x7f, 0x7f, 0x81, 0x81, 0x7e, 0x80,
			0x7d, 0x82, 0x7f, 0x7f, 0x7f, 0x7e, 0x81, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7d, 0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x7f, 0x7e, 0x81,
			0x7d, 0x82, 0x7e, 0x7e, 0x81, 0x7e, 0x83, 0x7c, 0x81, 0x7f, 0x80,
			0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x81, 0x7e, 0x82,
			0x7d, 0x80, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7e,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x81, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x7e, 0x81, 0x7e,
			0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x81, 0x7f, 0x80, 0x7f,
			0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x81, 0x7f, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x81, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x81,
			0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7e,
			0x80, 0x81, 0x80, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f,
			0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81,
			0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
		},
		{ // 7
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x80,
			0x7f, 0x80, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x7f,
			0x81, 0x7e, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x80,
			0x80, 0x7e, 0x82, 0x7e, 0x81, 0x7f, 0x81, 0x7f, 0x81, 0x7e, 0x80,
			0x7f, 0x7f, 0x80, 0x7e, 0x83, 0x7f, 0x83, 0x7c, 0x81, 0x7e, 0x81,
			0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7c, 0x84, 0x7b, 0x83, 0x7c, 0x82,
			0x80, 0x80, 0x80, 0x7e, 0x81, 0x7d, 0x81, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x81, 0x7e, 0x81, 0x7d, 0x81, 0x7d, 0x81, 0x7d, 0x82, 0x7e,
			0x80, 0x81, 0x7f, 0x80, 0x7f, 0x81, 0x7d, 0x81, 0x7d, 0x82, 0x7f,
			0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x7f, 0x7f,
			0x80, 0x7f, 0x7e, 0x81, 0x7f, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x81,
			0x80, 0x7f, 0x82, 0x7e, 0x83, 0x7e, 0x80, 0x7e, 0x82, 0x80, 0x7f,
			0x7e, 0x7f, 0x81, 0x7e, 0x81, 0x7d, 0x82, 0x7c, 0x82, 0x7d, 0x80,
			0x83, 0x7c, 0x82, 0x7d, 0x84, 0x80, 0x7f, 0x81, 0x7e, 0x81, 0x7d,
			0x7f, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x7d, 0x80, 0x7e,
			0x85, 0x7d, 0x81, 0x7f, 0x7e, 0x83, 0x7b, 0x83, 0x7d, 0x81, 0x7e,
			0x7e, 0x80, 0x7e, 0x83, 0x7d, 0x83, 0x7e, 0x80, 0x7f, 0x7f, 0x81,
			0x7d, 0x82, 0x7b, 0x83, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x81,
			0x7c, 0x82, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x80,
			0x80, 0x81, 0x7e, 0x7f, 0x81, 0x80, 0x7e, 0x81, 0x80, 0x7f, 0x81,
			0x7c, 0x81, 0x7f, 0x81, 0x81, 0x7f, 0x80, 0x7e, 0x81, 0x7d, 0x7e,
			0x81, 0x7f, 0x81, 0x81, 0x7c, 0x81, 0x7f, 0x7e, 0x82, 0x7e, 0x81,
			0x81, 0x7e, 0x81, 0x7e, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7d,
			0x82, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x80,
			0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x7e, 0x81, 0x7e, 0x81, 0x81, 0x7f,
			0x7f, 0x7d, 0x82, 0x7e, 0x7f, 0x81, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7e, 0x80, 0x81, 0x7d, 0x80, 0x80, 0x7e, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x82, 0x7e, 0x7f, 0x81, 0x7d, 0x82, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x7f,
			0x80, 0x7f, 0x80, 0x82, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x7e, 0x80,
			0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x81, 0x7d, 0x7f, 0x82, 0x81, 0x80, 0x7d, 0x7f, 0x82, 0x7f, 0x7f,
			0x80, 0x7e, 0x82, 0x7e, 0x7e, 0x80, 0x80, 0x7f, 0x81, 0x7e, 0x7d,
			0x82, 0x7b, 0x83, 0x7e, 0x7f, 0x83, 0x7f, 0x82, 0x7d, 0x80, 0x80,
			0x7f, 0x7f, 0x7d, 0x82, 0x7e, 0x80, 0x81, 0x7e, 0x81, 0x7e, 0x7f,
			0x81, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x81,
			0x81, 0x7e, 0x7e, 0x81, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x81, 0x7e,
			0x7f, 0x80, 0x81, 0x7c, 0x82, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x84, 0x7e, 0x82, 0x80, 0x7d, 0x83, 0x7e, 0x7e, 0x7f, 0x80, 0x81,
			0x7d, 0x83, 0x81, 0x7e, 0x81, 0x7d, 0x7e, 0x82, 0x7d, 0x7d, 0x80,
			0x7e, 0x7e, 0x82, 0x7f, 0x7e, 0x80, 0x80, 0x80, 0x7f, 0x7d, 0x80,
			0x80, 0x81, 0x7f, 0x7e, 0x83, 0x81, 0x80, 0x81, 0x7f, 0x81, 0x7f,
			0x7f, 0x7f, 0x7d, 0x7f, 0x7e, 0x7c, 0x7c, 0x7e, 0x7e, 0x81, 0x7f,
			0x80, 0x81, 0x80, 0x7f, 0x83, 0x82, 0x7f, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x82, 0x82, 0x84, 0x85, 0x85, 0x86, 0x85, 0x86, 0x85, 0x85,
			0x85, 0x82, 0x83, 0x82, 0x7f, 0x7e, 0x80, 0x7f, 0x7e, 0x7e, 0x7b,
			0x79, 0x7b, 0x79, 0x76, 0x72, 0x6f, 0x6c, 0x69, 0x67, 0x60, 0x5e,
			0x5f, 0x5c, 0x58, 0x57, 0x56, 0x57, 0x7a, 0xa0, 0xa2, 0xa0, 0xac,
			0xb6, 0xb7, 0xb1, 0xa0, 0x93, 0x97, 0x95, 0x82, 0x72, 0x68, 0x64,
			0x69, 0x6e, 0x68, 0x6b, 0x7c, 0x89, 0x90, 0x96, 0x93, 0x95, 0xa1,
			0x9f, 0x91, 0x89, 0x84, 0x80, 0x7b, 0x73, 0x71, 0x76, 0x7a, 0x7a,
			0x7c, 0x81, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x7e, 0x77, 0x74,
			0x6f, 0x6c, 0x66, 0x60, 0x59, 0x57, 0x53, 0x4b, 0x4c, 0x4a, 0x4e,
			0x54, 0x73, 0xa7, 0xb1, 0xaa, 0xb7, 0xc1, 0xbc, 0xb7, 0x9f, 0x83,
			0x7b, 0x80, 0x6c, 0x56, 0x58, 0x60, 0x70, 0x83, 0x87, 0x88, 0xa0,
			0xb3, 0xad, 0xa3, 0x98, 0x88, 0x83, 0x7c, 0x68, 0x5c, 0x60, 0x68,
			0x6e, 0x75, 0x79, 0x83, 0x98, 0xa3, 0x9f, 0x96, 0x91, 0x8b, 0x85,
			0x7c, 0x74, 0x76, 0x7c, 0x7d, 0x7e, 0x81, 0x7d, 0x7a, 0x7b, 0x78,
			0x74, 0x70, 0x6c, 0x67, 0x63, 0x5f, 0x59, 0x55, 0x51, 0x58, 0x5e,
			0x70, 0xa2, 0xbd, 0xb4, 0xaa, 0xb3, 0xb1, 0xa3, 0x8f, 0x6e, 0x63,
			0x6c, 0x69, 0x5f, 0x66, 0x75, 0x8b, 0xa2, 0xa5, 0x9c, 0xa1, 0xa7,
			0x9d, 0x8a, 0x78, 0x6b, 0x6d, 0x70, 0x6c, 0x6a, 0x74, 0x82, 0x8a,
			0x8b, 0x85, 0x85, 0x8c, 0x8f, 0x87, 0x80, 0x81, 0x84, 0x85, 0x83,
			0x82, 0x83, 0x85, 0x82, 0x7e, 0x7b, 0x79, 0x78, 0x78, 0x77, 0x76,
			0x74, 0x71, 0x6c, 0x67, 0x61, 0x5b, 0x59, 0x56, 0x54, 0x5b, 0x6a,
			0x7f, 0x9c, 0xb8, 0xbe, 0xb3, 0xa4, 0x9c, 0x8c, 0x78, 0x67, 0x5b,
			0x5c, 0x6c, 0x7f, 0x88, 0x8f, 0x9b, 0xa8, 0xab, 0xa3, 0x93, 0x83,
			0x78, 0x73, 0x6c, 0x64, 0x66, 0x72, 0x84, 0x8f, 0x93, 0x91, 0x90,
			0x91, 0x8c, 0x81, 0x74, 0x70, 0x73, 0x78, 0x79, 0x7c, 0x85, 0x8d,
			0x8f, 0x8d, 0x8c, 0x8a, 0x86, 0x80, 0x7a, 0x77, 0x76, 0x76, 0x76,
			0x77, 0x77, 0x76, 0x73, 0x70, 0x6b, 0x65, 0x5e, 0x5a, 0x59, 0x57,
			0x5a, 0x66, 0x74, 0x85, 0xa7, 0xc1, 0xbc, 0xa8, 0x99, 0x8e, 0x7f,
			0x72, 0x64, 0x5c, 0x68, 0x80, 0x90, 0x95, 0x99, 0x9f, 0xa1, 0x9c,
			0x8c, 0x79, 0x6c, 0x6b, 0x70, 0x74, 0x7a, 0x83, 0x8e, 0x99, 0x9a,
			0x91, 0x83, 0x7b, 0x75, 0x6e, 0x6a, 0x69, 0x6e, 0x7c, 0x8e, 0x98,
			0x98, 0x96, 0x93, 0x8a, 0x81, 0x7b, 0x78, 0x7a, 0x7f, 0x81, 0x80,
			0x7d, 0x7b, 0x78, 0x77, 0x75, 0x73, 0x71, 0x71, 0x70, 0x6d, 0x68,
			0x65, 0x66, 0x68, 0x68, 0x66, 0x64, 0x6a, 0x76, 0x84, 0x9e, 0xba,
			0xbf, 0xab, 0x95, 0x84, 0x75, 0x6c, 0x69, 0x6d, 0x76, 0x87, 0x97,
			0x9e, 0x9f, 0x9c, 0x95, 0x8d, 0x84, 0x78, 0x6c, 0x6b, 0x72, 0x7a,
			0x80, 0x87, 0x8d, 0x91, 0x92, 0x8d, 0x83, 0x78, 0x70, 0x6d, 0x6e,
			0x73, 0x7b, 0x84, 0x8d, 0x94, 0x94, 0x8f, 0x88, 0x83, 0x81, 0x82,
			0x84, 0x84, 0x85, 0x83, 0x7f, 0x7a, 0x76, 0x74, 0x75, 0x77, 0x77,
			0x76, 0x74, 0x73, 0x72, 0x70, 0x6e, 0x6e, 0x6d, 0x69, 0x65, 0x65,
			0x68, 0x69, 0x67, 0x6e, 0x82, 0x93, 0xa2, 0xac, 0xab, 0xa1, 0x95,
			0x88, 0x7a, 0x71, 0x71, 0x78, 0x80, 0x85, 0x8a, 0x91, 0x96, 0x98,
			0x95, 0x8d, 0x85, 0x7f, 0x7a, 0x75, 0x74, 0x78, 0x81, 0x88, 0x8b,
			0x89, 0x88, 0x86, 0x7f, 0x74, 0x6d, 0x6c, 0x71, 0x7a, 0x81, 0x85,
			0x86, 0x8c, 0x94, 0x94, 0x8d, 0x86, 0x82, 0x80, 0x80, 0x80, 0x7e,
			0x7c, 0x7d, 0x7f, 0x7e, 0x7d, 0x7b, 0x7a, 0x78, 0x76, 0x73, 0x71,
			0x6e, 0x6c, 0x6d, 0x6f, 0x6f, 0x6f, 0x71, 0x72, 0x71, 0x70, 0x6e,
			0x69, 0x67, 0x70, 0x7f, 0x96, 0xac, 0xb2, 0xa8, 0x9c, 0x93, 0x89,
			0x81, 0x79, 0x73, 0x75, 0x80, 0x8d, 0x95, 0x96, 0x94, 0x91, 0x8d,
			0x87, 0x7e, 0x74, 0x6f, 0x73, 0x7a, 0x80, 0x85, 0x88, 0x87, 0x86,
			0x84, 0x81, 0x7c, 0x77, 0x75, 0x74, 0x75, 0x79, 0x7e, 0x82, 0x88,
			0x91, 0x96, 0x92, 0x8b, 0x85, 0x81, 0x7e, 0x7d, 0x7f, 0x81, 0x83,
			0x85, 0x85, 0x80, 0x7c, 0x7b, 0x7b, 0x78, 0x76, 0x74, 0x72, 0x72,
			0x74, 0x75, 0x74, 0x74, 0x75, 0x72, 0x6d, 0x6d, 0x6f, 0x6d, 0x6b,
			0x70, 0x75, 0x76, 0x78, 0x78, 0x73, 0x6d, 0x6d, 0x70, 0x7b, 0x8d,
			0x94, 0x91, 0x8e, 0x8d, 0x83, 0x7a, 0x79, 0x70, 0x6a, 0x7e, 0x9c,
			0xa8, 0xa4, 0xa2, 0x9e, 0x94, 0x8f, 0x8c, 0x7f, 0x6f, 0x70, 0x7a,
			0x7f, 0x83, 0x8a, 0x8e, 0x8c, 0x90, 0x94, 0x8f, 0x83, 0x7e, 0x7d,
			0x77, 0x74, 0x77, 0x7a, 0x7a, 0x7e, 0x84, 0x84, 0x82, 0x83, 0x85,
			0x83, 0x80, 0x7f, 0x7b, 0x77, 0x77, 0x7c, 0x82, 0x86, 0x8a, 0x8c,
			0x8b, 0x89, 0x89, 0x89, 0x86, 0x81, 0x7c, 0x79, 0x79, 0x7a, 0x7b,
			0x7b, 0x7c, 0x7b, 0x7a, 0x79, 0x78, 0x76, 0x75, 0x73, 0x72, 0x72,
			0x72, 0x73, 0x74, 0x75, 0x75, 0x76, 0x78, 0x7a, 0x7b, 0x7b, 0x7d,
			0x7d, 0x7c, 0x7b, 0x7d, 0x7d, 0x7c, 0x7b, 0x7b, 0x7c, 0x7b, 0x7a,
			0x79, 0x77, 0x75, 0x7a, 0x86, 0x8d, 0x8e, 0x8e, 0x91, 0x91, 0x8e,
			0x8d, 0x8b, 0x88, 0x85, 0x87, 0x89, 0x88, 0x87, 0x87, 0x86, 0x84,
			0x84, 0x84, 0x82, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7f, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d,
			0x7c, 0x7c, 0x7d, 0x7e, 0x80, 0x82, 0x84, 0x83, 0x80, 0x7e, 0x7c,
			0x7d, 0x7e, 0x81, 0x83, 0x85, 0x86, 0x86, 0x85, 0x83, 0x81, 0x7f,
			0x7e, 0x7c, 0x7b, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7a, 0x7a, 0x7b,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x7c, 0x7d, 0x7e, 0x7e,
			0x7d, 0x7c, 0x7d, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x82, 0x82, 0x82, 0x82, 0x84, 0x85, 0x86, 0x86, 0x85, 0x84, 0x85,
			0x85, 0x85, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x83, 0x81, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7d, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7e, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e,
			0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d, 0x7c, 0x7c, 0x7d, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7b, 0x7c, 0x7d, 0x7f, 0x80, 0x82, 0x84, 0x87, 0x89,
			0x88, 0x87, 0x88, 0x8a, 0x8b, 0x8a, 0x88, 0x85, 0x85, 0x86, 0x85,
			0x84, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7e, 0x7d, 0x7e, 0x7f, 0x80,
			0x82, 0x81, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7d,
			0x7b, 0x7c, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x82, 0x83, 0x84, 0x83,
			0x80, 0x7e, 0x80, 0x7f, 0x7b, 0x79, 0x78, 0x78, 0x79, 0x79, 0x79,
			0x77, 0x74, 0x77, 0x78, 0x77, 0x77, 0x77, 0x76, 0x73, 0x73, 0x72,
			0x6f, 0x6f, 0x6e, 0x6e, 0x6f, 0x70, 0x70, 0x72, 0x70, 0x6d, 0x6a,
			0x69, 0x67, 0x6d, 0x7e, 0x80, 0x83, 0x9a, 0xab, 0xaa, 0xa3, 0xa2,
			0x9a, 0x95, 0x94, 0x8c, 0x7e, 0x78, 0x7c, 0x7c, 0x7f, 0x84, 0x86,
			0x86, 0x8c, 0x93, 0x8f, 0x89, 0x86, 0x84, 0x80, 0x7f, 0x7b, 0x72,
			0x73, 0x77, 0x79, 0x79, 0x7b, 0x7c, 0x7e, 0x84, 0x85, 0x82, 0x80,
			0x82, 0x82, 0x80, 0x7e, 0x7b, 0x7f, 0x85, 0x84, 0x81, 0x84, 0x8a,
			0x8b, 0x8a, 0x88, 0x85, 0x87, 0x89, 0x86, 0x81, 0x7e, 0x7e, 0x7d,
			0x7c, 0x78, 0x75, 0x76, 0x76, 0x70, 0x6c, 0x6e, 0x71, 0x74, 0x73,
			0x71, 0x71, 0x74, 0x74, 0x73, 0x72, 0x72, 0x71, 0x6e, 0x6b, 0x69,
			0x6b, 0x6b, 0x68, 0x67, 0x69, 0x6a, 0x67, 0x64, 0x62, 0x61, 0x72,
			0x96, 0xab, 0xac, 0xaa, 0xaf, 0xaf, 0xaa, 0x9e, 0x8d, 0x85, 0x86,
			0x88, 0x82, 0x7f, 0x82, 0x88, 0x90, 0x91, 0x8f, 0x8c, 0x8d, 0x8c,
			0x87, 0x81, 0x7d, 0x7c, 0x7b, 0x7b, 0x76, 0x75, 0x77, 0x78, 0x77,
			0x76, 0x76, 0x79, 0x7d, 0x7e, 0x80, 0x82, 0x85, 0x87, 0x86, 0x84,
			0x81, 0x81, 0x84, 0x86, 0x82, 0x80, 0x83, 0x85, 0x85, 0x82, 0x82,
			0x85, 0x88, 0x88, 0x84, 0x81, 0x81, 0x7e, 0x7a, 0x77, 0x73, 0x72,
			0x74, 0x73, 0x6f, 0x6d, 0x6e, 0x70, 0x72, 0x73, 0x72, 0x74, 0x76,
			0x75, 0x73, 0x72, 0x73, 0x72, 0x72, 0x70, 0x6f, 0x70, 0x71, 0x6f,
			0x6e, 0x70, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x75, 0x78, 0x79, 0x80,
			0x8a, 0x94, 0xa3, 0xab, 0xa9, 0xa4, 0xa3, 0x9f, 0x98, 0x93, 0x8e,
			0x8d, 0x8e, 0x8d, 0x89, 0x89, 0x8a, 0x8a, 0x89, 0x87, 0x85, 0x82,
			0x82, 0x80, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7b, 0x79, 0x78, 0x78,
			0x78, 0x76, 0x76, 0x79, 0x7a, 0x7c, 0x7f, 0x82, 0x87, 0x8b, 0x8d,
			0x8d, 0x8d, 0x8e, 0x8e, 0x89, 0x85, 0x83, 0x81, 0x81, 0x80, 0x7c,
			0x7b, 0x7b, 0x7c, 0x7b, 0x7a, 0x78, 0x76, 0x75, 0x73, 0x70, 0x6e,
			0x6e, 0x6d, 0x6c, 0x6d, 0x6f, 0x71, 0x72, 0x73, 0x75, 0x76, 0x75,
			0x75, 0x78, 0x79, 0x77, 0x77, 0x77, 0x78, 0x78, 0x7a, 0x79, 0x77,
			0x79, 0x7a, 0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x7e, 0x7a, 0x78, 0x78,
			0x7d, 0x85, 0x8c, 0x92, 0x95, 0x9b, 0xa4, 0xa4, 0xa0, 0x9f, 0xa0,
			0x9e, 0x9b, 0x97, 0x92, 0x90, 0x8f, 0x8c, 0x87, 0x85, 0x84, 0x82,
			0x81, 0x7f, 0x7e, 0x7f, 0x80, 0x7e, 0x7b, 0x7a, 0x79, 0x76, 0x75,
			0x74, 0x73, 0x73, 0x75, 0x77, 0x77, 0x79, 0x7c, 0x81, 0x84, 0x85,
			0x86, 0x89, 0x8b, 0x8c, 0x8b, 0x8a, 0x8b, 0x8b, 0x88, 0x83, 0x81,
			0x80, 0x7d, 0x7a, 0x77, 0x75, 0x76, 0x75, 0x73, 0x72, 0x72, 0x72,
			0x70, 0x6f, 0x6e, 0x6d, 0x6d, 0x6d, 0x6d, 0x6e, 0x70, 0x71, 0x72,
			0x75, 0x76, 0x77, 0x79, 0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7f,
			0x7e, 0x7d, 0x7d, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7e, 0x7e,
			0x7b, 0x7b, 0x7e, 0x7f, 0x7f, 0x80, 0x84, 0x89, 0x90, 0x94, 0x94,
			0x99, 0x9f, 0xa1, 0x9f, 0x9f, 0xa0, 0xa1, 0xa1, 0x9d, 0x99, 0x98,
			0x94, 0x90, 0x8c, 0x88, 0x84, 0x82, 0x7f, 0x7b, 0x7a, 0x7a, 0x79,
			0x76, 0x75, 0x73, 0x71, 0x71, 0x71, 0x70, 0x71, 0x74, 0x76, 0x77,
			0x79, 0x7c, 0x7f, 0x81, 0x83, 0x85, 0x87, 0x8a, 0x89, 0x89, 0x89,
			0x8a, 0x88, 0x85, 0x82, 0x81, 0x7e, 0x7c, 0x79, 0x76, 0x74, 0x73,
			0x70, 0x6e, 0x6d, 0x6c, 0x6c, 0x6b, 0x6b, 0x6b, 0x6c, 0x6e, 0x6e,
			0x6f, 0x70, 0x73, 0x73, 0x74, 0x76, 0x78, 0x7a, 0x7b, 0x7c, 0x7d,
			0x7f, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x7f, 0x81, 0x81, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7b, 0x7a, 0x7a, 0x79, 0x78,
			0x79, 0x7c, 0x81, 0x85, 0x88, 0x8b, 0x92, 0x97, 0x98, 0x9a, 0x9d,
			0xa0, 0xa1, 0xa0, 0x9f, 0x9e, 0x9d, 0x9b, 0x99, 0x94, 0x90, 0x8e,
			0x8a, 0x86, 0x83, 0x80, 0x7e, 0x7c, 0x7b, 0x78, 0x76, 0x75, 0x73,
			0x72, 0x70, 0x6f, 0x6f, 0x6f, 0x6f, 0x71, 0x72, 0x73, 0x76, 0x79,
			0x7b, 0x7d, 0x7f, 0x83, 0x85, 0x86, 0x86, 0x87, 0x87, 0x86, 0x84,
			0x83, 0x82, 0x81, 0x7f, 0x7d, 0x7b, 0x79, 0x78, 0x75, 0x74, 0x73,
			0x73, 0x71, 0x71, 0x72, 0x71, 0x71, 0x72, 0x72, 0x73, 0x73, 0x74,
			0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7d,
			0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x81, 0x86, 0x85,
			0x87, 0x8d, 0x91, 0x93, 0x94, 0x96, 0x9a, 0x9d, 0x9d, 0x9c, 0x9c,
			0x9c, 0x9b, 0x99, 0x96, 0x92, 0x90, 0x8e, 0x8a, 0x86, 0x84, 0x82,
			0x80, 0x7e, 0x7c, 0x7a, 0x79, 0x77, 0x75, 0x75, 0x75, 0x74, 0x73,
			0x73, 0x73, 0x74, 0x75, 0x75, 0x77, 0x79, 0x7b, 0x7d, 0x7e, 0x81,
			0x83, 0x83, 0x85, 0x86, 0x86, 0x86, 0x87, 0x86, 0x84, 0x83, 0x82,
			0x81, 0x7f, 0x7d, 0x7c, 0x7a, 0x79, 0x77, 0x76, 0x76, 0x76, 0x75,
			0x75, 0x75, 0x75, 0x75, 0x75, 0x76, 0x76, 0x77, 0x77, 0x78, 0x78,
			0x7a, 0x7b, 0x7a, 0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x81, 0x83, 0x84, 0x84, 0x86, 0x88, 0x89,
			0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d, 0x8d,
			0x8c, 0x8b, 0x8a, 0x89, 0x87, 0x86, 0x85, 0x84, 0x82, 0x81, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x79, 0x79, 0x78, 0x77,
			0x78, 0x78, 0x78, 0x77, 0x78, 0x78, 0x79, 0x79, 0x79, 0x79, 0x7a,
			0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
			0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82,
			0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x84,
			0x84, 0x85, 0x85, 0x86, 0x86, 0x87, 0x87, 0x88, 0x88, 0x89, 0x89,
			0x89, 0x88, 0x88, 0x87, 0x87, 0x87, 0x86, 0x85, 0x84, 0x83, 0x83,
			0x82, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7b,
			0x7b, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79,
			0x79, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81,
			0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x82,
			0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x82, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
		},
		{ // 8
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81,
			0x81, 0x89, 0x91, 0x84, 0x81, 0x88, 0x79, 0x6b, 0x71, 0x74, 0x77,
			0x81, 0x84, 0x87, 0x87, 0x7b, 0x6f, 0x6e, 0x6a, 0x64, 0x65, 0x63,
			0x62, 0x67, 0x73, 0x71, 0x69, 0x84, 0x88, 0x70, 0x76, 0x81, 0x71,
			0x63, 0x6f, 0x6b, 0x69, 0x80, 0x91, 0x95, 0xa0, 0xa8, 0xa3, 0xa1,
			0x9c, 0x90, 0x86, 0x82, 0x79, 0x78, 0x7f, 0x81, 0x89, 0x92, 0x9c,
			0xa4, 0xa5, 0x9e, 0x96, 0x8e, 0x83, 0x79, 0x72, 0x6d, 0x6a, 0x6f,
			0x6e, 0x71, 0x7b, 0x7a, 0x7e, 0x7e, 0x7b, 0x79, 0x6e, 0x67, 0x62,
			0x66, 0x5e, 0x56, 0x51, 0x4f, 0x95, 0xa8, 0x7f, 0x9b, 0xc6, 0xa6,
			0x81, 0x93, 0x89, 0x6f, 0x69, 0x68, 0x72, 0x71, 0x6e, 0x84, 0x92,
			0x8c, 0x97, 0xa1, 0x9c, 0x91, 0x8a, 0x88, 0x80, 0x73, 0x6d, 0x74,
			0x74, 0x72, 0x7c, 0x90, 0x9a, 0x95, 0x99, 0x9b, 0x8c, 0x7f, 0x7c,
			0x74, 0x6f, 0x6c, 0x73, 0x7e, 0x7c, 0x7d, 0x83, 0x7f, 0x7b, 0x77,
			0x73, 0x70, 0x66, 0x62, 0x5f, 0x5a, 0x51, 0x74, 0xa6, 0x91, 0x90,
			0xba, 0xb9, 0x94, 0x8f, 0x99, 0x7f, 0x65, 0x65, 0x6e, 0x6c, 0x65,
			0x74, 0x91, 0x90, 0x8e, 0xa0, 0xa5, 0x93, 0x8b, 0x8b, 0x7d, 0x72,
			0x6f, 0x6f, 0x73, 0x76, 0x81, 0x90, 0x93, 0x95, 0x9d, 0x96, 0x8d,
			0x8b, 0x82, 0x76, 0x73, 0x72, 0x6e, 0x71, 0x6f, 0x6c, 0x6e, 0x6a,
			0x6a, 0x6c, 0x6a, 0x67, 0x65, 0x64, 0x5f, 0x5b, 0x58, 0x71, 0x9a,
			0x8d, 0x90, 0xb7, 0xb1, 0x95, 0x95, 0x9a, 0x82, 0x6e, 0x6a, 0x6b,
			0x68, 0x64, 0x72, 0x86, 0x8f, 0x91, 0x9e, 0xa7, 0x9b, 0x94, 0x92,
			0x84, 0x77, 0x74, 0x6e, 0x6c, 0x74, 0x7c, 0x85, 0x8c, 0x93, 0x9a,
			0x99, 0x93, 0x8d, 0x87, 0x80, 0x7b, 0x77, 0x71, 0x6f, 0x6f, 0x6a,
			0x69, 0x66, 0x63, 0x67, 0x64, 0x61, 0x62, 0x5f, 0x60, 0x5e, 0x5a,
			0x59, 0x74, 0x9f, 0x92, 0x98, 0xc1, 0xaf, 0x8e, 0x95, 0x90, 0x73,
			0x6a, 0x69, 0x6b, 0x6c, 0x69, 0x77, 0x8b, 0x8e, 0x92, 0xa7, 0xa8,
			0x97, 0x97, 0x95, 0x83, 0x7a, 0x77, 0x71, 0x70, 0x76, 0x7d, 0x87,
			0x89, 0x8b, 0x94, 0x92, 0x8e, 0x8d, 0x88, 0x81, 0x80, 0x7c, 0x6f,
			0x71, 0x73, 0x68, 0x65, 0x68, 0x63, 0x65, 0x65, 0x5f, 0x5f, 0x62,
			0x60, 0x5e, 0x5b, 0x57, 0x56, 0x82, 0xa3, 0x86, 0xa0, 0xc7, 0xa6,
			0x8d, 0x9d, 0x92, 0x72, 0x6c, 0x6f, 0x6d, 0x65, 0x6a, 0x7c, 0x85,
			0x83, 0x95, 0xa6, 0x9f, 0x9c, 0x9c, 0x94, 0x84, 0x7b, 0x78, 0x6f,
			0x6f, 0x76, 0x7c, 0x83, 0x89, 0x90, 0x98, 0x94, 0x91, 0x93, 0x87,
			0x7e, 0x81, 0x7c, 0x71, 0x73, 0x73, 0x6b, 0x69, 0x68, 0x65, 0x61,
			0x5d, 0x5e, 0x60, 0x5d, 0x5a, 0x5e, 0x5d, 0x57, 0x50, 0x68, 0x9d,
			0x92, 0x8a, 0xbe, 0xbe, 0x95, 0x9c, 0xa4, 0x84, 0x71, 0x71, 0x71,
			0x66, 0x5d, 0x6e, 0x80, 0x7e, 0x88, 0xa4, 0xa5, 0x99, 0x9c, 0xa3,
			0x93, 0x81, 0x84, 0x7a, 0x6c, 0x6d, 0x70, 0x75, 0x79, 0x80, 0x8d,
			0x96, 0x94, 0x98, 0x9a, 0x90, 0x86, 0x7e, 0x7c, 0x78, 0x71, 0x6d,
			0x6f, 0x6c, 0x68, 0x67, 0x65, 0x63, 0x61, 0x63, 0x60, 0x5c, 0x5d,
			0x61, 0x66, 0x61, 0x61, 0x69, 0x8a, 0xa0, 0x8d, 0xa3, 0xba, 0x9f,
			0x8e, 0x98, 0x90, 0x74, 0x72, 0x77, 0x6e, 0x67, 0x74, 0x7e, 0x83,
			0x8b, 0x9a, 0xa1, 0x9d, 0x9d, 0x97, 0x8e, 0x84, 0x7a, 0x75, 0x6d,
			0x69, 0x6e, 0x72, 0x7a, 0x89, 0x8e, 0x8f, 0x9c, 0x9e, 0x95, 0x95,
			0x92, 0x85, 0x7a, 0x78, 0x74, 0x6c, 0x6a, 0x68, 0x61, 0x61, 0x68,
			0x67, 0x63, 0x68, 0x6b, 0x66, 0x60, 0x64, 0x68, 0x64, 0x5b, 0x5b,
			0x5b, 0x70, 0x8d, 0x81, 0x90, 0xaf, 0xa8, 0x9c, 0xa9, 0xab, 0x93,
			0x89, 0x88, 0x7f, 0x70, 0x6b, 0x6f, 0x70, 0x6e, 0x7b, 0x89, 0x8c,
			0x92, 0x9b, 0xa1, 0x9b, 0x97, 0x97, 0x8b, 0x7f, 0x7b, 0x76, 0x6c,
			0x6a, 0x6d, 0x70, 0x75, 0x7d, 0x87, 0x8d, 0x94, 0x9d, 0x9e, 0x98,
			0x8f, 0x89, 0x81, 0x75, 0x72, 0x72, 0x6c, 0x68, 0x69, 0x6c, 0x6d,
			0x6d, 0x72, 0x73, 0x6c, 0x68, 0x66, 0x65, 0x62, 0x60, 0x61, 0x5d,
			0x56, 0x57, 0x60, 0x70, 0x76, 0x86, 0x9d, 0x9f, 0xa5, 0xb2, 0xb2,
			0xa7, 0xa5, 0x9d, 0x8e, 0x82, 0x76, 0x70, 0x69, 0x66, 0x6a, 0x73,
			0x78, 0x80, 0x8e, 0x93, 0x99, 0xa0, 0xa2, 0xa0, 0x9a, 0x95, 0x8b,
			0x7e, 0x74, 0x6d, 0x65, 0x61, 0x61, 0x63, 0x6d, 0x76, 0x7f, 0x8c,
			0x96, 0xa0, 0xa4, 0xa7, 0xa6, 0x9f, 0x98, 0x8c, 0x82, 0x7a, 0x6f,
			0x6a, 0x65, 0x62, 0x60, 0x61, 0x63, 0x63, 0x68, 0x6b, 0x6c, 0x6e,
			0x6b, 0x6c, 0x68, 0x63, 0x65, 0x66, 0x68, 0x63, 0x5f, 0x5e, 0x5f,
			0x64, 0x71, 0x82, 0x85, 0x94, 0xa6, 0xa9, 0xab, 0xb2, 0xb4, 0xaa,
			0xa5, 0x9f, 0x91, 0x85, 0x7d, 0x75, 0x6c, 0x6b, 0x6b, 0x6c, 0x70,
			0x78, 0x81, 0x87, 0x8e, 0x93, 0x95, 0x96, 0x94, 0x91, 0x8b, 0x84,
			0x7e, 0x77, 0x71, 0x6f, 0x6d, 0x6e, 0x73, 0x79, 0x80, 0x86, 0x8f,
			0x97, 0x97, 0x9c, 0x9d, 0x98, 0x93, 0x8f, 0x89, 0x7e, 0x78, 0x73,
			0x6a, 0x63, 0x62, 0x5d, 0x5a, 0x5b, 0x5b, 0x5d, 0x5f, 0x5f, 0x62,
			0x64, 0x62, 0x5f, 0x60, 0x60, 0x60, 0x63, 0x64, 0x61, 0x60, 0x66,
			0x66, 0x6e, 0x80, 0x81, 0x8a, 0x9b, 0x9f, 0xa2, 0xab, 0xb4, 0xad,
			0xad, 0xae, 0xa2, 0x9a, 0x93, 0x89, 0x7d, 0x77, 0x73, 0x6d, 0x6b,
			0x6d, 0x72, 0x73, 0x7a, 0x80, 0x84, 0x8b, 0x8e, 0x92, 0x92, 0x91,
			0x8f, 0x8c, 0x86, 0x81, 0x7f, 0x7a, 0x79, 0x7b, 0x77, 0x7b, 0x80,
			0x7f, 0x84, 0x89, 0x88, 0x89, 0x8c, 0x89, 0x87, 0x86, 0x82, 0x7d,
			0x79, 0x75, 0x70, 0x6a, 0x67, 0x61, 0x5d, 0x5b, 0x57, 0x56, 0x57,
			0x5a, 0x63, 0x68, 0x67, 0x66, 0x60, 0x5c, 0x5a, 0x56, 0x56, 0x55,
			0x51, 0x54, 0x57, 0x5a, 0x65, 0x75, 0x79, 0x84, 0x9a, 0x9c, 0xa1,
			0xb2, 0xb5, 0xb3, 0xb8, 0xba, 0xb0, 0xa9, 0xa7, 0x99, 0x8e, 0x88,
			0x7e, 0x75, 0x70, 0x6f, 0x69, 0x69, 0x6d, 0x6d, 0x71, 0x76, 0x7b,
			0x7f, 0x83, 0x88, 0x89, 0x8b, 0x8c, 0x8d, 0x8b, 0x8b, 0x8b, 0x86,
			0x89, 0x88, 0x82, 0x85, 0x85, 0x81, 0x82, 0x82, 0x7f, 0x7e, 0x7e,
			0x7b, 0x78, 0x77, 0x73, 0x71, 0x6e, 0x6b, 0x6a, 0x69, 0x6a, 0x6d,
			0x6f, 0x6f, 0x73, 0x74, 0x74, 0x76, 0x75, 0x73, 0x71, 0x6e, 0x6c,
			0x69, 0x67, 0x65, 0x63, 0x5f, 0x5e, 0x5e, 0x5b, 0x59, 0x5b, 0x65,
			0x65, 0x66, 0x7a, 0x7f, 0x7e, 0x90, 0x99, 0x98, 0xa3, 0xad, 0xab,
			0xac, 0xb2, 0xac, 0xa7, 0xa5, 0x9e, 0x95, 0x8e, 0x89, 0x80, 0x7a,
			0x78, 0x72, 0x6f, 0x70, 0x70, 0x70, 0x73, 0x77, 0x79, 0x7b, 0x7f,
			0x82, 0x83, 0x85, 0x87, 0x88, 0x8a, 0x8b, 0x8a, 0x8c, 0x8b, 0x89,
			0x8a, 0x89, 0x86, 0x85, 0x84, 0x80, 0x7e, 0x7d, 0x79, 0x77, 0x75,
			0x73, 0x72, 0x71, 0x72, 0x71, 0x71, 0x76, 0x78, 0x7a, 0x7f, 0x82,
			0x83, 0x86, 0x88, 0x87, 0x86, 0x86, 0x83, 0x81, 0x80, 0x7d, 0x7a,
			0x79, 0x76, 0x74, 0x72, 0x71, 0x6f, 0x6d, 0x6d, 0x6b, 0x68, 0x6a,
			0x68, 0x66, 0x67, 0x66, 0x64, 0x68, 0x71, 0x6c, 0x71, 0x7f, 0x7a,
			0x80, 0x8d, 0x8a, 0x90, 0x97, 0x99, 0x9b, 0x9d, 0x9f, 0x9c, 0x9b,
			0x9a, 0x98, 0x92, 0x8e, 0x8d, 0x86, 0x83, 0x83, 0x7c, 0x7c, 0x7c,
			0x78, 0x78, 0x7a, 0x7a, 0x79, 0x7b, 0x7c, 0x7c, 0x7c, 0x7e, 0x7f,
			0x7e, 0x80, 0x81, 0x81, 0x83, 0x84, 0x84, 0x85, 0x84, 0x86, 0x84,
			0x84, 0x85, 0x82, 0x82, 0x81, 0x7e, 0x7e, 0x7c, 0x7b, 0x79, 0x76,
			0x77, 0x76, 0x74, 0x76, 0x74, 0x73, 0x75, 0x74, 0x74, 0x76, 0x76,
			0x77, 0x78, 0x7a, 0x7c, 0x7d, 0x7e, 0x80, 0x81, 0x82, 0x83, 0x84,
			0x84, 0x85, 0x86, 0x85, 0x85, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x81,
			0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x81, 0x7c, 0x8b,
			0x86, 0x7a, 0x85, 0x7f, 0x88, 0x7c, 0x77, 0x87, 0x83, 0x89, 0x8a,
			0x84, 0x82, 0x79, 0x81, 0x8b, 0x86, 0x82, 0x7e, 0x7e, 0x7c, 0x75,
			0x79, 0x7c, 0x7e, 0x7b, 0x78, 0x7e, 0x7d, 0x80, 0x7e, 0x7d, 0x7f,
			0x7e, 0x7d, 0x7d, 0x82, 0x81, 0x80, 0x7c, 0x81, 0x81, 0x7e, 0x7c,
			0x80, 0x85, 0x7f, 0x80, 0x82, 0x85, 0x81, 0x7d, 0x83, 0x83, 0x83,
			0x7e, 0x7f, 0x82, 0x81, 0x7e, 0x7d, 0x82, 0x80, 0x7d, 0x7d, 0x81,
			0x81, 0x7f, 0x7d, 0x81, 0x84, 0x7f, 0x7f, 0x83, 0x82, 0x80, 0x7f,
			0x7f, 0x81, 0x7f, 0x7d, 0x82, 0x82, 0x7b, 0x7d, 0x80, 0x7d, 0x7d,
			0x7f, 0x82, 0x81, 0x80, 0x7e, 0x80, 0x7f, 0x7c, 0x7e, 0x80, 0x82,
			0x82, 0x81, 0x81, 0x80, 0x7f, 0x7d, 0x7e, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
			0x80, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x81,
			0x80, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81,
			0x81, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f,
		},
		{ // 9
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7c, 0x7a,
			0x79, 0x7a, 0x7b, 0x7e, 0x80, 0x83, 0x86, 0x8a, 0x8e, 0x91, 0x95,
			0x98, 0x9a, 0x9c, 0x9e, 0x9f, 0x9f, 0x9e, 0x9c, 0x9b, 0x99, 0x96,
			0x93, 0x91, 0x8e, 0x8a, 0x88, 0x86, 0x83, 0x82, 0x80, 0x7f, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x81, 0x81, 0x81, 0x82,
			0x81, 0x81, 0x80, 0x7f, 0x7d, 0x7b, 0x79, 0x76, 0x74, 0x71, 0x6e,
			0x6b, 0x69, 0x67, 0x65, 0x64, 0x63, 0x62, 0x62, 0x62, 0x62, 0x62,
			0x64, 0x64, 0x64, 0x66, 0x67, 0x67, 0x68, 0x6a, 0x6e, 0x71, 0x75,
			0x7a, 0x7f, 0x84, 0x8a, 0x8f, 0x94, 0x99, 0x9e, 0xa1, 0xa4, 0xa6,
			0xa6, 0xa7, 0xa7, 0xa6, 0xa4, 0xa2, 0x9e, 0x99, 0x96, 0x91, 0x8d,
			0x89, 0x85, 0x81, 0x7e, 0x7d, 0x7b, 0x78, 0x78, 0x78, 0x78, 0x78,
			0x79, 0x7a, 0x7b, 0x7e, 0x80, 0x82, 0x85, 0x86, 0x87, 0x89, 0x88,
			0x87, 0x86, 0x84, 0x80, 0x7d, 0x7a, 0x76, 0x73, 0x6f, 0x6b, 0x69,
			0x66, 0x62, 0x5f, 0x5d, 0x5b, 0x59, 0x58, 0x58, 0x58, 0x59, 0x5b,
			0x5d, 0x5e, 0x5f, 0x62, 0x64, 0x66, 0x6b, 0x73, 0x79, 0x80, 0x8c,
			0x95, 0x97, 0x9e, 0xa8, 0xab, 0xab, 0xaf, 0xaf, 0xac, 0xad, 0xac,
			0xa6, 0xa4, 0xa3, 0x9c, 0x97, 0x95, 0x90, 0x88, 0x86, 0x83, 0x7d,
			0x7b, 0x7a, 0x77, 0x75, 0x76, 0x75, 0x74, 0x77, 0x77, 0x78, 0x7b,
			0x7d, 0x7d, 0x80, 0x83, 0x84, 0x85, 0x88, 0x88, 0x87, 0x88, 0x87,
			0x85, 0x84, 0x81, 0x7d, 0x7a, 0x76, 0x72, 0x6f, 0x6b, 0x66, 0x63,
			0x61, 0x5e, 0x5c, 0x5c, 0x5b, 0x5b, 0x5c, 0x5e, 0x5e, 0x61, 0x63,
			0x65, 0x67, 0x6c, 0x75, 0x79, 0x7d, 0x87, 0x8f, 0x93, 0x9a, 0xa4,
			0xa8, 0xad, 0xb2, 0xb3, 0xb3, 0xb4, 0xb3, 0xaf, 0xac, 0xa9, 0xa3,
			0x9d, 0x98, 0x91, 0x8b, 0x87, 0x83, 0x7d, 0x78, 0x75, 0x71, 0x70,
			0x6f, 0x6d, 0x6d, 0x70, 0x74, 0x76, 0x79, 0x7c, 0x7d, 0x80, 0x83,
			0x85, 0x85, 0x87, 0x8c, 0x8f, 0x91, 0x8c, 0x84, 0x7d, 0x77, 0x74,
			0x6b, 0x63, 0x60, 0x5b, 0x55, 0x4f, 0x4d, 0x4c, 0x4d, 0x4b, 0x4b,
			0x4b, 0x49, 0x48, 0x47, 0x53, 0x73, 0x8f, 0x97, 0x99, 0x9f, 0xa8,
			0xaa, 0xa1, 0x93, 0x8e, 0x95, 0x9c, 0x99, 0x8f, 0x8b, 0x93, 0x9c,
			0x98, 0x8b, 0x86, 0x8a, 0x8d, 0x8a, 0x84, 0x82, 0x86, 0x88, 0x85,
			0x7d, 0x78, 0x7d, 0x82, 0x80, 0x7c, 0x82, 0x8b, 0x8a, 0x88, 0x88,
			0x88, 0x8a, 0x8a, 0x86, 0x86, 0x88, 0x86, 0x82, 0x7a, 0x75, 0x72,
			0x6b, 0x63, 0x61, 0x5f, 0x5f, 0x5f, 0x5c, 0x58, 0x55, 0x50, 0x52,
			0x55, 0x4f, 0x51, 0x55, 0x4f, 0x44, 0x5c, 0x9c, 0xbb, 0xb0, 0x99,
			0x8d, 0x96, 0x9a, 0x88, 0x73, 0x7c, 0x95, 0x9e, 0x97, 0x90, 0x8f,
			0x98, 0x9e, 0x95, 0x89, 0x85, 0x87, 0x87, 0x84, 0x81, 0x83, 0x86,
			0x87, 0x84, 0x7f, 0x7d, 0x7f, 0x80, 0x7f, 0x81, 0x85, 0x86, 0x87,
			0x89, 0x8b, 0x8c, 0x8c, 0x88, 0x85, 0x83, 0x84, 0x82, 0x7c, 0x76,
			0x75, 0x73, 0x6d, 0x65, 0x63, 0x65, 0x63, 0x5d, 0x5b, 0x5a, 0x57,
			0x57, 0x56, 0x53, 0x54, 0x4f, 0x4d, 0x48, 0x57, 0x98, 0xc3, 0xb7,
			0x94, 0x81, 0x85, 0x8c, 0x81, 0x6c, 0x74, 0x95, 0xa4, 0x9e, 0x90,
			0x86, 0x8c, 0x94, 0x8a, 0x7d, 0x7b, 0x80, 0x89, 0x8d, 0x88, 0x83,
			0x84, 0x89, 0x87, 0x80, 0x79, 0x79, 0x80, 0x83, 0x81, 0x84, 0x85,
			0x86, 0x89, 0x8b, 0x89, 0x85, 0x83, 0x82, 0x80, 0x7d, 0x7c, 0x7c,
			0x7a, 0x78, 0x75, 0x71, 0x6f, 0x6e, 0x6c, 0x67, 0x63, 0x61, 0x5f,
			0x5e, 0x5e, 0x5c, 0x5a, 0x5c, 0x5d, 0x6a, 0x88, 0xa7, 0xb4, 0xa5,
			0x8c, 0x77, 0x70, 0x75, 0x7e, 0x88, 0x91, 0x95, 0x94, 0x8e, 0x8c,
			0x8a, 0x84, 0x81, 0x84, 0x88, 0x89, 0x86, 0x86, 0x88, 0x8a, 0x8b,
			0x86, 0x80, 0x7d, 0x7d, 0x80, 0x83, 0x80, 0x80, 0x84, 0x82, 0x7f,
			0x82, 0x87, 0x8a, 0x89, 0x84, 0x7e, 0x7a, 0x78, 0x79, 0x7b, 0x7c,
			0x77, 0x73, 0x74, 0x72, 0x6e, 0x68, 0x64, 0x66, 0x67, 0x66, 0x65,
			0x65, 0x62, 0x5d, 0x60, 0x7d, 0xab, 0xbe, 0xaa, 0x86, 0x68, 0x5f,
			0x6f, 0x86, 0x90, 0x8d, 0x89, 0x8c, 0x95, 0x98, 0x8f, 0x82, 0x7c,
			0x7e, 0x84, 0x86, 0x86, 0x87, 0x87, 0x85, 0x84, 0x84, 0x84, 0x82,
			0x82, 0x84, 0x83, 0x82, 0x85, 0x84, 0x83, 0x86, 0x86, 0x85, 0x86,
			0x86, 0x7f, 0x79, 0x76, 0x77, 0x7e, 0x81, 0x7a, 0x6e, 0x66, 0x69,
			0x72, 0x74, 0x6c, 0x63, 0x61, 0x60, 0x5e, 0x5f, 0x5c, 0x5f, 0x7e,
			0xaa, 0xbe, 0xae, 0x8a, 0x66, 0x5a, 0x6a, 0x81, 0x8f, 0x93, 0x8d,
			0x87, 0x89, 0x8e, 0x90, 0x8c, 0x84, 0x7c, 0x7e, 0x86, 0x89, 0x88,
			0x86, 0x85, 0x87, 0x88, 0x85, 0x80, 0x7f, 0x80, 0x83, 0x86, 0x85,
			0x85, 0x87, 0x88, 0x87, 0x85, 0x84, 0x82, 0x7e, 0x79, 0x78, 0x7a,
			0x7a, 0x78, 0x75, 0x73, 0x6f, 0x6d, 0x6b, 0x68, 0x66, 0x64, 0x62,
			0x5f, 0x5a, 0x58, 0x65, 0x88, 0xaf, 0xbe, 0xaa, 0x81, 0x5e, 0x56,
			0x6a, 0x88, 0x99, 0x95, 0x88, 0x81, 0x85, 0x8e, 0x92, 0x8c, 0x82,
			0x7e, 0x80, 0x82, 0x82, 0x82, 0x84, 0x87, 0x8a, 0x8b, 0x8a, 0x8a,
			0x87, 0x81, 0x7b, 0x79, 0x7c, 0x82, 0x8a, 0x8e, 0x8e, 0x8b, 0x85,
			0x7d, 0x77, 0x75, 0x77, 0x7b, 0x7c, 0x78, 0x73, 0x6f, 0x6c, 0x6c,
			0x6e, 0x6c, 0x67, 0x66, 0x62, 0x5a, 0x54, 0x59, 0x77, 0xa8, 0xc4,
			0xb8, 0x94, 0x68, 0x50, 0x59, 0x79, 0x97, 0xa0, 0x92, 0x80, 0x7a,
			0x84, 0x93, 0x96, 0x8c, 0x7f, 0x7b, 0x7c, 0x80, 0x83, 0x85, 0x87,
			0x8a, 0x8c, 0x8c, 0x8b, 0x88, 0x81, 0x7a, 0x78, 0x7b, 0x80, 0x89,
			0x8f, 0x8f, 0x8a, 0x85, 0x81, 0x7e, 0x79, 0x78, 0x79, 0x78, 0x76,
			0x75, 0x73, 0x71, 0x6e, 0x68, 0x65, 0x64, 0x61, 0x61, 0x5e, 0x56,
			0x50, 0x5c, 0x89, 0xb9, 0xc7, 0xb1, 0x81, 0x57, 0x4f, 0x68, 0x8c,
			0xa2, 0x9a, 0x83, 0x79, 0x7e, 0x8b, 0x94, 0x93, 0x89, 0x81, 0x7d,
			0x7d, 0x80, 0x82, 0x82, 0x85, 0x89, 0x8c, 0x8d, 0x8c, 0x86, 0x7f,
			0x7c, 0x7c, 0x7d, 0x7f, 0x86, 0x8b, 0x8d, 0x8c, 0x86, 0x7f, 0x7a,
			0x78, 0x78, 0x7b, 0x7c, 0x79, 0x74, 0x71, 0x6f, 0x6d, 0x6b, 0x68,
			0x66, 0x64, 0x64, 0x64, 0x5d, 0x54, 0x53, 0x68, 0x9a, 0xc0, 0xc0,
			0xa0, 0x6e, 0x4f, 0x56, 0x76, 0x98, 0xa6, 0x96, 0x7f, 0x79, 0x80,
			0x8c, 0x93, 0x8f, 0x87, 0x82, 0x7e, 0x7d, 0x80, 0x82, 0x84, 0x87,
			0x88, 0x89, 0x89, 0x87, 0x81, 0x7b, 0x7b, 0x7f, 0x86, 0x8b, 0x8c,
			0x89, 0x84, 0x80, 0x7d, 0x7b, 0x7a, 0x7c, 0x7d, 0x7c, 0x78, 0x74,
			0x71, 0x6f, 0x70, 0x70, 0x6e, 0x6a, 0x68, 0x6b, 0x6e, 0x6a, 0x64,
			0x5e, 0x57, 0x5b, 0x78, 0xa2, 0xb9, 0xb0, 0x8f, 0x69, 0x5a, 0x64,
			0x7e, 0x96, 0x9d, 0x90, 0x7f, 0x7e, 0x88, 0x90, 0x90, 0x8a, 0x84,
			0x81, 0x82, 0x84, 0x83, 0x81, 0x83, 0x87, 0x8a, 0x89, 0x85, 0x7f,
			0x7b, 0x7c, 0x7d, 0x81, 0x88, 0x8b, 0x8c, 0x8c, 0x87, 0x83, 0x81,
			0x7f, 0x7c, 0x79, 0x77, 0x7a, 0x7e, 0x7b, 0x76, 0x75, 0x75, 0x73,
			0x70, 0x6a, 0x62, 0x62, 0x67, 0x6b, 0x69, 0x61, 0x5d, 0x5e, 0x60,
			0x66, 0x6f, 0x82, 0xa1, 0xae, 0xa2, 0x87, 0x6b, 0x63, 0x72, 0x8a,
			0x9a, 0x9b, 0x8e, 0x85, 0x85, 0x89, 0x8b, 0x88, 0x81, 0x7e, 0x7e,
			0x83, 0x88, 0x87, 0x84, 0x84, 0x86, 0x88, 0x86, 0x80, 0x7a, 0x76,
			0x75, 0x79, 0x81, 0x8b, 0x92, 0x95, 0x91, 0x89, 0x82, 0x7f, 0x80,
			0x84, 0x86, 0x83, 0x7f, 0x7c, 0x79, 0x77, 0x78, 0x78, 0x75, 0x72,
			0x6e, 0x6b, 0x69, 0x6a, 0x69, 0x66, 0x65, 0x64, 0x67, 0x69, 0x66,
			0x63, 0x5f, 0x5d, 0x5c, 0x5e, 0x83, 0xaf, 0xb7, 0xa9, 0x89, 0x67,
			0x62, 0x75, 0x8d, 0xa1, 0x9d, 0x8a, 0x82, 0x84, 0x87, 0x8d, 0x8c,
			0x88, 0x88, 0x86, 0x82, 0x81, 0x7f, 0x80, 0x83, 0x82, 0x80, 0x81,
			0x80, 0x81, 0x81, 0x80, 0x7c, 0x79, 0x7c, 0x85, 0x8d, 0x90, 0x8e,
			0x89, 0x82, 0x7e, 0x7f, 0x82, 0x85, 0x87, 0x85, 0x80, 0x80, 0x7f,
			0x7b, 0x76, 0x74, 0x76, 0x78, 0x78, 0x73, 0x6d, 0x69, 0x68, 0x6a,
			0x6c, 0x6d, 0x69, 0x64, 0x65, 0x67, 0x6d, 0x69, 0x65, 0x61, 0x5d,
			0x5e, 0x63, 0x92, 0xbf, 0xbf, 0xaf, 0x89, 0x63, 0x5d, 0x74, 0x90,
			0xa5, 0x9f, 0x8b, 0x83, 0x83, 0x8b, 0x92, 0x8e, 0x84, 0x80, 0x7e,
			0x84, 0x8b, 0x86, 0x7f, 0x7e, 0x81, 0x85, 0x89, 0x83, 0x7a, 0x74,
			0x6f, 0x71, 0x77, 0x7c, 0x82, 0x88, 0x88, 0x87, 0x87, 0x88, 0x8b,
			0x8b, 0x86, 0x81, 0x7e, 0x7f, 0x83, 0x87, 0x88, 0x84, 0x7c, 0x79,
			0x79, 0x7a, 0x7b, 0x79, 0x76, 0x74, 0x72, 0x71, 0x70, 0x70, 0x6e,
			0x6d, 0x6e, 0x6f, 0x6e, 0x6b, 0x67, 0x66, 0x6a, 0x6e, 0x6f, 0x6d,
			0x69, 0x63, 0x5f, 0x64, 0x66, 0x7a, 0xa9, 0xbe, 0xb6, 0x9e, 0x78,
			0x64, 0x71, 0x88, 0x9a, 0x9f, 0x8e, 0x84, 0x89, 0x8c, 0x8f, 0x8c,
			0x82, 0x80, 0x82, 0x83, 0x82, 0x81, 0x7a, 0x7c, 0x85, 0x89, 0x8d,
			0x8a, 0x7e, 0x78, 0x76, 0x76, 0x79, 0x7a, 0x7d, 0x7f, 0x7f, 0x7f,
			0x81, 0x86, 0x87, 0x85, 0x82, 0x7f, 0x7e, 0x82, 0x88, 0x87, 0x85,
			0x86, 0x88, 0x86, 0x83, 0x7f, 0x7d, 0x81, 0x80, 0x7d, 0x7c, 0x7b,
			0x7b, 0x7b, 0x7a, 0x78, 0x75, 0x73, 0x71, 0x71, 0x75, 0x78, 0x77,
			0x75, 0x72, 0x71, 0x72, 0x72, 0x70, 0x6d, 0x6b, 0x6b, 0x6c, 0x6f,
			0x70, 0x6f, 0x6d, 0x69, 0x69, 0x68, 0x6b, 0x6a, 0x76, 0xa7, 0xbc,
			0xad, 0x93, 0x77, 0x70, 0x7e, 0x8c, 0x91, 0x91, 0x8a, 0x89, 0x90,
			0x90, 0x88, 0x83, 0x81, 0x85, 0x8c, 0x89, 0x7f, 0x78, 0x79, 0x82,
			0x8a, 0x88, 0x84, 0x83, 0x82, 0x81, 0x7d, 0x76, 0x70, 0x70, 0x76,
			0x7d, 0x84, 0x86, 0x88, 0x88, 0x85, 0x7e, 0x78, 0x79, 0x80, 0x87,
			0x88, 0x86, 0x84, 0x86, 0x87, 0x87, 0x85, 0x83, 0x80, 0x80, 0x83,
			0x80, 0x7d, 0x7d, 0x7e, 0x7c, 0x78, 0x76, 0x78, 0x79, 0x78, 0x76,
			0x75, 0x74, 0x74, 0x75, 0x74, 0x72, 0x74, 0x74, 0x71, 0x71, 0x72,
			0x72, 0x72, 0x72, 0x6e, 0x70, 0x73, 0x72, 0x70, 0x6e, 0x6e, 0x73,
			0x72, 0x6d, 0x6e, 0x81, 0xaa, 0xb5, 0x9e, 0x8b, 0x86, 0x8b, 0x90,
			0x85, 0x7c, 0x87, 0x92, 0x98, 0x94, 0x86, 0x82, 0x8a, 0x8a, 0x83,
			0x7e, 0x7b, 0x7f, 0x84, 0x84, 0x81, 0x81, 0x84, 0x86, 0x81, 0x7b,
			0x7e, 0x80, 0x7e, 0x7a, 0x77, 0x78, 0x7a, 0x7e, 0x81, 0x83, 0x86,
			0x87, 0x86, 0x82, 0x85, 0x88, 0x88, 0x88, 0x86, 0x83, 0x83, 0x82,
			0x82, 0x84, 0x81, 0x80, 0x81, 0x7b, 0x78, 0x78, 0x77, 0x78, 0x79,
			0x77, 0x76, 0x77, 0x73, 0x72, 0x72, 0x71, 0x75, 0x77, 0x73, 0x72,
			0x73, 0x74, 0x73, 0x71, 0x73, 0x73, 0x71, 0x74, 0x77, 0x75, 0x75,
			0x75, 0x74, 0x75, 0x76, 0x74, 0x75, 0x77, 0x77, 0x77, 0x77, 0x7b,
			0x8f, 0xa1, 0x9f, 0x98, 0x97, 0x96, 0x93, 0x8b, 0x84, 0x88, 0x91,
			0x92, 0x8c, 0x8a, 0x8a, 0x8d, 0x8b, 0x84, 0x82, 0x84, 0x82, 0x7d,
			0x7d, 0x7f, 0x82, 0x85, 0x81, 0x7f, 0x80, 0x81, 0x80, 0x7e, 0x7b,
			0x7b, 0x7a, 0x74, 0x74, 0x7a, 0x80, 0x81, 0x81, 0x87, 0x89, 0x8a,
			0x87, 0x86, 0x86, 0x85, 0x82, 0x7e, 0x80, 0x81, 0x7f, 0x82, 0x84,
			0x81, 0x7d, 0x7b, 0x79, 0x79, 0x7a, 0x79, 0x78, 0x78, 0x79, 0x79,
			0x77, 0x75, 0x75, 0x75, 0x74, 0x72, 0x72, 0x75, 0x74, 0x70, 0x70,
			0x74, 0x75, 0x73, 0x72, 0x73, 0x74, 0x74, 0x75, 0x73, 0x73, 0x74,
			0x74, 0x73, 0x74, 0x75, 0x76, 0x74, 0x6f, 0x74, 0x75, 0x7d, 0x8b,
			0x84, 0x82, 0x8c, 0x94, 0x96, 0x8d, 0x91, 0x9a, 0x98, 0x90, 0x8d,
			0x90, 0x91, 0x8e, 0x89, 0x8b, 0x8e, 0x89, 0x86, 0x88, 0x88, 0x85,
			0x81, 0x81, 0x84, 0x83, 0x7f, 0x7d, 0x81, 0x84, 0x7f, 0x7c, 0x80,
			0x81, 0x7c, 0x79, 0x7b, 0x7a, 0x78, 0x7a, 0x7c, 0x7c, 0x7d, 0x81,
			0x85, 0x83, 0x84, 0x87, 0x85, 0x83, 0x84, 0x86, 0x87, 0x84, 0x84,
			0x89, 0x85, 0x7f, 0x81, 0x81, 0x7f, 0x7c, 0x7b, 0x7e, 0x7f, 0x79,
			0x78, 0x7c, 0x7b, 0x77, 0x76, 0x78, 0x76, 0x72, 0x73, 0x73, 0x71,
			0x71, 0x72, 0x72, 0x71, 0x74, 0x72, 0x6f, 0x73, 0x75, 0x72, 0x74,
			0x76, 0x74, 0x73, 0x73, 0x73, 0x72, 0x74, 0x76, 0x74, 0x73, 0x71,
			0x70, 0x70, 0x6f, 0x72, 0x82, 0x84, 0x7b, 0x80, 0x85, 0x80, 0x8e,
			0x99, 0x8e, 0x96, 0xa5, 0x9d, 0x96, 0x96, 0x96, 0x96, 0x94, 0x90,
			0x91, 0x91, 0x8a, 0x86, 0x89, 0x88, 0x81, 0x7e, 0x80, 0x82, 0x82,
			0x7f, 0x82, 0x87, 0x84, 0x7e, 0x7f, 0x7f, 0x7c, 0x7a, 0x78, 0x79,
			0x7a, 0x78, 0x77, 0x7a, 0x7c, 0x7b, 0x7d, 0x82, 0x85, 0x84, 0x86,
			0x89, 0x8a, 0x88, 0x87, 0x87, 0x86, 0x84, 0x81, 0x80, 0x80, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7b, 0x79, 0x78, 0x77, 0x76, 0x75, 0x74, 0x75,
			0x73, 0x72, 0x73, 0x73, 0x71, 0x70, 0x72, 0x73, 0x73, 0x73, 0x73,
			0x75, 0x74, 0x74, 0x76, 0x74, 0x74, 0x74, 0x75, 0x76, 0x76, 0x78,
			0x78, 0x77, 0x79, 0x79, 0x78, 0x78, 0x79, 0x78, 0x78, 0x77, 0x77,
			0x75, 0x7a, 0x81, 0x7f, 0x7d, 0x81, 0x84, 0x80, 0x7e, 0x7d, 0x83,
			0x8b, 0x89, 0x8a, 0x91, 0x95, 0x94, 0x97, 0x99, 0x9b, 0x9e, 0x9e,
			0x9c, 0x9b, 0x9b, 0x98, 0x94, 0x92, 0x8f, 0x8b, 0x88, 0x84, 0x81,
			0x80, 0x7f, 0x7e, 0x7c, 0x7c, 0x7c, 0x7c, 0x7a, 0x78, 0x79, 0x7a,
			0x79, 0x78, 0x79, 0x7b, 0x7c, 0x7b, 0x7c, 0x7d, 0x7e, 0x80, 0x82,
			0x83, 0x84, 0x85, 0x86, 0x86, 0x86, 0x86, 0x84, 0x84, 0x83, 0x80,
			0x7f, 0x7e, 0x7d, 0x7b, 0x7a, 0x79, 0x78, 0x77, 0x76, 0x75, 0x75,
			0x74, 0x73, 0x73, 0x73, 0x72, 0x72, 0x72, 0x72, 0x72, 0x73, 0x72,
			0x71, 0x73, 0x74, 0x72, 0x72, 0x73, 0x75, 0x76, 0x76, 0x77, 0x79,
			0x7a, 0x7a, 0x7a, 0x7d, 0x7c, 0x7b, 0x7d, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7b, 0x7a,
			0x79, 0x79, 0x7f, 0x82, 0x80, 0x84, 0x8d, 0x8e, 0x8d, 0x92, 0x96,
			0x99, 0x9c, 0x9e, 0x9c, 0x9c, 0x9f, 0x9e, 0x9b, 0x98, 0x95, 0x95,
			0x91, 0x8c, 0x89, 0x8a, 0x89, 0x84, 0x81, 0x81, 0x7f, 0x7d, 0x7c,
			0x7a, 0x7a, 0x7a, 0x78, 0x77, 0x78, 0x77, 0x77, 0x79, 0x79, 0x79,
			0x7b, 0x7d, 0x7d, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x7f,
			0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c, 0x7b,
			0x7a, 0x7a, 0x79, 0x78, 0x77, 0x76, 0x75, 0x74, 0x74, 0x73, 0x73,
			0x72, 0x71, 0x72, 0x72, 0x70, 0x71, 0x72, 0x73, 0x72, 0x73, 0x74,
			0x74, 0x75, 0x75, 0x76, 0x77, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7f,
			0x80, 0x7f, 0x81, 0x82, 0x82, 0x81, 0x82, 0x81, 0x80, 0x81, 0x81,
			0x81, 0x82, 0x81, 0x80, 0x80, 0x7f, 0x7d, 0x7e, 0x80, 0x81, 0x82,
			0x84, 0x86, 0x89, 0x8b, 0x8b, 0x8d, 0x90, 0x91, 0x93, 0x93, 0x93,
			0x94, 0x94, 0x92, 0x90, 0x8f, 0x8e, 0x8d, 0x8c, 0x8a, 0x89, 0x89,
			0x88, 0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7f,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7b, 0x7b,
			0x7a, 0x7a, 0x79, 0x78, 0x77, 0x77, 0x75, 0x75, 0x74, 0x73, 0x73,
			0x73, 0x73, 0x73, 0x73, 0x73, 0x74, 0x75, 0x75, 0x76, 0x77, 0x78,
			0x79, 0x7a, 0x7a, 0x7b, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x83, 0x85,
			0x86, 0x87, 0x87, 0x89, 0x8a, 0x8b, 0x8b, 0x8d, 0x8d, 0x8d, 0x8e,
			0x8d, 0x8d, 0x8c, 0x8c, 0x8b, 0x8a, 0x89, 0x88, 0x87, 0x86, 0x85,
			0x85, 0x83, 0x82, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d,
			0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a,
			0x79, 0x78, 0x78, 0x78, 0x77, 0x77, 0x76, 0x76, 0x76, 0x76, 0x76,
			0x76, 0x77, 0x77, 0x78, 0x78, 0x79, 0x7a, 0x7b, 0x7b, 0x7c, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
		},
	},
	"ru": [][]byte{
		{ // 0
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x80,
			0x82, 0x81, 0x82, 0x82, 0x83, 0x82, 0x83, 0x83, 0x82, 0x83, 0x81,
			0x82, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d,
			0x7c, 0x7b, 0x7b, 0x7a, 0x7a, 0x79, 0x7b, 0x7b, 0x7d, 0x7e, 0x7f,
			0x81, 0x82, 0x84, 0x85, 0x85, 0x87, 0x87, 0x86, 0x87, 0x86, 0x84,
			0x84, 0x83, 0x81, 0x81, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c,
			0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7d, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7d, 0x7d, 0x7b, 0x7b, 0x7a, 0x78, 0x79, 0x79, 0x79,
			0x7a, 0x7b, 0x7d, 0x7f, 0x81, 0x84, 0x85, 0x86, 0x87, 0x87, 0x89,
			0x89, 0x88, 0x88, 0x85, 0x85, 0x83, 0x82, 0x81, 0x80, 0x7f, 0x7e,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7d,
			0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7c, 0x7c, 0x7b,
			0x7a, 0x79, 0x78, 0x79, 0x79, 0x79, 0x7b, 0x7b, 0x7e, 0x7f, 0x83,
			0x84, 0x86, 0x86, 0x88, 0x88, 0x89, 0x89, 0x88, 0x87, 0x86, 0x84,
			0x82, 0x82, 0x80, 0x7f, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x7c,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x80,
			0x81, 0x80, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7b, 0x7a, 0x78, 0x79, 0x77, 0x78, 0x78,
			0x7a, 0x79, 0x7c, 0x7d, 0x81, 0x82, 0x8a, 0x8a, 0x8c, 0x8c, 0x8e,
			0x8d, 0x8b, 0x8a, 0x86, 0x85, 0x81, 0x81, 0x7f, 0x7d, 0x7b, 0x79,
			0x79, 0x78, 0x7a, 0x79, 0x7b, 0x7a, 0x7c, 0x7c, 0x7e, 0x7e, 0x7f,
			0x80, 0x7f, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7c, 0x7d, 0x7c, 0x7d, 0x7c, 0x7d, 0x7a,
			0x78, 0x76, 0x77, 0x76, 0x74, 0x76, 0x77, 0x77, 0x78, 0x7d, 0x81,
			0x84, 0x87, 0x89, 0x8b, 0x8a, 0x8d, 0x8f, 0x8f, 0x8d, 0x8b, 0x88,
			0x86, 0x82, 0x81, 0x80, 0x7d, 0x7b, 0x79, 0x7a, 0x78, 0x78, 0x7a,
			0x79, 0x7a, 0x79, 0x7c, 0x7c, 0x7d, 0x7f, 0x7f, 0x80, 0x80, 0x82,
			0x81, 0x83, 0x83, 0x82, 0x82, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7d,
			0x7d, 0x7c, 0x7d, 0x7d, 0x7c, 0x7d, 0x7b, 0x78, 0x75, 0x77, 0x75,
			0x74, 0x74, 0x77, 0x77, 0x76, 0x7a, 0x7e, 0x82, 0x84, 0x89, 0x8a,
			0x8b, 0x8c, 0x8f, 0x8f, 0x8f, 0x8d, 0x8a, 0x88, 0x84, 0x83, 0x80,
			0x7f, 0x7c, 0x79, 0x79, 0x77, 0x78, 0x79, 0x79, 0x79, 0x78, 0x7a,
			0x7b, 0x7d, 0x7d, 0x80, 0x81, 0x80, 0x82, 0x82, 0x83, 0x84, 0x84,
			0x83, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c,
			0x7d, 0x7c, 0x7c, 0x7a, 0x76, 0x75, 0x76, 0x75, 0x72, 0x75, 0x76,
			0x76, 0x76, 0x7c, 0x80, 0x83, 0x85, 0x8a, 0x8a, 0x8c, 0x8e, 0x90,
			0x90, 0x8e, 0x8d, 0x89, 0x87, 0x83, 0x82, 0x80, 0x7e, 0x7b, 0x7a,
			0x78, 0x78, 0x78, 0x78, 0x7a, 0x78, 0x7a, 0x7a, 0x7b, 0x7d, 0x7e,
			0x81, 0x80, 0x81, 0x81, 0x83, 0x83, 0x85, 0x84, 0x84, 0x82, 0x82,
			0x82, 0x80, 0x80, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d, 0x7c, 0x7d, 0x7a,
			0x76, 0x73, 0x75, 0x74, 0x71, 0x74, 0x76, 0x74, 0x75, 0x7a, 0x7f,
			0x81, 0x86, 0x89, 0x8b, 0x8c, 0x8e, 0x91, 0x90, 0x90, 0x8e, 0x8c,
			0x89, 0x84, 0x84, 0x81, 0x7f, 0x7d, 0x7a, 0x79, 0x76, 0x77, 0x78,
			0x79, 0x78, 0x79, 0x7a, 0x7a, 0x7c, 0x7d, 0x80, 0x80, 0x80, 0x82,
			0x82, 0x84, 0x84, 0x85, 0x83, 0x83, 0x82, 0x83, 0x82, 0x80, 0x80,
			0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7a, 0x76, 0x72, 0x74, 0x72, 0x6f,
			0x72, 0x74, 0x73, 0x72, 0x79, 0x7e, 0x80, 0x85, 0x89, 0x8c, 0x8b,
			0x8e, 0x92, 0x91, 0x92, 0x91, 0x8e, 0x8a, 0x87, 0x84, 0x84, 0x81,
			0x7c, 0x7c, 0x79, 0x75, 0x76, 0x78, 0x77, 0x77, 0x77, 0x79, 0x78,
			0x7a, 0x7c, 0x7f, 0x7e, 0x80, 0x81, 0x83, 0x83, 0x86, 0x85, 0x86,
			0x84, 0x85, 0x83, 0x83, 0x81, 0x82, 0x81, 0x7e, 0x7e, 0x7c, 0x7b,
			0x76, 0x73, 0x74, 0x72, 0x6d, 0x6e, 0x72, 0x70, 0x70, 0x74, 0x7b,
			0x7e, 0x83, 0x89, 0x8b, 0x8c, 0x8e, 0x93, 0x92, 0x93, 0x93, 0x92,
			0x8d, 0x89, 0x86, 0x85, 0x80, 0x7e, 0x7d, 0x79, 0x76, 0x75, 0x76,
			0x77, 0x74, 0x77, 0x78, 0x76, 0x78, 0x7a, 0x7e, 0x7e, 0x7f, 0x83,
			0x82, 0x83, 0x84, 0x87, 0x86, 0x86, 0x85, 0x85, 0x83, 0x83, 0x82,
			0x82, 0x7f, 0x7e, 0x7b, 0x75, 0x72, 0x72, 0x70, 0x6a, 0x6d, 0x6e,
			0x6c, 0x6d, 0x74, 0x78, 0x7c, 0x82, 0x87, 0x8b, 0x8b, 0x91, 0x94,
			0x94, 0x94, 0x95, 0x92, 0x8f, 0x8a, 0x89, 0x86, 0x83, 0x7f, 0x7d,
			0x7a, 0x75, 0x74, 0x75, 0x75, 0x73, 0x76, 0x77, 0x74, 0x76, 0x79,
			0x7d, 0x7d, 0x81, 0x83, 0x83, 0x85, 0x87, 0x88, 0x88, 0x87, 0x88,
			0x86, 0x86, 0x85, 0x82, 0x7f, 0x7a, 0x75, 0x6d, 0x6c, 0x6e, 0x6d,
			0x6c, 0x6e, 0x70, 0x69, 0x69, 0x71, 0x7a, 0x80, 0x8c, 0x92, 0x8e,
			0x8e, 0x92, 0x99, 0x9a, 0x9c, 0x9a, 0x90, 0x85, 0x7e, 0x7e, 0x7c,
			0x7a, 0x78, 0x71, 0x6a, 0x6a, 0x72, 0x79, 0x7d, 0x7f, 0x7e, 0x7d,
			0x80, 0x88, 0x8e, 0x8c, 0x8b, 0x88, 0x85, 0x84, 0x88, 0x86, 0x80,
			0x7c, 0x7b, 0x7d, 0x7e, 0x80, 0x7d, 0x7a, 0x75, 0x5c, 0x42, 0x4b,
			0x5b, 0x66, 0x78, 0x81, 0x85, 0x84, 0x92, 0xac, 0xb0, 0xa5, 0x9f,
			0x8b, 0x77, 0x78, 0x7e, 0x7e, 0x75, 0x71, 0x78, 0x79, 0x7f, 0x8f,
			0x8e, 0x86, 0x81, 0x80, 0x7e, 0x7b, 0x7f, 0x7d, 0x78, 0x79, 0x81,
			0x86, 0x88, 0x88, 0x86, 0x7f, 0x7f, 0x80, 0x81, 0x7e, 0x7e, 0x7d,
			0x7f, 0x81, 0x83, 0x86, 0x84, 0x85, 0x88, 0x86, 0x84, 0x7e, 0x76,
			0x57, 0x34, 0x3c, 0x4f, 0x5c, 0x78, 0x88, 0x88, 0x8a, 0x96, 0xaf,
			0xb4, 0xac, 0xa1, 0x86, 0x6e, 0x6e, 0x78, 0x7a, 0x7c, 0x7a, 0x7b,
			0x7d, 0x82, 0x91, 0x8f, 0x86, 0x7e, 0x74, 0x6f, 0x6f, 0x79, 0x7e,
			0x7d, 0x83, 0x88, 0x8a, 0x8e, 0x8d, 0x89, 0x7f, 0x7b, 0x7c, 0x7e,
			0x7f, 0x82, 0x81, 0x81, 0x81, 0x85, 0x89, 0x8a, 0x8b, 0x85, 0x7e,
			0x77, 0x70, 0x3b, 0x50, 0x66, 0x8f, 0x97, 0x97, 0x8f, 0x8b, 0xad,
			0xa9, 0x9d, 0x96, 0x71, 0x5c, 0x5c, 0x6b, 0x88, 0x89, 0x8b, 0x93,
			0x85, 0x87, 0x92, 0x91, 0x89, 0x75, 0x68, 0x63, 0x62, 0x6e, 0x86,
			0x88, 0x84, 0x86, 0x86, 0x8c, 0x8b, 0x8d, 0x87, 0x79, 0x77, 0x7d,
			0x81, 0x85, 0x85, 0x89, 0x87, 0x88, 0x8c, 0x8e, 0x89, 0x84, 0x7f,
			0x7c, 0x77, 0x58, 0x2b, 0x3a, 0x57, 0x6a, 0x8f, 0x95, 0x98, 0x92,
			0x8a, 0xab, 0xaf, 0x95, 0x89, 0x69, 0x5d, 0x61, 0x71, 0x8e, 0x8a,
			0x82, 0x8d, 0x8d, 0x92, 0x97, 0x91, 0x80, 0x6a, 0x5f, 0x6b, 0x71,
			0x73, 0x82, 0x84, 0x87, 0x87, 0x8b, 0x92, 0x84, 0x78, 0x79, 0x76,
			0x7e, 0x7f, 0x81, 0x80, 0x7b, 0x87, 0x90, 0x8f, 0x91, 0x8c, 0x85,
			0x82, 0x82, 0x85, 0x82, 0x7b, 0x79, 0x6a, 0x38, 0x34, 0x64, 0x74,
			0x82, 0x8a, 0x83, 0x92, 0x89, 0xa0, 0xbb, 0x92, 0x7a, 0x6d, 0x69,
			0x7a, 0x77, 0x80, 0x84, 0x70, 0x81, 0x9c, 0xa2, 0x9a, 0x83, 0x77,
			0x78, 0x6e, 0x76, 0x7e, 0x6b, 0x69, 0x76, 0x8c, 0x99, 0x8f, 0x8a,
			0x7f, 0x6f, 0x7d, 0x7e, 0x76, 0x71, 0x71, 0x84, 0x88, 0x8a, 0x8c,
			0x81, 0x7c, 0x86, 0x8d, 0x92, 0x88, 0x81, 0x7f, 0x80, 0x89, 0x8c,
			0x85, 0x7f, 0x76, 0x5d, 0x30, 0x47, 0x71, 0x6d, 0x75, 0x72, 0x82,
			0x9d, 0x98, 0xb3, 0xab, 0x7d, 0x7b, 0x7c, 0x84, 0x7f, 0x62, 0x6d,
			0x77, 0x7a, 0x9b, 0x9e, 0x92, 0x85, 0x80, 0x94, 0x90, 0x77, 0x6d,
			0x65, 0x65, 0x77, 0x82, 0x83, 0x7c, 0x79, 0x8d, 0x98, 0x8a, 0x7b,
			0x70, 0x71, 0x78, 0x79, 0x79, 0x71, 0x76, 0x8a, 0x8f, 0x8d, 0x8a,
			0x8a, 0x8f, 0x8f, 0x8d, 0x8d, 0x82, 0x81, 0x7f, 0x7e, 0x7d, 0x7c,
			0x7d, 0x7f, 0x78, 0x76, 0x56, 0x2d, 0x63, 0x7d, 0x66, 0x6e, 0x69,
			0x88, 0xa5, 0x99, 0xb5, 0x9c, 0x7e, 0x9f, 0x98, 0x8a, 0x72, 0x59,
			0x74, 0x74, 0x72, 0x83, 0x76, 0x79, 0x93, 0x9e, 0x9e, 0x85, 0x7d,
			0x88, 0x83, 0x74, 0x73, 0x69, 0x61, 0x72, 0x7c, 0x7f, 0x7d, 0x7d,
			0x91, 0x94, 0x8a, 0x88, 0x81, 0x7e, 0x81, 0x78, 0x72, 0x70, 0x75,
			0x7e, 0x79, 0x7b, 0x85, 0x8b, 0x8c, 0x8d, 0x89, 0x89, 0x8a, 0x8b,
			0x85, 0x83, 0x81, 0x80, 0x7d, 0x7d, 0x7f, 0x7a, 0x7a, 0x62, 0x41,
			0x6d, 0x80, 0x4d, 0x63, 0x79, 0x70, 0x8a, 0x9e, 0x8f, 0x8a, 0x9b,
			0xa9, 0xa2, 0x8c, 0x86, 0x88, 0x81, 0x7a, 0x7e, 0x6c, 0x62, 0x78,
			0x80, 0x71, 0x7a, 0x86, 0x86, 0x88, 0x8e, 0x89, 0x88, 0x8e, 0x8d,
			0x81, 0x79, 0x79, 0x81, 0x7a, 0x74, 0x74, 0x71, 0x73, 0x7a, 0x76,
			0x70, 0x77, 0x81, 0x81, 0x84, 0x83, 0x85, 0x8d, 0x8d, 0x89, 0x89,
			0x87, 0x87, 0x83, 0x7c, 0x7c, 0x82, 0x83, 0x82, 0x82, 0x82, 0x86,
			0x89, 0x84, 0x86, 0x85, 0x84, 0x7d, 0x7b, 0x76, 0x50, 0x5f, 0x7d,
			0x56, 0x55, 0x6f, 0x66, 0x6e, 0x89, 0x88, 0x76, 0x9e, 0xb0, 0x8f,
			0x9d, 0xa5, 0x94, 0x99, 0x97, 0x86, 0x76, 0x82, 0x83, 0x69, 0x6b,
			0x72, 0x6e, 0x73, 0x77, 0x70, 0x6f, 0x81, 0x8f, 0x7f, 0x85, 0x91,
			0x8c, 0x91, 0x8f, 0x81, 0x7f, 0x86, 0x7f, 0x71, 0x75, 0x77, 0x70,
			0x74, 0x72, 0x6a, 0x73, 0x7f, 0x7b, 0x7a, 0x87, 0x8a, 0x85, 0x8d,
			0x8e, 0x8d, 0x95, 0x8e, 0x83, 0x86, 0x86, 0x7f, 0x7d, 0x7c, 0x76,
			0x7b, 0x7c, 0x78, 0x7f, 0x84, 0x81, 0x83, 0x83, 0x82, 0x81, 0x7e,
			0x62, 0x6b, 0x7e, 0x61, 0x5e, 0x69, 0x63, 0x70, 0x7d, 0x79, 0x75,
			0x91, 0x9d, 0x89, 0x9b, 0xa1, 0x98, 0xa2, 0x98, 0x8a, 0x8b, 0x91,
			0x88, 0x74, 0x75, 0x75, 0x6b, 0x73, 0x6b, 0x67, 0x75, 0x78, 0x76,
			0x77, 0x81, 0x87, 0x87, 0x8e, 0x86, 0x87, 0x91, 0x8a, 0x80, 0x83,
			0x83, 0x82, 0x7b, 0x7a, 0x76, 0x77, 0x75, 0x72, 0x71, 0x74, 0x76,
			0x77, 0x78, 0x80, 0x83, 0x87, 0x89, 0x8b, 0x8d, 0x8f, 0x8b, 0x8a,
			0x89, 0x85, 0x7e, 0x7e, 0x7d, 0x7d, 0x7b, 0x7a, 0x7f, 0x7f, 0x7d,
			0x80, 0x82, 0x81, 0x82, 0x7d, 0x7d, 0x7c, 0x69, 0x71, 0x7b, 0x63,
			0x69, 0x6b, 0x68, 0x73, 0x75, 0x79, 0x75, 0x8d, 0x93, 0x84, 0x98,
			0x9b, 0x94, 0xa1, 0x94, 0x91, 0x97, 0x8f, 0x88, 0x7f, 0x85, 0x7b,
			0x73, 0x76, 0x6a, 0x6d, 0x74, 0x69, 0x6d, 0x74, 0x7b, 0x7c, 0x7e,
			0x84, 0x84, 0x89, 0x8a, 0x80, 0x88, 0x86, 0x84, 0x82, 0x82, 0x83,
			0x82, 0x7e, 0x7c, 0x7b, 0x7a, 0x75, 0x73, 0x75, 0x76, 0x78, 0x76,
			0x79, 0x82, 0x83, 0x84, 0x89, 0x8d, 0x8e, 0x8c, 0x8b, 0x88, 0x87,
			0x85, 0x80, 0x80, 0x7f, 0x7c, 0x7a, 0x7a, 0x79, 0x7c, 0x7e, 0x7c,
			0x7e, 0x7f, 0x81, 0x7c, 0x82, 0x73, 0x6c, 0x80, 0x70, 0x6c, 0x71,
			0x6e, 0x77, 0x71, 0x78, 0x72, 0x7f, 0x89, 0x7b, 0x8b, 0x91, 0x90,
			0x96, 0x95, 0x94, 0x97, 0x94, 0x8e, 0x87, 0x89, 0x81, 0x7b, 0x79,
			0x72, 0x73, 0x72, 0x6d, 0x71, 0x75, 0x77, 0x75, 0x7b, 0x7d, 0x7f,
			0x82, 0x83, 0x82, 0x86, 0x84, 0x83, 0x82, 0x83, 0x83, 0x82, 0x81,
			0x7e, 0x7f, 0x7a, 0x75, 0x7a, 0x78, 0x77, 0x76, 0x79, 0x7c, 0x7e,
			0x7e, 0x84, 0x88, 0x88, 0x88, 0x89, 0x89, 0x87, 0x86, 0x82, 0x81,
			0x80, 0x7e, 0x7b, 0x7d, 0x7b, 0x7b, 0x7b, 0x7c, 0x7b, 0x7d, 0x7d,
			0x7d, 0x80, 0x7f, 0x81, 0x82, 0x88, 0x73, 0x79, 0x83, 0x6f, 0x73,
			0x6a, 0x70, 0x72, 0x6c, 0x74, 0x6d, 0x84, 0x7e, 0x7e, 0x8d, 0x8e,
			0x94, 0x90, 0x93, 0x91, 0x92, 0x8f, 0x87, 0x8a, 0x88, 0x85, 0x82,
			0x81, 0x80, 0x7c, 0x79, 0x75, 0x77, 0x76, 0x71, 0x72, 0x74, 0x77,
			0x79, 0x7b, 0x7e, 0x81, 0x83, 0x80, 0x84, 0x84, 0x82, 0x82, 0x80,
			0x81, 0x7d, 0x7f, 0x7c, 0x7b, 0x7c, 0x7c, 0x7b, 0x7c, 0x7c, 0x7b,
			0x7d, 0x7e, 0x80, 0x82, 0x82, 0x84, 0x85, 0x85, 0x86, 0x83, 0x84,
			0x82, 0x84, 0x80, 0x80, 0x7e, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7b, 0x7d, 0x7d, 0x7e, 0x81, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e,
			0x71, 0x7d, 0x78, 0x74, 0x76, 0x73, 0x7d, 0x74, 0x7b, 0x78, 0x7e,
			0x85, 0x7e, 0x84, 0x86, 0x8c, 0x88, 0x8c, 0x8f, 0x8e, 0x8f, 0x89,
			0x8a, 0x87, 0x85, 0x81, 0x7e, 0x7e, 0x7b, 0x78, 0x77, 0x78, 0x79,
			0x77, 0x78, 0x79, 0x7d, 0x7a, 0x7d, 0x7d, 0x7f, 0x7f, 0x7f, 0x81,
			0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x81, 0x7d, 0x7d, 0x7c, 0x7d,
			0x79, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7e, 0x7d, 0x80, 0x80, 0x81,
			0x81, 0x84, 0x84, 0x82, 0x84, 0x81, 0x82, 0x83, 0x82, 0x83, 0x81,
			0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7b, 0x7e, 0x7d, 0x7e, 0x7d,
			0x7c, 0x7e, 0x7a, 0x7d, 0x7d, 0x7e, 0x7f, 0x7e, 0x80, 0x81, 0x82,
			0x83, 0x7f, 0x80, 0x80, 0x7d, 0x7e, 0x79, 0x7c, 0x79, 0x7a, 0x79,
			0x7c, 0x7e, 0x80, 0x82, 0x83, 0x84, 0x85, 0x85, 0x86, 0x85, 0x85,
			0x82, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f,
			0x80, 0x7d, 0x7e, 0x7d, 0x81, 0x80, 0x80, 0x80, 0x7e, 0x80, 0x7d,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7b, 0x7b, 0x7d, 0x7e, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x81, 0x83, 0x81, 0x82, 0x81, 0x80, 0x7f, 0x7f, 0x7f,
			0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x81, 0x80,
			0x81, 0x82, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7f,
			0x7f, 0x7d, 0x7d, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x80,
			0x7f, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7e, 0x80, 0x80, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7e, 0x7e, 0x7c, 0x7f, 0x7f, 0x81, 0x81, 0x80, 0x7f,
			0x82, 0x82, 0x80, 0x7d, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7d, 0x80, 0x7d, 0x7f, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x82,
			0x81, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x7e, 0x7f,
			0x7f, 0x81, 0x7f, 0x7f, 0x7c, 0x7e, 0x7d, 0x7b, 0x7e, 0x7c, 0x7e,
			0x7e, 0x7f, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7d, 0x7e, 0x7d,
			0x7e, 0x7f, 0x7e, 0x80, 0x81, 0x81, 0x81, 0x83, 0x80, 0x81, 0x80,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x81, 0x7f,
			0x81, 0x80, 0x81, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7d, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x80,
			0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7d, 0x7e,
			0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f,
		},
		{ // 1
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x7f, 0x7e,
			0x7f, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x79, 0x50,
			0x36, 0x71, 0x90, 0x8d, 0xa6, 0x8b, 0x7b, 0x99, 0x8f, 0x7c, 0x6b,
			0x65, 0x78, 0x88, 0x9b, 0x97, 0x85, 0x8c, 0x8f, 0x86, 0x7f, 0x6f,
			0x66, 0x74, 0x84, 0x8a, 0x8b, 0x86, 0x83, 0x83, 0x81, 0x7e, 0x72,
			0x6f, 0x79, 0x7d, 0x84, 0x87, 0x7f, 0x80, 0x81, 0x7e, 0x7b, 0x77,
			0x7b, 0x81, 0x85, 0x85, 0x7e, 0x7c, 0x7d, 0x7f, 0x83, 0x84, 0x86,
			0x87, 0x85, 0x82, 0x7c, 0x7a, 0x7c, 0x7e, 0x83, 0x87, 0x88, 0x87,
			0x82, 0x7e, 0x7d, 0x7d, 0x7f, 0x80, 0x7f, 0x7f, 0x75, 0x4d, 0x41,
			0x7c, 0x8a, 0x85, 0xa3, 0x81, 0x7e, 0xa2, 0x89, 0x78, 0x6f, 0x6a,
			0x7a, 0x87, 0x95, 0x8b, 0x83, 0x94, 0x90, 0x86, 0x81, 0x6d, 0x69,
			0x7c, 0x81, 0x82, 0x88, 0x84, 0x88, 0x89, 0x84, 0x7e, 0x73, 0x74,
			0x78, 0x78, 0x81, 0x81, 0x81, 0x85, 0x80, 0x7e, 0x7d, 0x7c, 0x7d,
			0x80, 0x81, 0x80, 0x81, 0x80, 0x7e, 0x80, 0x82, 0x84, 0x87, 0x85,
			0x84, 0x81, 0x7e, 0x7c, 0x7d, 0x80, 0x84, 0x86, 0x85, 0x84, 0x83,
			0x81, 0x80, 0x81, 0x7f, 0x7c, 0x5e, 0x2b, 0x56, 0x93, 0x7b, 0x9f,
			0x9c, 0x6f, 0xa5, 0xa1, 0x78, 0x72, 0x61, 0x6e, 0x7f, 0x90, 0x90,
			0x7e, 0x94, 0x9e, 0x8d, 0x89, 0x76, 0x61, 0x74, 0x7f, 0x77, 0x82,
			0x83, 0x89, 0x93, 0x8a, 0x85, 0x76, 0x73, 0x77, 0x71, 0x79, 0x7d,
			0x7d, 0x87, 0x88, 0x82, 0x7f, 0x7f, 0x79, 0x78, 0x7e, 0x7f, 0x83,
			0x85, 0x80, 0x7f, 0x81, 0x82, 0x84, 0x87, 0x87, 0x86, 0x85, 0x7f,
			0x7b, 0x7c, 0x7d, 0x82, 0x85, 0x86, 0x88, 0x86, 0x84, 0x81, 0x7d,
			0x7b, 0x6c, 0x30, 0x3d, 0x8c, 0x78, 0x8d, 0xaa, 0x74, 0x9f, 0xb2,
			0x81, 0x73, 0x63, 0x6d, 0x76, 0x81, 0x8b, 0x7a, 0x92, 0xab, 0x95,
			0x8b, 0x82, 0x67, 0x72, 0x7b, 0x6a, 0x75, 0x7e, 0x8b, 0x96, 0x8d,
			0x8d, 0x80, 0x7f, 0x7e, 0x6a, 0x6c, 0x72, 0x77, 0x84, 0x84, 0x82,
			0x87, 0x88, 0x80, 0x7e, 0x7d, 0x7a, 0x7f, 0x7f, 0x7d, 0x80, 0x81,
			0x83, 0x86, 0x87, 0x85, 0x86, 0x87, 0x81, 0x80, 0x7d, 0x7b, 0x7f,
			0x81, 0x84, 0x88, 0x88, 0x86, 0x85, 0x7f, 0x79, 0x4c, 0x23, 0x6e,
			0x81, 0x67, 0x9d, 0x86, 0x8d, 0xc3, 0x9c, 0x7e, 0x6f, 0x75, 0x7a,
			0x69, 0x76, 0x70, 0x7d, 0xab, 0xa0, 0x8b, 0x97, 0x88, 0x82, 0x80,
			0x63, 0x62, 0x6d, 0x7d, 0x85, 0x7c, 0x8f, 0x96, 0x95, 0x93, 0x76,
			0x6f, 0x73, 0x71, 0x6f, 0x67, 0x71, 0x85, 0x8c, 0x8d, 0x8a, 0x8a,
			0x8a, 0x84, 0x78, 0x71, 0x78, 0x7e, 0x7e, 0x81, 0x87, 0x8b, 0x8e,
			0x89, 0x82, 0x83, 0x83, 0x7e, 0x7b, 0x7e, 0x80, 0x84, 0x87, 0x84,
			0x86, 0x87, 0x7b, 0x3a, 0x34, 0x88, 0x60, 0x61, 0x91, 0x6f, 0xaa,
			0xc0, 0x92, 0x8a, 0x88, 0x98, 0x75, 0x5f, 0x6c, 0x60, 0x82, 0x95,
			0x76, 0x90, 0xa9, 0x9b, 0x99, 0x81, 0x78, 0x7c, 0x72, 0x6d, 0x59,
			0x6e, 0x88, 0x85, 0x90, 0x89, 0x8d, 0x99, 0x89, 0x7a, 0x69, 0x69,
			0x70, 0x6b, 0x6e, 0x7b, 0x8d, 0x91, 0x8d, 0x8b, 0x89, 0x89, 0x7f,
			0x76, 0x79, 0x80, 0x82, 0x7f, 0x83, 0x87, 0x88, 0x85, 0x82, 0x84,
			0x87, 0x85, 0x80, 0x84, 0x83, 0x83, 0x80, 0x81, 0x56, 0x28, 0x7b,
			0x6d, 0x3e, 0x83, 0x6b, 0x8b, 0xbc, 0x94, 0x98, 0xa6, 0xb3, 0x8f,
			0x6d, 0x7e, 0x66, 0x6c, 0x74, 0x52, 0x79, 0x9b, 0x89, 0x93, 0x93,
			0x9d, 0xa4, 0x8d, 0x7d, 0x70, 0x7b, 0x73, 0x5e, 0x6b, 0x6d, 0x7d,
			0x84, 0x74, 0x7f, 0x92, 0x8e, 0x83, 0x83, 0x84, 0x88, 0x84, 0x77,
			0x7d, 0x84, 0x7c, 0x76, 0x7c, 0x82, 0x82, 0x81, 0x82, 0x8b, 0x90,
			0x88, 0x83, 0x87, 0x87, 0x80, 0x7c, 0x7c, 0x81, 0x7f, 0x7b, 0x7d,
			0x8a, 0x71, 0x3d, 0x76, 0x76, 0x44, 0x78, 0x58, 0x6a, 0xa4, 0x77,
			0x88, 0xa5, 0xb0, 0xa8, 0x96, 0x9f, 0x8c, 0x96, 0x82, 0x56, 0x7a,
			0x75, 0x63, 0x73, 0x67, 0x7e, 0x92, 0x85, 0x85, 0x94, 0x9d, 0x8c,
			0x8c, 0x85, 0x7c, 0x87, 0x73, 0x69, 0x75, 0x6e, 0x69, 0x71, 0x73,
			0x7d, 0x87, 0x82, 0x89, 0x96, 0x90, 0x8d, 0x8f, 0x8b, 0x8a, 0x83,
			0x79, 0x7c, 0x7e, 0x75, 0x72, 0x78, 0x7e, 0x81, 0x7f, 0x82, 0x8b,
			0x8c, 0x8a, 0x84, 0x89, 0x80, 0x5d, 0x74, 0x75, 0x56, 0x6d, 0x5f,
			0x5e, 0x7b, 0x6e, 0x6f, 0x83, 0x8f, 0x8e, 0x93, 0x9a, 0x95, 0xa6,
			0x9e, 0x8e, 0x9a, 0x90, 0x8a, 0x86, 0x7c, 0x7c, 0x7e, 0x79, 0x72,
			0x79, 0x79, 0x74, 0x79, 0x77, 0x78, 0x7c, 0x77, 0x78, 0x80, 0x7f,
			0x7f, 0x82, 0x83, 0x86, 0x88, 0x85, 0x87, 0x8a, 0x87, 0x82, 0x81,
			0x80, 0x80, 0x7f, 0x79, 0x7a, 0x7e, 0x7b, 0x7b, 0x7b, 0x7b, 0x7e,
			0x7f, 0x7e, 0x7d, 0x7f, 0x81, 0x80, 0x80, 0x7e, 0x7f, 0x82, 0x7e,
			0x7d, 0x7d, 0x7c, 0x7d, 0x7a, 0x7a, 0x7c, 0x7c, 0x7c, 0x7b, 0x7c,
			0x7f, 0x81, 0x80, 0x7e, 0x82, 0x85, 0x83, 0x86, 0x85, 0x85, 0x89,
			0x88, 0x86, 0x87, 0x88, 0x88, 0x87, 0x86, 0x85, 0x85, 0x84, 0x81,
			0x7f, 0x7d, 0x7c, 0x7b, 0x79, 0x79, 0x7b, 0x7c, 0x7d, 0x7b, 0x7c,
			0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f,
			0x80, 0x81, 0x7f, 0x80, 0x82, 0x82, 0x81, 0x7e, 0x7d, 0x7d, 0x7a,
			0x77, 0x76, 0x78, 0x79, 0x78, 0x7b, 0x7e, 0x80, 0x83, 0x81, 0x82,
			0x84, 0x83, 0x83, 0x83, 0x84, 0x86, 0x87, 0x87, 0x89, 0x8a, 0x88,
			0x88, 0x88, 0x86, 0x86, 0x83, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7a, 0x7b, 0x7b, 0x7a, 0x7b, 0x7b, 0x7c, 0x7d,
			0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x83,
			0x83, 0x80, 0x7e, 0x7d, 0x7a, 0x78, 0x77, 0x77, 0x79, 0x79, 0x7b,
			0x7d, 0x7f, 0x81, 0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x81, 0x82,
			0x82, 0x84, 0x87, 0x88, 0x8a, 0x89, 0x87, 0x87, 0x86, 0x84, 0x83,
			0x81, 0x7f, 0x80, 0x7f, 0x7c, 0x7d, 0x7c, 0x7c, 0x7c, 0x7a, 0x7b,
			0x7c, 0x7b, 0x7c, 0x7c, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x80, 0x82, 0x81, 0x81, 0x7f,
			0x7d, 0x7e, 0x7b, 0x7a, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7e,
			0x7f, 0x7e, 0x7f, 0x81, 0x83, 0x85, 0x85, 0x86, 0x87, 0x89, 0x87,
			0x86, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7f, 0x81, 0x81, 0x81, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x79, 0x79,
			0x7c, 0x7c, 0x7c, 0x7e, 0x7f, 0x81, 0x81, 0x80, 0x81, 0x83, 0x82,
			0x81, 0x81, 0x81, 0x81, 0x82, 0x7f, 0x7e, 0x7e, 0x7c, 0x79, 0x78,
			0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7f, 0x81, 0x80, 0x80, 0x82, 0x83,
			0x83, 0x82, 0x81, 0x83, 0x85, 0x85, 0x85, 0x85, 0x84, 0x86, 0x85,
			0x83, 0x83, 0x83, 0x82, 0x81, 0x7f, 0x7f, 0x7e, 0x7c, 0x7d, 0x7c,
			0x7b, 0x7c, 0x7b, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x81,
			0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x80,
			0x81, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7c, 0x7c, 0x7a, 0x7a, 0x7b,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x82, 0x84,
			0x85, 0x85, 0x85, 0x86, 0x86, 0x85, 0x84, 0x82, 0x82, 0x82, 0x7f,
			0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7d,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x7e,
			0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7f, 0x7e, 0x7d, 0x7c, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x81,
			0x80, 0x81, 0x82, 0x83, 0x84, 0x83, 0x83, 0x84, 0x85, 0x84, 0x83,
			0x83, 0x83, 0x82, 0x81, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7d, 0x7c, 0x7c, 0x7e,
			0x7e, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x82, 0x82, 0x80, 0x7f, 0x7f, 0x7f, 0x7d, 0x7d, 0x7c, 0x7c,
			0x7c, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x82, 0x81,
			0x82, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x81, 0x82, 0x82,
			0x82, 0x82, 0x82, 0x82, 0x81, 0x82, 0x82, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7c, 0x7c, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e,
			0x80, 0x7d, 0x7e, 0x7f, 0x7d, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7d, 0x7d, 0x7f, 0x7d, 0x7c, 0x7e, 0x7c,
			0x7e, 0x7d, 0x7b, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x80, 0x81, 0x80,
			0x80, 0x82, 0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x81, 0x81, 0x81,
			0x82, 0x82, 0x82, 0x82, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d,
			0x80, 0x7e, 0x7e, 0x81, 0x7d, 0x7f, 0x80, 0x7d, 0x7f, 0x7f, 0x7d,
			0x80, 0x7f, 0x80, 0x82, 0x7e, 0x7f, 0x83, 0x7e, 0x7e, 0x80, 0x79,
			0x7e, 0x7b, 0x76, 0x7d, 0x79, 0x7b, 0x7f, 0x7c, 0x83, 0x82, 0x80,
			0x85, 0x83, 0x84, 0x83, 0x81, 0x83, 0x83, 0x82, 0x81, 0x83, 0x82,
			0x82, 0x83, 0x7f, 0x84, 0x81, 0x7f, 0x82, 0x7f, 0x81, 0x7e, 0x7e,
			0x7f, 0x80, 0x7c, 0x7f, 0x7e, 0x7d, 0x80, 0x7d, 0x81, 0x80, 0x7e,
			0x80, 0x81, 0x7c, 0x83, 0x7b, 0x7e, 0x80, 0x7c, 0x7f, 0x7d, 0x81,
			0x7e, 0x85, 0x80, 0x7b, 0x83, 0x80, 0x76, 0x7f, 0x78, 0x77, 0x80,
			0x70, 0x7d, 0x7f, 0x78, 0x84, 0x7d, 0x7f, 0x89, 0x7f, 0x81, 0x85,
			0x82, 0x85, 0x81, 0x82, 0x86, 0x86, 0x83, 0x82, 0x87, 0x83, 0x82,
			0x80, 0x7f, 0x82, 0x80, 0x7b, 0x7e, 0x81, 0x7d, 0x7c, 0x7c, 0x7f,
			0x7c, 0x7c, 0x7f, 0x7f, 0x81, 0x82, 0x7f, 0x83, 0x83, 0x7e, 0x83,
			0x7f, 0x81, 0x7f, 0x7f, 0x81, 0x81, 0x7f, 0x81, 0x84, 0x80, 0x86,
			0x73, 0x7c, 0x84, 0x6f, 0x7b, 0x77, 0x70, 0x82, 0x72, 0x70, 0x86,
			0x75, 0x7f, 0x7e, 0x77, 0x89, 0x81, 0x7e, 0x87, 0x87, 0x8b, 0x89,
			0x86, 0x8d, 0x8b, 0x88, 0x84, 0x85, 0x85, 0x82, 0x7f, 0x7a, 0x83,
			0x7d, 0x7b, 0x7e, 0x7a, 0x7d, 0x79, 0x77, 0x7b, 0x7b, 0x79, 0x7c,
			0x7f, 0x81, 0x81, 0x82, 0x83, 0x87, 0x86, 0x81, 0x87, 0x85, 0x81,
			0x84, 0x82, 0x7f, 0x85, 0x7f, 0x7e, 0x81, 0x71, 0x7e, 0x7b, 0x6c,
			0x7d, 0x70, 0x73, 0x7d, 0x68, 0x78, 0x7b, 0x70, 0x81, 0x75, 0x7d,
			0x8a, 0x7d, 0x89, 0x8b, 0x8c, 0x93, 0x8d, 0x8f, 0x92, 0x8f, 0x8a,
			0x86, 0x87, 0x83, 0x80, 0x7c, 0x7b, 0x7e, 0x78, 0x77, 0x78, 0x78,
			0x78, 0x76, 0x76, 0x7a, 0x79, 0x7b, 0x7f, 0x7f, 0x85, 0x82, 0x84,
			0x88, 0x84, 0x87, 0x88, 0x89, 0x87, 0x8a, 0x85, 0x86, 0x87, 0x7e,
			0x85, 0x73, 0x76, 0x81, 0x67, 0x70, 0x72, 0x62, 0x76, 0x68, 0x63,
			0x7e, 0x6b, 0x76, 0x7e, 0x76, 0x8d, 0x85, 0x85, 0x93, 0x90, 0x96,
			0x93, 0x92, 0x98, 0x94, 0x92, 0x8d, 0x8d, 0x8d, 0x82, 0x83, 0x7c,
			0x7b, 0x7a, 0x6e, 0x72, 0x72, 0x6d, 0x6e, 0x6d, 0x71, 0x75, 0x75,
			0x7a, 0x83, 0x84, 0x8b, 0x8e, 0x8e, 0x94, 0x8d, 0x8c, 0x8e, 0x8b,
			0x87, 0x85, 0x83, 0x80, 0x81, 0x70, 0x71, 0x7f, 0x66, 0x6c, 0x71,
			0x5e, 0x75, 0x67, 0x5e, 0x7e, 0x6c, 0x74, 0x80, 0x76, 0x90, 0x8a,
			0x85, 0x97, 0x95, 0x99, 0x98, 0x94, 0x9c, 0x99, 0x95, 0x8e, 0x91,
			0x92, 0x83, 0x82, 0x7b, 0x7a, 0x76, 0x67, 0x6e, 0x6e, 0x6a, 0x6a,
			0x6b, 0x73, 0x76, 0x76, 0x7b, 0x89, 0x89, 0x8b, 0x90, 0x93, 0x96,
			0x8f, 0x90, 0x8f, 0x8d, 0x87, 0x84, 0x83, 0x81, 0x76, 0x6b, 0x7e,
			0x6c, 0x63, 0x71, 0x5c, 0x6d, 0x6c, 0x56, 0x71, 0x70, 0x6d, 0x7c,
			0x76, 0x87, 0x92, 0x87, 0x95, 0x9a, 0x9f, 0x9e, 0x9a, 0xa2, 0x9e,
			0x9d, 0x94, 0x8f, 0x96, 0x87, 0x7e, 0x7d, 0x7a, 0x74, 0x69, 0x69,
			0x6b, 0x6b, 0x66, 0x69, 0x72, 0x74, 0x76, 0x7b, 0x87, 0x8a, 0x8c,
			0x90, 0x95, 0x97, 0x93, 0x92, 0x92, 0x91, 0x8a, 0x86, 0x84, 0x83,
			0x75, 0x68, 0x7c, 0x69, 0x5e, 0x6f, 0x56, 0x67, 0x6a, 0x53, 0x6f,
			0x71, 0x6b, 0x7c, 0x7a, 0x8a, 0x95, 0x8f, 0x99, 0xa1, 0xa8, 0xa2,
			0x9e, 0xa8, 0x9e, 0x9d, 0x96, 0x8a, 0x92, 0x83, 0x74, 0x79, 0x70,
			0x67, 0x66, 0x61, 0x63, 0x68, 0x64, 0x6b, 0x78, 0x78, 0x7e, 0x8a,
			0x90, 0x95, 0x98, 0x98, 0x9d, 0x9c, 0x95, 0x95, 0x94, 0x8b, 0x85,
			0x82, 0x7b, 0x7b, 0x66, 0x5f, 0x72, 0x55, 0x54, 0x64, 0x50, 0x63,
			0x61, 0x59, 0x75, 0x75, 0x7a, 0x85, 0x8f, 0x9e, 0x9b, 0xa2, 0xa9,
			0xa9, 0xb3, 0xa2, 0xa1, 0xab, 0x96, 0x91, 0x8a, 0x7f, 0x81, 0x70,
			0x65, 0x67, 0x67, 0x5b, 0x58, 0x64, 0x65, 0x67, 0x6e, 0x78, 0x84,
			0x88, 0x8b, 0x95, 0x9f, 0x9c, 0x9e, 0xa2, 0xa0, 0x9b, 0x92, 0x90,
			0x8c, 0x85, 0x7d, 0x7b, 0x78, 0x73, 0x70, 0x55, 0x60, 0x6f, 0x48,
			0x53, 0x63, 0x51, 0x62, 0x61, 0x62, 0x7c, 0x81, 0x83, 0x8b, 0xa2,
			0xa9, 0x9c, 0xae, 0xb1, 0xab, 0xb2, 0x9f, 0x9e, 0xa3, 0x8d, 0x83,
			0x7e, 0x7b, 0x72, 0x64, 0x65, 0x62, 0x63, 0x5d, 0x5a, 0x69, 0x6e,
			0x6c, 0x74, 0x83, 0x88, 0x8a, 0x91, 0x98, 0x9f, 0x9d, 0x9b, 0x9e,
			0x9e, 0x94, 0x8e, 0x8f, 0x89, 0x81, 0x7e, 0x7c, 0x79, 0x75, 0x74,
			0x6b, 0x56, 0x67, 0x68, 0x44, 0x5a, 0x62, 0x51, 0x5f, 0x63, 0x6c,
			0x7a, 0x84, 0x8b, 0x91, 0xab, 0xab, 0x9e, 0xb4, 0xb4, 0xa9, 0xad,
			0xa1, 0x9c, 0x95, 0x88, 0x7f, 0x76, 0x7a, 0x6e, 0x61, 0x6a, 0x65,
			0x60, 0x64, 0x63, 0x67, 0x70, 0x71, 0x72, 0x80, 0x88, 0x87, 0x8e,
			0x98, 0x9a, 0x99, 0x9d, 0x9c, 0x9b, 0x99, 0x90, 0x8d, 0x8b, 0x84,
			0x7d, 0x7f, 0x7c, 0x77, 0x75, 0x75, 0x6f, 0x58, 0x60, 0x68, 0x4c,
			0x52, 0x5f, 0x56, 0x5b, 0x63, 0x6e, 0x76, 0x84, 0x93, 0x91, 0xa5,
			0xb2, 0xa5, 0xad, 0xb4, 0xaf, 0xaa, 0xa0, 0x9c, 0x91, 0x88, 0x83,
			0x74, 0x75, 0x72, 0x65, 0x65, 0x66, 0x67, 0x62, 0x63, 0x6a, 0x6a,
			0x6d, 0x71, 0x77, 0x80, 0x86, 0x89, 0x8f, 0x97, 0x99, 0x9a, 0x9b,
			0x9d, 0x9a, 0x96, 0x93, 0x8d, 0x89, 0x83, 0x7e, 0x7c, 0x7a, 0x76,
			0x73, 0x73, 0x73, 0x72, 0x61, 0x58, 0x65, 0x5d, 0x50, 0x59, 0x5f,
			0x61, 0x61, 0x6b, 0x79, 0x7f, 0x8e, 0x97, 0x9d, 0xaa, 0xac, 0xab,
			0xab, 0xad, 0xaf, 0xa0, 0x97, 0x93, 0x89, 0x82, 0x78, 0x72, 0x71,
			0x6b, 0x67, 0x63, 0x64, 0x6a, 0x69, 0x68, 0x6a, 0x6f, 0x72, 0x74,
			0x7a, 0x82, 0x87, 0x8b, 0x8e, 0x92, 0x97, 0x97, 0x97, 0x95, 0x94,
			0x92, 0x8c, 0x88, 0x85, 0x82, 0x7c, 0x77, 0x76, 0x74, 0x73, 0x73,
			0x73, 0x74, 0x75, 0x74, 0x6b, 0x66, 0x6b, 0x6b, 0x65, 0x62, 0x67,
			0x6d, 0x6b, 0x71, 0x7c, 0x81, 0x89, 0x94, 0x99, 0x99, 0x9c, 0xa1,
			0x9d, 0x9a, 0x9c, 0x96, 0x8e, 0x8a, 0x87, 0x82, 0x7d, 0x7d, 0x79,
			0x74, 0x74, 0x73, 0x72, 0x74, 0x75, 0x75, 0x76, 0x76, 0x77, 0x78,
			0x78, 0x79, 0x7b, 0x7e, 0x7f, 0x81, 0x84, 0x86, 0x88, 0x89, 0x89,
			0x88, 0x87, 0x88, 0x85, 0x83, 0x82, 0x81, 0x7f, 0x7f, 0x7e, 0x7f,
			0x80, 0x82, 0x82, 0x82, 0x83, 0x82, 0x81, 0x7a, 0x6f, 0x6c, 0x6f,
			0x68, 0x60, 0x65, 0x68, 0x64, 0x69, 0x72, 0x74, 0x77, 0x83, 0x8a,
			0x88, 0x8e, 0x95, 0x96, 0x99, 0x9c, 0x9b, 0x96, 0x95, 0x94, 0x90,
			0x8d, 0x8a, 0x86, 0x85, 0x81, 0x7d, 0x7c, 0x79, 0x73, 0x71, 0x71,
			0x6d, 0x6a, 0x6c, 0x6d, 0x6c, 0x6f, 0x72, 0x74, 0x77, 0x7c, 0x80,
			0x82, 0x85, 0x88, 0x8b, 0x8d, 0x8e, 0x8f, 0x8f, 0x8e, 0x8e, 0x8d,
			0x8b, 0x89, 0x87, 0x85, 0x82, 0x80, 0x7f, 0x7c, 0x7a, 0x79, 0x78,
			0x78, 0x75, 0x6f, 0x69, 0x6c, 0x6d, 0x64, 0x65, 0x6b, 0x68, 0x69,
			0x73, 0x78, 0x79, 0x82, 0x8a, 0x88, 0x8d, 0x94, 0x95, 0x96, 0x99,
			0x99, 0x98, 0x96, 0x93, 0x90, 0x8f, 0x8b, 0x86, 0x85, 0x81, 0x7c,
			0x7b, 0x7a, 0x76, 0x73, 0x74, 0x72, 0x6f, 0x71, 0x71, 0x70, 0x70,
			0x73, 0x73, 0x74, 0x78, 0x7b, 0x7d, 0x7f, 0x82, 0x84, 0x86, 0x88,
			0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x88, 0x87,
			0x87, 0x85, 0x83, 0x82, 0x81, 0x80, 0x7e, 0x7b, 0x78, 0x76, 0x70,
			0x66, 0x67, 0x68, 0x5f, 0x60, 0x66, 0x64, 0x65, 0x6f, 0x76, 0x78,
			0x82, 0x8b, 0x8c, 0x91, 0x98, 0x9a, 0x9c, 0x9d, 0x9c, 0x9c, 0x9a,
			0x95, 0x92, 0x90, 0x8a, 0x86, 0x84, 0x7f, 0x79, 0x76, 0x74, 0x70,
			0x6d, 0x6c, 0x6b, 0x6b, 0x6c, 0x6c, 0x6e, 0x70, 0x74, 0x77, 0x7a,
			0x7e, 0x83, 0x86, 0x87, 0x89, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8b,
			0x8a, 0x89, 0x86, 0x85, 0x83, 0x80, 0x7f, 0x7d, 0x7b, 0x7b, 0x7b,
			0x79, 0x7a, 0x7b, 0x7a, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e,
			0x7c, 0x75, 0x75, 0x79, 0x72, 0x6f, 0x73, 0x73, 0x70, 0x75, 0x7a,
			0x7a, 0x7e, 0x84, 0x85, 0x87, 0x8b, 0x8d, 0x8f, 0x90, 0x8f, 0x90,
			0x90, 0x8c, 0x8b, 0x8c, 0x89, 0x85, 0x86, 0x84, 0x80, 0x7e, 0x7e,
			0x7c, 0x79, 0x78, 0x77, 0x75, 0x74, 0x75, 0x76, 0x74, 0x74, 0x78,
			0x78, 0x78, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x83, 0x84, 0x84,
			0x85, 0x85, 0x85, 0x87, 0x86, 0x86, 0x86, 0x86, 0x84, 0x84, 0x83,
			0x82, 0x81, 0x80, 0x7e, 0x7f, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7e, 0x7e, 0x7c, 0x7b, 0x7b, 0x77, 0x70, 0x71, 0x73, 0x6f, 0x6d,
			0x72, 0x73, 0x74, 0x79, 0x7e, 0x81, 0x86, 0x8a, 0x8b, 0x8e, 0x8f,
			0x91, 0x92, 0x91, 0x8f, 0x8f, 0x8d, 0x89, 0x88, 0x87, 0x82, 0x80,
			0x7f, 0x7d, 0x7b, 0x79, 0x78, 0x77, 0x76, 0x75, 0x75, 0x76, 0x76,
			0x77, 0x78, 0x79, 0x7c, 0x7d, 0x7e, 0x81, 0x82, 0x83, 0x84, 0x85,
			0x84, 0x84, 0x84, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x80,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81,
			0x80, 0x7e, 0x7c, 0x77, 0x74, 0x74, 0x71, 0x6f, 0x70, 0x70, 0x71,
			0x74, 0x78, 0x7c, 0x7f, 0x84, 0x87, 0x8a, 0x8c, 0x8e, 0x90, 0x90,
			0x90, 0x8f, 0x8e, 0x8c, 0x8a, 0x89, 0x87, 0x84, 0x82, 0x7f, 0x7e,
			0x7b, 0x79, 0x78, 0x76, 0x74, 0x73, 0x73, 0x73, 0x75, 0x76, 0x76,
			0x79, 0x7c, 0x7c, 0x7f, 0x81, 0x83, 0x85, 0x85, 0x85, 0x87, 0x86,
			0x86, 0x86, 0x84, 0x83, 0x83, 0x81, 0x80, 0x7f, 0x7e, 0x7d, 0x7c,
			0x7d, 0x7d, 0x7c, 0x7d, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x82,
			0x83, 0x84, 0x84, 0x83, 0x82, 0x82, 0x81, 0x7e, 0x7c, 0x77, 0x73,
			0x74, 0x71, 0x6e, 0x6f, 0x70, 0x71, 0x75, 0x79, 0x7c, 0x80, 0x85,
			0x88, 0x8b, 0x8c, 0x8e, 0x90, 0x8f, 0x8f, 0x8e, 0x8c, 0x8a, 0x88,
			0x87, 0x84, 0x82, 0x80, 0x7e, 0x7d, 0x7a, 0x79, 0x79, 0x77, 0x76,
			0x76, 0x76, 0x76, 0x78, 0x79, 0x79, 0x7b, 0x7e, 0x7f, 0x80, 0x81,
			0x82, 0x84, 0x84, 0x84, 0x85, 0x84, 0x84, 0x84, 0x81, 0x81, 0x81,
			0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7f, 0x7f, 0x7f, 0x81, 0x82, 0x82, 0x82, 0x83, 0x84, 0x84, 0x83,
			0x83, 0x83, 0x82, 0x80, 0x7d, 0x7b, 0x79, 0x75, 0x73, 0x72, 0x70,
			0x6f, 0x6f, 0x71, 0x72, 0x75, 0x79, 0x7c, 0x81, 0x84, 0x87, 0x8a,
			0x8d, 0x8f, 0x91, 0x91, 0x91, 0x91, 0x90, 0x8e, 0x8c, 0x8a, 0x87,
			0x85, 0x82, 0x7f, 0x7c, 0x7a, 0x78, 0x77, 0x75, 0x75, 0x74, 0x74,
			0x74, 0x76, 0x77, 0x78, 0x7a, 0x7b, 0x7d, 0x80, 0x81, 0x83, 0x85,
			0x86, 0x86, 0x86, 0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x81, 0x80,
			0x7f, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7d,
			0x7b, 0x7b, 0x79, 0x75, 0x74, 0x74, 0x72, 0x71, 0x72, 0x74, 0x75,
			0x79, 0x7d, 0x80, 0x84, 0x87, 0x8b, 0x8e, 0x8f, 0x91, 0x92, 0x91,
			0x90, 0x8f, 0x8d, 0x8b, 0x88, 0x86, 0x82, 0x80, 0x7e, 0x7b, 0x7a,
			0x78, 0x77, 0x76, 0x75, 0x75, 0x76, 0x76, 0x77, 0x78, 0x79, 0x7a,
			0x7c, 0x7e, 0x7f, 0x81, 0x83, 0x84, 0x85, 0x86, 0x87, 0x86, 0x86,
			0x85, 0x84, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82,
			0x83, 0x83, 0x82, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7e, 0x7c,
			0x7b, 0x78, 0x73, 0x72, 0x73, 0x70, 0x6e, 0x70, 0x72, 0x73, 0x77,
			0x7c, 0x7f, 0x83, 0x88, 0x8c, 0x8f, 0x90, 0x92, 0x94, 0x93, 0x92,
			0x91, 0x8f, 0x8d, 0x8a, 0x88, 0x85, 0x82, 0x7f, 0x7e, 0x7c, 0x79,
			0x78, 0x77, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75, 0x76, 0x77, 0x78,
			0x7a, 0x7d, 0x7e, 0x80, 0x82, 0x84, 0x85, 0x85, 0x86, 0x86, 0x86,
			0x85, 0x85, 0x84, 0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7c, 0x7a, 0x7a, 0x7b, 0x79, 0x79, 0x7a,
			0x7a, 0x7a, 0x7c, 0x7e, 0x7f, 0x81, 0x83, 0x86, 0x88, 0x89, 0x8b,
			0x8c, 0x8c, 0x8c, 0x8b, 0x8b, 0x89, 0x87, 0x86, 0x84, 0x82, 0x80,
			0x7f, 0x7d, 0x7b, 0x7a, 0x79, 0x78, 0x77, 0x77, 0x77, 0x78, 0x79,
			0x79, 0x7b, 0x7c, 0x7e, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84, 0x84,
			0x84, 0x84, 0x83, 0x82, 0x81, 0x81, 0x7f, 0x7f, 0x7e, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81,
			0x82, 0x83, 0x83, 0x84, 0x84, 0x84, 0x84, 0x84, 0x83, 0x83, 0x83,
			0x82, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80,
		},
		{ // 2
			0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x7d, 0x7c, 0x80, 0x81, 0x7e, 0x7c, 0x7c, 0x7f,
			0x83, 0x85, 0x86, 0x88, 0x88, 0x85, 0x81, 0x7e, 0x7d, 0x7d, 0x7c,
			0x7a, 0x7a, 0x7b, 0x7c, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x80,
			0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x82, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7e,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x81, 0x82, 0x82, 0x80, 0x7f, 0x81,
			0x82, 0x81, 0x7f, 0x7e, 0x7f, 0x81, 0x80, 0x7f, 0x7e, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7c, 0x7b,
			0x7b, 0x79, 0x78, 0x6d, 0x69, 0x76, 0x76, 0x75, 0x7b, 0x7d, 0x85,
			0x8c, 0x94, 0x92, 0x8d, 0x95, 0x95, 0x8d, 0x89, 0x81, 0x7a, 0x78,
			0x76, 0x75, 0x6f, 0x71, 0x75, 0x78, 0x80, 0x82, 0x85, 0x89, 0x8e,
			0x8e, 0x8a, 0x89, 0x84, 0x81, 0x7e, 0x7a, 0x77, 0x77, 0x7a, 0x7a,
			0x7d, 0x80, 0x82, 0x86, 0x88, 0x8a, 0x87, 0x86, 0x87, 0x84, 0x82,
			0x80, 0x7e, 0x7e, 0x7f, 0x7e, 0x57, 0x2e, 0x5c, 0x6e, 0x54, 0x65,
			0x64, 0x6e, 0x8c, 0xac, 0xb6, 0x94, 0xa1, 0xbf, 0xac, 0x9d, 0x94,
			0x75, 0x65, 0x71, 0x74, 0x60, 0x4d, 0x66, 0x78, 0x7a, 0x95, 0x94,
			0x8a, 0x97, 0xa8, 0xa5, 0x8c, 0x84, 0x7c, 0x6c, 0x6b, 0x65, 0x57,
			0x55, 0x67, 0x75, 0x7b, 0x88, 0x90, 0x93, 0x9e, 0xa3, 0x98, 0x8d,
			0x89, 0x81, 0x79, 0x77, 0x6f, 0x68, 0x6e, 0x78, 0x79, 0x7e, 0x86,
			0x8a, 0x8e, 0x96, 0x95, 0x8f, 0x8d, 0x8b, 0x6a, 0x32, 0x44, 0x5e,
			0x45, 0x56, 0x5e, 0x5a, 0x76, 0x9a, 0xc0, 0xaf, 0xa5, 0xbf, 0xb4,
			0xa8, 0xa9, 0x8b, 0x64, 0x5b, 0x64, 0x66, 0x53, 0x55, 0x68, 0x65,
			0x85, 0xa5, 0x9b, 0x9a, 0x9c, 0xa7, 0xa4, 0x94, 0x8d, 0x6c, 0x59,
			0x61, 0x5c, 0x56, 0x55, 0x61, 0x6c, 0x82, 0x9f, 0x9d, 0x99, 0xa0,
			0xa0, 0x9b, 0x95, 0x8b, 0x73, 0x6c, 0x71, 0x6d, 0x6c, 0x6d, 0x6f,
			0x74, 0x82, 0x92, 0x91, 0x93, 0x97, 0x93, 0x93, 0x90, 0x84, 0x53,
			0x2b, 0x4d, 0x52, 0x49, 0x63, 0x5b, 0x5e, 0x7b, 0xa5, 0xc4, 0xb0,
			0xb0, 0xba, 0xa4, 0xa4, 0xa9, 0x87, 0x62, 0x56, 0x5a, 0x5f, 0x59,
			0x67, 0x6c, 0x61, 0x86, 0xa2, 0xa3, 0xa6, 0x9f, 0x9d, 0x93, 0x8f,
			0x94, 0x71, 0x58, 0x56, 0x4e, 0x55, 0x63, 0x70, 0x6e, 0x7a, 0x97,
			0x9c, 0xa4, 0xa8, 0x99, 0x8c, 0x8a, 0x8a, 0x7c, 0x72, 0x6e, 0x62,
			0x67, 0x75, 0x7b, 0x7c, 0x82, 0x8a, 0x8c, 0x97, 0x9f, 0x95, 0x8f,
			0x86, 0x7b, 0x54, 0x35, 0x4e, 0x47, 0x45, 0x65, 0x62, 0x67, 0x7c,
			0x9c, 0xb9, 0xb3, 0xbc, 0xbc, 0x9e, 0x98, 0x9d, 0x87, 0x6e, 0x62,
			0x58, 0x53, 0x54, 0x6b, 0x79, 0x6f, 0x87, 0x97, 0x95, 0xa5, 0xa8,
			0xa2, 0x91, 0x85, 0x85, 0x71, 0x63, 0x64, 0x54, 0x4b, 0x58, 0x68,
			0x73, 0x84, 0x97, 0x95, 0x96, 0xa4, 0x9e, 0x94, 0x90, 0x85, 0x75,
			0x72, 0x76, 0x6e, 0x6d, 0x75, 0x73, 0x77, 0x85, 0x8c, 0x8d, 0x91,
			0x96, 0x8f, 0x8d, 0x8b, 0x80, 0x62, 0x3b, 0x42, 0x48, 0x42, 0x64,
			0x6c, 0x66, 0x77, 0x89, 0xa7, 0xb4, 0xbf, 0xc7, 0xa9, 0x95, 0x95,
			0x86, 0x78, 0x74, 0x66, 0x54, 0x4f, 0x5b, 0x6f, 0x77, 0x8a, 0x9a,
			0x8d, 0x94, 0xa0, 0x9d, 0x9e, 0x96, 0x8a, 0x74, 0x60, 0x62, 0x5b,
			0x59, 0x61, 0x60, 0x66, 0x75, 0x8a, 0x97, 0x9c, 0xa3, 0x99, 0x8f,
			0x90, 0x89, 0x83, 0x7f, 0x77, 0x6e, 0x6b, 0x73, 0x77, 0x7d, 0x86,
			0x85, 0x87, 0x8c, 0x91, 0x93, 0x93, 0x8d, 0x80, 0x67, 0x42, 0x40,
			0x48, 0x43, 0x60, 0x6d, 0x68, 0x77, 0x83, 0x9d, 0xb0, 0xbc, 0xc8,
			0xb1, 0x9a, 0x95, 0x84, 0x78, 0x79, 0x6f, 0x5e, 0x56, 0x58, 0x64,
			0x70, 0x86, 0x9b, 0x94, 0x96, 0x9d, 0x92, 0x96, 0x98, 0x8f, 0x80,
			0x6b, 0x62, 0x57, 0x53, 0x62, 0x65, 0x6b, 0x79, 0x80, 0x8a, 0x97,
			0xa3, 0xa3, 0x99, 0x94, 0x86, 0x7d, 0x80, 0x7b, 0x78, 0x76, 0x72,
			0x71, 0x78, 0x82, 0x87, 0x8b, 0x8f, 0x8d, 0x8d, 0x8f, 0x8b, 0x84,
			0x71, 0x4d, 0x41, 0x42, 0x3d, 0x58, 0x6f, 0x73, 0x80, 0x86, 0x92,
			0xa3, 0xb1, 0xc5, 0xbe, 0xa8, 0x9b, 0x81, 0x6e, 0x70, 0x70, 0x69,
			0x67, 0x62, 0x60, 0x66, 0x78, 0x91, 0x9a, 0xa0, 0xa4, 0x93, 0x8c,
			0x8e, 0x86, 0x83, 0x7d, 0x71, 0x61, 0x54, 0x58, 0x5c, 0x69, 0x80,
			0x89, 0x8f, 0x96, 0x94, 0x96, 0x97, 0x97, 0x8f, 0x85, 0x7f, 0x74,
			0x72, 0x77, 0x77, 0x7c, 0x80, 0x7f, 0x81, 0x85, 0x8b, 0x8f, 0x92,
			0x93, 0x8a, 0x7b, 0x5f, 0x44, 0x44, 0x41, 0x4a, 0x69, 0x70, 0x78,
			0x86, 0x8a, 0x98, 0xa6, 0xb6, 0xbe, 0xb2, 0xa6, 0x92, 0x75, 0x6a,
			0x6c, 0x67, 0x69, 0x6f, 0x67, 0x67, 0x70, 0x7f, 0x8f, 0x9b, 0xa7,
			0xa2, 0x93, 0x90, 0x85, 0x7a, 0x7c, 0x77, 0x6d, 0x66, 0x5f, 0x59,
			0x5d, 0x6c, 0x7d, 0x8b, 0x9b, 0x9c, 0x97, 0x95, 0x8f, 0x8a, 0x8a,
			0x86, 0x7f, 0x79, 0x76, 0x73, 0x75, 0x7f, 0x83, 0x86, 0x8b, 0x8a,
			0x8a, 0x8e, 0x8f, 0x8c, 0x82, 0x68, 0x4c, 0x43, 0x3c, 0x41, 0x60,
			0x71, 0x7c, 0x8d, 0x8f, 0x94, 0x9d, 0xab, 0xb6, 0xb2, 0xae, 0x9f,
			0x80, 0x6e, 0x66, 0x5e, 0x63, 0x71, 0x72, 0x72, 0x78, 0x7a, 0x83,
			0x90, 0x9f, 0xa4, 0x9e, 0x9b, 0x8c, 0x79, 0x76, 0x6e, 0x67, 0x6a,
			0x67, 0x61, 0x63, 0x6a, 0x72, 0x81, 0x95, 0x9e, 0x9f, 0x9e, 0x93,
			0x88, 0x85, 0x81, 0x7e, 0x80, 0x7f, 0x7b, 0x79, 0x7b, 0x7c, 0x81,
			0x8a, 0x8e, 0x91, 0x93, 0x8d, 0x84, 0x71, 0x53, 0x49, 0x44, 0x3f,
			0x57, 0x6b, 0x74, 0x89, 0x90, 0x92, 0x9c, 0xa4, 0xae, 0xb0, 0xab,
			0xa3, 0x8c, 0x76, 0x6b, 0x60, 0x5e, 0x6a, 0x6f, 0x72, 0x7d, 0x7f,
			0x83, 0x8d, 0x95, 0x9c, 0x9e, 0x9d, 0x96, 0x84, 0x78, 0x6f, 0x62,
			0x62, 0x64, 0x63, 0x68, 0x6f, 0x78, 0x83, 0x90, 0x9b, 0x9f, 0x9e,
			0x97, 0x8b, 0x84, 0x7d, 0x78, 0x7c, 0x7e, 0x7d, 0x7f, 0x7d, 0x7c,
			0x80, 0x86, 0x8d, 0x92, 0x93, 0x8d, 0x7a, 0x5b, 0x4c, 0x43, 0x3c,
			0x54, 0x6b, 0x74, 0x8c, 0x95, 0x92, 0x9a, 0x9f, 0xa5, 0xaa, 0xac,
			0xa6, 0x91, 0x7c, 0x6c, 0x5b, 0x56, 0x62, 0x6a, 0x72, 0x83, 0x86,
			0x85, 0x8e, 0x91, 0x94, 0x9b, 0x9d, 0x9a, 0x8e, 0x82, 0x72, 0x5f,
			0x59, 0x5a, 0x5c, 0x68, 0x75, 0x7f, 0x8a, 0x93, 0x99, 0x9c, 0x9d,
			0x9a, 0x91, 0x89, 0x80, 0x78, 0x76, 0x76, 0x77, 0x7a, 0x7c, 0x7d,
			0x81, 0x85, 0x8b, 0x8d, 0x8c, 0x7d, 0x63, 0x58, 0x4c, 0x43, 0x58,
			0x69, 0x75, 0x8d, 0x96, 0x94, 0x99, 0x9d, 0xa0, 0xa4, 0xa8, 0xa3,
			0x93, 0x82, 0x70, 0x5d, 0x55, 0x5d, 0x62, 0x6c, 0x7e, 0x84, 0x89,
			0x92, 0x92, 0x93, 0x98, 0x9b, 0x98, 0x91, 0x86, 0x75, 0x64, 0x5b,
			0x57, 0x59, 0x67, 0x77, 0x84, 0x90, 0x97, 0x98, 0x9a, 0x98, 0x94,
			0x90, 0x8c, 0x85, 0x7f, 0x7a, 0x75, 0x71, 0x73, 0x74, 0x78, 0x81,
			0x88, 0x8a, 0x83, 0x6d, 0x5e, 0x55, 0x4b, 0x5b, 0x6e, 0x77, 0x8e,
			0x96, 0x90, 0x94, 0x95, 0x95, 0x9c, 0xa1, 0xa0, 0x97, 0x88, 0x79,
			0x69, 0x5e, 0x62, 0x65, 0x6b, 0x7c, 0x82, 0x83, 0x8b, 0x8a, 0x89,
			0x8f, 0x92, 0x93, 0x91, 0x8a, 0x7e, 0x6e, 0x64, 0x5f, 0x5f, 0x6b,
			0x79, 0x84, 0x91, 0x93, 0x91, 0x92, 0x8f, 0x8e, 0x8e, 0x8c, 0x89,
			0x85, 0x80, 0x7b, 0x77, 0x76, 0x75, 0x79, 0x7e, 0x7f, 0x77, 0x61,
			0x58, 0x52, 0x49, 0x60, 0x77, 0x81, 0x9c, 0xa4, 0x99, 0x9a, 0x97,
			0x91, 0x94, 0x99, 0x95, 0x8a, 0x7d, 0x6e, 0x60, 0x5b, 0x67, 0x70,
			0x7a, 0x8e, 0x91, 0x8e, 0x93, 0x8b, 0x85, 0x89, 0x88, 0x86, 0x81,
			0x7a, 0x6d, 0x61, 0x60, 0x61, 0x6a, 0x7e, 0x8c, 0x96, 0x9e, 0x9a,
			0x92, 0x8e, 0x88, 0x86, 0x85, 0x84, 0x82, 0x7d, 0x7a, 0x77, 0x76,
			0x7b, 0x80, 0x84, 0x85, 0x7a, 0x5e, 0x52, 0x4c, 0x42, 0x5e, 0x79,
			0x83, 0x9d, 0xa5, 0x99, 0x9a, 0x99, 0x97, 0x98, 0x9a, 0x94, 0x82,
			0x6f, 0x62, 0x55, 0x55, 0x6b, 0x7a, 0x84, 0x98, 0x96, 0x8e, 0x90,
			0x8b, 0x88, 0x8c, 0x8c, 0x86, 0x7a, 0x6e, 0x60, 0x57, 0x5e, 0x69,
			0x76, 0x8a, 0x93, 0x94, 0x96, 0x90, 0x8b, 0x8c, 0x8b, 0x8a, 0x86,
			0x84, 0x7f, 0x79, 0x7a, 0x7b, 0x7b, 0x82, 0x84, 0x82, 0x7b, 0x5d,
			0x49, 0x4a, 0x41, 0x59, 0x81, 0x89, 0x9d, 0xa9, 0x9a, 0x98, 0x9b,
			0x99, 0x9b, 0x97, 0x8b, 0x76, 0x5e, 0x55, 0x55, 0x5c, 0x78, 0x8f,
			0x93, 0x9e, 0x9b, 0x8c, 0x8e, 0x8c, 0x86, 0x86, 0x7e, 0x71, 0x63,
			0x5b, 0x5a, 0x5d, 0x71, 0x85, 0x8e, 0x9c, 0x9e, 0x97, 0x94, 0x8e,
			0x88, 0x84, 0x7d, 0x78, 0x73, 0x75, 0x7b, 0x7c, 0x83, 0x87, 0x86,
			0x8c, 0x8c, 0x87, 0x7b, 0x56, 0x45, 0x44, 0x38, 0x5a, 0x82, 0x87,
			0xa0, 0xa9, 0x99, 0x9d, 0xa2, 0x9f, 0x9c, 0x91, 0x7e, 0x63, 0x50,
			0x54, 0x5f, 0x6e, 0x90, 0x9c, 0x94, 0x9b, 0x93, 0x88, 0x91, 0x8e,
			0x82, 0x76, 0x68, 0x5b, 0x58, 0x66, 0x74, 0x7e, 0x8e, 0x8d, 0x87,
			0x8a, 0x88, 0x87, 0x8b, 0x88, 0x81, 0x7c, 0x7c, 0x7d, 0x83, 0x90,
			0x92, 0x8d, 0x8a, 0x82, 0x7c, 0x80, 0x7e, 0x79, 0x5f, 0x37, 0x37,
			0x3d, 0x4b, 0x8c, 0xa9, 0xa8, 0xb7, 0xa4, 0x90, 0x99, 0x9a, 0x93,
			0x81, 0x68, 0x4f, 0x3d, 0x4c, 0x73, 0x8e, 0xa8, 0xbb, 0xa5, 0x95,
			0x97, 0x8a, 0x89, 0x89, 0x70, 0x55, 0x44, 0x4a, 0x5e, 0x7e, 0xa0,
			0xa1, 0x96, 0x8d, 0x7c, 0x7d, 0x89, 0x87, 0x80, 0x75, 0x6b, 0x6a,
			0x78, 0x8b, 0x92, 0x92, 0x8e, 0x84, 0x86, 0x8d, 0x8e, 0x8f, 0x87,
			0x78, 0x6b, 0x61, 0x47, 0x3c, 0x57, 0x5e, 0x73, 0x9f, 0x9c, 0x9a,
			0xa3, 0x97, 0x92, 0x90, 0x89, 0x74, 0x5f, 0x5e, 0x60, 0x69, 0x88,
			0x9e, 0x9b, 0xa1, 0x9f, 0x89, 0x87, 0x86, 0x75, 0x6c, 0x64, 0x5e,
			0x60, 0x77, 0x92, 0x99, 0x9f, 0x97, 0x7e, 0x77, 0x75, 0x70, 0x72,
			0x74, 0x71, 0x72, 0x80, 0x8c, 0x90, 0x94, 0x8c, 0x80, 0x7f, 0x83,
			0x8a, 0x90, 0x8a, 0x7d, 0x75, 0x75, 0x7b, 0x80, 0x82, 0x65, 0x36,
			0x41, 0x59, 0x6b, 0xa8, 0xb7, 0x97, 0x94, 0x8d, 0x87, 0x92, 0x92,
			0x7b, 0x55, 0x4c, 0x5d, 0x70, 0x95, 0xb2, 0xa0, 0x8f, 0x92, 0x85,
			0x84, 0x8d, 0x79, 0x62, 0x5c, 0x63, 0x71, 0x8a, 0x9f, 0x97, 0x8c,
			0x88, 0x79, 0x73, 0x76, 0x6f, 0x68, 0x70, 0x7e, 0x88, 0x93, 0x97,
			0x88, 0x7e, 0x7d, 0x79, 0x7b, 0x81, 0x7f, 0x7f, 0x88, 0x8d, 0x89,
			0x87, 0x86, 0x82, 0x83, 0x80, 0x77, 0x58, 0x32, 0x42, 0x65, 0x79,
			0xab, 0xb2, 0x90, 0x92, 0x90, 0x88, 0x8a, 0x7c, 0x64, 0x52, 0x61,
			0x83, 0x96, 0xa5, 0xa7, 0x8b, 0x80, 0x89, 0x7f, 0x76, 0x71, 0x60,
			0x60, 0x77, 0x91, 0x9d, 0x98, 0x94, 0x84, 0x79, 0x81, 0x77, 0x65,
			0x61, 0x63, 0x71, 0x89, 0x9b, 0x96, 0x8a, 0x87, 0x7f, 0x7f, 0x84,
			0x7a, 0x72, 0x77, 0x7e, 0x86, 0x8c, 0x8a, 0x83, 0x85, 0x8b, 0x8b,
			0x87, 0x80, 0x73, 0x6b, 0x6e, 0x60, 0x43, 0x57, 0x77, 0x7f, 0xa6,
			0xac, 0x88, 0x87, 0x84, 0x79, 0x79, 0x74, 0x6b, 0x66, 0x7d, 0x9c,
			0xa1, 0xa1, 0x9b, 0x7f, 0x75, 0x7e, 0x73, 0x6c, 0x70, 0x70, 0x7b,
			0x90, 0x9a, 0x94, 0x83, 0x7a, 0x77, 0x75, 0x78, 0x78, 0x71, 0x77,
			0x83, 0x87, 0x8a, 0x86, 0x79, 0x74, 0x7a, 0x80, 0x80, 0x82, 0x80,
			0x7f, 0x87, 0x8a, 0x86, 0x82, 0x7c, 0x7c, 0x80, 0x85, 0x85, 0x81,
			0x7f, 0x7f, 0x82, 0x88, 0x87, 0x80, 0x79, 0x6b, 0x4c, 0x41, 0x65,
			0x7b, 0x8d, 0xa8, 0x92, 0x83, 0x8f, 0x87, 0x81, 0x7a, 0x6f, 0x6d,
			0x7b, 0x94, 0x9b, 0x91, 0x8c, 0x80, 0x76, 0x7e, 0x7a, 0x6e, 0x73,
			0x7c, 0x87, 0x96, 0x96, 0x89, 0x7b, 0x74, 0x76, 0x76, 0x75, 0x74,
			0x76, 0x7e, 0x8a, 0x8c, 0x84, 0x7d, 0x78, 0x7b, 0x83, 0x86, 0x82,
			0x7f, 0x7f, 0x7d, 0x7d, 0x7c, 0x78, 0x7a, 0x81, 0x88, 0x8c, 0x8a,
			0x84, 0x7c, 0x79, 0x7c, 0x7e, 0x83, 0x87, 0x88, 0x8a, 0x88, 0x82,
			0x7b, 0x72, 0x6e, 0x66, 0x4e, 0x4c, 0x74, 0x8b, 0x9b, 0xaa, 0x8c,
			0x78, 0x7f, 0x77, 0x75, 0x74, 0x70, 0x79, 0x8c, 0xa0, 0x9e, 0x8d,
			0x82, 0x77, 0x75, 0x7d, 0x79, 0x73, 0x7c, 0x88, 0x92, 0x98, 0x8a,
			0x77, 0x6d, 0x6f, 0x7a, 0x7d, 0x7e, 0x81, 0x81, 0x88, 0x8a, 0x7d,
			0x77, 0x74, 0x74, 0x7f, 0x83, 0x82, 0x80, 0x7b, 0x79, 0x76, 0x77,
			0x7c, 0x80, 0x89, 0x8c, 0x8b, 0x8a, 0x81, 0x7c, 0x7b, 0x7c, 0x81,
			0x83, 0x84, 0x84, 0x83, 0x82, 0x80, 0x7f, 0x80, 0x81, 0x84, 0x84,
			0x81, 0x7a, 0x70, 0x68, 0x63, 0x5e, 0x5a, 0x68, 0x83, 0x8f, 0x98,
			0x99, 0x87, 0x82, 0x82, 0x79, 0x76, 0x77, 0x7f, 0x8a, 0x94, 0x98,
			0x8c, 0x81, 0x7d, 0x79, 0x79, 0x7c, 0x7a, 0x7d, 0x88, 0x8d, 0x8b,
			0x84, 0x77, 0x6f, 0x70, 0x77, 0x7e, 0x80, 0x83, 0x85, 0x85, 0x86,
			0x81, 0x7a, 0x78, 0x75, 0x78, 0x82, 0x86, 0x84, 0x83, 0x7d, 0x79,
			0x7a, 0x7a, 0x7b, 0x81, 0x88, 0x89, 0x85, 0x7f, 0x77, 0x75, 0x79,
			0x7d, 0x83, 0x87, 0x87, 0x85, 0x80, 0x7d, 0x7b, 0x7d, 0x80, 0x81,
			0x83, 0x85, 0x84, 0x85, 0x84, 0x81, 0x7f, 0x7d, 0x78, 0x71, 0x6a,
			0x64, 0x5f, 0x61, 0x7b, 0x8d, 0x8e, 0x93, 0x88, 0x7a, 0x80, 0x7d,
			0x76, 0x78, 0x7e, 0x88, 0x91, 0x97, 0x91, 0x82, 0x7d, 0x7d, 0x7b,
			0x7f, 0x80, 0x80, 0x87, 0x8d, 0x89, 0x83, 0x7b, 0x74, 0x75, 0x79,
			0x7d, 0x7f, 0x7f, 0x82, 0x81, 0x7f, 0x7b, 0x74, 0x73, 0x79, 0x80,
			0x86, 0x87, 0x82, 0x7d, 0x7b, 0x78, 0x7a, 0x7d, 0x7d, 0x7e, 0x82,
			0x82, 0x81, 0x82, 0x82, 0x7f, 0x7f, 0x81, 0x84, 0x87, 0x87, 0x84,
			0x7f, 0x7b, 0x79, 0x7c, 0x7e, 0x80, 0x82, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x81, 0x81, 0x83, 0x84, 0x82, 0x7e, 0x7b, 0x7a, 0x7a,
			0x77, 0x6d, 0x68, 0x68, 0x64, 0x71, 0x89, 0x8d, 0x8e, 0x8e, 0x81,
			0x7d, 0x80, 0x7b, 0x79, 0x7f, 0x88, 0x8e, 0x91, 0x8f, 0x84, 0x7f,
			0x7f, 0x7c, 0x7e, 0x7e, 0x7e, 0x82, 0x85, 0x85, 0x82, 0x7d, 0x7b,
			0x7c, 0x7e, 0x81, 0x82, 0x80, 0x7e, 0x7e, 0x7e, 0x7b, 0x78, 0x79,
			0x7b, 0x81, 0x85, 0x83, 0x7e, 0x7b, 0x78, 0x76, 0x7b, 0x7d, 0x7d,
			0x80, 0x7f, 0x80, 0x84, 0x83, 0x84, 0x83, 0x83, 0x83, 0x80, 0x80,
			0x7e, 0x7f, 0x82, 0x81, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7c, 0x7b, 0x7c, 0x7d, 0x7f, 0x80,
			0x82, 0x81, 0x7f, 0x82, 0x81, 0x7f, 0x7f, 0x7e, 0x77, 0x71, 0x69,
			0x55, 0x5b, 0x7e, 0x8b, 0x91, 0x95, 0x84, 0x81, 0x84, 0x7d, 0x7a,
			0x7f, 0x89, 0x8d, 0x90, 0x8e, 0x83, 0x80, 0x82, 0x7e, 0x81, 0x85,
			0x84, 0x88, 0x87, 0x82, 0x7d, 0x78, 0x76, 0x77, 0x7a, 0x7f, 0x80,
			0x81, 0x7f, 0x7d, 0x7d, 0x7a, 0x76, 0x79, 0x84, 0x8b, 0x88, 0x80,
			0x78, 0x76, 0x78, 0x7a, 0x7b, 0x7e, 0x86, 0x89, 0x87, 0x81, 0x7c,
			0x7a, 0x7b, 0x7d, 0x81, 0x83, 0x84, 0x81, 0x7d, 0x7c, 0x7b, 0x7d,
			0x7f, 0x81, 0x82, 0x82, 0x80, 0x7d, 0x7b, 0x7d, 0x81, 0x83, 0x83,
			0x81, 0x7e, 0x7d, 0x7e, 0x7d, 0x7d, 0x7e, 0x7e, 0x81, 0x81, 0x7f,
			0x7d, 0x7c, 0x7d, 0x7f, 0x7e, 0x7e, 0x81, 0x82, 0x82, 0x80, 0x74,
			0x68, 0x6a, 0x75, 0x7d, 0x84, 0x88, 0x8a, 0x8a, 0x83, 0x7b, 0x7b,
			0x81, 0x89, 0x8c, 0x8a, 0x88, 0x87, 0x80, 0x7a, 0x79, 0x7c, 0x82,
			0x88, 0x87, 0x83, 0x82, 0x7f, 0x7b, 0x7b, 0x7d, 0x7f, 0x83, 0x82,
			0x7e, 0x7b, 0x7a, 0x79, 0x7a, 0x7a, 0x7d, 0x84, 0x88, 0x85, 0x82,
			0x80, 0x7c, 0x7a, 0x79, 0x79, 0x7d, 0x7f, 0x7e, 0x7c, 0x7d, 0x7e,
			0x80, 0x82, 0x83, 0x83, 0x84, 0x82, 0x7f, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e, 0x80, 0x82, 0x82,
			0x81, 0x7f, 0x7e, 0x7c, 0x7c, 0x7e, 0x80, 0x80, 0x7f, 0x7e, 0x7e,
			0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x7e, 0x7f,
		},
		{ // 3
			0x7f, 0x80, 0x81, 0x7e, 0x7a, 0x7c, 0x84, 0x85, 0x7d, 0x7c, 0x81,
			0x82, 0x80, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x80,
			0x7d, 0x7c, 0x80, 0x81, 0x80, 0x7f, 0x7d, 0x82, 0x7c, 0x7d, 0x80,
			0x7b, 0x7e, 0x81, 0x84, 0x83, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x81, 0x82, 0x80, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7d, 0x80,
			0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x79, 0x7a, 0x7f, 0x7e, 0x82, 0x82, 0x80,
			0x83, 0x84, 0x83, 0x85, 0x86, 0x82, 0x7f, 0x80, 0x7f, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x80, 0x81, 0x7e, 0x7f, 0x82, 0x82,
			0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x81, 0x81, 0x80, 0x80, 0x82, 0x82, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x82, 0x82, 0x80, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7b, 0x79, 0x73, 0x73, 0x78, 0x74, 0x73, 0x78,
			0x7a, 0x7f, 0x83, 0x87, 0x88, 0x8c, 0x92, 0x8f, 0x8d, 0x8f, 0x8c,
			0x87, 0x82, 0x7e, 0x7a, 0x77, 0x73, 0x72, 0x72, 0x76, 0x7b, 0x7e,
			0x82, 0x87, 0x8b, 0x8d, 0x8f, 0x8e, 0x8c, 0x8b, 0x88, 0x83, 0x80,
			0x7f, 0x7d, 0x7b, 0x7b, 0x7b, 0x7f, 0x82, 0x80, 0x83, 0x87, 0x8a,
			0x83, 0x82, 0x63, 0x45, 0x76, 0x68, 0x3c, 0x56, 0x5f, 0x6c, 0x74,
			0x80, 0x8a, 0x91, 0xc1, 0xb6, 0x95, 0xb7, 0xbc, 0xa0, 0x92, 0x85,
			0x80, 0x72, 0x70, 0x61, 0x49, 0x6f, 0x74, 0x5e, 0x71, 0x84, 0x90,
			0x8f, 0x99, 0x9b, 0x92, 0xa3, 0x8f, 0x75, 0x7f, 0x7a, 0x64, 0x5c,
			0x65, 0x62, 0x6a, 0x78, 0x79, 0x8a, 0x9c, 0x9c, 0x97, 0xa3, 0xa4,
			0x96, 0x92, 0x8b, 0x84, 0x7e, 0x77, 0x6f, 0x73, 0x7c, 0x7b, 0x78,
			0x79, 0x7e, 0x4c, 0x40, 0x84, 0x58, 0x38, 0x66, 0x68, 0x75, 0x7c,
			0x8c, 0x93, 0xa1, 0xcc, 0xa5, 0x95, 0xc2, 0xaa, 0x88, 0x86, 0x7f,
			0x77, 0x64, 0x65, 0x5b, 0x5a, 0x81, 0x6f, 0x6a, 0x90, 0x96, 0x96,
			0x93, 0xa1, 0x9e, 0x8f, 0x94, 0x77, 0x6e, 0x76, 0x63, 0x50, 0x58,
			0x6a, 0x65, 0x70, 0x83, 0x8f, 0x9e, 0xa1, 0x9f, 0xa1, 0xa8, 0x99,
			0x89, 0x8b, 0x83, 0x78, 0x70, 0x71, 0x70, 0x77, 0x7d, 0x7b, 0x87,
			0x89, 0x81, 0x48, 0x51, 0x93, 0x4a, 0x35, 0x69, 0x66, 0x70, 0x6c,
			0x83, 0x96, 0xa4, 0xbd, 0x97, 0xa7, 0xcf, 0x9e, 0x87, 0x91, 0x87,
			0x7a, 0x5f, 0x62, 0x61, 0x62, 0x76, 0x5e, 0x73, 0x98, 0x8a, 0x8d,
			0x97, 0xaa, 0x9f, 0x8b, 0x94, 0x82, 0x7b, 0x6f, 0x59, 0x5e, 0x62,
			0x59, 0x5a, 0x77, 0x83, 0x86, 0x97, 0x9e, 0xa5, 0xa3, 0x9f, 0x96,
			0x95, 0x8f, 0x7c, 0x79, 0x77, 0x71, 0x6e, 0x72, 0x7a, 0x7f, 0x86,
			0x87, 0x8b, 0x54, 0x4b, 0x98, 0x57, 0x30, 0x6a, 0x69, 0x69, 0x62,
			0x80, 0x98, 0x94, 0xb3, 0x9e, 0xa5, 0xcc, 0xa0, 0x8d, 0x99, 0x8e,
			0x7f, 0x60, 0x68, 0x6b, 0x59, 0x6b, 0x61, 0x70, 0x8c, 0x7d, 0x8a,
			0x97, 0xa6, 0x9d, 0x8b, 0x9f, 0x8c, 0x78, 0x76, 0x6a, 0x64, 0x5f,
			0x5e, 0x61, 0x75, 0x7e, 0x7f, 0x91, 0x9b, 0x9c, 0x9b, 0x9f, 0x9a,
			0x92, 0x8f, 0x83, 0x7e, 0x79, 0x74, 0x74, 0x76, 0x7b, 0x7d, 0x80,
			0x84, 0x4e, 0x48, 0x98, 0x58, 0x2f, 0x73, 0x71, 0x69, 0x61, 0x87,
			0x9e, 0x8b, 0xac, 0x9f, 0xa5, 0xc2, 0x98, 0x8e, 0x9d, 0x8e, 0x7b,
			0x64, 0x71, 0x72, 0x56, 0x68, 0x69, 0x73, 0x82, 0x75, 0x8c, 0x95,
			0x9b, 0x95, 0x8d, 0xa0, 0x8a, 0x7a, 0x79, 0x75, 0x69, 0x5d, 0x69,
			0x6b, 0x72, 0x77, 0x82, 0x90, 0x90, 0x95, 0x97, 0x9f, 0x97, 0x8e,
			0x90, 0x88, 0x80, 0x77, 0x79, 0x79, 0x74, 0x7a, 0x7b, 0x81, 0x54,
			0x40, 0x93, 0x64, 0x29, 0x74, 0x78, 0x66, 0x5f, 0x81, 0xa3, 0x83,
			0x9f, 0xa5, 0xa1, 0xbe, 0x98, 0x92, 0xa5, 0x92, 0x80, 0x6b, 0x78,
			0x7a, 0x53, 0x65, 0x6e, 0x6b, 0x75, 0x6c, 0x84, 0x8b, 0x8b, 0x91,
			0x8e, 0x9c, 0x8b, 0x83, 0x89, 0x81, 0x71, 0x6e, 0x7b, 0x6e, 0x6e,
			0x79, 0x7f, 0x82, 0x82, 0x8e, 0x8e, 0x91, 0x8e, 0x8d, 0x90, 0x87,
			0x83, 0x80, 0x81, 0x7a, 0x7d, 0x7c, 0x7e, 0x69, 0x3b, 0x85, 0x77,
			0x27, 0x6b, 0x76, 0x68, 0x5f, 0x71, 0xa0, 0x7f, 0x91, 0xa4, 0x9b,
			0xb8, 0x9e, 0x94, 0xae, 0x9a, 0x8a, 0x7b, 0x7f, 0x87, 0x59, 0x65,
			0x75, 0x63, 0x6a, 0x60, 0x7a, 0x7d, 0x74, 0x87, 0x85, 0x92, 0x88,
			0x8a, 0x93, 0x89, 0x86, 0x80, 0x8a, 0x7d, 0x7a, 0x80, 0x7d, 0x80,
			0x7a, 0x84, 0x84, 0x84, 0x84, 0x83, 0x8a, 0x83, 0x82, 0x84, 0x84,
			0x82, 0x7d, 0x85, 0x66, 0x4e, 0x88, 0x75, 0x37, 0x6c, 0x7d, 0x63,
			0x5a, 0x75, 0x94, 0x71, 0x84, 0x99, 0x8e, 0xa2, 0x99, 0x95, 0x9f,
			0xa0, 0x9a, 0x85, 0x8b, 0x95, 0x7a, 0x73, 0x7e, 0x76, 0x72, 0x6b,
			0x70, 0x76, 0x73, 0x78, 0x75, 0x7c, 0x82, 0x7e, 0x81, 0x84, 0x86,
			0x83, 0x81, 0x81, 0x82, 0x82, 0x7f, 0x81, 0x82, 0x82, 0x82, 0x81,
			0x83, 0x83, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7b, 0x7b, 0x7d, 0x7c,
			0x7c, 0x7e, 0x7d, 0x7a, 0x7e, 0x82, 0x7e, 0x7d, 0x80, 0x7f, 0x7e,
			0x7c, 0x7c, 0x7b, 0x7a, 0x7c, 0x7b, 0x7c, 0x7c, 0x7d, 0x80, 0x80,
			0x82, 0x83, 0x83, 0x84, 0x85, 0x84, 0x83, 0x84, 0x86, 0x84, 0x83,
			0x84, 0x86, 0x85, 0x84, 0x84, 0x82, 0x82, 0x81, 0x7d, 0x7c, 0x7c,
			0x7b, 0x79, 0x78, 0x7a, 0x7a, 0x7a, 0x7d, 0x7e, 0x7f, 0x82, 0x84,
			0x83, 0x84, 0x85, 0x83, 0x82, 0x82, 0x80, 0x7e, 0x7e, 0x80, 0x79,
			0x7a, 0x81, 0x79, 0x78, 0x7c, 0x7d, 0x7e, 0x7a, 0x7e, 0x7e, 0x7b,
			0x7f, 0x7e, 0x7c, 0x7d, 0x7e, 0x82, 0x80, 0x80, 0x86, 0x82, 0x84,
			0x86, 0x85, 0x86, 0x83, 0x86, 0x84, 0x7f, 0x82, 0x81, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7e, 0x7d, 0x7d,
			0x7c, 0x7b, 0x7c, 0x7d, 0x7c, 0x7d, 0x80, 0x7e, 0x81, 0x82, 0x83,
			0x82, 0x82, 0x84, 0x82, 0x82, 0x83, 0x7d, 0x78, 0x80, 0x7f, 0x76,
			0x77, 0x7a, 0x7d, 0x77, 0x76, 0x7d, 0x7c, 0x7e, 0x7e, 0x7e, 0x81,
			0x81, 0x84, 0x82, 0x81, 0x88, 0x86, 0x81, 0x84, 0x86, 0x85, 0x82,
			0x83, 0x86, 0x80, 0x7f, 0x81, 0x7f, 0x7c, 0x7c, 0x80, 0x7c, 0x7b,
			0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x7f, 0x80,
			0x80, 0x7d, 0x80, 0x82, 0x7e, 0x7f, 0x81, 0x80, 0x80, 0x82, 0x82,
			0x80, 0x81, 0x82, 0x81, 0x75, 0x7c, 0x86, 0x74, 0x72, 0x7c, 0x7d,
			0x76, 0x6f, 0x7f, 0x7e, 0x75, 0x7f, 0x81, 0x81, 0x82, 0x85, 0x87,
			0x83, 0x8a, 0x8c, 0x80, 0x86, 0x8a, 0x82, 0x7f, 0x7f, 0x87, 0x7f,
			0x79, 0x82, 0x7e, 0x7e, 0x7a, 0x7c, 0x7e, 0x79, 0x7b, 0x7b, 0x7e,
			0x7d, 0x7e, 0x7d, 0x7d, 0x85, 0x7c, 0x81, 0x87, 0x84, 0x83, 0x84,
			0x88, 0x7f, 0x80, 0x82, 0x7f, 0x81, 0x7f, 0x83, 0x81, 0x82, 0x84,
			0x81, 0x6d, 0x7d, 0x8f, 0x5d, 0x6c, 0x88, 0x6e, 0x66, 0x6e, 0x86,
			0x72, 0x6c, 0x8c, 0x80, 0x81, 0x8a, 0x88, 0x90, 0x8f, 0x8b, 0x8d,
			0x8f, 0x91, 0x83, 0x85, 0x93, 0x7e, 0x7c, 0x84, 0x7f, 0x78, 0x71,
			0x7d, 0x75, 0x6d, 0x73, 0x76, 0x75, 0x6e, 0x7b, 0x7f, 0x7b, 0x7f,
			0x87, 0x8e, 0x85, 0x8c, 0x93, 0x8e, 0x8a, 0x8b, 0x8f, 0x82, 0x80,
			0x85, 0x7e, 0x7b, 0x7b, 0x7f, 0x7b, 0x7d, 0x6e, 0x67, 0x8d, 0x64,
			0x55, 0x8a, 0x69, 0x5e, 0x72, 0x76, 0x79, 0x6d, 0x85, 0x87, 0x86,
			0x92, 0x88, 0x9d, 0x9c, 0x87, 0x9c, 0x9c, 0x8b, 0x8b, 0x8c, 0x8f,
			0x7e, 0x7b, 0x85, 0x77, 0x75, 0x6f, 0x76, 0x77, 0x66, 0x71, 0x74,
			0x71, 0x6d, 0x77, 0x7e, 0x74, 0x80, 0x87, 0x89, 0x88, 0x8e, 0x98,
			0x8f, 0x92, 0x95, 0x93, 0x8a, 0x86, 0x8a, 0x80, 0x7b, 0x7b, 0x7c,
			0x76, 0x78, 0x6c, 0x61, 0x89, 0x5f, 0x53, 0x8d, 0x5b, 0x63, 0x77,
			0x67, 0x7c, 0x6d, 0x7d, 0x89, 0x83, 0x8d, 0x8c, 0x9f, 0x96, 0x8f,
			0xa7, 0x99, 0x92, 0x99, 0x8e, 0x92, 0x84, 0x7c, 0x88, 0x76, 0x71,
			0x70, 0x73, 0x6f, 0x62, 0x75, 0x6e, 0x69, 0x75, 0x75, 0x79, 0x78,
			0x81, 0x85, 0x85, 0x89, 0x8e, 0x94, 0x8c, 0x93, 0x95, 0x8e, 0x90,
			0x8d, 0x8c, 0x83, 0x83, 0x81, 0x7a, 0x7c, 0x77, 0x77, 0x62, 0x68,
			0x7f, 0x50, 0x67, 0x79, 0x56, 0x76, 0x67, 0x70, 0x83, 0x6a, 0x89,
			0x89, 0x84, 0x90, 0x8f, 0x9b, 0x90, 0x94, 0xa0, 0x94, 0x95, 0x93,
			0x92, 0x92, 0x83, 0x88, 0x86, 0x78, 0x78, 0x73, 0x75, 0x6b, 0x68,
			0x6e, 0x6c, 0x6b, 0x6a, 0x78, 0x74, 0x76, 0x84, 0x82, 0x88, 0x8a,
			0x92, 0x8f, 0x8d, 0x96, 0x91, 0x8e, 0x8c, 0x8f, 0x89, 0x83, 0x86,
			0x82, 0x7e, 0x7d, 0x7e, 0x7a, 0x71, 0x64, 0x7a, 0x6b, 0x53, 0x7a,
			0x61, 0x63, 0x71, 0x60, 0x83, 0x6c, 0x75, 0x90, 0x7d, 0x8d, 0x8f,
			0x95, 0x9a, 0x8f, 0x9d, 0x9c, 0x92, 0x95, 0x93, 0x93, 0x8b, 0x83,
			0x8b, 0x7f, 0x78, 0x78, 0x76, 0x74, 0x68, 0x6f, 0x6f, 0x68, 0x6b,
			0x6e, 0x73, 0x70, 0x78, 0x82, 0x81, 0x84, 0x8d, 0x91, 0x8e, 0x91,
			0x95, 0x91, 0x8f, 0x8f, 0x8e, 0x88, 0x86, 0x86, 0x80, 0x7e, 0x80,
			0x7d, 0x7b, 0x7b, 0x73, 0x67, 0x7e, 0x6a, 0x59, 0x7f, 0x5e, 0x69,
			0x70, 0x60, 0x85, 0x66, 0x79, 0x8f, 0x76, 0x92, 0x8a, 0x94, 0x9a,
			0x8b, 0x9f, 0x99, 0x91, 0x98, 0x8f, 0x91, 0x8b, 0x84, 0x8a, 0x7e,
			0x7b, 0x7c, 0x76, 0x75, 0x6e, 0x73, 0x71, 0x6b, 0x71, 0x70, 0x74,
			0x71, 0x76, 0x7e, 0x79, 0x80, 0x86, 0x88, 0x88, 0x8d, 0x91, 0x8c,
			0x8e, 0x91, 0x8e, 0x8a, 0x8b, 0x8b, 0x84, 0x82, 0x83, 0x7f, 0x7b,
			0x7d, 0x7e, 0x7a, 0x78, 0x74, 0x6f, 0x7b, 0x69, 0x67, 0x7a, 0x60,
			0x70, 0x6e, 0x69, 0x7f, 0x68, 0x82, 0x84, 0x79, 0x91, 0x86, 0x94,
			0x92, 0x8e, 0x9e, 0x92, 0x93, 0x96, 0x8f, 0x92, 0x8a, 0x86, 0x8a,
			0x7c, 0x7d, 0x7c, 0x75, 0x75, 0x70, 0x74, 0x70, 0x6f, 0x75, 0x74,
			0x75, 0x77, 0x79, 0x7b, 0x7e, 0x7d, 0x82, 0x85, 0x82, 0x89, 0x87,
			0x8a, 0x8a, 0x89, 0x8b, 0x87, 0x8a, 0x87, 0x86, 0x85, 0x84, 0x83,
			0x7f, 0x82, 0x80, 0x7d, 0x81, 0x7e, 0x7d, 0x7a, 0x70, 0x7c, 0x73,
			0x65, 0x7b, 0x67, 0x6d, 0x71, 0x66, 0x7f, 0x69, 0x7a, 0x85, 0x77,
			0x8c, 0x83, 0x8e, 0x92, 0x89, 0x98, 0x93, 0x90, 0x94, 0x8e, 0x91,
			0x8b, 0x85, 0x8d, 0x81, 0x7e, 0x80, 0x7a, 0x7c, 0x73, 0x77, 0x78,
			0x70, 0x75, 0x75, 0x76, 0x76, 0x77, 0x7c, 0x7b, 0x7b, 0x7d, 0x81,
			0x7e, 0x80, 0x85, 0x80, 0x82, 0x84, 0x84, 0x84, 0x84, 0x88, 0x86,
			0x84, 0x88, 0x88, 0x85, 0x86, 0x88, 0x85, 0x83, 0x84, 0x84, 0x82,
			0x83, 0x80, 0x7f, 0x7b, 0x71, 0x7f, 0x6b, 0x69, 0x78, 0x5f, 0x71,
			0x66, 0x68, 0x78, 0x61, 0x7d, 0x78, 0x78, 0x89, 0x81, 0x93, 0x8d,
			0x8e, 0x9d, 0x95, 0x98, 0x99, 0x95, 0x99, 0x8f, 0x8e, 0x90, 0x82,
			0x83, 0x7f, 0x7a, 0x77, 0x70, 0x75, 0x70, 0x6b, 0x70, 0x71, 0x6f,
			0x70, 0x75, 0x78, 0x77, 0x7b, 0x80, 0x80, 0x7f, 0x83, 0x87, 0x82,
			0x86, 0x87, 0x86, 0x87, 0x85, 0x89, 0x85, 0x85, 0x89, 0x84, 0x87,
			0x86, 0x87, 0x84, 0x83, 0x87, 0x82, 0x81, 0x82, 0x82, 0x7e, 0x7e,
			0x7f, 0x79, 0x7d, 0x6b, 0x75, 0x79, 0x5a, 0x78, 0x65, 0x66, 0x75,
			0x5c, 0x83, 0x6b, 0x75, 0x8d, 0x77, 0x92, 0x88, 0x92, 0x9b, 0x8c,
			0x9e, 0x9a, 0x92, 0x98, 0x91, 0x92, 0x8d, 0x84, 0x8b, 0x7f, 0x7b,
			0x7b, 0x75, 0x77, 0x6d, 0x70, 0x72, 0x6c, 0x70, 0x71, 0x74, 0x74,
			0x77, 0x7f, 0x7f, 0x81, 0x87, 0x88, 0x89, 0x89, 0x8a, 0x8a, 0x83,
			0x87, 0x84, 0x7e, 0x81, 0x7d, 0x7e, 0x7a, 0x7b, 0x7e, 0x79, 0x7d,
			0x7e, 0x7f, 0x81, 0x82, 0x85, 0x85, 0x86, 0x88, 0x87, 0x86, 0x88,
			0x87, 0x85, 0x85, 0x86, 0x80, 0x82, 0x7c, 0x6b, 0x84, 0x68, 0x64,
			0x7b, 0x58, 0x75, 0x5f, 0x68, 0x7d, 0x5c, 0x85, 0x78, 0x80, 0x8d,
			0x82, 0x9c, 0x8f, 0x94, 0x9f, 0x95, 0x99, 0x98, 0x94, 0x96, 0x8c,
			0x8d, 0x8a, 0x80, 0x81, 0x7a, 0x79, 0x72, 0x70, 0x72, 0x6c, 0x6d,
			0x6e, 0x70, 0x70, 0x73, 0x78, 0x7a, 0x7d, 0x81, 0x84, 0x86, 0x87,
			0x89, 0x8b, 0x88, 0x8a, 0x86, 0x82, 0x84, 0x7d, 0x7e, 0x7c, 0x7b,
			0x7c, 0x7a, 0x7e, 0x7d, 0x7f, 0x81, 0x81, 0x84, 0x84, 0x86, 0x85,
			0x87, 0x86, 0x85, 0x85, 0x83, 0x84, 0x81, 0x82, 0x81, 0x81, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7b, 0x69, 0x81, 0x71, 0x61, 0x7d, 0x61, 0x75,
			0x67, 0x6d, 0x81, 0x64, 0x86, 0x7d, 0x83, 0x8c, 0x87, 0x9b, 0x8d,
			0x95, 0x9b, 0x94, 0x95, 0x93, 0x94, 0x8e, 0x88, 0x89, 0x83, 0x7e,
			0x7a, 0x7a, 0x76, 0x72, 0x73, 0x72, 0x72, 0x72, 0x75, 0x77, 0x77,
			0x7b, 0x7f, 0x7e, 0x81, 0x85, 0x84, 0x85, 0x84, 0x86, 0x85, 0x80,
			0x83, 0x82, 0x7d, 0x7d, 0x7f, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7d,
			0x80, 0x7f, 0x80, 0x84, 0x84, 0x84, 0x86, 0x88, 0x86, 0x86, 0x87,
			0x86, 0x83, 0x83, 0x83, 0x7f, 0x7f, 0x7e, 0x7c, 0x7a, 0x7a, 0x7c,
			0x7a, 0x7b, 0x7d, 0x7d, 0x7c, 0x80, 0x7c, 0x77, 0x80, 0x76, 0x76,
			0x77, 0x75, 0x79, 0x72, 0x7b, 0x7a, 0x7a, 0x82, 0x82, 0x87, 0x87,
			0x8c, 0x8f, 0x8c, 0x8f, 0x90, 0x8d, 0x8b, 0x8a, 0x88, 0x83, 0x81,
			0x81, 0x7d, 0x7c, 0x7c, 0x7b, 0x7b, 0x7b, 0x7e, 0x7c, 0x7c, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x81, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7d, 0x7f, 0x7d, 0x7d, 0x7d, 0x7d, 0x7f,
			0x7c, 0x7f, 0x81, 0x7f, 0x81, 0x81, 0x83, 0x81, 0x81, 0x84, 0x82,
			0x81, 0x82, 0x82, 0x80, 0x7f, 0x81, 0x80, 0x7e, 0x81, 0x81, 0x7f,
			0x81, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7d, 0x7e, 0x7e, 0x7e, 0x7c,
			0x7d, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x80, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7d, 0x7f, 0x7d, 0x7e, 0x7f, 0x7f, 0x81, 0x81, 0x82, 0x84,
			0x84, 0x85, 0x85, 0x85, 0x85, 0x83, 0x84, 0x82, 0x80, 0x82, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x81,
			0x7f, 0x80, 0x80, 0x80, 0x82, 0x80, 0x81, 0x83, 0x80, 0x81, 0x81,
			0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x81, 0x81, 0x7f, 0x82,
			0x80, 0x81, 0x81, 0x80, 0x82, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81,
			0x80, 0x81, 0x81, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x81, 0x7f, 0x80, 0x81,
			0x80, 0x82, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x81,
			0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x7d, 0x7d, 0x7f, 0x7c, 0x7e, 0x7f,
			0x7e, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x82, 0x80, 0x80, 0x82, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x81, 0x7f,
			0x7e, 0x7f, 0x7d, 0x7f, 0x7e, 0x7d, 0x80, 0x7c, 0x7e, 0x80, 0x7e,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7f,
			0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81, 0x81, 0x80,
			0x7f, 0x7e, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7f,
			0x81, 0x80, 0x81, 0x83, 0x82, 0x80, 0x81, 0x81, 0x80, 0x7f, 0x7f,
			0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x80,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7d,
			0x7c, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x82, 0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x82, 0x80, 0x82, 0x81,
			0x81, 0x82, 0x80, 0x82, 0x81, 0x7f, 0x80, 0x7e, 0x7d, 0x7d, 0x7b,
			0x7b, 0x7c, 0x7b, 0x7c, 0x7d, 0x7d, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x81, 0x80, 0x81, 0x81, 0x7f, 0x81, 0x80, 0x80, 0x82, 0x80, 0x82,
			0x81, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x81, 0x7f, 0x80, 0x81, 0x7f, 0x81, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f,
		},
		{ // 4
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7e, 0x7f, 0x80, 0x7d, 0x7f, 0x80, 0x7e, 0x7f, 0x7e, 0x81, 0x7f,
			0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7e, 0x7f, 0x7f,
			0x7e, 0x7f, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x81, 0x7d,
			0x80, 0x7f, 0x79, 0x81, 0x7c, 0x7c, 0x84, 0x80, 0x81, 0x81, 0x80,
			0x85, 0x7a, 0x82, 0x80, 0x7d, 0x81, 0x7a, 0x80, 0x7d, 0x7e, 0x7e,
			0x80, 0x7e, 0x7f, 0x7f, 0x7c, 0x86, 0x7d, 0x7e, 0x85, 0x7b, 0x81,
			0x83, 0x76, 0x88, 0x78, 0x82, 0x83, 0x76, 0x88, 0x7a, 0x7f, 0x83,
			0x7a, 0x84, 0x7a, 0x80, 0x85, 0x73, 0x8b, 0x79, 0x7e, 0x85, 0x75,
			0x8b, 0x75, 0x83, 0x84, 0x75, 0x8a, 0x78, 0x80, 0x86, 0x75, 0x83,
			0x7d, 0x7d, 0x84, 0x7b, 0x85, 0x7f, 0x7d, 0x7e, 0x7f, 0x84, 0x77,
			0x88, 0x7d, 0x79, 0x8b, 0x71, 0x87, 0x84, 0x6e, 0x8f, 0x77, 0x7a,
			0x89, 0x78, 0x84, 0x7d, 0x7e, 0x82, 0x80, 0x79, 0x7f, 0x89, 0x75,
			0x85, 0x81, 0x74, 0x8f, 0x71, 0x7e, 0x8e, 0x6f, 0x84, 0x86, 0x76,
			0x82, 0x80, 0x80, 0x7d, 0x77, 0x8c, 0x7c, 0x7c, 0x80, 0x80, 0x7d,
			0x7d, 0x84, 0x77, 0x89, 0x7e, 0x76, 0x8d, 0x76, 0x7a, 0x8d, 0x70,
			0x85, 0x8a, 0x6d, 0x8b, 0x81, 0x6f, 0x8c, 0x7f, 0x73, 0x8e, 0x7e,
			0x74, 0x8c, 0x79, 0x7a, 0x8c, 0x71, 0x85, 0x85, 0x74, 0x84, 0x83,
			0x79, 0x7d, 0x8a, 0x74, 0x84, 0x7e, 0x7d, 0x86, 0x77, 0x8a, 0x77,
			0x7e, 0x85, 0x78, 0x81, 0x81, 0x7e, 0x84, 0x7a, 0x7d, 0x83, 0x7b,
			0x83, 0x77, 0x8d, 0x76, 0x80, 0x8a, 0x6d, 0x91, 0x78, 0x76, 0x8b,
			0x7c, 0x78, 0x87, 0x7b, 0x80, 0x7f, 0x7c, 0x83, 0x75, 0x8a, 0x7c,
			0x7b, 0x87, 0x79, 0x7f, 0x81, 0x7d, 0x7f, 0x83, 0x7a, 0x84, 0x7e,
			0x7d, 0x84, 0x77, 0x84, 0x7d, 0x81, 0x81, 0x7b, 0x8b, 0x72, 0x78,
			0x94, 0x6f, 0x7b, 0x98, 0x6d, 0x7b, 0x94, 0x65, 0x87, 0x8e, 0x6c,
			0x8c, 0x7b, 0x80, 0x82, 0x74, 0x8d, 0x79, 0x78, 0x8c, 0x79, 0x7e,
			0x7e, 0x86, 0x7d, 0x77, 0x8d, 0x76, 0x77, 0x91, 0x77, 0x75, 0x93,
			0x76, 0x78, 0x8c, 0x74, 0x83, 0x7b, 0x7e, 0x87, 0x77, 0x86, 0x7c,
			0x78, 0x8c, 0x7c, 0x76, 0x8d, 0x74, 0x7f, 0x8f, 0x6d, 0x8a, 0x7f,
			0x74, 0x8f, 0x71, 0x84, 0x86, 0x78, 0x87, 0x75, 0x88, 0x7d, 0x75,
			0x86, 0x7e, 0x7e, 0x82, 0x7a, 0x85, 0x83, 0x72, 0x89, 0x80, 0x73,
			0x8b, 0x7d, 0x7a, 0x8c, 0x76, 0x81, 0x7f, 0x7e, 0x83, 0x7a, 0x80,
			0x82, 0x7e, 0x7d, 0x83, 0x7e, 0x7c, 0x84, 0x7c, 0x7e, 0x84, 0x7a,
			0x80, 0x83, 0x7e, 0x80, 0x7f, 0x7a, 0x84, 0x7f, 0x77, 0x88, 0x7b,
			0x7d, 0x82, 0x7d, 0x7f, 0x7f, 0x80, 0x79, 0x87, 0x81, 0x71, 0x8d,
			0x80, 0x75, 0x89, 0x7e, 0x79, 0x8a, 0x7a, 0x7b, 0x8a, 0x73, 0x7f,
			0x87, 0x76, 0x81, 0x86, 0x7b, 0x7d, 0x89, 0x78, 0x7c, 0x8a, 0x79,
			0x7e, 0x88, 0x79, 0x7b, 0x88, 0x73, 0x82, 0x8a, 0x72, 0x88, 0x82,
			0x74, 0x83, 0x80, 0x7e, 0x84, 0x7e, 0x7e, 0x82, 0x7c, 0x82, 0x7b,
			0x7f, 0x88, 0x74, 0x87, 0x86, 0x6f, 0x8e, 0x7f, 0x74, 0x8a, 0x7a,
			0x7b, 0x87, 0x7c, 0x7b, 0x85, 0x7f, 0x7e, 0x82, 0x7f, 0x81, 0x7e,
			0x80, 0x83, 0x7e, 0x7e, 0x7e, 0x7f, 0x7a, 0x82, 0x7f, 0x7a, 0x88,
			0x7d, 0x81, 0x83, 0x7e, 0x83, 0x7a, 0x82, 0x7b, 0x7e, 0x80, 0x7b,
			0x83, 0x81, 0x80, 0x7f, 0x86, 0x78, 0x84, 0x84, 0x75, 0x88, 0x7f,
			0x7b, 0x84, 0x7c, 0x7f, 0x81, 0x7c, 0x7c, 0x85, 0x79, 0x80, 0x84,
			0x7a, 0x83, 0x83, 0x7d, 0x81, 0x7f, 0x83, 0x76, 0x87, 0x81, 0x73,
			0x89, 0x7f, 0x78, 0x86, 0x81, 0x78, 0x88, 0x81, 0x75, 0x8d, 0x7d,
			0x7a, 0x86, 0x7a, 0x81, 0x7d, 0x7d, 0x7e, 0x7f, 0x7d, 0x7c, 0x7f,
			0x7b, 0x81, 0x7a, 0x7c, 0x81, 0x7d, 0x7b, 0x82, 0x81, 0x7c, 0x86,
			0x85, 0x7e, 0x8a, 0x85, 0x82, 0x89, 0x85, 0x83, 0x8b, 0x83, 0x83,
			0x86, 0x80, 0x81, 0x80, 0x7b, 0x81, 0x82, 0x78, 0x85, 0x7e, 0x79,
			0x81, 0x7a, 0x7c, 0x81, 0x80, 0x7d, 0x83, 0x7e, 0x80, 0x84, 0x7b,
			0x88, 0x81, 0x84, 0x61, 0x68, 0x91, 0x52, 0x64, 0x75, 0x61, 0x77,
			0x66, 0x74, 0x81, 0x89, 0x87, 0x87, 0xa5, 0x99, 0x9b, 0x9e, 0x9e,
			0xa0, 0x97, 0x8f, 0x8a, 0x8d, 0x80, 0x72, 0x77, 0x76, 0x6a, 0x68,
			0x6c, 0x6d, 0x70, 0x70, 0x78, 0x80, 0x81, 0x81, 0x8b, 0x8d, 0x8a,
			0x8c, 0x8e, 0x8c, 0x88, 0x85, 0x84, 0x85, 0x7d, 0x7a, 0x7e, 0x7b,
			0x79, 0x79, 0x7c, 0x7e, 0x7c, 0x81, 0x7f, 0x84, 0x88, 0x84, 0x83,
			0x53, 0x6b, 0x95, 0x3e, 0x53, 0x79, 0x57, 0x69, 0x61, 0x6f, 0x7f,
			0x8c, 0x8a, 0x83, 0xb1, 0xaa, 0x96, 0xa5, 0xac, 0xa3, 0x9c, 0x93,
			0x8a, 0x91, 0x82, 0x72, 0x72, 0x78, 0x6b, 0x63, 0x69, 0x6c, 0x6e,
			0x65, 0x72, 0x79, 0x79, 0x7d, 0x84, 0x8c, 0x89, 0x8d, 0x8e, 0x90,
			0x90, 0x8a, 0x8b, 0x8b, 0x85, 0x7f, 0x80, 0x83, 0x77, 0x7b, 0x7c,
			0x7a, 0x79, 0x7d, 0x7d, 0x7e, 0x85, 0x7d, 0x86, 0x84, 0x86, 0x62,
			0x4d, 0x98, 0x58, 0x37, 0x7b, 0x5b, 0x60, 0x64, 0x6c, 0x77, 0x86,
			0x98, 0x7d, 0xa0, 0xbb, 0x9c, 0x9d, 0xb1, 0xa9, 0x9c, 0x9b, 0x8a,
			0x8d, 0x89, 0x7a, 0x6b, 0x71, 0x78, 0x5f, 0x63, 0x6c, 0x70, 0x67,
			0x66, 0x7a, 0x79, 0x7b, 0x7b, 0x89, 0x8f, 0x89, 0x8d, 0x8f, 0x98,
			0x8c, 0x89, 0x8e, 0x8a, 0x83, 0x7c, 0x82, 0x7f, 0x79, 0x77, 0x7a,
			0x7c, 0x78, 0x7b, 0x7e, 0x81, 0x82, 0x7d, 0x85, 0x85, 0x87, 0x7e,
			0x41, 0x70, 0x95, 0x33, 0x50, 0x73, 0x5e, 0x61, 0x5e, 0x78, 0x77,
			0x98, 0x90, 0x7d, 0xb4, 0xb8, 0x98, 0x9e, 0xb5, 0xa7, 0x9b, 0x92,
			0x8c, 0x89, 0x86, 0x75, 0x63, 0x77, 0x74, 0x5b, 0x61, 0x6f, 0x75,
			0x68, 0x69, 0x75, 0x84, 0x7e, 0x78, 0x88, 0x94, 0x8d, 0x86, 0x90,
			0x95, 0x8d, 0x87, 0x84, 0x88, 0x85, 0x7b, 0x78, 0x80, 0x7d, 0x75,
			0x78, 0x79, 0x7b, 0x7b, 0x79, 0x7e, 0x80, 0x81, 0x7d, 0x85, 0x87,
			0x8b, 0x7d, 0x42, 0x79, 0x8c, 0x3c, 0x57, 0x6b, 0x68, 0x5e, 0x63,
			0x76, 0x72, 0x9a, 0x8c, 0x81, 0xa8, 0xb3, 0x9e, 0x96, 0xae, 0xa8,
			0x99, 0x94, 0x8c, 0x87, 0x89, 0x7b, 0x6a, 0x72, 0x76, 0x6b, 0x63,
			0x6f, 0x75, 0x6e, 0x71, 0x72, 0x7c, 0x81, 0x7e, 0x7d, 0x88, 0x91,
			0x86, 0x84, 0x8a, 0x8c, 0x87, 0x81, 0x82, 0x84, 0x81, 0x79, 0x78,
			0x7a, 0x7e, 0x78, 0x76, 0x7c, 0x7e, 0x7b, 0x7b, 0x7c, 0x83, 0x81,
			0x7d, 0x80, 0x84, 0x87, 0x83, 0x8c, 0x69, 0x5c, 0x8f, 0x6f, 0x54,
			0x67, 0x6e, 0x6b, 0x60, 0x73, 0x6a, 0x79, 0x8e, 0x80, 0x85, 0x98,
			0xa6, 0x96, 0x97, 0xa6, 0x9f, 0x9b, 0x98, 0x8e, 0x87, 0x8c, 0x85,
			0x72, 0x75, 0x7c, 0x70, 0x6a, 0x72, 0x73, 0x70, 0x72, 0x74, 0x74,
			0x7e, 0x7e, 0x79, 0x7d, 0x87, 0x84, 0x7f, 0x81, 0x85, 0x83, 0x83,
			0x81, 0x7f, 0x84, 0x81, 0x7d, 0x7c, 0x81, 0x7f, 0x7a, 0x7c, 0x7d,
			0x7d, 0x7d, 0x7c, 0x7d, 0x7f, 0x7e, 0x7e, 0x7d, 0x81, 0x80, 0x7f,
			0x80, 0x82, 0x82, 0x80, 0x76, 0x77, 0x7c, 0x77, 0x75, 0x72, 0x75,
			0x75, 0x75, 0x79, 0x77, 0x7c, 0x82, 0x84, 0x86, 0x89, 0x8d, 0x8c,
			0x8d, 0x8b, 0x8b, 0x89, 0x8a, 0x86, 0x84, 0x83, 0x82, 0x82, 0x7e,
			0x7f, 0x7c, 0x7d, 0x7e, 0x7c, 0x7a, 0x7c, 0x7c, 0x7b, 0x7b, 0x7c,
			0x7c, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f, 0x81, 0x80, 0x80, 0x80, 0x82,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7d, 0x7e, 0x7e, 0x7e, 0x7c,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7e, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7f, 0x81, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81,
			0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7d, 0x7f, 0x7e, 0x7d, 0x7e,
			0x7d, 0x7f, 0x7e, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x81, 0x83, 0x82,
			0x83, 0x82, 0x84, 0x82, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x7f,
			0x81, 0x7f, 0x7e, 0x80, 0x7e, 0x7e, 0x7c, 0x7d, 0x7d, 0x7c, 0x7d,
			0x7b, 0x7c, 0x7d, 0x7d, 0x7c, 0x7e, 0x7d, 0x80, 0x7d, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x7f,
			0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7e, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x7f, 0x81, 0x81,
			0x82, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7d, 0x7f, 0x7d, 0x7f, 0x7e, 0x7f, 0x7f, 0x80,
			0x7f, 0x81, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7d,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7f, 0x7d, 0x7d, 0x7f, 0x7e, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x81, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7d, 0x7f, 0x7d, 0x7e, 0x7d, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x7f,
			0x80, 0x7f, 0x81, 0x81, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7d, 0x7d,
			0x7d, 0x7c, 0x7d, 0x7c, 0x7d, 0x7e, 0x7d, 0x7f, 0x7e, 0x80, 0x80,
			0x81, 0x82, 0x81, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7d, 0x7e, 0x7f, 0x7f, 0x7d, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7e, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7e, 0x80, 0x7e, 0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7f, 0x7d, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x80,
			0x7e, 0x80, 0x7e, 0x7e, 0x81, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7d, 0x7f, 0x7e, 0x7d, 0x7c, 0x77, 0x82, 0x82,
			0x7e, 0x80, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x83, 0x7f, 0x7c,
			0x86, 0x75, 0x7c, 0x85, 0x81, 0x85, 0x84, 0x82, 0x7b, 0x7e, 0x81,
			0x80, 0x7f, 0x7b, 0x7d, 0x7e, 0x7d, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x81, 0x80, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x7e,
			0x7f, 0x7e, 0x7e, 0x80, 0x7c, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x79, 0x7c, 0x82, 0x82, 0x82, 0x84, 0x81, 0x80, 0x81, 0x78, 0x7f,
			0x7e, 0x7f, 0x7c, 0x79, 0x7e, 0x7d, 0x7f, 0x75, 0x7f, 0x85, 0x82,
			0x85, 0x86, 0x85, 0x83, 0x7f, 0x7c, 0x82, 0x83, 0x81, 0x80, 0x7e,
			0x80, 0x7d, 0x7b, 0x7c, 0x7c, 0x7d, 0x7c, 0x78, 0x7b, 0x7c, 0x7e,
			0x7e, 0x7d, 0x80, 0x81, 0x81, 0x80, 0x83, 0x84, 0x82, 0x81, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7c, 0x7f, 0x7d, 0x7f, 0x7d, 0x7e, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7d, 0x7e,
			0x7f, 0x7c, 0x7e, 0x7f, 0x80, 0x80, 0x7d, 0x81, 0x7f, 0x7d, 0x81,
			0x7e, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x82, 0x7e, 0x81, 0x83, 0x80,
			0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7d, 0x7c,
			0x81, 0x7c, 0x7d, 0x7f, 0x7a, 0x80, 0x81, 0x7c, 0x7e, 0x83, 0x80,
			0x7d, 0x7f, 0x83, 0x81, 0x81, 0x7f, 0x7f, 0x7f, 0x81, 0x7a, 0x7e,
			0x81, 0x7d, 0x7d, 0x7c, 0x7e, 0x7f, 0x7d, 0x7d, 0x81, 0x7d, 0x7f,
			0x7d, 0x7b, 0x7c, 0x7a, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7f, 0x7e,
			0x82, 0x84, 0x85, 0x87, 0x89, 0x8a, 0x8b, 0x8d, 0x88, 0x8a, 0x8a,
			0x85, 0x84, 0x83, 0x83, 0x7f, 0x80, 0x7e, 0x81, 0x7e, 0x7b, 0x7d,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7f, 0x7d, 0x7f, 0x80, 0x7f, 0x80, 0x6d,
			0x58, 0x70, 0x77, 0x59, 0x5e, 0x65, 0x6f, 0x71, 0x75, 0x7e, 0x7b,
			0x93, 0xa3, 0x94, 0x92, 0xa3, 0xab, 0x9e, 0x94, 0x98, 0x92, 0x8e,
			0x89, 0x79, 0x72, 0x76, 0x6d, 0x64, 0x69, 0x6b, 0x6e, 0x72, 0x7c,
			0x7e, 0x82, 0x8f, 0x8d, 0x90, 0x92, 0x96, 0x93, 0x8e, 0x90, 0x89,
			0x87, 0x82, 0x7d, 0x7a, 0x7a, 0x7d, 0x78, 0x7e, 0x7d, 0x7c, 0x6c,
			0x40, 0x65, 0x7c, 0x45, 0x4b, 0x58, 0x67, 0x6c, 0x64, 0x82, 0x7a,
			0x8f, 0xb6, 0x9d, 0x96, 0xb3, 0xbf, 0xac, 0x96, 0x9d, 0xa2, 0x89,
			0x84, 0x7f, 0x63, 0x72, 0x77, 0x61, 0x58, 0x60, 0x74, 0x60, 0x62,
			0x7d, 0x76, 0x82, 0x89, 0x8f, 0x8e, 0x96, 0xa3, 0x8d, 0x93, 0x9d,
			0x94, 0x8a, 0x8b, 0x91, 0x7f, 0x7e, 0x87, 0x7d, 0x7e, 0x82, 0x81,
			0x7d, 0x6c, 0x44, 0x5c, 0x7d, 0x3e, 0x3f, 0x55, 0x5e, 0x69, 0x52,
			0x7a, 0x7e, 0x89, 0xb5, 0x98, 0x9c, 0xbd, 0xc5, 0xb3, 0x98, 0xab,
			0xb1, 0x8e, 0x80, 0x81, 0x6d, 0x71, 0x6e, 0x54, 0x59, 0x5e, 0x73,
			0x64, 0x57, 0x77, 0x77, 0x7e, 0x81, 0x83, 0x94, 0x91, 0x9c, 0x8d,
			0x8f, 0xa0, 0x94, 0x8c, 0x8a, 0x93, 0x90, 0x80, 0x84, 0x83, 0x86,
			0x85, 0x80, 0x84, 0x7e, 0x81, 0x58, 0x40, 0x78, 0x64, 0x31, 0x48,
			0x57, 0x66, 0x57, 0x5d, 0x81, 0x7d, 0x9c, 0xab, 0x90, 0xad, 0xc8,
			0xbb, 0xa6, 0x9e, 0xb9, 0xa8, 0x7f, 0x84, 0x7e, 0x6f, 0x73, 0x5d,
			0x56, 0x5e, 0x65, 0x6b, 0x53, 0x6a, 0x87, 0x75, 0x78, 0x81, 0x90,
			0x92, 0x87, 0x92, 0x8c, 0x96, 0x95, 0x83, 0x89, 0x90, 0x8f, 0x7f,
			0x81, 0x91, 0x84, 0x80, 0x84, 0x88, 0x89, 0x85, 0x89, 0x80, 0x71,
			0x56, 0x60, 0x73, 0x42, 0x41, 0x58, 0x57, 0x5a, 0x54, 0x6f, 0x7e,
			0x83, 0x9e, 0x99, 0x9f, 0xbd, 0xbb, 0xab, 0xa7, 0xb4, 0xb0, 0x91,
			0x85, 0x8d, 0x7b, 0x71, 0x6a, 0x59, 0x62, 0x61, 0x61, 0x5c, 0x60,
			0x7b, 0x76, 0x6f, 0x81, 0x8a, 0x89, 0x86, 0x8f, 0x8e, 0x8c, 0x93,
			0x89, 0x86, 0x8b, 0x8b, 0x82, 0x7f, 0x8b, 0x87, 0x84, 0x83, 0x87,
			0x8b, 0x87, 0x88, 0x89, 0x88, 0x84, 0x76, 0x5a, 0x57, 0x74, 0x54,
			0x35, 0x53, 0x5c, 0x5b, 0x51, 0x62, 0x80, 0x8e, 0x93, 0xab, 0xaa,
			0x9c, 0xb3, 0xb5, 0xa2, 0x9e, 0x9d, 0x95, 0x8a, 0x7a, 0x79, 0x70,
			0x6d, 0x67, 0x59, 0x69, 0x6b, 0x60, 0x68, 0x72, 0x7e, 0x7d, 0x7f,
			0x8a, 0x8d, 0x93, 0x8c, 0x8c, 0x95, 0x89, 0x83, 0x82, 0x82, 0x78,
			0x74, 0x78, 0x73, 0x76, 0x75, 0x79, 0x80, 0x83, 0x84, 0x89, 0x90,
			0x91, 0x90, 0x95, 0x93, 0x93, 0x91, 0x8d, 0x82, 0x70, 0x61, 0x6b,
			0x64, 0x3c, 0x51, 0x5a, 0x49, 0x54, 0x57, 0x69, 0x77, 0x7e, 0x8a,
			0x93, 0xad, 0xae, 0xa2, 0xb7, 0xba, 0xaa, 0xa7, 0xa0, 0x9a, 0x92,
			0x7f, 0x79, 0x72, 0x6e, 0x66, 0x58, 0x65, 0x67, 0x5f, 0x66, 0x6d,
			0x79, 0x79, 0x7c, 0x85, 0x89, 0x8e, 0x8c, 0x85, 0x93, 0x8d, 0x7f,
			0x83, 0x87, 0x7c, 0x75, 0x7d, 0x7b, 0x79, 0x7d, 0x7e, 0x82, 0x87,
			0x86, 0x8a, 0x91, 0x90, 0x8a, 0x91, 0x90, 0x8a, 0x89, 0x87, 0x87,
			0x7d, 0x73, 0x60, 0x5a, 0x71, 0x4e, 0x3d, 0x60, 0x56, 0x51, 0x5b,
			0x66, 0x79, 0x7c, 0x8a, 0x91, 0xa0, 0xb5, 0xa8, 0xa5, 0xbf, 0xb5,
			0xa5, 0xa3, 0x9e, 0x9a, 0x87, 0x7d, 0x77, 0x6c, 0x6f, 0x5c, 0x58,
			0x68, 0x63, 0x5d, 0x64, 0x6e, 0x76, 0x73, 0x7c, 0x85, 0x89, 0x8e,
			0x8b, 0x90, 0x95, 0x8c, 0x8c, 0x8a, 0x89, 0x82, 0x7f, 0x7f, 0x7d,
			0x7e, 0x79, 0x7d, 0x7e, 0x7f, 0x7c, 0x80, 0x84, 0x7f, 0x81, 0x7f,
			0x7f, 0x80, 0x80, 0x7d, 0x7f, 0x81, 0x7f, 0x7e, 0x7f, 0x7d, 0x77,
			0x73, 0x7d, 0x72, 0x6c, 0x73, 0x70, 0x70, 0x71, 0x74, 0x78, 0x79,
			0x81, 0x82, 0x82, 0x8d, 0x8e, 0x8b, 0x92, 0x92, 0x91, 0x8f, 0x8f,
			0x8f, 0x89, 0x8a, 0x87, 0x7f, 0x82, 0x7f, 0x7b, 0x79, 0x7b, 0x79,
			0x75, 0x77, 0x79, 0x78, 0x77, 0x7b, 0x79, 0x7b, 0x7d, 0x7b, 0x7d,
			0x7e, 0x81, 0x7d, 0x7d, 0x82, 0x7d, 0x7e, 0x80, 0x81, 0x80, 0x80,
			0x81, 0x7f, 0x82, 0x81, 0x81, 0x82, 0x84, 0x81, 0x81, 0x82, 0x82,
			0x80, 0x83, 0x81, 0x81, 0x80, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7f,
			0x80, 0x7d, 0x7d, 0x7d, 0x78, 0x77, 0x7b, 0x76, 0x6f, 0x76, 0x72,
			0x72, 0x74, 0x75, 0x76, 0x79, 0x7e, 0x7f, 0x7f, 0x89, 0x89, 0x88,
			0x8f, 0x91, 0x8e, 0x90, 0x8e, 0x8e, 0x89, 0x8a, 0x87, 0x80, 0x83,
			0x7f, 0x7a, 0x7b, 0x7c, 0x77, 0x77, 0x78, 0x7a, 0x77, 0x79, 0x7a,
			0x78, 0x7b, 0x7a, 0x7a, 0x7e, 0x7d, 0x7d, 0x7d, 0x81, 0x81, 0x7d,
			0x82, 0x85, 0x7d, 0x82, 0x81, 0x80, 0x7e, 0x81, 0x80, 0x7d, 0x82,
			0x7e, 0x80, 0x82, 0x7f, 0x80, 0x81, 0x83, 0x7f, 0x83, 0x83, 0x83,
			0x81, 0x84, 0x82, 0x83, 0x82, 0x80, 0x82, 0x82, 0x80, 0x80, 0x80,
			0x7d, 0x7b, 0x73, 0x70, 0x7a, 0x6c, 0x67, 0x74, 0x6c, 0x6e, 0x71,
			0x74, 0x79, 0x7d, 0x81, 0x84, 0x8c, 0x91, 0x8d, 0x92, 0x9b, 0x92,
			0x92, 0x94, 0x8f, 0x8d, 0x87, 0x82, 0x81, 0x7c, 0x78, 0x73, 0x75,
			0x75, 0x6e, 0x72, 0x74, 0x75, 0x76, 0x77, 0x7b, 0x80, 0x7e, 0x81,
			0x82, 0x86, 0x84, 0x83, 0x85, 0x85, 0x82, 0x80, 0x81, 0x7d, 0x7c,
			0x7a, 0x78, 0x78, 0x77, 0x78, 0x79, 0x7b, 0x7c, 0x81, 0x84, 0x84,
			0x87, 0x8a, 0x8b, 0x8b, 0x8a, 0x8b, 0x8a, 0x86, 0x85, 0x82, 0x83,
			0x80, 0x7f, 0x80, 0x7d, 0x7d, 0x7f, 0x78, 0x7a, 0x6c, 0x5b, 0x81,
			0x64, 0x4a, 0x7c, 0x61, 0x60, 0x71, 0x6c, 0x82, 0x80, 0x85, 0x90,
			0x99, 0xa4, 0x92, 0x9f, 0xae, 0x95, 0x98, 0x9c, 0x8c, 0x90, 0x7e,
			0x7a, 0x81, 0x6f, 0x6d, 0x6a, 0x70, 0x69, 0x64, 0x73, 0x71, 0x71,
			0x79, 0x78, 0x85, 0x85, 0x80, 0x8e, 0x8e, 0x8b, 0x89, 0x8c, 0x8f,
			0x84, 0x84, 0x81, 0x7c, 0x7b, 0x72, 0x70, 0x73, 0x6b, 0x6d, 0x6f,
			0x73, 0x75, 0x7a, 0x80, 0x85, 0x8a, 0x8d, 0x92, 0x93, 0x92, 0x93,
			0x93, 0x8e, 0x89, 0x88, 0x84, 0x7e, 0x7a, 0x79, 0x78, 0x75, 0x76,
			0x78, 0x7e, 0x7a, 0x7c, 0x7c, 0x83, 0x68, 0x5c, 0x95, 0x55, 0x4e,
			0x8b, 0x57, 0x69, 0x73, 0x6a, 0x8d, 0x7f, 0x84, 0x97, 0x9f, 0x9e,
			0x90, 0xa7, 0xab, 0x89, 0x9c, 0x95, 0x86, 0x8d, 0x6f, 0x7e, 0x7c,
			0x64, 0x6d, 0x6f, 0x6f, 0x69, 0x6d, 0x7d, 0x75, 0x79, 0x80, 0x83,
			0x8e, 0x83, 0x86, 0x99, 0x8a, 0x86, 0x8c, 0x8b, 0x86, 0x7a, 0x7f,
			0x7b, 0x74, 0x71, 0x69, 0x73, 0x70, 0x62, 0x71, 0x7b, 0x6e, 0x76,
			0x85, 0x84, 0x82, 0x8b, 0x91, 0x92, 0x8d, 0x91, 0x97, 0x90, 0x85,
			0x8c, 0x8d, 0x80, 0x7d, 0x82, 0x7e, 0x78, 0x77, 0x7c, 0x7a, 0x77,
			0x79, 0x81, 0x7f, 0x79, 0x80, 0x7e, 0x7c, 0x6a, 0x61, 0x7f, 0x60,
			0x4e, 0x75, 0x62, 0x65, 0x6e, 0x6e, 0x89, 0x82, 0x86, 0x9b, 0xa1,
			0xa2, 0x9b, 0xaa, 0xac, 0x95, 0x9b, 0x99, 0x8c, 0x87, 0x75, 0x7b,
			0x75, 0x63, 0x68, 0x69, 0x6a, 0x63, 0x69, 0x77, 0x75, 0x77, 0x82,
			0x87, 0x8e, 0x87, 0x8f, 0x98, 0x8c, 0x8b, 0x8c, 0x8c, 0x84, 0x79,
			0x7d, 0x78, 0x72, 0x6e, 0x6f, 0x6f, 0x6c, 0x6f, 0x70, 0x77, 0x78,
			0x79, 0x82, 0x84, 0x85, 0x86, 0x90, 0x8b, 0x88, 0x8e, 0x8c, 0x89,
			0x85, 0x87, 0x86, 0x80, 0x81, 0x80, 0x82, 0x7c, 0x7f, 0x83, 0x7f,
			0x7e, 0x80, 0x83, 0x82, 0x7f, 0x85, 0x83, 0x81, 0x7c, 0x7c, 0x71,
			0x56, 0x7c, 0x63, 0x42, 0x75, 0x5d, 0x5c, 0x6f, 0x6b, 0x83, 0x82,
			0x8b, 0x9a, 0xa3, 0xa7, 0x9e, 0xae, 0xb0, 0x97, 0xa0, 0x9a, 0x8a,
			0x88, 0x73, 0x79, 0x73, 0x62, 0x65, 0x68, 0x6a, 0x61, 0x6b, 0x78,
			0x73, 0x79, 0x83, 0x86, 0x8f, 0x87, 0x8d, 0x95, 0x8c, 0x88, 0x89,
			0x88, 0x80, 0x79, 0x7d, 0x75, 0x73, 0x6f, 0x71, 0x74, 0x71, 0x6c,
			0x7a, 0x7c, 0x74, 0x7e, 0x86, 0x86, 0x85, 0x88, 0x90, 0x89, 0x88,
			0x89, 0x8b, 0x85, 0x7f, 0x86, 0x82, 0x7e, 0x7e, 0x81, 0x80, 0x7c,
			0x81, 0x83, 0x81, 0x7f, 0x83, 0x83, 0x7e, 0x81, 0x81, 0x81, 0x7d,
			0x80, 0x7e, 0x80, 0x75, 0x72, 0x6b, 0x63, 0x73, 0x55, 0x5f, 0x73,
			0x5f, 0x70, 0x75, 0x80, 0x87, 0x89, 0x9a, 0x9e, 0xa2, 0xa1, 0xa0,
			0xa7, 0x9a, 0x91, 0x93, 0x85, 0x80, 0x75, 0x70, 0x73, 0x65, 0x66,
			0x6d, 0x6e, 0x6e, 0x72, 0x80, 0x7f, 0x82, 0x89, 0x8f, 0x90, 0x8b,
			0x8e, 0x8f, 0x88, 0x83, 0x81, 0x81, 0x7a, 0x73, 0x76, 0x75, 0x72,
			0x70, 0x74, 0x76, 0x73, 0x75, 0x7c, 0x7d, 0x79, 0x7e, 0x85, 0x81,
			0x81, 0x86, 0x89, 0x85, 0x87, 0x89, 0x89, 0x85, 0x86, 0x87, 0x85,
			0x81, 0x81, 0x82, 0x7c, 0x7c, 0x7e, 0x7e, 0x7b, 0x7b, 0x7e, 0x7c,
			0x7c, 0x7e, 0x80, 0x80, 0x7f, 0x82, 0x82, 0x81, 0x80, 0x82, 0x82,
			0x78, 0x65, 0x78, 0x6f, 0x58, 0x6b, 0x6f, 0x68, 0x6e, 0x7a, 0x81,
			0x84, 0x8c, 0x92, 0x9e, 0x9a, 0x97, 0x9f, 0x98, 0x90, 0x8d, 0x8c,
			0x81, 0x7b, 0x78, 0x76, 0x74, 0x70, 0x72, 0x79, 0x77, 0x78, 0x7f,
			0x83, 0x80, 0x84, 0x88, 0x87, 0x85, 0x83, 0x84, 0x82, 0x7e, 0x7b,
			0x7f, 0x7b, 0x76, 0x7b, 0x79, 0x77, 0x77, 0x78, 0x78, 0x76, 0x78,
			0x7c, 0x7b, 0x7a, 0x7f, 0x82, 0x82, 0x84, 0x88, 0x8a, 0x88, 0x8a,
			0x8b, 0x8a, 0x86, 0x84, 0x85, 0x80, 0x7d, 0x7c, 0x7d, 0x79, 0x79,
			0x7a, 0x7d, 0x7b, 0x7d, 0x80, 0x80, 0x81, 0x81, 0x83, 0x84, 0x80,
			0x83, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7a, 0x7f, 0x71, 0x66, 0x7f,
			0x68, 0x62, 0x73, 0x71, 0x6f, 0x75, 0x80, 0x7f, 0x8a, 0x89, 0x8f,
			0x99, 0x90, 0x92, 0x96, 0x91, 0x89, 0x8d, 0x88, 0x82, 0x82, 0x7d,
			0x7e, 0x7d, 0x78, 0x7c, 0x7c, 0x78, 0x78, 0x7e, 0x7a, 0x79, 0x7c,
			0x7d, 0x7e, 0x7c, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x83, 0x7f, 0x80,
			0x81, 0x7d, 0x7c, 0x7b, 0x7c, 0x79, 0x7a, 0x7a, 0x7d, 0x7c, 0x7e,
			0x80, 0x82, 0x82, 0x84, 0x84, 0x85, 0x84, 0x83, 0x84, 0x82, 0x81,
			0x7f, 0x7f, 0x7c, 0x7d, 0x7d, 0x7d, 0x7c, 0x7e, 0x7e, 0x7f, 0x80,
			0x7e, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x7e, 0x7f, 0x7e, 0x7c, 0x7d,
			0x7d, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7f, 0x7e, 0x7f, 0x80, 0x81,
			0x81, 0x7e, 0x7e, 0x80, 0x7e, 0x7d, 0x7f, 0x80, 0x7d, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x81, 0x81, 0x82, 0x82, 0x84,
			0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x80, 0x7f, 0x7d,
			0x80, 0x7e, 0x7d, 0x7c, 0x7f, 0x7d, 0x7d, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x7d, 0x7e,
			0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x81, 0x81, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x7e,
			0x7d, 0x7d, 0x7e, 0x7b, 0x7b, 0x7d, 0x7b, 0x7a, 0x7c, 0x7b, 0x7c,
			0x7c, 0x7e, 0x7d, 0x80, 0x7f, 0x81, 0x81, 0x82, 0x81, 0x83, 0x82,
			0x80, 0x82, 0x81, 0x81, 0x80, 0x81, 0x81, 0x82, 0x80, 0x81, 0x82,
			0x80, 0x81, 0x80, 0x82, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7c, 0x7e, 0x7e, 0x7d,
			0x7e, 0x7c, 0x7e, 0x7f, 0x7e, 0x7d, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d,
			0x7e, 0x7c, 0x7c, 0x7c, 0x7d, 0x7c, 0x7d, 0x7d, 0x7f, 0x7e, 0x80,
			0x81, 0x82, 0x81, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x83, 0x81,
			0x82, 0x80, 0x80, 0x7e, 0x7f, 0x7e, 0x7c, 0x7e, 0x7d, 0x7e, 0x7d,
			0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81,
			0x80,
		},
		{ // 5
			0x7f, 0x7f, 0x7f, 0x7c, 0x7a, 0x7c, 0x7d, 0x7a, 0x7b, 0x81, 0x83,
			0x82, 0x85, 0x87, 0x87, 0x88, 0x87, 0x84, 0x83, 0x84, 0x81, 0x7c,
			0x7c, 0x7f, 0x7d, 0x7a, 0x7c, 0x7f, 0x7e, 0x7e, 0x81, 0x82, 0x82,
			0x83, 0x82, 0x82, 0x83, 0x81, 0x7e, 0x7e, 0x7f, 0x7c, 0x7b, 0x7c,
			0x7c, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x82, 0x81, 0x82, 0x81, 0x82, 0x82, 0x82, 0x82,
			0x81, 0x82, 0x81, 0x83, 0x83, 0x83, 0x83, 0x83, 0x85, 0x84, 0x84,
			0x85, 0x85, 0x83, 0x78, 0x5c, 0x68, 0x7a, 0x57, 0x5d, 0x6f, 0x69,
			0x7e, 0x81, 0x7e, 0x96, 0xa6, 0x9f, 0x99, 0xa1, 0xa2, 0x94, 0x89,
			0x7e, 0x74, 0x79, 0x6c, 0x5b, 0x69, 0x70, 0x6f, 0x73, 0x7e, 0x8b,
			0x92, 0x90, 0x91, 0x9a, 0x95, 0x89, 0x84, 0x82, 0x7b, 0x74, 0x6e,
			0x71, 0x7a, 0x77, 0x7d, 0x8a, 0x8d, 0x91, 0x98, 0x99, 0x98, 0x92,
			0x54, 0x4f, 0x83, 0x49, 0x34, 0x5b, 0x52, 0x70, 0x82, 0x74, 0x95,
			0xbe, 0xb8, 0xa4, 0xa3, 0xaf, 0xa2, 0x7b, 0x6d, 0x62, 0x64, 0x67,
			0x46, 0x56, 0x7c, 0x81, 0x89, 0x8d, 0xa2, 0xb5, 0xa7, 0x94, 0x89,
			0x8f, 0x7f, 0x5b, 0x56, 0x60, 0x62, 0x59, 0x66, 0x80, 0x90, 0x95,
			0x96, 0xa5, 0xaa, 0x9c, 0x8a, 0x87, 0x87, 0x78, 0x6d, 0x6d, 0x76,
			0x7a, 0x7e, 0x85, 0x8b, 0x81, 0x50, 0x6a, 0x8b, 0x53, 0x5d, 0x72,
			0x6d, 0x8b, 0x8b, 0x7f, 0x99, 0xb0, 0x9f, 0x88, 0x87, 0x92, 0x81,
			0x66, 0x68, 0x67, 0x77, 0x7d, 0x68, 0x80, 0x9d, 0x98, 0x94, 0x8e,
			0x95, 0x96, 0x7e, 0x70, 0x6c, 0x72, 0x69, 0x59, 0x68, 0x7e, 0x81,
			0x7f, 0x8a, 0x98, 0x97, 0x8f, 0x87, 0x8b, 0x89, 0x7a, 0x74, 0x7b,
			0x81, 0x7e, 0x7f, 0x87, 0x8e, 0x91, 0x91, 0x92, 0x8f, 0x7f, 0x40,
			0x38, 0x78, 0x52, 0x3b, 0x72, 0x7c, 0x96, 0xb3, 0x98, 0x9d, 0xc4,
			0xa8, 0x75, 0x70, 0x6e, 0x67, 0x59, 0x4f, 0x65, 0x86, 0x9a, 0x90,
			0x94, 0xb5, 0xaf, 0x94, 0x82, 0x71, 0x73, 0x68, 0x50, 0x58, 0x71,
			0x7e, 0x82, 0x8c, 0x99, 0xa1, 0x97, 0x83, 0x7d, 0x7d, 0x6b, 0x61,
			0x6c, 0x7c, 0x84, 0x85, 0x8e, 0x97, 0x97, 0x8b, 0x81, 0x85, 0x85,
			0x7b, 0x79, 0x83, 0x89, 0x83, 0x81, 0x70, 0x41, 0x5c, 0x86, 0x53,
			0x5d, 0x89, 0x86, 0x9a, 0xa3, 0x8d, 0x92, 0xa8, 0x8a, 0x65, 0x70,
			0x72, 0x6d, 0x6f, 0x6f, 0x80, 0x96, 0x9d, 0x90, 0x8c, 0x9a, 0x8e,
			0x78, 0x6f, 0x69, 0x72, 0x75, 0x6f, 0x7b, 0x8b, 0x93, 0x8e, 0x85,
			0x86, 0x83, 0x6f, 0x65, 0x6d, 0x74, 0x77, 0x7e, 0x8b, 0x97, 0x9a,
			0x8e, 0x85, 0x89, 0x7f, 0x72, 0x72, 0x7a, 0x82, 0x84, 0x86, 0x8d,
			0x95, 0x92, 0x8d, 0x84, 0x7e, 0x56, 0x22, 0x5c, 0x79, 0x53, 0x78,
			0x96, 0x9f, 0xb9, 0xac, 0x85, 0x86, 0x96, 0x6b, 0x4b, 0x5f, 0x6c,
			0x7d, 0x88, 0x89, 0x9e, 0xb0, 0xa7, 0x86, 0x73, 0x7c, 0x6f, 0x5e,
			0x5d, 0x67, 0x84, 0x92, 0x90, 0x96, 0x9c, 0x99, 0x84, 0x69, 0x64,
			0x6c, 0x66, 0x62, 0x75, 0x8d, 0x96, 0x96, 0x93, 0x93, 0x91, 0x7c,
			0x6d, 0x74, 0x79, 0x76, 0x79, 0x84, 0x91, 0x8f, 0x8b, 0x87, 0x89,
			0x8f, 0x84, 0x7f, 0x7a, 0x75, 0x4d, 0x2b, 0x6f, 0x8a, 0x67, 0x87,
			0x9c, 0x9f, 0xb0, 0x99, 0x70, 0x78, 0x8b, 0x66, 0x54, 0x6d, 0x80,
			0x90, 0x8f, 0x8d, 0x99, 0xa2, 0x97, 0x73, 0x68, 0x79, 0x73, 0x6b,
			0x6e, 0x78, 0x93, 0x97, 0x8d, 0x8b, 0x8c, 0x89, 0x76, 0x64, 0x67,
			0x74, 0x7a, 0x7a, 0x81, 0x90, 0x94, 0x8c, 0x7f, 0x7d, 0x7f, 0x75,
			0x72, 0x7a, 0x86, 0x89, 0x86, 0x89, 0x8d, 0x89, 0x81, 0x7c, 0x81,
			0x86, 0x81, 0x82, 0x89, 0x8c, 0x84, 0x7c, 0x54, 0x2b, 0x70, 0x85,
			0x53, 0x7b, 0x9f, 0x9f, 0xaf, 0xa0, 0x7a, 0x87, 0x92, 0x63, 0x50,
			0x67, 0x7c, 0x83, 0x82, 0x90, 0x9e, 0xa8, 0x9f, 0x78, 0x75, 0x81,
			0x6e, 0x65, 0x67, 0x79, 0x8f, 0x8e, 0x8c, 0x8e, 0x93, 0x8b, 0x74,
			0x67, 0x6b, 0x6f, 0x6f, 0x78, 0x87, 0x90, 0x96, 0x90, 0x86, 0x83,
			0x7a, 0x70, 0x6e, 0x77, 0x7f, 0x81, 0x87, 0x8d, 0x90, 0x8c, 0x84,
			0x81, 0x80, 0x7e, 0x7c, 0x7c, 0x7f, 0x86, 0x89, 0x89, 0x89, 0x86,
			0x75, 0x38, 0x3f, 0x8a, 0x6a, 0x5b, 0x92, 0x9b, 0xa6, 0xb1, 0x88,
			0x7d, 0x96, 0x79, 0x55, 0x56, 0x72, 0x82, 0x7a, 0x8a, 0x99, 0xa6,
			0xad, 0x86, 0x77, 0x84, 0x75, 0x65, 0x5d, 0x6b, 0x85, 0x87, 0x88,
			0x93, 0x9d, 0x9c, 0x85, 0x72, 0x74, 0x71, 0x67, 0x63, 0x68, 0x80,
			0x91, 0x8c, 0x8b, 0x96, 0x91, 0x7d, 0x72, 0x71, 0x74, 0x73, 0x74,
			0x7e, 0x8f, 0x8f, 0x88, 0x8c, 0x8f, 0x86, 0x7c, 0x7b, 0x7d, 0x7f,
			0x7b, 0x7d, 0x86, 0x8c, 0x8c, 0x8c, 0x8b, 0x86, 0x6f, 0x32, 0x44,
			0x81, 0x55, 0x56, 0x90, 0x96, 0xac, 0xad, 0x8c, 0x99, 0xa0, 0x7a,
			0x58, 0x5c, 0x77, 0x6c, 0x6a, 0x83, 0x93, 0xae, 0xa3, 0x8a, 0x98,
			0x95, 0x79, 0x66, 0x60, 0x6f, 0x72, 0x6c, 0x78, 0x8c, 0x9c, 0x91,
			0x85, 0x8d, 0x88, 0x79, 0x68, 0x63, 0x72, 0x6c, 0x6f, 0x87, 0x8c,
			0x91, 0x93, 0x8d, 0x89, 0x84, 0x75, 0x70, 0x75, 0x73, 0x76, 0x81,
			0x87, 0x8a, 0x8e, 0x8d, 0x8b, 0x86, 0x7d, 0x79, 0x7a, 0x78, 0x77,
			0x7c, 0x80, 0x84, 0x86, 0x88, 0x8b, 0x8c, 0x89, 0x80, 0x75, 0x4b,
			0x48, 0x7d, 0x5c, 0x53, 0x8a, 0x8b, 0x99, 0xa3, 0x92, 0xa4, 0xa5,
			0x88, 0x70, 0x72, 0x7c, 0x63, 0x5f, 0x73, 0x7c, 0x8e, 0x8a, 0x88,
			0xa2, 0x9d, 0x8c, 0x86, 0x81, 0x7e, 0x6d, 0x63, 0x6a, 0x74, 0x78,
			0x74, 0x84, 0x94, 0x90, 0x8e, 0x8d, 0x8c, 0x87, 0x76, 0x6f, 0x74,
			0x6f, 0x64, 0x74, 0x7e, 0x7d, 0x86, 0x89, 0x8c, 0x8f, 0x88, 0x82,
			0x81, 0x7b, 0x76, 0x79, 0x79, 0x7b, 0x80, 0x84, 0x86, 0x85, 0x87,
			0x89, 0x86, 0x80, 0x7f, 0x80, 0x7f, 0x7c, 0x7c, 0x7f, 0x80, 0x7f,
			0x83, 0x85, 0x87, 0x83, 0x7f, 0x6e, 0x51, 0x75, 0x73, 0x4d, 0x74,
			0x7b, 0x80, 0x94, 0x85, 0x9b, 0xa8, 0x96, 0x91, 0x8d, 0x8e, 0x7c,
			0x6d, 0x70, 0x6d, 0x73, 0x6d, 0x72, 0x89, 0x86, 0x8a, 0x95, 0x96,
			0x98, 0x8c, 0x84, 0x83, 0x7b, 0x6f, 0x66, 0x6e, 0x71, 0x6d, 0x74,
			0x7d, 0x89, 0x8c, 0x89, 0x90, 0x93, 0x8d, 0x84, 0x80, 0x7a, 0x75,
			0x73, 0x6d, 0x72, 0x76, 0x77, 0x7b, 0x80, 0x83, 0x87, 0x88, 0x88,
			0x8a, 0x8a, 0x88, 0x84, 0x80, 0x7f, 0x7c, 0x76, 0x76, 0x78, 0x7a,
			0x7e, 0x80, 0x87, 0x8b, 0x8b, 0x8a, 0x8a, 0x88, 0x83, 0x7e, 0x7c,
			0x7a, 0x78, 0x79, 0x77, 0x77, 0x60, 0x70, 0x83, 0x5b, 0x73, 0x7e,
			0x6f, 0x8a, 0x7a, 0x86, 0x9f, 0x8e, 0x91, 0x96, 0x97, 0x8d, 0x83,
			0x83, 0x7c, 0x7e, 0x70, 0x6f, 0x7f, 0x74, 0x78, 0x7d, 0x80, 0x88,
			0x80, 0x83, 0x8a, 0x8a, 0x86, 0x83, 0x8a, 0x85, 0x81, 0x7d, 0x79,
			0x7a, 0x71, 0x6f, 0x74, 0x74, 0x77, 0x79, 0x81, 0x88, 0x87, 0x88,
			0x8d, 0x8a, 0x86, 0x81, 0x7e, 0x7d, 0x76, 0x75, 0x79, 0x7a, 0x7a,
			0x7e, 0x81, 0x83, 0x84, 0x85, 0x85, 0x83, 0x83, 0x84, 0x82, 0x81,
			0x83, 0x83, 0x82, 0x80, 0x7f, 0x82, 0x7f, 0x7b, 0x7c, 0x7d, 0x7c,
			0x7a, 0x7e, 0x82, 0x83, 0x83, 0x86, 0x86, 0x85, 0x7d, 0x73, 0x7d,
			0x74, 0x69, 0x72, 0x6d, 0x71, 0x76, 0x75, 0x80, 0x85, 0x84, 0x8b,
			0x8f, 0x8d, 0x8e, 0x8b, 0x8a, 0x8c, 0x86, 0x85, 0x88, 0x84, 0x83,
			0x84, 0x82, 0x81, 0x7e, 0x7b, 0x7a, 0x79, 0x77, 0x78, 0x79, 0x7a,
			0x7c, 0x7c, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81,
			0x82, 0x82, 0x82, 0x81, 0x82, 0x80, 0x7e, 0x7e, 0x7c, 0x7b, 0x7c,
			0x7c, 0x7e, 0x80, 0x82, 0x82, 0x82, 0x82, 0x80, 0x80, 0x7e, 0x7d,
			0x7e, 0x7e, 0x7f, 0x82, 0x83, 0x83, 0x84, 0x83, 0x82, 0x82, 0x80,
			0x7e, 0x7f, 0x7e, 0x7c, 0x7c, 0x7d, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x80, 0x7f, 0x81, 0x7f, 0x7f,
			0x84, 0x81, 0x7e, 0x7e, 0x80, 0x81, 0x81, 0x80, 0x80, 0x83, 0x82,
			0x81, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7d, 0x7b, 0x7a,
			0x7b, 0x7c, 0x7c, 0x7d, 0x7f, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81,
			0x7f, 0x7d, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x82, 0x82, 0x82, 0x82,
			0x82, 0x82, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7c, 0x7d, 0x7e, 0x7d, 0x7f, 0x7f, 0x80, 0x82, 0x82, 0x82,
			0x81, 0x7f, 0x80, 0x7e, 0x7d, 0x7d, 0x7e, 0x80, 0x80, 0x80, 0x82,
			0x83, 0x82, 0x81, 0x80, 0x80, 0x81, 0x7f, 0x7d, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7e, 0x7f, 0x81, 0x84, 0x84, 0x84, 0x83, 0x83, 0x80, 0x7d,
			0x7b, 0x7b, 0x7a, 0x7a, 0x7c, 0x7f, 0x81, 0x82, 0x82, 0x83, 0x83,
			0x82, 0x80, 0x7f, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x80, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x81,
			0x82, 0x82, 0x81, 0x80, 0x7f, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x80,
			0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x81, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x81,
			0x80, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7e, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x81, 0x80, 0x80,
			0x81, 0x81, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x81,
			0x81, 0x82, 0x82, 0x82, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x81,
			0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7f, 0x81,
			0x81, 0x82, 0x83, 0x84, 0x83, 0x81, 0x80, 0x7f, 0x7e, 0x7c, 0x7c,
			0x7d, 0x7e, 0x7f, 0x7f, 0x81, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7f,
			0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x82,
			0x81, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e,
			0x80, 0x81, 0x82, 0x81, 0x80, 0x81, 0x81, 0x7f, 0x7e, 0x7e, 0x7f,
			0x7e, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7d, 0x7c,
			0x7f, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x81, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x81,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7d,
			0x7e, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x80, 0x7f,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x80, 0x82, 0x81,
			0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x80, 0x7f, 0x80, 0x81,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x7f, 0x7e, 0x80, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x80, 0x7f,
			0x81, 0x7f, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x80, 0x81, 0x7e, 0x82,
			0x7e, 0x7e, 0x82, 0x7c, 0x80, 0x82, 0x7f, 0x80, 0x80, 0x7d, 0x7f,
			0x80, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x7e, 0x7f,
			0x7f, 0x7d, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x7f, 0x82,
			0x80, 0x7f, 0x82, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x81, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x7e,
			0x81, 0x7f, 0x7e, 0x81, 0x7f, 0x7e, 0x81, 0x7e, 0x7f, 0x81, 0x7d,
			0x80, 0x82, 0x7e, 0x81, 0x81, 0x7c, 0x83, 0x7f, 0x7e, 0x7f, 0x7e,
			0x80, 0x7e, 0x7f, 0x81, 0x80, 0x81, 0x81, 0x7f, 0x81, 0x7f, 0x7f,
			0x7e, 0x80, 0x7d, 0x81, 0x7f, 0x7f, 0x83, 0x7d, 0x80, 0x81, 0x7e,
			0x7f, 0x80, 0x7c, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x81, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x81,
			0x82, 0x7d, 0x80, 0x80, 0x7d, 0x82, 0x7e, 0x7e, 0x81, 0x7f, 0x80,
			0x80, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x81,
			0x7f, 0x7f, 0x81, 0x7e, 0x82, 0x80, 0x80, 0x81, 0x7f, 0x7f, 0x7f,
			0x80, 0x7e, 0x7f, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x7e,
			0x7f, 0x80, 0x7d, 0x81, 0x7f, 0x7f, 0x82, 0x7f, 0x80, 0x82, 0x7e,
			0x7f, 0x80, 0x7d, 0x80, 0x7f, 0x7e, 0x81, 0x81, 0x7f, 0x82, 0x7f,
			0x80, 0x81, 0x7d, 0x80, 0x7d, 0x80, 0x80, 0x7e, 0x81, 0x81, 0x7f,
			0x80, 0x80, 0x7f, 0x81, 0x7d, 0x7e, 0x82, 0x7e, 0x7f, 0x81, 0x7f,
			0x82, 0x81, 0x7d, 0x82, 0x7f, 0x7f, 0x80, 0x7d, 0x80, 0x82, 0x7e,
			0x81, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x7f,
			0x81, 0x7e, 0x80, 0x81, 0x7d, 0x80, 0x7f, 0x7e, 0x80, 0x80, 0x80,
			0x7f, 0x81, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x7f, 0x7f, 0x80,
			0x7d, 0x80, 0x7e, 0x7e, 0x81, 0x7e, 0x81, 0x7f, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x80, 0x7f,
			0x82, 0x7d, 0x80, 0x80, 0x7d, 0x7f, 0x80, 0x7d, 0x81, 0x81, 0x7e,
			0x82, 0x80, 0x80, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x7e, 0x80,
			0x80, 0x7e, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x81, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x81, 0x7d, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7f,
			0x80, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x7e, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x81,
			0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80,
		},
		{ // 6
			0x80, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x81, 0x80, 0x7f, 0x7e, 0x7f,
			0x81, 0x80, 0x7f, 0x7e, 0x7f, 0x81, 0x80, 0x7f, 0x7e, 0x7f, 0x81,
			0x81, 0x7f, 0x7e, 0x7f, 0x81, 0x81, 0x7f, 0x7e, 0x7e, 0x81, 0x81,
			0x80, 0x7e, 0x7d, 0x80, 0x82, 0x81, 0x7d, 0x7d, 0x80, 0x83, 0x80,
			0x7d, 0x7d, 0x81, 0x82, 0x7f, 0x7d, 0x7f, 0x82, 0x81, 0x7e, 0x7e,
			0x80, 0x82, 0x80, 0x7d, 0x7e, 0x82, 0x82, 0x7f, 0x7c, 0x7f, 0x82,
			0x81, 0x7e, 0x7d, 0x80, 0x82, 0x80, 0x7e, 0x7e, 0x80, 0x81, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x7e, 0x80, 0x81, 0x80, 0x7e,
			0x7e, 0x80, 0x81, 0x80, 0x7e, 0x7e, 0x81, 0x81, 0x7f, 0x7d, 0x7e,
			0x81, 0x82, 0x80, 0x7c, 0x7d, 0x82, 0x83, 0x7e, 0x7c, 0x7f, 0x83,
			0x81, 0x7d, 0x7e, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x80,
			0x7f, 0x7e, 0x80, 0x82, 0x7f, 0x7d, 0x7f, 0x81, 0x80, 0x80, 0x7e,
			0x7e, 0x80, 0x82, 0x7f, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7e, 0x7f, 0x82, 0x81, 0x7c, 0x7e, 0x82, 0x80, 0x7d, 0x80, 0x81,
			0x7d, 0x7f, 0x83, 0x80, 0x7d, 0x7d, 0x82, 0x84, 0x7e, 0x7b, 0x80,
			0x82, 0x80, 0x7e, 0x80, 0x7f, 0x7e, 0x80, 0x83, 0x81, 0x7a, 0x7d,
			0x85, 0x82, 0x7c, 0x7c, 0x81, 0x82, 0x7e, 0x80, 0x80, 0x7d, 0x7e,
			0x83, 0x83, 0x7a, 0x7b, 0x84, 0x85, 0x7c, 0x7b, 0x81, 0x82, 0x80,
			0x7e, 0x7f, 0x80, 0x7e, 0x82, 0x83, 0x7b, 0x7c, 0x84, 0x82, 0x7d,
			0x7e, 0x7e, 0x83, 0x81, 0x7e, 0x7d, 0x7f, 0x84, 0x82, 0x7c, 0x79,
			0x82, 0x86, 0x7f, 0x7a, 0x7c, 0x85, 0x85, 0x7c, 0x7c, 0x7e, 0x81,
			0x84, 0x81, 0x7b, 0x79, 0x84, 0x86, 0x7d, 0x7b, 0x7d, 0x81, 0x84,
			0x81, 0x79, 0x7b, 0x87, 0x84, 0x78, 0x7e, 0x83, 0x81, 0x7f, 0x80,
			0x7d, 0x7d, 0x87, 0x84, 0x77, 0x78, 0x88, 0x87, 0x7a, 0x78, 0x82,
			0x87, 0x7f, 0x7c, 0x7d, 0x83, 0x82, 0x7e, 0x7e, 0x7f, 0x80, 0x82,
			0x7f, 0x7b, 0x7f, 0x86, 0x80, 0x76, 0x7f, 0x89, 0x83, 0x77, 0x79,
			0x85, 0x85, 0x7e, 0x7c, 0x80, 0x80, 0x80, 0x82, 0x80, 0x7a, 0x80,
			0x84, 0x7e, 0x7b, 0x80, 0x89, 0x7a, 0x75, 0x88, 0x86, 0x7b, 0x7c,
			0x7e, 0x84, 0x82, 0x7e, 0x80, 0x7c, 0x7e, 0x85, 0x83, 0x7a, 0x7d,
			0x81, 0x83, 0x81, 0x7c, 0x7e, 0x7f, 0x80, 0x83, 0x7f, 0x7b, 0x82,
			0x81, 0x7e, 0x7d, 0x82, 0x83, 0x7c, 0x7e, 0x7e, 0x81, 0x85, 0x7f,
			0x78, 0x7e, 0x84, 0x84, 0x7f, 0x79, 0x7c, 0x87, 0x84, 0x7c, 0x7d,
			0x7c, 0x81, 0x86, 0x81, 0x79, 0x7c, 0x84, 0x83, 0x81, 0x7a, 0x7c,
			0x84, 0x83, 0x7c, 0x80, 0x7d, 0x7d, 0x85, 0x84, 0x7e, 0x76, 0x7e,
			0x86, 0x87, 0x7d, 0x75, 0x81, 0x85, 0x83, 0x7f, 0x7d, 0x7b, 0x80,
			0x84, 0x7f, 0x80, 0x7f, 0x7d, 0x80, 0x83, 0x7e, 0x80, 0x81, 0x7c,
			0x7b, 0x86, 0x85, 0x7a, 0x7d, 0x7b, 0x81, 0x8a, 0x7d, 0x76, 0x7f,
			0x87, 0x84, 0x7a, 0x7a, 0x82, 0x88, 0x7e, 0x73, 0x85, 0x88, 0x7d,
			0x7a, 0x7c, 0x85, 0x82, 0x7e, 0x7c, 0x7e, 0x83, 0x7f, 0x83, 0x7b,
			0x7a, 0x86, 0x81, 0x7d, 0x79, 0x83, 0x86, 0x7b, 0x7c, 0x81, 0x80,
			0x7c, 0x84, 0x83, 0x7f, 0x78, 0x79, 0x8d, 0x86, 0x77, 0x78, 0x7f,
			0x8b, 0x80, 0x78, 0x7f, 0x7e, 0x84, 0x87, 0x7c, 0x71, 0x84, 0x8b,
			0x80, 0x79, 0x76, 0x87, 0x86, 0x7e, 0x7b, 0x7e, 0x83, 0x7f, 0x82,
			0x80, 0x77, 0x82, 0x87, 0x7e, 0x7d, 0x7b, 0x84, 0x80, 0x7e, 0x84,
			0x76, 0x82, 0x88, 0x79, 0x80, 0x80, 0x7e, 0x83, 0x7c, 0x7f, 0x86,
			0x7f, 0x76, 0x7f, 0x86, 0x82, 0x85, 0x79, 0x77, 0x83, 0x85, 0x84,
			0x7e, 0x79, 0x7c, 0x81, 0x87, 0x82, 0x77, 0x83, 0x7f, 0x79, 0x86,
			0x85, 0x7a, 0x7a, 0x83, 0x83, 0x7e, 0x80, 0x7f, 0x7b, 0x83, 0x83,
			0x7b, 0x7c, 0x80, 0x86, 0x85, 0x78, 0x78, 0x80, 0x87, 0x81, 0x7f,
			0x85, 0x76, 0x78, 0x89, 0x85, 0x80, 0x7d, 0x74, 0x84, 0x8e, 0x79,
			0x7a, 0x80, 0x7f, 0x7d, 0x8c, 0x7f, 0x71, 0x87, 0x7a, 0x80, 0x8a,
			0x7e, 0x7b, 0x77, 0x85, 0x83, 0x7f, 0x7d, 0x7a, 0x8a, 0x81, 0x73,
			0x82, 0x85, 0x80, 0x7d, 0x7e, 0x81, 0x80, 0x81, 0x7d, 0x83, 0x80,
			0x79, 0x86, 0x7e, 0x7a, 0x89, 0x7e, 0x7a, 0x81, 0x7f, 0x7f, 0x81,
			0x86, 0x79, 0x78, 0x86, 0x84, 0x81, 0x7d, 0x75, 0x84, 0x8e, 0x75,
			0x79, 0x82, 0x86, 0x81, 0x79, 0x81, 0x7a, 0x85, 0x85, 0x7b, 0x7d,
			0x7d, 0x86, 0x7f, 0x7c, 0x83, 0x78, 0x7f, 0x8f, 0x7b, 0x6f, 0x84,
			0x8d, 0x7b, 0x79, 0x88, 0x7a, 0x79, 0x84, 0x8c, 0x7a, 0x73, 0x87,
			0x7b, 0x83, 0x8a, 0x7b, 0x75, 0x7c, 0x8c, 0x80, 0x7a, 0x86, 0x7d,
			0x75, 0x84, 0x8d, 0x7c, 0x75, 0x80, 0x85, 0x81, 0x80, 0x81, 0x7b,
			0x7a, 0x87, 0x83, 0x78, 0x81, 0x86, 0x76, 0x80, 0x8a, 0x75, 0x82,
			0x80, 0x7a, 0x8a, 0x80, 0x79, 0x7b, 0x84, 0x83, 0x7b, 0x87, 0x7e,
			0x72, 0x87, 0x86, 0x7f, 0x7b, 0x7e, 0x80, 0x82, 0x84, 0x7a, 0x7e,
			0x85, 0x7f, 0x7b, 0x87, 0x7a, 0x7b, 0x86, 0x7f, 0x83, 0x82, 0x78,
			0x79, 0x89, 0x83, 0x7b, 0x7d, 0x83, 0x83, 0x74, 0x81, 0x8a, 0x7f,
			0x78, 0x7c, 0x85, 0x84, 0x7a, 0x7e, 0x84, 0x7c, 0x82, 0x7a, 0x7c,
			0x8a, 0x86, 0x74, 0x75, 0x8e, 0x83, 0x79, 0x7b, 0x83, 0x84, 0x7e,
			0x7e, 0x7f, 0x78, 0x87, 0x89, 0x74, 0x82, 0x7b, 0x7f, 0x95, 0x77,
			0x69, 0x8d, 0x85, 0x7e, 0x81, 0x72, 0x8a, 0x82, 0x7c, 0x82, 0x76,
			0x85, 0x84, 0x84, 0x74, 0x7f, 0x83, 0x84, 0x82, 0x72, 0x8b, 0x71,
			0x8d, 0x91, 0x61, 0x7f, 0x8e, 0x83, 0x7f, 0x77, 0x7a, 0x87, 0x81,
			0x83, 0x84, 0x6f, 0x79, 0x95, 0x88, 0x67, 0x7b, 0x96, 0x7c, 0x75,
			0x85, 0x7d, 0x81, 0x88, 0x77, 0x7c, 0x89, 0x77, 0x83, 0x8d, 0x6e,
			0x7c, 0x89, 0x7f, 0x84, 0x7d, 0x7e, 0x7b, 0x7b, 0x8a, 0x8a, 0x80,
			0x61, 0x80, 0x9c, 0x7b, 0x7d, 0x78, 0x7f, 0x7f, 0x7c, 0x95, 0x84,
			0x61, 0x75, 0x99, 0x8d, 0x71, 0x73, 0x8a, 0x79, 0x79, 0x9f, 0x7e,
			0x5a, 0x85, 0x9d, 0x7b, 0x72, 0x82, 0x84, 0x7d, 0x77, 0x8a, 0x8f,
			0x69, 0x76, 0x94, 0x79, 0x76, 0x94, 0x82, 0x65, 0x7f, 0x96, 0x82,
			0x74, 0x7a, 0x81, 0x7f, 0x8d, 0x87, 0x6a, 0x74, 0x90, 0x94, 0x76,
			0x6e, 0x7b, 0x8a, 0x90, 0x7c, 0x6b, 0x7d, 0x92, 0x87, 0x6d, 0x7d,
			0x8f, 0x7a, 0x7b, 0x83, 0x7d, 0x7c, 0x8a, 0x7c, 0x78, 0x84, 0x7e,
			0x80, 0x85, 0x7d, 0x74, 0x84, 0x94, 0x78, 0x65, 0x84, 0x98, 0x85,
			0x67, 0x7a, 0x8f, 0x7f, 0x81, 0x83, 0x74, 0x75, 0x91, 0x8d, 0x72,
			0x80, 0x7b, 0x78, 0x91, 0x83, 0x76, 0x7f, 0x79, 0x85, 0x87, 0x80,
			0x76, 0x73, 0x8a, 0x88, 0x86, 0x76, 0x75, 0x82, 0x83, 0x88, 0x81,
			0x78, 0x7a, 0x84, 0x83, 0x7d, 0x7d, 0x82, 0x85, 0x7d, 0x76, 0x82,
			0x85, 0x81, 0x80, 0x7a, 0x81, 0x7f, 0x82, 0x85, 0x7d, 0x78, 0x83,
			0x85, 0x7a, 0x7f, 0x83, 0x7e, 0x81, 0x83, 0x7b, 0x7e, 0x86, 0x84,
			0x75, 0x7b, 0x88, 0x82, 0x7b, 0x78, 0x85, 0x85, 0x7d, 0x7d, 0x7f,
			0x83, 0x7f, 0x7d, 0x7d, 0x84, 0x7c, 0x82, 0x84, 0x77, 0x7f, 0x81,
			0x86, 0x7b, 0x7b, 0x85, 0x7d, 0x82, 0x83, 0x7b, 0x7d, 0x7f, 0x89,
			0x7e, 0x7a, 0x83, 0x7f, 0x7d, 0x80, 0x84, 0x7c, 0x7d, 0x83, 0x80,
			0x7a, 0x80, 0x82, 0x81, 0x89, 0x77, 0x73, 0x89, 0x88, 0x7c, 0x7c,
			0x7d, 0x7e, 0x83, 0x82, 0x81, 0x7a, 0x7d, 0x8a, 0x81, 0x73, 0x81,
			0x8b, 0x7d, 0x79, 0x7f, 0x84, 0x7d, 0x7e, 0x86, 0x79, 0x7a, 0x87,
			0x86, 0x7b, 0x79, 0x84, 0x81, 0x7c, 0x87, 0x81, 0x73, 0x81, 0x89,
			0x7a, 0x7c, 0x87, 0x7c, 0x7a, 0x85, 0x82, 0x79, 0x82, 0x86, 0x77,
			0x7f, 0x87, 0x7c, 0x7e, 0x7f, 0x80, 0x7f, 0x7d, 0x85, 0x80, 0x7b,
			0x7d, 0x7f, 0x85, 0x80, 0x7e, 0x81, 0x7d, 0x82, 0x7f, 0x80, 0x81,
			0x79, 0x81, 0x85, 0x81, 0x7c, 0x7a, 0x86, 0x84, 0x77, 0x82, 0x82,
			0x79, 0x84, 0x84, 0x7d, 0x7c, 0x85, 0x81, 0x75, 0x83, 0x8a, 0x7c,
			0x7a, 0x82, 0x7e, 0x7e, 0x84, 0x7f, 0x7b, 0x81, 0x84, 0x7c, 0x7b,
			0x83, 0x84, 0x7e, 0x7a, 0x80, 0x83, 0x82, 0x7d, 0x7d, 0x81, 0x82,
			0x80, 0x7c, 0x81, 0x83, 0x80, 0x81, 0x82, 0x7d, 0x81, 0x89, 0x80,
			0x7b, 0x83, 0x85, 0x7c, 0x7d, 0x81, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d,
			0x7d, 0x7c, 0x72, 0x6d, 0x76, 0x7a, 0x75, 0x73, 0x7a, 0x85, 0x86,
			0x84, 0x89, 0x8e, 0x8f, 0x8c, 0x88, 0x85, 0x84, 0x82, 0x7f, 0x7b,
			0x79, 0x7d, 0x81, 0x7e, 0x7f, 0x86, 0x89, 0x88, 0x86, 0x88, 0x8d,
			0x8b, 0x85, 0x80, 0x80, 0x85, 0x80, 0x7b, 0x7d, 0x81, 0x84, 0x82,
			0x73, 0x42, 0x46, 0x89, 0x71, 0x39, 0x52, 0x82, 0x92, 0x77, 0x75,
			0xa1, 0xad, 0xa1, 0xa1, 0x9a, 0x91, 0x97, 0x96, 0x7a, 0x64, 0x71,
			0x82, 0x72, 0x59, 0x6a, 0x8c, 0x89, 0x7c, 0x82, 0x93, 0x99, 0x8c,
			0x85, 0x82, 0x7b, 0x7b, 0x75, 0x68, 0x6a, 0x7a, 0x7f, 0x77, 0x7d,
			0x92, 0x98, 0x8d, 0x8f, 0x99, 0x96, 0x8c, 0x87, 0x88, 0x86, 0x83,
			0x82, 0x7a, 0x61, 0x32, 0x48, 0x81, 0x4d, 0x2e, 0x61, 0x89, 0x91,
			0x76, 0x8e, 0xbe, 0xb2, 0xac, 0xa9, 0x96, 0x98, 0x92, 0x7c, 0x5e,
			0x57, 0x73, 0x6f, 0x53, 0x5e, 0x82, 0x96, 0x88, 0x89, 0xa1, 0xa8,
			0x9f, 0x91, 0x8a, 0x86, 0x7a, 0x6a, 0x56, 0x53, 0x63, 0x65, 0x63,
			0x75, 0x92, 0x9b, 0x95, 0x9c, 0xa9, 0xa4, 0x95, 0x8d, 0x8c, 0x87,
			0x7d, 0x76, 0x73, 0x77, 0x7c, 0x76, 0x6f, 0x44, 0x43, 0x8b, 0x69,
			0x39, 0x64, 0x8b, 0x96, 0x76, 0x80, 0xb6, 0xaa, 0x9d, 0x9e, 0x8b,
			0x95, 0x92, 0x74, 0x65, 0x62, 0x7e, 0x78, 0x55, 0x70, 0x8e, 0x92,
			0x88, 0x84, 0x9e, 0xa2, 0x8f, 0x86, 0x81, 0x85, 0x7c, 0x68, 0x61,
			0x64, 0x6e, 0x65, 0x5f, 0x77, 0x8b, 0x8c, 0x8b, 0x9b, 0xa5, 0x9d,
			0x91, 0x8f, 0x91, 0x8a, 0x7e, 0x78, 0x7c, 0x82, 0x7d, 0x79, 0x80,
			0x84, 0x7d, 0x48, 0x47, 0x89, 0x60, 0x3b, 0x61, 0x7e, 0x8c, 0x74,
			0x82, 0xb1, 0xa9, 0xa1, 0xa1, 0x8f, 0x9c, 0x97, 0x6e, 0x66, 0x6d,
			0x7b, 0x69, 0x53, 0x78, 0x8c, 0x85, 0x83, 0x8b, 0xa5, 0xa1, 0x8b,
			0x8a, 0x8c, 0x8c, 0x79, 0x61, 0x68, 0x73, 0x68, 0x5a, 0x63, 0x79,
			0x82, 0x7d, 0x84, 0x9b, 0xa1, 0x95, 0x90, 0x98, 0x95, 0x85, 0x80,
			0x82, 0x81, 0x7b, 0x7b, 0x83, 0x85, 0x85, 0x84, 0x83, 0x75, 0x44,
			0x62, 0x7e, 0x42, 0x4d, 0x6d, 0x73, 0x7f, 0x79, 0x8f, 0xb0, 0xa4,
			0x9e, 0xa2, 0x9c, 0xa0, 0x84, 0x74, 0x77, 0x70, 0x71, 0x5c, 0x64,
			0x80, 0x78, 0x7c, 0x88, 0x94, 0x9f, 0x92, 0x8e, 0x97, 0x92, 0x83,
			0x73, 0x71, 0x76, 0x67, 0x61, 0x64, 0x6a, 0x79, 0x73, 0x74, 0x8e,
			0x98, 0x8e, 0x91, 0x9d, 0x98, 0x8e, 0x87, 0x86, 0x84, 0x80, 0x79,
			0x7c, 0x81, 0x80, 0x83, 0x84, 0x8b, 0x85, 0x87, 0x61, 0x4a, 0x88,
			0x5e, 0x37, 0x70, 0x67, 0x6a, 0x80, 0x75, 0x95, 0xaa, 0x9c, 0x9f,
			0xa2, 0xb1, 0x96, 0x7e, 0x90, 0x78, 0x75, 0x6a, 0x58, 0x74, 0x6f,
			0x66, 0x79, 0x83, 0x8e, 0x8d, 0x8e, 0x9c, 0x97, 0x93, 0x86, 0x81,
			0x87, 0x71, 0x6c, 0x6d, 0x6c, 0x6b, 0x68, 0x72, 0x77, 0x7e, 0x83,
			0x8c, 0x93, 0x91, 0x94, 0x95, 0x90, 0x88, 0x88, 0x85, 0x7f, 0x7a,
			0x7b, 0x7e, 0x7d, 0x80, 0x85, 0x89, 0x8d, 0x88, 0x8e, 0x62, 0x58,
			0x95, 0x49, 0x46, 0x79, 0x4b, 0x72, 0x71, 0x61, 0xa0, 0x95, 0x92,
			0xa3, 0xa9, 0xb4, 0x93, 0x9d, 0x96, 0x84, 0x88, 0x63, 0x72, 0x75,
			0x58, 0x6a, 0x6c, 0x74, 0x7a, 0x79, 0x8e, 0x90, 0x98, 0x91, 0x95,
			0x9f, 0x87, 0x85, 0x7c, 0x7a, 0x74, 0x63, 0x6a, 0x6c, 0x67, 0x6e,
			0x7d, 0x81, 0x86, 0x8e, 0x97, 0x96, 0x91, 0x93, 0x93, 0x89, 0x81,
			0x82, 0x7e, 0x77, 0x75, 0x7b, 0x7b, 0x7f, 0x80, 0x89, 0x8a, 0x96,
			0x83, 0x48, 0x92, 0x73, 0x3a, 0x78, 0x59, 0x65, 0x69, 0x61, 0x84,
			0x8c, 0x7f, 0x95, 0xae, 0x96, 0xa0, 0xa1, 0x9e, 0x99, 0x86, 0x88,
			0x86, 0x77, 0x6d, 0x73, 0x71, 0x6f, 0x6f, 0x78, 0x77, 0x76, 0x82,
			0x86, 0x85, 0x86, 0x8d, 0x8d, 0x89, 0x84, 0x86, 0x84, 0x7d, 0x7a,
			0x7b, 0x79, 0x77, 0x7a, 0x7c, 0x7e, 0x7e, 0x84, 0x85, 0x84, 0x85,
			0x87, 0x86, 0x82, 0x82, 0x82, 0x7f, 0x7e, 0x7e, 0x7c, 0x7d, 0x7d,
			0x80, 0x81, 0x80, 0x88, 0x88, 0x8d, 0x7f, 0x74, 0x83, 0x6d, 0x66,
			0x6e, 0x67, 0x67, 0x65, 0x6a, 0x74, 0x73, 0x7c, 0x8a, 0x8a, 0x90,
			0x97, 0x9b, 0x9a, 0x95, 0x98, 0x95, 0x8a, 0x88, 0x84, 0x7f, 0x7a,
			0x75, 0x78, 0x78, 0x74, 0x78, 0x7e, 0x7f, 0x81, 0x86, 0x86, 0x86,
			0x85, 0x85, 0x82, 0x7e, 0x7e, 0x7a, 0x76, 0x76, 0x76, 0x76, 0x77,
			0x79, 0x7e, 0x7f, 0x81, 0x85, 0x86, 0x87, 0x88, 0x88, 0x88, 0x83,
			0x83, 0x82, 0x7d, 0x7b, 0x7c, 0x7b, 0x7a, 0x7a, 0x7d, 0x7e, 0x7e,
			0x82, 0x7e, 0x82, 0x82, 0x7f, 0x82, 0x7a, 0x7e, 0x7a, 0x73, 0x77,
			0x77, 0x74, 0x74, 0x77, 0x7a, 0x7b, 0x7b, 0x81, 0x83, 0x84, 0x89,
			0x8b, 0x8a, 0x8c, 0x8c, 0x8c, 0x89, 0x86, 0x87, 0x84, 0x81, 0x7f,
			0x7d, 0x7d, 0x7d, 0x7b, 0x7a, 0x7d, 0x7f, 0x7f, 0x7e, 0x80, 0x82,
			0x81, 0x80, 0x81, 0x82, 0x7f, 0x80, 0x7e, 0x7c, 0x81, 0x7d, 0x7c,
			0x80, 0x7d, 0x7e, 0x81, 0x7c, 0x80, 0x83, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7c, 0x7d, 0x7e, 0x7f, 0x80,
			0x7f, 0x7f, 0x82, 0x81, 0x7f, 0x81, 0x7f, 0x7e, 0x81, 0x7f, 0x7f,
			0x80, 0x7f, 0x82, 0x80, 0x7d, 0x81, 0x80, 0x7e, 0x7d, 0x7d, 0x80,
			0x7e, 0x7d, 0x80, 0x7e, 0x80, 0x81, 0x7f, 0x80, 0x81, 0x82, 0x83,
			0x80, 0x82, 0x83, 0x81, 0x83, 0x81, 0x82, 0x82, 0x81, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x7e, 0x7e, 0x82, 0x7e, 0x7b, 0x7f, 0x7e,
			0x7d, 0x7e, 0x7c, 0x80, 0x80, 0x7f, 0x81, 0x80, 0x83, 0x82, 0x80,
			0x81, 0x81, 0x7f, 0x80, 0x7f, 0x7c, 0x81, 0x7b, 0x7b, 0x7f, 0x7a,
			0x7f, 0x7c, 0x7c, 0x83, 0x7b, 0x81, 0x83, 0x7d, 0x82, 0x81, 0x7e,
			0x81, 0x7c, 0x81, 0x7d, 0x7b, 0x82, 0x7b, 0x80, 0x7f, 0x81, 0x83,
			0x81, 0x84, 0x82, 0x81, 0x82, 0x7f, 0x7f, 0x81, 0x7a, 0x7c, 0x7e,
			0x7a, 0x7e, 0x7d, 0x80, 0x81, 0x7e, 0x85, 0x83, 0x80, 0x84, 0x82,
			0x81, 0x83, 0x7b, 0x81, 0x7c, 0x7a, 0x80, 0x7a, 0x80, 0x7f, 0x7c,
			0x85, 0x80, 0x81, 0x86, 0x7d, 0x84, 0x82, 0x7a, 0x82, 0x79, 0x7c,
			0x80, 0x77, 0x81, 0x7d, 0x7e, 0x84, 0x7f, 0x84, 0x83, 0x80, 0x86,
			0x7c, 0x80, 0x82, 0x78, 0x82, 0x7a, 0x7b, 0x80, 0x7b, 0x7e, 0x82,
			0x7d, 0x84, 0x81, 0x80, 0x87, 0x7e, 0x83, 0x84, 0x7c, 0x81, 0x81,
			0x7c, 0x80, 0x7d, 0x7b, 0x7f, 0x7d, 0x7c, 0x7e, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x7f, 0x82, 0x81, 0x7f, 0x80, 0x81, 0x80, 0x7e, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x7e, 0x7e, 0x81,
			0x7d, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x81,
			0x7f, 0x81, 0x80, 0x7e, 0x83, 0x7f, 0x7d, 0x81, 0x7e, 0x7d, 0x7f,
			0x7e, 0x81, 0x7f, 0x82, 0x80, 0x80, 0x84, 0x7c, 0x82, 0x82, 0x7c,
			0x81, 0x7e, 0x7e, 0x7f, 0x7d, 0x7e, 0x7f, 0x7e, 0x81, 0x7e, 0x80,
			0x82, 0x80, 0x80, 0x82, 0x7f, 0x80, 0x82, 0x7f, 0x7f, 0x81, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x81, 0x7f, 0x7d, 0x81, 0x7e, 0x7e,
			0x81, 0x7d, 0x81, 0x7f, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7f,
			0x81, 0x7a, 0x83, 0x7f, 0x7d, 0x81, 0x81, 0x80, 0x80, 0x82, 0x80,
			0x82, 0x7e, 0x81, 0x7f, 0x7e, 0x7f, 0x7c, 0x7f, 0x7d, 0x7e, 0x7e,
			0x7f, 0x80, 0x80, 0x83, 0x83, 0x81, 0x84, 0x83, 0x80, 0x7f, 0x7f,
			0x7e, 0x7d, 0x7d, 0x7b, 0x7e, 0x7c, 0x7f, 0x7f, 0x7f, 0x83, 0x82,
			0x81, 0x84, 0x81, 0x81, 0x81, 0x7f, 0x81, 0x7f, 0x7e, 0x80, 0x7d,
			0x7f, 0x81, 0x7e, 0x7f, 0x81, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e,
			0x7d, 0x7e, 0x7f, 0x80, 0x82, 0x81, 0x81, 0x83, 0x82, 0x84, 0x80,
			0x80, 0x82, 0x7d, 0x7e, 0x7d, 0x7d, 0x7c, 0x7e, 0x7f, 0x7f, 0x7f,
			0x81, 0x80, 0x83, 0x82, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x7f, 0x7f,
			0x80, 0x7d, 0x7e, 0x7f, 0x7e, 0x81, 0x7e, 0x7f, 0x81, 0x80, 0x7f,
			0x81, 0x80, 0x80, 0x81, 0x7e, 0x81, 0x7f, 0x80, 0x81, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7d, 0x7f,
			0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x7f, 0x82, 0x81, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7e,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80, 0x7e, 0x7d,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x81, 0x81, 0x81, 0x82, 0x80, 0x81,
			0x81, 0x7e, 0x7f, 0x7f, 0x7d, 0x7f, 0x7e, 0x7f, 0x81, 0x7f, 0x82,
			0x82, 0x82, 0x82, 0x81, 0x80, 0x81, 0x7f, 0x7e, 0x7d, 0x7c, 0x7d,
			0x7c, 0x7c, 0x7e, 0x7f, 0x7e, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81,
			0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x81,
			0x80, 0x81, 0x82, 0x80, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7e, 0x7c,
			0x7d, 0x7f, 0x7e, 0x7f, 0x7f, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82,
			0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x80, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x81, 0x7d, 0x81, 0x80,
			0x7f, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x7f, 0x81, 0x7e, 0x81, 0x80,
			0x7e, 0x81, 0x7f, 0x7e, 0x82, 0x7e, 0x80, 0x81, 0x7d, 0x81, 0x80,
			0x7d, 0x81, 0x7f, 0x7e, 0x83, 0x7d, 0x80, 0x81, 0x7c, 0x81, 0x81,
			0x7d, 0x81, 0x80, 0x7d, 0x82, 0x7e, 0x7f, 0x82, 0x7e, 0x81, 0x81,
			0x7e, 0x81, 0x80, 0x7e, 0x82, 0x7e, 0x7f, 0x80, 0x7e, 0x7f, 0x80,
			0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x81,
			0x7e, 0x80, 0x80, 0x7f, 0x81, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x82, 0x7e,
			0x80, 0x81, 0x7d, 0x81, 0x80, 0x7f, 0x81, 0x7f, 0x7e, 0x82, 0x7e,
			0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e,
			0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7e, 0x80, 0x81, 0x7e,
			0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x82, 0x7d, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x82, 0x7c, 0x82, 0x7d, 0x80, 0x80, 0x7e,
			0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7e, 0x82, 0x7e, 0x81, 0x7f, 0x7f,
			0x7f, 0x81, 0x7f, 0x7f, 0x81, 0x7d, 0x82, 0x7e, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x81,
			0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x81,
			0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x7f, 0x80, 0x7e, 0x81,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x81,
			0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7e, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80,
		},
		{ // 7
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7f,
			0x80, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80,
			0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f,
			0x81, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x82, 0x7d, 0x80,
			0x81, 0x7d, 0x82, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7e,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e,
			0x81, 0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7f,
			0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x81, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x81,
			0x80, 0x7e, 0x82, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81,
			0x7e, 0x80, 0x81, 0x7e, 0x81, 0x7f, 0x7e, 0x81, 0x7e, 0x81, 0x7f,
			0x7e, 0x81, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f,
			0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e,
			0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x81,
			0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f,
			0x81, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x80,
			0x80, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x81,
			0x7f, 0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7e, 0x82, 0x7e, 0x80, 0x80,
			0x7e, 0x81, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7f,
			0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7e, 0x81, 0x7e, 0x80, 0x81, 0x7d, 0x82, 0x7f, 0x7f,
			0x81, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7e,
			0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e,
			0x81, 0x7f, 0x7d, 0x83, 0x7e, 0x7f, 0x82, 0x7c, 0x81, 0x7f, 0x7f,
			0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x82, 0x7c, 0x81, 0x80, 0x7e,
			0x82, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x81, 0x7e, 0x80, 0x81, 0x7e, 0x81, 0x80, 0x7e, 0x81, 0x7d, 0x80,
			0x81, 0x7d, 0x82, 0x7e, 0x7f, 0x82, 0x7d, 0x80, 0x80, 0x7e, 0x81,
			0x7f, 0x7e, 0x83, 0x7c, 0x80, 0x81, 0x7e, 0x81, 0x7f, 0x80, 0x7f,
			0x7f, 0x81, 0x7f, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7d, 0x81, 0x80, 0x7f,
			0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x82,
			0x7e, 0x7e, 0x82, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x81,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x81,
			0x7e, 0x81, 0x7e, 0x7f, 0x82, 0x7e, 0x7f, 0x81, 0x7e, 0x7f, 0x81,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x81, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7e,
			0x81, 0x7f, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x81, 0x7f,
			0x80, 0x7f, 0x7f, 0x81, 0x7d, 0x81, 0x80, 0x7e, 0x80, 0x7f, 0x7f,
			0x80, 0x7e, 0x81, 0x7e, 0x7f, 0x82, 0x7d, 0x81, 0x80, 0x7d, 0x82,
			0x7e, 0x7f, 0x82, 0x7c, 0x81, 0x80, 0x7d, 0x83, 0x7d, 0x80, 0x82,
			0x7d, 0x82, 0x7f, 0x7e, 0x82, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7e,
			0x7f, 0x81, 0x7e, 0x81, 0x7f, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e,
			0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e,
			0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x7e, 0x81,
			0x80, 0x7e, 0x81, 0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x81,
			0x7e, 0x80, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x81,
			0x7e, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7e,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7e,
			0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x81, 0x7e,
			0x80, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e,
			0x80, 0x80, 0x7d, 0x82, 0x7f, 0x7e, 0x82, 0x7f, 0x7f, 0x81, 0x7e,
			0x80, 0x80, 0x7d, 0x82, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7d, 0x81,
			0x80, 0x7e, 0x82, 0x7e, 0x80, 0x80, 0x7e, 0x81, 0x80, 0x7d, 0x81,
			0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x80,
			0x81, 0x7e, 0x81, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7e, 0x81,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x82, 0x84,
			0x82, 0x83, 0x83, 0x81, 0x83, 0x81, 0x81, 0x83, 0x7f, 0x81, 0x81,
			0x7d, 0x81, 0x7f, 0x7d, 0x82, 0x7d, 0x82, 0x79, 0x72, 0x87, 0x70,
			0x74, 0x7e, 0x6d, 0x80, 0x72, 0x74, 0x87, 0x77, 0x81, 0x84, 0x84,
			0x8b, 0x86, 0x89, 0x8d, 0x8c, 0x83, 0x8a, 0x87, 0x82, 0x84, 0x7a,
			0x83, 0x7f, 0x75, 0x7f, 0x7a, 0x7b, 0x7c, 0x7a, 0x80, 0x7f, 0x7c,
			0x7f, 0x83, 0x7f, 0x81, 0x81, 0x81, 0x83, 0x7a, 0x7f, 0x81, 0x7a,
			0x7c, 0x7d, 0x7d, 0x7d, 0x7b, 0x81, 0x83, 0x7f, 0x84, 0x87, 0x86,
			0x86, 0x86, 0x8a, 0x87, 0x84, 0x89, 0x84, 0x85, 0x82, 0x87, 0x76,
			0x65, 0x8f, 0x61, 0x66, 0x7d, 0x58, 0x82, 0x64, 0x69, 0x8e, 0x6f,
			0x84, 0x8a, 0x8b, 0x95, 0x8f, 0x90, 0x99, 0x96, 0x83, 0x92, 0x88,
			0x7d, 0x82, 0x70, 0x7f, 0x75, 0x69, 0x79, 0x73, 0x74, 0x78, 0x7b,
			0x81, 0x85, 0x7f, 0x89, 0x90, 0x80, 0x8b, 0x89, 0x80, 0x84, 0x78,
			0x7b, 0x7c, 0x70, 0x79, 0x7c, 0x77, 0x80, 0x81, 0x86, 0x8a, 0x86,
			0x8f, 0x90, 0x87, 0x90, 0x88, 0x8b, 0x86, 0x8a, 0x80, 0x47, 0x96,
			0x62, 0x3d, 0x8a, 0x43, 0x7a, 0x6b, 0x58, 0xa0, 0x7b, 0x85, 0x9e,
			0xa0, 0x9b, 0x9d, 0x95, 0x96, 0x99, 0x70, 0x83, 0x82, 0x64, 0x72,
			0x68, 0x74, 0x75, 0x6a, 0x81, 0x89, 0x7f, 0x87, 0x94, 0x8c, 0x8e,
			0x85, 0x86, 0x8b, 0x75, 0x72, 0x7d, 0x76, 0x6b, 0x75, 0x7c, 0x79,
			0x77, 0x82, 0x8c, 0x82, 0x84, 0x8f, 0x8c, 0x83, 0x84, 0x89, 0x84,
			0x7c, 0x81, 0x86, 0x82, 0x7e, 0x8d, 0x88, 0x92, 0x62, 0x67, 0xa6,
			0x3c, 0x67, 0x7f, 0x52, 0x81, 0x57, 0x7f, 0x94, 0x76, 0x89, 0xa1,
			0x9b, 0x8b, 0x99, 0x8f, 0x92, 0x82, 0x74, 0x8b, 0x77, 0x6a, 0x7a,
			0x7b, 0x7a, 0x77, 0x7e, 0x89, 0x82, 0x7d, 0x89, 0x8a, 0x7d, 0x7f,
			0x81, 0x80, 0x7b, 0x73, 0x81, 0x84, 0x72, 0x80, 0x87, 0x7e, 0x81,
			0x81, 0x82, 0x7f, 0x77, 0x7f, 0x80, 0x78, 0x7e, 0x85, 0x83, 0x82,
			0x88, 0x89, 0x89, 0x84, 0x88, 0x89, 0x82, 0x88, 0x84, 0x93, 0x4d,
			0x70, 0x9a, 0x2c, 0x7e, 0x73, 0x5d, 0x88, 0x62, 0x8f, 0x90, 0x82,
			0x8d, 0xa1, 0x8d, 0x85, 0x94, 0x80, 0x87, 0x7b, 0x77, 0x85, 0x76,
			0x76, 0x84, 0x81, 0x7e, 0x82, 0x84, 0x83, 0x7c, 0x7c, 0x85, 0x7b,
			0x79, 0x80, 0x7e, 0x7e, 0x7d, 0x80, 0x87, 0x80, 0x7f, 0x87, 0x82,
			0x7d, 0x80, 0x7d, 0x79, 0x7a, 0x75, 0x7b, 0x7d, 0x7a, 0x83, 0x86,
			0x84, 0x88, 0x8a, 0x87, 0x87, 0x85, 0x85, 0x81, 0x83, 0x7f, 0x87,
			0x80, 0x8b, 0x7b, 0x4b, 0x9e, 0x61, 0x4b, 0x91, 0x5e, 0x77, 0x76,
			0x79, 0x8c, 0x88, 0x81, 0x95, 0x95, 0x7f, 0x93, 0x86, 0x83, 0x84,
			0x7d, 0x80, 0x81, 0x79, 0x7f, 0x84, 0x7c, 0x82, 0x81, 0x80, 0x7f,
			0x7c, 0x7f, 0x7f, 0x7a, 0x7e, 0x81, 0x7e, 0x7a, 0x83, 0x85, 0x7c,
			0x85, 0x83, 0x81, 0x80, 0x7d, 0x7e, 0x7a, 0x78, 0x7a, 0x7c, 0x7a,
			0x80, 0x82, 0x84, 0x86, 0x87, 0x88, 0x86, 0x86, 0x85, 0x84, 0x81,
			0x82, 0x82, 0x7f, 0x87, 0x81, 0x91, 0x63, 0x65, 0x9a, 0x49, 0x6a,
			0x81, 0x63, 0x77, 0x74, 0x7f, 0x87, 0x86, 0x80, 0x9b, 0x8a, 0x84,
			0x92, 0x86, 0x86, 0x84, 0x83, 0x81, 0x84, 0x7b, 0x81, 0x83, 0x7b,
			0x7f, 0x80, 0x7c, 0x7a, 0x7c, 0x7c, 0x7d, 0x78, 0x83, 0x7f, 0x7e,
			0x88, 0x83, 0x84, 0x86, 0x83, 0x80, 0x81, 0x7b, 0x7b, 0x7b, 0x75,
			0x78, 0x7a, 0x7a, 0x7e, 0x82, 0x83, 0x87, 0x86, 0x85, 0x88, 0x84,
			0x84, 0x85, 0x81, 0x82, 0x81, 0x82, 0x80, 0x87, 0x82, 0x91, 0x6f,
			0x5a, 0x99, 0x4e, 0x5c, 0x8b, 0x5a, 0x76, 0x7a, 0x7c, 0x84, 0x8c,
			0x83, 0x95, 0x94, 0x81, 0x94, 0x8a, 0x82, 0x85, 0x85, 0x7f, 0x81,
			0x7e, 0x7d, 0x83, 0x7b, 0x7c, 0x81, 0x7c, 0x77, 0x7e, 0x7c, 0x7d,
			0x7c, 0x7c, 0x84, 0x7e, 0x81, 0x88, 0x82, 0x84, 0x84, 0x80, 0x80,
			0x7e, 0x7b, 0x7d, 0x7a, 0x78, 0x7c, 0x7c, 0x7d, 0x80, 0x83, 0x84,
			0x84, 0x84, 0x86, 0x85, 0x82, 0x85, 0x83, 0x81, 0x82, 0x83, 0x83,
			0x82, 0x87, 0x84, 0x8c, 0x62, 0x66, 0x8f, 0x4c, 0x64, 0x82, 0x66,
			0x71, 0x79, 0x84, 0x82, 0x8c, 0x85, 0x93, 0x95, 0x80, 0x8f, 0x8f,
			0x83, 0x83, 0x8a, 0x81, 0x80, 0x83, 0x7c, 0x82, 0x7d, 0x77, 0x7e,
			0x7c, 0x73, 0x7a, 0x7f, 0x7b, 0x7e, 0x82, 0x82, 0x83, 0x7f, 0x86,
			0x87, 0x7f, 0x83, 0x83, 0x80, 0x7c, 0x7e, 0x7e, 0x7b, 0x79, 0x79,
			0x7e, 0x7c, 0x7c, 0x82, 0x84, 0x81, 0x83, 0x86, 0x85, 0x83, 0x82,
			0x85, 0x83, 0x82, 0x83, 0x84, 0x83, 0x82, 0x88, 0x85, 0x87, 0x68,
			0x66, 0x8a, 0x5b, 0x5d, 0x7c, 0x6e, 0x70, 0x6f, 0x85, 0x83, 0x84,
			0x87, 0x89, 0x9a, 0x87, 0x85, 0x93, 0x8f, 0x85, 0x85, 0x8b, 0x82,
			0x80, 0x80, 0x7c, 0x7f, 0x7a, 0x76, 0x7a, 0x7a, 0x78, 0x7a, 0x80,
			0x7f, 0x80, 0x81, 0x80, 0x87, 0x84, 0x80, 0x84, 0x84, 0x80, 0x7f,
			0x80, 0x7f, 0x7e, 0x7c, 0x7b, 0x7c, 0x7a, 0x79, 0x7c, 0x7e, 0x7f,
			0x7e, 0x82, 0x84, 0x83, 0x85, 0x85, 0x87, 0x86, 0x84, 0x86, 0x85,
			0x85, 0x83, 0x84, 0x84, 0x83, 0x81, 0x82, 0x75, 0x61, 0x75, 0x76,
			0x62, 0x68, 0x6f, 0x7c, 0x73, 0x71, 0x84, 0x86, 0x8a, 0x86, 0x8c,
			0x91, 0x8d, 0x8f, 0x8a, 0x8a, 0x8c, 0x8a, 0x84, 0x7e, 0x84, 0x85,
			0x7c, 0x7b, 0x7c, 0x7c, 0x7b, 0x78, 0x79, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7d, 0x80, 0x81, 0x81, 0x7f, 0x80, 0x82, 0x82, 0x82, 0x80, 0x81,
			0x81, 0x80, 0x7e, 0x7e, 0x7c, 0x7c, 0x7e, 0x7d, 0x7f, 0x7e, 0x80,
			0x84, 0x81, 0x83, 0x83, 0x82, 0x82, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x81, 0x83, 0x81, 0x83, 0x83, 0x81, 0x7c, 0x79, 0x7d,
			0x7c, 0x72, 0x72, 0x7a, 0x73, 0x71, 0x79, 0x78, 0x78, 0x7d, 0x84,
			0x82, 0x81, 0x89, 0x8c, 0x89, 0x8a, 0x8f, 0x8b, 0x87, 0x8b, 0x88,
			0x85, 0x85, 0x85, 0x82, 0x7f, 0x7f, 0x7e, 0x7e, 0x7b, 0x7a, 0x7a,
			0x7a, 0x79, 0x78, 0x7a, 0x7a, 0x79, 0x7c, 0x7d, 0x7b, 0x7d, 0x81,
			0x80, 0x80, 0x81, 0x83, 0x83, 0x83, 0x84, 0x83, 0x83, 0x83, 0x83,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x81,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x83, 0x82, 0x83, 0x7e,
			0x78, 0x7e, 0x7d, 0x75, 0x71, 0x78, 0x77, 0x70, 0x76, 0x7a, 0x79,
			0x7b, 0x83, 0x84, 0x80, 0x87, 0x8c, 0x89, 0x88, 0x8c, 0x8d, 0x88,
			0x89, 0x89, 0x86, 0x85, 0x84, 0x82, 0x82, 0x80, 0x7e, 0x7f, 0x7d,
			0x7b, 0x7a, 0x7b, 0x79, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7d, 0x7e,
			0x7e, 0x80, 0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x80, 0x7f, 0x80,
			0x82, 0x80, 0x80, 0x81, 0x81, 0x80, 0x82, 0x81, 0x80, 0x81, 0x82,
			0x82, 0x80, 0x81, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x82, 0x82, 0x83, 0x83, 0x82, 0x82, 0x80, 0x79, 0x79, 0x7d,
			0x76, 0x6e, 0x74, 0x77, 0x70, 0x73, 0x79, 0x79, 0x7a, 0x81, 0x86,
			0x82, 0x85, 0x8d, 0x8c, 0x8a, 0x8c, 0x8e, 0x8b, 0x89, 0x8a, 0x88,
			0x86, 0x85, 0x84, 0x82, 0x80, 0x7d, 0x7d, 0x7b, 0x79, 0x78, 0x77,
			0x78, 0x76, 0x76, 0x79, 0x79, 0x7a, 0x7d, 0x7f, 0x7f, 0x81, 0x83,
			0x83, 0x84, 0x84, 0x84, 0x83, 0x82, 0x83, 0x81, 0x7f, 0x80, 0x7f,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f,
			0x80, 0x81, 0x83, 0x83, 0x83, 0x84, 0x85, 0x84, 0x84, 0x83, 0x83,
			0x82, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7d,
			0x79, 0x7a, 0x7d, 0x78, 0x71, 0x75, 0x79, 0x73, 0x74, 0x7a, 0x7a,
			0x7b, 0x81, 0x84, 0x82, 0x86, 0x8c, 0x8c, 0x8a, 0x8b, 0x8d, 0x8a,
			0x89, 0x88, 0x86, 0x84, 0x84, 0x83, 0x80, 0x80, 0x7e, 0x7e, 0x7d,
			0x7b, 0x7a, 0x7a, 0x7a, 0x78, 0x79, 0x7a, 0x79, 0x79, 0x7c, 0x7d,
			0x7d, 0x7f, 0x81, 0x82, 0x82, 0x83, 0x84, 0x84, 0x83, 0x83, 0x82,
			0x81, 0x81, 0x80, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d,
			0x7e, 0x7f, 0x80, 0x80, 0x82, 0x84, 0x83, 0x83, 0x85, 0x84, 0x84,
			0x83, 0x83, 0x83, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x79, 0x78,
			0x7b, 0x79, 0x75, 0x77, 0x7a, 0x78, 0x79, 0x7d, 0x7e, 0x7f, 0x83,
			0x86, 0x85, 0x87, 0x8b, 0x8b, 0x8a, 0x8b, 0x8b, 0x89, 0x88, 0x87,
			0x86, 0x83, 0x82, 0x81, 0x7e, 0x7c, 0x7c, 0x7b, 0x7a, 0x79, 0x78,
			0x79, 0x79, 0x78, 0x7a, 0x7b, 0x7b, 0x7c, 0x7e, 0x7f, 0x80, 0x82,
			0x82, 0x83, 0x83, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x82,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81,
			0x82, 0x82, 0x81, 0x7e, 0x7e, 0x7e, 0x7c, 0x7a, 0x7b, 0x7c, 0x7b,
			0x7b, 0x7d, 0x7e, 0x7e, 0x81, 0x82, 0x81, 0x82, 0x84, 0x84, 0x83,
			0x84, 0x84, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
		},
		{ // 8
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x80, 0x80, 0x7f, 0x7d, 0x7c, 0x79, 0x78, 0x78, 0x78, 0x7a,
			0x7d, 0x7f, 0x81, 0x83, 0x83, 0x84, 0x84, 0x85, 0x85, 0x86, 0x85,
			0x84, 0x83, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7c, 0x7c,
			0x7b, 0x7c, 0x7d, 0x80, 0x82, 0x83, 0x84, 0x84, 0x82, 0x81, 0x81,
			0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x84, 0x84, 0x83, 0x85, 0x87,
			0x88, 0x8a, 0x84, 0x73, 0x6c, 0x61, 0x53, 0x5d, 0x66, 0x6e, 0x81,
			0x8b, 0x8e, 0x8e, 0x8d, 0x8f, 0x8e, 0x93, 0x9a, 0x96, 0x8f, 0x8a,
			0x7b, 0x6e, 0x6d, 0x6a, 0x6e, 0x79, 0x82, 0x87, 0x88, 0x89, 0x86,
			0x80, 0x85, 0x88, 0x87, 0x8a, 0x89, 0x7f, 0x78, 0x72, 0x6c, 0x6b,
			0x70, 0x76, 0x7a, 0x7f, 0x83, 0x83, 0x86, 0x8a, 0x8c, 0x8f, 0x8f,
			0x8b, 0x86, 0x81, 0x7f, 0x7e, 0x81, 0x85, 0x86, 0x8a, 0x8c, 0x8b,
			0x8a, 0x8a, 0x78, 0x5f, 0x59, 0x48, 0x42, 0x5a, 0x68, 0x78, 0x8e,
			0x96, 0x98, 0x97, 0x9c, 0x9f, 0x9d, 0xa2, 0x9f, 0x8a, 0x7b, 0x6f,
			0x5a, 0x58, 0x63, 0x6b, 0x7a, 0x87, 0x90, 0x90, 0x8d, 0x93, 0x90,
			0x8f, 0x97, 0x91, 0x85, 0x7e, 0x6e, 0x5f, 0x5a, 0x5c, 0x62, 0x6c,
			0x7d, 0x88, 0x8f, 0x99, 0x9a, 0x98, 0x99, 0x93, 0x8b, 0x84, 0x7f,
			0x79, 0x77, 0x7b, 0x7e, 0x82, 0x89, 0x8d, 0x8d, 0x91, 0x7b, 0x59,
			0x56, 0x43, 0x3f, 0x60, 0x6f, 0x7e, 0x8f, 0x92, 0x94, 0x93, 0x9f,
			0xab, 0xa5, 0xa5, 0x9c, 0x7a, 0x66, 0x5f, 0x54, 0x5f, 0x71, 0x7d,
			0x84, 0x84, 0x8c, 0x8a, 0x8c, 0xa0, 0xa0, 0x99, 0x96, 0x82, 0x6c,
			0x62, 0x5f, 0x60, 0x64, 0x6e, 0x72, 0x72, 0x7f, 0x8a, 0x95, 0xa3,
			0xa6, 0x9e, 0x90, 0x84, 0x7a, 0x74, 0x7c, 0x80, 0x81, 0x82, 0x80,
			0x7e, 0x86, 0x8f, 0x99, 0x96, 0x66, 0x4f, 0x44, 0x2b, 0x4d, 0x73,
			0x7f, 0x8f, 0x8e, 0x8f, 0x8e, 0x99, 0xba, 0xba, 0xaa, 0xa0, 0x77,
			0x53, 0x55, 0x5b, 0x6b, 0x78, 0x7e, 0x7e, 0x6e, 0x7d, 0x96, 0x9d,
			0xb2, 0xb2, 0x96, 0x7a, 0x63, 0x60, 0x62, 0x6f, 0x7c, 0x6e, 0x65,
			0x66, 0x6f, 0x87, 0xa0, 0xb0, 0xa5, 0x92, 0x86, 0x79, 0x7f, 0x8a,
			0x8b, 0x82, 0x75, 0x6e, 0x6e, 0x7f, 0x94, 0x9d, 0x9d, 0x9f, 0x71,
			0x35, 0x42, 0x45, 0x49, 0x74, 0x7b, 0x72, 0x68, 0x7d, 0xa5, 0xaf,
			0xca, 0xd1, 0x9d, 0x7b, 0x76, 0x6d, 0x6f, 0x72, 0x73, 0x5d, 0x47,
			0x68, 0x80, 0x91, 0xae, 0xab, 0x95, 0x85, 0x8d, 0x92, 0x89, 0x8b,
			0x76, 0x58, 0x54, 0x5f, 0x6b, 0x75, 0x84, 0x84, 0x80, 0x91, 0x9f,
			0xa0, 0x9c, 0x93, 0x81, 0x74, 0x7b, 0x7f, 0x7a, 0x79, 0x76, 0x74,
			0x7c, 0x8c, 0x95, 0x92, 0x9c, 0x7a, 0x3b, 0x42, 0x51, 0x5a, 0x6d,
			0x72, 0x70, 0x68, 0x8b, 0xb1, 0xb0, 0xb3, 0xa7, 0x91, 0x87, 0x8b,
			0x8e, 0x75, 0x5e, 0x5a, 0x5c, 0x6c, 0x82, 0x8a, 0x83, 0x86, 0x95,
			0x9e, 0xa1, 0x9a, 0x86, 0x74, 0x74, 0x7a, 0x77, 0x6c, 0x61, 0x5f,
			0x6d, 0x83, 0x91, 0x90, 0x8b, 0x8d, 0x92, 0x98, 0x95, 0x87, 0x77,
			0x73, 0x7a, 0x7f, 0x7d, 0x78, 0x74, 0x7b, 0x8a, 0x99, 0x96, 0x72,
			0x4c, 0x4f, 0x62, 0x6c, 0x6b, 0x62, 0x5f, 0x70, 0x94, 0xa4, 0x9a,
			0x91, 0x94, 0x9c, 0x9f, 0x9a, 0x88, 0x73, 0x74, 0x7c, 0x79, 0x73,
			0x70, 0x73, 0x7d, 0x8d, 0x91, 0x88, 0x86, 0x8a, 0x8a, 0x87, 0x82,
			0x7a, 0x74, 0x78, 0x7a, 0x75, 0x73, 0x78, 0x7d, 0x81, 0x86, 0x88,
			0x89, 0x8d, 0x8f, 0x8a, 0x84, 0x83, 0x80, 0x7c, 0x7b, 0x79, 0x7a,
			0x7e, 0x87, 0x84, 0x75, 0x6b, 0x64, 0x67, 0x67, 0x65, 0x64, 0x68,
			0x75, 0x7e, 0x85, 0x89, 0x90, 0x98, 0x9a, 0x96, 0x91, 0x90, 0x8d,
			0x88, 0x84, 0x7e, 0x7b, 0x7c, 0x7c, 0x7b, 0x7d, 0x82, 0x85, 0x85,
			0x84, 0x84, 0x84, 0x84, 0x85, 0x80, 0x7c, 0x7a, 0x79, 0x77, 0x77,
			0x7b, 0x7b, 0x7d, 0x7e, 0x80, 0x85, 0x89, 0x8a, 0x88, 0x85, 0x83,
			0x81, 0x80, 0x7e, 0x7c, 0x7b, 0x79, 0x7b, 0x7a, 0x76, 0x77, 0x73,
			0x71, 0x6f, 0x6f, 0x70, 0x70, 0x75, 0x78, 0x7b, 0x80, 0x84, 0x87,
			0x8a, 0x8f, 0x90, 0x8f, 0x8e, 0x8c, 0x88, 0x86, 0x85, 0x84, 0x81,
			0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x84, 0x85, 0x84, 0x82,
			0x81, 0x7f, 0x7d, 0x7d, 0x7c, 0x7b, 0x7a, 0x7a, 0x7b, 0x7d, 0x80,
			0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7d,
			0x80, 0x7e, 0x7e, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x81, 0x81, 0x83,
			0x80, 0x7f, 0x7f, 0x7d, 0x80, 0x7f, 0x7d, 0x80, 0x7e, 0x7e, 0x81,
			0x7f, 0x81, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7e, 0x80, 0x7d, 0x84, 0x82, 0x82, 0x82, 0x7f, 0x81, 0x80, 0x80,
			0x7f, 0x81, 0x7b, 0x7f, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x7e, 0x7f,
			0x81, 0x7f, 0x82, 0x7f, 0x7e, 0x80, 0x7c, 0x81, 0x7f, 0x7f, 0x7f,
			0x80, 0x7e, 0x7f, 0x82, 0x7f, 0x84, 0x80, 0x81, 0x81, 0x7e, 0x81,
			0x81, 0x7f, 0x80, 0x80, 0x7e, 0x82, 0x7d, 0x80, 0x7e, 0x7c, 0x81,
			0x7c, 0x7f, 0x80, 0x7e, 0x7e, 0x81, 0x7e, 0x81, 0x82, 0x81, 0x80,
			0x82, 0x80, 0x82, 0x81, 0x80, 0x80, 0x7d, 0x81, 0x7d, 0x81, 0x7f,
			0x82, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d,
			0x7f, 0x80, 0x80, 0x7f, 0x84, 0x7e, 0x82, 0x82, 0x7f, 0x80, 0x82,
			0x7d, 0x82, 0x7f, 0x7d, 0x83, 0x7d, 0x81, 0x82, 0x7f, 0x82, 0x81,
			0x7f, 0x80, 0x7f, 0x7d, 0x7f, 0x7c, 0x7e, 0x7c, 0x7d, 0x7f, 0x7e,
			0x83, 0x81, 0x83, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x7c,
			0x80, 0x7c, 0x7f, 0x83, 0x7e, 0x82, 0x82, 0x7e, 0x80, 0x80, 0x7d,
			0x81, 0x7c, 0x7c, 0x80, 0x79, 0x7f, 0x7e, 0x7e, 0x82, 0x7f, 0x82,
			0x81, 0x80, 0x82, 0x81, 0x7f, 0x82, 0x7e, 0x7f, 0x7f, 0x7e, 0x80,
			0x80, 0x7f, 0x80, 0x82, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x7e, 0x80,
			0x7c, 0x7e, 0x7d, 0x7c, 0x80, 0x80, 0x7e, 0x82, 0x82, 0x80, 0x84,
			0x80, 0x82, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x81,
			0x7e, 0x83, 0x7e, 0x7f, 0x80, 0x7b, 0x80, 0x7d, 0x7e, 0x7f, 0x7f,
			0x7c, 0x81, 0x7e, 0x81, 0x83, 0x7f, 0x82, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x81, 0x7e, 0x80, 0x7e, 0x7c, 0x83, 0x7f, 0x83, 0x80, 0x83,
			0x7d, 0x80, 0x82, 0x7c, 0x82, 0x7d, 0x7c, 0x7d, 0x7d, 0x7c, 0x81,
			0x80, 0x7f, 0x84, 0x7e, 0x82, 0x80, 0x80, 0x81, 0x80, 0x81, 0x7d,
			0x82, 0x7e, 0x7e, 0x83, 0x80, 0x81, 0x80, 0x80, 0x80, 0x7e, 0x81,
			0x7d, 0x7f, 0x7d, 0x7e, 0x7e, 0x7d, 0x7f, 0x83, 0x7f, 0x81, 0x83,
			0x7c, 0x83, 0x7e, 0x7d, 0x82, 0x7e, 0x80, 0x7f, 0x7d, 0x80, 0x7e,
			0x7f, 0x82, 0x80, 0x80, 0x84, 0x7d, 0x83, 0x80, 0x7f, 0x81, 0x7c,
			0x7e, 0x7d, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x7e, 0x82, 0x80, 0x80,
			0x82, 0x80, 0x7e, 0x80, 0x81, 0x7d, 0x81, 0x81, 0x7e, 0x82, 0x7f,
			0x83, 0x80, 0x81, 0x7f, 0x7f, 0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e,
			0x81, 0x80, 0x82, 0x80, 0x84, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7e, 0x7e, 0x80, 0x7f, 0x80, 0x82, 0x81, 0x83, 0x81,
			0x81, 0x81, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7d, 0x80, 0x7e,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7c,
			0x82, 0x7e, 0x80, 0x82, 0x80, 0x81, 0x82, 0x7e, 0x80, 0x7f, 0x7d,
			0x81, 0x7d, 0x7f, 0x80, 0x7b, 0x7e, 0x84, 0x7c, 0x82, 0x82, 0x7d,
			0x84, 0x7f, 0x80, 0x80, 0x7b, 0x80, 0x7f, 0x7f, 0x82, 0x7f, 0x7f,
			0x81, 0x7d, 0x82, 0x81, 0x7f, 0x81, 0x80, 0x7f, 0x80, 0x7e, 0x7e,
			0x7e, 0x7e, 0x80, 0x80, 0x80, 0x7d, 0x80, 0x82, 0x80, 0x7f, 0x7f,
			0x7d, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x81, 0x7e, 0x82, 0x82,
			0x7d, 0x83, 0x7c, 0x81, 0x7d, 0x7f, 0x7f, 0x7d, 0x7f, 0x7e, 0x81,
			0x7f, 0x81, 0x80, 0x82, 0x80, 0x83, 0x7f, 0x7f, 0x80, 0x7d, 0x80,
			0x7f, 0x7d, 0x7e, 0x7f, 0x7e, 0x82, 0x81, 0x80, 0x82, 0x7e, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x7d, 0x82, 0x7e, 0x82,
			0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x7f,
			0x82, 0x80, 0x81, 0x82, 0x7d, 0x82, 0x7b, 0x82, 0x7e, 0x7f, 0x80,
			0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x83, 0x7c, 0x81, 0x80, 0x7d, 0x83,
			0x7e, 0x83, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x7f, 0x81, 0x7c, 0x83,
			0x7d, 0x81, 0x80, 0x7f, 0x80, 0x81, 0x7e, 0x7f, 0x80, 0x7c, 0x82,
			0x7d, 0x81, 0x7f, 0x7f, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x7d, 0x81,
			0x7c, 0x80, 0x81, 0x7d, 0x82, 0x81, 0x7f, 0x84, 0x7d, 0x81, 0x80,
			0x7d, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x81, 0x7f,
			0x7e, 0x82, 0x7e, 0x7f, 0x81, 0x7a, 0x82, 0x81, 0x7d, 0x83, 0x7e,
			0x7f, 0x80, 0x7f, 0x7e, 0x81, 0x7d, 0x81, 0x81, 0x7f, 0x80, 0x80,
			0x82, 0x7d, 0x82, 0x7e, 0x7e, 0x81, 0x7f, 0x80, 0x82, 0x7e, 0x7d,
			0x81, 0x7c, 0x81, 0x7f, 0x7d, 0x81, 0x7c, 0x80, 0x80, 0x80, 0x81,
			0x81, 0x7d, 0x81, 0x81, 0x7c, 0x84, 0x80, 0x7e, 0x81, 0x7f, 0x7c,
			0x83, 0x7d, 0x81, 0x80, 0x7d, 0x80, 0x7e, 0x7e, 0x7f, 0x81, 0x7d,
			0x80, 0x7f, 0x80, 0x81, 0x7f, 0x82, 0x80, 0x81, 0x80, 0x7d, 0x82,
			0x7e, 0x7f, 0x83, 0x7e, 0x82, 0x81, 0x7f, 0x82, 0x7f, 0x7d, 0x7f,
			0x7d, 0x7c, 0x81, 0x7c, 0x7e, 0x80, 0x7d, 0x7f, 0x80, 0x7f, 0x81,
			0x80, 0x7f, 0x82, 0x7f, 0x80, 0x82, 0x7f, 0x7f, 0x81, 0x7c, 0x7f,
			0x80, 0x7e, 0x81, 0x80, 0x7d, 0x80, 0x80, 0x7c, 0x83, 0x7e, 0x81,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x80, 0x7e, 0x81, 0x7e, 0x81,
			0x7d, 0x81, 0x80, 0x7e, 0x81, 0x7e, 0x7d, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x82, 0x80, 0x81, 0x80, 0x7f, 0x7d, 0x7f, 0x7f,
			0x7e, 0x81, 0x7d, 0x81, 0x7d, 0x7e, 0x80, 0x7f, 0x81, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x81, 0x7d, 0x80, 0x7f, 0x7e, 0x81, 0x7e, 0x80,
			0x81, 0x80, 0x80, 0x82, 0x7e, 0x80, 0x7f, 0x7e, 0x80, 0x7e, 0x7d,
			0x7f, 0x7d, 0x7e, 0x81, 0x7f, 0x81, 0x81, 0x7f, 0x80, 0x80, 0x7f,
			0x81, 0x7e, 0x80, 0x80, 0x7d, 0x81, 0x7f, 0x7e, 0x81, 0x7e, 0x7e,
			0x82, 0x7e, 0x81, 0x80, 0x7e, 0x81, 0x7e, 0x7f, 0x80, 0x7e, 0x80,
			0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x81, 0x7e, 0x81,
			0x7f, 0x7e, 0x82, 0x7e, 0x80, 0x81, 0x7f, 0x81, 0x80, 0x7e, 0x80,
			0x7e, 0x7b, 0x7b, 0x7a, 0x77, 0x79, 0x79, 0x79, 0x7c, 0x7c, 0x7d,
			0x80, 0x81, 0x83, 0x86, 0x86, 0x88, 0x88, 0x87, 0x87, 0x86, 0x86,
			0x84, 0x83, 0x81, 0x80, 0x7e, 0x7e, 0x7c, 0x7c, 0x7b, 0x7a, 0x7a,
			0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x82, 0x82, 0x83, 0x84,
			0x84, 0x84, 0x84, 0x85, 0x82, 0x83, 0x81, 0x81, 0x81, 0x80, 0x7f,
			0x80, 0x7e, 0x81, 0x7f, 0x83, 0x77, 0x6d, 0x88, 0x69, 0x6a, 0x7a,
			0x65, 0x77, 0x6e, 0x6d, 0x80, 0x7a, 0x7c, 0x88, 0x8c, 0x8d, 0x90,
			0x91, 0x93, 0x98, 0x8e, 0x8e, 0x93, 0x86, 0x85, 0x83, 0x7e, 0x7e,
			0x77, 0x76, 0x79, 0x76, 0x74, 0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7f,
			0x80, 0x7e, 0x82, 0x84, 0x82, 0x84, 0x83, 0x83, 0x85, 0x80, 0x7d,
			0x80, 0x7e, 0x76, 0x7b, 0x7b, 0x79, 0x7a, 0x7b, 0x7f, 0x7f, 0x80,
			0x85, 0x87, 0x85, 0x88, 0x89, 0x89, 0x87, 0x86, 0x87, 0x85, 0x82,
			0x82, 0x84, 0x7f, 0x80, 0x80, 0x81, 0x83, 0x7d, 0x7f, 0x63, 0x7c,
			0x78, 0x49, 0x7f, 0x64, 0x5a, 0x7a, 0x5d, 0x7c, 0x7f, 0x75, 0x8b,
			0x92, 0x95, 0x8f, 0x9e, 0x9a, 0x94, 0x9e, 0x8b, 0x96, 0x94, 0x7a,
			0x8a, 0x83, 0x76, 0x7b, 0x75, 0x78, 0x74, 0x73, 0x72, 0x77, 0x7a,
			0x71, 0x7f, 0x7f, 0x7b, 0x83, 0x7f, 0x86, 0x86, 0x81, 0x88, 0x86,
			0x83, 0x7f, 0x80, 0x82, 0x79, 0x7a, 0x7d, 0x78, 0x77, 0x79, 0x7c,
			0x7b, 0x7c, 0x7f, 0x83, 0x84, 0x83, 0x89, 0x8a, 0x88, 0x89, 0x8a,
			0x89, 0x87, 0x86, 0x86, 0x83, 0x80, 0x7f, 0x80, 0x7f, 0x7c, 0x81,
			0x7f, 0x81, 0x6b, 0x66, 0x8d, 0x51, 0x57, 0x8a, 0x4d, 0x68, 0x74,
			0x65, 0x84, 0x77, 0x88, 0x8d, 0x9a, 0xa1, 0x85, 0xaa, 0xa4, 0x8a,
			0xa2, 0x95, 0x8c, 0x8b, 0x7e, 0x81, 0x7f, 0x77, 0x74, 0x73, 0x7a,
			0x6e, 0x6c, 0x7d, 0x75, 0x75, 0x7b, 0x7a, 0x82, 0x7d, 0x7f, 0x86,
			0x84, 0x87, 0x83, 0x86, 0x8a, 0x83, 0x83, 0x83, 0x83, 0x7c, 0x76,
			0x7d, 0x79, 0x72, 0x76, 0x77, 0x77, 0x76, 0x7b, 0x81, 0x80, 0x84,
			0x86, 0x89, 0x8c, 0x89, 0x8b, 0x8c, 0x8b, 0x88, 0x86, 0x86, 0x83,
			0x80, 0x80, 0x7e, 0x7d, 0x7c, 0x7c, 0x7d, 0x7f, 0x80, 0x7e, 0x80,
			0x74, 0x69, 0x79, 0x72, 0x65, 0x67, 0x6b, 0x76, 0x6a, 0x6a, 0x82,
			0x83, 0x81, 0x89, 0x92, 0x94, 0x8f, 0x96, 0x9a, 0x92, 0x92, 0x94,
			0x8e, 0x86, 0x86, 0x86, 0x81, 0x7d, 0x7d, 0x7c, 0x79, 0x78, 0x79,
			0x7a, 0x78, 0x76, 0x78, 0x7b, 0x79, 0x79, 0x7c, 0x7e, 0x7c, 0x7d,
			0x81, 0x82, 0x80, 0x83, 0x84, 0x82, 0x82, 0x83, 0x82, 0x7f, 0x7e,
			0x80, 0x7d, 0x79, 0x7a, 0x7c, 0x7a, 0x7b, 0x7e, 0x7e, 0x7e, 0x81,
			0x82, 0x83, 0x84, 0x86, 0x87, 0x86, 0x86, 0x87, 0x87, 0x86, 0x85,
			0x84, 0x83, 0x81, 0x81, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7e, 0x71, 0x71, 0x79, 0x71, 0x64, 0x69, 0x74, 0x6d,
			0x68, 0x77, 0x7c, 0x79, 0x83, 0x8e, 0x8b, 0x88, 0x94, 0x9a, 0x94,
			0x92, 0x96, 0x94, 0x8d, 0x8c, 0x8c, 0x88, 0x83, 0x82, 0x81, 0x7e,
			0x7a, 0x79, 0x7a, 0x78, 0x72, 0x74, 0x77, 0x74, 0x72, 0x77, 0x79,
			0x76, 0x79, 0x7e, 0x7e, 0x7e, 0x81, 0x85, 0x83, 0x83, 0x85, 0x86,
			0x84, 0x84, 0x84, 0x81, 0x80, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7e, 0x80, 0x80, 0x82, 0x84, 0x84, 0x85, 0x86, 0x86,
			0x86, 0x85, 0x86, 0x85, 0x82, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x75, 0x6c, 0x74, 0x76,
			0x68, 0x64, 0x71, 0x73, 0x6a, 0x73, 0x7f, 0x7d, 0x82, 0x8c, 0x90,
			0x8b, 0x90, 0x9a, 0x97, 0x92, 0x94, 0x96, 0x91, 0x8e, 0x8c, 0x89,
			0x86, 0x82, 0x7f, 0x7d, 0x78, 0x74, 0x75, 0x74, 0x70, 0x6f, 0x73,
			0x74, 0x72, 0x75, 0x7a, 0x7a, 0x7b, 0x80, 0x83, 0x82, 0x85, 0x88,
			0x87, 0x86, 0x87, 0x86, 0x85, 0x83, 0x81, 0x7f, 0x7d, 0x7d, 0x7c,
			0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7d, 0x7f, 0x80, 0x82, 0x83,
			0x85, 0x86, 0x87, 0x87, 0x88, 0x87, 0x86, 0x86, 0x84, 0x83, 0x83,
			0x81, 0x7f, 0x7e, 0x7d, 0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7d,
			0x7d, 0x7e, 0x7e, 0x7f, 0x7b, 0x72, 0x75, 0x7b, 0x73, 0x6b, 0x72,
			0x7a, 0x73, 0x74, 0x7f, 0x82, 0x81, 0x89, 0x8e, 0x89, 0x8b, 0x93,
			0x93, 0x8f, 0x8e, 0x90, 0x8d, 0x89, 0x89, 0x86, 0x84, 0x81, 0x7e,
			0x7c, 0x7a, 0x77, 0x77, 0x78, 0x76, 0x73, 0x76, 0x78, 0x77, 0x78,
			0x7b, 0x7d, 0x7d, 0x7f, 0x81, 0x81, 0x81, 0x83, 0x83, 0x82, 0x81,
			0x80, 0x80, 0x81, 0x7f, 0x7e, 0x7f, 0x80, 0x7d, 0x7d, 0x7f, 0x7e,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x83, 0x82, 0x82, 0x84, 0x84, 0x83,
			0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d,
			0x7c, 0x7c, 0x7e, 0x7d, 0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x81,
			0x82, 0x81, 0x80, 0x80, 0x7d, 0x77, 0x75, 0x78, 0x76, 0x70, 0x72,
			0x78, 0x76, 0x76, 0x7d, 0x81, 0x81, 0x85, 0x8a, 0x89, 0x8a, 0x8e,
			0x90, 0x8d, 0x8c, 0x8d, 0x8c, 0x89, 0x87, 0x86, 0x84, 0x83, 0x80,
			0x7f, 0x7d, 0x7a, 0x79, 0x78, 0x77, 0x75, 0x75, 0x76, 0x76, 0x77,
			0x79, 0x7b, 0x7c, 0x7e, 0x80, 0x81, 0x82, 0x84, 0x84, 0x82, 0x82,
			0x82, 0x81, 0x7e, 0x7d, 0x7f, 0x7e, 0x7d, 0x7e, 0x80, 0x7f, 0x7f,
			0x81, 0x81, 0x80, 0x81, 0x83, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
			0x84, 0x83, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7c, 0x7b,
			0x7b, 0x7b, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x82, 0x82,
			0x83, 0x83, 0x83, 0x84, 0x84, 0x83, 0x84, 0x83, 0x81, 0x81, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c, 0x7d, 0x7e,
			0x7e, 0x7f, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82,
			0x82, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7e, 0x7d, 0x79, 0x78, 0x7a, 0x78, 0x76, 0x76,
			0x79, 0x79, 0x79, 0x7d, 0x7f, 0x81, 0x83, 0x87, 0x88, 0x88, 0x8b,
			0x8c, 0x8b, 0x8b, 0x8b, 0x8a, 0x88, 0x86, 0x85, 0x83, 0x81, 0x7f,
			0x7e, 0x7c, 0x7a, 0x7a, 0x79, 0x79, 0x78, 0x78, 0x7a, 0x7a, 0x7a,
			0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x82, 0x82, 0x82, 0x82,
			0x82, 0x82, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x82,
			0x83, 0x83, 0x83, 0x83, 0x84, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d,
			0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x80,
			0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x80, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f,
		},
		{ // 9
			0x7f, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x81, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x81, 0x7d, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f,
			0x7d, 0x7f, 0x7f, 0x7d, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x81, 0x80,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x80, 0x7e, 0x7f,
			0x7e, 0x7e, 0x7e, 0x83, 0x84, 0x82, 0x81, 0x82, 0x80, 0x7e, 0x84,
			0x7e, 0x81, 0x81, 0x7d, 0x7f, 0x7f, 0x7d, 0x81, 0x7f, 0x7e, 0x82,
			0x7c, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x7d, 0x7f, 0x7c, 0x7f,
			0x7c, 0x7c, 0x7e, 0x7c, 0x7d, 0x7d, 0x7c, 0x7f, 0x7f, 0x7d, 0x81,
			0x80, 0x81, 0x82, 0x80, 0x84, 0x82, 0x82, 0x85, 0x81, 0x84, 0x83,
			0x81, 0x82, 0x82, 0x81, 0x81, 0x82, 0x80, 0x80, 0x7f, 0x7d, 0x80,
			0x7e, 0x7c, 0x7f, 0x7b, 0x7d, 0x7b, 0x7c, 0x7d, 0x7c, 0x7d, 0x7f,
			0x7e, 0x7f, 0x80, 0x7f, 0x83, 0x80, 0x83, 0x83, 0x80, 0x83, 0x81,
			0x81, 0x84, 0x81, 0x7f, 0x83, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x7e,
			0x7e, 0x80, 0x7d, 0x7f, 0x7f, 0x80, 0x82, 0x7f, 0x82, 0x76, 0x7c,
			0x85, 0x6f, 0x7e, 0x7b, 0x72, 0x82, 0x6e, 0x7a, 0x84, 0x74, 0x83,
			0x7f, 0x83, 0x88, 0x82, 0x88, 0x8a, 0x8a, 0x84, 0x8a, 0x87, 0x84,
			0x87, 0x7e, 0x87, 0x82, 0x7a, 0x84, 0x7c, 0x7d, 0x7f, 0x77, 0x80,
			0x7c, 0x79, 0x7d, 0x7e, 0x7c, 0x7a, 0x7b, 0x7e, 0x7a, 0x7b, 0x7f,
			0x7e, 0x7e, 0x7f, 0x82, 0x83, 0x81, 0x84, 0x86, 0x84, 0x84, 0x84,
			0x86, 0x82, 0x80, 0x83, 0x81, 0x7e, 0x7f, 0x7e, 0x7f, 0x7d, 0x7b,
			0x80, 0x7f, 0x7d, 0x80, 0x80, 0x84, 0x80, 0x87, 0x77, 0x72, 0x90,
			0x67, 0x74, 0x81, 0x62, 0x85, 0x6b, 0x6c, 0x8d, 0x6e, 0x80, 0x88,
			0x81, 0x91, 0x88, 0x8b, 0x95, 0x90, 0x86, 0x91, 0x8c, 0x83, 0x8a,
			0x7a, 0x85, 0x80, 0x70, 0x84, 0x76, 0x77, 0x7d, 0x72, 0x81, 0x7c,
			0x75, 0x82, 0x80, 0x7a, 0x83, 0x7e, 0x81, 0x81, 0x79, 0x84, 0x7d,
			0x7b, 0x82, 0x7e, 0x81, 0x80, 0x7f, 0x87, 0x81, 0x81, 0x8a, 0x82,
			0x85, 0x84, 0x83, 0x85, 0x7f, 0x81, 0x82, 0x7d, 0x7e, 0x7e, 0x7c,
			0x80, 0x7b, 0x81, 0x81, 0x82, 0x82, 0x89, 0x7b, 0x60, 0x9b, 0x65,
			0x5e, 0x8f, 0x4f, 0x86, 0x6c, 0x59, 0x9d, 0x68, 0x7c, 0x94, 0x81,
			0x9b, 0x8e, 0x8f, 0xa1, 0x97, 0x86, 0x99, 0x92, 0x7e, 0x8c, 0x73,
			0x83, 0x7c, 0x60, 0x82, 0x6f, 0x6c, 0x78, 0x70, 0x7f, 0x7c, 0x75,
			0x89, 0x89, 0x7a, 0x8c, 0x88, 0x85, 0x87, 0x7c, 0x89, 0x7c, 0x75,
			0x80, 0x79, 0x78, 0x7b, 0x7c, 0x83, 0x7d, 0x81, 0x8d, 0x84, 0x87,
			0x8b, 0x88, 0x88, 0x82, 0x84, 0x84, 0x7a, 0x7b, 0x7f, 0x77, 0x7a,
			0x7a, 0x7d, 0x86, 0x7b, 0x8e, 0x56, 0x80, 0x9e, 0x30, 0x96, 0x70,
			0x58, 0x98, 0x44, 0x93, 0x8e, 0x60, 0x9d, 0x8f, 0x90, 0x97, 0x90,
			0x9a, 0x9e, 0x84, 0x86, 0x9e, 0x74, 0x7b, 0x7f, 0x6e, 0x83, 0x5f,
			0x74, 0x82, 0x66, 0x78, 0x80, 0x81, 0x7f, 0x82, 0x89, 0x8f, 0x81,
			0x85, 0x8f, 0x81, 0x7f, 0x7e, 0x80, 0x77, 0x6f, 0x79, 0x7a, 0x72,
			0x78, 0x82, 0x82, 0x81, 0x86, 0x8f, 0x8a, 0x85, 0x8e, 0x8c, 0x83,
			0x82, 0x82, 0x81, 0x78, 0x79, 0x7f, 0x77, 0x79, 0x76, 0x89, 0x7e,
			0x90, 0x6c, 0x53, 0xbf, 0x42, 0x5e, 0xa0, 0x3f, 0x98, 0x5b, 0x68,
			0xb0, 0x62, 0x86, 0xa2, 0x92, 0x94, 0x92, 0x97, 0x9c, 0x8e, 0x75,
			0x95, 0x86, 0x62, 0x7f, 0x6e, 0x79, 0x6e, 0x65, 0x8b, 0x78, 0x73,
			0x86, 0x91, 0x82, 0x86, 0x8c, 0x8d, 0x8a, 0x77, 0x88, 0x82, 0x72,
			0x75, 0x77, 0x76, 0x70, 0x70, 0x7e, 0x7e, 0x76, 0x88, 0x8d, 0x88,
			0x88, 0x8e, 0x90, 0x85, 0x82, 0x89, 0x82, 0x79, 0x7c, 0x7d, 0x7b,
			0x74, 0x7d, 0x80, 0x7b, 0x7d, 0x85, 0x8c, 0x89, 0x93, 0x4b, 0x89,
			0x9f, 0x1d, 0x93, 0x71, 0x4f, 0x93, 0x49, 0x92, 0x98, 0x67, 0x9d,
			0xa5, 0x96, 0x91, 0x9c, 0x99, 0x91, 0x83, 0x72, 0x91, 0x6f, 0x5c,
			0x7d, 0x6c, 0x74, 0x6a, 0x7a, 0x8d, 0x7c, 0x81, 0x94, 0x98, 0x81,
			0x8c, 0x8e, 0x88, 0x7c, 0x73, 0x80, 0x73, 0x69, 0x6e, 0x79, 0x71,
			0x70, 0x80, 0x86, 0x83, 0x85, 0x93, 0x92, 0x88, 0x89, 0x8f, 0x85,
			0x79, 0x7f, 0x7f, 0x76, 0x74, 0x7a, 0x7f, 0x79, 0x7b, 0x88, 0x83,
			0x84, 0x84, 0x8e, 0x8b, 0x90, 0x78, 0x48, 0xa4, 0x60, 0x31, 0x98,
			0x50, 0x6e, 0x79, 0x62, 0xa5, 0x8b, 0x83, 0xa6, 0xad, 0x95, 0x91,
			0x9f, 0x8c, 0x84, 0x75, 0x6e, 0x82, 0x5f, 0x60, 0x79, 0x73, 0x73,
			0x79, 0x8d, 0x8e, 0x89, 0x8b, 0x9b, 0x92, 0x81, 0x88, 0x84, 0x7b,
			0x6e, 0x70, 0x73, 0x6c, 0x64, 0x75, 0x7e, 0x74, 0x82, 0x8d, 0x8e,
			0x8c, 0x8e, 0x93, 0x8e, 0x80, 0x83, 0x85, 0x75, 0x75, 0x7a, 0x79,
			0x76, 0x79, 0x81, 0x83, 0x7f, 0x86, 0x8b, 0x86, 0x85, 0x85, 0x8e,
			0x83, 0x84, 0x5b, 0x66, 0x91, 0x3a, 0x62, 0x7f, 0x5a, 0x7c, 0x74,
			0x89, 0x9c, 0x8f, 0x96, 0xaa, 0xa1, 0x8e, 0x94, 0x90, 0x7e, 0x77,
			0x6f, 0x6f, 0x71, 0x62, 0x6e, 0x7c, 0x79, 0x7b, 0x8b, 0x92, 0x8e,
			0x90, 0x8e, 0x96, 0x87, 0x7d, 0x82, 0x79, 0x70, 0x6d, 0x70, 0x6f,
			0x6c, 0x72, 0x7f, 0x7e, 0x80, 0x8d, 0x8f, 0x8d, 0x8d, 0x8d, 0x8b,
			0x82, 0x7d, 0x80, 0x79, 0x74, 0x78, 0x7a, 0x79, 0x7b, 0x81, 0x85,
			0x83, 0x86, 0x8b, 0x85, 0x86, 0x82, 0x86, 0x84, 0x83, 0x7a, 0x46,
			0x83, 0x79, 0x3a, 0x7c, 0x75, 0x6b, 0x7b, 0x81, 0x90, 0x9b, 0x93,
			0x92, 0xab, 0x97, 0x87, 0x91, 0x89, 0x77, 0x77, 0x70, 0x71, 0x73,
			0x68, 0x74, 0x81, 0x7b, 0x80, 0x90, 0x8c, 0x8b, 0x90, 0x8e, 0x8a,
			0x83, 0x7f, 0x7d, 0x78, 0x70, 0x71, 0x70, 0x70, 0x72, 0x76, 0x7f,
			0x82, 0x85, 0x8b, 0x8e, 0x8c, 0x8b, 0x89, 0x87, 0x82, 0x7d, 0x7c,
			0x7a, 0x78, 0x78, 0x7b, 0x7b, 0x7d, 0x81, 0x82, 0x84, 0x86, 0x85,
			0x85, 0x86, 0x83, 0x89, 0x81, 0x88, 0x68, 0x56, 0x90, 0x5f, 0x4d,
			0x7d, 0x74, 0x6b, 0x79, 0x8b, 0x89, 0x99, 0x92, 0x95, 0xa7, 0x95,
			0x89, 0x91, 0x8c, 0x78, 0x7a, 0x76, 0x71, 0x72, 0x6e, 0x70, 0x7c,
			0x7c, 0x7a, 0x89, 0x8a, 0x88, 0x8e, 0x8e, 0x89, 0x89, 0x84, 0x7f,
			0x7e, 0x75, 0x72, 0x75, 0x72, 0x6f, 0x77, 0x7c, 0x7b, 0x83, 0x87,
			0x88, 0x8a, 0x89, 0x88, 0x87, 0x84, 0x7f, 0x7f, 0x7e, 0x7a, 0x7b,
			0x7c, 0x7b, 0x7e, 0x7e, 0x7d, 0x82, 0x82, 0x80, 0x83, 0x83, 0x82,
			0x88, 0x84, 0x89, 0x74, 0x5f, 0x8b, 0x75, 0x56, 0x73, 0x7e, 0x6e,
			0x6e, 0x86, 0x82, 0x8a, 0x91, 0x8b, 0x97, 0x9a, 0x8f, 0x89, 0x92,
			0x8a, 0x7f, 0x7d, 0x7d, 0x79, 0x74, 0x74, 0x75, 0x78, 0x78, 0x7a,
			0x7e, 0x82, 0x84, 0x86, 0x88, 0x87, 0x87, 0x85, 0x83, 0x80, 0x7d,
			0x7b, 0x79, 0x78, 0x78, 0x79, 0x7b, 0x7e, 0x7e, 0x80, 0x81, 0x83,
			0x83, 0x82, 0x83, 0x82, 0x81, 0x82, 0x81, 0x80, 0x7e, 0x7e, 0x7f,
			0x7d, 0x7d, 0x7f, 0x7e, 0x7e, 0x80, 0x81, 0x82, 0x84, 0x85, 0x84,
			0x8a, 0x71, 0x6d, 0x8b, 0x76, 0x65, 0x73, 0x7f, 0x75, 0x6e, 0x7f,
			0x81, 0x83, 0x88, 0x89, 0x8a, 0x93, 0x91, 0x84, 0x8a, 0x8f, 0x84,
			0x7c, 0x81, 0x80, 0x7a, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7c, 0x7e,
			0x84, 0x81, 0x7e, 0x82, 0x84, 0x7f, 0x7d, 0x80, 0x7d, 0x7b, 0x7d,
			0x7c, 0x7b, 0x7e, 0x7e, 0x7d, 0x81, 0x81, 0x81, 0x81, 0x83, 0x83,
			0x80, 0x82, 0x81, 0x80, 0x80, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f,
			0x7f, 0x7f, 0x81, 0x81, 0x81, 0x83, 0x81, 0x82, 0x84, 0x81, 0x84,
			0x72, 0x72, 0x88, 0x74, 0x6b, 0x79, 0x7f, 0x76, 0x75, 0x81, 0x7f,
			0x83, 0x86, 0x86, 0x87, 0x8c, 0x8d, 0x85, 0x85, 0x8a, 0x85, 0x7d,
			0x81, 0x82, 0x7e, 0x7e, 0x7f, 0x7e, 0x80, 0x81, 0x7e, 0x7f, 0x82,
			0x7f, 0x7d, 0x7d, 0x7f, 0x7c, 0x79, 0x7d, 0x7d, 0x7b, 0x7d, 0x7e,
			0x7e, 0x7f, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x81, 0x81, 0x80,
			0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x80, 0x81,
			0x81, 0x81, 0x82, 0x80, 0x82, 0x80, 0x7e, 0x80, 0x80, 0x80, 0x81,
			0x82, 0x72, 0x76, 0x88, 0x76, 0x70, 0x7b, 0x81, 0x78, 0x73, 0x81,
			0x7e, 0x7e, 0x84, 0x83, 0x84, 0x8b, 0x8a, 0x83, 0x87, 0x8b, 0x86,
			0x80, 0x83, 0x84, 0x81, 0x7e, 0x80, 0x81, 0x7e, 0x7e, 0x7c, 0x7d,
			0x80, 0x7d, 0x7a, 0x7e, 0x7e, 0x7c, 0x7c, 0x7e, 0x7e, 0x7c, 0x7e,
			0x80, 0x80, 0x7f, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x7f,
			0x80, 0x80, 0x81, 0x7f, 0x81, 0x81, 0x81, 0x82, 0x81, 0x82, 0x81,
			0x80, 0x81, 0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x81,
			0x80, 0x83, 0x83, 0x85, 0x7a, 0x70, 0x8a, 0x7c, 0x68, 0x79, 0x7e,
			0x75, 0x6d, 0x7f, 0x7f, 0x7a, 0x85, 0x84, 0x88, 0x8f, 0x8c, 0x87,
			0x8d, 0x8e, 0x85, 0x82, 0x85, 0x82, 0x7a, 0x7c, 0x7e, 0x7a, 0x79,
			0x7c, 0x7b, 0x7c, 0x7f, 0x7e, 0x7f, 0x80, 0x81, 0x7f, 0x80, 0x81,
			0x7f, 0x7e, 0x80, 0x7d, 0x7d, 0x7e, 0x7b, 0x7f, 0x7d, 0x7d, 0x7f,
			0x7e, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x83, 0x81, 0x82, 0x82, 0x81,
			0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x7f, 0x84, 0x81, 0x82, 0x72, 0x70,
			0x8e, 0x6c, 0x67, 0x83, 0x75, 0x70, 0x74, 0x80, 0x7b, 0x81, 0x85,
			0x82, 0x93, 0x8d, 0x86, 0x92, 0x92, 0x86, 0x89, 0x89, 0x83, 0x80,
			0x7d, 0x7b, 0x7d, 0x79, 0x74, 0x7c, 0x7b, 0x77, 0x7d, 0x80, 0x7d,
			0x7f, 0x83, 0x81, 0x84, 0x82, 0x7f, 0x84, 0x82, 0x7d, 0x80, 0x81,
			0x7b, 0x7b, 0x80, 0x7b, 0x79, 0x7d, 0x7c, 0x7c, 0x7b, 0x7f, 0x82,
			0x80, 0x80, 0x85, 0x86, 0x83, 0x86, 0x86, 0x86, 0x84, 0x83, 0x84,
			0x81, 0x7f, 0x7f, 0x7f, 0x7d, 0x7c, 0x7d, 0x7f, 0x7e, 0x7f, 0x81,
			0x87, 0x81, 0x86, 0x77, 0x6d, 0x91, 0x63, 0x6a, 0x82, 0x63, 0x77,
			0x6f, 0x74, 0x81, 0x7d, 0x7f, 0x8e, 0x92, 0x88, 0x97, 0x94, 0x92,
			0x93, 0x8a, 0x8c, 0x8a, 0x7d, 0x7e, 0x7e, 0x76, 0x74, 0x74, 0x75,
			0x74, 0x74, 0x78, 0x7e, 0x7b, 0x7f, 0x84, 0x84, 0x86, 0x85, 0x88,
			0x88, 0x84, 0x82, 0x85, 0x80, 0x7e, 0x7c, 0x79, 0x7c, 0x77, 0x77,
			0x7a, 0x78, 0x78, 0x7b, 0x7d, 0x7e, 0x80, 0x83, 0x86, 0x84, 0x86,
			0x8a, 0x88, 0x85, 0x86, 0x87, 0x84, 0x82, 0x83, 0x82, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7e, 0x7d, 0x7f, 0x7f, 0x80, 0x82, 0x81, 0x83, 0x69,
			0x81, 0x7f, 0x5f, 0x7e, 0x6b, 0x72, 0x74, 0x6a, 0x81, 0x7c, 0x7a,
			0x89, 0x8c, 0x8a, 0x92, 0x8e, 0x96, 0x93, 0x89, 0x91, 0x8b, 0x84,
			0x84, 0x7e, 0x7f, 0x7a, 0x74, 0x7a, 0x77, 0x73, 0x78, 0x79, 0x7a,
			0x7a, 0x7c, 0x81, 0x80, 0x80, 0x85, 0x85, 0x85, 0x85, 0x84, 0x87,
			0x83, 0x82, 0x84, 0x81, 0x7e, 0x7b, 0x7c, 0x7b, 0x76, 0x78, 0x79,
			0x78, 0x77, 0x7b, 0x7e, 0x7d, 0x80, 0x85, 0x85, 0x85, 0x87, 0x89,
			0x88, 0x87, 0x88, 0x87, 0x83, 0x83, 0x82, 0x80, 0x7e, 0x7e, 0x7e,
			0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x80, 0x7e, 0x83, 0x76, 0x75, 0x85,
			0x6e, 0x77, 0x78, 0x72, 0x79, 0x70, 0x79, 0x7f, 0x78, 0x81, 0x85,
			0x84, 0x8b, 0x87, 0x8e, 0x8e, 0x88, 0x8e, 0x8c, 0x88, 0x88, 0x84,
			0x84, 0x82, 0x7d, 0x7f, 0x7d, 0x7a, 0x7a, 0x79, 0x7a, 0x79, 0x7a,
			0x7c, 0x7c, 0x7c, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x83, 0x82, 0x82,
			0x83, 0x83, 0x81, 0x80, 0x81, 0x7f, 0x7d, 0x7d, 0x7d, 0x7c, 0x7b,
			0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x80, 0x80, 0x81, 0x83, 0x82, 0x82,
			0x83, 0x84, 0x83, 0x82, 0x82, 0x82, 0x80, 0x80, 0x81, 0x80, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7d, 0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e,
			0x7e, 0x80, 0x7c, 0x7c, 0x80, 0x7b, 0x7c, 0x7d, 0x7c, 0x7d, 0x7c,
			0x7c, 0x7f, 0x7c, 0x7f, 0x81, 0x80, 0x83, 0x82, 0x83, 0x85, 0x83,
			0x85, 0x85, 0x83, 0x85, 0x83, 0x83, 0x84, 0x82, 0x83, 0x82, 0x81,
			0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7f, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x80, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81,
			0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x81, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x81,
			0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7e, 0x7f, 0x80, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7e,
			0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7e, 0x80, 0x7e, 0x80, 0x7e, 0x7f, 0x81, 0x7e, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x82, 0x7f, 0x7f, 0x82, 0x7f, 0x7f, 0x81,
			0x7f, 0x7e, 0x80, 0x7e, 0x80, 0x80, 0x7d, 0x81, 0x7f, 0x7f, 0x81,
			0x7f, 0x80, 0x81, 0x7e, 0x81, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x81,
			0x7e, 0x80, 0x81, 0x7d, 0x82, 0x7f, 0x7f, 0x82, 0x7e, 0x81, 0x80,
			0x7d, 0x81, 0x7f, 0x7e, 0x81, 0x7e, 0x80, 0x7e, 0x7f, 0x80, 0x7e,
			0x80, 0x80, 0x7f, 0x81, 0x80, 0x7e, 0x82, 0x7f, 0x7e, 0x81, 0x7e,
			0x7e, 0x80, 0x7d, 0x80, 0x80, 0x7c, 0x83, 0x7e, 0x7f, 0x82, 0x7e,
			0x82, 0x80, 0x7f, 0x82, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x80, 0x7d,
			0x82, 0x7d, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x81, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7e, 0x80, 0x7f, 0x7e, 0x82, 0x7e, 0x7f, 0x82,
			0x7e, 0x81, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x81, 0x7e, 0x81, 0x80, 0x7f, 0x81,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7e, 0x81, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x81, 0x7d, 0x82,
			0x80, 0x7e, 0x82, 0x7d, 0x81, 0x80, 0x7d, 0x83, 0x7e, 0x7e, 0x82,
			0x7d, 0x81, 0x7f, 0x7f, 0x82, 0x7e, 0x81, 0x80, 0x7f, 0x81, 0x80,
			0x7f, 0x82, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x7e, 0x81, 0x7f, 0x7e, 0x81, 0x7f, 0x7f, 0x81, 0x7e, 0x80, 0x81,
			0x7e, 0x81, 0x7f, 0x80, 0x80, 0x7e, 0x82, 0x7e, 0x7f, 0x81, 0x7c,
			0x81, 0x7f, 0x7d, 0x82, 0x7d, 0x7f, 0x82, 0x7c, 0x82, 0x81, 0x7d,
			0x83, 0x80, 0x7d, 0x82, 0x7f, 0x7e, 0x82, 0x7d, 0x7f, 0x82, 0x7c,
			0x81, 0x81, 0x7d, 0x81, 0x7e, 0x7f, 0x81, 0x7d, 0x81, 0x81, 0x7e,
			0x7f, 0x81, 0x81, 0x7e, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x7e, 0x81, 0x80, 0x7e, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x81, 0x80, 0x7e, 0x80, 0x80, 0x7e, 0x7f, 0x7e,
			0x80, 0x80, 0x7d, 0x81, 0x81, 0x7d, 0x81, 0x81, 0x7f, 0x81, 0x7f,
			0x80, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x82, 0x7f, 0x7e, 0x82, 0x7e, 0x7e, 0x81,
			0x7e, 0x80, 0x80, 0x7c, 0x82, 0x7f, 0x7c, 0x82, 0x7f, 0x7f, 0x80,
			0x7f, 0x81, 0x80, 0x7e, 0x81, 0x81, 0x7e, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x82, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7e, 0x81, 0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x7f, 0x7e, 0x81,
			0x7f, 0x7d, 0x82, 0x7f, 0x7f, 0x81, 0x7d, 0x82, 0x7f, 0x7e, 0x81,
			0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x7e, 0x7f, 0x80, 0x7e, 0x80, 0x81, 0x7f, 0x81, 0x80, 0x7f, 0x80,
			0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
		},
	},
	"zh": [][]byte{
		{ // 0
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x81,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x80,
			0x80, 0x80, 0x82, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83,
			0x83, 0x83, 0x83, 0x81, 0x81, 0x7f, 0x80, 0x7e, 0x7d, 0x7d, 0x7a,
			0x7a, 0x78, 0x78, 0x77, 0x76, 0x76, 0x77, 0x78, 0x78, 0x7a, 0x7b,
			0x7f, 0x82, 0x83, 0x88, 0x8a, 0x8c, 0x90, 0x8f, 0x94, 0x92, 0x93,
			0x93, 0x90, 0x90, 0x8b, 0x88, 0x84, 0x81, 0x7d, 0x77, 0x73, 0x6e,
			0x69, 0x65, 0x65, 0x61, 0x64, 0x61, 0x66, 0x65, 0x6a, 0x69, 0x71,
			0x73, 0x7b, 0x87, 0x86, 0x97, 0x92, 0xa5, 0x9f, 0xa5, 0xab, 0xa3,
			0xab, 0x9f, 0xa0, 0x98, 0x90, 0x8b, 0x83, 0x7d, 0x76, 0x70, 0x6d,
			0x68, 0x64, 0x62, 0x60, 0x5f, 0x60, 0x5e, 0x5e, 0x60, 0x60, 0x64,
			0x64, 0x70, 0x76, 0x7c, 0x87, 0x8b, 0x99, 0x9a, 0xa5, 0xa9, 0xaa,
			0xae, 0xaa, 0xaa, 0xa2, 0x9e, 0x97, 0x8f, 0x89, 0x81, 0x7d, 0x77,
			0x74, 0x6f, 0x6d, 0x69, 0x66, 0x65, 0x62, 0x61, 0x60, 0x5f, 0x5d,
			0x60, 0x60, 0x64, 0x67, 0x71, 0x74, 0x7f, 0x85, 0x8e, 0x98, 0x9a,
			0xa7, 0xa6, 0xac, 0xab, 0xaa, 0xa9, 0xa3, 0x9f, 0x99, 0x93, 0x8b,
			0x84, 0x7d, 0x77, 0x71, 0x6c, 0x6a, 0x63, 0x63, 0x60, 0x5f, 0x60,
			0x5e, 0x61, 0x60, 0x63, 0x65, 0x69, 0x6e, 0x72, 0x77, 0x7e, 0x83,
			0x8c, 0x91, 0x98, 0x9c, 0xa2, 0xa4, 0xa7, 0xa5, 0xa5, 0xa2, 0xa2,
			0x9d, 0x95, 0x96, 0x88, 0x85, 0x7f, 0x7a, 0x73, 0x73, 0x6d, 0x6a,
			0x66, 0x61, 0x62, 0x5f, 0x61, 0x5f, 0x5f, 0x5f, 0x5e, 0x5c, 0x63,
			0x6b, 0x70, 0x78, 0x83, 0x8a, 0x95, 0x9b, 0xa6, 0xaa, 0xad, 0xb2,
			0xad, 0xad, 0xa6, 0xa0, 0x9b, 0x91, 0x8e, 0x83, 0x7e, 0x79, 0x73,
			0x72, 0x6c, 0x6f, 0x6a, 0x6b, 0x6b, 0x67, 0x63, 0x62, 0x5f, 0x5e,
			0x59, 0x5b, 0x58, 0x54, 0x5b, 0x62, 0x71, 0x79, 0x8d, 0x99, 0xa1,
			0xad, 0xb5, 0xb6, 0xbc, 0xb8, 0xb3, 0xaf, 0xa7, 0x9e, 0x95, 0x8f,
			0x84, 0x7e, 0x77, 0x73, 0x6f, 0x6d, 0x6d, 0x6c, 0x6e, 0x6e, 0x6e,
			0x6e, 0x69, 0x66, 0x63, 0x5d, 0x5e, 0x57, 0x57, 0x51, 0x53, 0x57,
			0x5d, 0x73, 0x76, 0x8e, 0x99, 0xa4, 0xaf, 0xb6, 0xbc, 0xba, 0xbe,
			0xb5, 0xaf, 0xab, 0x9c, 0x95, 0x8f, 0x82, 0x7f, 0x76, 0x72, 0x70,
			0x6b, 0x6e, 0x6c, 0x6e, 0x6f, 0x6f, 0x73, 0x6e, 0x6e, 0x69, 0x66,
			0x62, 0x5d, 0x5e, 0x55, 0x5a, 0x51, 0x5a, 0x5c, 0x67, 0x77, 0x7f,
			0x97, 0x9a, 0xab, 0xb1, 0xb8, 0xbb, 0xba, 0xbb, 0xb4, 0xad, 0xa7,
			0x9c, 0x94, 0x8c, 0x83, 0x7d, 0x77, 0x72, 0x6f, 0x6c, 0x6d, 0x6b,
			0x6d, 0x6f, 0x6e, 0x70, 0x6e, 0x6f, 0x6b, 0x6b, 0x65, 0x65, 0x5f,
			0x5d, 0x5c, 0x56, 0x59, 0x5a, 0x5d, 0x6c, 0x74, 0x81, 0x94, 0x98,
			0xaa, 0xad, 0xb7, 0xbb, 0xbb, 0xbd, 0xb5, 0xb2, 0xa8, 0xa2, 0x98,
			0x8f, 0x88, 0x7b, 0x7a, 0x72, 0x6d, 0x6d, 0x69, 0x6b, 0x6a, 0x6d,
			0x6e, 0x6f, 0x71, 0x70, 0x70, 0x6d, 0x6b, 0x68, 0x66, 0x62, 0x61,
			0x5e, 0x5d, 0x5e, 0x5d, 0x63, 0x69, 0x75, 0x7b, 0x8e, 0x93, 0x9e,
			0xaa, 0xac, 0xb7, 0xb6, 0xb9, 0xb7, 0xb1, 0xad, 0xa4, 0x9b, 0x94,
			0x87, 0x82, 0x79, 0x73, 0x70, 0x6b, 0x6d, 0x69, 0x6b, 0x6f, 0x6d,
			0x73, 0x71, 0x72, 0x72, 0x70, 0x6e, 0x6c, 0x68, 0x64, 0x63, 0x5f,
			0x60, 0x5d, 0x5f, 0x62, 0x64, 0x6e, 0x78, 0x7f, 0x90, 0x95, 0x9f,
			0xa9, 0xac, 0xb3, 0xb6, 0xb6, 0xb5, 0xb1, 0xaa, 0xa5, 0x99, 0x92,
			0x89, 0x80, 0x7a, 0x73, 0x6f, 0x6c, 0x6b, 0x6b, 0x6c, 0x6e, 0x6e,
			0x72, 0x73, 0x71, 0x75, 0x70, 0x70, 0x6d, 0x69, 0x69, 0x64, 0x65,
			0x62, 0x64, 0x64, 0x65, 0x69, 0x6c, 0x72, 0x7d, 0x80, 0x8f, 0x95,
			0x9a, 0xa7, 0xa5, 0xaf, 0xb0, 0xb0, 0xb0, 0xab, 0xa6, 0xa2, 0x97,
			0x92, 0x88, 0x7f, 0x7a, 0x73, 0x70, 0x6e, 0x6c, 0x6e, 0x6d, 0x6f,
			0x72, 0x71, 0x76, 0x73, 0x76, 0x74, 0x72, 0x72, 0x6d, 0x6c, 0x69,
			0x66, 0x67, 0x66, 0x69, 0x6a, 0x6b, 0x6e, 0x73, 0x74, 0x7e, 0x84,
			0x87, 0x96, 0x94, 0x9e, 0xa2, 0xa3, 0xab, 0xa8, 0xab, 0xa8, 0xa4,
			0x9f, 0x99, 0x91, 0x8b, 0x83, 0x7b, 0x76, 0x72, 0x6f, 0x6e, 0x6e,
			0x6f, 0x6f, 0x71, 0x73, 0x75, 0x76, 0x76, 0x77, 0x75, 0x74, 0x73,
			0x70, 0x70, 0x6d, 0x6c, 0x6b, 0x6b, 0x6e, 0x6e, 0x70, 0x72, 0x75,
			0x77, 0x7c, 0x82, 0x86, 0x8d, 0x93, 0x94, 0x9e, 0x9d, 0xa2, 0xa6,
			0xa1, 0xa7, 0x9e, 0x9e, 0x99, 0x90, 0x8d, 0x84, 0x7e, 0x79, 0x76,
			0x71, 0x72, 0x6f, 0x71, 0x72, 0x72, 0x76, 0x75, 0x78, 0x76, 0x77,
			0x77, 0x76, 0x76, 0x74, 0x73, 0x72, 0x71, 0x71, 0x70, 0x72, 0x72,
			0x74, 0x76, 0x77, 0x79, 0x79, 0x7d, 0x7b, 0x81, 0x82, 0x88, 0x8c,
			0x8f, 0x95, 0x96, 0x9b, 0x9d, 0x9e, 0x9f, 0x9d, 0x9b, 0x97, 0x93,
			0x8d, 0x87, 0x82, 0x7d, 0x79, 0x76, 0x74, 0x73, 0x73, 0x73, 0x74,
			0x75, 0x77, 0x77, 0x78, 0x78, 0x77, 0x77, 0x75, 0x74, 0x74, 0x73,
			0x73, 0x73, 0x73, 0x74, 0x73, 0x76, 0x75, 0x78, 0x78, 0x7a, 0x78,
			0x7e, 0x79, 0x81, 0x82, 0x84, 0x8f, 0x89, 0x98, 0x93, 0x9a, 0x9d,
			0x9b, 0xa1, 0x9a, 0x9c, 0x97, 0x90, 0x8f, 0x86, 0x82, 0x7f, 0x78,
			0x78, 0x74, 0x73, 0x75, 0x73, 0x76, 0x76, 0x77, 0x79, 0x77, 0x7a,
			0x77, 0x78, 0x77, 0x75, 0x77, 0x74, 0x75, 0x75, 0x75, 0x77, 0x75,
			0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x78, 0x7d, 0x76, 0x81, 0x7d,
			0x84, 0x8a, 0x87, 0x96, 0x8e, 0x9b, 0x99, 0x9b, 0x9f, 0x9a, 0x9b,
			0x96, 0x91, 0x8d, 0x87, 0x82, 0x7f, 0x79, 0x79, 0x75, 0x74, 0x75,
			0x75, 0x75, 0x79, 0x75, 0x7a, 0x78, 0x78, 0x7a, 0x77, 0x7a, 0x78,
			0x78, 0x78, 0x76, 0x77, 0x76, 0x75, 0x76, 0x75, 0x77, 0x76, 0x78,
			0x78, 0x78, 0x78, 0x7b, 0x78, 0x81, 0x7e, 0x84, 0x8b, 0x88, 0x95,
			0x92, 0x99, 0x9b, 0x9a, 0x9e, 0x9b, 0x98, 0x97, 0x8f, 0x8e, 0x88,
			0x83, 0x82, 0x7b, 0x7b, 0x78, 0x77, 0x77, 0x76, 0x77, 0x76, 0x78,
			0x76, 0x78, 0x78, 0x77, 0x79, 0x76, 0x79, 0x77, 0x78, 0x78, 0x77,
			0x78, 0x77, 0x78, 0x78, 0x78, 0x79, 0x79, 0x79, 0x79, 0x7c, 0x7a,
			0x81, 0x80, 0x86, 0x8b, 0x8a, 0x94, 0x93, 0x97, 0x9a, 0x99, 0x9b,
			0x99, 0x95, 0x94, 0x8e, 0x8b, 0x87, 0x82, 0x81, 0x7c, 0x7b, 0x7a,
			0x77, 0x77, 0x75, 0x74, 0x74, 0x73, 0x75, 0x73, 0x77, 0x76, 0x75,
			0x7a, 0x76, 0x7b, 0x7b, 0x7b, 0x7f, 0x7a, 0x7f, 0x7b, 0x7c, 0x7d,
			0x7b, 0x7d, 0x7c, 0x7d, 0x7f, 0x84, 0x83, 0x8c, 0x8b, 0x90, 0x94,
			0x92, 0x99, 0x94, 0x97, 0x95, 0x91, 0x92, 0x8a, 0x8a, 0x85, 0x81,
			0x80, 0x7b, 0x7a, 0x77, 0x76, 0x76, 0x75, 0x75, 0x76, 0x73, 0x76,
			0x74, 0x75, 0x78, 0x76, 0x79, 0x79, 0x79, 0x7c, 0x7b, 0x7c, 0x7e,
			0x7d, 0x7f, 0x7d, 0x7f, 0x7f, 0x7f, 0x82, 0x82, 0x86, 0x87, 0x8c,
			0x8c, 0x90, 0x92, 0x91, 0x97, 0x91, 0x95, 0x91, 0x8e, 0x8d, 0x88,
			0x87, 0x82, 0x81, 0x7d, 0x7b, 0x7a, 0x77, 0x77, 0x75, 0x76, 0x75,
			0x76, 0x76, 0x76, 0x77, 0x77, 0x77, 0x78, 0x7a, 0x78, 0x7c, 0x79,
			0x7b, 0x7b, 0x7a, 0x7d, 0x7a, 0x7f, 0x7d, 0x7e, 0x80, 0x7e, 0x82,
			0x85, 0x85, 0x8d, 0x8c, 0x8f, 0x95, 0x90, 0x97, 0x94, 0x93, 0x93,
			0x8f, 0x8d, 0x8a, 0x87, 0x84, 0x80, 0x7d, 0x7a, 0x79, 0x76, 0x76,
			0x75, 0x74, 0x74, 0x72, 0x74, 0x73, 0x75, 0x76, 0x75, 0x78, 0x77,
			0x7a, 0x79, 0x7a, 0x7a, 0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x7b,
			0x7f, 0x7b, 0x80, 0x83, 0x84, 0x8c, 0x8b, 0x8f, 0x93, 0x94, 0x98,
			0x97, 0x96, 0x96, 0x93, 0x8f, 0x8e, 0x88, 0x85, 0x80, 0x7d, 0x7b,
			0x78, 0x76, 0x75, 0x74, 0x74, 0x74, 0x73, 0x75, 0x72, 0x74, 0x73,
			0x73, 0x75, 0x74, 0x75, 0x75, 0x77, 0x75, 0x78, 0x78, 0x78, 0x7a,
			0x78, 0x7a, 0x7a, 0x7d, 0x7c, 0x84, 0x85, 0x8b, 0x94, 0x93, 0x9c,
			0x9b, 0x9d, 0x9e, 0x9c, 0x9b, 0x98, 0x95, 0x8f, 0x8d, 0x88, 0x83,
			0x81, 0x7d, 0x7a, 0x79, 0x76, 0x74, 0x74, 0x71, 0x71, 0x6f, 0x6f,
			0x6e, 0x6c, 0x6d, 0x6c, 0x6d, 0x6e, 0x6f, 0x71, 0x72, 0x74, 0x74,
			0x76, 0x76, 0x79, 0x7a, 0x7a, 0x7d, 0x7c, 0x84, 0x88, 0x91, 0x97,
			0x9b, 0xa0, 0xa0, 0xa3, 0xa3, 0xa3, 0xa1, 0x9c, 0x99, 0x93, 0x8f,
			0x8a, 0x86, 0x82, 0x7e, 0x7d, 0x7a, 0x79, 0x76, 0x74, 0x73, 0x6f,
			0x6f, 0x6c, 0x6b, 0x6b, 0x6a, 0x6b, 0x6a, 0x6b, 0x6b, 0x6e, 0x6f,
			0x72, 0x74, 0x75, 0x77, 0x77, 0x78, 0x78, 0x79, 0x79, 0x7c, 0x82,
			0x87, 0x8f, 0x96, 0x9a, 0xa0, 0xa1, 0xa4, 0xa4, 0xa5, 0xa2, 0xa0,
			0x9b, 0x96, 0x91, 0x8c, 0x88, 0x83, 0x80, 0x7c, 0x7b, 0x79, 0x78,
			0x76, 0x73, 0x71, 0x6f, 0x6e, 0x6c, 0x6b, 0x6b, 0x6a, 0x6a, 0x6a,
			0x6a, 0x6c, 0x6e, 0x70, 0x73, 0x74, 0x76, 0x76, 0x79, 0x79, 0x7a,
			0x7a, 0x79, 0x7b, 0x7f, 0x86, 0x8d, 0x95, 0x98, 0x9d, 0x9f, 0xa2,
			0xa3, 0xa5, 0xa2, 0xa0, 0x9d, 0x98, 0x94, 0x8f, 0x8a, 0x86, 0x82,
			0x7e, 0x7c, 0x7a, 0x78, 0x76, 0x75, 0x72, 0x71, 0x6e, 0x6c, 0x6c,
			0x6a, 0x6b, 0x6a, 0x6a, 0x6b, 0x6b, 0x6d, 0x6f, 0x71, 0x73, 0x74,
			0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7a, 0x7b, 0x7c, 0x80, 0x85, 0x8b,
			0x91, 0x96, 0x9a, 0x9d, 0x9f, 0xa1, 0xa1, 0xa0, 0x9e, 0x9b, 0x97,
			0x94, 0x90, 0x8b, 0x87, 0x83, 0x80, 0x7e, 0x7b, 0x7a, 0x79, 0x77,
			0x75, 0x73, 0x70, 0x6e, 0x6c, 0x6b, 0x6a, 0x6a, 0x6a, 0x6a, 0x6b,
			0x6b, 0x6d, 0x6f, 0x71, 0x73, 0x75, 0x77, 0x78, 0x79, 0x7a, 0x7b,
			0x7b, 0x7c, 0x7d, 0x7f, 0x83, 0x88, 0x8e, 0x93, 0x96, 0x99, 0x9c,
			0x9e, 0xa0, 0xa0, 0x9f, 0x9d, 0x9a, 0x97, 0x94, 0x8f, 0x8b, 0x87,
			0x84, 0x80, 0x7e, 0x7c, 0x7a, 0x78, 0x76, 0x74, 0x72, 0x70, 0x6e,
			0x6c, 0x6b, 0x6b, 0x6b, 0x6a, 0x6a, 0x6b, 0x6b, 0x6d, 0x6f, 0x70,
			0x72, 0x74, 0x75, 0x77, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7b, 0x7c,
			0x7f, 0x84, 0x89, 0x8f, 0x92, 0x96, 0x98, 0x9c, 0x9e, 0xa0, 0xa0,
			0x9f, 0x9d, 0x9a, 0x97, 0x93, 0x90, 0x8b, 0x88, 0x83, 0x81, 0x7e,
			0x7c, 0x7a, 0x78, 0x76, 0x74, 0x73, 0x70, 0x6e, 0x6c, 0x6b, 0x6a,
			0x6a, 0x69, 0x69, 0x69, 0x6a, 0x6b, 0x6d, 0x6e, 0x71, 0x73, 0x74,
			0x76, 0x77, 0x79, 0x7a, 0x7b, 0x7b, 0x7b, 0x7c, 0x80, 0x85, 0x8a,
			0x90, 0x93, 0x96, 0x9a, 0x9d, 0xa0, 0xa2, 0xa2, 0x9f, 0x9e, 0x9b,
			0x98, 0x94, 0x90, 0x8b, 0x87, 0x83, 0x80, 0x7e, 0x7b, 0x79, 0x76,
			0x75, 0x73, 0x71, 0x6e, 0x6d, 0x6a, 0x6a, 0x6a, 0x69, 0x68, 0x68,
			0x69, 0x6a, 0x6c, 0x6d, 0x6e, 0x70, 0x73, 0x75, 0x77, 0x77, 0x79,
			0x7a, 0x7c, 0x7c, 0x7d, 0x7d, 0x80, 0x85, 0x8b, 0x91, 0x94, 0x97,
			0x9a, 0x9e, 0xa1, 0xa2, 0xa2, 0xa0, 0x9d, 0x9b, 0x98, 0x94, 0x8f,
			0x8b, 0x87, 0x83, 0x80, 0x7d, 0x7a, 0x78, 0x76, 0x75, 0x72, 0x70,
			0x6d, 0x6b, 0x6a, 0x69, 0x69, 0x67, 0x67, 0x67, 0x68, 0x69, 0x6b,
			0x6c, 0x6e, 0x71, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7b, 0x7c, 0x7c,
			0x7d, 0x81, 0x86, 0x8c, 0x91, 0x95, 0x98, 0x9c, 0x9f, 0xa2, 0xa3,
			0xa2, 0xa0, 0x9e, 0x9b, 0x98, 0x94, 0x90, 0x8a, 0x87, 0x83, 0x80,
			0x7d, 0x7a, 0x78, 0x75, 0x74, 0x72, 0x6f, 0x6d, 0x6c, 0x6b, 0x69,
			0x68, 0x67, 0x66, 0x66, 0x68, 0x69, 0x6a, 0x6c, 0x6f, 0x71, 0x74,
			0x75, 0x77, 0x79, 0x7b, 0x7b, 0x7b, 0x7c, 0x7e, 0x84, 0x88, 0x90,
			0x93, 0x97, 0x9a, 0x9e, 0xa1, 0xa3, 0xa4, 0xa1, 0xa0, 0x9c, 0x9a,
			0x95, 0x92, 0x8d, 0x89, 0x84, 0x82, 0x7e, 0x7b, 0x79, 0x77, 0x74,
			0x72, 0x70, 0x6e, 0x6c, 0x6b, 0x69, 0x67, 0x66, 0x65, 0x65, 0x67,
			0x68, 0x69, 0x6b, 0x6e, 0x70, 0x73, 0x75, 0x77, 0x79, 0x7a, 0x7b,
			0x7c, 0x7c, 0x7e, 0x84, 0x88, 0x90, 0x93, 0x98, 0x9a, 0x9f, 0xa1,
			0xa3, 0xa5, 0xa2, 0xa1, 0x9d, 0x9a, 0x96, 0x92, 0x8d, 0x89, 0x84,
			0x81, 0x7e, 0x7c, 0x79, 0x76, 0x74, 0x71, 0x6f, 0x6d, 0x6c, 0x69,
			0x68, 0x66, 0x65, 0x65, 0x65, 0x65, 0x67, 0x69, 0x6b, 0x6e, 0x71,
			0x73, 0x76, 0x77, 0x79, 0x7a, 0x7b, 0x7d, 0x7f, 0x84, 0x88, 0x90,
			0x94, 0x99, 0x9b, 0x9f, 0xa2, 0xa4, 0xa5, 0xa3, 0xa1, 0x9e, 0x9c,
			0x96, 0x93, 0x8d, 0x8a, 0x85, 0x82, 0x7e, 0x7c, 0x79, 0x76, 0x74,
			0x72, 0x70, 0x6d, 0x6b, 0x67, 0x67, 0x64, 0x65, 0x63, 0x64, 0x63,
			0x65, 0x68, 0x6b, 0x6d, 0x70, 0x73, 0x75, 0x77, 0x79, 0x79, 0x7c,
			0x7e, 0x82, 0x88, 0x8d, 0x93, 0x97, 0x9c, 0x9e, 0xa3, 0xa4, 0xa6,
			0xa4, 0xa3, 0x9f, 0x9d, 0x98, 0x94, 0x8f, 0x8a, 0x86, 0x82, 0x80,
			0x7c, 0x7b, 0x78, 0x77, 0x74, 0x72, 0x6f, 0x6c, 0x69, 0x67, 0x65,
			0x64, 0x63, 0x63, 0x63, 0x64, 0x66, 0x69, 0x6d, 0x70, 0x72, 0x74,
			0x76, 0x78, 0x7a, 0x7d, 0x7f, 0x84, 0x89, 0x90, 0x95, 0x99, 0x9e,
			0xa0, 0xa4, 0xa4, 0xa6, 0xa3, 0xa2, 0x9e, 0x9a, 0x96, 0x92, 0x8e,
			0x88, 0x86, 0x81, 0x7f, 0x7b, 0x7a, 0x77, 0x76, 0x73, 0x71, 0x6d,
			0x6b, 0x68, 0x67, 0x65, 0x64, 0x64, 0x63, 0x64, 0x66, 0x69, 0x6b,
			0x6f, 0x70, 0x73, 0x74, 0x77, 0x78, 0x7b, 0x7d, 0x83, 0x87, 0x8e,
			0x93, 0x98, 0x9c, 0x9f, 0xa2, 0xa4, 0xa5, 0xa3, 0xa2, 0x9e, 0x9c,
			0x96, 0x93, 0x8e, 0x8a, 0x86, 0x83, 0x80, 0x7d, 0x7b, 0x78, 0x77,
			0x74, 0x71, 0x6e, 0x6c, 0x6a, 0x68, 0x66, 0x66, 0x64, 0x64, 0x65,
			0x67, 0x68, 0x6b, 0x6e, 0x70, 0x72, 0x74, 0x75, 0x78, 0x7a, 0x7e,
			0x84, 0x8a, 0x8f, 0x93, 0x98, 0x9b, 0xa0, 0xa2, 0xa4, 0xa3, 0xa2,
			0xa0, 0x9d, 0x99, 0x95, 0x91, 0x8c, 0x89, 0x85, 0x82, 0x7f, 0x7d,
			0x7a, 0x78, 0x76, 0x73, 0x70, 0x6e, 0x6c, 0x6a, 0x69, 0x67, 0x67,
			0x67, 0x67, 0x68, 0x6a, 0x6c, 0x6e, 0x70, 0x72, 0x73, 0x75, 0x77,
			0x7a, 0x7c, 0x80, 0x86, 0x8c, 0x8f, 0x95, 0x98, 0x9b, 0x9f, 0xa0,
			0xa1, 0xa0, 0x9f, 0x9c, 0x9a, 0x96, 0x93, 0x8f, 0x8b, 0x87, 0x83,
			0x80, 0x7e, 0x7b, 0x78, 0x75, 0x73, 0x71, 0x6e, 0x6c, 0x6b, 0x6a,
			0x69, 0x6a, 0x69, 0x6a, 0x6a, 0x6d, 0x6e, 0x70, 0x72, 0x73, 0x75,
			0x77, 0x79, 0x7b, 0x7e, 0x82, 0x88, 0x8d, 0x91, 0x95, 0x98, 0x9a,
			0x9d, 0x9e, 0x9d, 0x9b, 0x9a, 0x97, 0x94, 0x91, 0x8e, 0x8a, 0x87,
			0x84, 0x81, 0x7f, 0x7d, 0x7a, 0x78, 0x76, 0x74, 0x72, 0x70, 0x6f,
			0x6d, 0x6d, 0x6d, 0x6d, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x73, 0x74,
			0x75, 0x77, 0x78, 0x7b, 0x7c, 0x81, 0x84, 0x89, 0x8d, 0x91, 0x94,
			0x96, 0x98, 0x99, 0x9a, 0x99, 0x98, 0x95, 0x93, 0x90, 0x8d, 0x8a,
			0x88, 0x85, 0x82, 0x80, 0x7e, 0x7c, 0x7a, 0x78, 0x76, 0x74, 0x72,
			0x70, 0x6f, 0x6f, 0x6e, 0x6f, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74,
			0x75, 0x76, 0x78, 0x78, 0x79, 0x7a, 0x7c, 0x80, 0x83, 0x87, 0x8b,
			0x8e, 0x91, 0x94, 0x96, 0x97, 0x97, 0x96, 0x95, 0x93, 0x91, 0x8e,
			0x8b, 0x88, 0x86, 0x83, 0x82, 0x80, 0x7e, 0x7d, 0x7b, 0x79, 0x77,
			0x75, 0x74, 0x73, 0x71, 0x71, 0x71, 0x71, 0x72, 0x74, 0x75, 0x78,
			0x7a, 0x7c, 0x7e, 0x7f, 0x81, 0x82, 0x83, 0x83, 0x82, 0x81, 0x80,
			0x7e, 0x7e, 0x7c, 0x7c, 0x7a, 0x7a, 0x7b, 0x7d, 0x80, 0x83, 0x86,
			0x87, 0x8a, 0x8c, 0x8e, 0x8f, 0x90, 0x8f, 0x8e, 0x8d, 0x8b, 0x89,
			0x86, 0x85, 0x82, 0x80, 0x7e, 0x7e, 0x7c, 0x7b, 0x79, 0x79, 0x76,
			0x76, 0x74, 0x73, 0x72, 0x72, 0x72, 0x73, 0x74, 0x75, 0x77, 0x79,
			0x7c, 0x7e, 0x81, 0x82, 0x85, 0x86, 0x88, 0x89, 0x8a, 0x89, 0x89,
			0x89, 0x87, 0x86, 0x84, 0x83, 0x81, 0x80, 0x7e, 0x7e, 0x7c, 0x7c,
			0x7b, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7c, 0x7c, 0x7d,
			0x7e, 0x7f, 0x7f, 0x81, 0x82, 0x84, 0x85, 0x86, 0x88, 0x89, 0x8b,
			0x8b, 0x8c, 0x8b, 0x8b, 0x89, 0x88, 0x86, 0x84, 0x82, 0x7f, 0x7d,
			0x7b, 0x7a, 0x78, 0x77, 0x76, 0x76, 0x75, 0x75, 0x75, 0x75, 0x75,
			0x75, 0x76, 0x76, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x7c, 0x7d, 0x7f,
			0x82, 0x84, 0x86, 0x89, 0x8b, 0x8c, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d,
			0x8b, 0x8a, 0x88, 0x86, 0x83, 0x81, 0x7f, 0x7e, 0x7c, 0x7b, 0x7a,
			0x79, 0x78, 0x78, 0x77, 0x77, 0x77, 0x76, 0x76, 0x77, 0x77, 0x78,
			0x79, 0x7a, 0x7b, 0x7d, 0x7e, 0x80, 0x81, 0x83, 0x85, 0x87, 0x89,
			0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x89, 0x88, 0x86, 0x84, 0x82, 0x81,
			0x7f, 0x7e, 0x7c, 0x7b, 0x7a, 0x7a, 0x79, 0x79, 0x79, 0x79, 0x79,
			0x79, 0x79, 0x79, 0x7a, 0x7a, 0x7b, 0x7b, 0x7c, 0x7d, 0x7e, 0x80,
			0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x87, 0x87, 0x87, 0x87,
			0x86, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x82,
			0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f,
		},
		{ // 1
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7b, 0x7d,
			0x7b, 0x7e, 0x7c, 0x7e, 0x7f, 0x7e, 0x82, 0x82, 0x83, 0x85, 0x86,
			0x87, 0x89, 0x88, 0x8a, 0x89, 0x89, 0x87, 0x88, 0x84, 0x84, 0x7f,
			0x7e, 0x7a, 0x77, 0x74, 0x71, 0x6e, 0x6c, 0x6a, 0x6a, 0x6b, 0x6b,
			0x71, 0x70, 0x78, 0x79, 0x80, 0x84, 0x8a, 0x8e, 0x94, 0x97, 0x9c,
			0x9e, 0x9e, 0xa2, 0x9d, 0x9e, 0x9a, 0x95, 0x92, 0x8c, 0x85, 0x80,
			0x77, 0x73, 0x6a, 0x66, 0x60, 0x5c, 0x58, 0x58, 0x55, 0x59, 0x5b,
			0x5d, 0x67, 0x69, 0x72, 0x79, 0x80, 0x88, 0x91, 0x95, 0x9d, 0xa1,
			0xa5, 0xa8, 0xa9, 0xa8, 0xa9, 0xa3, 0xa2, 0x9b, 0x96, 0x90, 0x89,
			0x82, 0x7a, 0x72, 0x6a, 0x65, 0x5d, 0x5a, 0x53, 0x55, 0x4f, 0x56,
			0x55, 0x5c, 0x62, 0x67, 0x6f, 0x77, 0x7f, 0x88, 0x90, 0x96, 0xa0,
			0xa1, 0xaa, 0xa8, 0xad, 0xab, 0xaa, 0xa6, 0xa2, 0x9c, 0x97, 0x8e,
			0x89, 0x80, 0x78, 0x70, 0x67, 0x61, 0x5a, 0x56, 0x52, 0x52, 0x4f,
			0x55, 0x53, 0x5d, 0x61, 0x68, 0x71, 0x78, 0x80, 0x8b, 0x90, 0x9b,
			0xa0, 0xa5, 0xab, 0xab, 0xae, 0xac, 0xab, 0xa6, 0xa3, 0x9a, 0x97,
			0x8d, 0x87, 0x7d, 0x76, 0x6c, 0x65, 0x5d, 0x58, 0x53, 0x50, 0x50,
			0x4e, 0x56, 0x53, 0x5f, 0x61, 0x6a, 0x73, 0x7a, 0x83, 0x8d, 0x93,
			0x9e, 0xa2, 0xa8, 0xad, 0xae, 0xb0, 0xae, 0xad, 0xa7, 0xa4, 0x9b,
			0x96, 0x8d, 0x86, 0x7b, 0x74, 0x68, 0x63, 0x5a, 0x56, 0x4f, 0x50,
			0x4b, 0x4e, 0x53, 0x52, 0x5f, 0x60, 0x6b, 0x74, 0x7c, 0x86, 0x91,
			0x96, 0xa2, 0xa5, 0xae, 0xaf, 0xb3, 0xb2, 0xb3, 0xad, 0xaa, 0xa2,
			0x9d, 0x94, 0x8c, 0x82, 0x79, 0x70, 0x64, 0x5f, 0x55, 0x53, 0x4c,
			0x4e, 0x49, 0x52, 0x4d, 0x5d, 0x59, 0x6a, 0x6d, 0x75, 0x85, 0x85,
			0x95, 0x9b, 0x9f, 0xaa, 0xab, 0xac, 0xb5, 0xa8, 0xb3, 0xa4, 0xa6,
			0x9e, 0x96, 0x92, 0x88, 0x7f, 0x7b, 0x6c, 0x68, 0x61, 0x57, 0x59,
			0x4f, 0x53, 0x50, 0x52, 0x55, 0x5a, 0x60, 0x66, 0x6f, 0x76, 0x80,
			0x88, 0x92, 0x99, 0xa2, 0xa6, 0xac, 0xb0, 0xaf, 0xb3, 0xad, 0xaa,
			0xa6, 0x9d, 0x98, 0x8f, 0x86, 0x7e, 0x74, 0x6b, 0x62, 0x5c, 0x56,
			0x50, 0x50, 0x4d, 0x4d, 0x54, 0x52, 0x5e, 0x61, 0x68, 0x75, 0x79,
			0x84, 0x8f, 0x94, 0x9e, 0xa4, 0xa8, 0xaf, 0xb0, 0xb1, 0xb2, 0xad,
			0xaa, 0xa4, 0x9b, 0x98, 0x8b, 0x86, 0x7a, 0x72, 0x68, 0x61, 0x58,
			0x55, 0x4d, 0x4f, 0x4a, 0x4e, 0x52, 0x53, 0x5e, 0x61, 0x6c, 0x74,
			0x7e, 0x86, 0x93, 0x96, 0xa4, 0xa4, 0xae, 0xaf, 0xb1, 0xb5, 0xae,
			0xb1, 0xa7, 0xa2, 0x9d, 0x91, 0x8c, 0x81, 0x76, 0x71, 0x61, 0x5f,
			0x55, 0x51, 0x4e, 0x4c, 0x49, 0x51, 0x4e, 0x59, 0x5f, 0x63, 0x70,
			0x76, 0x81, 0x8b, 0x93, 0x9b, 0xa4, 0xa7, 0xaf, 0xaf, 0xb4, 0xb0,
			0xb2, 0xab, 0xa8, 0xa0, 0x9a, 0x90, 0x88, 0x7e, 0x75, 0x6b, 0x62,
			0x5b, 0x54, 0x4f, 0x4d, 0x4c, 0x49, 0x52, 0x4e, 0x5c, 0x5e, 0x68,
			0x71, 0x7a, 0x83, 0x8f, 0x96, 0x9f, 0xa7, 0xa9, 0xb3, 0xaf, 0xb7,
			0xb2, 0xb0, 0xae, 0xa4, 0xa0, 0x97, 0x8d, 0x87, 0x79, 0x74, 0x67,
			0x60, 0x58, 0x51, 0x4d, 0x4c, 0x49, 0x4e, 0x4e, 0x53, 0x5d, 0x5e,
			0x6d, 0x71, 0x7d, 0x86, 0x90, 0x98, 0xa2, 0xa6, 0xae, 0xb0, 0xb2,
			0xb5, 0xb1, 0xb0, 0xab, 0xa4, 0x9f, 0x95, 0x8d, 0x85, 0x78, 0x73,
			0x64, 0x5f, 0x55, 0x50, 0x4b, 0x4a, 0x47, 0x4d, 0x4e, 0x52, 0x5e,
			0x5f, 0x6e, 0x74, 0x7f, 0x8a, 0x93, 0x9b, 0xa6, 0xa8, 0xb1, 0xb2,
			0xb4, 0xb7, 0xb1, 0xb2, 0xa8, 0xa3, 0x9c, 0x92, 0x8b, 0x81, 0x77,
			0x6f, 0x62, 0x5d, 0x53, 0x4e, 0x4a, 0x49, 0x48, 0x4d, 0x4c, 0x57,
			0x5b, 0x63, 0x70, 0x75, 0x84, 0x8b, 0x96, 0xa0, 0xa8, 0xac, 0xb5,
			0xb3, 0xb9, 0xb6, 0xb3, 0xb1, 0xa8, 0xa2, 0x9a, 0x8f, 0x8a, 0x7d,
			0x75, 0x6b, 0x60, 0x5a, 0x51, 0x4d, 0x48, 0x49, 0x46, 0x4e, 0x4b,
			0x59, 0x5a, 0x66, 0x6f, 0x77, 0x84, 0x8c, 0x97, 0xa1, 0xa8, 0xad,
			0xb6, 0xb4, 0xbb, 0xb5, 0xb5, 0xaf, 0xa7, 0xa2, 0x99, 0x90, 0x89,
			0x7b, 0x75, 0x68, 0x60, 0x57, 0x50, 0x4b, 0x49, 0x47, 0x48, 0x4c,
			0x4e, 0x59, 0x5b, 0x68, 0x6e, 0x7a, 0x84, 0x8f, 0x98, 0xa3, 0xa9,
			0xb0, 0xb4, 0xb7, 0xb8, 0xb6, 0xb3, 0xae, 0xa7, 0xa0, 0x97, 0x8e,
			0x86, 0x7a, 0x72, 0x65, 0x5f, 0x54, 0x50, 0x48, 0x4a, 0x44, 0x4b,
			0x4a, 0x51, 0x5a, 0x5d, 0x6c, 0x70, 0x7f, 0x88, 0x93, 0x9c, 0xa7,
			0xab, 0xb3, 0xb6, 0xb7, 0xb8, 0xb5, 0xb1, 0xac, 0xa3, 0x9e, 0x92,
			0x8c, 0x81, 0x78, 0x6e, 0x63, 0x5b, 0x53, 0x4d, 0x49, 0x48, 0x45,
			0x4c, 0x4a, 0x56, 0x58, 0x63, 0x6c, 0x75, 0x82, 0x8c, 0x96, 0xa1,
			0xa8, 0xaf, 0xb5, 0xb6, 0xba, 0xb7, 0xb5, 0xb0, 0xaa, 0xa2, 0x9b,
			0x91, 0x8a, 0x7d, 0x77, 0x69, 0x62, 0x57, 0x52, 0x4b, 0x49, 0x46,
			0x48, 0x4b, 0x4c, 0x59, 0x59, 0x69, 0x6e, 0x7a, 0x85, 0x8f, 0x99,
			0xa4, 0xaa, 0xb2, 0xb6, 0xb7, 0xba, 0xb5, 0xb4, 0xae, 0xa7, 0xa0,
			0x97, 0x8f, 0x85, 0x7b, 0x73, 0x66, 0x60, 0x55, 0x50, 0x4a, 0x48,
			0x46, 0x49, 0x4a, 0x50, 0x58, 0x5d, 0x6a, 0x71, 0x7d, 0x88, 0x92,
			0x9c, 0xa6, 0xac, 0xb3, 0xb6, 0xb8, 0xb9, 0xb5, 0xb2, 0xac, 0xa5,
			0x9e, 0x93, 0x8d, 0x81, 0x79, 0x6e, 0x63, 0x5d, 0x52, 0x4f, 0x48,
			0x48, 0x45, 0x4b, 0x4a, 0x53, 0x59, 0x60, 0x6d, 0x73, 0x80, 0x8a,
			0x94, 0x9e, 0xa8, 0xac, 0xb5, 0xb5, 0xb9, 0xb8, 0xb5, 0xb1, 0xab,
			0xa3, 0x9d, 0x92, 0x8b, 0x7f, 0x76, 0x6c, 0x62, 0x5a, 0x52, 0x4d,
			0x48, 0x48, 0x45, 0x4d, 0x49, 0x58, 0x58, 0x65, 0x6d, 0x76, 0x83,
			0x8b, 0x97, 0xa0, 0xa9, 0xae, 0xb6, 0xb5, 0xb9, 0xb6, 0xb4, 0xae,
			0xa8, 0xa1, 0x99, 0x8f, 0x88, 0x7c, 0x76, 0x68, 0x62, 0x58, 0x52,
			0x4d, 0x49, 0x47, 0x47, 0x4c, 0x4d, 0x59, 0x5a, 0x69, 0x6d, 0x7a,
			0x84, 0x8e, 0x99, 0xa2, 0xa9, 0xb1, 0xb4, 0xb7, 0xb7, 0xb5, 0xb3,
			0xac, 0xa7, 0x9f, 0x97, 0x8e, 0x85, 0x7b, 0x73, 0x68, 0x61, 0x57,
			0x54, 0x4b, 0x4c, 0x46, 0x4b, 0x4c, 0x50, 0x59, 0x5e, 0x68, 0x71,
			0x7a, 0x86, 0x90, 0x99, 0xa5, 0xa9, 0xb2, 0xb4, 0xb8, 0xb7, 0xb6,
			0xb1, 0xad, 0xa5, 0x9e, 0x96, 0x8d, 0x84, 0x7b, 0x71, 0x67, 0x5f,
			0x55, 0x52, 0x4a, 0x4b, 0x45, 0x4c, 0x4a, 0x53, 0x58, 0x5f, 0x69,
			0x72, 0x7c, 0x87, 0x92, 0x9b, 0xa6, 0xab, 0xb4, 0xb4, 0xb8, 0xb6,
			0xb5, 0xaf, 0xab, 0xa2, 0x9c, 0x92, 0x8b, 0x80, 0x78, 0x6c, 0x64,
			0x5b, 0x55, 0x4e, 0x4c, 0x49, 0x4a, 0x4d, 0x4e, 0x59, 0x5b, 0x68,
			0x6f, 0x79, 0x84, 0x8f, 0x97, 0xa4, 0xa8, 0xb1, 0xb3, 0xb7, 0xb6,
			0xb5, 0xb0, 0xab, 0xa4, 0x9d, 0x95, 0x8c, 0x84, 0x7a, 0x71, 0x67,
			0x5f, 0x56, 0x52, 0x4b, 0x4d, 0x47, 0x50, 0x4c, 0x57, 0x5a, 0x63,
			0x6d, 0x75, 0x81, 0x8b, 0x94, 0x9e, 0xa6, 0xab, 0xb2, 0xb3, 0xb6,
			0xb3, 0xb2, 0xab, 0xa7, 0x9f, 0x98, 0x90, 0x89, 0x7e, 0x78, 0x6b,
			0x65, 0x59, 0x55, 0x4d, 0x4e, 0x48, 0x4d, 0x4d, 0x52, 0x5a, 0x5e,
			0x6b, 0x70, 0x7e, 0x85, 0x92, 0x98, 0xa4, 0xa7, 0xb1, 0xb0, 0xb6,
			0xb2, 0xb3, 0xad, 0xa8, 0xa1, 0x9a, 0x93, 0x8b, 0x82, 0x79, 0x70,
			0x67, 0x5e, 0x57, 0x51, 0x4d, 0x4c, 0x4a, 0x50, 0x4f, 0x59, 0x5b,
			0x67, 0x6e, 0x79, 0x82, 0x8e, 0x94, 0xa0, 0xa4, 0xac, 0xaf, 0xb2,
			0xb3, 0xb2, 0xaf, 0xaa, 0xa3, 0x9d, 0x95, 0x8d, 0x86, 0x7b, 0x75,
			0x69, 0x63, 0x5a, 0x55, 0x4f, 0x50, 0x49, 0x51, 0x4d, 0x57, 0x5b,
			0x62, 0x6d, 0x73, 0x80, 0x88, 0x92, 0x9b, 0xa3, 0xa8, 0xaf, 0xb0,
			0xb5, 0xb0, 0xb2, 0xa9, 0xa7, 0x9e, 0x98, 0x90, 0x89, 0x7f, 0x78,
			0x6d, 0x67, 0x5d, 0x58, 0x52, 0x4e, 0x4e, 0x4a, 0x51, 0x4e, 0x5a,
			0x5b, 0x67, 0x6d, 0x78, 0x81, 0x8c, 0x93, 0x9e, 0xa3, 0xaa, 0xaf,
			0xb1, 0xb4, 0xb1, 0xb0, 0xaa, 0xa6, 0x9d, 0x98, 0x8f, 0x89, 0x7e,
			0x77, 0x6c, 0x66, 0x5c, 0x58, 0x50, 0x4f, 0x4c, 0x4d, 0x50, 0x52,
			0x5b, 0x5e, 0x6a, 0x6f, 0x7a, 0x84, 0x8d, 0x95, 0x9e, 0xa3, 0xab,
			0xac, 0xb1, 0xb0, 0xb0, 0xac, 0xa8, 0xa2, 0x9c, 0x95, 0x8e, 0x86,
			0x7d, 0x76, 0x6c, 0x65, 0x5b, 0x59, 0x50, 0x51, 0x4b, 0x50, 0x4f,
			0x55, 0x5b, 0x60, 0x6b, 0x71, 0x7c, 0x85, 0x8f, 0x96, 0xa0, 0xa4,
			0xac, 0xac, 0xb1, 0xaf, 0xb0, 0xaa, 0xa7, 0xa1, 0x99, 0x94, 0x8b,
			0x85, 0x7c, 0x74, 0x6c, 0x64, 0x5d, 0x59, 0x51, 0x53, 0x4b, 0x53,
			0x50, 0x57, 0x5e, 0x61, 0x6d, 0x71, 0x7e, 0x85, 0x8f, 0x97, 0xa0,
			0xa4, 0xac, 0xab, 0xb0, 0xae, 0xae, 0xab, 0xa5, 0xa1, 0x98, 0x93,
			0x8b, 0x84, 0x7c, 0x73, 0x6c, 0x64, 0x5c, 0x59, 0x51, 0x53, 0x4d,
			0x53, 0x52, 0x57, 0x5f, 0x62, 0x6e, 0x73, 0x7d, 0x86, 0x8f, 0x97,
			0x9f, 0xa3, 0xaa, 0xaa, 0xaf, 0xab, 0xad, 0xa7, 0xa3, 0x9e, 0x96,
			0x92, 0x89, 0x83, 0x7c, 0x73, 0x6c, 0x64, 0x5e, 0x59, 0x53, 0x55,
			0x4e, 0x56, 0x53, 0x5b, 0x60, 0x64, 0x6f, 0x75, 0x7e, 0x88, 0x8f,
			0x98, 0xa0, 0xa3, 0xab, 0xa9, 0xae, 0xaa, 0xab, 0xa5, 0xa3, 0x9b,
			0x96, 0x8f, 0x88, 0x82, 0x7a, 0x72, 0x6c, 0x64, 0x5e, 0x59, 0x54,
			0x55, 0x4f, 0x57, 0x53, 0x5d, 0x60, 0x67, 0x70, 0x76, 0x80, 0x89,
			0x90, 0x9a, 0x9f, 0xa4, 0xaa, 0xa9, 0xae, 0xa8, 0xaa, 0xa4, 0xa2,
			0x9b, 0x95, 0x90, 0x88, 0x83, 0x7b, 0x74, 0x6d, 0x66, 0x5f, 0x5c,
			0x54, 0x57, 0x50, 0x56, 0x56, 0x5a, 0x62, 0x64, 0x70, 0x74, 0x7e,
			0x87, 0x8e, 0x96, 0x9e, 0xa1, 0xa8, 0xa8, 0xab, 0xaa, 0xa8, 0xa4,
			0xa1, 0x9b, 0x95, 0x90, 0x88, 0x83, 0x7b, 0x75, 0x6e, 0x69, 0x60,
			0x5f, 0x57, 0x58, 0x54, 0x56, 0x59, 0x5a, 0x62, 0x64, 0x6e, 0x73,
			0x7c, 0x84, 0x8c, 0x93, 0x9b, 0x9e, 0xa5, 0xa6, 0xa7, 0xa9, 0xa5,
			0xa5, 0x9e, 0x9b, 0x95, 0x8f, 0x89, 0x83, 0x7b, 0x77, 0x6e, 0x6a,
			0x63, 0x5f, 0x5c, 0x59, 0x59, 0x58, 0x5c, 0x5c, 0x65, 0x64, 0x71,
			0x73, 0x7c, 0x84, 0x8a, 0x91, 0x99, 0x9c, 0xa3, 0xa4, 0xa5, 0xa9,
			0xa2, 0xa5, 0x9d, 0x9b, 0x94, 0x90, 0x88, 0x84, 0x7a, 0x78, 0x6e,
			0x6b, 0x63, 0x61, 0x5c, 0x5b, 0x5a, 0x59, 0x5e, 0x5d, 0x66, 0x67,
			0x71, 0x74, 0x7e, 0x83, 0x8c, 0x90, 0x9a, 0x9b, 0xa3, 0xa3, 0xa5,
			0xa6, 0xa1, 0xa2, 0x9b, 0x99, 0x92, 0x8d, 0x87, 0x81, 0x7a, 0x75,
			0x6c, 0x6b, 0x62, 0x62, 0x5d, 0x5d, 0x5c, 0x5c, 0x61, 0x60, 0x6a,
			0x69, 0x75, 0x77, 0x80, 0x86, 0x8d, 0x93, 0x9a, 0x9d, 0xa1, 0xa3,
			0xa2, 0xa4, 0xa0, 0x9f, 0x9a, 0x95, 0x90, 0x8a, 0x83, 0x7f, 0x76,
			0x74, 0x6a, 0x69, 0x62, 0x61, 0x5e, 0x5e, 0x5c, 0x60, 0x62, 0x66,
			0x6c, 0x6f, 0x78, 0x7b, 0x84, 0x89, 0x90, 0x95, 0x9c, 0x9c, 0xa3,
			0x9f, 0xa4, 0xa0, 0x9e, 0x9b, 0x95, 0x91, 0x8b, 0x85, 0x80, 0x79,
			0x73, 0x6e, 0x68, 0x65, 0x61, 0x61, 0x5d, 0x60, 0x5f, 0x64, 0x65,
			0x6c, 0x6f, 0x76, 0x7c, 0x82, 0x89, 0x8e, 0x94, 0x99, 0x9c, 0xa0,
			0xa0, 0xa0, 0xa2, 0x9c, 0x9d, 0x95, 0x93, 0x8d, 0x86, 0x82, 0x7b,
			0x75, 0x71, 0x6a, 0x68, 0x63, 0x61, 0x5f, 0x5f, 0x60, 0x62, 0x65,
			0x69, 0x6e, 0x73, 0x7a, 0x7e, 0x85, 0x8a, 0x90, 0x95, 0x99, 0x9c,
			0x9f, 0x9f, 0xa2, 0x9d, 0x9e, 0x99, 0x95, 0x90, 0x8a, 0x85, 0x7f,
			0x79, 0x75, 0x6d, 0x6b, 0x65, 0x63, 0x62, 0x5f, 0x61, 0x60, 0x65,
			0x66, 0x6d, 0x6f, 0x77, 0x7a, 0x81, 0x86, 0x8c, 0x91, 0x96, 0x99,
			0x9c, 0x9d, 0x9f, 0x9e, 0x9d, 0x9b, 0x95, 0x94, 0x8c, 0x89, 0x81,
			0x7d, 0x77, 0x73, 0x6d, 0x6b, 0x65, 0x65, 0x61, 0x63, 0x61, 0x64,
			0x66, 0x69, 0x6f, 0x71, 0x79, 0x7b, 0x84, 0x86, 0x8e, 0x91, 0x95,
			0x99, 0x9b, 0x9d, 0x9e, 0x9c, 0x9c, 0x97, 0x95, 0x8f, 0x8b, 0x86,
			0x80, 0x7c, 0x76, 0x71, 0x6d, 0x69, 0x66, 0x65, 0x62, 0x64, 0x63,
			0x67, 0x68, 0x6d, 0x70, 0x76, 0x7b, 0x7f, 0x85, 0x88, 0x8e, 0x91,
			0x95, 0x97, 0x99, 0x9a, 0x9a, 0x9a, 0x97, 0x95, 0x91, 0x8d, 0x89,
			0x84, 0x80, 0x7a, 0x76, 0x70, 0x6d, 0x6a, 0x67, 0x66, 0x65, 0x65,
			0x67, 0x69, 0x6b, 0x71, 0x74, 0x79, 0x7d, 0x82, 0x86, 0x8b, 0x8f,
			0x92, 0x95, 0x98, 0x99, 0x99, 0x9a, 0x97, 0x96, 0x92, 0x8f, 0x8a,
			0x86, 0x81, 0x7c, 0x77, 0x73, 0x6e, 0x6b, 0x69, 0x67, 0x66, 0x66,
			0x67, 0x69, 0x6c, 0x70, 0x73, 0x78, 0x7c, 0x81, 0x84, 0x8a, 0x8e,
			0x91, 0x95, 0x96, 0x98, 0x98, 0x99, 0x95, 0x95, 0x90, 0x8e, 0x87,
			0x84, 0x7e, 0x79, 0x74, 0x70, 0x6d, 0x69, 0x69, 0x67, 0x68, 0x68,
			0x6b, 0x6c, 0x71, 0x73, 0x79, 0x7b, 0x81, 0x83, 0x89, 0x8b, 0x8f,
			0x92, 0x94, 0x96, 0x96, 0x97, 0x95, 0x95, 0x91, 0x8f, 0x8a, 0x86,
			0x82, 0x7d, 0x77, 0x75, 0x70, 0x6d, 0x6b, 0x69, 0x69, 0x69, 0x6a,
			0x6c, 0x6e, 0x70, 0x73, 0x77, 0x7a, 0x7f, 0x82, 0x86, 0x8a, 0x8b,
			0x8f, 0x90, 0x93, 0x93, 0x94, 0x93, 0x93, 0x91, 0x8e, 0x8c, 0x87,
			0x84, 0x80, 0x7c, 0x79, 0x75, 0x72, 0x71, 0x6e, 0x6d, 0x6d, 0x6d,
			0x6e, 0x70, 0x72, 0x74, 0x77, 0x7a, 0x7d, 0x81, 0x83, 0x87, 0x89,
			0x8b, 0x8d, 0x8f, 0x90, 0x8f, 0x90, 0x8f, 0x8e, 0x8c, 0x8a, 0x87,
			0x85, 0x81, 0x7e, 0x7c, 0x78, 0x77, 0x74, 0x73, 0x71, 0x71, 0x70,
			0x71, 0x72, 0x74, 0x75, 0x78, 0x79, 0x7d, 0x7e, 0x81, 0x84, 0x85,
			0x88, 0x88, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x88, 0x86,
			0x85, 0x82, 0x80, 0x7e, 0x7c, 0x7a, 0x79, 0x76, 0x77, 0x75, 0x75,
			0x75, 0x76, 0x76, 0x78, 0x79, 0x7b, 0x7c, 0x7e, 0x80, 0x81, 0x83,
			0x84, 0x86, 0x86, 0x87, 0x87, 0x88, 0x87, 0x87, 0x86, 0x86, 0x84,
			0x84, 0x82, 0x81, 0x7f, 0x7e, 0x7d, 0x7b, 0x7b, 0x79, 0x79, 0x78,
			0x78, 0x78, 0x7a, 0x79, 0x7c, 0x7b, 0x7e, 0x7e, 0x7f, 0x81, 0x82,
			0x83, 0x83, 0x84, 0x83, 0x85, 0x84, 0x85, 0x84, 0x84, 0x83, 0x83,
			0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7d, 0x7d, 0x7c, 0x7c, 0x7b, 0x7c,
			0x7b, 0x7c, 0x7c, 0x7d, 0x7d, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81,
			0x82, 0x82, 0x81, 0x82, 0x81, 0x82, 0x81, 0x81, 0x81, 0x81, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
		},
		{ // 2
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x7e, 0x80, 0x7e, 0x81, 0x7f, 0x89, 0x87,
			0x7d, 0x78, 0x76, 0x7c, 0x87, 0x88, 0x82, 0x7a, 0x72, 0x73, 0x79,
			0x80, 0x81, 0x7d, 0x74, 0x73, 0x77, 0x81, 0x7c, 0x7f, 0x75, 0x90,
			0x9f, 0x92, 0x81, 0x6b, 0x6a, 0x83, 0x97, 0x94, 0x8c, 0x7c, 0x78,
			0x80, 0x88, 0x81, 0x82, 0x7c, 0x81, 0x84, 0x7e, 0x77, 0x76, 0x7b,
			0x81, 0x81, 0x73, 0x6b, 0x65, 0x6b, 0x70, 0x7d, 0x84, 0x8f, 0xa8,
			0x91, 0x73, 0x65, 0x66, 0x7f, 0x95, 0x97, 0x93, 0x89, 0x7d, 0x7a,
			0x79, 0x7e, 0x83, 0x84, 0x85, 0x84, 0x7d, 0x7a, 0x73, 0x77, 0x7e,
			0x83, 0x82, 0x80, 0x73, 0x6b, 0x69, 0x69, 0x6e, 0x7b, 0x82, 0x88,
			0xa4, 0x9b, 0x83, 0x70, 0x66, 0x76, 0x8f, 0x9b, 0x9f, 0x94, 0x83,
			0x7a, 0x76, 0x7d, 0x83, 0x85, 0x87, 0x80, 0x79, 0x73, 0x6f, 0x74,
			0x7c, 0x7d, 0x75, 0x68, 0x62, 0x60, 0x77, 0x86, 0x90, 0xad, 0x99,
			0x80, 0x6b, 0x63, 0x7e, 0x9a, 0xa0, 0xa3, 0x92, 0x83, 0x7c, 0x77,
			0x7f, 0x83, 0x89, 0x86, 0x7b, 0x71, 0x6f, 0x6d, 0x76, 0x7a, 0x76,
			0x6d, 0x64, 0x55, 0x6c, 0x82, 0x93, 0xba, 0xa5, 0x7e, 0x64, 0x5d,
			0x78, 0x9e, 0xa8, 0xa4, 0x93, 0x83, 0x79, 0x75, 0x7c, 0x84, 0x89,
			0x89, 0x7b, 0x6e, 0x64, 0x6e, 0x79, 0x75, 0x6f, 0x68, 0x56, 0x5e,
			0x7a, 0x7f, 0xb2, 0xb8, 0x8e, 0x6c, 0x57, 0x6a, 0x95, 0xae, 0xaa,
			0xa0, 0x8a, 0x7c, 0x77, 0x7c, 0x83, 0x89, 0x8d, 0x81, 0x6f, 0x63,
			0x63, 0x6e, 0x71, 0x6f, 0x6a, 0x56, 0x60, 0x7d, 0x77, 0xa3, 0xb3,
			0x92, 0x7a, 0x5e, 0x66, 0x8c, 0xab, 0xaa, 0x9f, 0x8a, 0x7d, 0x77,
			0x7c, 0x7f, 0x87, 0x8b, 0x7d, 0x6c, 0x60, 0x65, 0x6d, 0x73, 0x6d,
			0x5e, 0x56, 0x78, 0x76, 0x8f, 0xb8, 0x9c, 0x88, 0x6a, 0x61, 0x81,
			0xa4, 0xa9, 0x9f, 0x94, 0x85, 0x7f, 0x7e, 0x7c, 0x81, 0x8b, 0x86,
			0x72, 0x64, 0x65, 0x6d, 0x6d, 0x68, 0x61, 0x5a, 0x77, 0x7f, 0x77,
			0xac, 0xaa, 0x89, 0x74, 0x59, 0x77, 0xa2, 0xac, 0xa0, 0x97, 0x87,
			0x85, 0x7c, 0x74, 0x83, 0x90, 0x87, 0x73, 0x60, 0x62, 0x6a, 0x64,
			0x69, 0x65, 0x5f, 0x7d, 0x74, 0x75, 0xb1, 0xa4, 0x8b, 0x75, 0x64,
			0x7a, 0xa3, 0xa7, 0x9c, 0x99, 0x87, 0x85, 0x7c, 0x79, 0x84, 0x8f,
			0x81, 0x71, 0x63, 0x65, 0x6d, 0x62, 0x64, 0x60, 0x6b, 0x81, 0x6b,
			0x7b, 0xb3, 0xa0, 0x89, 0x72, 0x67, 0x8a, 0xa5, 0x9e, 0x97, 0x98,
			0x8d, 0x87, 0x79, 0x77, 0x84, 0x8e, 0x7d, 0x6a, 0x60, 0x66, 0x6b,
			0x63, 0x64, 0x61, 0x6d, 0x7c, 0x6b, 0x81, 0xaf, 0x9f, 0x86, 0x71,
			0x6f, 0x8b, 0xa6, 0x9b, 0x98, 0x9e, 0x8a, 0x81, 0x76, 0x7c, 0x90,
			0x86, 0x73, 0x6c, 0x68, 0x68, 0x5f, 0x63, 0x6a, 0x6b, 0x77, 0x6a,
			0x66, 0x99, 0xab, 0x9c, 0x7c, 0x67, 0x7e, 0x9d, 0xa1, 0x97, 0x9b,
			0x94, 0x88, 0x7e, 0x73, 0x88, 0x90, 0x7e, 0x71, 0x68, 0x6b, 0x63,
			0x5d, 0x61, 0x6a, 0x76, 0x79, 0x59, 0x72, 0xad, 0xa5, 0x87, 0x6d,
			0x71, 0x95, 0xa9, 0x94, 0x97, 0x9e, 0x8d, 0x86, 0x75, 0x80, 0x99,
			0x89, 0x71, 0x67, 0x6e, 0x70, 0x62, 0x61, 0x66, 0x67, 0x78, 0x6d,
			0x5a, 0x8f, 0xa8, 0x8f, 0x80, 0x72, 0x7f, 0x98, 0x9a, 0x94, 0xa2,
			0x99, 0x84, 0x81, 0x78, 0x8d, 0x8f, 0x82, 0x73, 0x6c, 0x6b, 0x67,
			0x60, 0x6b, 0x6d, 0x68, 0x73, 0x5f, 0x6d, 0x9a, 0xa4, 0x82, 0x7b,
			0x77, 0x87, 0x98, 0x92, 0x98, 0xa5, 0x96, 0x7c, 0x80, 0x79, 0x91,
			0x8b, 0x7b, 0x75, 0x73, 0x6c, 0x65, 0x67, 0x69, 0x6b, 0x64, 0x7b,
			0x6b, 0x60, 0x96, 0xa5, 0x86, 0x7d, 0x76, 0x85, 0x9a, 0x94, 0x93,
			0xa4, 0x96, 0x7c, 0x81, 0x81, 0x8c, 0x88, 0x7a, 0x74, 0x74, 0x6b,
			0x67, 0x6d, 0x69, 0x61, 0x6b, 0x7a, 0x64, 0x67, 0x98, 0xa1, 0x85,
			0x7d, 0x7a, 0x8d, 0x9e, 0x91, 0x90, 0xa3, 0x96, 0x7e, 0x80, 0x81,
			0x8d, 0x89, 0x77, 0x76, 0x77, 0x6a, 0x61, 0x63, 0x6f, 0x74, 0x61,
			0x6e, 0x6e, 0x61, 0x84, 0x9d, 0x9a, 0x87, 0x77, 0x80, 0x8a, 0x92,
			0x9c, 0xa3, 0x9b, 0x82, 0x7a, 0x81, 0x8b, 0x8b, 0x82, 0x77, 0x76,
			0x6e, 0x62, 0x69, 0x72, 0x69, 0x62, 0x6c, 0x71, 0x69, 0x7d, 0x92,
			0x8e, 0x8f, 0x7d, 0x7e, 0x90, 0x93, 0x95, 0x97, 0x9b, 0x90, 0x7f,
			0x7f, 0x84, 0x89, 0x88, 0x7c, 0x78, 0x74, 0x6c, 0x67, 0x67, 0x6c,
			0x63, 0x65, 0x76, 0x6b, 0x60, 0x8b, 0x9e, 0x88, 0x86, 0x84, 0x88,
			0x89, 0x93, 0x98, 0x98, 0x98, 0x8e, 0x87, 0x85, 0x81, 0x82, 0x86,
			0x82, 0x7b, 0x71, 0x69, 0x69, 0x67, 0x67, 0x66, 0x6e, 0x7c, 0x63,
			0x56, 0x8e, 0x9f, 0x8a, 0x85, 0x7c, 0x88, 0x91, 0x8e, 0x8b, 0x9c,
			0x9e, 0x8d, 0x83, 0x82, 0x83, 0x84, 0x7f, 0x81, 0x7e, 0x73, 0x6c,
			0x68, 0x6d, 0x6c, 0x65, 0x62, 0x6f, 0x77, 0x64, 0x72, 0x9b, 0x8d,
			0x82, 0x8c, 0x87, 0x83, 0x90, 0x95, 0x92, 0x97, 0x95, 0x8d, 0x84,
			0x82, 0x87, 0x82, 0x7f, 0x7e, 0x77, 0x75, 0x70, 0x69, 0x67, 0x6d,
			0x65, 0x5e, 0x74, 0x78, 0x6a, 0x85, 0x95, 0x84, 0x82, 0x85, 0x86,
			0x92, 0x97, 0x90, 0x92, 0x95, 0x91, 0x8a, 0x87, 0x86, 0x82, 0x7f,
			0x80, 0x83, 0x7a, 0x73, 0x6d, 0x68, 0x6a, 0x68, 0x64, 0x63, 0x6f,
			0x76, 0x67, 0x7a, 0x97, 0x85, 0x7c, 0x8b, 0x8f, 0x89, 0x8f, 0x95,
			0x93, 0x95, 0x91, 0x8c, 0x8c, 0x8a, 0x83, 0x7f, 0x80, 0x80, 0x7b,
			0x7b, 0x7a, 0x6b, 0x63, 0x6a, 0x68, 0x5f, 0x62, 0x75, 0x78, 0x6b,
			0x7b, 0x91, 0x89, 0x84, 0x8b, 0x89, 0x8b, 0x95, 0x97, 0x90, 0x93,
			0x91, 0x8f, 0x8c, 0x89, 0x85, 0x80, 0x7d, 0x7b, 0x7d, 0x7d, 0x7a,
			0x6d, 0x60, 0x63, 0x69, 0x66, 0x63, 0x6b, 0x79, 0x74, 0x6d, 0x85,
			0x93, 0x89, 0x8a, 0x8c, 0x8b, 0x8c, 0x95, 0x93, 0x8f, 0x94, 0x91,
			0x8e, 0x89, 0x88, 0x84, 0x7d, 0x7d, 0x7c, 0x7e, 0x79, 0x75, 0x72,
			0x69, 0x64, 0x65, 0x69, 0x69, 0x6a, 0x70, 0x76, 0x74, 0x84, 0x95,
			0x84, 0x81, 0x92, 0x91, 0x86, 0x8c, 0x99, 0x95, 0x91, 0x91, 0x8b,
			0x89, 0x8b, 0x8a, 0x83, 0x7c, 0x7a, 0x79, 0x7a, 0x7a, 0x77, 0x71,
			0x6d, 0x69, 0x60, 0x60, 0x6e, 0x73, 0x6c, 0x6d, 0x74, 0x7b, 0x8b,
			0x90, 0x85, 0x88, 0x93, 0x90, 0x88, 0x8e, 0x98, 0x95, 0x92, 0x8f,
			0x89, 0x89, 0x8b, 0x87, 0x7f, 0x7d, 0x7c, 0x7b, 0x78, 0x79, 0x77,
			0x72, 0x70, 0x6d, 0x67, 0x64, 0x6f, 0x70, 0x6b, 0x70, 0x71, 0x79,
			0x78, 0x86, 0x9c, 0x94, 0x89, 0x8a, 0x8f, 0x8b, 0x8d, 0x95, 0x95,
			0x92, 0x8f, 0x89, 0x83, 0x86, 0x86, 0x83, 0x7e, 0x7a, 0x79, 0x78,
			0x78, 0x74, 0x79, 0x7c, 0x70, 0x64, 0x65, 0x6d, 0x6e, 0x6c, 0x75,
			0x7b, 0x6c, 0x6d, 0x7a, 0x8c, 0x9c, 0x8f, 0x8b, 0x92, 0x93, 0x88,
			0x86, 0x96, 0x99, 0x90, 0x8e, 0x8d, 0x88, 0x80, 0x80, 0x82, 0x82,
			0x7d, 0x78, 0x79, 0x7e, 0x78, 0x72, 0x78, 0x79, 0x71, 0x6c, 0x6f,
			0x71, 0x70, 0x6b, 0x6c, 0x75, 0x79, 0x72, 0x6e, 0x78, 0x84, 0x93,
			0x95, 0x89, 0x8e, 0x98, 0x91, 0x86, 0x8f, 0x98, 0x90, 0x8b, 0x8d,
			0x8a, 0x84, 0x83, 0x82, 0x80, 0x80, 0x80, 0x7a, 0x78, 0x7b, 0x79,
			0x72, 0x74, 0x79, 0x75, 0x70, 0x73, 0x74, 0x6f, 0x6f, 0x73, 0x6f,
			0x70, 0x74, 0x79, 0x74, 0x73, 0x80, 0x8a, 0x97, 0x97, 0x8c, 0x8a,
			0x91, 0x91, 0x89, 0x8c, 0x92, 0x92, 0x8e, 0x8a, 0x87, 0x81, 0x80,
			0x80, 0x81, 0x7f, 0x7c, 0x80, 0x7c, 0x78, 0x77, 0x7a, 0x76, 0x71,
			0x79, 0x78, 0x74, 0x74, 0x77, 0x75, 0x73, 0x71, 0x71, 0x78, 0x77,
			0x76, 0x7a, 0x7d, 0x73, 0x71, 0x86, 0x9a, 0x94, 0x8e, 0x99, 0x94,
			0x88, 0x85, 0x90, 0x90, 0x88, 0x8f, 0x90, 0x8c, 0x84, 0x83, 0x82,
			0x7f, 0x7f, 0x7b, 0x79, 0x7b, 0x7e, 0x7b, 0x7a, 0x7b, 0x76, 0x74,
			0x75, 0x78, 0x76, 0x75, 0x76, 0x79, 0x7a, 0x75, 0x6e, 0x70, 0x77,
			0x78, 0x72, 0x77, 0x82, 0x7e, 0x76, 0x7a, 0x7c, 0x7b, 0x91, 0x9e,
			0x90, 0x8f, 0x98, 0x8e, 0x7f, 0x89, 0x91, 0x8b, 0x8b, 0x8e, 0x8c,
			0x84, 0x84, 0x85, 0x7f, 0x7c, 0x7e, 0x7e, 0x7c, 0x7c, 0x7c, 0x7a,
			0x77, 0x75, 0x78, 0x7c, 0x77, 0x76, 0x79, 0x78, 0x75, 0x78, 0x7e,
			0x7a, 0x76, 0x76, 0x7a, 0x78, 0x72, 0x75, 0x7e, 0x7e, 0x79, 0x7c,
			0x7e, 0x7b, 0x76, 0x77, 0x80, 0x92, 0x9a, 0x92, 0x92, 0x94, 0x8f,
			0x88, 0x89, 0x8c, 0x8a, 0x8e, 0x8e, 0x89, 0x85, 0x84, 0x81, 0x7d,
			0x7d, 0x7e, 0x7d, 0x7c, 0x7b, 0x7a, 0x79, 0x78, 0x77, 0x78, 0x7a,
			0x7a, 0x7e, 0x79, 0x76, 0x7a, 0x78, 0x72, 0x74, 0x82, 0x7d, 0x72,
			0x76, 0x7d, 0x77, 0x6e, 0x78, 0x7f, 0x7b, 0x78, 0x7d, 0x7f, 0x79,
			0x77, 0x7a, 0x80, 0x8b, 0x97, 0x98, 0x94, 0x94, 0x91, 0x8b, 0x87,
			0x8a, 0x8c, 0x8a, 0x8c, 0x8c, 0x8a, 0x84, 0x81, 0x81, 0x7f, 0x7c,
			0x7c, 0x7c, 0x7a, 0x7b, 0x7b, 0x7b, 0x7a, 0x76, 0x79, 0x7a, 0x7c,
			0x7a, 0x79, 0x79, 0x77, 0x76, 0x76, 0x78, 0x7a, 0x7a, 0x77, 0x76,
			0x76, 0x73, 0x75, 0x7a, 0x79, 0x75, 0x7c, 0x7e, 0x78, 0x76, 0x79,
			0x7b, 0x81, 0x8e, 0x96, 0x99, 0x96, 0x93, 0x90, 0x8b, 0x87, 0x88,
			0x8f, 0x8e, 0x8c, 0x8a, 0x89, 0x86, 0x80, 0x7f, 0x80, 0x7e, 0x7c,
			0x7a, 0x7b, 0x79, 0x79, 0x79, 0x76, 0x77, 0x78, 0x78, 0x79, 0x7a,
			0x7b, 0x7a, 0x7c, 0x7d, 0x7e, 0x7f, 0x85, 0x83, 0x7b, 0x7e, 0x80,
			0x7a, 0x76, 0x7e, 0x80, 0x79, 0x78, 0x7b, 0x78, 0x73, 0x75, 0x77,
			0x77, 0x77, 0x78, 0x7a, 0x7b, 0x79, 0x79, 0x82, 0x8e, 0x92, 0x91,
			0x95, 0x98, 0x90, 0x89, 0x8b, 0x8b, 0x87, 0x87, 0x8a, 0x88, 0x85,
			0x83, 0x81, 0x80, 0x7e, 0x7b, 0x7a, 0x7b, 0x79, 0x77, 0x78, 0x77,
			0x78, 0x76, 0x77, 0x77, 0x77, 0x79, 0x79, 0x7a, 0x7b, 0x7d, 0x7d,
			0x7c, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x82, 0x81,
			0x82, 0x81, 0x82, 0x80, 0x84, 0x88, 0x82, 0x82, 0x85, 0x83, 0x7c,
			0x7e, 0x82, 0x7d, 0x7e, 0x7f, 0x80, 0x7c, 0x7c, 0x7e, 0x7c, 0x7c,
			0x7c, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7d, 0x7d, 0x7f, 0x80,
			0x7c, 0x7b, 0x7e, 0x7c, 0x7a, 0x7b, 0x7f, 0x7f, 0x7f, 0x81, 0x80,
			0x83, 0x85, 0x84, 0x83, 0x85, 0x87, 0x83, 0x86, 0x88, 0x85, 0x83,
			0x84, 0x85, 0x80, 0x80, 0x80, 0x80, 0x7c, 0x7c, 0x7f, 0x7c, 0x7a,
			0x7b, 0x7c, 0x7a, 0x78, 0x7a, 0x7a, 0x78, 0x78, 0x7a, 0x7a, 0x78,
			0x7a, 0x7b, 0x7c, 0x7a, 0x7c, 0x7e, 0x7d, 0x7d, 0x7e, 0x80, 0x7f,
			0x7e, 0x81, 0x81, 0x7f, 0x80, 0x83, 0x81, 0x80, 0x82, 0x83, 0x81,
			0x81, 0x83, 0x82, 0x80, 0x82, 0x82, 0x81, 0x81, 0x82, 0x81, 0x80,
			0x81, 0x81, 0x7f, 0x80, 0x81, 0x80, 0x7e, 0x7f, 0x7f, 0x7f, 0x7d,
			0x7e, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7d, 0x7d, 0x7e,
			0x7d, 0x7e, 0x7d, 0x7f, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x81, 0x80, 0x7e, 0x80, 0x81, 0x7e, 0x7e, 0x80, 0x7e, 0x7d, 0x7e,
			0x7f, 0x7e, 0x7d, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d, 0x7c, 0x7d, 0x7e,
			0x7d, 0x7e, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x81, 0x81, 0x80,
			0x81, 0x82, 0x81, 0x80, 0x81, 0x82, 0x81, 0x81, 0x82, 0x81, 0x80,
			0x81, 0x80, 0x80, 0x81, 0x7f, 0x7e, 0x7f, 0x7f, 0x7d, 0x7d, 0x7e,
			0x7d, 0x7c, 0x7d, 0x7e, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7d, 0x7c,
			0x7d, 0x7e, 0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x80, 0x81,
			0x80, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f,
			0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e,
			0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f,
		},
		{ // 3
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x81, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x7f, 0x80, 0x81, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x80, 0x7f, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x80, 0x7e, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x80, 0x7e, 0x7e,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x82, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x81, 0x80, 0x80, 0x7e, 0x7e, 0x80, 0x80, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7d, 0x7d, 0x80, 0x80, 0x7e, 0x7e, 0x80, 0x80, 0x81, 0x80,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x81, 0x80, 0x7f, 0x7f, 0x7e,
			0x80, 0x80, 0x82, 0x81, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x7f, 0x80, 0x7f,
			0x81, 0x80, 0x7e, 0x7d, 0x7f, 0x80, 0x81, 0x82, 0x81, 0x80, 0x80,
			0x82, 0x83, 0x81, 0x80, 0x82, 0x80, 0x81, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x80, 0x7e, 0x7c, 0x7d, 0x7d, 0x7b, 0x7c, 0x7e, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7c, 0x7c, 0x7f, 0x7e, 0x7c, 0x7c, 0x7f, 0x7e,
			0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x80, 0x81, 0x80,
			0x80, 0x81, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81, 0x82, 0x83, 0x83,
			0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x81, 0x80,
			0x80, 0x81, 0x82, 0x82, 0x82, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x82, 0x80, 0x7e, 0x7f, 0x82, 0x80, 0x81, 0x82, 0x82, 0x81, 0x80,
			0x82, 0x82, 0x81, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x7f, 0x80, 0x82, 0x7f, 0x7f,
			0x82, 0x82, 0x7f, 0x7e, 0x81, 0x82, 0x7f, 0x7f, 0x81, 0x81, 0x7f,
			0x7e, 0x7f, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x81, 0x81,
			0x81, 0x81, 0x7f, 0x7e, 0x81, 0x80, 0x7e, 0x7e, 0x80, 0x80, 0x7e,
			0x7f, 0x81, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x82, 0x81, 0x7e, 0x7e,
			0x80, 0x7f, 0x7f, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x82,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x7d, 0x80, 0x81, 0x7f, 0x80,
			0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f,
			0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x80, 0x80, 0x7e, 0x7f, 0x7f,
			0x7d, 0x7d, 0x7e, 0x7f, 0x7e, 0x7f, 0x80, 0x7d, 0x7d, 0x7e, 0x7f,
			0x7e, 0x7e, 0x80, 0x7e, 0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x7e,
			0x80, 0x80, 0x7d, 0x7e, 0x80, 0x7f, 0x7d, 0x7e, 0x80, 0x7f, 0x7e,
			0x80, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7e, 0x7f, 0x7f, 0x81,
			0x80, 0x7e, 0x7e, 0x7f, 0x7e, 0x7d, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7d, 0x7d, 0x7f, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7f, 0x7f,
			0x7d, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7e,
			0x80, 0x81, 0x7f, 0x7d, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x80,
			0x7e, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x82, 0x81, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x82, 0x81, 0x80, 0x7e, 0x81, 0x80, 0x7f, 0x81,
			0x7f, 0x7d, 0x7f, 0x7f, 0x7f, 0x82, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x7f, 0x7e, 0x80, 0x7e, 0x7f, 0x7d, 0x7d, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7e, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x81, 0x7e, 0x7e,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x80, 0x7e, 0x7e, 0x7e, 0x7d, 0x7f,
			0x7f, 0x80, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x81, 0x82, 0x80, 0x7e, 0x80, 0x83, 0x80, 0x81,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x82, 0x80, 0x83,
			0x7f, 0x82, 0x82, 0x82, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x80,
			0x80, 0x7e, 0x7f, 0x7e, 0x7f, 0x82, 0x80, 0x80, 0x82, 0x82, 0x81,
			0x80, 0x80, 0x80, 0x7e, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x81, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x81, 0x7c, 0x7d, 0x7f, 0x7c, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x7e, 0x80, 0x80,
			0x7f, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x81, 0x80, 0x81, 0x7f,
			0x80, 0x7f, 0x81, 0x81, 0x81, 0x80, 0x82, 0x7f, 0x7f, 0x82, 0x82,
			0x80, 0x7f, 0x82, 0x7f, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x7e, 0x81,
			0x7f, 0x7f, 0x81, 0x80, 0x7f, 0x7d, 0x80, 0x7e, 0x7f, 0x80, 0x81,
			0x7f, 0x80, 0x81, 0x7e, 0x80, 0x7e, 0x81, 0x80, 0x81, 0x81, 0x82,
			0x81, 0x7e, 0x80, 0x7e, 0x7e, 0x7e, 0x81, 0x80, 0x81, 0x80, 0x80,
			0x81, 0x7e, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7d, 0x7f, 0x81,
			0x80, 0x80, 0x81, 0x82, 0x81, 0x81, 0x7f, 0x7e, 0x80, 0x80, 0x7e,
			0x80, 0x80, 0x7f, 0x7f, 0x7d, 0x7f, 0x7f, 0x7d, 0x7c, 0x80, 0x7f,
			0x7d, 0x7c, 0x7e, 0x7e, 0x7d, 0x80, 0x7d, 0x81, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x82, 0x81, 0x7e, 0x7d, 0x82, 0x80,
			0x7f, 0x81, 0x82, 0x80, 0x7f, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x82,
			0x82, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x83, 0x81, 0x7f, 0x82, 0x81,
			0x80, 0x7f, 0x81, 0x7e, 0x7e, 0x7f, 0x81, 0x81, 0x7f, 0x7e, 0x7e,
			0x81, 0x7d, 0x80, 0x80, 0x7d, 0x7e, 0x7e, 0x7d, 0x7c, 0x7e, 0x80,
			0x7d, 0x80, 0x80, 0x80, 0x7e, 0x7a, 0x80, 0x81, 0x7c, 0x7d, 0x7f,
			0x83, 0x7f, 0x80, 0x83, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x81, 0x80,
			0x82, 0x83, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x82, 0x83, 0x82, 0x80,
			0x80, 0x81, 0x7d, 0x7c, 0x7f, 0x82, 0x7e, 0x83, 0x7f, 0x80, 0x80,
			0x80, 0x83, 0x83, 0x84, 0x7a, 0x7f, 0x7d, 0x7f, 0x7e, 0x7d, 0x84,
			0x7c, 0x7b, 0x79, 0x7e, 0x81, 0x7c, 0x80, 0x7f, 0x81, 0x81, 0x7d,
			0x7f, 0x7d, 0x7f, 0x7c, 0x7a, 0x7e, 0x7d, 0x7b, 0x7d, 0x7e, 0x80,
			0x7e, 0x7d, 0x7e, 0x7f, 0x81, 0x7f, 0x7f, 0x81, 0x81, 0x83, 0x83,
			0x81, 0x87, 0x84, 0x84, 0x80, 0x83, 0x83, 0x7e, 0x83, 0x86, 0x86,
			0x84, 0x87, 0x89, 0x87, 0x86, 0x82, 0x7c, 0x80, 0x7f, 0x7b, 0x7e,
			0x83, 0x80, 0x7f, 0x7d, 0x7f, 0x82, 0x80, 0x7b, 0x79, 0x7d, 0x7c,
			0x76, 0x78, 0x7d, 0x7e, 0x7c, 0x79, 0x7e, 0x7b, 0x7c, 0x7c, 0x7f,
			0x7f, 0x7a, 0x7b, 0x7e, 0x7d, 0x7a, 0x7f, 0x7b, 0x7c, 0x7b, 0x7c,
			0x7c, 0x79, 0x7b, 0x7d, 0x79, 0x78, 0x7a, 0x7c, 0x7b, 0x7d, 0x80,
			0x82, 0x86, 0x84, 0x89, 0x8c, 0x92, 0x93, 0x95, 0x97, 0x98, 0x97,
			0x92, 0x92, 0x8f, 0x85, 0x7b, 0x70, 0x62, 0x60, 0x64, 0x65, 0x5d,
			0x5d, 0x5d, 0x5e, 0x60, 0x73, 0x92, 0xa5, 0xab, 0xaa, 0xad, 0xae,
			0xa4, 0x96, 0x93, 0x9a, 0x9a, 0x92, 0x8c, 0x85, 0x7d, 0x6c, 0x60,
			0x56, 0x4d, 0x45, 0x4b, 0x4a, 0x4c, 0x4f, 0x62, 0x9a, 0xa9, 0xa5,
			0xa2, 0x9c, 0x98, 0x80, 0x78, 0x84, 0x92, 0x98, 0x98, 0x9c, 0x9d,
			0x8f, 0x79, 0x79, 0x6f, 0x5a, 0x56, 0x51, 0x4a, 0x4e, 0x56, 0x70,
			0x7b, 0x83, 0xb0, 0xae, 0xa4, 0x94, 0x85, 0x8c, 0x82, 0x82, 0x91,
			0xa2, 0xa9, 0xa6, 0x9e, 0x98, 0x8a, 0x79, 0x72, 0x72, 0x71, 0x65,
			0x59, 0x53, 0x4a, 0x4e, 0x5c, 0x77, 0x75, 0x86, 0xb4, 0xa5, 0x99,
			0x84, 0x7e, 0x83, 0x7c, 0x88, 0x98, 0xad, 0xab, 0x9b, 0x95, 0x85,
			0x78, 0x6e, 0x6f, 0x78, 0x6e, 0x5e, 0x54, 0x50, 0x45, 0x4c, 0x62,
			0x86, 0x71, 0x9c, 0xbc, 0xa0, 0x92, 0x74, 0x88, 0x7d, 0x83, 0x93,
			0xa8, 0xb9, 0xa5, 0x96, 0x8d, 0x7c, 0x73, 0x73, 0x7b, 0x7b, 0x68,
			0x60, 0x5a, 0x49, 0x45, 0x54, 0x7f, 0x82, 0x75, 0xbd, 0xb3, 0x96,
			0x7b, 0x71, 0x84, 0x7d, 0x89, 0xa5, 0xb9, 0xad, 0x97, 0x88, 0x7c,
			0x75, 0x71, 0x78, 0x8a, 0x74, 0x66, 0x59, 0x56, 0x49, 0x47, 0x58,
			0x8a, 0x7c, 0x8c, 0xc7, 0xa4, 0x8f, 0x6d, 0x74, 0x7c, 0x7c, 0x91,
			0xab, 0xb4, 0xa6, 0x8e, 0x7a, 0x75, 0x75, 0x73, 0x82, 0x82, 0x73,
			0x62, 0x51, 0x50, 0x49, 0x4b, 0x64, 0x90, 0x81, 0xb4, 0xb8, 0x93,
			0x81, 0x62, 0x74, 0x79, 0x8c, 0xa3, 0xb6, 0xb0, 0x9a, 0x83, 0x74,
			0x70, 0x76, 0x7b, 0x8d, 0x7e, 0x6d, 0x60, 0x56, 0x4d, 0x50, 0x52,
			0x6e, 0x96, 0x8b, 0xc0, 0xaf, 0x89, 0x70, 0x66, 0x76, 0x80, 0x94,
			0xa8, 0xb8, 0xa3, 0x8d, 0x75, 0x71, 0x75, 0x7d, 0x83, 0x8f, 0x7c,
			0x6a, 0x58, 0x58, 0x5c, 0x59, 0x4a, 0x74, 0x8f, 0x91, 0xc7, 0xa2,
			0x8c, 0x6c, 0x60, 0x76, 0x82, 0x9c, 0xb3, 0xb6, 0x9e, 0x82, 0x70,
			0x72, 0x79, 0x81, 0x8f, 0x8c, 0x75, 0x64, 0x5b, 0x5c, 0x56, 0x50,
			0x57, 0x91, 0x8e, 0xac, 0xbf, 0x8d, 0x79, 0x56, 0x66, 0x7d, 0x94,
			0xae, 0xba, 0xaa, 0x8d, 0x73, 0x6d, 0x74, 0x83, 0x8b, 0x90, 0x7f,
			0x6a, 0x5d, 0x5b, 0x5d, 0x60, 0x4e, 0x5f, 0x95, 0x8f, 0xc0, 0xad,
			0x87, 0x6d, 0x57, 0x70, 0x83, 0x9d, 0xb8, 0xb6, 0xa4, 0x83, 0x6d,
			0x6f, 0x76, 0x86, 0x89, 0x8b, 0x73, 0x67, 0x5d, 0x5c, 0x5a, 0x66,
			0x4d, 0x73, 0x91, 0xa6, 0xc8, 0x91, 0x7f, 0x67, 0x61, 0x75, 0x8d,
			0xac, 0xb5, 0xa5, 0x96, 0x76, 0x6c, 0x71, 0x82, 0x87, 0x8e, 0x84,
			0x71, 0x65, 0x5f, 0x5c, 0x5c, 0x5a, 0x50, 0x8b, 0x93, 0xc0, 0xb1,
			0x7f, 0x72, 0x5b, 0x6a, 0x7c, 0x9e, 0xb8, 0xb4, 0x9b, 0x87, 0x6e,
			0x72, 0x75, 0x87, 0x90, 0x8f, 0x79, 0x6d, 0x61, 0x60, 0x5e, 0x67,
			0x4f, 0x5e, 0x95, 0x97, 0xc5, 0x97, 0x78, 0x6e, 0x5b, 0x71, 0x88,
			0xa4, 0xb8, 0xa1, 0x96, 0x7d, 0x6e, 0x74, 0x7a, 0x8d, 0x8b, 0x8a,
			0x76, 0x6a, 0x5f, 0x5a, 0x63, 0x60, 0x4a, 0x88, 0x97, 0xaf, 0xb0,
			0x80, 0x77, 0x5e, 0x63, 0x83, 0x9c, 0xb3, 0xa9, 0x99, 0x84, 0x6b,
			0x75, 0x78, 0x8f, 0x8a, 0x84, 0x78, 0x69, 0x5e, 0x5e, 0x5f, 0x67,
			0x4c, 0x79, 0x97, 0xac, 0xbb, 0x80, 0x77, 0x64, 0x64, 0x7b, 0x97,
			0xb5, 0xa9, 0x97, 0x84, 0x70, 0x72, 0x73, 0x8e, 0x8c, 0x86, 0x74,
			0x69, 0x65, 0x5e, 0x5d, 0x63, 0x51, 0x7d, 0x96, 0xad, 0xb4, 0x7f,
			0x79, 0x61, 0x6b, 0x7e, 0x99, 0xb3, 0xaa, 0x96, 0x83, 0x70, 0x74,
			0x77, 0x89, 0x8c, 0x81, 0x76, 0x69, 0x60, 0x5e, 0x65, 0x64, 0x53,
			0x7c, 0x93, 0xa9, 0xb2, 0x81, 0x7b, 0x63, 0x69, 0x84, 0x99, 0xb3,
			0xa8, 0x99, 0x83, 0x71, 0x73, 0x7a, 0x8b, 0x8a, 0x84, 0x75, 0x66,
			0x5f, 0x5a, 0x64, 0x5e, 0x51, 0x85, 0x94, 0xab, 0xad, 0x80, 0x7b,
			0x63, 0x6e, 0x8b, 0x9c, 0xb1, 0xa2, 0x95, 0x83, 0x75, 0x78, 0x82,
			0x8a, 0x86, 0x7d, 0x71, 0x65, 0x61, 0x5d, 0x61, 0x61, 0x58, 0x8f,
			0x8d, 0xa9, 0x9e, 0x76, 0x75, 0x61, 0x83, 0x92, 0xa2, 0xaa, 0x9b,
			0x91, 0x7c, 0x7c, 0x85, 0x8b, 0x8b, 0x84, 0x7c, 0x70, 0x67, 0x64,
			0x62, 0x64, 0x52, 0x5d, 0x8d, 0x8f, 0xa8, 0x89, 0x76, 0x70, 0x67,
			0x86, 0x92, 0xa3, 0xa2, 0x9d, 0x8e, 0x80, 0x80, 0x85, 0x8e, 0x89,
			0x87, 0x80, 0x75, 0x68, 0x5f, 0x5b, 0x67, 0x51, 0x6a, 0x8e, 0x88,
			0xa5, 0x80, 0x75, 0x67, 0x69, 0x8f, 0x95, 0xa4, 0x9f, 0x9a, 0x8c,
			0x80, 0x80, 0x89, 0x8d, 0x8c, 0x88, 0x83, 0x72, 0x66, 0x5e, 0x5d,
			0x62, 0x51, 0x80, 0x8b, 0x8d, 0x9c, 0x7b, 0x73, 0x61, 0x71, 0x90,
			0x95, 0xa4, 0x9d, 0x99, 0x89, 0x7e, 0x82, 0x89, 0x8d, 0x89, 0x8a,
			0x80, 0x70, 0x66, 0x62, 0x60, 0x61, 0x56, 0x87, 0x83, 0x95, 0x9b,
			0x78, 0x70, 0x5e, 0x7f, 0x8e, 0x98, 0xa0, 0x9d, 0x97, 0x84, 0x81,
			0x83, 0x8a, 0x90, 0x8c, 0x8b, 0x7b, 0x6e, 0x68, 0x5d, 0x5f, 0x58,
			0x5e, 0x89, 0x7c, 0x9a, 0x93, 0x78, 0x6f, 0x63, 0x82, 0x8c, 0x98,
			0x9f, 0xa0, 0x95, 0x85, 0x81, 0x86, 0x89, 0x89, 0x8e, 0x8b, 0x7c,
			0x6a, 0x66, 0x5f, 0x5f, 0x53, 0x64, 0x93, 0x7c, 0x9b, 0x8a, 0x7c,
			0x6b, 0x5e, 0x8a, 0x8a, 0x9c, 0x9e, 0xa0, 0x96, 0x81, 0x7f, 0x84,
			0x8b, 0x89, 0x8a, 0x8c, 0x7c, 0x68, 0x62, 0x5b, 0x63, 0x50, 0x72,
			0x8a, 0x84, 0xa0, 0x82, 0x7c, 0x69, 0x6e, 0x8a, 0x8e, 0x9d, 0xa1,
			0x9f, 0x91, 0x81, 0x82, 0x84, 0x88, 0x8c, 0x8e, 0x86, 0x77, 0x69,
			0x60, 0x59, 0x60, 0x59, 0x79, 0x82, 0x81, 0xa0, 0x7f, 0x79, 0x64,
			0x78, 0x8a, 0x89, 0x9d, 0xa1, 0x9f, 0x90, 0x85, 0x84, 0x84, 0x86,
			0x8c, 0x8d, 0x87, 0x75, 0x6b, 0x62, 0x5a, 0x59, 0x55, 0x7d, 0x7e,
			0x82, 0x9a, 0x81, 0x79, 0x64, 0x77, 0x86, 0x89, 0x9d, 0xa4, 0xa2,
			0x91, 0x83, 0x83, 0x84, 0x87, 0x8d, 0x91, 0x88, 0x77, 0x6b, 0x5e,
			0x58, 0x55, 0x5a, 0x7e, 0x76, 0x8a, 0x9b, 0x80, 0x77, 0x66, 0x7d,
			0x80, 0x8c, 0x9d, 0xa8, 0xa1, 0x91, 0x87, 0x85, 0x84, 0x84, 0x8f,
			0x8f, 0x83, 0x74, 0x6c, 0x60, 0x57, 0x51, 0x63, 0x81, 0x71, 0x8d,
			0x96, 0x80, 0x78, 0x69, 0x81, 0x7f, 0x8f, 0x9f, 0xa5, 0x9e, 0x8d,
			0x89, 0x88, 0x83, 0x85, 0x93, 0x8e, 0x80, 0x72, 0x6b, 0x5f, 0x58,
			0x53, 0x69, 0x7b, 0x70, 0x8a, 0x90, 0x82, 0x76, 0x6d, 0x82, 0x80,
			0x89, 0x9c, 0xa6, 0x9e, 0x91, 0x8b, 0x8a, 0x82, 0x86, 0x8f, 0x8e,
			0x83, 0x72, 0x6c, 0x5e, 0x55, 0x52, 0x6e, 0x74, 0x70, 0x8e, 0x8c,
			0x7f, 0x72, 0x73, 0x7e, 0x7e, 0x8a, 0xa2, 0xa7, 0x9c, 0x96, 0x8e,
			0x8a, 0x80, 0x86, 0x91, 0x8a, 0x80, 0x74, 0x6b, 0x5e, 0x53, 0x57,
			0x72, 0x6f, 0x70, 0x8d, 0x8b, 0x80, 0x72, 0x7b, 0x83, 0x7f, 0x8e,
			0x9f, 0xa4, 0x9b, 0x94, 0x8f, 0x8b, 0x82, 0x87, 0x8f, 0x88, 0x7d,
			0x73, 0x6a, 0x5d, 0x53, 0x5d, 0x71, 0x69, 0x72, 0x8d, 0x86, 0x7e,
			0x76, 0x7e, 0x83, 0x7e, 0x8c, 0x9f, 0xa2, 0x9b, 0x97, 0x95, 0x8e,
			0x82, 0x89, 0x8b, 0x83, 0x7b, 0x76, 0x6a, 0x5c, 0x54, 0x62, 0x6c,
			0x60, 0x77, 0x8a, 0x83, 0x7b, 0x79, 0x84, 0x82, 0x80, 0x91, 0x9f,
			0x9e, 0x98, 0x99, 0x99, 0x8c, 0x85, 0x8c, 0x8a, 0x81, 0x78, 0x73,
			0x69, 0x5a, 0x57, 0x65, 0x69, 0x66, 0x7a, 0x83, 0x81, 0x7a, 0x7c,
			0x83, 0x81, 0x85, 0x91, 0x9d, 0x9b, 0x97, 0x99, 0x97, 0x8d, 0x8a,
			0x8d, 0x89, 0x80, 0x76, 0x71, 0x68, 0x5d, 0x5f, 0x67, 0x68, 0x66,
			0x74, 0x7b, 0x7a, 0x79, 0x7e, 0x86, 0x83, 0x87, 0x91, 0x98, 0x98,
			0x97, 0x99, 0x98, 0x90, 0x8e, 0x8d, 0x8a, 0x83, 0x7b, 0x75, 0x6d,
			0x65, 0x65, 0x67, 0x65, 0x66, 0x6f, 0x72, 0x72, 0x74, 0x7c, 0x81,
			0x83, 0x88, 0x8f, 0x93, 0x93, 0x95, 0x97, 0x99, 0x94, 0x93, 0x92,
			0x8e, 0x89, 0x82, 0x7e, 0x77, 0x70, 0x6c, 0x6b, 0x65, 0x63, 0x66,
			0x67, 0x68, 0x6b, 0x71, 0x77, 0x7c, 0x81, 0x88, 0x8e, 0x92, 0x95,
			0x99, 0x9c, 0x9b, 0x9d, 0x9a, 0x99, 0x94, 0x8e, 0x87, 0x81, 0x78,
			0x71, 0x6b, 0x63, 0x60, 0x5d, 0x5d, 0x5f, 0x62, 0x67, 0x6c, 0x74,
			0x7b, 0x83, 0x8a, 0x91, 0x97, 0x9c, 0x9f, 0xa2, 0xa2, 0xa0, 0x9e,
			0x9a, 0x93, 0x8c, 0x86, 0x7c, 0x73, 0x6d, 0x66, 0x5f, 0x5b, 0x5c,
			0x5c, 0x5e, 0x61, 0x68, 0x6e, 0x75, 0x7e, 0x85, 0x8e, 0x95, 0x99,
			0x9e, 0xa2, 0xa2, 0xa1, 0xa1, 0x9e, 0x98, 0x92, 0x8a, 0x82, 0x78,
			0x70, 0x69, 0x62, 0x5c, 0x5b, 0x5c, 0x5c, 0x5f, 0x64, 0x6b, 0x72,
			0x7a, 0x82, 0x8a, 0x91, 0x96, 0x9b, 0xa0, 0xa2, 0xa2, 0xa1, 0xa0,
			0x9b, 0x95, 0x8f, 0x86, 0x7d, 0x73, 0x6c, 0x64, 0x5e, 0x5b, 0x5c,
			0x5b, 0x5d, 0x62, 0x68, 0x6f, 0x76, 0x7e, 0x86, 0x8e, 0x93, 0x98,
			0x9d, 0xa1, 0xa2, 0xa2, 0xa1, 0x9d, 0x97, 0x91, 0x89, 0x81, 0x77,
			0x6f, 0x68, 0x62, 0x5d, 0x5d, 0x5d, 0x5d, 0x61, 0x66, 0x6c, 0x73,
			0x7b, 0x83, 0x8a, 0x91, 0x96, 0x9b, 0x9f, 0xa1, 0xa1, 0xa1, 0x9e,
			0x99, 0x94, 0x8c, 0x84, 0x7b, 0x73, 0x6c, 0x64, 0x5f, 0x5d, 0x5d,
			0x5d, 0x60, 0x65, 0x6b, 0x71, 0x78, 0x80, 0x88, 0x8e, 0x93, 0x98,
			0x9d, 0x9f, 0xa0, 0xa1, 0x9f, 0x9b, 0x96, 0x90, 0x88, 0x7f, 0x76,
			0x70, 0x69, 0x62, 0x5f, 0x5e, 0x5d, 0x5e, 0x62, 0x67, 0x6d, 0x73,
			0x7b, 0x83, 0x89, 0x8f, 0x95, 0x9a, 0x9d, 0x9f, 0x9f, 0xa0, 0x9d,
			0x98, 0x93, 0x8d, 0x84, 0x7b, 0x74, 0x6e, 0x67, 0x61, 0x60, 0x5f,
			0x5e, 0x61, 0x65, 0x6b, 0x70, 0x77, 0x7f, 0x86, 0x8c, 0x91, 0x97,
			0x9b, 0x9d, 0x9e, 0x9f, 0x9e, 0x9b, 0x95, 0x90, 0x89, 0x80, 0x77,
			0x72, 0x6b, 0x64, 0x61, 0x60, 0x5f, 0x60, 0x64, 0x69, 0x6f, 0x74,
			0x7b, 0x82, 0x89, 0x8f, 0x93, 0x98, 0x9b, 0x9d, 0x9d, 0x9d, 0x9b,
			0x96, 0x91, 0x8b, 0x83, 0x7a, 0x74, 0x6e, 0x67, 0x63, 0x61, 0x61,
			0x60, 0x63, 0x68, 0x6d, 0x72, 0x79, 0x80, 0x86, 0x8c, 0x91, 0x96,
			0x9a, 0x9b, 0x9c, 0x9d, 0x9b, 0x97, 0x93, 0x8d, 0x85, 0x7d, 0x76,
			0x70, 0x6a, 0x65, 0x63, 0x62, 0x62, 0x64, 0x68, 0x6c, 0x71, 0x78,
			0x7e, 0x85, 0x8a, 0x8f, 0x94, 0x98, 0x9a, 0x9b, 0x9c, 0x9b, 0x97,
			0x93, 0x8d, 0x87, 0x7f, 0x77, 0x72, 0x6c, 0x66, 0x64, 0x64, 0x63,
			0x64, 0x68, 0x6d, 0x71, 0x77, 0x7e, 0x84, 0x89, 0x8e, 0x93, 0x96,
			0x99, 0x9a, 0x9b, 0x9a, 0x97, 0x93, 0x8e, 0x88, 0x80, 0x79, 0x73,
			0x6d, 0x68, 0x65, 0x65, 0x63, 0x64, 0x68, 0x6d, 0x71, 0x76, 0x7d,
			0x83, 0x88, 0x8c, 0x92, 0x95, 0x97, 0x99, 0x9a, 0x9a, 0x96, 0x93,
			0x8e, 0x87, 0x80, 0x79, 0x74, 0x6e, 0x69, 0x66, 0x66, 0x64, 0x65,
			0x69, 0x6d, 0x72, 0x77, 0x7d, 0x83, 0x88, 0x8d, 0x92, 0x95, 0x97,
			0x98, 0x99, 0x98, 0x95, 0x92, 0x8c, 0x86, 0x7e, 0x78, 0x73, 0x6d,
			0x69, 0x67, 0x66, 0x65, 0x67, 0x6b, 0x6f, 0x73, 0x79, 0x7f, 0x84,
			0x89, 0x8d, 0x92, 0x95, 0x96, 0x98, 0x98, 0x97, 0x94, 0x90, 0x8b,
			0x85, 0x7e, 0x78, 0x73, 0x6e, 0x69, 0x67, 0x67, 0x66, 0x67, 0x6b,
			0x6f, 0x73, 0x78, 0x7e, 0x84, 0x88, 0x8c, 0x90, 0x94, 0x96, 0x97,
			0x98, 0x97, 0x94, 0x90, 0x8b, 0x86, 0x7f, 0x79, 0x75, 0x70, 0x6b,
			0x68, 0x68, 0x67, 0x68, 0x6c, 0x70, 0x73, 0x78, 0x7d, 0x82, 0x87,
			0x8b, 0x90, 0x92, 0x94, 0x96, 0x96, 0x96, 0x93, 0x90, 0x8b, 0x86,
			0x7f, 0x79, 0x75, 0x70, 0x6c, 0x6a, 0x69, 0x69, 0x6a, 0x6d, 0x71,
			0x74, 0x79, 0x7e, 0x82, 0x87, 0x8b, 0x8f, 0x91, 0x93, 0x95, 0x95,
			0x94, 0x92, 0x8f, 0x8a, 0x85, 0x7e, 0x79, 0x75, 0x70, 0x6d, 0x6a,
			0x6a, 0x69, 0x6a, 0x6e, 0x71, 0x75, 0x79, 0x7f, 0x83, 0x87, 0x8b,
			0x8f, 0x91, 0x93, 0x94, 0x95, 0x94, 0x91, 0x8d, 0x89, 0x84, 0x7d,
			0x79, 0x74, 0x70, 0x6d, 0x6b, 0x6b, 0x6a, 0x6c, 0x6f, 0x73, 0x76,
			0x7b, 0x80, 0x84, 0x88, 0x8b, 0x8f, 0x91, 0x92, 0x93, 0x94, 0x93,
			0x90, 0x8c, 0x88, 0x82, 0x7d, 0x79, 0x74, 0x70, 0x6d, 0x6b, 0x6b,
			0x6b, 0x6d, 0x70, 0x73, 0x77, 0x7b, 0x80, 0x84, 0x88, 0x8c, 0x8f,
			0x90, 0x92, 0x93, 0x93, 0x91, 0x8f, 0x8b, 0x87, 0x81, 0x7c, 0x78,
			0x74, 0x70, 0x6e, 0x6d, 0x6c, 0x6c, 0x6e, 0x71, 0x74, 0x78, 0x7c,
			0x81, 0x85, 0x88, 0x8c, 0x8f, 0x91, 0x91, 0x92, 0x92, 0x90, 0x8d,
			0x89, 0x85, 0x7f, 0x7b, 0x77, 0x73, 0x70, 0x6e, 0x6d, 0x6d, 0x6e,
			0x70, 0x73, 0x76, 0x79, 0x7e, 0x82, 0x85, 0x89, 0x8c, 0x8e, 0x90,
			0x91, 0x91, 0x91, 0x8e, 0x8c, 0x88, 0x83, 0x7e, 0x7b, 0x77, 0x74,
			0x70, 0x6f, 0x6e, 0x6e, 0x6f, 0x72, 0x75, 0x77, 0x7b, 0x7f, 0x83,
			0x86, 0x8a, 0x8c, 0x8e, 0x8f, 0x90, 0x91, 0x8f, 0x8d, 0x89, 0x86,
			0x81, 0x7d, 0x79, 0x76, 0x72, 0x70, 0x6f, 0x6f, 0x70, 0x71, 0x74,
			0x76, 0x79, 0x7d, 0x81, 0x85, 0x88, 0x8a, 0x8d, 0x8e, 0x8f, 0x90,
			0x8f, 0x8e, 0x8a, 0x87, 0x83, 0x7e, 0x7b, 0x77, 0x74, 0x72, 0x70,
			0x70, 0x70, 0x71, 0x73, 0x75, 0x78, 0x7c, 0x7f, 0x83, 0x86, 0x89,
			0x8b, 0x8d, 0x8e, 0x8f, 0x8f, 0x8d, 0x8b, 0x88, 0x84, 0x80, 0x7d,
			0x79, 0x76, 0x73, 0x71, 0x71, 0x70, 0x71, 0x73, 0x75, 0x77, 0x7b,
			0x7e, 0x82, 0x85, 0x88, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x8e, 0x8c,
			0x89, 0x86, 0x82, 0x7e, 0x7b, 0x78, 0x75, 0x72, 0x71, 0x71, 0x71,
			0x72, 0x74, 0x76, 0x78, 0x7c, 0x7f, 0x82, 0x85, 0x88, 0x8b, 0x8c,
			0x8d, 0x8e, 0x8e, 0x8d, 0x8a, 0x87, 0x84, 0x80, 0x7d, 0x7a, 0x77,
			0x74, 0x72, 0x71, 0x71, 0x72, 0x74, 0x76, 0x77, 0x7a, 0x7d, 0x81,
			0x84, 0x87, 0x89, 0x8b, 0x8c, 0x8d, 0x8d, 0x8c, 0x8b, 0x88, 0x85,
			0x82, 0x7f, 0x7c, 0x79, 0x76, 0x74, 0x73, 0x72, 0x72, 0x74, 0x75,
			0x76, 0x79, 0x7c, 0x7f, 0x82, 0x85, 0x87, 0x89, 0x8a, 0x8c, 0x8c,
			0x8c, 0x8b, 0x89, 0x87, 0x84, 0x81, 0x7e, 0x7b, 0x79, 0x76, 0x74,
			0x73, 0x73, 0x74, 0x75, 0x76, 0x78, 0x7a, 0x7d, 0x80, 0x83, 0x86,
			0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8b, 0x8a, 0x88, 0x85, 0x83, 0x80,
			0x7e, 0x7b, 0x78, 0x76, 0x75, 0x74, 0x74, 0x75, 0x77, 0x78, 0x7a,
			0x7c, 0x7f, 0x81, 0x83, 0x85, 0x87, 0x88, 0x89, 0x89, 0x88, 0x87,
			0x86, 0x84, 0x82, 0x80, 0x7e, 0x7c, 0x7a, 0x78, 0x77, 0x77, 0x77,
			0x78, 0x79, 0x7a, 0x7c, 0x7e, 0x80, 0x82, 0x84, 0x85, 0x86, 0x87,
			0x88, 0x88, 0x88, 0x87, 0x85, 0x84, 0x82, 0x81, 0x7e, 0x7c, 0x7a,
			0x78, 0x77, 0x77, 0x77, 0x77, 0x78, 0x79, 0x7a, 0x7c, 0x7e, 0x80,
			0x82, 0x84, 0x85, 0x86, 0x87, 0x87, 0x87, 0x86, 0x86, 0x85, 0x83,
			0x82, 0x80, 0x7e, 0x7c, 0x7a, 0x79, 0x79, 0x78, 0x78, 0x78, 0x79,
			0x7a, 0x7c, 0x7d, 0x7f, 0x80, 0x82, 0x83, 0x84, 0x85, 0x86, 0x86,
			0x86, 0x85, 0x85, 0x84, 0x83, 0x82, 0x80, 0x7e, 0x7d, 0x7c, 0x7b,
			0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x80, 0x81,
			0x82, 0x83, 0x84, 0x84, 0x85, 0x85, 0x84, 0x84, 0x83, 0x82, 0x81,
			0x80, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c,
			0x7c, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83,
			0x83, 0x83, 0x82, 0x82, 0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80,
			0x80, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x7f, 0x80,
		},
		{ // 4
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x81, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e,
			0x7f, 0x7f, 0x80, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x81, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x81, 0x80, 0x80, 0x7f, 0x81, 0x80,
			0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81,
			0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x82, 0x81, 0x82, 0x82, 0x81,
			0x80, 0x81, 0x82, 0x82, 0x81, 0x82, 0x81, 0x81, 0x80, 0x80, 0x82,
			0x82, 0x80, 0x81, 0x80, 0x81, 0x81, 0x81, 0x82, 0x81, 0x80, 0x80,
			0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x7f, 0x80, 0x81, 0x80,
			0x80, 0x81, 0x82, 0x83, 0x82, 0x81, 0x82, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7d, 0x7d, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x81,
			0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7f, 0x7d, 0x7e, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7e, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7e, 0x7d, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7e, 0x7f, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7e, 0x7f, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c,
			0x7d, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7d, 0x7d, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7c, 0x7e,
			0x80, 0x80, 0x7e, 0x7d, 0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x7d, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7e, 0x7e,
			0x7f, 0x7f, 0x80, 0x80, 0x7d, 0x7d, 0x80, 0x7f, 0x7f, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7d, 0x7e, 0x7f, 0x81,
			0x7f, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7e, 0x7e,
			0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7d, 0x7d, 0x7f, 0x7f, 0x7e,
			0x80, 0x81, 0x7f, 0x81, 0x7e, 0x80, 0x7f, 0x81, 0x81, 0x7f, 0x7f,
			0x7e, 0x81, 0x7f, 0x81, 0x81, 0x80, 0x80, 0x81, 0x84, 0x80, 0x7f,
			0x80, 0x7e, 0x7e, 0x80, 0x82, 0x80, 0x7f, 0x81, 0x81, 0x7f, 0x7e,
			0x80, 0x7f, 0x81, 0x81, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x80, 0x7e,
			0x81, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x80, 0x7e, 0x7f, 0x7f,
			0x80, 0x7e, 0x7d, 0x80, 0x7f, 0x80, 0x81, 0x80, 0x80, 0x7e, 0x7f,
			0x7e, 0x81, 0x80, 0x7d, 0x7f, 0x80, 0x80, 0x7c, 0x7d, 0x7b, 0x7b,
			0x7d, 0x7c, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7f, 0x81, 0x7f,
			0x7e, 0x7c, 0x7e, 0x7d, 0x7d, 0x80, 0x81, 0x7e, 0x7f, 0x80, 0x80,
			0x83, 0x85, 0x81, 0x83, 0x84, 0x83, 0x7f, 0x80, 0x80, 0x81, 0x84,
			0x7f, 0x7f, 0x7f, 0x82, 0x7f, 0x7f, 0x7f, 0x7c, 0x81, 0x80, 0x7e,
			0x7d, 0x7f, 0x7f, 0x81, 0x82, 0x81, 0x80, 0x7e, 0x7c, 0x7d, 0x80,
			0x81, 0x80, 0x7f, 0x82, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x82, 0x7f,
			0x7d, 0x7e, 0x7e, 0x80, 0x80, 0x7b, 0x7b, 0x7f, 0x81, 0x82, 0x7f,
			0x7e, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x82, 0x7e, 0x7a, 0x80, 0x82,
			0x81, 0x81, 0x83, 0x83, 0x80, 0x7f, 0x7f, 0x7f, 0x81, 0x83, 0x85,
			0x86, 0x81, 0x7b, 0x7c, 0x7e, 0x80, 0x82, 0x83, 0x80, 0x81, 0x80,
			0x7f, 0x83, 0x81, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7a, 0x7d, 0x80,
			0x7e, 0x7c, 0x7e, 0x82, 0x7e, 0x7c, 0x80, 0x7f, 0x7c, 0x7d, 0x7e,
			0x7e, 0x7c, 0x7a, 0x7d, 0x80, 0x7e, 0x7f, 0x80, 0x7f, 0x7f, 0x82,
			0x83, 0x82, 0x7f, 0x80, 0x81, 0x83, 0x80, 0x81, 0x82, 0x81, 0x81,
			0x7f, 0x80, 0x7c, 0x81, 0x81, 0x80, 0x81, 0x81, 0x7f, 0x7f, 0x82,
			0x7f, 0x82, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x7d,
			0x7f, 0x7e, 0x7c, 0x7c, 0x7d, 0x80, 0x7e, 0x7d, 0x7e, 0x7e, 0x7e,
			0x7d, 0x81, 0x82, 0x7d, 0x79, 0x7c, 0x7f, 0x7b, 0x7d, 0x7d, 0x7f,
			0x7d, 0x7e, 0x7e, 0x7d, 0x7f, 0x7f, 0x81, 0x80, 0x7e, 0x7d, 0x82,
			0x82, 0x7e, 0x7e, 0x83, 0x7e, 0x7d, 0x81, 0x7f, 0x7e, 0x7e, 0x80,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x80, 0x81, 0x81, 0x82, 0x7b, 0x79,
			0x81, 0x81, 0x80, 0x7f, 0x82, 0x7f, 0x7c, 0x7e, 0x81, 0x7e, 0x7e,
			0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7e,
			0x7d, 0x7d, 0x7f, 0x80, 0x82, 0x82, 0x7c, 0x77, 0x7d, 0x7f, 0x7d,
			0x7f, 0x7e, 0x7d, 0x7e, 0x7f, 0x7f, 0x7d, 0x7c, 0x80, 0x7f, 0x7c,
			0x7b, 0x7c, 0x7e, 0x7d, 0x7d, 0x81, 0x80, 0x7d, 0x7d, 0x7f, 0x81,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x82, 0x81, 0x7e, 0x81, 0x83, 0x80,
			0x80, 0x7e, 0x81, 0x80, 0x7f, 0x80, 0x7f, 0x7b, 0x7c, 0x81, 0x82,
			0x7f, 0x7e, 0x7e, 0x7f, 0x7c, 0x7c, 0x7e, 0x7e, 0x81, 0x7d, 0x7e,
			0x7e, 0x81, 0x82, 0x7f, 0x7c, 0x80, 0x82, 0x80, 0x7f, 0x80, 0x80,
			0x83, 0x83, 0x81, 0x7f, 0x7e, 0x83, 0x82, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x83, 0x84, 0x82, 0x82, 0x81, 0x81, 0x80, 0x81, 0x81, 0x7f,
			0x7d, 0x7d, 0x82, 0x82, 0x7c, 0x7e, 0x7e, 0x7c, 0x7e, 0x7f, 0x7d,
			0x7c, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7b, 0x7d, 0x7f, 0x7e,
			0x80, 0x80, 0x80, 0x7d, 0x7d, 0x81, 0x80, 0x7f, 0x80, 0x82, 0x82,
			0x7f, 0x80, 0x83, 0x83, 0x80, 0x81, 0x82, 0x7e, 0x7f, 0x7e, 0x7d,
			0x7d, 0x7c, 0x7e, 0x7f, 0x7c, 0x7e, 0x80, 0x81, 0x81, 0x83, 0x84,
			0x83, 0x83, 0x82, 0x82, 0x80, 0x81, 0x82, 0x82, 0x80, 0x7b, 0x79,
			0x7a, 0x7b, 0x7d, 0x7e, 0x7e, 0x7c, 0x7b, 0x7f, 0x82, 0x7f, 0x7f,
			0x84, 0x87, 0x86, 0x87, 0x84, 0x84, 0x84, 0x80, 0x7d, 0x7a, 0x77,
			0x75, 0x74, 0x6f, 0x6c, 0x6e, 0x74, 0x76, 0x7c, 0x85, 0x8b, 0x8f,
			0x97, 0x9d, 0xa1, 0xa3, 0xa0, 0x9a, 0x8d, 0x80, 0x75, 0x6c, 0x68,
			0x61, 0x56, 0x53, 0x5c, 0x63, 0x68, 0x6f, 0x7b, 0x88, 0x91, 0x96,
			0xa3, 0xb3, 0xb6, 0xb5, 0xb1, 0xa9, 0x96, 0x7e, 0x6c, 0x5f, 0x58,
			0x54, 0x51, 0x51, 0x50, 0x54, 0x5f, 0x6a, 0x74, 0x7e, 0x89, 0x92,
			0x99, 0x9d, 0xa3, 0xaa, 0xa9, 0xa6, 0xa1, 0x9b, 0x98, 0x93, 0x90,
			0x8c, 0x88, 0x82, 0x78, 0x6c, 0x5f, 0x58, 0x52, 0x4c, 0x4e, 0x52,
			0x57, 0x5d, 0x67, 0x75, 0x81, 0x8b, 0x94, 0x9b, 0xa3, 0xa7, 0xaa,
			0xad, 0xac, 0xa6, 0xa3, 0x9d, 0x98, 0x93, 0x8c, 0x87, 0x7f, 0x75,
			0x6a, 0x5e, 0x53, 0x4b, 0x45, 0x4b, 0x50, 0x59, 0x5d, 0x69, 0x77,
			0x82, 0x8f, 0x96, 0xa0, 0xa5, 0xa9, 0xac, 0xac, 0xab, 0xa6, 0xa0,
			0x9b, 0x95, 0x90, 0x89, 0x81, 0x78, 0x6c, 0x61, 0x55, 0x4f, 0x45,
			0x41, 0x47, 0x50, 0x5e, 0x63, 0x71, 0x7e, 0x8d, 0x95, 0x9e, 0xa8,
			0xad, 0xaf, 0xad, 0xaf, 0xab, 0xa5, 0x9e, 0x9a, 0x92, 0x89, 0x7f,
			0x77, 0x69, 0x60, 0x56, 0x4e, 0x44, 0x3a, 0x45, 0x4d, 0x5d, 0x60,
			0x71, 0x82, 0x8f, 0x98, 0x9e, 0xa9, 0xad, 0xae, 0xaf, 0xaf, 0xab,
			0xa6, 0x9f, 0x9b, 0x91, 0x88, 0x7c, 0x76, 0x66, 0x5d, 0x53, 0x4d,
			0x41, 0x39, 0x42, 0x4e, 0x5e, 0x61, 0x73, 0x85, 0x95, 0x9a, 0xa0,
			0xad, 0xb2, 0xb2, 0xaf, 0xb1, 0xad, 0xa4, 0x9e, 0x96, 0x8c, 0x7f,
			0x78, 0x6d, 0x5f, 0x53, 0x4c, 0x45, 0x38, 0x3c, 0x4a, 0x5f, 0x61,
			0x6c, 0x80, 0x93, 0x9b, 0x9d, 0xab, 0xb3, 0xb4, 0xb0, 0xb1, 0xb0,
			0xa7, 0x9e, 0x97, 0x8b, 0x7f, 0x77, 0x6e, 0x62, 0x55, 0x50, 0x4b,
			0x3b, 0x3a, 0x49, 0x5c, 0x63, 0x69, 0x80, 0x92, 0x9b, 0x9c, 0xa8,
			0xb3, 0xb7, 0xb2, 0xb1, 0xaf, 0xa8, 0xa1, 0x93, 0x87, 0x7d, 0x75,
			0x6b, 0x5f, 0x55, 0x52, 0x47, 0x38, 0x3c, 0x50, 0x60, 0x63, 0x6c,
			0x83, 0x96, 0x9a, 0x9d, 0xa9, 0xb4, 0xb6, 0xb1, 0xae, 0xad, 0xa8,
			0x9d, 0x8d, 0x81, 0x7c, 0x73, 0x64, 0x59, 0x56, 0x53, 0x44, 0x36,
			0x43, 0x5a, 0x63, 0x64, 0x73, 0x8e, 0x9c, 0x9b, 0x9e, 0xb0, 0xb9,
			0xb4, 0xad, 0xad, 0xae, 0xa2, 0x92, 0x85, 0x7e, 0x75, 0x67, 0x5d,
			0x5c, 0x59, 0x4b, 0x39, 0x3c, 0x55, 0x5f, 0x61, 0x6b, 0x86, 0x97,
			0x96, 0x9a, 0xab, 0xb9, 0xb5, 0xac, 0xaf, 0xaf, 0xa5, 0x96, 0x8c,
			0x88, 0x7b, 0x6c, 0x64, 0x62, 0x5e, 0x53, 0x47, 0x3c, 0x48, 0x57,
			0x5e, 0x65, 0x74, 0x8a, 0x93, 0x97, 0x9e, 0xae, 0xb6, 0xb2, 0xb0,
			0xb0, 0xac, 0x9d, 0x94, 0x8b, 0x82, 0x75, 0x6b, 0x68, 0x65, 0x5c,
			0x55, 0x4c, 0x3f, 0x4a, 0x58, 0x62, 0x65, 0x72, 0x86, 0x91, 0x95,
			0x9b, 0xac, 0xb2, 0xb0, 0xad, 0xaf, 0xa9, 0x9b, 0x92, 0x8b, 0x80,
			0x73, 0x6e, 0x6b, 0x68, 0x5e, 0x59, 0x4f, 0x43, 0x4d, 0x5b, 0x62,
			0x64, 0x72, 0x85, 0x90, 0x92, 0x9c, 0xad, 0xb3, 0xb1, 0xad, 0xb0,
			0xaa, 0x9e, 0x93, 0x8c, 0x83, 0x74, 0x72, 0x6e, 0x6b, 0x64, 0x5f,
			0x54, 0x42, 0x48, 0x58, 0x5f, 0x5d, 0x68, 0x7f, 0x8b, 0x8e, 0x97,
			0xa9, 0xb4, 0xb1, 0xae, 0xaf, 0xae, 0xa2, 0x98, 0x90, 0x86, 0x7c,
			0x74, 0x74, 0x6f, 0x6c, 0x6a, 0x63, 0x4f, 0x3d, 0x4a, 0x59, 0x58,
			0x56, 0x68, 0x80, 0x86, 0x8b, 0x97, 0xb1, 0xb7, 0xb2, 0xb2, 0xb2,
			0xae, 0xa1, 0x98, 0x8d, 0x83, 0x7c, 0x78, 0x74, 0x6f, 0x70, 0x6f,
			0x62, 0x4d, 0x42, 0x50, 0x56, 0x51, 0x53, 0x66, 0x7e, 0x82, 0x88,
			0x9d, 0xb3, 0xb9, 0xb6, 0xb7, 0xb8, 0xb2, 0xa4, 0x98, 0x8f, 0x86,
			0x7f, 0x77, 0x72, 0x73, 0x75, 0x72, 0x6a, 0x5e, 0x54, 0x47, 0x49,
			0x50, 0x53, 0x59, 0x62, 0x77, 0x82, 0x8f, 0x9c, 0xaf, 0xba, 0xba,
			0xb8, 0xb6, 0xb0, 0xa4, 0x97, 0x8c, 0x83, 0x7e, 0x79, 0x73, 0x76,
			0x77, 0x75, 0x70, 0x6a, 0x5d, 0x4f, 0x46, 0x50, 0x56, 0x58, 0x59,
			0x6b, 0x83, 0x8a, 0x95, 0xa6, 0xbb, 0xbd, 0xb8, 0xb4, 0xb4, 0xac,
			0x98, 0x8b, 0x86, 0x83, 0x77, 0x71, 0x76, 0x7b, 0x75, 0x71, 0x70,
			0x71, 0x64, 0x51, 0x4a, 0x52, 0x58, 0x57, 0x5c, 0x6d, 0x84, 0x8a,
			0x95, 0xa3, 0xb8, 0xba, 0xb3, 0xb5, 0xb4, 0xa8, 0x92, 0x8b, 0x87,
			0x81, 0x75, 0x75, 0x79, 0x7a, 0x77, 0x77, 0x7b, 0x78, 0x6c, 0x60,
			0x57, 0x50, 0x4e, 0x57, 0x5a, 0x63, 0x6a, 0x7c, 0x8c, 0x99, 0xa9,
			0xb4, 0xbd, 0xba, 0xb8, 0xb1, 0xaa, 0x99, 0x8d, 0x83, 0x81, 0x7e,
			0x77, 0x76, 0x79, 0x81, 0x7e, 0x7e, 0x7e, 0x7d, 0x72, 0x61, 0x54,
			0x4b, 0x4b, 0x50, 0x50, 0x5a, 0x66, 0x79, 0x89, 0x96, 0xa7, 0xb4,
			0xbd, 0xbc, 0xb9, 0xb2, 0xa8, 0x9c, 0x92, 0x86, 0x81, 0x7d, 0x7d,
			0x7a, 0x7d, 0x83, 0x84, 0x84, 0x81, 0x82, 0x7c, 0x6f, 0x62, 0x54,
			0x4b, 0x40, 0x40, 0x4d, 0x56, 0x62, 0x6f, 0x86, 0x97, 0xa5, 0xb0,
			0xbb, 0xc1, 0xbd, 0xb6, 0xac, 0xa3, 0x96, 0x89, 0x81, 0x7c, 0x7e,
			0x7d, 0x7f, 0x82, 0x89, 0x8a, 0x87, 0x86, 0x82, 0x7c, 0x6b, 0x60,
			0x51, 0x4a, 0x3b, 0x37, 0x3a, 0x4e, 0x5a, 0x65, 0x78, 0x8e, 0xa7,
			0xac, 0xb8, 0xc0, 0xc9, 0xc0, 0xb3, 0xab, 0xa3, 0x97, 0x87, 0x81,
			0x7e, 0x7c, 0x77, 0x7b, 0x86, 0x8b, 0x8a, 0x88, 0x8a, 0x86, 0x7a,
			0x70, 0x6a, 0x64, 0x57, 0x4c, 0x48, 0x47, 0x42, 0x40, 0x49, 0x63,
			0x71, 0x80, 0x8c, 0xa4, 0xb6, 0xb8, 0xc1, 0xc6, 0xcf, 0xbf, 0xb1,
			0xa8, 0xa0, 0x90, 0x79, 0x71, 0x6a, 0x63, 0x59, 0x5b, 0x64, 0x69,
			0x6d, 0x74, 0x83, 0x8b, 0x8e, 0x8f, 0x93, 0x96, 0x91, 0x8e, 0x89,
			0x88, 0x80, 0x79, 0x76, 0x72, 0x6d, 0x66, 0x67, 0x64, 0x5f, 0x57,
			0x58, 0x54, 0x50, 0x4f, 0x5f, 0x72, 0x77, 0x80, 0x8f, 0xa6, 0xaa,
			0xaf, 0xb9, 0xc3, 0xc0, 0xb2, 0xac, 0xa7, 0x9c, 0x86, 0x7a, 0x75,
			0x6f, 0x65, 0x5f, 0x65, 0x6a, 0x6d, 0x6e, 0x79, 0x82, 0x85, 0x87,
			0x8a, 0x90, 0x8c, 0x86, 0x80, 0x7f, 0x7a, 0x73, 0x72, 0x75, 0x77,
			0x71, 0x73, 0x78, 0x7e, 0x7a, 0x79, 0x7d, 0x7c, 0x74, 0x69, 0x68,
			0x61, 0x56, 0x4f, 0x58, 0x68, 0x6e, 0x70, 0x7e, 0x94, 0xa1, 0xa5,
			0xae, 0xbd, 0xc2, 0xba, 0xb2, 0xae, 0xa6, 0x94, 0x84, 0x7c, 0x74,
			0x69, 0x5e, 0x60, 0x65, 0x68, 0x6a, 0x72, 0x7d, 0x81, 0x82, 0x86,
			0x8c, 0x8e, 0x87, 0x84, 0x83, 0x7f, 0x76, 0x6e, 0x6d, 0x6e, 0x6d,
			0x68, 0x6c, 0x74, 0x7f, 0x81, 0x84, 0x8c, 0x94, 0x95, 0x8e, 0x90,
			0x8f, 0x89, 0x79, 0x71, 0x6b, 0x63, 0x58, 0x4f, 0x4f, 0x4c, 0x52,
			0x5a, 0x6d, 0x7b, 0x89, 0x99, 0xa7, 0xb7, 0xba, 0xc0, 0xbf, 0xbe,
			0xb5, 0xa6, 0x9b, 0x8c, 0x7f, 0x6e, 0x66, 0x61, 0x5e, 0x5d, 0x5f,
			0x69, 0x6f, 0x78, 0x7e, 0x88, 0x8e, 0x8f, 0x8f, 0x8d, 0x8c, 0x84,
			0x7f, 0x78, 0x73, 0x6e, 0x67, 0x67, 0x67, 0x6b, 0x6c, 0x71, 0x79,
			0x7f, 0x84, 0x88, 0x8d, 0x90, 0x91, 0x8e, 0x8d, 0x89, 0x89, 0x86,
			0x81, 0x7f, 0x7b, 0x7d, 0x79, 0x7a, 0x79, 0x7a, 0x79, 0x76, 0x74,
			0x71, 0x71, 0x6c, 0x68, 0x62, 0x68, 0x71, 0x77, 0x7e, 0x85, 0x95,
			0x9d, 0xa1, 0xa6, 0xac, 0xb0, 0xa8, 0xa1, 0x99, 0x94, 0x88, 0x7c,
			0x73, 0x6e, 0x6b, 0x65, 0x66, 0x6a, 0x70, 0x73, 0x77, 0x80, 0x86,
			0x88, 0x87, 0x89, 0x89, 0x84, 0x7f, 0x7b, 0x79, 0x72, 0x6e, 0x6c,
			0x6e, 0x6f, 0x6f, 0x72, 0x77, 0x7d, 0x7f, 0x83, 0x88, 0x8b, 0x8b,
			0x8a, 0x8b, 0x8a, 0x86, 0x81, 0x7f, 0x7c, 0x7a, 0x77, 0x76, 0x78,
			0x78, 0x7b, 0x7c, 0x80, 0x83, 0x85, 0x87, 0x8a, 0x8c, 0x8b, 0x89,
			0x88, 0x87, 0x84, 0x81, 0x7e, 0x7e, 0x7c, 0x7b, 0x7b, 0x7c, 0x7c,
			0x7d, 0x7d, 0x80, 0x81, 0x82, 0x82, 0x82, 0x84, 0x82, 0x81, 0x7f,
			0x7f, 0x7e, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7f, 0x80,
			0x89, 0x8f, 0x8d, 0x88, 0x85, 0x85, 0x7b, 0x73, 0x6d, 0x6d, 0x65,
			0x5d, 0x5c, 0x66, 0x6f, 0x71, 0x7b, 0x86, 0x96, 0x99, 0x9d, 0xa2,
			0xa6, 0xa4, 0x98, 0x93, 0x8e, 0x86, 0x78, 0x70, 0x6f, 0x6e, 0x6c,
			0x6a, 0x71, 0x79, 0x7d, 0x80, 0x86, 0x8e, 0x8e, 0x8c, 0x8a, 0x8a,
			0x86, 0x7e, 0x79, 0x76, 0x74, 0x6f, 0x6d, 0x6f, 0x73, 0x75, 0x76,
			0x7c, 0x82, 0x86, 0x87, 0x89, 0x8c, 0x8c, 0x89, 0x86, 0x85, 0x82,
			0x7e, 0x79, 0x78, 0x78, 0x77, 0x76, 0x77, 0x7b, 0x7e, 0x7f, 0x82,
			0x85, 0x88, 0x87, 0x87, 0x87, 0x87, 0x84, 0x81, 0x7f, 0x7e, 0x7d,
			0x7a, 0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x80, 0x82, 0x83, 0x83, 0x84,
			0x84, 0x83, 0x82, 0x80, 0x80, 0x7e, 0x7d, 0x7c, 0x7c, 0x7c, 0x7b,
			0x7c, 0x7d, 0x7f, 0x7f, 0x80, 0x81, 0x82, 0x83, 0x82, 0x82, 0x82,
			0x81, 0x80, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7f, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f,
		},
		{ // 5
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83,
			0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x80, 0x7f, 0x7e, 0x7c, 0x7b,
			0x7a, 0x78, 0x78, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78, 0x78, 0x79,
			0x7b, 0x7c, 0x7d, 0x7f, 0x80, 0x81, 0x83, 0x83, 0x84, 0x85, 0x85,
			0x86, 0x86, 0x87, 0x88, 0x88, 0x89, 0x8a, 0x8a, 0x8a, 0x8a, 0x89,
			0x87, 0x84, 0x81, 0x7d, 0x79, 0x75, 0x71, 0x6f, 0x6f, 0x6f, 0x6f,
			0x6f, 0x70, 0x70, 0x71, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7d, 0x7f,
			0x81, 0x83, 0x84, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x8c, 0x8d, 0x8f,
			0x90, 0x90, 0x91, 0x90, 0x8f, 0x8e, 0x8c, 0x89, 0x86, 0x83, 0x7f,
			0x7c, 0x78, 0x75, 0x72, 0x6f, 0x6e, 0x6d, 0x6e, 0x6e, 0x6f, 0x6f,
			0x6f, 0x6f, 0x6f, 0x6f, 0x70, 0x72, 0x74, 0x76, 0x79, 0x7b, 0x7e,
			0x81, 0x83, 0x86, 0x88, 0x8a, 0x8d, 0x8f, 0x91, 0x93, 0x94, 0x95,
			0x95, 0x94, 0x93, 0x91, 0x8f, 0x8c, 0x88, 0x85, 0x81, 0x7e, 0x7b,
			0x78, 0x75, 0x73, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x71,
			0x70, 0x6f, 0x6f, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x75, 0x77, 0x7a,
			0x7c, 0x7f, 0x82, 0x84, 0x87, 0x8a, 0x8d, 0x90, 0x92, 0x95, 0x96,
			0x97, 0x97, 0x97, 0x95, 0x93, 0x90, 0x8c, 0x89, 0x85, 0x80, 0x7d,
			0x79, 0x76, 0x74, 0x73, 0x72, 0x73, 0x73, 0x73, 0x72, 0x71, 0x70,
			0x6f, 0x6e, 0x6e, 0x6e, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x74, 0x76,
			0x79, 0x7c, 0x7e, 0x81, 0x85, 0x88, 0x8b, 0x8f, 0x92, 0x95, 0x98,
			0x99, 0x9a, 0x9a, 0x99, 0x97, 0x94, 0x90, 0x8c, 0x87, 0x83, 0x7e,
			0x7a, 0x77, 0x75, 0x74, 0x73, 0x74, 0x74, 0x74, 0x73, 0x71, 0x70,
			0x6f, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6e, 0x6f, 0x70, 0x71, 0x73,
			0x75, 0x78, 0x7a, 0x7d, 0x80, 0x84, 0x87, 0x8b, 0x8e, 0x92, 0x96,
			0x99, 0x9b, 0x9c, 0x9d, 0x9c, 0x9a, 0x97, 0x93, 0x8e, 0x89, 0x84,
			0x7f, 0x7a, 0x77, 0x75, 0x75, 0x75, 0x75, 0x75, 0x74, 0x72, 0x70,
			0x6f, 0x6e, 0x6e, 0x6e, 0x6e, 0x6d, 0x6d, 0x6d, 0x6d, 0x6e, 0x70,
			0x71, 0x73, 0x75, 0x78, 0x7b, 0x7e, 0x81, 0x84, 0x88, 0x8c, 0x90,
			0x94, 0x98, 0x9b, 0x9d, 0x9f, 0x9f, 0x9d, 0x9b, 0x97, 0x93, 0x8d,
			0x87, 0x81, 0x7c, 0x78, 0x76, 0x76, 0x76, 0x76, 0x75, 0x74, 0x72,
			0x70, 0x6f, 0x6f, 0x6f, 0x6e, 0x6e, 0x6d, 0x6c, 0x6c, 0x6c, 0x6c,
			0x6d, 0x6e, 0x70, 0x73, 0x75, 0x78, 0x7b, 0x7e, 0x81, 0x84, 0x88,
			0x8c, 0x90, 0x95, 0x99, 0x9c, 0x9f, 0xa0, 0xa1, 0x9f, 0x9d, 0x98,
			0x93, 0x8c, 0x86, 0x80, 0x7b, 0x78, 0x78, 0x77, 0x77, 0x76, 0x74,
			0x73, 0x71, 0x70, 0x70, 0x70, 0x6f, 0x6e, 0x6d, 0x6c, 0x6b, 0x6b,
			0x6b, 0x6b, 0x6c, 0x6d, 0x6f, 0x71, 0x74, 0x77, 0x7a, 0x7d, 0x80,
			0x84, 0x87, 0x8b, 0x8f, 0x94, 0x98, 0x9d, 0xa0, 0xa2, 0xa4, 0xa3,
			0xa0, 0x9c, 0x96, 0x8f, 0x88, 0x81, 0x7d, 0x7a, 0x79, 0x78, 0x78,
			0x76, 0x74, 0x72, 0x71, 0x70, 0x70, 0x6f, 0x6e, 0x6d, 0x6c, 0x6b,
			0x6a, 0x69, 0x69, 0x69, 0x69, 0x6b, 0x6d, 0x6f, 0x72, 0x76, 0x79,
			0x7c, 0x7f, 0x82, 0x85, 0x89, 0x8d, 0x92, 0x97, 0x9c, 0xa1, 0xa5,
			0xa7, 0xa7, 0xa5, 0xa0, 0x9a, 0x93, 0x8c, 0x84, 0x7f, 0x7b, 0x7a,
			0x7a, 0x78, 0x76, 0x73, 0x71, 0x70, 0x70, 0x70, 0x70, 0x6f, 0x6e,
			0x6c, 0x6b, 0x69, 0x68, 0x67, 0x67, 0x67, 0x68, 0x6a, 0x6d, 0x70,
			0x74, 0x78, 0x7a, 0x7e, 0x80, 0x83, 0x87, 0x8c, 0x90, 0x96, 0x9d,
			0xa3, 0xa7, 0xaa, 0xaa, 0xa8, 0xa3, 0x9d, 0x95, 0x8d, 0x85, 0x7e,
			0x7b, 0x7a, 0x79, 0x78, 0x76, 0x73, 0x71, 0x70, 0x71, 0x71, 0x71,
			0x71, 0x70, 0x6e, 0x6c, 0x6a, 0x67, 0x66, 0x66, 0x66, 0x67, 0x69,
			0x6b, 0x6f, 0x72, 0x75, 0x78, 0x7b, 0x7e, 0x81, 0x84, 0x89, 0x8f,
			0x95, 0x9c, 0xa3, 0xa9, 0xac, 0xad, 0xac, 0xa7, 0xa0, 0x98, 0x8f,
			0x86, 0x7f, 0x7b, 0x79, 0x78, 0x77, 0x75, 0x72, 0x70, 0x70, 0x70,
			0x72, 0x73, 0x74, 0x73, 0x71, 0x6e, 0x6a, 0x67, 0x65, 0x64, 0x65,
			0x66, 0x68, 0x6b, 0x6e, 0x71, 0x75, 0x78, 0x7a, 0x7d, 0x7f, 0x82,
			0x86, 0x8c, 0x93, 0x9b, 0xa2, 0xa9, 0xad, 0xaf, 0xae, 0xa9, 0xa2,
			0x9a, 0x91, 0x88, 0x80, 0x7b, 0x78, 0x77, 0x76, 0x74, 0x72, 0x70,
			0x6f, 0x71, 0x73, 0x76, 0x78, 0x77, 0x75, 0x70, 0x6c, 0x68, 0x65,
			0x64, 0x64, 0x64, 0x66, 0x68, 0x6b, 0x6e, 0x72, 0x75, 0x78, 0x7a,
			0x7d, 0x80, 0x85, 0x8a, 0x92, 0x9a, 0xa3, 0xaa, 0xaf, 0xb1, 0xb0,
			0xac, 0xa5, 0x9c, 0x92, 0x89, 0x81, 0x7b, 0x77, 0x75, 0x74, 0x73,
			0x71, 0x70, 0x6f, 0x71, 0x74, 0x78, 0x7a, 0x7b, 0x78, 0x73, 0x6d,
			0x68, 0x65, 0x64, 0x63, 0x64, 0x65, 0x68, 0x6b, 0x6e, 0x71, 0x73,
			0x76, 0x79, 0x7b, 0x7f, 0x83, 0x89, 0x90, 0x99, 0xa2, 0xaa, 0xb0,
			0xb3, 0xb2, 0xae, 0xa7, 0x9f, 0x95, 0x8c, 0x83, 0x7b, 0x76, 0x72,
			0x70, 0x6f, 0x6e, 0x6e, 0x6f, 0x72, 0x76, 0x7a, 0x7d, 0x7f, 0x7d,
			0x78, 0x71, 0x6b, 0x66, 0x64, 0x63, 0x63, 0x64, 0x66, 0x69, 0x6c,
			0x6f, 0x72, 0x75, 0x78, 0x7b, 0x7e, 0x82, 0x87, 0x8e, 0x97, 0xa0,
			0xa8, 0xae, 0xb2, 0xb2, 0xaf, 0xa9, 0xa2, 0x98, 0x8f, 0x85, 0x7d,
			0x76, 0x71, 0x6e, 0x6c, 0x6b, 0x6b, 0x6e, 0x71, 0x76, 0x7b, 0x80,
			0x82, 0x81, 0x7d, 0x76, 0x6d, 0x67, 0x63, 0x62, 0x63, 0x64, 0x65,
			0x67, 0x69, 0x6d, 0x70, 0x74, 0x78, 0x7c, 0x7f, 0x83, 0x88, 0x8e,
			0x95, 0x9d, 0xa5, 0xac, 0xb0, 0xb1, 0xb0, 0xab, 0xa3, 0x9a, 0x91,
			0x87, 0x7e, 0x76, 0x71, 0x6c, 0x6a, 0x69, 0x6a, 0x6d, 0x71, 0x77,
			0x7c, 0x81, 0x84, 0x84, 0x80, 0x79, 0x70, 0x68, 0x63, 0x61, 0x62,
			0x64, 0x66, 0x68, 0x6a, 0x6d, 0x70, 0x74, 0x78, 0x7c, 0x80, 0x84,
			0x88, 0x8e, 0x94, 0x9b, 0xa3, 0xa9, 0xae, 0xb0, 0xaf, 0xab, 0xa4,
			0x9c, 0x92, 0x88, 0x7f, 0x76, 0x70, 0x6b, 0x68, 0x68, 0x69, 0x6c,
			0x71, 0x77, 0x7e, 0x84, 0x87, 0x87, 0x83, 0x7c, 0x71, 0x68, 0x61,
			0x5f, 0x60, 0x63, 0x65, 0x66, 0x68, 0x6b, 0x6f, 0x73, 0x78, 0x7d,
			0x82, 0x86, 0x8b, 0x8f, 0x95, 0x9b, 0xa1, 0xa7, 0xac, 0xaf, 0xaf,
			0xac, 0xa6, 0x9e, 0x95, 0x8a, 0x80, 0x77, 0x70, 0x6b, 0x67, 0x66,
			0x67, 0x6b, 0x70, 0x76, 0x7d, 0x83, 0x88, 0x89, 0x86, 0x7f, 0x76,
			0x6b, 0x63, 0x5d, 0x5d, 0x60, 0x63, 0x66, 0x69, 0x6b, 0x6e, 0x72,
			0x77, 0x7c, 0x81, 0x86, 0x8a, 0x8e, 0x93, 0x98, 0x9e, 0xa3, 0xa8,
			0xac, 0xad, 0xac, 0xa8, 0xa2, 0x99, 0x90, 0x85, 0x7c, 0x73, 0x6d,
			0x69, 0x67, 0x67, 0x6a, 0x6e, 0x74, 0x7a, 0x81, 0x87, 0x8a, 0x89,
			0x85, 0x7c, 0x72, 0x67, 0x5f, 0x5a, 0x5b, 0x5e, 0x63, 0x68, 0x6c,
			0x70, 0x73, 0x77, 0x7a, 0x7e, 0x82, 0x86, 0x8b, 0x8f, 0x94, 0x9a,
			0x9f, 0xa4, 0xa7, 0xaa, 0xab, 0xa9, 0xa5, 0x9f, 0x97, 0x8e, 0x84,
			0x7b, 0x73, 0x6d, 0x69, 0x67, 0x68, 0x6b, 0x6f, 0x75, 0x7c, 0x82,
			0x87, 0x89, 0x88, 0x83, 0x7b, 0x71, 0x67, 0x60, 0x5c, 0x5c, 0x5f,
			0x63, 0x68, 0x6c, 0x70, 0x73, 0x77, 0x7c, 0x81, 0x86, 0x8a, 0x8d,
			0x91, 0x94, 0x98, 0x9c, 0xa0, 0xa3, 0xa6, 0xa7, 0xa6, 0xa2, 0x9d,
			0x95, 0x8c, 0x84, 0x7c, 0x74, 0x6e, 0x6b, 0x6a, 0x6b, 0x6e, 0x72,
			0x77, 0x7d, 0x83, 0x87, 0x88, 0x85, 0x7f, 0x77, 0x6e, 0x66, 0x60,
			0x5e, 0x60, 0x64, 0x68, 0x6c, 0x70, 0x72, 0x75, 0x78, 0x7c, 0x80,
			0x85, 0x89, 0x8d, 0x90, 0x93, 0x98, 0x9c, 0x9f, 0xa3, 0xa5, 0xa6,
			0xa5, 0xa1, 0x9b, 0x94, 0x8c, 0x83, 0x7a, 0x73, 0x6e, 0x6b, 0x6a,
			0x6c, 0x6f, 0x73, 0x78, 0x7d, 0x82, 0x85, 0x86, 0x84, 0x7e, 0x77,
			0x6f, 0x68, 0x63, 0x61, 0x62, 0x65, 0x69, 0x6c, 0x70, 0x73, 0x76,
			0x7a, 0x7e, 0x83, 0x86, 0x8a, 0x8d, 0x90, 0x94, 0x97, 0x9b, 0x9e,
			0xa1, 0xa3, 0xa3, 0xa1, 0x9d, 0x98, 0x91, 0x89, 0x81, 0x7a, 0x74,
			0x6f, 0x6d, 0x6c, 0x6d, 0x70, 0x74, 0x78, 0x7d, 0x81, 0x83, 0x84,
			0x82, 0x7f, 0x79, 0x72, 0x6b, 0x66, 0x63, 0x63, 0x66, 0x6a, 0x6e,
			0x72, 0x76, 0x79, 0x7c, 0x7e, 0x81, 0x84, 0x88, 0x8b, 0x8f, 0x92,
			0x96, 0x99, 0x9d, 0xa0, 0xa2, 0xa2, 0xa0, 0x9c, 0x97, 0x90, 0x89,
			0x82, 0x7b, 0x75, 0x71, 0x6f, 0x6e, 0x6f, 0x71, 0x74, 0x78, 0x7b,
			0x7f, 0x82, 0x83, 0x83, 0x80, 0x7c, 0x75, 0x6f, 0x69, 0x65, 0x64,
			0x65, 0x68, 0x6d, 0x71, 0x75, 0x79, 0x7c, 0x7e, 0x80, 0x83, 0x86,
			0x8a, 0x8e, 0x92, 0x96, 0x9a, 0x9d, 0xa0, 0xa1, 0xa0, 0x9e, 0x99,
			0x94, 0x8e, 0x87, 0x81, 0x7b, 0x76, 0x73, 0x71, 0x70, 0x71, 0x72,
			0x74, 0x77, 0x7a, 0x7d, 0x7f, 0x81, 0x82, 0x81, 0x7e, 0x79, 0x74,
			0x6e, 0x6a, 0x67, 0x67, 0x69, 0x6d, 0x71, 0x75, 0x78, 0x7b, 0x7d,
			0x7f, 0x81, 0x84, 0x88, 0x8c, 0x90, 0x95, 0x9a, 0x9d, 0xa0, 0xa0,
			0x9f, 0x9c, 0x98, 0x92, 0x8c, 0x86, 0x80, 0x7b, 0x77, 0x74, 0x73,
			0x72, 0x73, 0x74, 0x76, 0x78, 0x7a, 0x7c, 0x7e, 0x80, 0x80, 0x80,
			0x7e, 0x7b, 0x76, 0x72, 0x6d, 0x6a, 0x6a, 0x6b, 0x6e, 0x71, 0x75,
			0x78, 0x7b, 0x7d, 0x7f, 0x81, 0x84, 0x87, 0x8b, 0x8f, 0x94, 0x98,
			0x9c, 0x9e, 0x9f, 0x9e, 0x9a, 0x96, 0x90, 0x8a, 0x84, 0x7e, 0x7a,
			0x76, 0x75, 0x74, 0x74, 0x75, 0x76, 0x77, 0x79, 0x7a, 0x7c, 0x7d,
			0x7e, 0x7f, 0x7e, 0x7d, 0x7b, 0x77, 0x74, 0x70, 0x6e, 0x6d, 0x6e,
			0x70, 0x73, 0x76, 0x79, 0x7b, 0x7d, 0x7f, 0x80, 0x82, 0x85, 0x89,
			0x8e, 0x94, 0x98, 0x9d, 0x9f, 0x9f, 0x9d, 0x98, 0x93, 0x8c, 0x86,
			0x80, 0x7b, 0x78, 0x76, 0x75, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a,
			0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x78, 0x76, 0x73, 0x71,
			0x70, 0x70, 0x71, 0x73, 0x76, 0x79, 0x7c, 0x7e, 0x80, 0x82, 0x84,
			0x86, 0x89, 0x8c, 0x90, 0x94, 0x98, 0x9a, 0x9b, 0x9a, 0x97, 0x93,
			0x8d, 0x87, 0x82, 0x7d, 0x79, 0x77, 0x76, 0x76, 0x77, 0x78, 0x7a,
			0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x79, 0x77, 0x76, 0x74,
			0x73, 0x72, 0x72, 0x72, 0x74, 0x76, 0x78, 0x7b, 0x7d, 0x7f, 0x81,
			0x83, 0x85, 0x88, 0x8b, 0x8f, 0x92, 0x95, 0x97, 0x98, 0x98, 0x95,
			0x92, 0x8d, 0x88, 0x83, 0x7f, 0x7b, 0x79, 0x78, 0x77, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x78, 0x76, 0x75,
			0x73, 0x72, 0x72, 0x72, 0x73, 0x75, 0x77, 0x79, 0x7b, 0x7d, 0x7f,
			0x81, 0x84, 0x87, 0x8a, 0x8d, 0x90, 0x94, 0x96, 0x97, 0x97, 0x96,
			0x93, 0x90, 0x8b, 0x87, 0x82, 0x7f, 0x7c, 0x7a, 0x79, 0x79, 0x79,
			0x7a, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x78, 0x77, 0x75,
			0x73, 0x72, 0x72, 0x72, 0x73, 0x74, 0x75, 0x77, 0x79, 0x7b, 0x7d,
			0x80, 0x83, 0x86, 0x8a, 0x8d, 0x91, 0x94, 0x97, 0x98, 0x98, 0x97,
			0x94, 0x91, 0x8c, 0x88, 0x84, 0x80, 0x7d, 0x7b, 0x7a, 0x79, 0x7a,
			0x7a, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x78, 0x77, 0x75,
			0x73, 0x72, 0x71, 0x71, 0x72, 0x72, 0x74, 0x75, 0x77, 0x79, 0x7c,
			0x7f, 0x82, 0x86, 0x8a, 0x8f, 0x93, 0x96, 0x99, 0x9a, 0x9a, 0x99,
			0x96, 0x93, 0x8e, 0x89, 0x84, 0x81, 0x7d, 0x7b, 0x7a, 0x79, 0x79,
			0x7a, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7b, 0x7a, 0x78, 0x76, 0x74,
			0x72, 0x70, 0x70, 0x70, 0x70, 0x71, 0x72, 0x74, 0x75, 0x78, 0x7a,
			0x7d, 0x81, 0x85, 0x8b, 0x90, 0x95, 0x9a, 0x9d, 0x9f, 0x9f, 0x9d,
			0x99, 0x95, 0x8f, 0x89, 0x84, 0x7f, 0x7c, 0x79, 0x78, 0x78, 0x79,
			0x7a, 0x7b, 0x7c, 0x7c, 0x7d, 0x7c, 0x7b, 0x79, 0x77, 0x74, 0x72,
			0x6f, 0x6e, 0x6d, 0x6d, 0x6e, 0x6f, 0x71, 0x72, 0x74, 0x76, 0x78,
			0x7a, 0x7e, 0x82, 0x88, 0x8e, 0x95, 0x9b, 0xa0, 0xa3, 0xa3, 0xa2,
			0x9e, 0x9a, 0x94, 0x8d, 0x87, 0x81, 0x7c, 0x79, 0x77, 0x77, 0x78,
			0x79, 0x7a, 0x7c, 0x7d, 0x7e, 0x7d, 0x7c, 0x7b, 0x78, 0x75, 0x72,
			0x6f, 0x6c, 0x6b, 0x6b, 0x6c, 0x6d, 0x6f, 0x71, 0x73, 0x74, 0x75,
			0x77, 0x7a, 0x7f, 0x85, 0x8c, 0x94, 0x9c, 0xa2, 0xa7, 0xa9, 0xa7,
			0xa3, 0x9d, 0x97, 0x8f, 0x87, 0x81, 0x7c, 0x78, 0x76, 0x76, 0x77,
			0x78, 0x7a, 0x7c, 0x7e, 0x7f, 0x7f, 0x7e, 0x7c, 0x79, 0x75, 0x70,
			0x6c, 0x69, 0x67, 0x67, 0x68, 0x6b, 0x6e, 0x70, 0x71, 0x73, 0x74,
			0x76, 0x7a, 0x80, 0x88, 0x90, 0x9a, 0xa2, 0xa9, 0xad, 0xad, 0xaa,
			0xa4, 0x9c, 0x94, 0x8b, 0x83, 0x7c, 0x78, 0x75, 0x74, 0x75, 0x77,
			0x79, 0x7c, 0x7f, 0x80, 0x81, 0x80, 0x7e, 0x7a, 0x75, 0x6f, 0x6a,
			0x66, 0x63, 0x63, 0x65, 0x69, 0x6d, 0x71, 0x73, 0x74, 0x75, 0x76,
			0x78, 0x7d, 0x84, 0x8e, 0x99, 0xa3, 0xab, 0xb1, 0xb3, 0xb0, 0xaa,
			0xa1, 0x97, 0x8d, 0x84, 0x7c, 0x77, 0x74, 0x73, 0x74, 0x76, 0x79,
			0x7d, 0x80, 0x82, 0x83, 0x82, 0x7f, 0x7b, 0x75, 0x6e, 0x67, 0x62,
			0x5f, 0x5f, 0x62, 0x68, 0x6d, 0x71, 0x73, 0x74, 0x73, 0x74, 0x77,
			0x7c, 0x84, 0x8f, 0x9b, 0xa6, 0xaf, 0xb5, 0xb6, 0xb2, 0xab, 0xa1,
			0x96, 0x8b, 0x81, 0x7a, 0x75, 0x72, 0x72, 0x74, 0x77, 0x7b, 0x7f,
			0x83, 0x85, 0x86, 0x85, 0x81, 0x7b, 0x72, 0x68, 0x5f, 0x59, 0x56,
			0x58, 0x5e, 0x66, 0x6e, 0x72, 0x74, 0x73, 0x73, 0x74, 0x78, 0x80,
			0x8b, 0x98, 0xa5, 0xb1, 0xb8, 0xbc, 0xba, 0xb3, 0xa8, 0x9b, 0x8f,
			0x83, 0x7a, 0x74, 0x71, 0x70, 0x71, 0x74, 0x78, 0x7c, 0x81, 0x85,
			0x89, 0x8b, 0x88, 0x83, 0x79, 0x6d, 0x60, 0x56, 0x50, 0x4f, 0x55,
			0x5e, 0x69, 0x71, 0x74, 0x76, 0x75, 0x75, 0x76, 0x7c, 0x85, 0x93,
			0xa2, 0xb0, 0xba, 0xc0, 0xc0, 0xb9, 0xaf, 0xa1, 0x94, 0x86, 0x7c,
			0x75, 0x72, 0x70, 0x70, 0x72, 0x76, 0x7b, 0x80, 0x86, 0x8a, 0x8d,
			0x8b, 0x86, 0x7c, 0x6e, 0x60, 0x53, 0x4b, 0x4a, 0x50, 0x5b, 0x66,
			0x6f, 0x73, 0x76, 0x75, 0x75, 0x77, 0x7d, 0x86, 0x94, 0xa4, 0xb2,
			0xbd, 0xc2, 0xc2, 0xba, 0xaf, 0xa1, 0x93, 0x85, 0x7b, 0x74, 0x70,
			0x6f, 0x6f, 0x72, 0x75, 0x7a, 0x80, 0x87, 0x8c, 0x8f, 0x8e, 0x86,
			0x7a, 0x6a, 0x5b, 0x4d, 0x46, 0x46, 0x4f, 0x5b, 0x67, 0x70, 0x75,
			0x77, 0x76, 0x77, 0x7a, 0x82, 0x8d, 0x9c, 0xab, 0xb9, 0xc1, 0xc4,
			0xc1, 0xb7, 0xab, 0x9a, 0x8c, 0x7e, 0x76, 0x70, 0x6e, 0x6e, 0x6f,
			0x72, 0x76, 0x7c, 0x82, 0x8a, 0x8f, 0x91, 0x8e, 0x85, 0x75, 0x63,
			0x52, 0x47, 0x44, 0x4a, 0x54, 0x5e, 0x67, 0x6d, 0x72, 0x73, 0x75,
			0x79, 0x81, 0x8b, 0x9a, 0xa9, 0xb7, 0xc1, 0xc5, 0xc3, 0xba, 0xad,
			0x9d, 0x8e, 0x80, 0x76, 0x70, 0x6d, 0x6d, 0x6e, 0x70, 0x74, 0x79,
			0x82, 0x8b, 0x93, 0x97, 0x95, 0x8b, 0x7b, 0x67, 0x54, 0x47, 0x41,
			0x45, 0x4e, 0x59, 0x63, 0x6a, 0x6d, 0x6f, 0x72, 0x77, 0x80, 0x8d,
			0x9c, 0xac, 0xbb, 0xc4, 0xc7, 0xc3, 0xb8, 0xaa, 0x99, 0x89, 0x7d,
			0x74, 0x70, 0x6d, 0x6d, 0x6f, 0x72, 0x77, 0x7e, 0x87, 0x8f, 0x95,
			0x96, 0x91, 0x84, 0x72, 0x5e, 0x4c, 0x43, 0x43, 0x4a, 0x52, 0x5c,
			0x63, 0x69, 0x6c, 0x71, 0x77, 0x82, 0x90, 0x9f, 0xaf, 0xbb, 0xc4,
			0xc6, 0xc1, 0xb5, 0xa7, 0x96, 0x87, 0x7b, 0x74, 0x6f, 0x6e, 0x6e,
			0x70, 0x74, 0x79, 0x80, 0x88, 0x90, 0x94, 0x93, 0x8c, 0x7e, 0x6b,
			0x59, 0x4b, 0x43, 0x43, 0x49, 0x51, 0x5a, 0x61, 0x68, 0x70, 0x7a,
			0x86, 0x95, 0xa4, 0xb3, 0xbf, 0xc6, 0xc7, 0xc1, 0xb5, 0xa5, 0x93,
			0x83, 0x77, 0x6f, 0x6b, 0x6b, 0x6d, 0x70, 0x75, 0x7b, 0x82, 0x88,
			0x8e, 0x91, 0x90, 0x89, 0x7c, 0x6c, 0x5b, 0x4e, 0x46, 0x45, 0x4a,
			0x51, 0x59, 0x62, 0x6b, 0x76, 0x84, 0x93, 0xa2, 0xb0, 0xba, 0xc1,
			0xc2, 0xbd, 0xb3, 0xa5, 0x96, 0x87, 0x7a, 0x71, 0x6c, 0x6b, 0x6d,
			0x71, 0x75, 0x7b, 0x82, 0x87, 0x8c, 0x8d, 0x8b, 0x82, 0x77, 0x68,
			0x5a, 0x4f, 0x4a, 0x4a, 0x4d, 0x54, 0x5c, 0x67, 0x74, 0x83, 0x92,
			0xa2, 0xb0, 0xbb, 0xc0, 0xc0, 0xba, 0xb0, 0xa2, 0x93, 0x85, 0x79,
			0x70, 0x6b, 0x69, 0x6a, 0x6e, 0x73, 0x7a, 0x80, 0x86, 0x8a, 0x8b,
			0x89, 0x83, 0x78, 0x6b, 0x5e, 0x52, 0x4d, 0x4b, 0x4f, 0x56, 0x61,
			0x6d, 0x7d, 0x8e, 0x9f, 0xaf, 0xb9, 0xbf, 0xbe, 0xb9, 0xae, 0xa2,
			0x93, 0x86, 0x7a, 0x71, 0x6a, 0x67, 0x67, 0x69, 0x6e, 0x75, 0x7e,
			0x85, 0x8b, 0x8d, 0x8b, 0x84, 0x7a, 0x6d, 0x60, 0x54, 0x4d, 0x4a,
			0x4d, 0x57, 0x64, 0x76, 0x88, 0x9a, 0xa9, 0xb6, 0xbc, 0xbd, 0xb9,
			0xb0, 0xa4, 0x96, 0x89, 0x7d, 0x73, 0x6b, 0x66, 0x64, 0x65, 0x69,
			0x70, 0x79, 0x82, 0x8a, 0x8f, 0x8e, 0x89, 0x81, 0x75, 0x68, 0x5b,
			0x51, 0x4c, 0x4b, 0x51, 0x5c, 0x6e, 0x80, 0x93, 0xa5, 0xb2, 0xbb,
			0xbd, 0xbb, 0xb2, 0xa8, 0x9a, 0x8d, 0x7f, 0x72, 0x69, 0x61, 0x5e,
			0x5e, 0x64, 0x6b, 0x76, 0x82, 0x8c, 0x93, 0x95, 0x94, 0x8c, 0x83,
			0x76, 0x6a, 0x5f, 0x56, 0x50, 0x4d, 0x4e, 0x54, 0x5f, 0x6f, 0x81,
			0x96, 0xa9, 0xb9, 0xc2, 0xc5, 0xc0, 0xb6, 0xa7, 0x96, 0x87, 0x79,
			0x6e, 0x65, 0x60, 0x5d, 0x5c, 0x5f, 0x65, 0x6e, 0x7b, 0x8a, 0x98,
			0xa2, 0xa8, 0xa6, 0x9d, 0x8f, 0x7d, 0x6c, 0x5d, 0x53, 0x4d, 0x4c,
			0x4c, 0x4e, 0x50, 0x54, 0x5c, 0x69, 0x7d, 0x93, 0xab, 0xbe, 0xcc,
			0xcf, 0xca, 0xbb, 0xa8, 0x93, 0x7f, 0x71, 0x67, 0x62, 0x60, 0x60,
			0x61, 0x63, 0x67, 0x6d, 0x76, 0x82, 0x8f, 0x9a, 0xa2, 0xa4, 0xa0,
			0x96, 0x88, 0x79, 0x6c, 0x63, 0x5f, 0x5f, 0x63, 0x69, 0x70, 0x78,
			0x80, 0x87, 0x8e, 0x92, 0x95, 0x93, 0x90, 0x87, 0x7e, 0x72, 0x67,
			0x5b, 0x53, 0x4f, 0x52, 0x5d, 0x6c, 0x80, 0x92, 0xa4, 0xaf, 0xb6,
			0xb6, 0xb1, 0xaa, 0xa0, 0x97, 0x8c, 0x83, 0x78, 0x6f, 0x65, 0x5e,
			0x5a, 0x59, 0x5e, 0x66, 0x73, 0x7f, 0x8c, 0x95, 0x9b, 0x9b, 0x98,
			0x91, 0x89, 0x81, 0x79, 0x73, 0x6e, 0x6c, 0x69, 0x68, 0x68, 0x69,
			0x6c, 0x71, 0x78, 0x80, 0x89, 0x90, 0x95, 0x96, 0x95, 0x91, 0x8b,
			0x85, 0x7f, 0x7b, 0x77, 0x75, 0x73, 0x73, 0x73, 0x73, 0x75, 0x77,
			0x7b, 0x80, 0x85, 0x8a, 0x8e, 0x90, 0x90, 0x8d, 0x89, 0x84, 0x7f,
			0x7b, 0x78, 0x76, 0x75, 0x75, 0x76, 0x77, 0x78, 0x7a, 0x7d, 0x7f,
			0x82, 0x85, 0x88, 0x89, 0x89, 0x88, 0x85, 0x81, 0x7d, 0x7a, 0x78,
			0x77, 0x77, 0x78, 0x79, 0x7a, 0x7c, 0x7d, 0x7e, 0x80, 0x82, 0x83,
			0x85, 0x85, 0x85, 0x85, 0x83, 0x81, 0x7e, 0x7c, 0x7a, 0x79, 0x79,
			0x7a, 0x7b, 0x7d, 0x7e, 0x7f, 0x80, 0x81, 0x81, 0x82, 0x83, 0x83,
			0x83, 0x82, 0x84, 0x84, 0x87, 0x86, 0x84, 0x7e, 0x77, 0x6f, 0x68,
			0x65, 0x65, 0x6b, 0x73, 0x7e, 0x87, 0x8f, 0x92, 0x94, 0x92, 0x90,
			0x8e, 0x8b, 0x8a, 0x88, 0x85, 0x80, 0x7b, 0x73, 0x6e, 0x6a, 0x6a,
			0x6e, 0x74, 0x7c, 0x84, 0x8a, 0x8d, 0x8e, 0x8b, 0x88, 0x85, 0x82,
			0x80, 0x7d, 0x7c, 0x7a, 0x78, 0x75, 0x73, 0x72, 0x73, 0x76, 0x7a,
			0x80, 0x85, 0x89, 0x8a, 0x8a, 0x88, 0x85, 0x82, 0x7f, 0x7e, 0x7d,
			0x7d, 0x7c, 0x7c, 0x7b, 0x7a, 0x79, 0x79, 0x7a, 0x7d, 0x80, 0x83,
			0x85, 0x86, 0x86, 0x85, 0x83, 0x80, 0x7f, 0x7d, 0x7c, 0x7c, 0x7c,
			0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7e, 0x80, 0x82, 0x83, 0x84,
			0x84, 0x83, 0x81, 0x7f, 0x7d, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x80, 0x81, 0x82, 0x82, 0x82, 0x81,
			0x80, 0x7e, 0x7d, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f,
			0x7e, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
		},
		{ // 6
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x81, 0x82, 0x81, 0x82,
			0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7e, 0x7c, 0x7d, 0x7c, 0x7c,
			0x7c, 0x7c, 0x7e, 0x7d, 0x7f, 0x80, 0x81, 0x82, 0x83, 0x84, 0x84,
			0x85, 0x84, 0x85, 0x82, 0x82, 0x7f, 0x7e, 0x7c, 0x7a, 0x79, 0x77,
			0x77, 0x75, 0x77, 0x76, 0x7a, 0x7a, 0x7f, 0x81, 0x84, 0x87, 0x89,
			0x8b, 0x8c, 0x8c, 0x8c, 0x8b, 0x88, 0x86, 0x81, 0x7e, 0x79, 0x76,
			0x71, 0x71, 0x6b, 0x6d, 0x6d, 0x6e, 0x74, 0x74, 0x7f, 0x80, 0x87,
			0x8c, 0x90, 0x95, 0x96, 0x97, 0x96, 0x95, 0x8f, 0x8a, 0x81, 0x7d,
			0x76, 0x70, 0x6b, 0x65, 0x64, 0x63, 0x64, 0x69, 0x6d, 0x73, 0x7d,
			0x83, 0x8c, 0x91, 0x98, 0x9c, 0x9e, 0x9e, 0x9d, 0x97, 0x90, 0x87,
			0x80, 0x79, 0x71, 0x6a, 0x62, 0x61, 0x5a, 0x61, 0x60, 0x6b, 0x6e,
			0x78, 0x82, 0x88, 0x92, 0x96, 0x9f, 0x9f, 0xa2, 0x9e, 0x9e, 0x96,
			0x8f, 0x84, 0x7e, 0x73, 0x6d, 0x65, 0x61, 0x5d, 0x5b, 0x61, 0x62,
			0x6d, 0x6e, 0x7e, 0x83, 0x8c, 0x92, 0x99, 0x9f, 0x9f, 0xa0, 0x9e,
			0x9c, 0x92, 0x8c, 0x81, 0x7b, 0x70, 0x6c, 0x64, 0x62, 0x5b, 0x60,
			0x62, 0x68, 0x6d, 0x73, 0x82, 0x83, 0x8f, 0x90, 0x9b, 0x9d, 0x9e,
			0x9e, 0x9c, 0x98, 0x91, 0x88, 0x81, 0x78, 0x70, 0x6a, 0x65, 0x62,
			0x5e, 0x65, 0x62, 0x6d, 0x6d, 0x79, 0x82, 0x84, 0x90, 0x90, 0x9b,
			0x9b, 0x9c, 0x9d, 0x9a, 0x96, 0x8f, 0x84, 0x7f, 0x74, 0x71, 0x6b,
			0x66, 0x63, 0x62, 0x64, 0x67, 0x6d, 0x6e, 0x7e, 0x7e, 0x88, 0x8d,
			0x94, 0x9b, 0x99, 0x9d, 0x9c, 0x99, 0x93, 0x8a, 0x82, 0x7f, 0x75,
			0x73, 0x6a, 0x66, 0x61, 0x66, 0x66, 0x68, 0x6d, 0x70, 0x7c, 0x7b,
			0x87, 0x8b, 0x94, 0x97, 0x97, 0x9c, 0x9e, 0x9a, 0x96, 0x8e, 0x89,
			0x82, 0x78, 0x74, 0x69, 0x65, 0x5f, 0x62, 0x61, 0x66, 0x67, 0x70,
			0x78, 0x7b, 0x87, 0x8c, 0x95, 0x98, 0x9a, 0x9f, 0x9f, 0x9d, 0x98,
			0x90, 0x8a, 0x80, 0x7a, 0x71, 0x69, 0x62, 0x60, 0x60, 0x60, 0x66,
			0x67, 0x71, 0x79, 0x7e, 0x88, 0x8e, 0x96, 0x98, 0x9d, 0xa0, 0x9e,
			0x9d, 0x95, 0x8f, 0x88, 0x80, 0x75, 0x70, 0x66, 0x62, 0x5f, 0x60,
			0x63, 0x65, 0x6b, 0x72, 0x7b, 0x80, 0x8a, 0x8d, 0x98, 0x99, 0x9c,
			0x9e, 0x9c, 0x9a, 0x93, 0x8e, 0x87, 0x7e, 0x76, 0x6f, 0x65, 0x62,
			0x60, 0x61, 0x64, 0x67, 0x6c, 0x75, 0x79, 0x80, 0x8b, 0x8f, 0x98,
			0x98, 0x9d, 0x9f, 0x9b, 0x9b, 0x93, 0x8d, 0x85, 0x7d, 0x75, 0x6e,
			0x65, 0x64, 0x60, 0x5f, 0x63, 0x68, 0x6e, 0x77, 0x7c, 0x83, 0x8b,
			0x8e, 0x97, 0x98, 0x9b, 0x9d, 0x9b, 0x9a, 0x92, 0x8c, 0x88, 0x7d,
			0x75, 0x6e, 0x66, 0x64, 0x61, 0x60, 0x63, 0x66, 0x6b, 0x75, 0x78,
			0x81, 0x8a, 0x8f, 0x97, 0x97, 0x9d, 0x9f, 0x9d, 0x9a, 0x93, 0x8d,
			0x87, 0x7c, 0x76, 0x6e, 0x66, 0x65, 0x5f, 0x61, 0x61, 0x67, 0x6c,
			0x74, 0x79, 0x83, 0x89, 0x8e, 0x96, 0x96, 0x9e, 0x9c, 0x9d, 0x99,
			0x94, 0x8d, 0x86, 0x7e, 0x76, 0x6d, 0x67, 0x64, 0x60, 0x62, 0x62,
			0x69, 0x6c, 0x75, 0x79, 0x80, 0x87, 0x8c, 0x94, 0x94, 0x9a, 0x9d,
			0x9a, 0x9a, 0x97, 0x90, 0x8a, 0x81, 0x7b, 0x74, 0x69, 0x69, 0x63,
			0x5e, 0x5d, 0x61, 0x63, 0x6c, 0x79, 0x81, 0x8e, 0x94, 0x9f, 0xa1,
			0xa4, 0xa8, 0xa1, 0x9c, 0x8e, 0x84, 0x7a, 0x70, 0x66, 0x62, 0x5d,
			0x4d, 0x57, 0x5f, 0x5b, 0x67, 0x82, 0x88, 0x8e, 0x9e, 0xa8, 0xa1,
			0xa1, 0xa7, 0xa2, 0x92, 0x93, 0x8d, 0x7c, 0x79, 0x76, 0x6f, 0x64,
			0x5e, 0x58, 0x4d, 0x5c, 0x61, 0x61, 0x80, 0x86, 0x93, 0x9b, 0xa6,
			0xa4, 0xa0, 0xa3, 0xa2, 0x96, 0x92, 0x8f, 0x82, 0x7a, 0x77, 0x70,
			0x68, 0x5f, 0x58, 0x4f, 0x51, 0x68, 0x59, 0x7f, 0x84, 0x91, 0x9d,
			0xa1, 0xa9, 0x9d, 0xa1, 0x9b, 0x95, 0x8a, 0x8b, 0x83, 0x7b, 0x77,
			0x74, 0x69, 0x65, 0x59, 0x51, 0x51, 0x67, 0x59, 0x78, 0x89, 0x88,
			0x9f, 0x9f, 0xa8, 0x9b, 0xa3, 0x9b, 0x97, 0x91, 0x8c, 0x87, 0x7c,
			0x79, 0x73, 0x69, 0x67, 0x5b, 0x53, 0x4d, 0x63, 0x58, 0x6e, 0x8c,
			0x82, 0xa1, 0x9f, 0xa7, 0x9e, 0x9f, 0x9a, 0x94, 0x94, 0x88, 0x8a,
			0x7f, 0x7b, 0x75, 0x6b, 0x6b, 0x5b, 0x58, 0x4a, 0x62, 0x5b, 0x65,
			0x8d, 0x81, 0x9c, 0x9e, 0xa5, 0x9f, 0x9f, 0x9c, 0x94, 0x94, 0x8d,
			0x87, 0x83, 0x7b, 0x7a, 0x6e, 0x6e, 0x66, 0x59, 0x52, 0x54, 0x66,
			0x51, 0x82, 0x83, 0x89, 0xa4, 0xa0, 0xa5, 0x9f, 0xa5, 0x94, 0x94,
			0x93, 0x86, 0x86, 0x7e, 0x79, 0x75, 0x6c, 0x6c, 0x5c, 0x59, 0x4c,
			0x63, 0x5a, 0x65, 0x8d, 0x7c, 0x9a, 0xa0, 0x9f, 0x9f, 0xa2, 0x9d,
			0x90, 0x97, 0x8d, 0x84, 0x86, 0x79, 0x77, 0x6f, 0x6d, 0x65, 0x58,
			0x55, 0x4e, 0x68, 0x54, 0x7b, 0x8b, 0x82, 0xa3, 0x9d, 0xa2, 0x9d,
			0xa1, 0x98, 0x92, 0x92, 0x8b, 0x84, 0x84, 0x79, 0x7c, 0x6e, 0x6d,
			0x66, 0x56, 0x55, 0x4f, 0x67, 0x52, 0x7c, 0x83, 0x81, 0xa2, 0x9a,
			0xa3, 0xa0, 0xa2, 0x99, 0x99, 0x93, 0x8d, 0x88, 0x83, 0x7a, 0x7a,
			0x6e, 0x6a, 0x64, 0x56, 0x53, 0x54, 0x63, 0x56, 0x7d, 0x84, 0x84,
			0xa0, 0x9e, 0xa4, 0x9f, 0xa2, 0x9a, 0x96, 0x93, 0x8b, 0x89, 0x83,
			0x7b, 0x79, 0x6f, 0x68, 0x64, 0x59, 0x50, 0x52, 0x62, 0x59, 0x76,
			0x89, 0x86, 0x9e, 0x9e, 0xa2, 0xa2, 0xa0, 0x9a, 0x97, 0x92, 0x8e,
			0x8a, 0x83, 0x7f, 0x76, 0x76, 0x6d, 0x66, 0x5c, 0x5a, 0x4d, 0x5d,
			0x5e, 0x62, 0x89, 0x81, 0x95, 0x9f, 0x9f, 0xa0, 0xa1, 0x9b, 0x97,
			0x96, 0x8f, 0x8c, 0x84, 0x84, 0x78, 0x76, 0x74, 0x6b, 0x63, 0x5a,
			0x54, 0x4d, 0x66, 0x57, 0x74, 0x8a, 0x85, 0xa1, 0x9d, 0xa5, 0x9e,
			0xa1, 0x98, 0x98, 0x93, 0x8d, 0x88, 0x81, 0x81, 0x75, 0x76, 0x6e,
			0x6d, 0x5d, 0x5a, 0x4f, 0x50, 0x66, 0x55, 0x81, 0x86, 0x8b, 0xa3,
			0x9d, 0xa4, 0x9e, 0x9f, 0x9a, 0x98, 0x91, 0x8e, 0x86, 0x83, 0x7d,
			0x78, 0x77, 0x6e, 0x6c, 0x63, 0x5a, 0x53, 0x4d, 0x66, 0x5a, 0x79,
			0x8b, 0x85, 0xa0, 0x9d, 0x9f, 0x9e, 0xa0, 0x97, 0x98, 0x91, 0x90,
			0x88, 0x82, 0x83, 0x77, 0x78, 0x70, 0x6e, 0x65, 0x5c, 0x55, 0x49,
			0x64, 0x59, 0x6f, 0x8b, 0x84, 0x9e, 0x9b, 0xa3, 0xa0, 0x9e, 0x99,
			0x99, 0x95, 0x8b, 0x8f, 0x82, 0x81, 0x7b, 0x77, 0x73, 0x6e, 0x6e,
			0x60, 0x5e, 0x51, 0x4f, 0x67, 0x56, 0x7a, 0x8a, 0x89, 0xa2, 0xa1,
			0xa3, 0x9c, 0xa0, 0x96, 0x96, 0x91, 0x8e, 0x8a, 0x83, 0x82, 0x79,
			0x78, 0x6e, 0x6e, 0x68, 0x5f, 0x5d, 0x4c, 0x60, 0x5e, 0x61, 0x88,
			0x80, 0x96, 0x9f, 0xa0, 0xa1, 0x9f, 0x9e, 0x92, 0x96, 0x8c, 0x8b,
			0x85, 0x84, 0x81, 0x7a, 0x7a, 0x71, 0x6f, 0x67, 0x5f, 0x58, 0x4d,
			0x60, 0x5e, 0x5e, 0x89, 0x85, 0x93, 0xa4, 0xa0, 0xa2, 0x9f, 0x9e,
			0x94, 0x96, 0x8f, 0x89, 0x86, 0x80, 0x7f, 0x7b, 0x77, 0x75, 0x72,
			0x6c, 0x5f, 0x5e, 0x4c, 0x5b, 0x64, 0x57, 0x82, 0x86, 0x8c, 0xa0,
			0xa3, 0xa0, 0xa0, 0xa3, 0x91, 0x97, 0x90, 0x89, 0x8a, 0x81, 0x81,
			0x7d, 0x79, 0x72, 0x72, 0x6e, 0x64, 0x5c, 0x53, 0x51, 0x63, 0x58,
			0x73, 0x8c, 0x87, 0x9f, 0x9e, 0xa5, 0x9c, 0xa0, 0x97, 0x93, 0x95,
			0x8b, 0x8e, 0x84, 0x86, 0x7e, 0x7d, 0x75, 0x73, 0x72, 0x68, 0x64,
			0x59, 0x4e, 0x54, 0x62, 0x5b, 0x80, 0x8d, 0x8d, 0xa5, 0xa0, 0xa5,
			0x9e, 0x9e, 0x96, 0x92, 0x91, 0x89, 0x8a, 0x7f, 0x83, 0x7b, 0x78,
			0x76, 0x76, 0x72, 0x6a, 0x64, 0x58, 0x4b, 0x59, 0x60, 0x5e, 0x87,
			0x8a, 0x96, 0xa5, 0xa5, 0xa1, 0x9a, 0x9d, 0x91, 0x93, 0x8d, 0x88,
			0x85, 0x7e, 0x82, 0x78, 0x7d, 0x75, 0x78, 0x74, 0x6d, 0x66, 0x58,
			0x4d, 0x57, 0x63, 0x5c, 0x82, 0x8d, 0x92, 0xa6, 0xa7, 0xa3, 0x9c,
			0x9a, 0x92, 0x8d, 0x8a, 0x83, 0x8a, 0x7e, 0x82, 0x80, 0x7d, 0x7a,
			0x78, 0x79, 0x6f, 0x6b, 0x5c, 0x52, 0x4b, 0x68, 0x58, 0x70, 0x93,
			0x8b, 0xa2, 0xa2, 0xa6, 0x9a, 0x96, 0x96, 0x88, 0x8e, 0x86, 0x85,
			0x83, 0x81, 0x85, 0x7d, 0x80, 0x79, 0x7d, 0x72, 0x72, 0x64, 0x5b,
			0x4a, 0x51, 0x64, 0x54, 0x85, 0x92, 0x9c, 0xa7, 0xa8, 0xa8, 0x98,
			0x95, 0x8a, 0x88, 0x85, 0x83, 0x85, 0x81, 0x84, 0x80, 0x81, 0x7e,
			0x7c, 0x81, 0x74, 0x73, 0x60, 0x58, 0x45, 0x51, 0x64, 0x5c, 0x89,
			0x92, 0x9b, 0xa4, 0xa7, 0xa8, 0x94, 0x93, 0x86, 0x88, 0x81, 0x84,
			0x87, 0x84, 0x88, 0x82, 0x83, 0x7d, 0x7e, 0x80, 0x77, 0x72, 0x68,
			0x59, 0x4c, 0x45, 0x5c, 0x5b, 0x7c, 0x97, 0x9f, 0xaa, 0xa5, 0xa8,
			0x95, 0x90, 0x87, 0x7f, 0x83, 0x80, 0x81, 0x82, 0x88, 0x8a, 0x8a,
			0x89, 0x83, 0x81, 0x79, 0x76, 0x6b, 0x5c, 0x54, 0x42, 0x4b, 0x66,
			0x66, 0x8c, 0x9e, 0xa7, 0xa9, 0xa2, 0xa4, 0x8c, 0x8a, 0x7c, 0x7f,
			0x7a, 0x7f, 0x85, 0x85, 0x8b, 0x8b, 0x92, 0x8c, 0x85, 0x84, 0x78,
			0x72, 0x6b, 0x65, 0x56, 0x4d, 0x46, 0x58, 0x71, 0x78, 0x9d, 0xa4,
			0xab, 0xa6, 0x9d, 0x8f, 0x82, 0x82, 0x7b, 0x7d, 0x84, 0x83, 0x89,
			0x8e, 0x90, 0x95, 0x89, 0x85, 0x7d, 0x79, 0x71, 0x69, 0x64, 0x62,
			0x59, 0x50, 0x45, 0x61, 0x76, 0x81, 0x9f, 0xa5, 0xad, 0x99, 0x98,
			0x8e, 0x80, 0x7e, 0x7b, 0x81, 0x85, 0x8f, 0x8f, 0x96, 0x93, 0x90,
			0x8d, 0x83, 0x7c, 0x78, 0x71, 0x67, 0x66, 0x66, 0x5f, 0x59, 0x53,
			0x52, 0x6d, 0x7b, 0x92, 0x9c, 0xa4, 0xa5, 0x90, 0x91, 0x80, 0x80,
			0x7d, 0x80, 0x89, 0x8e, 0x94, 0x93, 0x98, 0x8e, 0x8c, 0x81, 0x78,
			0x74, 0x6e, 0x70, 0x6c, 0x6d, 0x6b, 0x6b, 0x62, 0x61, 0x50, 0x60,
			0x72, 0x80, 0x99, 0x9a, 0xa9, 0x9b, 0x95, 0x88, 0x84, 0x85, 0x7f,
			0x88, 0x8a, 0x93, 0x92, 0x94, 0x92, 0x89, 0x87, 0x79, 0x75, 0x70,
			0x6e, 0x70, 0x72, 0x71, 0x6e, 0x68, 0x61, 0x59, 0x4e, 0x62, 0x73,
			0x8e, 0x9a, 0xa3, 0xa8, 0x9b, 0x91, 0x84, 0x83, 0x80, 0x83, 0x88,
			0x89, 0x94, 0x93, 0x94, 0x90, 0x88, 0x82, 0x79, 0x76, 0x6f, 0x71,
			0x70, 0x75, 0x77, 0x71, 0x6d, 0x63, 0x60, 0x4f, 0x51, 0x62, 0x7d,
			0x9c, 0xa1, 0xa9, 0xa2, 0x9c, 0x89, 0x80, 0x7e, 0x80, 0x87, 0x87,
			0x91, 0x96, 0x97, 0x92, 0x8e, 0x86, 0x7e, 0x74, 0x73, 0x70, 0x71,
			0x74, 0x76, 0x7a, 0x75, 0x6b, 0x63, 0x5c, 0x50, 0x4f, 0x63, 0x87,
			0xa3, 0xa8, 0xa6, 0xa0, 0x96, 0x86, 0x76, 0x77, 0x80, 0x8d, 0x93,
			0x91, 0x97, 0x97, 0x92, 0x86, 0x7c, 0x77, 0x74, 0x73, 0x73, 0x73,
			0x78, 0x7d, 0x7a, 0x76, 0x69, 0x65, 0x5d, 0x55, 0x51, 0x60, 0x86,
			0xa3, 0xac, 0xa2, 0x9a, 0x92, 0x82, 0x74, 0x71, 0x85, 0x96, 0x9c,
			0x97, 0x8f, 0x96, 0x90, 0x86, 0x75, 0x73, 0x77, 0x7a, 0x7d, 0x75,
			0x7a, 0x7a, 0x7d, 0x70, 0x61, 0x5f, 0x59, 0x52, 0x4e, 0x68, 0x97,
			0xb6, 0xb5, 0x9c, 0x8d, 0x84, 0x7c, 0x6d, 0x6e, 0x8b, 0xa3, 0xa9,
			0x95, 0x8a, 0x89, 0x8a, 0x80, 0x71, 0x71, 0x7b, 0x80, 0x7c, 0x76,
			0x77, 0x7d, 0x7c, 0x72, 0x62, 0x60, 0x5a, 0x54, 0x4c, 0x65, 0x9b,
			0xbd, 0xb9, 0x96, 0x86, 0x80, 0x7c, 0x70, 0x6f, 0x87, 0xa6, 0xaf,
			0x9b, 0x86, 0x80, 0x87, 0x82, 0x76, 0x74, 0x7d, 0x87, 0x80, 0x75,
			0x71, 0x77, 0x7f, 0x77, 0x66, 0x5d, 0x5d, 0x5c, 0x54, 0x55, 0x7d,
			0xab, 0xc4, 0xac, 0x8a, 0x7b, 0x7a, 0x7a, 0x73, 0x7a, 0x91, 0xa9,
			0xa5, 0x92, 0x7e, 0x7d, 0x81, 0x7c, 0x74, 0x76, 0x80, 0x83, 0x7b,
			0x74, 0x77, 0x7f, 0x7d, 0x72, 0x60, 0x5a, 0x5c, 0x5c, 0x56, 0x60,
			0x8c, 0xb9, 0xc4, 0xa4, 0x82, 0x71, 0x78, 0x7d, 0x7d, 0x86, 0x95,
			0xa8, 0xa1, 0x8e, 0x7e, 0x76, 0x79, 0x74, 0x7a, 0x83, 0x8b, 0x85,
			0x76, 0x71, 0x78, 0x80, 0x7a, 0x71, 0x66, 0x63, 0x5f, 0x5a, 0x59,
			0x60, 0x85, 0xae, 0xc1, 0xab, 0x86, 0x70, 0x6f, 0x7a, 0x82, 0x8c,
			0x90, 0x99, 0x98, 0x94, 0x85, 0x7d, 0x76, 0x79, 0x7c, 0x85, 0x8a,
			0x88, 0x7f, 0x74, 0x75, 0x76, 0x79, 0x71, 0x6f, 0x66, 0x67, 0x62,
			0x62, 0x5e, 0x61, 0x81, 0xa7, 0xbd, 0xab, 0x87, 0x71, 0x6f, 0x7a,
			0x87, 0x8e, 0x93, 0x96, 0x96, 0x90, 0x89, 0x7f, 0x7e, 0x7c, 0x82,
			0x87, 0x87, 0x87, 0x7f, 0x7d, 0x77, 0x77, 0x73, 0x72, 0x6c, 0x6a,
			0x66, 0x6a, 0x65, 0x62, 0x57, 0x70, 0x9a, 0xbd, 0xbc, 0x93, 0x76,
			0x62, 0x77, 0x81, 0x95, 0x8d, 0x94, 0x91, 0x95, 0x8d, 0x82, 0x7c,
			0x7d, 0x88, 0x85, 0x85, 0x7b, 0x83, 0x80, 0x81, 0x78, 0x73, 0x6e,
			0x70, 0x71, 0x70, 0x69, 0x68, 0x62, 0x61, 0x55, 0x74, 0x97, 0xc1,
			0xbe, 0x98, 0x77, 0x61, 0x74, 0x80, 0x92, 0x8d, 0x94, 0x8f, 0x98,
			0x90, 0x88, 0x7b, 0x77, 0x7b, 0x88, 0x8b, 0x88, 0x7c, 0x75, 0x7a,
			0x7f, 0x83, 0x78, 0x71, 0x6e, 0x79, 0x75, 0x70, 0x65, 0x60, 0x5d,
			0x58, 0x6f, 0x9c, 0xc2, 0xc4, 0x9d, 0x76, 0x60, 0x6b, 0x7d, 0x92,
			0x90, 0x8f, 0x8e, 0x91, 0x93, 0x88, 0x7d, 0x75, 0x7a, 0x80, 0x88,
			0x81, 0x7d, 0x77, 0x7e, 0x87, 0x88, 0x7e, 0x72, 0x6b, 0x6e, 0x75,
			0x7c, 0x7a, 0x6f, 0x64, 0x5e, 0x60, 0x62, 0x82, 0xa2, 0xc3, 0xb9,
			0x98, 0x73, 0x5e, 0x68, 0x7c, 0x91, 0x91, 0x93, 0x8e, 0x95, 0x90,
			0x8b, 0x7b, 0x75, 0x73, 0x7f, 0x84, 0x85, 0x82, 0x7b, 0x7e, 0x7a,
			0x82, 0x7f, 0x7f, 0x77, 0x76, 0x6f, 0x76, 0x74, 0x76, 0x6c, 0x68,
			0x62, 0x61, 0x60, 0x75, 0x9d, 0xbd, 0xc3, 0xa1, 0x7a, 0x59, 0x5f,
			0x74, 0x96, 0x9b, 0x9e, 0x93, 0x92, 0x8e, 0x88, 0x7c, 0x6f, 0x69,
			0x72, 0x83, 0x8d, 0x90, 0x86, 0x81, 0x7b, 0x7f, 0x7b, 0x7a, 0x71,
			0x78, 0x82, 0x90, 0x8f, 0x81, 0x70, 0x6b, 0x72, 0x80, 0x85, 0x7c,
			0x73, 0x6c, 0x72, 0x72, 0x6f, 0x67, 0x63, 0x61, 0x63, 0x76, 0x96,
			0xb6, 0xbe, 0xa8, 0x85, 0x65, 0x60, 0x71, 0x8a, 0x9b, 0x9a, 0x99,
			0x92, 0x90, 0x87, 0x7d, 0x71, 0x6b, 0x71, 0x7f, 0x8c, 0x91, 0x8a,
			0x80, 0x77, 0x76, 0x78, 0x76, 0x77, 0x77, 0x7d, 0x83, 0x8d, 0x90,
			0x8c, 0x7d, 0x74, 0x70, 0x75, 0x7b, 0x80, 0x7e, 0x78, 0x74, 0x73,
			0x70, 0x6a, 0x68, 0x67, 0x69, 0x65, 0x6e, 0x7d, 0xa1, 0xb8, 0xbe,
			0x9f, 0x77, 0x5b, 0x5d, 0x78, 0x94, 0xa5, 0xa0, 0x97, 0x8c, 0x8c,
			0x86, 0x80, 0x70, 0x6d, 0x6f, 0x81, 0x90, 0x94, 0x8d, 0x7e, 0x77,
			0x75, 0x7c, 0x79, 0x78, 0x72, 0x76, 0x7e, 0x8b, 0x90, 0x8c, 0x7f,
			0x77, 0x74, 0x77, 0x79, 0x79, 0x77, 0x76, 0x79, 0x7a, 0x78, 0x6d,
			0x67, 0x62, 0x69, 0x6a, 0x68, 0x64, 0x77, 0x9c, 0xbe, 0xc6, 0xa7,
			0x7e, 0x5b, 0x5d, 0x75, 0x96, 0xa6, 0xa3, 0x95, 0x8a, 0x86, 0x87,
			0x84, 0x7b, 0x71, 0x6e, 0x77, 0x85, 0x92, 0x93, 0x8d, 0x7d, 0x74,
			0x6f, 0x74, 0x78, 0x7d, 0x7a, 0x79, 0x76, 0x77, 0x76, 0x72, 0x6d,
			0x68, 0x6b, 0x69, 0x69, 0x63, 0x79, 0x98, 0xbf, 0xc6, 0xb1, 0x84,
			0x60, 0x5a, 0x6f, 0x92, 0xa5, 0xa8, 0x99, 0x8b, 0x83, 0x85, 0x85,
			0x80, 0x75, 0x71, 0x75, 0x83, 0x8f, 0x93, 0x8a, 0x7d, 0x72, 0x6e,
			0x73, 0x7a, 0x7e, 0x7b, 0x76, 0x72, 0x72, 0x71, 0x73, 0x70, 0x71,
			0x6d, 0x6b, 0x63, 0x67, 0x80, 0xa4, 0xc4, 0xc1, 0xa6, 0x78, 0x5e,
			0x5e, 0x7a, 0x99, 0xa7, 0xa2, 0x91, 0x86, 0x82, 0x86, 0x85, 0x80,
			0x75, 0x72, 0x77, 0x85, 0x8f, 0x91, 0x86, 0x79, 0x70, 0x6f, 0x77,
			0x7e, 0x81, 0x7b, 0x76, 0x71, 0x71, 0x71, 0x74, 0x72, 0x73, 0x6e,
			0x69, 0x63, 0x6f, 0x8d, 0xb1, 0xc3, 0xb5, 0x95, 0x6d, 0x60, 0x66,
			0x86, 0x9c, 0xa7, 0x9b, 0x8d, 0x82, 0x81, 0x84, 0x83, 0x7e, 0x76,
			0x76, 0x7c, 0x89, 0x8d, 0x8a, 0x7c, 0x74, 0x6f, 0x75, 0x7a, 0x80,
			0x7c, 0x77, 0x71, 0x71, 0x70, 0x72, 0x72, 0x73, 0x72, 0x6d, 0x67,
			0x67, 0x7e, 0x9e, 0xc0, 0xc0, 0xac, 0x82, 0x68, 0x62, 0x77, 0x91,
			0xa2, 0xa0, 0x92, 0x86, 0x80, 0x85, 0x85, 0x83, 0x7a, 0x77, 0x77,
			0x82, 0x88, 0x8c, 0x85, 0x7c, 0x73, 0x72, 0x74, 0x79, 0x7b, 0x7b,
			0x78, 0x76, 0x74, 0x74, 0x74, 0x73, 0x72, 0x71, 0x72, 0x6d, 0x6c,
			0x71, 0x87, 0xa2, 0xba, 0xba, 0xa7, 0x86, 0x6f, 0x6b, 0x7a, 0x8f,
			0x9d, 0x9d, 0x92, 0x88, 0x82, 0x84, 0x84, 0x83, 0x7e, 0x7d, 0x7f,
			0x83, 0x84, 0x7f, 0x78, 0x71, 0x72, 0x77, 0x7f, 0x7f, 0x7b, 0x72,
			0x6d, 0x6d, 0x71, 0x75, 0x76, 0x77, 0x72, 0x6d, 0x68, 0x71, 0x88,
			0xa8, 0xbd, 0xb9, 0xa1, 0x80, 0x6d, 0x6c, 0x80, 0x94, 0xa0, 0x9a,
			0x8f, 0x84, 0x81, 0x84, 0x85, 0x84, 0x7f, 0x7e, 0x7f, 0x83, 0x82,
			0x7e, 0x76, 0x72, 0x73, 0x7a, 0x80, 0x81, 0x7b, 0x73, 0x6c, 0x6d,
			0x72, 0x77, 0x78, 0x76, 0x73, 0x6f, 0x6e, 0x70, 0x7f, 0x97, 0xb0,
			0xb8, 0xae, 0x94, 0x7c, 0x6f, 0x75, 0x86, 0x96, 0x9d, 0x98, 0x8d,
			0x83, 0x80, 0x81, 0x83, 0x81, 0x7f, 0x7d, 0x7f, 0x81, 0x81, 0x7d,
			0x77, 0x73, 0x74, 0x7a, 0x80, 0x80, 0x7a, 0x71, 0x6b, 0x6c, 0x72,
			0x79, 0x7c, 0x7a, 0x76, 0x6e, 0x6a, 0x6d, 0x7e, 0x97, 0xae, 0xb7,
			0xad, 0x96, 0x7d, 0x71, 0x76, 0x87, 0x97, 0x9d, 0x97, 0x8c, 0x82,
			0x7e, 0x80, 0x82, 0x82, 0x7d, 0x7a, 0x7c, 0x82, 0x87, 0x87, 0x80,
			0x76, 0x6f, 0x6f, 0x77, 0x7f, 0x83, 0x80, 0x76, 0x6d, 0x6a, 0x6e,
			0x75, 0x7b, 0x7b, 0x79, 0x73, 0x6f, 0x6d, 0x72, 0x80, 0x94, 0xa9,
			0xb1, 0xac, 0x99, 0x85, 0x77, 0x78, 0x83, 0x91, 0x98, 0x97, 0x8e,
			0x85, 0x80, 0x7f, 0x81, 0x81, 0x7f, 0x7b, 0x7b, 0x7d, 0x82, 0x84,
			0x84, 0x7e, 0x77, 0x71, 0x72, 0x77, 0x7d, 0x7f, 0x7d, 0x76, 0x70,
			0x6f, 0x70, 0x75, 0x77, 0x79, 0x77, 0x76, 0x72, 0x71, 0x72, 0x7d,
			0x8d, 0xa0, 0xac, 0xac, 0x9f, 0x8d, 0x7e, 0x78, 0x7e, 0x88, 0x93,
			0x95, 0x92, 0x88, 0x82, 0x7f, 0x80, 0x81, 0x81, 0x7e, 0x7b, 0x7a,
			0x7a, 0x7f, 0x83, 0x86, 0x83, 0x7d, 0x75, 0x72, 0x71, 0x77, 0x7c,
			0x7f, 0x7d, 0x79, 0x74, 0x71, 0x72, 0x76, 0x79, 0x79, 0x77, 0x75,
			0x74, 0x75, 0x78, 0x7b, 0x84, 0x8e, 0x9c, 0xa3, 0xa4, 0x99, 0x8c,
			0x7f, 0x7b, 0x7e, 0x88, 0x90, 0x92, 0x8f, 0x87, 0x82, 0x7d, 0x7e,
			0x7e, 0x81, 0x7f, 0x7e, 0x7a, 0x7a, 0x7b, 0x7f, 0x82, 0x83, 0x81,
			0x7c, 0x78, 0x74, 0x76, 0x78, 0x7d, 0x7f, 0x7f, 0x7d, 0x7a, 0x78,
			0x79, 0x7a, 0x7c, 0x7c, 0x7a, 0x77, 0x76, 0x77, 0x7a, 0x7d, 0x7e,
			0x7f, 0x7f, 0x7e, 0x7f, 0x83, 0x8b, 0x93, 0x9b, 0x9b, 0x97, 0x8d,
			0x84, 0x7f, 0x7f, 0x83, 0x88, 0x8a, 0x88, 0x85, 0x80, 0x7e, 0x7d,
			0x7e, 0x7d, 0x7d, 0x7c, 0x7b, 0x7b, 0x7b, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7a, 0x7a, 0x7a, 0x7b, 0x7c, 0x7c,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x83,
			0x83, 0x83, 0x84, 0x85, 0x88, 0x8c, 0x8f, 0x90, 0x8e, 0x89, 0x85,
			0x82, 0x80, 0x81, 0x83, 0x84, 0x83, 0x82, 0x7f, 0x7e, 0x7c, 0x7b,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x79, 0x78, 0x76, 0x75, 0x75, 0x76,
			0x78, 0x79, 0x7a, 0x79, 0x78, 0x79, 0x7e, 0x86, 0x90, 0x97, 0x99,
			0x93, 0x8a, 0x82, 0x7f, 0x81, 0x87, 0x8c, 0x8e, 0x8b, 0x85, 0x81,
			0x7f, 0x80, 0x82, 0x84, 0x81, 0x7e, 0x7a, 0x78, 0x79, 0x7c, 0x7f,
			0x80, 0x7e, 0x7a, 0x77, 0x76, 0x77, 0x7a, 0x7d, 0x7e, 0x7d, 0x7b,
			0x7a, 0x7a, 0x7c, 0x7e, 0x7f, 0x80, 0x7f, 0x7e, 0x7d, 0x7d, 0x7e,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x80,
			0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x81, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e,
			0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x81, 0x82, 0x82,
			0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x81, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7c, 0x7c, 0x7b, 0x7b, 0x7c,
			0x7e, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7e, 0x7f, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x80, 0x81, 0x81, 0x82, 0x82, 0x83, 0x82, 0x81,
			0x81, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7c,
			0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x81, 0x82, 0x83, 0x83, 0x83,
			0x82, 0x82, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x82, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7e,
			0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 0x7d, 0x7d,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
		},
		{ // 7
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
			0x81, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7e, 0x80, 0x7e, 0x82, 0x7d,
			0x85, 0x80, 0x7e, 0x82, 0x7f, 0x82, 0x80, 0x81, 0x82, 0x82, 0x7e,
			0x81, 0x7e, 0x80, 0x80, 0x7e, 0x7c, 0x7f, 0x7f, 0x7d, 0x82, 0x7d,
			0x81, 0x7e, 0x80, 0x7e, 0x7e, 0x7e, 0x7d, 0x81, 0x7d, 0x84, 0x7d,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x81, 0x7d, 0x82, 0x7d, 0x81, 0x7e,
			0x7f, 0x80, 0x7f, 0x80, 0x82, 0x81, 0x82, 0x81, 0x84, 0x7e, 0x7f,
			0x82, 0x7f, 0x80, 0x7f, 0x81, 0x7c, 0x81, 0x7d, 0x81, 0x7f, 0x7e,
			0x83, 0x81, 0x7e, 0x81, 0x7b, 0x80, 0x7f, 0x81, 0x83, 0x80, 0x7f,
			0x7c, 0x83, 0x7b, 0x82, 0x7d, 0x80, 0x7c, 0x81, 0x7f, 0x7f, 0x7e,
			0x7f, 0x7f, 0x80, 0x82, 0x7d, 0x7f, 0x7f, 0x7d, 0x7c, 0x81, 0x7a,
			0x81, 0x7e, 0x81, 0x7e, 0x80, 0x80, 0x80, 0x81, 0x81, 0x80, 0x80,
			0x7b, 0x82, 0x7f, 0x7f, 0x83, 0x7e, 0x7f, 0x7f, 0x81, 0x7f, 0x80,
			0x84, 0x80, 0x79, 0x82, 0x7c, 0x7d, 0x80, 0x83, 0x7a, 0x7e, 0x7f,
			0x7d, 0x81, 0x80, 0x7e, 0x7f, 0x7e, 0x7e, 0x82, 0x81, 0x81, 0x7f,
			0x81, 0x81, 0x80, 0x80, 0x84, 0x7c, 0x84, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x83, 0x83, 0x80, 0x81, 0x81, 0x7e, 0x80, 0x80, 0x79, 0x80,
			0x7c, 0x7f, 0x81, 0x81, 0x7b, 0x7d, 0x7f, 0x7d, 0x80, 0x82, 0x80,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7b, 0x82, 0x7f, 0x7b, 0x83, 0x7a, 0x7f,
			0x7f, 0x81, 0x7c, 0x83, 0x80, 0x80, 0x81, 0x85, 0x7f, 0x7d, 0x84,
			0x7f, 0x7f, 0x80, 0x86, 0x79, 0x85, 0x7d, 0x83, 0x7e, 0x82, 0x80,
			0x86, 0x81, 0x83, 0x81, 0x80, 0x7e, 0x82, 0x82, 0x7c, 0x84, 0x7e,
			0x83, 0x7f, 0x87, 0x7d, 0x83, 0x82, 0x83, 0x7f, 0x86, 0x7e, 0x82,
			0x7f, 0x84, 0x7e, 0x82, 0x80, 0x83, 0x84, 0x80, 0x84, 0x7e, 0x82,
			0x7e, 0x85, 0x7c, 0x85, 0x7b, 0x7f, 0x80, 0x80, 0x7d, 0x84, 0x7e,
			0x80, 0x7f, 0x80, 0x7e, 0x7c, 0x82, 0x7a, 0x82, 0x7a, 0x80, 0x7b,
			0x7d, 0x7d, 0x7a, 0x84, 0x79, 0x7f, 0x7f, 0x7c, 0x7b, 0x82, 0x82,
			0x7e, 0x85, 0x7d, 0x7f, 0x7f, 0x86, 0x7d, 0x86, 0x83, 0x7d, 0x7f,
			0x85, 0x7a, 0x82, 0x83, 0x78, 0x83, 0x7f, 0x7c, 0x7f, 0x80, 0x77,
			0x81, 0x7e, 0x7c, 0x7c, 0x7f, 0x75, 0x7f, 0x78, 0x7b, 0x7c, 0x79,
			0x7b, 0x77, 0x81, 0x79, 0x81, 0x82, 0x7c, 0x7e, 0x81, 0x79, 0x86,
			0x79, 0x82, 0x7b, 0x7b, 0x7c, 0x79, 0x84, 0x77, 0x85, 0x7e, 0x7e,
			0x83, 0x80, 0x81, 0x83, 0x80, 0x83, 0x80, 0x7f, 0x81, 0x7b, 0x82,
			0x7d, 0x81, 0x80, 0x7e, 0x82, 0x7a, 0x82, 0x7f, 0x80, 0x82, 0x7d,
			0x82, 0x7a, 0x7e, 0x82, 0x79, 0x85, 0x7b, 0x7b, 0x81, 0x76, 0x86,
			0x7a, 0x82, 0x7e, 0x7e, 0x7f, 0x7e, 0x84, 0x7e, 0x87, 0x7d, 0x85,
			0x7e, 0x81, 0x84, 0x7c, 0x82, 0x7f, 0x7b, 0x80, 0x7d, 0x7e, 0x7c,
			0x81, 0x7f, 0x7f, 0x84, 0x7b, 0x85, 0x78, 0x87, 0x7e, 0x82, 0x83,
			0x7b, 0x82, 0x79, 0x82, 0x7f, 0x80, 0x7f, 0x82, 0x7a, 0x83, 0x81,
			0x81, 0x86, 0x7e, 0x84, 0x7c, 0x82, 0x7e, 0x81, 0x7e, 0x7e, 0x81,
			0x79, 0x84, 0x7b, 0x7f, 0x7c, 0x80, 0x7f, 0x7f, 0x84, 0x79, 0x85,
			0x79, 0x80, 0x85, 0x79, 0x83, 0x7e, 0x78, 0x80, 0x82, 0x7d, 0x7e,
			0x84, 0x79, 0x7c, 0x83, 0x7c, 0x7c, 0x7e, 0x80, 0x75, 0x87, 0x7d,
			0x81, 0x7e, 0x84, 0x7b, 0x81, 0x84, 0x7a, 0x86, 0x79, 0x87, 0x7a,
			0x87, 0x7f, 0x80, 0x7e, 0x84, 0x7d, 0x83, 0x82, 0x7b, 0x84, 0x7a,
			0x83, 0x80, 0x80, 0x7d, 0x7f, 0x7a, 0x7e, 0x7d, 0x80, 0x7f, 0x82,
			0x80, 0x7f, 0x81, 0x7f, 0x7b, 0x81, 0x7d, 0x7f, 0x82, 0x7e, 0x81,
			0x7f, 0x82, 0x82, 0x81, 0x7f, 0x80, 0x78, 0x7c, 0x7d, 0x77, 0x81,
			0x7c, 0x7e, 0x7f, 0x81, 0x7f, 0x80, 0x85, 0x7e, 0x8a, 0x80, 0x87,
			0x83, 0x7a, 0x85, 0x7a, 0x80, 0x83, 0x7b, 0x7f, 0x7c, 0x80, 0x80,
			0x85, 0x84, 0x84, 0x84, 0x7f, 0x81, 0x7c, 0x7c, 0x7b, 0x80, 0x7c,
			0x7f, 0x88, 0x70, 0x88, 0x7b, 0x7b, 0x8a, 0x80, 0x81, 0x7e, 0x86,
			0x71, 0x8b, 0x7f, 0x7b, 0x85, 0x7d, 0x72, 0x86, 0x74, 0x7d, 0x7e,
			0x82, 0x7b, 0x83, 0x83, 0x73, 0x89, 0x75, 0x89, 0x7c, 0x8c, 0x80,
			0x80, 0x83, 0x81, 0x7f, 0x86, 0x81, 0x7d, 0x7b, 0x80, 0x7a, 0x7d,
			0x86, 0x80, 0x7e, 0x8a, 0x7e, 0x7d, 0x83, 0x7a, 0x80, 0x7c, 0x8b,
			0x76, 0x85, 0x7f, 0x7b, 0x7f, 0x87, 0x7e, 0x82, 0x82, 0x7b, 0x7e,
			0x81, 0x7c, 0x85, 0x7b, 0x7f, 0x81, 0x77, 0x7e, 0x81, 0x77, 0x80,
			0x85, 0x7b, 0x84, 0x7e, 0x7f, 0x77, 0x84, 0x7c, 0x7d, 0x83, 0x7e,
			0x7d, 0x83, 0x86, 0x84, 0x83, 0x8e, 0x78, 0x86, 0x82, 0x7a, 0x7e,
			0x82, 0x74, 0x83, 0x7c, 0x79, 0x85, 0x75, 0x87, 0x79, 0x88, 0x81,
			0x81, 0x83, 0x80, 0x7d, 0x88, 0x7c, 0x86, 0x7f, 0x7f, 0x83, 0x7d,
			0x88, 0x7a, 0x85, 0x7b, 0x80, 0x7c, 0x7f, 0x7c, 0x7d, 0x7e, 0x7b,
			0x84, 0x7a, 0x82, 0x7f, 0x77, 0x80, 0x7e, 0x73, 0x84, 0x78, 0x7a,
			0x87, 0x7e, 0x87, 0x82, 0x88, 0x7e, 0x87, 0x83, 0x7f, 0x87, 0x7b,
			0x86, 0x7b, 0x82, 0x85, 0x7a, 0x85, 0x80, 0x79, 0x82, 0x7e, 0x76,
			0x86, 0x78, 0x81, 0x81, 0x80, 0x80, 0x81, 0x81, 0x7c, 0x88, 0x7a,
			0x87, 0x7b, 0x82, 0x7d, 0x81, 0x81, 0x7f, 0x80, 0x7c, 0x80, 0x78,
			0x81, 0x79, 0x7f, 0x7b, 0x84, 0x76, 0x87, 0x7d, 0x7b, 0x85, 0x7d,
			0x82, 0x7f, 0x88, 0x75, 0x87, 0x80, 0x7a, 0x87, 0x81, 0x7c, 0x85,
			0x7f, 0x7e, 0x84, 0x7e, 0x85, 0x7f, 0x83, 0x82, 0x81, 0x7e, 0x84,
			0x7c, 0x7e, 0x83, 0x79, 0x81, 0x79, 0x83, 0x79, 0x84, 0x7e, 0x85,
			0x79, 0x8b, 0x78, 0x7f, 0x87, 0x71, 0x8b, 0x73, 0x84, 0x7a, 0x80,
			0x7b, 0x85, 0x77, 0x82, 0x81, 0x76, 0x81, 0x80, 0x76, 0x85, 0x81,
			0x7a, 0x8d, 0x7d, 0x88, 0x86, 0x81, 0x87, 0x82, 0x7d, 0x83, 0x80,
			0x76, 0x88, 0x7d, 0x75, 0x90, 0x76, 0x7f, 0x86, 0x7e, 0x75, 0x8d,
			0x71, 0x82, 0x7f, 0x7c, 0x7e, 0x84, 0x7c, 0x83, 0x84, 0x79, 0x8a,
			0x75, 0x85, 0x79, 0x84, 0x75, 0x8b, 0x73, 0x8a, 0x79, 0x88, 0x7b,
			0x84, 0x80, 0x78, 0x87, 0x6f, 0x8a, 0x6e, 0x88, 0x76, 0x84, 0x7a,
			0x89, 0x7a, 0x88, 0x80, 0x81, 0x84, 0x81, 0x83, 0x81, 0x85, 0x7d,
			0x8c, 0x77, 0x8e, 0x77, 0x8b, 0x76, 0x8d, 0x71, 0x88, 0x79, 0x7c,
			0x7e, 0x7c, 0x7d, 0x77, 0x88, 0x6f, 0x8b, 0x75, 0x86, 0x79, 0x8a,
			0x75, 0x8d, 0x77, 0x88, 0x7a, 0x84, 0x7a, 0x82, 0x7a, 0x80, 0x7e,
			0x7a, 0x89, 0x73, 0x8c, 0x79, 0x85, 0x7d, 0x88, 0x76, 0x8a, 0x78,
			0x84, 0x77, 0x8c, 0x6f, 0x8f, 0x77, 0x82, 0x82, 0x80, 0x82, 0x7e,
			0x88, 0x77, 0x8e, 0x76, 0x8b, 0x7a, 0x88, 0x78, 0x88, 0x77, 0x84,
			0x7b, 0x7f, 0x7b, 0x82, 0x78, 0x82, 0x7e, 0x7e, 0x82, 0x7f, 0x80,
			0x81, 0x7e, 0x80, 0x7e, 0x7e, 0x81, 0x78, 0x85, 0x76, 0x86, 0x76,
			0x85, 0x78, 0x83, 0x7b, 0x80, 0x7e, 0x81, 0x7e, 0x82, 0x82, 0x7e,
			0x89, 0x7d, 0x84, 0x86, 0x7d, 0x86, 0x82, 0x81, 0x81, 0x82, 0x82,
			0x7e, 0x83, 0x80, 0x7c, 0x83, 0x7e, 0x7d, 0x82, 0x7d, 0x7d, 0x81,
			0x7d, 0x7b, 0x81, 0x78, 0x81, 0x76, 0x83, 0x73, 0x86, 0x75, 0x82,
			0x7d, 0x7e, 0x80, 0x7f, 0x7f, 0x81, 0x80, 0x7e, 0x84, 0x7b, 0x85,
			0x7c, 0x84, 0x7b, 0x87, 0x7b, 0x89, 0x7f, 0x89, 0x80, 0x8c, 0x81,
			0x85, 0x88, 0x7d, 0x86, 0x7e, 0x7c, 0x7c, 0x7a, 0x74, 0x79, 0x72,
			0x73, 0x71, 0x71, 0x6f, 0x75, 0x71, 0x79, 0x79, 0x7c, 0x84, 0x83,
			0x8d, 0x91, 0x95, 0x9c, 0x9f, 0xa0, 0xa3, 0xa2, 0x9c, 0x9c, 0x92,
			0x8b, 0x83, 0x77, 0x6f, 0x66, 0x5b, 0x5a, 0x50, 0x4d, 0x4f, 0x4b,
			0x50, 0x58, 0x59, 0x68, 0x72, 0x79, 0x8b, 0x92, 0x9b, 0xa9, 0xac,
			0xb5, 0xb8, 0xba, 0xbb, 0xb7, 0xb3, 0xad, 0xa3, 0x9a, 0x91, 0x81,
			0x7a, 0x6c, 0x62, 0x58, 0x55, 0x45, 0x4c, 0x3f, 0x41, 0x45, 0x41,
			0x4e, 0x52, 0x5f, 0x6c, 0x78, 0x88, 0x92, 0x9f, 0xaa, 0xb3, 0xb6,
			0xc1, 0xbc, 0xbe, 0xbb, 0xb2, 0xb0, 0xa2, 0x9d, 0x8e, 0x87, 0x79,
			0x73, 0x65, 0x63, 0x54, 0x55, 0x49, 0x47, 0x40, 0x43, 0x3d, 0x47,
			0x4f, 0x4f, 0x6a, 0x68, 0x82, 0x89, 0x9c, 0xa4, 0xb5, 0xb6, 0xc3,
			0xc4, 0xc4, 0xc3, 0xbe, 0xb6, 0xad, 0xa5, 0x96, 0x8e, 0x7f, 0x77,
			0x69, 0x63, 0x57, 0x53, 0x47, 0x44, 0x3c, 0x3b, 0x39, 0x3e, 0x47,
			0x4c, 0x5f, 0x67, 0x79, 0x86, 0x96, 0xa3, 0xb0, 0xb9, 0xc2, 0xc5,
			0xc7, 0xc6, 0xc1, 0xbb, 0xb0, 0xa9, 0x9a, 0x90, 0x83, 0x78, 0x6b,
			0x64, 0x5a, 0x54, 0x4a, 0x44, 0x3d, 0x3a, 0x38, 0x3e, 0x44, 0x4c,
			0x5b, 0x66, 0x73, 0x84, 0x91, 0xa0, 0xae, 0xb6, 0xc2, 0xc4, 0xca,
			0xc5, 0xc6, 0xba, 0xb5, 0xa7, 0x9e, 0x90, 0x85, 0x7a, 0x6e, 0x67,
			0x5c, 0x56, 0x4c, 0x46, 0x3c, 0x3e, 0x34, 0x40, 0x42, 0x48, 0x59,
			0x61, 0x6f, 0x83, 0x8c, 0x9f, 0xae, 0xb6, 0xc3, 0xc7, 0xcb, 0xc9,
			0xc8, 0xbc, 0xb6, 0xa9, 0x9e, 0x90, 0x86, 0x77, 0x6e, 0x63, 0x5c,
			0x51, 0x4c, 0x42, 0x3c, 0x3b, 0x34, 0x40, 0x41, 0x4b, 0x5a, 0x65,
			0x71, 0x87, 0x8e, 0xa4, 0xaf, 0xba, 0xc4, 0xc8, 0xcc, 0xc9, 0xc7,
			0xbc, 0xb5, 0xa7, 0x9d, 0x8d, 0x83, 0x75, 0x6c, 0x61, 0x5b, 0x50,
			0x4b, 0x42, 0x3c, 0x39, 0x35, 0x41, 0x3e, 0x4e, 0x58, 0x64, 0x73,
			0x85, 0x8f, 0xa4, 0xaf, 0xbb, 0xc6, 0xc8, 0xcf, 0xc9, 0xc8, 0xbc,
			0xb5, 0xa6, 0x9b, 0x8d, 0x82, 0x74, 0x6b, 0x5f, 0x59, 0x4f, 0x48,
			0x41, 0x3b, 0x36, 0x36, 0x41, 0x3e, 0x53, 0x58, 0x67, 0x77, 0x86,
			0x92, 0xa6, 0xb0, 0xbd, 0xc6, 0xc9, 0xce, 0xca, 0xc7, 0xbd, 0xb4,
			0xa7, 0x9b, 0x8c, 0x84, 0x73, 0x6d, 0x5f, 0x5a, 0x4e, 0x4b, 0x3d,
			0x3d, 0x32, 0x38, 0x40, 0x3b, 0x55, 0x56, 0x67, 0x77, 0x85, 0x91,
			0xaa, 0xaf, 0xc0, 0xc8, 0xca, 0xcf, 0xcc, 0xc6, 0xbe, 0xb3, 0xa5,
			0x99, 0x8c, 0x7f, 0x73, 0x69, 0x5d, 0x58, 0x4c, 0x47, 0x3d, 0x3b,
			0x2f, 0x41, 0x3a, 0x46, 0x58, 0x59, 0x6f, 0x7b, 0x87, 0x9a, 0xab,
			0xb2, 0xc4, 0xc4, 0xcc, 0xcb, 0xc9, 0xc3, 0xbb, 0xae, 0xa3, 0x94,
			0x8a, 0x7a, 0x72, 0x64, 0x5c, 0x54, 0x49, 0x43, 0x3b, 0x36, 0x32,
			0x42, 0x37, 0x50, 0x55, 0x5f, 0x73, 0x7e, 0x8a, 0xa1, 0xab, 0xb6,
			0xc4, 0xc4, 0xcc, 0xc9, 0xc8, 0xc0, 0xb8, 0xa9, 0xa0, 0x90, 0x86,
			0x77, 0x70, 0x60, 0x5c, 0x4f, 0x48, 0x3f, 0x3b, 0x33, 0x39, 0x41,
			0x3c, 0x56, 0x55, 0x67, 0x76, 0x83, 0x90, 0xa8, 0xac, 0xbd, 0xc5,
			0xc7, 0xce, 0xc9, 0xc7, 0xbd, 0xb4, 0xa5, 0x9b, 0x8c, 0x80, 0x74,
			0x6a, 0x5e, 0x58, 0x4c, 0x45, 0x3f, 0x38, 0x36, 0x40, 0x3c, 0x4a,
			0x56, 0x5b, 0x71, 0x7b, 0x8a, 0x9c, 0xa9, 0xb3, 0xc3, 0xc3, 0xcc,
			0xcb, 0xc7, 0xc3, 0xb8, 0xad, 0xa0, 0x94, 0x86, 0x7a, 0x70, 0x63,
			0x5b, 0x51, 0x48, 0x40, 0x3c, 0x33, 0x3b, 0x3d, 0x40, 0x52, 0x54,
			0x67, 0x74, 0x82, 0x91, 0xa3, 0xab, 0xbb, 0xc2, 0xc6, 0xcc, 0xc8,
			0xc6, 0xbd, 0xb4, 0xa8, 0x9b, 0x8e, 0x82, 0x75, 0x6c, 0x61, 0x57,
			0x4f, 0x45, 0x3e, 0x39, 0x34, 0x3e, 0x3b, 0x48, 0x52, 0x59, 0x6d,
			0x79, 0x87, 0x9b, 0xa7, 0xb3, 0xc0, 0xc3, 0xcb, 0xcb, 0xc8, 0xc4,
			0xba, 0xae, 0xa4, 0x95, 0x8b, 0x7c, 0x72, 0x67, 0x5e, 0x54, 0x4c,
			0x43, 0x3c, 0x38, 0x3a, 0x3f, 0x40, 0x50, 0x54, 0x62, 0x72, 0x7f,
			0x90, 0xa1, 0xab, 0xba, 0xc1, 0xc5, 0xcb, 0xc8, 0xc6, 0xbe, 0xb3,
			0xa8, 0x9c, 0x8e, 0x83, 0x75, 0x6b, 0x60, 0x57, 0x4d, 0x45, 0x3d,
			0x38, 0x38, 0x3d, 0x3f, 0x49, 0x54, 0x5c, 0x6e, 0x7a, 0x8b, 0x9c,
			0xa9, 0xb5, 0xc0, 0xc4, 0xc9, 0xca, 0xc5, 0xc2, 0xb5, 0xac, 0x9f,
			0x93, 0x86, 0x7a, 0x6f, 0x65, 0x5a, 0x53, 0x49, 0x40, 0x3d, 0x36,
			0x3f, 0x3d, 0x46, 0x51, 0x57, 0x67, 0x75, 0x83, 0x96, 0xa3, 0xb0,
			0xbc, 0xc2, 0xc7, 0xca, 0xc7, 0xc3, 0xbc, 0xaf, 0xa5, 0x97, 0x8a,
			0x7f, 0x72, 0x68, 0x5f, 0x53, 0x4c, 0x43, 0x3c, 0x38, 0x3b, 0x3e,
			0x42, 0x4f, 0x55, 0x62, 0x71, 0x7d, 0x8f, 0x9d, 0xab, 0xb6, 0xc1,
			0xc3, 0xc9, 0xc7, 0xc4, 0xbf, 0xb1, 0xa9, 0x9c, 0x8e, 0x83, 0x78,
			0x6b, 0x64, 0x58, 0x51, 0x47, 0x40, 0x3a, 0x39, 0x3e, 0x3f, 0x49,
			0x53, 0x5a, 0x6d, 0x78, 0x88, 0x99, 0xa6, 0xb2, 0xbe, 0xc2, 0xc8,
			0xc9, 0xc3, 0xc4, 0xb2, 0xae, 0x9e, 0x91, 0x86, 0x79, 0x6d, 0x67,
			0x58, 0x51, 0x4a, 0x3d, 0x3d, 0x38, 0x3c, 0x40, 0x48, 0x51, 0x5e,
			0x68, 0x7a, 0x87, 0x96, 0xa5, 0xb2, 0xbb, 0xc4, 0xc6, 0xc8, 0xc6,
			0xc0, 0xb7, 0xab, 0xa0, 0x92, 0x87, 0x79, 0x6f, 0x65, 0x5b, 0x51,
			0x4a, 0x40, 0x3c, 0x3a, 0x3d, 0x41, 0x49, 0x53, 0x5c, 0x6d, 0x78,
			0x88, 0x98, 0xa3, 0xb2, 0xbc, 0xc1, 0xc8, 0xc6, 0xc4, 0xc1, 0xb3,
			0xae, 0x9e, 0x93, 0x88, 0x79, 0x6e, 0x66, 0x58, 0x52, 0x49, 0x3f,
			0x3d, 0x38, 0x3d, 0x41, 0x49, 0x53, 0x5d, 0x6c, 0x7a, 0x88, 0x98,
			0xa6, 0xb2, 0xbc, 0xc4, 0xc4, 0xca, 0xc2, 0xc1, 0xb6, 0xab, 0xa0,
			0x91, 0x86, 0x79, 0x6d, 0x63, 0x5a, 0x4e, 0x49, 0x3d, 0x3b, 0x3a,
			0x3d, 0x42, 0x4d, 0x54, 0x61, 0x70, 0x7b, 0x8e, 0x9b, 0xa9, 0xb7,
			0xbe, 0xc6, 0xc8, 0xc7, 0xc6, 0xbc, 0xb5, 0xa9, 0x9b, 0x8f, 0x82,
			0x74, 0x6b, 0x60, 0x56, 0x4d, 0x43, 0x3d, 0x39, 0x3a, 0x40, 0x43,
			0x4f, 0x57, 0x63, 0x73, 0x80, 0x90, 0x9f, 0xac, 0xb8, 0xc1, 0xc6,
			0xc7, 0xc6, 0xc2, 0xb8, 0xb0, 0xa1, 0x95, 0x89, 0x7b, 0x71, 0x66,
			0x5c, 0x53, 0x49, 0x41, 0x3b, 0x3a, 0x3d, 0x40, 0x49, 0x53, 0x5d,
			0x6c, 0x7a, 0x88, 0x98, 0xa5, 0xb4, 0xbc, 0xc3, 0xc8, 0xc6, 0xc5,
			0xbe, 0xb2, 0xa9, 0x99, 0x8d, 0x82, 0x75, 0x6c, 0x61, 0x56, 0x4e,
			0x44, 0x3d, 0x3b, 0x3b, 0x40, 0x45, 0x4f, 0x57, 0x66, 0x74, 0x82,
			0x93, 0xa0, 0xae, 0xb9, 0xc0, 0xc7, 0xc7, 0xc5, 0xc2, 0xb5, 0xae,
			0x9e, 0x91, 0x87, 0x78, 0x6f, 0x67, 0x58, 0x53, 0x48, 0x40, 0x3e,
			0x3b, 0x40, 0x44, 0x4c, 0x56, 0x60, 0x6f, 0x7d, 0x8d, 0x9b, 0xa9,
			0xb4, 0xbc, 0xc4, 0xc4, 0xc6, 0xc2, 0xb8, 0xb0, 0xa2, 0x94, 0x8a,
			0x7b, 0x73, 0x66, 0x5d, 0x53, 0x4a, 0x43, 0x3d, 0x3d, 0x41, 0x44,
			0x4e, 0x57, 0x60, 0x71, 0x7d, 0x8d, 0x9c, 0xa9, 0xb4, 0xbd, 0xc1,
			0xc7, 0xc1, 0xc1, 0xb7, 0xab, 0xa3, 0x91, 0x88, 0x7c, 0x6f, 0x68,
			0x5d, 0x53, 0x4e, 0x43, 0x40, 0x3f, 0x41, 0x47, 0x4f, 0x58, 0x63,
			0x70, 0x7e, 0x8d, 0x9b, 0xa8, 0xb4, 0xbb, 0xc2, 0xc4, 0xc2, 0xbf,
			0xb8, 0xab, 0xa3, 0x92, 0x88, 0x7d, 0x71, 0x6a, 0x5f, 0x56, 0x4e,
			0x47, 0x3f, 0x40, 0x3f, 0x46, 0x4b, 0x56, 0x5e, 0x6c, 0x7a, 0x89,
			0x98, 0xa4, 0xb2, 0xb7, 0xc0, 0xc2, 0xc2, 0xbe, 0xbb, 0xae, 0xa7,
			0x98, 0x8c, 0x83, 0x76, 0x6e, 0x65, 0x5b, 0x53, 0x4c, 0x41, 0x43,
			0x3f, 0x45, 0x4a, 0x50, 0x5c, 0x64, 0x75, 0x80, 0x92, 0x9c, 0xab,
			0xb2, 0xba, 0xc0, 0xbf, 0xc0, 0xbc, 0xb2, 0xa9, 0x9f, 0x90, 0x89,
			0x7a, 0x72, 0x68, 0x5f, 0x56, 0x50, 0x46, 0x43, 0x44, 0x41, 0x4d,
			0x4c, 0x5a, 0x61, 0x6f, 0x7c, 0x8b, 0x98, 0xa4, 0xb0, 0xb5, 0xbf,
			0xbe, 0xbf, 0xbb, 0xb5, 0xaa, 0xa2, 0x93, 0x8a, 0x7d, 0x73, 0x6b,
			0x61, 0x5a, 0x53, 0x4c, 0x44, 0x48, 0x41, 0x4d, 0x4e, 0x57, 0x61,
			0x6a, 0x7a, 0x85, 0x95, 0x9e, 0xad, 0xaf, 0xbc, 0xba, 0xbe, 0xb9,
			0xb4, 0xad, 0xa1, 0x98, 0x8a, 0x82, 0x74, 0x6f, 0x62, 0x5f, 0x53,
			0x51, 0x45, 0x4a, 0x43, 0x4b, 0x51, 0x53, 0x64, 0x65, 0x7b, 0x80,
			0x93, 0x9a, 0xaa, 0xad, 0xb8, 0xb9, 0xb9, 0xbb, 0xb1, 0xaf, 0xa0,
			0x9a, 0x8b, 0x84, 0x76, 0x72, 0x64, 0x62, 0x57, 0x53, 0x4b, 0x49,
			0x4a, 0x48, 0x56, 0x52, 0x65, 0x66, 0x77, 0x80, 0x8e, 0x98, 0xa5,
			0xac, 0xb4, 0xb9, 0xb7, 0xbc, 0xb1, 0xb1, 0xa2, 0x9e, 0x8d, 0x87,
			0x79, 0x73, 0x68, 0x63, 0x58, 0x56, 0x4d, 0x4a, 0x4e, 0x47, 0x58,
			0x52, 0x63, 0x66, 0x74, 0x7c, 0x8d, 0x91, 0xa3, 0xa7, 0xaf, 0xb6,
			0xb3, 0xb8, 0xaf, 0xaf, 0xa1, 0x9d, 0x8c, 0x89, 0x78, 0x76, 0x69,
			0x65, 0x5a, 0x58, 0x4f, 0x4e, 0x4f, 0x4a, 0x58, 0x54, 0x64, 0x68,
			0x75, 0x7d, 0x8d, 0x91, 0xa3, 0xa4, 0xaf, 0xb2, 0xb2, 0xb7, 0xad,
			0xae, 0xa0, 0x9b, 0x8d, 0x87, 0x79, 0x76, 0x68, 0x66, 0x5a, 0x58,
			0x51, 0x4f, 0x52, 0x4d, 0x5b, 0x57, 0x65, 0x6b, 0x74, 0x7f, 0x8c,
			0x91, 0xa1, 0xa3, 0xad, 0xb0, 0xb1, 0xb1, 0xad, 0xaa, 0x9f, 0x9b,
			0x8c, 0x87, 0x7a, 0x74, 0x6a, 0x66, 0x5a, 0x5b, 0x51, 0x53, 0x53,
			0x50, 0x5c, 0x5a, 0x66, 0x6e, 0x75, 0x81, 0x8c, 0x92, 0xa1, 0xa3,
			0xab, 0xad, 0xb0, 0xab, 0xac, 0xa4, 0x9b, 0x98, 0x88, 0x85, 0x78,
			0x72, 0x6a, 0x64, 0x5c, 0x5c, 0x53, 0x57, 0x55, 0x55, 0x60, 0x5d,
			0x6a, 0x71, 0x77, 0x84, 0x8d, 0x92, 0xa0, 0xa2, 0xa7, 0xad, 0xa9,
			0xaa, 0xa8, 0x9e, 0x9c, 0x91, 0x88, 0x84, 0x76, 0x73, 0x6b, 0x62,
			0x61, 0x5a, 0x56, 0x5b, 0x54, 0x5c, 0x61, 0x60, 0x70, 0x72, 0x7b,
			0x87, 0x8c, 0x95, 0x9f, 0x9f, 0xa7, 0xa9, 0xa5, 0xa9, 0xa0, 0x9c,
			0x97, 0x8c, 0x86, 0x80, 0x75, 0x73, 0x68, 0x65, 0x61, 0x5b, 0x5a,
			0x5b, 0x5a, 0x5f, 0x65, 0x66, 0x74, 0x74, 0x80, 0x87, 0x8e, 0x96,
			0x9d, 0x9e, 0xa6, 0xa3, 0xa4, 0xa4, 0x9c, 0x9b, 0x92, 0x8b, 0x85,
			0x7e, 0x75, 0x74, 0x68, 0x68, 0x60, 0x60, 0x5d, 0x5f, 0x5d, 0x64,
			0x66, 0x6b, 0x74, 0x77, 0x81, 0x86, 0x8f, 0x93, 0x9b, 0x9b, 0xa3,
			0x9f, 0xa3, 0x9f, 0x9b, 0x98, 0x90, 0x8a, 0x84, 0x7d, 0x77, 0x72,
			0x6b, 0x69, 0x62, 0x62, 0x5f, 0x61, 0x61, 0x65, 0x69, 0x6d, 0x74,
			0x7a, 0x7f, 0x88, 0x8c, 0x92, 0x98, 0x9a, 0x9e, 0x9e, 0x9f, 0x9c,
			0x9a, 0x94, 0x90, 0x89, 0x84, 0x7d, 0x78, 0x72, 0x6e, 0x69, 0x66,
			0x65, 0x62, 0x64, 0x65, 0x67, 0x6c, 0x6f, 0x74, 0x7c, 0x7e, 0x88,
			0x8b, 0x90, 0x95, 0x98, 0x9a, 0x9d, 0x9b, 0x9a, 0x98, 0x92, 0x8f,
			0x89, 0x84, 0x7e, 0x78, 0x73, 0x70, 0x69, 0x69, 0x65, 0x65, 0x66,
			0x67, 0x69, 0x6d, 0x71, 0x76, 0x7c, 0x80, 0x86, 0x8b, 0x8f, 0x93,
			0x96, 0x97, 0x9a, 0x98, 0x97, 0x95, 0x91, 0x8d, 0x89, 0x83, 0x7f,
			0x79, 0x75, 0x71, 0x6d, 0x6b, 0x69, 0x68, 0x69, 0x69, 0x6b, 0x70,
			0x71, 0x77, 0x7b, 0x80, 0x85, 0x8a, 0x8e, 0x92, 0x94, 0x96, 0x97,
			0x96, 0x95, 0x92, 0x8f, 0x8a, 0x86, 0x81, 0x7d, 0x78, 0x74, 0x70,
			0x6e, 0x6c, 0x6b, 0x6b, 0x6b, 0x6d, 0x70, 0x72, 0x77, 0x7a, 0x7f,
			0x84, 0x88, 0x8c, 0x8f, 0x92, 0x94, 0x94, 0x94, 0x93, 0x91, 0x8e,
			0x8b, 0x86, 0x82, 0x7e, 0x7a, 0x77, 0x73, 0x71, 0x6f, 0x6f, 0x6d,
			0x6e, 0x6f, 0x71, 0x73, 0x76, 0x78, 0x7c, 0x7f, 0x82, 0x86, 0x88,
			0x8b, 0x8d, 0x8f, 0x8f, 0x90, 0x8f, 0x8e, 0x8c, 0x89, 0x87, 0x83,
			0x80, 0x7d, 0x7a, 0x77, 0x76, 0x73, 0x73, 0x72, 0x72, 0x73, 0x74,
			0x75, 0x78, 0x7a, 0x7c, 0x7f, 0x81, 0x84, 0x85, 0x88, 0x89, 0x8b,
			0x8c, 0x8c, 0x8c, 0x8a, 0x89, 0x87, 0x85, 0x82, 0x80, 0x7e, 0x7c,
			0x7a, 0x78, 0x77, 0x76, 0x76, 0x76, 0x76, 0x77, 0x79, 0x7a, 0x7c,
			0x7d, 0x7f, 0x81, 0x82, 0x83, 0x85, 0x85, 0x86, 0x86, 0x86, 0x86,
			0x86, 0x85, 0x84, 0x83, 0x81, 0x81, 0x7f, 0x7e, 0x7d, 0x7c, 0x7c,
			0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f,
			0x81, 0x81, 0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82,
			0x81, 0x81, 0x80, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
		},
		{ // 8
			0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
			0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7e,
			0x80, 0x80, 0x7f, 0x81, 0x80, 0x80, 0x81, 0x81, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x82, 0x83, 0x91, 0x9c, 0x7a, 0x74, 0x82, 0x82, 0x97,
			0x94, 0x83, 0x74, 0x6d, 0x72, 0x7c, 0x80, 0x7a, 0x71, 0x6d, 0x6a,
			0x69, 0x72, 0x79, 0x7f, 0x82, 0x82, 0x7e, 0x7f, 0x82, 0x83, 0x82,
			0x84, 0x81, 0x83, 0x86, 0x86, 0x89, 0x89, 0x8a, 0x8a, 0x88, 0x85,
			0x80, 0x7b, 0x78, 0x71, 0x71, 0x6e, 0x6f, 0x70, 0x70, 0x71, 0x75,
			0x78, 0x78, 0x7d, 0x8a, 0xa1, 0xa7, 0xa7, 0x9a, 0x92, 0x8e, 0x91,
			0x95, 0x97, 0x94, 0x8b, 0x80, 0x71, 0x6a, 0x60, 0x5d, 0x59, 0x58,
			0x54, 0x56, 0x58, 0x6c, 0x83, 0xa0, 0xb8, 0xa7, 0x8f, 0x72, 0x6b,
			0x78, 0x88, 0x9b, 0xad, 0xa9, 0x98, 0x85, 0x79, 0x76, 0x78, 0x7e,
			0x81, 0x81, 0x77, 0x6e, 0x66, 0x62, 0x64, 0x60, 0x5c, 0x5a, 0x6e,
			0x7e, 0xa0, 0xb2, 0xa1, 0x91, 0x6f, 0x69, 0x78, 0x89, 0xa2, 0xaa,
			0xa9, 0x9d, 0x8c, 0x7c, 0x70, 0x77, 0x84, 0x90, 0x89, 0x7e, 0x6e,
			0x66, 0x5c, 0x5f, 0x62, 0x65, 0x5a, 0x66, 0x79, 0x90, 0xbf, 0xa9,
			0x95, 0x72, 0x5e, 0x73, 0x85, 0x9c, 0xb1, 0xa8, 0xa3, 0x8a, 0x7a,
			0x73, 0x71, 0x84, 0x8a, 0x8e, 0x7f, 0x72, 0x69, 0x61, 0x62, 0x66,
			0x60, 0x62, 0x4e, 0x66, 0x7e, 0x9f, 0xc8, 0xa3, 0x89, 0x68, 0x5c,
			0x77, 0x89, 0xa5, 0xb6, 0xa8, 0x9b, 0x7d, 0x74, 0x77, 0x7a, 0x8b,
			0x8c, 0x88, 0x77, 0x6f, 0x68, 0x69, 0x6e, 0x69, 0x62, 0x5b, 0x4b,
			0x67, 0x7f, 0xa0, 0xc7, 0xa2, 0x86, 0x60, 0x56, 0x7a, 0x90, 0xac,
			0xb5, 0xa4, 0x93, 0x76, 0x74, 0x7b, 0x80, 0x8e, 0x8d, 0x87, 0x75,
			0x6a, 0x6c, 0x70, 0x71, 0x6c, 0x5d, 0x5a, 0x4c, 0x63, 0x85, 0xa0,
			0xc6, 0xa9, 0x81, 0x5f, 0x57, 0x79, 0x98, 0xaf, 0xb4, 0x9f, 0x88,
			0x6f, 0x72, 0x80, 0x89, 0x92, 0x8a, 0x80, 0x6c, 0x69, 0x6b, 0x74,
			0x79, 0x72, 0x5e, 0x52, 0x44, 0x60, 0x88, 0xa0, 0xc9, 0xab, 0x84,
			0x5c, 0x51, 0x79, 0x9b, 0xb4, 0xb7, 0xa0, 0x86, 0x6f, 0x70, 0x82,
			0x8b, 0x92, 0x87, 0x7e, 0x6b, 0x68, 0x72, 0x79, 0x7d, 0x71, 0x5c,
			0x53, 0x4b, 0x5b, 0x8a, 0x9a, 0xc5, 0xb3, 0x80, 0x62, 0x4c, 0x74,
			0x9b, 0xb2, 0xb4, 0x9d, 0x85, 0x71, 0x71, 0x89, 0x90, 0x95, 0x88,
			0x78, 0x6d, 0x6a, 0x76, 0x7c, 0x7e, 0x72, 0x5e, 0x52, 0x52, 0x55,
			0x7f, 0x92, 0xb9, 0xc1, 0x89, 0x67, 0x4a, 0x6b, 0x9b, 0xb1, 0xb6,
			0x9f, 0x86, 0x76, 0x73, 0x88, 0x8f, 0x95, 0x88, 0x74, 0x6c, 0x68,
			0x79, 0x7d, 0x7e, 0x6f, 0x5c, 0x54, 0x4f, 0x52, 0x78, 0x91, 0xaf,
			0xc6, 0x92, 0x6c, 0x4f, 0x60, 0x94, 0xaf, 0xb9, 0xa2, 0x86, 0x75,
			0x73, 0x89, 0x95, 0x94, 0x89, 0x75, 0x6e, 0x6a, 0x7a, 0x82, 0x81,
			0x71, 0x5a, 0x51, 0x53, 0x56, 0x6c, 0x8a, 0x9e, 0xc6, 0xa1, 0x71,
			0x54, 0x54, 0x8d, 0xad, 0xb8, 0xa6, 0x88, 0x79, 0x73, 0x84, 0x96,
			0x94, 0x8d, 0x73, 0x6d, 0x6a, 0x77, 0x80, 0x80, 0x79, 0x63, 0x50,
			0x4b, 0x52, 0x65, 0x8d, 0x96, 0xbe, 0xae, 0x77, 0x5a, 0x4c, 0x81,
			0xac, 0xba, 0xad, 0x8a, 0x79, 0x73, 0x83, 0x9b, 0x94, 0x8d, 0x77,
			0x6e, 0x6e, 0x75, 0x84, 0x80, 0x78, 0x60, 0x56, 0x57, 0x5b, 0x57,
			0x7a, 0x8e, 0xb1, 0xc0, 0x83, 0x66, 0x4d, 0x71, 0xa0, 0xaf, 0xb1,
			0x95, 0x7c, 0x74, 0x7a, 0x93, 0x97, 0x8f, 0x7e, 0x6d, 0x71, 0x71,
			0x84, 0x7f, 0x78, 0x66, 0x59, 0x53, 0x59, 0x59, 0x76, 0x8c, 0xa1,
			0xc5, 0x91, 0x6e, 0x53, 0x65, 0x9b, 0xaf, 0xb2, 0x9c, 0x81, 0x7a,
			0x7a, 0x90, 0x99, 0x8f, 0x82, 0x6e, 0x71, 0x71, 0x82, 0x83, 0x79,
			0x6a, 0x58, 0x57, 0x5d, 0x59, 0x68, 0x84, 0x95, 0xbf, 0xa4, 0x75,
			0x5a, 0x5a, 0x8d, 0xaa, 0xb1, 0xa2, 0x88, 0x7b, 0x79, 0x89, 0x9b,
			0x94, 0x87, 0x73, 0x72, 0x72, 0x7c, 0x86, 0x7b, 0x6f, 0x5a, 0x5b,
			0x5d, 0x5b, 0x60, 0x7d, 0x8d, 0xba, 0xb0, 0x7e, 0x63, 0x52, 0x83,
			0xa3, 0xb5, 0xa8, 0x8d, 0x7c, 0x76, 0x85, 0x9a, 0x97, 0x8c, 0x75,
			0x6f, 0x71, 0x76, 0x88, 0x7e, 0x73, 0x5d, 0x5a, 0x58, 0x5c, 0x58,
			0x74, 0x89, 0xaa, 0xbb, 0x87, 0x6a, 0x50, 0x75, 0x9d, 0xb0, 0xab,
			0x90, 0x81, 0x77, 0x81, 0x9a, 0x99, 0x8d, 0x76, 0x6f, 0x76, 0x79,
			0x84, 0x7c, 0x70, 0x5c, 0x5a, 0x5d, 0x5f, 0x5d, 0x7a, 0x86, 0xb4,
			0xb5, 0x80, 0x63, 0x4e, 0x80, 0xa3, 0xb3, 0xa7, 0x8d, 0x7f, 0x78,
			0x87, 0x9b, 0x9a, 0x8b, 0x72, 0x70, 0x73, 0x7f, 0x82, 0x79, 0x6c,
			0x5e, 0x5c, 0x5b, 0x5a, 0x5b, 0x82, 0x91, 0xbb, 0xa6, 0x72, 0x5e,
			0x59, 0x8a, 0xa8, 0xb1, 0xa1, 0x87, 0x7a, 0x7a, 0x8e, 0x9d, 0x94,
			0x84, 0x6f, 0x73, 0x77, 0x86, 0x7f, 0x77, 0x64, 0x5a, 0x5d, 0x63,
			0x5d, 0x61, 0x7f, 0x99, 0xc1, 0x99, 0x72, 0x56, 0x69, 0x96, 0xa9,
			0xad, 0x97, 0x85, 0x7a, 0x81, 0x92, 0x9e, 0x92, 0x7b, 0x6c, 0x74,
			0x7d, 0x89, 0x83, 0x75, 0x5f, 0x5a, 0x5a, 0x65, 0x5b, 0x6c, 0x88,
			0xa1, 0xbf, 0x88, 0x69, 0x53, 0x74, 0x9d, 0xac, 0xa8, 0x8e, 0x81,
			0x7a, 0x83, 0x97, 0x9c, 0x8d, 0x76, 0x6c, 0x75, 0x7f, 0x88, 0x7b,
			0x70, 0x5f, 0x5e, 0x5d, 0x62, 0x59, 0x72, 0x88, 0xae, 0xb9, 0x85,
			0x64, 0x53, 0x7f, 0xa1, 0xb1, 0xa5, 0x8d, 0x7f, 0x78, 0x86, 0x99,
			0x9a, 0x89, 0x70, 0x6d, 0x77, 0x85, 0x85, 0x78, 0x6c, 0x5f, 0x5f,
			0x5c, 0x5d, 0x5b, 0x7f, 0x91, 0xb4, 0xa6, 0x76, 0x61, 0x5b, 0x8c,
			0xa3, 0xae, 0x9b, 0x86, 0x7d, 0x7b, 0x8d, 0x9c, 0x98, 0x81, 0x6c,
			0x6f, 0x7a, 0x87, 0x82, 0x76, 0x63, 0x5b, 0x5d, 0x64, 0x5d, 0x62,
			0x80, 0x92, 0xbe, 0x98, 0x77, 0x5a, 0x67, 0x96, 0xa7, 0xae, 0x96,
			0x86, 0x7c, 0x7e, 0x90, 0x9d, 0x93, 0x7e, 0x6e, 0x74, 0x7c, 0x87,
			0x7e, 0x77, 0x67, 0x5e, 0x58, 0x5f, 0x59, 0x6a, 0x89, 0x9f, 0xbb,
			0x8d, 0x6c, 0x55, 0x71, 0x9e, 0xaf, 0xaa, 0x8f, 0x80, 0x7a, 0x85,
			0x95, 0x9b, 0x8f, 0x77, 0x6d, 0x73, 0x7e, 0x85, 0x7c, 0x73, 0x62,
			0x60, 0x5c, 0x62, 0x58, 0x6b, 0x83, 0x9e, 0xb9, 0x8c, 0x6c, 0x56,
			0x75, 0x9d, 0xad, 0xa6, 0x8d, 0x82, 0x7c, 0x84, 0x95, 0x9a, 0x8e,
			0x79, 0x6f, 0x74, 0x7f, 0x86, 0x7b, 0x6e, 0x62, 0x61, 0x60, 0x65,
			0x55, 0x6a, 0x85, 0xa0, 0xb9, 0x89, 0x6c, 0x5a, 0x77, 0x9f, 0xab,
			0xa6, 0x8e, 0x83, 0x7b, 0x87, 0x95, 0x9c, 0x8d, 0x77, 0x71, 0x76,
			0x81, 0x84, 0x7b, 0x6f, 0x61, 0x63, 0x60, 0x65, 0x57, 0x65, 0x81,
			0x9e, 0xbb, 0x8e, 0x6f, 0x57, 0x73, 0x9b, 0xac, 0xab, 0x8e, 0x84,
			0x7a, 0x86, 0x94, 0x9b, 0x8e, 0x78, 0x70, 0x76, 0x83, 0x86, 0x7b,
			0x6c, 0x60, 0x63, 0x61, 0x65, 0x58, 0x64, 0x82, 0x9c, 0xba, 0x8d,
			0x70, 0x5b, 0x74, 0x9b, 0xa7, 0xa8, 0x8f, 0x87, 0x7c, 0x85, 0x94,
			0x9a, 0x8f, 0x77, 0x70, 0x75, 0x80, 0x85, 0x78, 0x6e, 0x64, 0x65,
			0x61, 0x63, 0x56, 0x63, 0x80, 0x98, 0xb6, 0x91, 0x75, 0x5b, 0x71,
			0x96, 0xa9, 0xab, 0x92, 0x86, 0x7b, 0x85, 0x93, 0x9c, 0x90, 0x79,
			0x70, 0x76, 0x7f, 0x83, 0x79, 0x70, 0x65, 0x62, 0x5f, 0x62, 0x5c,
			0x62, 0x7c, 0x92, 0xb4, 0x95, 0x76, 0x5d, 0x6f, 0x96, 0xa8, 0xab,
			0x92, 0x88, 0x7d, 0x86, 0x92, 0x9b, 0x91, 0x7b, 0x70, 0x74, 0x7f,
			0x84, 0x7b, 0x6f, 0x64, 0x64, 0x60, 0x64, 0x5b, 0x65, 0x7f, 0x91,
			0xb2, 0x92, 0x78, 0x60, 0x71, 0x97, 0xa8, 0xaa, 0x91, 0x86, 0x7d,
			0x89, 0x94, 0x9a, 0x8c, 0x79, 0x72, 0x76, 0x7f, 0x80, 0x78, 0x6d,
			0x63, 0x65, 0x61, 0x64, 0x59, 0x67, 0x7f, 0x97, 0xaf, 0x8e, 0x77,
			0x61, 0x79, 0x98, 0xa9, 0xa7, 0x90, 0x87, 0x80, 0x8b, 0x95, 0x97,
			0x8a, 0x78, 0x74, 0x79, 0x81, 0x7f, 0x75, 0x6b, 0x62, 0x64, 0x60,
			0x65, 0x59, 0x6f, 0x80, 0x9d, 0xab, 0x85, 0x72, 0x5f, 0x83, 0x9b,
			0xa9, 0x9e, 0x8c, 0x85, 0x81, 0x8e, 0x95, 0x97, 0x85, 0x75, 0x73,
			0x7b, 0x82, 0x7d, 0x72, 0x69, 0x64, 0x64, 0x63, 0x62, 0x5d, 0x76,
			0x7f, 0xa2, 0x9e, 0x85, 0x70, 0x66, 0x89, 0x9c, 0xa9, 0x98, 0x8b,
			0x82, 0x85, 0x8f, 0x97, 0x95, 0x82, 0x74, 0x75, 0x7b, 0x82, 0x79,
			0x6f, 0x66, 0x66, 0x61, 0x64, 0x5b, 0x67, 0x7c, 0x88, 0xa5, 0x8e,
			0x81, 0x68, 0x76, 0x91, 0xa2, 0xa5, 0x92, 0x8a, 0x83, 0x8b, 0x93,
			0x99, 0x8e, 0x7c, 0x75, 0x79, 0x81, 0x80, 0x75, 0x6c, 0x66, 0x66,
			0x62, 0x62, 0x5b, 0x72, 0x7d, 0x98, 0x9f, 0x84, 0x75, 0x67, 0x85,
			0x98, 0xa4, 0x9a, 0x8d, 0x88, 0x86, 0x90, 0x96, 0x94, 0x85, 0x77,
			0x76, 0x7a, 0x81, 0x7b, 0x76, 0x68, 0x63, 0x5f, 0x63, 0x61, 0x6a,
			0x79, 0x87, 0xa0, 0x8d, 0x7d, 0x69, 0x78, 0x91, 0xa0, 0x9d, 0x8e,
			0x89, 0x87, 0x8e, 0x95, 0x95, 0x8b, 0x7c, 0x76, 0x79, 0x7f, 0x7e,
			0x75, 0x6b, 0x67, 0x61, 0x61, 0x60, 0x65, 0x7a, 0x7f, 0x9c, 0x8f,
			0x85, 0x70, 0x73, 0x8c, 0x9a, 0xa2, 0x91, 0x8a, 0x84, 0x8c, 0x93,
			0x96, 0x8e, 0x7f, 0x77, 0x77, 0x7d, 0x7e, 0x79, 0x6f, 0x69, 0x63,
			0x60, 0x63, 0x64, 0x79, 0x7c, 0x96, 0x92, 0x84, 0x74, 0x70, 0x8a,
			0x99, 0xa4, 0x94, 0x8d, 0x85, 0x8b, 0x93, 0x93, 0x8f, 0x80, 0x79,
			0x78, 0x7c, 0x7c, 0x79, 0x6e, 0x65, 0x62, 0x64, 0x69, 0x67, 0x75,
			0x7b, 0x94, 0x93, 0x84, 0x74, 0x74, 0x8a, 0x97, 0x9e, 0x92, 0x8d,
			0x88, 0x8a, 0x90, 0x92, 0x8c, 0x81, 0x79, 0x79, 0x7d, 0x7a, 0x77,
			0x6f, 0x67, 0x61, 0x63, 0x64, 0x6d, 0x76, 0x7d, 0x93, 0x8d, 0x84,
			0x71, 0x77, 0x8b, 0x99, 0x9d, 0x93, 0x8c, 0x89, 0x8b, 0x90, 0x94,
			0x8a, 0x81, 0x7a, 0x7a, 0x7d, 0x7a, 0x76, 0x6e, 0x67, 0x60, 0x64,
			0x64, 0x6f, 0x79, 0x82, 0x93, 0x86, 0x80, 0x72, 0x7f, 0x8e, 0x9a,
			0x98, 0x90, 0x8c, 0x89, 0x90, 0x90, 0x93, 0x87, 0x80, 0x7a, 0x7c,
			0x7f, 0x7a, 0x74, 0x6c, 0x69, 0x64, 0x65, 0x66, 0x71, 0x7b, 0x85,
			0x8f, 0x85, 0x7c, 0x76, 0x80, 0x91, 0x9a, 0x98, 0x8f, 0x8a, 0x8a,
			0x91, 0x91, 0x8d, 0x83, 0x7f, 0x7c, 0x7d, 0x7d, 0x78, 0x71, 0x69,
			0x69, 0x66, 0x69, 0x68, 0x77, 0x7d, 0x89, 0x89, 0x80, 0x79, 0x78,
			0x89, 0x91, 0x97, 0x90, 0x8f, 0x8b, 0x8e, 0x8f, 0x8f, 0x8a, 0x84,
			0x82, 0x7f, 0x80, 0x78, 0x75, 0x6e, 0x6e, 0x69, 0x69, 0x66, 0x6a,
			0x77, 0x7e, 0x88, 0x80, 0x7d, 0x78, 0x7e, 0x8a, 0x91, 0x95, 0x8f,
			0x8c, 0x8c, 0x93, 0x93, 0x8f, 0x86, 0x86, 0x84, 0x82, 0x7e, 0x77,
			0x75, 0x71, 0x70, 0x69, 0x66, 0x65, 0x6f, 0x79, 0x80, 0x83, 0x7c,
			0x79, 0x77, 0x83, 0x8b, 0x8f, 0x90, 0x8d, 0x8d, 0x8e, 0x93, 0x90,
			0x8b, 0x88, 0x88, 0x85, 0x81, 0x7b, 0x77, 0x74, 0x71, 0x6d, 0x69,
			0x69, 0x6a, 0x74, 0x79, 0x80, 0x7f, 0x7c, 0x79, 0x7b, 0x87, 0x8d,
			0x91, 0x8d, 0x8d, 0x8c, 0x92, 0x94, 0x8f, 0x8b, 0x87, 0x89, 0x85,
			0x80, 0x78, 0x76, 0x75, 0x72, 0x6a, 0x69, 0x6c, 0x70, 0x75, 0x76,
			0x7d, 0x7c, 0x7b, 0x78, 0x7e, 0x88, 0x8f, 0x90, 0x8c, 0x8c, 0x8f,
			0x94, 0x91, 0x8c, 0x89, 0x89, 0x87, 0x82, 0x7d, 0x78, 0x75, 0x72,
			0x6e, 0x6b, 0x6e, 0x6f, 0x73, 0x75, 0x78, 0x7d, 0x7b, 0x7c, 0x7b,
			0x83, 0x8a, 0x90, 0x8e, 0x8c, 0x8f, 0x92, 0x91, 0x8a, 0x8a, 0x8a,
			0x8a, 0x82, 0x7c, 0x79, 0x77, 0x74, 0x6e, 0x6b, 0x6f, 0x73, 0x72,
			0x72, 0x72, 0x7a, 0x7d, 0x7e, 0x7b, 0x7f, 0x86, 0x8c, 0x8f, 0x8d,
			0x8e, 0x91, 0x93, 0x8c, 0x8a, 0x8a, 0x8b, 0x86, 0x80, 0x7b, 0x7a,
			0x77, 0x73, 0x6d, 0x6e, 0x72, 0x72, 0x72, 0x73, 0x77, 0x7b, 0x7d,
			0x7b, 0x7d, 0x83, 0x8b, 0x8b, 0x8c, 0x8e, 0x90, 0x8e, 0x8b, 0x8c,
			0x8d, 0x8b, 0x84, 0x81, 0x7d, 0x7c, 0x76, 0x74, 0x70, 0x72, 0x73,
			0x72, 0x6f, 0x70, 0x75, 0x7d, 0x81, 0x7d, 0x7b, 0x7f, 0x88, 0x8c,
			0x8f, 0x8c, 0x8c, 0x8c, 0x8e, 0x8c, 0x8a, 0x86, 0x85, 0x83, 0x80,
			0x7b, 0x76, 0x75, 0x74, 0x74, 0x72, 0x72, 0x70, 0x73, 0x76, 0x7c,
			0x7f, 0x7e, 0x7d, 0x81, 0x87, 0x8b, 0x8c, 0x8b, 0x8a, 0x8b, 0x8c,
			0x8a, 0x88, 0x85, 0x83, 0x80, 0x7d, 0x7c, 0x79, 0x76, 0x73, 0x72,
			0x72, 0x72, 0x75, 0x79, 0x7e, 0x7e, 0x7c, 0x7c, 0x82, 0x87, 0x8a,
			0x88, 0x88, 0x8b, 0x8c, 0x8b, 0x88, 0x87, 0x87, 0x85, 0x81, 0x7e,
			0x7d, 0x7b, 0x78, 0x75, 0x74, 0x74, 0x74, 0x74, 0x77, 0x7b, 0x7c,
			0x7c, 0x7c, 0x80, 0x83, 0x85, 0x87, 0x89, 0x89, 0x8a, 0x89, 0x88,
			0x88, 0x88, 0x84, 0x81, 0x7f, 0x7f, 0x7e, 0x7b, 0x78, 0x76, 0x76,
			0x77, 0x77, 0x77, 0x79, 0x7a, 0x7b, 0x7d, 0x80, 0x80, 0x82, 0x84,
			0x87, 0x87, 0x88, 0x87, 0x87, 0x88, 0x87, 0x85, 0x82, 0x81, 0x80,
			0x80, 0x7e, 0x7b, 0x79, 0x79, 0x79, 0x78, 0x78, 0x79, 0x7b, 0x7c,
			0x7c, 0x7c, 0x7e, 0x81, 0x83, 0x83, 0x84, 0x85, 0x86, 0x86, 0x86,
			0x85, 0x85, 0x84, 0x82, 0x80, 0x80, 0x80, 0x7f, 0x7c, 0x7a, 0x7a,
			0x7b, 0x7b, 0x7a, 0x7a, 0x7b, 0x7d, 0x7d, 0x7d, 0x7f, 0x81, 0x82,
			0x82, 0x83, 0x84, 0x85, 0x85, 0x84, 0x83, 0x84, 0x84, 0x82, 0x80,
			0x7f, 0x80, 0x80, 0x7e, 0x7c, 0x7b, 0x7c, 0x7c, 0x7c, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7d, 0x7e, 0x80, 0x81, 0x81, 0x81, 0x82, 0x83, 0x84,
			0x83, 0x82, 0x82, 0x82, 0x82, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7d,
			0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f,
			0x80, 0x80, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x81, 0x81, 0x81,
			0x81, 0x81, 0x80, 0x80, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x81, 0x81,
			0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7f, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x7f, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
		},
		{ // 9
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80,
			0x81, 0x81, 0x81, 0x81, 0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81,
			0x81, 0x80, 0x7f, 0x7f, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7b, 0x7b,
			0x7b, 0x7b, 0x7c, 0x7c, 0x7d, 0x7d, 0x7e, 0x7f, 0x7f, 0x80, 0x81,
			0x82, 0x82, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x82, 0x82, 0x81,
			0x80, 0x7f, 0x7e, 0x7e, 0x7d, 0x7d, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c,
			0x7c, 0x7d, 0x7e, 0x7e, 0x7f, 0x80, 0x80, 0x81, 0x81, 0x82, 0x82,
			0x82, 0x82, 0x82, 0x82, 0x82, 0x81, 0x81, 0x80, 0x80, 0x7f, 0x7f,
			0x7e, 0x7e, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7e,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
			0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x7f,
			0x80, 0x80, 0x80, 0x81, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x81,
			0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x7d,
			0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7d, 0x7e, 0x7e, 0x7f, 0x80,
			0x7f, 0x81, 0x7d, 0x7f, 0x7e, 0x7f, 0x81, 0x80, 0x81, 0x80, 0x80,
			0x7f, 0x80, 0x82, 0x81, 0x82, 0x82, 0x80, 0x81, 0x7f, 0x81, 0x7f,
			0x82, 0x7f, 0x80, 0x7f, 0x7c, 0x7e, 0x7e, 0x7e, 0x7d, 0x7e, 0x7c,
			0x7c, 0x7c, 0x7d, 0x7b, 0x80, 0x7c, 0x7e, 0x7d, 0x7e, 0x7c, 0x7f,
			0x7f, 0x7f, 0x81, 0x7f, 0x7f, 0x80, 0x80, 0x7f, 0x82, 0x80, 0x80,
			0x80, 0x81, 0x7e, 0x81, 0x80, 0x7f, 0x80, 0x80, 0x7e, 0x7f, 0x80,
			0x7e, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x81, 0x80, 0x81,
			0x80, 0x81, 0x80, 0x81, 0x80, 0x80, 0x81, 0x80, 0x7f, 0x82, 0x7e,
			0x80, 0x80, 0x7e, 0x80, 0x7e, 0x80, 0x7d, 0x80, 0x7d, 0x80, 0x7e,
			0x80, 0x7d, 0x81, 0x7e, 0x7d, 0x81, 0x7c, 0x80, 0x7f, 0x7e, 0x80,
			0x7d, 0x81, 0x7e, 0x7d, 0x82, 0x7b, 0x81, 0x7f, 0x7f, 0x7d, 0x83,
			0x7e, 0x7d, 0x85, 0x7b, 0x82, 0x81, 0x7f, 0x7f, 0x81, 0x82, 0x7a,
			0x87, 0x7c, 0x82, 0x80, 0x82, 0x7d, 0x80, 0x85, 0x76, 0x8a, 0x79,
			0x83, 0x7d, 0x81, 0x80, 0x7a, 0x87, 0x78, 0x80, 0x83, 0x7a, 0x7f,
			0x82, 0x7b, 0x7d, 0x83, 0x7c, 0x7b, 0x86, 0x78, 0x7f, 0x81, 0x7d,
			0x7b, 0x83, 0x7c, 0x7c, 0x83, 0x7d, 0x7c, 0x83, 0x7e, 0x7c, 0x84,
			0x7b, 0x82, 0x7e, 0x83, 0x7c, 0x84, 0x7e, 0x82, 0x7e, 0x82, 0x82,
			0x7b, 0x87, 0x7c, 0x80, 0x82, 0x7f, 0x7e, 0x84, 0x7e, 0x7f, 0x80,
			0x83, 0x79, 0x84, 0x80, 0x79, 0x86, 0x7c, 0x7d, 0x83, 0x7d, 0x7d,
			0x80, 0x80, 0x79, 0x84, 0x7b, 0x7e, 0x80, 0x7c, 0x7f, 0x7e, 0x80,
			0x7b, 0x82, 0x7b, 0x81, 0x7d, 0x81, 0x7c, 0x81, 0x7c, 0x7f, 0x81,
			0x7c, 0x80, 0x82, 0x7b, 0x83, 0x7e, 0x7e, 0x82, 0x7c, 0x83, 0x7c,
			0x85, 0x7a, 0x85, 0x7e, 0x81, 0x81, 0x81, 0x82, 0x7d, 0x86, 0x7a,
			0x85, 0x7f, 0x80, 0x84, 0x7b, 0x83, 0x7e, 0x7e, 0x81, 0x7b, 0x82,
			0x7c, 0x7f, 0x7f, 0x7b, 0x81, 0x79, 0x84, 0x78, 0x84, 0x7a, 0x7e,
			0x80, 0x7a, 0x84, 0x7a, 0x84, 0x7d, 0x7c, 0x81, 0x7c, 0x7c, 0x82,
			0x7b, 0x82, 0x7b, 0x84, 0x78, 0x86, 0x79, 0x82, 0x81, 0x7f, 0x80,
			0x7f, 0x86, 0x75, 0x8c, 0x7b, 0x81, 0x84, 0x7d, 0x81, 0x81, 0x7b,
			0x83, 0x7d, 0x82, 0x7d, 0x83, 0x82, 0x7c, 0x84, 0x7e, 0x80, 0x82,
			0x7b, 0x89, 0x78, 0x83, 0x7f, 0x7e, 0x80, 0x7b, 0x87, 0x75, 0x88,
			0x75, 0x82, 0x7d, 0x7c, 0x80, 0x82, 0x7e, 0x7f, 0x84, 0x7b, 0x81,
			0x7f, 0x80, 0x7f, 0x81, 0x80, 0x7b, 0x86, 0x76, 0x85, 0x7b, 0x7f,
			0x83, 0x77, 0x84, 0x7a, 0x80, 0x7a, 0x88, 0x78, 0x88, 0x7c, 0x86,
			0x7c, 0x84, 0x80, 0x83, 0x82, 0x7f, 0x88, 0x7a, 0x8a, 0x7c, 0x85,
			0x80, 0x84, 0x78, 0x88, 0x7a, 0x7e, 0x84, 0x7b, 0x81, 0x7c, 0x80,
			0x7c, 0x7c, 0x80, 0x7b, 0x80, 0x7a, 0x7f, 0x7c, 0x7c, 0x84, 0x7b,
			0x85, 0x7f, 0x81, 0x7c, 0x85, 0x7a, 0x86, 0x7f, 0x82, 0x82, 0x7f,
			0x81, 0x7f, 0x80, 0x7e, 0x84, 0x7b, 0x81, 0x7f, 0x7a, 0x80, 0x80,
			0x7a, 0x88, 0x7a, 0x7f, 0x81, 0x7a, 0x7c, 0x82, 0x78, 0x80, 0x7f,
			0x7a, 0x7f, 0x7a, 0x7c, 0x81, 0x75, 0x80, 0x82, 0x73, 0x82, 0x7d,
			0x7a, 0x7d, 0x84, 0x77, 0x84, 0x7a, 0x7e, 0x81, 0x7a, 0x7c, 0x84,
			0x7a, 0x80, 0x86, 0x7a, 0x84, 0x82, 0x7b, 0x84, 0x82, 0x78, 0x8a,
			0x78, 0x7e, 0x85, 0x76, 0x82, 0x80, 0x7c, 0x7f, 0x85, 0x76, 0x82,
			0x83, 0x73, 0x8d, 0x7a, 0x7d, 0x89, 0x76, 0x81, 0x7d, 0x7e, 0x7c,
			0x7d, 0x83, 0x76, 0x85, 0x75, 0x89, 0x77, 0x81, 0x88, 0x76, 0x87,
			0x7d, 0x80, 0x7f, 0x85, 0x7a, 0x84, 0x84, 0x72, 0x89, 0x7f, 0x6f,
			0x8e, 0x73, 0x7a, 0x82, 0x79, 0x78, 0x87, 0x76, 0x80, 0x86, 0x77,
			0x85, 0x82, 0x7c, 0x86, 0x81, 0x7b, 0x8c, 0x74, 0x89, 0x7b, 0x81,
			0x81, 0x7d, 0x81, 0x7c, 0x84, 0x75, 0x8b, 0x7b, 0x7c, 0x8b, 0x7c,
			0x7e, 0x87, 0x80, 0x7c, 0x8b, 0x78, 0x84, 0x80, 0x78, 0x84, 0x73,
			0x83, 0x73, 0x80, 0x76, 0x7b, 0x78, 0x79, 0x80, 0x75, 0x87, 0x78,
			0x83, 0x7c, 0x85, 0x77, 0x87, 0x7a, 0x80, 0x81, 0x7e, 0x7f, 0x7f,
			0x82, 0x7b, 0x8b, 0x76, 0x8e, 0x7c, 0x83, 0x84, 0x82, 0x7e, 0x85,
			0x7e, 0x7c, 0x85, 0x77, 0x83, 0x7d, 0x80, 0x7a, 0x87, 0x77, 0x86,
			0x7f, 0x7c, 0x89, 0x73, 0x8c, 0x74, 0x84, 0x7e, 0x7a, 0x85, 0x76,
			0x88, 0x76, 0x88, 0x7b, 0x81, 0x86, 0x79, 0x89, 0x7d, 0x82, 0x80,
			0x84, 0x7a, 0x81, 0x81, 0x74, 0x84, 0x77, 0x79, 0x7c, 0x77, 0x77,
			0x78, 0x77, 0x76, 0x77, 0x77, 0x78, 0x76, 0x79, 0x7c, 0x77, 0x82,
			0x82, 0x80, 0x8e, 0x88, 0x91, 0x91, 0x97, 0x98, 0x98, 0xa0, 0x98,
			0x9b, 0x9a, 0x93, 0x8f, 0x8b, 0x80, 0x7c, 0x72, 0x6e, 0x62, 0x5f,
			0x5b, 0x50, 0x57, 0x4c, 0x54, 0x51, 0x56, 0x58, 0x60, 0x66, 0x6e,
			0x7c, 0x7d, 0x94, 0x91, 0xa3, 0xa8, 0xae, 0xb9, 0xb6, 0xbe, 0xb8,
			0xb7, 0xb1, 0xab, 0x9e, 0x98, 0x90, 0x80, 0x80, 0x71, 0x70, 0x69,
			0x66, 0x64, 0x5c, 0x5f, 0x57, 0x56, 0x4f, 0x54, 0x47, 0x4e, 0x4d,
			0x49, 0x55, 0x58, 0x62, 0x6d, 0x84, 0x87, 0xa2, 0xaa, 0xb4, 0xc3,
			0xc3, 0xc9, 0xc4, 0xc3, 0xb4, 0xb0, 0x9e, 0x97, 0x88, 0x7c, 0x7a,
			0x6d, 0x6d, 0x6e, 0x6b, 0x6c, 0x74, 0x6c, 0x72, 0x6d, 0x68, 0x66,
			0x5d, 0x59, 0x55, 0x4e, 0x48, 0x4f, 0x47, 0x52, 0x63, 0x60, 0x82,
			0x86, 0x98, 0xaf, 0xaf, 0xc5, 0xc4, 0xc8, 0xc8, 0xbf, 0xb4, 0xa9,
			0x99, 0x89, 0x82, 0x70, 0x6f, 0x67, 0x66, 0x65, 0x6f, 0x70, 0x72,
			0x86, 0x71, 0x87, 0x7b, 0x73, 0x77, 0x65, 0x61, 0x5a, 0x50, 0x46,
			0x4b, 0x44, 0x4a, 0x61, 0x61, 0x77, 0x94, 0x8d, 0xb4, 0xb7, 0xbd,
			0xce, 0xc5, 0xc4, 0xbf, 0xb3, 0xa1, 0x9e, 0x83, 0x80, 0x76, 0x66,
			0x6a, 0x62, 0x64, 0x6e, 0x71, 0x7e, 0x83, 0x86, 0x89, 0x82, 0x80,
			0x76, 0x6e, 0x66, 0x5e, 0x51, 0x50, 0x47, 0x3d, 0x49, 0x48, 0x4e,
			0x6d, 0x73, 0x84, 0xa4, 0xa4, 0xb9, 0xc4, 0xc4, 0xc8, 0xc7, 0xbb,
			0xb6, 0xa6, 0x97, 0x8b, 0x7a, 0x72, 0x6c, 0x66, 0x66, 0x69, 0x69,
			0x75, 0x7a, 0x81, 0x8c, 0x8b, 0x8c, 0x90, 0x81, 0x7f, 0x74, 0x67,
			0x63, 0x57, 0x52, 0x4c, 0x49, 0x43, 0x47, 0x4e, 0x52, 0x61, 0x7f,
			0x78, 0x9f, 0xae, 0xa6, 0xc9, 0xbc, 0xbf, 0xc3, 0xb8, 0xad, 0xa8,
			0x97, 0x89, 0x82, 0x73, 0x71, 0x6b, 0x69, 0x71, 0x71, 0x77, 0x80,
			0x82, 0x89, 0x8f, 0x8e, 0x8d, 0x8b, 0x7d, 0x76, 0x6f, 0x5e, 0x5d,
			0x55, 0x53, 0x51, 0x4b, 0x52, 0x4d, 0x4e, 0x63, 0x56, 0x75, 0x89,
			0x75, 0xb1, 0xa1, 0xad, 0xc7, 0xb5, 0xc1, 0xbc, 0xb5, 0xa5, 0xa5,
			0x90, 0x82, 0x82, 0x6f, 0x72, 0x70, 0x70, 0x75, 0x78, 0x7f, 0x85,
			0x87, 0x8c, 0x8f, 0x8b, 0x88, 0x87, 0x79, 0x75, 0x6e, 0x63, 0x62,
			0x5e, 0x5b, 0x5e, 0x5d, 0x59, 0x5e, 0x58, 0x54, 0x5c, 0x59, 0x64,
			0x89, 0x74, 0x9b, 0xb0, 0x99, 0xc4, 0xb8, 0xb7, 0xc0, 0xae, 0xa5,
			0x9f, 0x93, 0x81, 0x7e, 0x77, 0x6c, 0x72, 0x71, 0x76, 0x7c, 0x81,
			0x88, 0x8b, 0x8d, 0x8a, 0x85, 0x83, 0x79, 0x76, 0x74, 0x71, 0x6b,
			0x69, 0x6c, 0x67, 0x6c, 0x65, 0x68, 0x66, 0x63, 0x5e, 0x57, 0x5a,
			0x5c, 0x4f, 0x7d, 0x7a, 0x81, 0xb7, 0x9e, 0xb8, 0xc3, 0xbc, 0xbe,
			0xb5, 0xab, 0x97, 0x91, 0x7d, 0x70, 0x76, 0x6a, 0x6e, 0x77, 0x7a,
			0x84, 0x86, 0x8e, 0x90, 0x8d, 0x8e, 0x83, 0x79, 0x74, 0x6e, 0x69,
			0x6f, 0x6c, 0x71, 0x77, 0x71, 0x79, 0x74, 0x71, 0x71, 0x65, 0x66,
			0x54, 0x5a, 0x4a, 0x50, 0x59, 0x5d, 0x92, 0x7a, 0xb0, 0xbb, 0xad,
			0xca, 0xb7, 0xbb, 0xae, 0x9f, 0x93, 0x7e, 0x7e, 0x6e, 0x6f, 0x78,
			0x78, 0x85, 0x89, 0x91, 0x93, 0x91, 0x92, 0x8a, 0x82, 0x79, 0x71,
			0x69, 0x64, 0x6c, 0x6b, 0x78, 0x7a, 0x80, 0x7f, 0x7f, 0x7d, 0x73,
			0x6e, 0x62, 0x5a, 0x5b, 0x50, 0x51, 0x49, 0x50, 0x64, 0x6f, 0x9c,
			0x97, 0xbc, 0xc3, 0xb6, 0xc2, 0xab, 0xa6, 0x99, 0x8a, 0x83, 0x74,
			0x7c, 0x79, 0x7a, 0x89, 0x87, 0x92, 0x93, 0x93, 0x8d, 0x85, 0x80,
			0x78, 0x71, 0x71, 0x69, 0x6c, 0x6f, 0x75, 0x7b, 0x80, 0x89, 0x82,
			0x80, 0x7d, 0x73, 0x6c, 0x6b, 0x64, 0x60, 0x57, 0x64, 0x5b, 0x61,
			0x5f, 0x5b, 0x6a, 0x7b, 0x9e, 0x96, 0xb3, 0xb3, 0xae, 0xaf, 0xa0,
			0x9d, 0x8e, 0x8c, 0x88, 0x82, 0x8a, 0x87, 0x8c, 0x8d, 0x8c, 0x8e,
			0x86, 0x8b, 0x80, 0x7c, 0x7c, 0x74, 0x74, 0x73, 0x78, 0x79, 0x76,
			0x7c, 0x7e, 0x80, 0x7e, 0x77, 0x78, 0x73, 0x6e, 0x69, 0x68, 0x6b,
			0x6a, 0x6e, 0x67, 0x66, 0x66, 0x65, 0x5a, 0x53, 0x65, 0x8b, 0x96,
			0x9a, 0xb7, 0xb5, 0xaf, 0xa4, 0xa3, 0x98, 0x89, 0x89, 0x88, 0x85,
			0x84, 0x8b, 0x91, 0x8f, 0x90, 0x8b, 0x86, 0x85, 0x7b, 0x79, 0x76,
			0x78, 0x77, 0x79, 0x78, 0x7c, 0x7e, 0x7d, 0x7a, 0x7b, 0x75, 0x76,
			0x70, 0x6f, 0x72, 0x70, 0x71, 0x71, 0x73, 0x6f, 0x6f, 0x68, 0x63,
			0x62, 0x61, 0x5f, 0x5d, 0x57, 0x92, 0xa1, 0xa6, 0xb8, 0xb9, 0xbc,
			0x97, 0x97, 0x90, 0x88, 0x81, 0x82, 0x91, 0x89, 0x92, 0x93, 0x94,
			0x96, 0x85, 0x86, 0x7a, 0x74, 0x73, 0x71, 0x74, 0x77, 0x7e, 0x7d,
			0x80, 0x7d, 0x7c, 0x78, 0x70, 0x7a, 0x79, 0x7a, 0x76, 0x75, 0x78,
			0x73, 0x73, 0x70, 0x70, 0x6b, 0x65, 0x5f, 0x5f, 0x61, 0x5a, 0x55,
			0x5e, 0x8a, 0xae, 0xa8, 0xaf, 0xb3, 0xb2, 0x98, 0x82, 0x86, 0x82,
			0x89, 0x85, 0x92, 0x9a, 0x98, 0x98, 0x91, 0x90, 0x84, 0x79, 0x73,
			0x73, 0x78, 0x79, 0x7d, 0x81, 0x83, 0x80, 0x7b, 0x77, 0x72, 0x73,
			0x73, 0x7b, 0x79, 0x7d, 0x83, 0x81, 0x84, 0x7a, 0x7c, 0x75, 0x71,
			0x70, 0x6d, 0x70, 0x6f, 0x6a, 0x69, 0x6b, 0x6e, 0x6f, 0x6c, 0x66,
			0x6e, 0x81, 0x91, 0xa5, 0xa8, 0xab, 0xa5, 0x9b, 0x91, 0x88, 0x8a,
			0x8a, 0x8e, 0x8f, 0x92, 0x94, 0x8f, 0x8a, 0x84, 0x82, 0x7b, 0x74,
			0x77, 0x7b, 0x7f, 0x7e, 0x7f, 0x7e, 0x7c, 0x78, 0x77, 0x74, 0x76,
			0x77, 0x81, 0x87, 0x88, 0x82, 0x77, 0x75, 0x6f, 0x70, 0x6c, 0x6f,
			0x71, 0x6f, 0x66, 0x62, 0x66, 0x6a, 0x64, 0x5a, 0x60, 0x74, 0xa3,
			0xb4, 0xb1, 0xa4, 0x9f, 0x9d, 0x85, 0x79, 0x7b, 0x90, 0x9a, 0x99,
			0x93, 0x96, 0x98, 0x90, 0x83, 0x77, 0x77, 0x79, 0x79, 0x79, 0x7c,
			0x82, 0x82, 0x7c, 0x79, 0x76, 0x75, 0x74, 0x76, 0x76, 0x7a, 0x7c,
			0x7f, 0x82, 0x7f, 0x84, 0x7f, 0x82, 0x81, 0x7e, 0x7b, 0x71, 0x75,
			0x74, 0x7a, 0x78, 0x74, 0x77, 0x71, 0x6e, 0x65, 0x66, 0x6b, 0x6e,
			0x6f, 0x6e, 0x7c, 0x90, 0xa8, 0xb1, 0xaa, 0x9d, 0x8f, 0x89, 0x83,
			0x82, 0x88, 0x92, 0x99, 0x99, 0x92, 0x8c, 0x85, 0x80, 0x7d, 0x7b,
			0x7c, 0x7b, 0x7e, 0x7f, 0x7f, 0x7c, 0x7a, 0x79, 0x79, 0x77, 0x74,
			0x76, 0x78, 0x7c, 0x7b, 0x7c, 0x81, 0x86, 0x88, 0x82, 0x7c, 0x75,
			0x73, 0x70, 0x72, 0x77, 0x79, 0x79, 0x71, 0x6e, 0x68, 0x69, 0x6b,
			0x69, 0x64, 0x60, 0x75, 0x9a, 0xb8, 0xba, 0xa5, 0x8f, 0x86, 0x83,
			0x7f, 0x7d, 0x85, 0x95, 0xa1, 0x9f, 0x93, 0x88, 0x84, 0x83, 0x7d,
			0x77, 0x76, 0x7d, 0x83, 0x83, 0x7f, 0x7c, 0x7b, 0x7c, 0x7a, 0x76,
			0x73, 0x74, 0x7b, 0x7d, 0x7c, 0x77, 0x77, 0x79, 0x7a, 0x7a, 0x79,
			0x7b, 0x7d, 0x83, 0x87, 0x8c, 0x8a, 0x84, 0x7c, 0x74, 0x73, 0x74,
			0x7b, 0x7e, 0x7f, 0x7c, 0x76, 0x6f, 0x69, 0x6a, 0x6f, 0x72, 0x72,
			0x6e, 0x75, 0x87, 0xa5, 0xb4, 0xac, 0x95, 0x7e, 0x7c, 0x7d, 0x84,
			0x83, 0x8a, 0x94, 0x9b, 0x99, 0x8b, 0x7f, 0x76, 0x79, 0x7b, 0x7c,
			0x7c, 0x7c, 0x80, 0x82, 0x81, 0x7c, 0x78, 0x77, 0x78, 0x79, 0x78,
			0x77, 0x78, 0x79, 0x7d, 0x7d, 0x7b, 0x7a, 0x7d, 0x80, 0x80, 0x7c,
			0x7c, 0x7e, 0x81, 0x82, 0x83, 0x8b, 0x8e, 0x8c, 0x7a, 0x6f, 0x6c,
			0x7a, 0x86, 0x89, 0x84, 0x7c, 0x7b, 0x77, 0x75, 0x6d, 0x6c, 0x6e,
			0x76, 0x78, 0x72, 0x69, 0x6f, 0x8d, 0xae, 0xbc, 0xa6, 0x85, 0x6f,
			0x73, 0x82, 0x89, 0x8a, 0x86, 0x8d, 0x94, 0x95, 0x8a, 0x7a, 0x75,
			0x76, 0x7e, 0x7f, 0x7c, 0x7a, 0x7a, 0x7f, 0x82, 0x81, 0x7c, 0x76,
			0x76, 0x79, 0x7c, 0x7a, 0x78, 0x78, 0x7b, 0x7f, 0x80, 0x7f, 0x7b,
			0x7a, 0x7c, 0x7e, 0x7f, 0x7f, 0x80, 0x81, 0x82, 0x82, 0x80, 0x7f,
			0x7f, 0x81, 0x81, 0x80, 0x7f, 0x80, 0x83, 0x83, 0x83, 0x82, 0x81,
			0x82, 0x82, 0x83, 0x81, 0x81, 0x80, 0x85, 0x8a, 0x8a, 0x89, 0x82,
			0x7e, 0x76, 0x76, 0x75, 0x7a, 0x7e, 0x7f, 0x7e, 0x79, 0x75, 0x70,
			0x6f, 0x6e, 0x6f, 0x71, 0x75, 0x76, 0x75, 0x71, 0x78, 0x87, 0x9d,
			0xa7, 0xa1, 0x8f, 0x7a, 0x74, 0x79, 0x85, 0x8c, 0x8c, 0x8a, 0x8a,
			0x8d, 0x8b, 0x85, 0x7a, 0x74, 0x74, 0x7a, 0x81, 0x83, 0x83, 0x80,
			0x7f, 0x7f, 0x7e, 0x7b, 0x76, 0x71, 0x74, 0x79, 0x7f, 0x81, 0x7f,
			0x7d, 0x7a, 0x7a, 0x7c, 0x7c, 0x7d, 0x7b, 0x7d, 0x7f, 0x82, 0x83,
			0x81, 0x7f, 0x7d, 0x7e, 0x80, 0x82, 0x81, 0x7f, 0x7e, 0x80, 0x82,
			0x84, 0x82, 0x81, 0x7f, 0x7f, 0x7f, 0x82, 0x80, 0x81, 0x7e, 0x81,
			0x80, 0x81, 0x7e, 0x83, 0x80, 0x83, 0x7f, 0x87, 0x93, 0x94, 0x92,
			0x76, 0x6e, 0x64, 0x77, 0x7f, 0x89, 0x82, 0x78, 0x6e, 0x66, 0x6d,
			0x6c, 0x73, 0x71, 0x70, 0x6e, 0x69, 0x76, 0x8c, 0xa8, 0xb7, 0xa8,
			0x8f, 0x6f, 0x69, 0x6e, 0x86, 0x93, 0x99, 0x91, 0x88, 0x88, 0x87,
			0x89, 0x7e, 0x76, 0x6d, 0x70, 0x79, 0x85, 0x8b, 0x87, 0x80, 0x79,
			0x79, 0x7a, 0x7a, 0x75, 0x72, 0x73, 0x7a, 0x82, 0x86, 0x84, 0x7d,
			0x77, 0x76, 0x78, 0x7c, 0x7e, 0x7d, 0x7d, 0x7d, 0x80, 0x83, 0x84,
			0x81, 0x7e, 0x7b, 0x7c, 0x7f, 0x81, 0x81, 0x80, 0x7e, 0x7e, 0x7f,
			0x81, 0x82, 0x81, 0x81, 0x80, 0x81, 0x80, 0x82, 0x82, 0x82, 0x82,
			0x80, 0x81, 0x81, 0x82, 0x82, 0x81, 0x7f, 0x7e, 0x7f, 0x80, 0x82,
			0x82, 0x80, 0x7f, 0x7e, 0x7f, 0x80, 0x81, 0x80, 0x7e, 0x7e, 0x7f,
			0x84, 0x86, 0x89, 0x86, 0x81, 0x7b, 0x78, 0x7b, 0x7d, 0x82, 0x81,
			0x80, 0x7b, 0x79, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75, 0x76, 0x75,
			0x77, 0x76, 0x76, 0x74, 0x74, 0x79, 0x84, 0x95, 0xa2, 0xa8, 0x9c,
			0x8c, 0x78, 0x72, 0x75, 0x82, 0x8e, 0x92, 0x8f, 0x88, 0x85, 0x83,
			0x83, 0x80, 0x7c, 0x76, 0x73, 0x74, 0x7a, 0x81, 0x86, 0x84, 0x80,
			0x79, 0x75, 0x74, 0x76, 0x79, 0x7b, 0x7c, 0x7c, 0x7e, 0x7f, 0x81,
			0x7f, 0x7e, 0x7d, 0x7d, 0x7d, 0x7f, 0x80, 0x82, 0x81, 0x81, 0x7f,
			0x80, 0x81, 0x81, 0x82, 0x81, 0x86, 0x87, 0x8b, 0x84, 0x7f, 0x77,
			0x76, 0x78, 0x7d, 0x84, 0x84, 0x82, 0x7a, 0x77, 0x74, 0x77, 0x79,
			0x79, 0x78, 0x76, 0x76, 0x76, 0x79, 0x78, 0x76, 0x72, 0x72, 0x7d,
			0x8f, 0xa4, 0xab, 0xa6, 0x91, 0x7c, 0x6f, 0x70, 0x7c, 0x89, 0x92,
			0x8f, 0x88, 0x7f, 0x7d, 0x7f, 0x83, 0x81, 0x7c, 0x75, 0x72, 0x74,
			0x7b, 0x83, 0x87, 0x86, 0x80, 0x79, 0x75, 0x75, 0x78, 0x7d, 0x7f,
			0x80, 0x7e, 0x7e, 0x7f, 0x80, 0x82, 0x81, 0x80, 0x7c, 0x7f, 0x82,
			0x88, 0x89, 0x86, 0x80, 0x79, 0x78, 0x79, 0x80, 0x83, 0x85, 0x80,
			0x7b, 0x76, 0x76, 0x77, 0x79, 0x7a, 0x78, 0x76, 0x73, 0x73, 0x76,
			0x77, 0x78, 0x74, 0x76, 0x80, 0x93, 0xa7, 0xaf, 0xaa, 0x94, 0x7e,
			0x6d, 0x6e, 0x78, 0x88, 0x93, 0x93, 0x8c, 0x82, 0x7e, 0x7d, 0x80,
			0x81, 0x7e, 0x79, 0x72, 0x72, 0x75, 0x7e, 0x85, 0x88, 0x84, 0x7d,
			0x77, 0x75, 0x76, 0x7a, 0x7d, 0x80, 0x80, 0x7f, 0x7e, 0x7d, 0x80,
			0x81, 0x88, 0x89, 0x8c, 0x85, 0x7f, 0x76, 0x72, 0x76, 0x7b, 0x85,
			0x86, 0x87, 0x7c, 0x77, 0x71, 0x71, 0x73, 0x73, 0x76, 0x73, 0x76,
			0x72, 0x72, 0x6f, 0x75, 0x84, 0x98, 0xad, 0xb2, 0xac, 0x94, 0x7f,
			0x6d, 0x6d, 0x7a, 0x88, 0x94, 0x94, 0x8f, 0x84, 0x80, 0x7e, 0x81,
			0x82, 0x7f, 0x79, 0x72, 0x70, 0x74, 0x7d, 0x85, 0x89, 0x86, 0x80,
			0x77, 0x73, 0x74, 0x78, 0x7e, 0x81, 0x84, 0x84, 0x86, 0x85, 0x84,
			0x80, 0x7c, 0x78, 0x77, 0x7a, 0x7d, 0x81, 0x82, 0x81, 0x7d, 0x7a,
			0x77, 0x75, 0x74, 0x72, 0x71, 0x72, 0x72, 0x76, 0x75, 0x74, 0x70,
			0x77, 0x85, 0x9d, 0xb0, 0xb7, 0xaf, 0x96, 0x7f, 0x6c, 0x6d, 0x75,
			0x86, 0x91, 0x96, 0x92, 0x89, 0x84, 0x80, 0x80, 0x7f, 0x7d, 0x78,
			0x74, 0x70, 0x73, 0x78, 0x80, 0x86, 0x87, 0x85, 0x7f, 0x7b, 0x78,
			0x7b, 0x7d, 0x81, 0x82, 0x80, 0x7d, 0x7a, 0x7b, 0x7c, 0x7f, 0x7f,
			0x7e, 0x7b, 0x78, 0x74, 0x72, 0x72, 0x71, 0x73, 0x74, 0x76, 0x76,
			0x73, 0x70, 0x6f, 0x7a, 0x8d, 0xa8, 0xb9, 0xbe, 0xae, 0x94, 0x7a,
			0x69, 0x6b, 0x76, 0x88, 0x93, 0x96, 0x8f, 0x87, 0x7f, 0x7c, 0x7d,
			0x7e, 0x7e, 0x7b, 0x76, 0x72, 0x73, 0x78, 0x80, 0x89, 0x8f, 0x8f,
			0x88, 0x7d, 0x72, 0x6c, 0x6d, 0x74, 0x7e, 0x84, 0x86, 0x80, 0x79,
			0x72, 0x6e, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x6d, 0x6c, 0x6c, 0x78,
			0x8c, 0xa9, 0xbe, 0xc6, 0xb9, 0x9d, 0x81, 0x6b, 0x69, 0x71, 0x83,
			0x90, 0x98, 0x95, 0x8f, 0x87, 0x82, 0x7f, 0x7e, 0x7c, 0x79, 0x75,
			0x73, 0x77, 0x7e, 0x88, 0x8c, 0x8c, 0x84, 0x79, 0x6f, 0x6b, 0x6d,
			0x72, 0x78, 0x79, 0x77, 0x71, 0x6d, 0x6a, 0x6c, 0x6e, 0x6f, 0x6b,
			0x67, 0x6b, 0x7d, 0x9c, 0xbb, 0xcd, 0xc8, 0xb1, 0x8f, 0x74, 0x68,
			0x6d, 0x7b, 0x89, 0x93, 0x93, 0x8f, 0x8b, 0x89, 0x88, 0x87, 0x83,
			0x7d, 0x77, 0x72, 0x73, 0x79, 0x82, 0x88, 0x89, 0x84, 0x7c, 0x75,
			0x70, 0x71, 0x72, 0x74, 0x73, 0x71, 0x6d, 0x6a, 0x6a, 0x6b, 0x6c,
			0x69, 0x66, 0x69, 0x77, 0x91, 0xaf, 0xc6, 0xca, 0xb9, 0x9c, 0x7e,
			0x6e, 0x6d, 0x79, 0x85, 0x8e, 0x90, 0x8d, 0x8a, 0x8a, 0x8d, 0x8e,
			0x8a, 0x82, 0x79, 0x71, 0x6f, 0x70, 0x7a, 0x82, 0x8c, 0x8c, 0x89,
			0x7d, 0x72, 0x6c, 0x68, 0x6d, 0x6e, 0x74, 0x71, 0x70, 0x69, 0x67,
			0x65, 0x64, 0x63, 0x66, 0x73, 0x8a, 0xa9, 0xc0, 0xca, 0xbe, 0xa7,
			0x89, 0x76, 0x6e, 0x75, 0x7f, 0x8a, 0x8d, 0x8c, 0x89, 0x89, 0x8e,
			0x91, 0x91, 0x8a, 0x7f, 0x73, 0x6d, 0x6d, 0x77, 0x80, 0x8a, 0x89,
			0x87, 0x7b, 0x74, 0x6e, 0x6f, 0x70, 0x71, 0x71, 0x6c, 0x6a, 0x64,
			0x65, 0x61, 0x63, 0x60, 0x69, 0x78, 0x96, 0xb3, 0xc9, 0xcc, 0xba,
			0x9f, 0x80, 0x72, 0x70, 0x7c, 0x86, 0x8d, 0x8b, 0x86, 0x83, 0x85,
			0x8d, 0x93, 0x96, 0x8d, 0x82, 0x72, 0x6c, 0x6a, 0x75, 0x80, 0x8a,
			0x8c, 0x86, 0x7d, 0x71, 0x6f, 0x6c, 0x73, 0x72, 0x74, 0x6d, 0x68,
			0x63, 0x61, 0x61, 0x61, 0x62, 0x66, 0x78, 0x92, 0xb1, 0xc7, 0xcd,
			0xbe, 0xa4, 0x86, 0x74, 0x70, 0x79, 0x85, 0x8d, 0x8c, 0x87, 0x81,
			0x81, 0x87, 0x90, 0x95, 0x92, 0x87, 0x79, 0x6e, 0x6d, 0x74, 0x7f,
			0x88, 0x88, 0x82, 0x77, 0x6f, 0x6d, 0x72, 0x78, 0x7b, 0x78, 0x6f,
			0x65, 0x5f, 0x5d, 0x5f, 0x61, 0x61, 0x65, 0x71, 0x8b, 0xa8, 0xc3,
			0xce, 0xc5, 0xad, 0x8e, 0x79, 0x70, 0x77, 0x82, 0x8d, 0x8f, 0x8a,
			0x82, 0x7e, 0x82, 0x8a, 0x92, 0x93, 0x8c, 0x80, 0x74, 0x6f, 0x73,
			0x7d, 0x87, 0x8b, 0x85, 0x79, 0x6d, 0x67, 0x6a, 0x73, 0x7a, 0x7b,
			0x73, 0x69, 0x5f, 0x5b, 0x5b, 0x5e, 0x61, 0x65, 0x72, 0x85, 0xa4,
			0xbb, 0xcc, 0xc7, 0xb6, 0x9b, 0x84, 0x78, 0x77, 0x80, 0x88, 0x8e,
			0x8c, 0x87, 0x81, 0x82, 0x85, 0x8b, 0x8c, 0x8a, 0x83, 0x7a, 0x73,
			0x70, 0x77, 0x82, 0x8e, 0x91, 0x87, 0x76, 0x63, 0x5e, 0x61, 0x71,
			0x7a, 0x7f, 0x76, 0x69, 0x5d, 0x56, 0x5a, 0x5d, 0x66, 0x6b, 0x79,
			0x87, 0xa0, 0xb5, 0xc4, 0xc4, 0xb7, 0xa2, 0x8a, 0x7e, 0x79, 0x81,
			0x87, 0x8e, 0x8d, 0x8a, 0x85, 0x82, 0x84, 0x86, 0x88, 0x86, 0x82,
			0x7b, 0x76, 0x73, 0x78, 0x81, 0x8c, 0x90, 0x87, 0x78, 0x65, 0x5e,
			0x5d, 0x6a, 0x73, 0x79, 0x73, 0x69, 0x5e, 0x58, 0x5b, 0x60, 0x6a,
			0x70, 0x7c, 0x88, 0x9d, 0xae, 0xbc, 0xbe, 0xb5, 0xa4, 0x91, 0x86,
			0x81, 0x85, 0x89, 0x8e, 0x8d, 0x8a, 0x87, 0x85, 0x84, 0x85, 0x85,
			0x83, 0x80, 0x7a, 0x78, 0x75, 0x79, 0x80, 0x88, 0x8c, 0x86, 0x7b,
			0x6c, 0x64, 0x61, 0x67, 0x6e, 0x73, 0x6e, 0x66, 0x5d, 0x5a, 0x5d,
			0x64, 0x6d, 0x74, 0x79, 0x83, 0x91, 0xa4, 0xb3, 0xbb, 0xb8, 0xab,
			0x9a, 0x8b, 0x85, 0x85, 0x8a, 0x8c, 0x8e, 0x8a, 0x88, 0x85, 0x85,
			0x85, 0x85, 0x84, 0x80, 0x7d, 0x78, 0x77, 0x75, 0x7c, 0x81, 0x88,
			0x87, 0x82, 0x76, 0x6a, 0x64, 0x63, 0x69, 0x6b, 0x6e, 0x66, 0x61,
			0x5b, 0x5d, 0x62, 0x6c, 0x75, 0x7b, 0x83, 0x8c, 0x9a, 0xa8, 0xb2,
			0xb4, 0xad, 0xa0, 0x92, 0x8a, 0x87, 0x89, 0x8d, 0x8d, 0x8c, 0x88,
			0x85, 0x84, 0x85, 0x86, 0x85, 0x82, 0x7e, 0x79, 0x77, 0x76, 0x79,
			0x7d, 0x81, 0x83, 0x83, 0x7e, 0x77, 0x6f, 0x6a, 0x68, 0x6a, 0x6b,
			0x6a, 0x65, 0x60, 0x5d, 0x60, 0x65, 0x6d, 0x74, 0x7b, 0x7e, 0x86,
			0x90, 0x9d, 0xaa, 0xaf, 0xae, 0xa2, 0x98, 0x8c, 0x89, 0x89, 0x8d,
			0x8e, 0x8d, 0x88, 0x84, 0x83, 0x84, 0x86, 0x87, 0x86, 0x80, 0x7d,
			0x78, 0x78, 0x78, 0x7b, 0x7c, 0x7d, 0x7c, 0x7b, 0x7a, 0x78, 0x76,
			0x73, 0x71, 0x6d, 0x6c, 0x6a, 0x69, 0x68, 0x66, 0x66, 0x67, 0x6a,
			0x6e, 0x73, 0x7a, 0x81, 0x8a, 0x93, 0x9e, 0xa5, 0xa7, 0xa4, 0x9d,
			0x96, 0x8e, 0x8c, 0x8a, 0x8c, 0x8a, 0x88, 0x85, 0x83, 0x82, 0x83,
			0x85, 0x85, 0x85, 0x82, 0x7f, 0x7b, 0x7a, 0x78, 0x78, 0x78, 0x77,
			0x77, 0x77, 0x77, 0x78, 0x77, 0x77, 0x76, 0x75, 0x74, 0x73, 0x72,
			0x72, 0x72, 0x71, 0x72, 0x72, 0x73, 0x74, 0x76, 0x78, 0x7b, 0x7d,
			0x80, 0x82, 0x88, 0x8f, 0x97, 0x9e, 0xa0, 0x9f, 0x99, 0x93, 0x8d,
			0x8b, 0x8a, 0x8a, 0x89, 0x86, 0x82, 0x7e, 0x7d, 0x7e, 0x80, 0x81,
			0x81, 0x7f, 0x7c, 0x79, 0x78, 0x77, 0x77, 0x77, 0x76, 0x75, 0x74,
			0x74, 0x75, 0x76, 0x76, 0x76, 0x75, 0x74, 0x74, 0x74, 0x74, 0x75,
			0x76, 0x77, 0x78, 0x7b, 0x7e, 0x80, 0x82, 0x84, 0x86, 0x8b, 0x90,
			0x95, 0x97, 0x97, 0x93, 0x8e, 0x8a, 0x88, 0x87, 0x87, 0x88, 0x86,
			0x84, 0x80, 0x7e, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7d, 0x7b, 0x79,
			0x79, 0x78, 0x79, 0x78, 0x78, 0x77, 0x76, 0x76, 0x76, 0x77, 0x78,
			0x79, 0x79, 0x79, 0x78, 0x78, 0x79, 0x7a, 0x7b, 0x7d, 0x7f, 0x80,
			0x81, 0x82, 0x82, 0x83, 0x85, 0x87, 0x89, 0x8c, 0x8d, 0x8d, 0x8d,
			0x8c, 0x8a, 0x89, 0x88, 0x86, 0x85, 0x84, 0x83, 0x81, 0x80, 0x7f,
			0x7e, 0x7c, 0x7b, 0x7b, 0x7a, 0x79, 0x78, 0x76, 0x75, 0x73, 0x71,
			0x70, 0x6f, 0x70, 0x72, 0x74, 0x76, 0x78, 0x7a, 0x7c, 0x7f, 0x81,
			0x84, 0x88, 0x8c, 0x8f, 0x91, 0x91, 0x8f, 0x8c, 0x89, 0x87, 0x85,
			0x85, 0x84, 0x83, 0x81, 0x7f, 0x7d, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e,
			0x7e, 0x7d, 0x7c, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b,
			0x7b, 0x7c, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x81, 0x81, 0x81,
			0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e,
			0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x80, 0x80, 0x81, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
			0x7f, 0x7f, 0x7f,
		},
	},
}

var beepSound = []byte{
	0x80, 0x80, 0x81, 0x81, 0x7f, 0x7e, 0x7e, 0x80, 0x7e, 0x79, 0x76,
	0x78, 0x81, 0x8c, 0x8f, 0x88, 0x7d, 0x78, 0x7b, 0x80, 0x7d, 0x73,
	0x6c, 0x73, 0x88, 0x9b, 0x9d, 0x8c, 0x76, 0x6d, 0x74, 0x7e, 0x7c,
	0x70, 0x68, 0x75, 0x8f, 0xa4, 0xa2, 0x89, 0x6f, 0x66, 0x70, 0x7d,
	0x7e, 0x74, 0x6e, 0x7b, 0x93, 0xa5, 0x9f, 0x84, 0x6a, 0x62, 0x6e,
	0x7e, 0x81, 0x79, 0x73, 0x7e, 0x95, 0xa4, 0x9a, 0x7e, 0x64, 0x5f,
	0x6e, 0x81, 0x86, 0x7e, 0x78, 0x82, 0x96, 0xa1, 0x95, 0x78, 0x5f,
	0x5d, 0x70, 0x84, 0x8a, 0x83, 0x7c, 0x84, 0x94, 0x9d, 0x8f, 0x72,
	0x5c, 0x5c, 0x72, 0x89, 0x90, 0x87, 0x7f, 0x84, 0x92, 0x98, 0x89,
	0x6d, 0x59, 0x5e, 0x77, 0x8f, 0x95, 0x8a, 0x80, 0x82, 0x8e, 0x93,
	0x84, 0x6a, 0x58, 0x61, 0x7c, 0x94, 0x9a, 0x8d, 0x80, 0x80, 0x8a,
	0x8d, 0x7f, 0x67, 0x5a, 0x65, 0x82, 0x9a, 0x9d, 0x8e, 0x7d, 0x7c,
	0x84, 0x88, 0x7b, 0x66, 0x5c, 0x6a, 0x88, 0x9f, 0x9f, 0x8d, 0x7b,
	0x77, 0x7f, 0x84, 0x79, 0x67, 0x60, 0x70, 0x8e, 0xa3, 0xa0, 0x8a,
	0x76, 0x72, 0x7b, 0x81, 0x78, 0x69, 0x65, 0x76, 0x93, 0xa5, 0x9f,
	0x86, 0x70, 0x6c, 0x77, 0x7f, 0x79, 0x6c, 0x6a, 0x7c, 0x97, 0xa7,
	0x9d, 0x81, 0x6b, 0x68, 0x74, 0x7f, 0x7c, 0x71, 0x70, 0x81, 0x9a,
	0xa6, 0x99, 0x7c, 0x65, 0x64, 0x73, 0x81, 0x80, 0x76, 0x75, 0x84,
	0x9b, 0xa4, 0x94, 0x76, 0x60, 0x61, 0x74, 0x84, 0x84, 0x7b, 0x79,
	0x87, 0x9a, 0xa0, 0x8e, 0x70, 0x5c, 0x61, 0x76, 0x88, 0x89, 0x80,
	0x7d, 0x88, 0x98, 0x9c, 0x88, 0x6a, 0x59, 0x61, 0x79, 0x8d, 0x8e,
	0x84, 0x7e, 0x88, 0x95, 0x96, 0x82, 0x66, 0x58, 0x63, 0x7e, 0x93,
	0x93, 0x87, 0x7f, 0x86, 0x91, 0x91, 0x7d, 0x63, 0x58, 0x67, 0x84,
	0x98, 0x97, 0x89, 0x7e, 0x82, 0x8c, 0x8b, 0x78, 0x61, 0x5a, 0x6c,
	0x8a, 0x9e, 0x9a, 0x88, 0x7c, 0x7e, 0x87, 0x86, 0x76, 0x61, 0x5d,
	0x71, 0x8f, 0xa2, 0x9c, 0x87, 0x78, 0x79, 0x82, 0x82, 0x74, 0x63,
	0x62, 0x77, 0x95, 0xa5, 0x9b, 0x84, 0x73, 0x73, 0x7d, 0x80, 0x74,
	0x66, 0x67, 0x7d, 0x9a, 0xa7, 0x9a, 0x80, 0x6d, 0x6e, 0x7b, 0x7f,
	0x76, 0x6a, 0x6c, 0x83, 0x9d, 0xa7, 0x96, 0x7a, 0x68, 0x6b, 0x78,
	0x80, 0x79, 0x6f, 0x72, 0x88, 0x9f, 0xa5, 0x92, 0x74, 0x62, 0x67,
	0x78, 0x82, 0x7d, 0x74, 0x77, 0x8a, 0x9f, 0xa2, 0x8c, 0x6e, 0x5e,
	0x66, 0x79, 0x86, 0x82, 0x79, 0x7c, 0x8d, 0x9e, 0x9e, 0x86, 0x68,
	0x5b, 0x66, 0x7c, 0x8a, 0x87, 0x7e, 0x7e, 0x8d, 0x9c, 0x98, 0x80,
	0x63, 0x59, 0x67, 0x80, 0x8f, 0x8c, 0x81, 0x80, 0x8c, 0x98, 0x93,
	0x7b, 0x60, 0x58, 0x6a, 0x85, 0x94, 0x91, 0x84, 0x80, 0x89, 0x93,
	0x8d, 0x76, 0x5d, 0x5a, 0x6e, 0x8b, 0x9a, 0x94, 0x84, 0x7e, 0x85,
	0x8e, 0x88, 0x72, 0x5d, 0x5c, 0x73, 0x91, 0x9f, 0x96, 0x84, 0x7b,
	0x80, 0x88, 0x83, 0x70, 0x5e, 0x61, 0x79, 0x97, 0xa2, 0x97, 0x81,
	0x77, 0x7b, 0x84, 0x80, 0x6f, 0x60, 0x66, 0x80, 0x9c, 0xa4, 0x95,
	0x7d, 0x71, 0x76, 0x80, 0x7e, 0x70, 0x64, 0x6b, 0x86, 0xa0, 0xa5,
	0x93, 0x79, 0x6c, 0x72, 0x7d, 0x7e, 0x72, 0x68, 0x71, 0x8a, 0xa2,
	0xa4, 0x8f, 0x73, 0x67, 0x6e, 0x7c, 0x7f, 0x76, 0x6e, 0x77, 0x8e,
	0xa3, 0xa2, 0x89, 0x6d, 0x62, 0x6c, 0x7c, 0x82, 0x7b, 0x73, 0x7b,
	0x91, 0xa3, 0x9e, 0x84, 0x67, 0x5e, 0x6b, 0x7e, 0x86, 0x80, 0x78,
	0x7f, 0x92, 0xa0, 0x99, 0x7d, 0x62, 0x5c, 0x6b, 0x81, 0x8b, 0x84,
	0x7c, 0x81, 0x92, 0x9d, 0x93, 0x78, 0x5e, 0x5a, 0x6e, 0x86, 0x90,
	0x89, 0x80, 0x82, 0x90, 0x98, 0x8e, 0x72, 0x5b, 0x5b, 0x72, 0x8c,
	0x95, 0x8d, 0x81, 0x81, 0x8d, 0x93, 0x88, 0x6e, 0x5a, 0x5d, 0x76,
	0x91, 0x9a, 0x8f, 0x81, 0x7e, 0x88, 0x8e, 0x83, 0x6b, 0x5a, 0x61,
	0x7c, 0x97, 0x9e, 0x91, 0x80, 0x7b, 0x83, 0x89, 0x7e, 0x6a, 0x5c,
	0x66, 0x82, 0x9b, 0x9f, 0x8f, 0x7d, 0x78, 0x7e, 0x83, 0x7d, 0x70,
	0x6a, 0x72, 0x85, 0x93, 0x93, 0x88, 0x7c, 0x79, 0x7d, 0x80, 0x7d,
	0x78, 0x77, 0x7b, 0x83, 0x87, 0x86, 0x81, 0x7e, 0x7d, 0x7e, 0x7f,
	0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
	0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80,
	0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
	0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80,
	0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
	0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
	0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
	0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80,
	0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
	0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
	0x7f, 0x80, 0x80, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f,
	0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f,
	0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
	0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
	0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
	0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f,
	0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f,
	0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
	0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x80, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
	0x80, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x80, 0x7f, 0x80, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f,
	0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x80, 0x7f, 0x7f, 0x7f, 0x7f, 0x80,
	0x7f, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x80, 0x80,
	0x7f, 0x80, 0x7f, 0x7f, 0x80,
}
