List of registration-free / anonymous imageboards in JSON format.

Derived from Creamy's list, other imageboard lists, online searches, imageboard threads, and various other sources. Contributions welcome.

JSON endpoints:
https://ccd0.github.io/imageboards.json/imageboards.json

Archives and closed boards that it is no longer possible to post to will not be listed.
To avoid disturbing very slow boards, sites will not be listed unless they have at least 12 posts per year.
Exceptions will be made for new sites, demo sites for imageboard software, and sites that specifically request to be added.

Codes used for the "software" field are documented at [software.md](software.md).

The "mirrors" field describes alternate ways of accessing the site with substantially the same interface. It does not include URLs that merely redirect to the main URL. It is an array in the following format:
* The first element is a part of the site URL ("url" field) and of other URLs (e.g. "boardlist"), usually the protocol and domain part.
* Subsequent elements are what the first element should be replaced with to reach corresponding pages on the site's mirrors.

The "interfaces" field describes alternate ways of accessing the site with substantially different interfaces.

The "entrances", "redirects", and "fallbacks" fields are arrays containing various types of alternate URLs for the site.
* "entrances" are sites that contain links to the main site.
* "redirects" are URLs that redirect to the site or redirect to a page linking to the site.
* "fallbacks" are URLs not yet used but which may be activated if the main site goes down.

A third-party human-readable version of this list:
https://imageboards.net/

Other lists that may be of interest:
* https://socialwiki.top/wiki/Imageboards
* https://bvffalo.land/the-rest/
* http://www.1ch.us/
* https://allchans.org/
* http://overchan.ru/
* https://0chan.one/catalog/ (also available in JSON: https://0chan.one/chans/chans.json)
* http://metatorjq65tshfy.onion/catalog/ (also available in JSON: http://metatorjq65tshfy.onion/chans/chans.json)
* https://dscript.me/chanlist/
* http://overchan2.narod.ru/
* https://komica.org/
* http://txtchan.org/ (textchan overchan)
* http://xiongnu.org/overtext/ (The overtext)
* https://lurkmore.to/Зарубежные_имиджборды
* https://lurkmore.to/Отечественные_имиджборды
* http://www.wikinet.pro/wiki/Anexo:Lista_de_chans_brasileiros_ativos
* https://chanes.uwu.mx/
* http://www.anontalk.info/wiki/Illegal_Clones
* https://encyclopediadramatica.se/List_of_chans
* https://encyclopediadramatica.se/List_of_imageboards
* http://anticopyright.ru/wiki/Список_имиджбордов
* https://tvtropes.org/pmwiki/pmwiki.php/Main/ImageBoards (tvtropes list of imageboards)
* https://allthetropes.org/wiki/Image_Boards
* https://drama.kropyva.ch/Список_іміджбордів
* http://4x13.net/list/
* https://chiru.no/ ("Pick a site" dropdown)
* https://stormy-skies.neocities.org/list/chanlist.html
* https://listography.com/5491020766/websites/imageboard_lists
* https://marttcw.neocities.org/links/
* https://docs.google.com/document/d/1t10VI-sccy1CfAeMZHwmCS_7agIHFo_B5ipMjzsMtTg/edit (Creamy's list with updates to 2016-10-14)
* https://pastebin.com/E4n2qEBa (2015-08-12 version of Creamy's list of imageboards)
* https://pastebin.com/EUrfHx7n (2015-12-18)
* https://pastebin.com/8QNNKrxV (2016-08-12)
* https://pastebin.com/3e2RddP5 (2016-10-14)
* http://web.archive.org/web/20160829200019/http://dramatica.org.ua/List_of_image_boards
* https://bitbin.it/emT3GJ1C/ (2013)
* https://www.1chan.net/overchan/ (2008)
* http://archive.is/jHD6 (2ch.us the overchan V.2)
* http://web.archive.org/web/20161108181843/https://pastebin.com/xgacDKda (Imageboard thread v.8.3 2014-04-14)
* http://web.archive.org/web/20150518223427/https://meltingwax.net/text-overchan (textboard overchan V.2)
