.include "macros.inc"

.section .text  # 0x80005940 - 0x803B7240

.global TRKSetBufferUsed
TRKSetBufferUsed:
/* 80326C94 00323874  90 83 00 04 */	stw r4, 4(r3)
/* 80326C98 00323878  4E 80 00 20 */	blr 

.global TRKInitializeMessageBuffers
TRKInitializeMessageBuffers:
/* 80326C9C 0032387C  7C 08 02 A6 */	mflr r0
/* 80326CA0 00323880  3C 60 80 4A */	lis r3, lbl_804A3178@ha
/* 80326CA4 00323884  90 01 00 04 */	stw r0, 4(r1)
/* 80326CA8 00323888  38 03 31 78 */	addi r0, r3, lbl_804A3178@l
/* 80326CAC 0032388C  94 21 FF F0 */	stwu r1, -0x10(r1)
/* 80326CB0 00323890  93 E1 00 0C */	stw r31, 0xc(r1)
/* 80326CB4 00323894  93 C1 00 08 */	stw r30, 8(r1)
/* 80326CB8 00323898  3B C0 00 00 */	li r30, 0
/* 80326CBC 0032389C  1C 9E 08 90 */	mulli r4, r30, 0x890
/* 80326CC0 003238A0  7F E0 22 14 */	add r31, r0, r4
lbl_80326CC4:
/* 80326CC4 003238A4  7F E3 FB 78 */	mr r3, r31
/* 80326CC8 003238A8  48 00 21 99 */	bl TRKInitializeMutex
/* 80326CCC 003238AC  7F E3 FB 78 */	mr r3, r31
/* 80326CD0 003238B0  48 00 21 99 */	bl TRKAcquireMutex
/* 80326CD4 003238B4  38 7F 00 00 */	addi r3, r31, 0
/* 80326CD8 003238B8  38 80 00 00 */	li r4, 0
/* 80326CDC 003238BC  4B FF FF B9 */	bl TRKSetBufferUsed
/* 80326CE0 003238C0  7F E3 FB 78 */	mr r3, r31
/* 80326CE4 003238C4  48 00 21 8D */	bl TRKReleaseMutex
/* 80326CE8 003238C8  3B DE 00 01 */	addi r30, r30, 1
/* 80326CEC 003238CC  3B FF 08 90 */	addi r31, r31, 0x890
/* 80326CF0 003238D0  2C 1E 00 03 */	cmpwi r30, 3
/* 80326CF4 003238D4  41 80 FF D0 */	blt lbl_80326CC4
/* 80326CF8 003238D8  83 E1 00 0C */	lwz r31, 0xc(r1)
/* 80326CFC 003238DC  38 60 00 00 */	li r3, 0
/* 80326D00 003238E0  83 C1 00 08 */	lwz r30, 8(r1)
/* 80326D04 003238E4  38 21 00 10 */	addi r1, r1, 0x10
/* 80326D08 003238E8  80 01 00 04 */	lwz r0, 4(r1)
/* 80326D0C 003238EC  7C 08 03 A6 */	mtlr r0
/* 80326D10 003238F0  4E 80 00 20 */	blr 

.global TRKGetFreeBuffer
TRKGetFreeBuffer:
/* 80326D14 003238F4  7C 08 02 A6 */	mflr r0
/* 80326D18 003238F8  90 01 00 04 */	stw r0, 4(r1)
/* 80326D1C 003238FC  38 00 00 00 */	li r0, 0
/* 80326D20 00323900  94 21 FF E0 */	stwu r1, -0x20(r1)
/* 80326D24 00323904  BF 61 00 0C */	stmw r27, 0xc(r1)
/* 80326D28 00323908  3B 84 00 00 */	addi r28, r4, 0
/* 80326D2C 0032390C  3B 63 00 00 */	addi r27, r3, 0
/* 80326D30 00323910  3B E0 03 00 */	li r31, 0x300
/* 80326D34 00323914  3B C0 00 00 */	li r30, 0
/* 80326D38 00323918  90 04 00 00 */	stw r0, 0(r4)
/* 80326D3C 0032391C  48 00 00 54 */	b lbl_80326D90
lbl_80326D40:
/* 80326D40 00323920  7F C3 F3 78 */	mr r3, r30
/* 80326D44 00323924  48 00 00 6D */	bl TRKGetBuffer
/* 80326D48 00323928  7C 7D 1B 78 */	mr r29, r3
/* 80326D4C 0032392C  48 00 21 1D */	bl TRKAcquireMutex
/* 80326D50 00323930  80 1D 00 04 */	lwz r0, 4(r29)
/* 80326D54 00323934  2C 00 00 00 */	cmpwi r0, 0
/* 80326D58 00323938  40 82 00 2C */	bne lbl_80326D84
/* 80326D5C 0032393C  38 7D 00 00 */	addi r3, r29, 0
/* 80326D60 00323940  38 80 00 01 */	li r4, 1
/* 80326D64 00323944  48 00 00 E1 */	bl TRKResetBuffer
/* 80326D68 00323948  38 7D 00 00 */	addi r3, r29, 0
/* 80326D6C 0032394C  38 80 00 01 */	li r4, 1
/* 80326D70 00323950  4B FF FF 25 */	bl TRKSetBufferUsed
/* 80326D74 00323954  93 BC 00 00 */	stw r29, 0(r28)
/* 80326D78 00323958  3B E0 00 00 */	li r31, 0
/* 80326D7C 0032395C  93 DB 00 00 */	stw r30, 0(r27)
/* 80326D80 00323960  3B C0 00 03 */	li r30, 3
lbl_80326D84:
/* 80326D84 00323964  7F A3 EB 78 */	mr r3, r29
/* 80326D88 00323968  48 00 20 E9 */	bl TRKReleaseMutex
/* 80326D8C 0032396C  3B DE 00 01 */	addi r30, r30, 1
lbl_80326D90:
/* 80326D90 00323970  2C 1E 00 03 */	cmpwi r30, 3
/* 80326D94 00323974  41 80 FF AC */	blt lbl_80326D40
/* 80326D98 00323978  7F E3 FB 78 */	mr r3, r31
/* 80326D9C 0032397C  BB 61 00 0C */	lmw r27, 0xc(r1)
/* 80326DA0 00323980  38 21 00 20 */	addi r1, r1, 0x20
/* 80326DA4 00323984  80 01 00 04 */	lwz r0, 4(r1)
/* 80326DA8 00323988  7C 08 03 A6 */	mtlr r0
/* 80326DAC 0032398C  4E 80 00 20 */	blr 

.global TRKGetBuffer
TRKGetBuffer:
/* 80326DB0 00323990  2C 03 00 00 */	cmpwi r3, 0
/* 80326DB4 00323994  38 00 00 00 */	li r0, 0
/* 80326DB8 00323998  41 80 00 1C */	blt lbl_80326DD4
/* 80326DBC 0032399C  2C 03 00 03 */	cmpwi r3, 3
/* 80326DC0 003239A0  40 80 00 14 */	bge lbl_80326DD4
/* 80326DC4 003239A4  1C 83 08 90 */	mulli r4, r3, 0x890
/* 80326DC8 003239A8  3C 60 80 4A */	lis r3, lbl_804A3178@ha
/* 80326DCC 003239AC  38 03 31 78 */	addi r0, r3, lbl_804A3178@l
/* 80326DD0 003239B0  7C 00 22 14 */	add r0, r0, r4
lbl_80326DD4:
/* 80326DD4 003239B4  7C 03 03 78 */	mr r3, r0
/* 80326DD8 003239B8  4E 80 00 20 */	blr 

.global TRKReleaseBuffer
TRKReleaseBuffer:
/* 80326DDC 003239BC  7C 08 02 A6 */	mflr r0
/* 80326DE0 003239C0  2C 03 FF FF */	cmpwi r3, -1
/* 80326DE4 003239C4  90 01 00 04 */	stw r0, 4(r1)
/* 80326DE8 003239C8  94 21 FF F0 */	stwu r1, -0x10(r1)
/* 80326DEC 003239CC  93 E1 00 0C */	stw r31, 0xc(r1)
/* 80326DF0 003239D0  41 82 00 40 */	beq lbl_80326E30
/* 80326DF4 003239D4  2C 03 00 00 */	cmpwi r3, 0
/* 80326DF8 003239D8  41 80 00 38 */	blt lbl_80326E30
/* 80326DFC 003239DC  2C 03 00 03 */	cmpwi r3, 3
/* 80326E00 003239E0  40 80 00 30 */	bge lbl_80326E30
/* 80326E04 003239E4  1C 83 08 90 */	mulli r4, r3, 0x890
/* 80326E08 003239E8  3C 60 80 4A */	lis r3, lbl_804A3178@ha
/* 80326E0C 003239EC  38 03 31 78 */	addi r0, r3, lbl_804A3178@l
/* 80326E10 003239F0  7F E0 22 14 */	add r31, r0, r4
/* 80326E14 003239F4  38 7F 00 00 */	addi r3, r31, 0
/* 80326E18 003239F8  48 00 20 51 */	bl TRKAcquireMutex
/* 80326E1C 003239FC  38 7F 00 00 */	addi r3, r31, 0
/* 80326E20 00323A00  38 80 00 00 */	li r4, 0
/* 80326E24 00323A04  4B FF FE 71 */	bl TRKSetBufferUsed
/* 80326E28 00323A08  7F E3 FB 78 */	mr r3, r31
/* 80326E2C 00323A0C  48 00 20 45 */	bl TRKReleaseMutex
lbl_80326E30:
/* 80326E30 00323A10  83 E1 00 0C */	lwz r31, 0xc(r1)
/* 80326E34 00323A14  38 21 00 10 */	addi r1, r1, 0x10
/* 80326E38 00323A18  80 01 00 04 */	lwz r0, 4(r1)
/* 80326E3C 00323A1C  7C 08 03 A6 */	mtlr r0
/* 80326E40 00323A20  4E 80 00 20 */	blr 

.global TRKResetBuffer
TRKResetBuffer:
/* 80326E44 00323A24  7C 08 02 A6 */	mflr r0
/* 80326E48 00323A28  38 A0 00 00 */	li r5, 0
/* 80326E4C 00323A2C  90 01 00 04 */	stw r0, 4(r1)
/* 80326E50 00323A30  54 80 06 3F */	clrlwi. r0, r4, 0x18
/* 80326E54 00323A34  94 21 FF F8 */	stwu r1, -8(r1)
/* 80326E58 00323A38  90 A3 00 08 */	stw r5, 8(r3)
/* 80326E5C 00323A3C  90 A3 00 0C */	stw r5, 0xc(r3)
/* 80326E60 00323A40  40 82 00 14 */	bne lbl_80326E74
/* 80326E64 00323A44  38 63 00 10 */	addi r3, r3, 0x10
/* 80326E68 00323A48  38 80 00 00 */	li r4, 0
/* 80326E6C 00323A4C  38 A0 08 80 */	li r5, 0x880
/* 80326E70 00323A50  4B CD C3 F9 */	bl func_80003268
lbl_80326E74:
/* 80326E74 00323A54  38 21 00 08 */	addi r1, r1, 8
/* 80326E78 00323A58  80 01 00 04 */	lwz r0, 4(r1)
/* 80326E7C 00323A5C  7C 08 03 A6 */	mtlr r0
/* 80326E80 00323A60  4E 80 00 20 */	blr 

.global TRKSetBufferPosition
TRKSetBufferPosition:
/* 80326E84 00323A64  28 04 08 80 */	cmplwi r4, 0x880
/* 80326E88 00323A68  38 A0 00 00 */	li r5, 0
/* 80326E8C 00323A6C  40 81 00 0C */	ble lbl_80326E98
/* 80326E90 00323A70  38 A0 03 01 */	li r5, 0x301
/* 80326E94 00323A74  48 00 00 18 */	b lbl_80326EAC
lbl_80326E98:
/* 80326E98 00323A78  90 83 00 0C */	stw r4, 0xc(r3)
/* 80326E9C 00323A7C  80 03 00 08 */	lwz r0, 8(r3)
/* 80326EA0 00323A80  7C 04 00 40 */	cmplw r4, r0
/* 80326EA4 00323A84  40 81 00 08 */	ble lbl_80326EAC
/* 80326EA8 00323A88  90 83 00 08 */	stw r4, 8(r3)
lbl_80326EAC:
/* 80326EAC 00323A8C  7C A3 2B 78 */	mr r3, r5
/* 80326EB0 00323A90  4E 80 00 20 */	blr 

.global TRKAppendBuffer
TRKAppendBuffer:
/* 80326EB4 00323A94  7C 08 02 A6 */	mflr r0
/* 80326EB8 00323A98  90 01 00 04 */	stw r0, 4(r1)
/* 80326EBC 00323A9C  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 80326EC0 00323AA0  93 E1 00 14 */	stw r31, 0x14(r1)
/* 80326EC4 00323AA4  3B E0 00 00 */	li r31, 0
/* 80326EC8 00323AA8  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80326ECC 00323AAC  7C BE 2B 79 */	or. r30, r5, r5
/* 80326ED0 00323AB0  93 A1 00 0C */	stw r29, 0xc(r1)
/* 80326ED4 00323AB4  3B A3 00 00 */	addi r29, r3, 0
/* 80326ED8 00323AB8  40 82 00 0C */	bne lbl_80326EE4
/* 80326EDC 00323ABC  38 60 00 00 */	li r3, 0
/* 80326EE0 00323AC0  48 00 00 5C */	b lbl_80326F3C
lbl_80326EE4:
/* 80326EE4 00323AC4  80 7D 00 0C */	lwz r3, 0xc(r29)
/* 80326EE8 00323AC8  20 03 08 80 */	subfic r0, r3, 0x880
/* 80326EEC 00323ACC  7C 00 F0 40 */	cmplw r0, r30
/* 80326EF0 00323AD0  40 80 00 0C */	bge lbl_80326EFC
/* 80326EF4 00323AD4  3B E0 03 01 */	li r31, 0x301
/* 80326EF8 00323AD8  7C 1E 03 78 */	mr r30, r0
lbl_80326EFC:
/* 80326EFC 00323ADC  28 1E 00 01 */	cmplwi r30, 1
/* 80326F00 00323AE0  40 82 00 14 */	bne lbl_80326F14
/* 80326F04 00323AE4  88 04 00 00 */	lbz r0, 0(r4)
/* 80326F08 00323AE8  7C 7D 1A 14 */	add r3, r29, r3
/* 80326F0C 00323AEC  98 03 00 10 */	stb r0, 0x10(r3)
/* 80326F10 00323AF0  48 00 00 14 */	b lbl_80326F24
lbl_80326F14:
/* 80326F14 00323AF4  38 63 00 10 */	addi r3, r3, 0x10
/* 80326F18 00323AF8  38 BE 00 00 */	addi r5, r30, 0
/* 80326F1C 00323AFC  7C 7D 1A 14 */	add r3, r29, r3
/* 80326F20 00323B00  4B CD C3 25 */	bl TRK_memcpy
lbl_80326F24:
/* 80326F24 00323B04  80 1D 00 0C */	lwz r0, 0xc(r29)
/* 80326F28 00323B08  38 7F 00 00 */	addi r3, r31, 0
/* 80326F2C 00323B0C  7C 00 F2 14 */	add r0, r0, r30
/* 80326F30 00323B10  90 1D 00 0C */	stw r0, 0xc(r29)
/* 80326F34 00323B14  80 1D 00 0C */	lwz r0, 0xc(r29)
/* 80326F38 00323B18  90 1D 00 08 */	stw r0, 8(r29)
lbl_80326F3C:
/* 80326F3C 00323B1C  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 80326F40 00323B20  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 80326F44 00323B24  83 A1 00 0C */	lwz r29, 0xc(r1)
/* 80326F48 00323B28  38 21 00 18 */	addi r1, r1, 0x18
/* 80326F4C 00323B2C  80 01 00 04 */	lwz r0, 4(r1)
/* 80326F50 00323B30  7C 08 03 A6 */	mtlr r0
/* 80326F54 00323B34  4E 80 00 20 */	blr 

.global TRKReadBuffer
TRKReadBuffer:
/* 80326F58 00323B38  7C 08 02 A6 */	mflr r0
/* 80326F5C 00323B3C  90 01 00 04 */	stw r0, 4(r1)
/* 80326F60 00323B40  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 80326F64 00323B44  93 E1 00 14 */	stw r31, 0x14(r1)
/* 80326F68 00323B48  3B E0 00 00 */	li r31, 0
/* 80326F6C 00323B4C  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80326F70 00323B50  7C BE 2B 79 */	or. r30, r5, r5
/* 80326F74 00323B54  93 A1 00 0C */	stw r29, 0xc(r1)
/* 80326F78 00323B58  3B A3 00 00 */	addi r29, r3, 0
/* 80326F7C 00323B5C  38 64 00 00 */	addi r3, r4, 0
/* 80326F80 00323B60  40 82 00 0C */	bne lbl_80326F8C
/* 80326F84 00323B64  38 60 00 00 */	li r3, 0
/* 80326F88 00323B68  48 00 00 40 */	b lbl_80326FC8
lbl_80326F8C:
/* 80326F8C 00323B6C  80 9D 00 0C */	lwz r4, 0xc(r29)
/* 80326F90 00323B70  80 1D 00 08 */	lwz r0, 8(r29)
/* 80326F94 00323B74  7C 04 00 50 */	subf r0, r4, r0
/* 80326F98 00323B78  7C 1E 00 40 */	cmplw r30, r0
/* 80326F9C 00323B7C  40 81 00 0C */	ble lbl_80326FA8
/* 80326FA0 00323B80  3B E0 03 02 */	li r31, 0x302
/* 80326FA4 00323B84  7C 1E 03 78 */	mr r30, r0
lbl_80326FA8:
/* 80326FA8 00323B88  38 84 00 10 */	addi r4, r4, 0x10
/* 80326FAC 00323B8C  38 BE 00 00 */	addi r5, r30, 0
/* 80326FB0 00323B90  7C 9D 22 14 */	add r4, r29, r4
/* 80326FB4 00323B94  4B CD C2 91 */	bl TRK_memcpy
/* 80326FB8 00323B98  80 1D 00 0C */	lwz r0, 0xc(r29)
/* 80326FBC 00323B9C  38 7F 00 00 */	addi r3, r31, 0
/* 80326FC0 00323BA0  7C 00 F2 14 */	add r0, r0, r30
/* 80326FC4 00323BA4  90 1D 00 0C */	stw r0, 0xc(r29)
lbl_80326FC8:
/* 80326FC8 00323BA8  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 80326FCC 00323BAC  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 80326FD0 00323BB0  83 A1 00 0C */	lwz r29, 0xc(r1)
/* 80326FD4 00323BB4  38 21 00 18 */	addi r1, r1, 0x18
/* 80326FD8 00323BB8  80 01 00 04 */	lwz r0, 4(r1)
/* 80326FDC 00323BBC  7C 08 03 A6 */	mtlr r0
/* 80326FE0 00323BC0  4E 80 00 20 */	blr 

.global TRKAppendBuffer1_ui16
TRKAppendBuffer1_ui16:
/* 80326FE4 00323BC4  7C 08 02 A6 */	mflr r0
/* 80326FE8 00323BC8  3C A0 80 4A */	lis r5, lbl_804A3170@ha
/* 80326FEC 00323BCC  90 01 00 04 */	stw r0, 4(r1)
/* 80326FF0 00323BD0  94 21 FF F0 */	stwu r1, -0x10(r1)
/* 80326FF4 00323BD4  B0 81 00 08 */	sth r4, 8(r1)
/* 80326FF8 00323BD8  80 05 31 70 */	lwz r0, lbl_804A3170@l(r5)
/* 80326FFC 00323BDC  2C 00 00 00 */	cmpwi r0, 0
/* 80327000 00323BE0  41 82 00 0C */	beq lbl_8032700C
/* 80327004 00323BE4  38 81 00 08 */	addi r4, r1, 8
/* 80327008 00323BE8  48 00 00 18 */	b lbl_80327020
lbl_8032700C:
/* 8032700C 00323BEC  88 01 00 09 */	lbz r0, 9(r1)
/* 80327010 00323BF0  38 81 00 0C */	addi r4, r1, 0xc
/* 80327014 00323BF4  98 01 00 0C */	stb r0, 0xc(r1)
/* 80327018 00323BF8  88 01 00 08 */	lbz r0, 8(r1)
/* 8032701C 00323BFC  98 01 00 0D */	stb r0, 0xd(r1)
lbl_80327020:
/* 80327020 00323C00  38 A0 00 02 */	li r5, 2
/* 80327024 00323C04  4B FF FE 91 */	bl TRKAppendBuffer
/* 80327028 00323C08  38 21 00 10 */	addi r1, r1, 0x10
/* 8032702C 00323C0C  80 01 00 04 */	lwz r0, 4(r1)
/* 80327030 00323C10  7C 08 03 A6 */	mtlr r0
/* 80327034 00323C14  4E 80 00 20 */	blr 

.global TRKAppendBuffer1_ui32
TRKAppendBuffer1_ui32:
/* 80327038 00323C18  7C 08 02 A6 */	mflr r0
/* 8032703C 00323C1C  3C A0 80 4A */	lis r5, lbl_804A3170@ha
/* 80327040 00323C20  90 01 00 04 */	stw r0, 4(r1)
/* 80327044 00323C24  94 21 FF F0 */	stwu r1, -0x10(r1)
/* 80327048 00323C28  90 81 00 08 */	stw r4, 8(r1)
/* 8032704C 00323C2C  80 05 31 70 */	lwz r0, lbl_804A3170@l(r5)
/* 80327050 00323C30  2C 00 00 00 */	cmpwi r0, 0
/* 80327054 00323C34  41 82 00 0C */	beq lbl_80327060
/* 80327058 00323C38  38 81 00 08 */	addi r4, r1, 8
/* 8032705C 00323C3C  48 00 00 28 */	b lbl_80327084
lbl_80327060:
/* 80327060 00323C40  88 01 00 0B */	lbz r0, 0xb(r1)
/* 80327064 00323C44  38 81 00 0C */	addi r4, r1, 0xc
/* 80327068 00323C48  98 01 00 0C */	stb r0, 0xc(r1)
/* 8032706C 00323C4C  88 01 00 0A */	lbz r0, 0xa(r1)
/* 80327070 00323C50  98 01 00 0D */	stb r0, 0xd(r1)
/* 80327074 00323C54  88 01 00 09 */	lbz r0, 9(r1)
/* 80327078 00323C58  98 01 00 0E */	stb r0, 0xe(r1)
/* 8032707C 00323C5C  88 01 00 08 */	lbz r0, 8(r1)
/* 80327080 00323C60  98 01 00 0F */	stb r0, 0xf(r1)
lbl_80327084:
/* 80327084 00323C64  38 A0 00 04 */	li r5, 4
/* 80327088 00323C68  4B FF FE 2D */	bl TRKAppendBuffer
/* 8032708C 00323C6C  38 21 00 10 */	addi r1, r1, 0x10
/* 80327090 00323C70  80 01 00 04 */	lwz r0, 4(r1)
/* 80327094 00323C74  7C 08 03 A6 */	mtlr r0
/* 80327098 00323C78  4E 80 00 20 */	blr 

.global TRKAppendBuffer1_ui64
TRKAppendBuffer1_ui64:
/* 8032709C 00323C7C  7C 08 02 A6 */	mflr r0
/* 803270A0 00323C80  3C 80 80 4A */	lis r4, lbl_804A3170@ha
/* 803270A4 00323C84  90 01 00 04 */	stw r0, 4(r1)
/* 803270A8 00323C88  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 803270AC 00323C8C  90 A1 00 08 */	stw r5, 8(r1)
/* 803270B0 00323C90  90 C1 00 0C */	stw r6, 0xc(r1)
/* 803270B4 00323C94  80 04 31 70 */	lwz r0, lbl_804A3170@l(r4)
/* 803270B8 00323C98  2C 00 00 00 */	cmpwi r0, 0
/* 803270BC 00323C9C  41 82 00 0C */	beq lbl_803270C8
/* 803270C0 00323CA0  38 81 00 08 */	addi r4, r1, 8
/* 803270C4 00323CA4  48 00 00 48 */	b lbl_8032710C
lbl_803270C8:
/* 803270C8 00323CA8  88 01 00 0F */	lbz r0, 0xf(r1)
/* 803270CC 00323CAC  38 81 00 10 */	addi r4, r1, 0x10
/* 803270D0 00323CB0  98 01 00 10 */	stb r0, 0x10(r1)
/* 803270D4 00323CB4  88 01 00 0E */	lbz r0, 0xe(r1)
/* 803270D8 00323CB8  98 01 00 11 */	stb r0, 0x11(r1)
/* 803270DC 00323CBC  88 01 00 0D */	lbz r0, 0xd(r1)
/* 803270E0 00323CC0  98 01 00 12 */	stb r0, 0x12(r1)
/* 803270E4 00323CC4  88 01 00 0C */	lbz r0, 0xc(r1)
/* 803270E8 00323CC8  98 01 00 13 */	stb r0, 0x13(r1)
/* 803270EC 00323CCC  88 01 00 0B */	lbz r0, 0xb(r1)
/* 803270F0 00323CD0  98 01 00 14 */	stb r0, 0x14(r1)
/* 803270F4 00323CD4  88 01 00 0A */	lbz r0, 0xa(r1)
/* 803270F8 00323CD8  98 01 00 15 */	stb r0, 0x15(r1)
/* 803270FC 00323CDC  88 01 00 09 */	lbz r0, 9(r1)
/* 80327100 00323CE0  98 01 00 16 */	stb r0, 0x16(r1)
/* 80327104 00323CE4  88 01 00 08 */	lbz r0, 8(r1)
/* 80327108 00323CE8  98 01 00 17 */	stb r0, 0x17(r1)
lbl_8032710C:
/* 8032710C 00323CEC  38 A0 00 08 */	li r5, 8
/* 80327110 00323CF0  4B FF FD A5 */	bl TRKAppendBuffer
/* 80327114 00323CF4  38 21 00 18 */	addi r1, r1, 0x18
/* 80327118 00323CF8  80 01 00 04 */	lwz r0, 4(r1)
/* 8032711C 00323CFC  7C 08 03 A6 */	mtlr r0
/* 80327120 00323D00  4E 80 00 20 */	blr 

.global TRKAppendBuffer_ui8
TRKAppendBuffer_ui8:
/* 80327124 00323D04  39 20 00 00 */	li r9, 0
/* 80327128 00323D08  38 00 00 00 */	li r0, 0
/* 8032712C 00323D0C  48 00 00 48 */	b lbl_80327174
lbl_80327130:
/* 80327130 00323D10  80 E3 00 0C */	lwz r7, 0xc(r3)
/* 80327134 00323D14  89 04 00 00 */	lbz r8, 0(r4)
/* 80327138 00323D18  28 07 08 80 */	cmplwi r7, 0x880
/* 8032713C 00323D1C  41 80 00 0C */	blt lbl_80327148
/* 80327140 00323D20  38 E0 03 01 */	li r7, 0x301
/* 80327144 00323D24  48 00 00 24 */	b lbl_80327168
lbl_80327148:
/* 80327148 00323D28  38 C7 00 01 */	addi r6, r7, 1
/* 8032714C 00323D2C  38 07 00 10 */	addi r0, r7, 0x10
/* 80327150 00323D30  90 C3 00 0C */	stw r6, 0xc(r3)
/* 80327154 00323D34  38 E0 00 00 */	li r7, 0
/* 80327158 00323D38  7D 03 01 AE */	stbx r8, r3, r0
/* 8032715C 00323D3C  80 C3 00 08 */	lwz r6, 8(r3)
/* 80327160 00323D40  38 06 00 01 */	addi r0, r6, 1
/* 80327164 00323D44  90 03 00 08 */	stw r0, 8(r3)
lbl_80327168:
/* 80327168 00323D48  38 07 00 00 */	addi r0, r7, 0
/* 8032716C 00323D4C  39 29 00 01 */	addi r9, r9, 1
/* 80327170 00323D50  38 84 00 01 */	addi r4, r4, 1
lbl_80327174:
/* 80327174 00323D54  2C 00 00 00 */	cmpwi r0, 0
/* 80327178 00323D58  40 82 00 0C */	bne lbl_80327184
/* 8032717C 00323D5C  7C 09 28 00 */	cmpw r9, r5
/* 80327180 00323D60  41 80 FF B0 */	blt lbl_80327130
lbl_80327184:
/* 80327184 00323D64  7C 03 03 78 */	mr r3, r0
/* 80327188 00323D68  4E 80 00 20 */	blr 

.global TRKAppendBuffer_ui32
TRKAppendBuffer_ui32:
/* 8032718C 00323D6C  7C 08 02 A6 */	mflr r0
/* 80327190 00323D70  90 01 00 04 */	stw r0, 4(r1)
/* 80327194 00323D74  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 80327198 00323D78  93 E1 00 14 */	stw r31, 0x14(r1)
/* 8032719C 00323D7C  93 C1 00 10 */	stw r30, 0x10(r1)
/* 803271A0 00323D80  3B C0 00 00 */	li r30, 0
/* 803271A4 00323D84  57 C0 10 3A */	slwi r0, r30, 2
/* 803271A8 00323D88  93 A1 00 0C */	stw r29, 0xc(r1)
/* 803271AC 00323D8C  7F E4 02 14 */	add r31, r4, r0
/* 803271B0 00323D90  3B A5 00 00 */	addi r29, r5, 0
/* 803271B4 00323D94  93 81 00 08 */	stw r28, 8(r1)
/* 803271B8 00323D98  3B 83 00 00 */	addi r28, r3, 0
/* 803271BC 00323D9C  38 60 00 00 */	li r3, 0
/* 803271C0 00323DA0  48 00 00 18 */	b lbl_803271D8
lbl_803271C4:
/* 803271C4 00323DA4  7F 83 E3 78 */	mr r3, r28
/* 803271C8 00323DA8  80 9F 00 00 */	lwz r4, 0(r31)
/* 803271CC 00323DAC  4B FF FE 6D */	bl TRKAppendBuffer1_ui32
/* 803271D0 00323DB0  3B DE 00 01 */	addi r30, r30, 1
/* 803271D4 00323DB4  3B FF 00 04 */	addi r31, r31, 4
lbl_803271D8:
/* 803271D8 00323DB8  2C 03 00 00 */	cmpwi r3, 0
/* 803271DC 00323DBC  40 82 00 0C */	bne lbl_803271E8
/* 803271E0 00323DC0  7C 1E E8 00 */	cmpw r30, r29
/* 803271E4 00323DC4  41 80 FF E0 */	blt lbl_803271C4
lbl_803271E8:
/* 803271E8 00323DC8  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 803271EC 00323DCC  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 803271F0 00323DD0  83 A1 00 0C */	lwz r29, 0xc(r1)
/* 803271F4 00323DD4  83 81 00 08 */	lwz r28, 8(r1)
/* 803271F8 00323DD8  38 21 00 18 */	addi r1, r1, 0x18
/* 803271FC 00323DDC  80 01 00 04 */	lwz r0, 4(r1)
/* 80327200 00323DE0  7C 08 03 A6 */	mtlr r0
/* 80327204 00323DE4  4E 80 00 20 */	blr 

.global TRKReadBuffer1_ui8
TRKReadBuffer1_ui8:
/* 80327208 00323DE8  7C 08 02 A6 */	mflr r0
/* 8032720C 00323DEC  38 A0 00 01 */	li r5, 1
/* 80327210 00323DF0  90 01 00 04 */	stw r0, 4(r1)
/* 80327214 00323DF4  94 21 FF F8 */	stwu r1, -8(r1)
/* 80327218 00323DF8  4B FF FD 41 */	bl TRKReadBuffer
/* 8032721C 00323DFC  38 21 00 08 */	addi r1, r1, 8
/* 80327220 00323E00  80 01 00 04 */	lwz r0, 4(r1)
/* 80327224 00323E04  7C 08 03 A6 */	mtlr r0
/* 80327228 00323E08  4E 80 00 20 */	blr 

.global TRKReadBuffer1_ui16
TRKReadBuffer1_ui16:
/* 8032722C 00323E0C  7C 08 02 A6 */	mflr r0
/* 80327230 00323E10  3C A0 80 4A */	lis r5, lbl_804A3170@ha
/* 80327234 00323E14  90 01 00 04 */	stw r0, 4(r1)
/* 80327238 00323E18  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 8032723C 00323E1C  93 E1 00 14 */	stw r31, 0x14(r1)
/* 80327240 00323E20  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80327244 00323E24  3B C4 00 00 */	addi r30, r4, 0
/* 80327248 00323E28  80 05 31 70 */	lwz r0, lbl_804A3170@l(r5)
/* 8032724C 00323E2C  2C 00 00 00 */	cmpwi r0, 0
/* 80327250 00323E30  41 82 00 0C */	beq lbl_8032725C
/* 80327254 00323E34  7F DF F3 78 */	mr r31, r30
/* 80327258 00323E38  48 00 00 08 */	b lbl_80327260
lbl_8032725C:
/* 8032725C 00323E3C  3B E1 00 08 */	addi r31, r1, 8
lbl_80327260:
/* 80327260 00323E40  38 9F 00 00 */	addi r4, r31, 0
/* 80327264 00323E44  38 A0 00 02 */	li r5, 2
/* 80327268 00323E48  4B FF FC F1 */	bl TRKReadBuffer
/* 8032726C 00323E4C  3C 80 80 4A */	lis r4, lbl_804A3170@ha
/* 80327270 00323E50  80 04 31 70 */	lwz r0, lbl_804A3170@l(r4)
/* 80327274 00323E54  2C 00 00 00 */	cmpwi r0, 0
/* 80327278 00323E58  40 82 00 1C */	bne lbl_80327294
/* 8032727C 00323E5C  2C 03 00 00 */	cmpwi r3, 0
/* 80327280 00323E60  40 82 00 14 */	bne lbl_80327294
/* 80327284 00323E64  88 1F 00 01 */	lbz r0, 1(r31)
/* 80327288 00323E68  98 1E 00 00 */	stb r0, 0(r30)
/* 8032728C 00323E6C  88 1F 00 00 */	lbz r0, 0(r31)
/* 80327290 00323E70  98 1E 00 01 */	stb r0, 1(r30)
lbl_80327294:
/* 80327294 00323E74  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 80327298 00323E78  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 8032729C 00323E7C  38 21 00 18 */	addi r1, r1, 0x18
/* 803272A0 00323E80  80 01 00 04 */	lwz r0, 4(r1)
/* 803272A4 00323E84  7C 08 03 A6 */	mtlr r0
/* 803272A8 00323E88  4E 80 00 20 */	blr 

.global TRKReadBuffer1_ui32
TRKReadBuffer1_ui32:
/* 803272AC 00323E8C  7C 08 02 A6 */	mflr r0
/* 803272B0 00323E90  3C A0 80 4A */	lis r5, lbl_804A3170@ha
/* 803272B4 00323E94  90 01 00 04 */	stw r0, 4(r1)
/* 803272B8 00323E98  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 803272BC 00323E9C  93 E1 00 14 */	stw r31, 0x14(r1)
/* 803272C0 00323EA0  93 C1 00 10 */	stw r30, 0x10(r1)
/* 803272C4 00323EA4  3B C4 00 00 */	addi r30, r4, 0
/* 803272C8 00323EA8  80 05 31 70 */	lwz r0, lbl_804A3170@l(r5)
/* 803272CC 00323EAC  2C 00 00 00 */	cmpwi r0, 0
/* 803272D0 00323EB0  41 82 00 0C */	beq lbl_803272DC
/* 803272D4 00323EB4  7F DF F3 78 */	mr r31, r30
/* 803272D8 00323EB8  48 00 00 08 */	b lbl_803272E0
lbl_803272DC:
/* 803272DC 00323EBC  3B E1 00 08 */	addi r31, r1, 8
lbl_803272E0:
/* 803272E0 00323EC0  38 9F 00 00 */	addi r4, r31, 0
/* 803272E4 00323EC4  38 A0 00 04 */	li r5, 4
/* 803272E8 00323EC8  4B FF FC 71 */	bl TRKReadBuffer
/* 803272EC 00323ECC  3C 80 80 4A */	lis r4, lbl_804A3170@ha
/* 803272F0 00323ED0  80 04 31 70 */	lwz r0, lbl_804A3170@l(r4)
/* 803272F4 00323ED4  2C 00 00 00 */	cmpwi r0, 0
/* 803272F8 00323ED8  40 82 00 2C */	bne lbl_80327324
/* 803272FC 00323EDC  2C 03 00 00 */	cmpwi r3, 0
/* 80327300 00323EE0  40 82 00 24 */	bne lbl_80327324
/* 80327304 00323EE4  88 1F 00 03 */	lbz r0, 3(r31)
/* 80327308 00323EE8  98 1E 00 00 */	stb r0, 0(r30)
/* 8032730C 00323EEC  88 1F 00 02 */	lbz r0, 2(r31)
/* 80327310 00323EF0  98 1E 00 01 */	stb r0, 1(r30)
/* 80327314 00323EF4  88 1F 00 01 */	lbz r0, 1(r31)
/* 80327318 00323EF8  98 1E 00 02 */	stb r0, 2(r30)
/* 8032731C 00323EFC  88 1F 00 00 */	lbz r0, 0(r31)
/* 80327320 00323F00  98 1E 00 03 */	stb r0, 3(r30)
lbl_80327324:
/* 80327324 00323F04  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 80327328 00323F08  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 8032732C 00323F0C  38 21 00 18 */	addi r1, r1, 0x18
/* 80327330 00323F10  80 01 00 04 */	lwz r0, 4(r1)
/* 80327334 00323F14  7C 08 03 A6 */	mtlr r0
/* 80327338 00323F18  4E 80 00 20 */	blr 

.global TRKReadBuffer1_ui64
TRKReadBuffer1_ui64:
/* 8032733C 00323F1C  7C 08 02 A6 */	mflr r0
/* 80327340 00323F20  3C A0 80 4A */	lis r5, lbl_804A3170@ha
/* 80327344 00323F24  90 01 00 04 */	stw r0, 4(r1)
/* 80327348 00323F28  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 8032734C 00323F2C  93 E1 00 14 */	stw r31, 0x14(r1)
/* 80327350 00323F30  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80327354 00323F34  3B C4 00 00 */	addi r30, r4, 0
/* 80327358 00323F38  80 05 31 70 */	lwz r0, lbl_804A3170@l(r5)
/* 8032735C 00323F3C  2C 00 00 00 */	cmpwi r0, 0
/* 80327360 00323F40  41 82 00 0C */	beq lbl_8032736C
/* 80327364 00323F44  7F DF F3 78 */	mr r31, r30
/* 80327368 00323F48  48 00 00 08 */	b lbl_80327370
lbl_8032736C:
/* 8032736C 00323F4C  3B E1 00 08 */	addi r31, r1, 8
lbl_80327370:
/* 80327370 00323F50  38 9F 00 00 */	addi r4, r31, 0
/* 80327374 00323F54  38 A0 00 08 */	li r5, 8
/* 80327378 00323F58  4B FF FB E1 */	bl TRKReadBuffer
/* 8032737C 00323F5C  3C 80 80 4A */	lis r4, lbl_804A3170@ha
/* 80327380 00323F60  80 04 31 70 */	lwz r0, lbl_804A3170@l(r4)
/* 80327384 00323F64  2C 00 00 00 */	cmpwi r0, 0
/* 80327388 00323F68  40 82 00 4C */	bne lbl_803273D4
/* 8032738C 00323F6C  2C 03 00 00 */	cmpwi r3, 0
/* 80327390 00323F70  40 82 00 44 */	bne lbl_803273D4
/* 80327394 00323F74  88 1F 00 07 */	lbz r0, 7(r31)
/* 80327398 00323F78  98 1E 00 00 */	stb r0, 0(r30)
/* 8032739C 00323F7C  88 1F 00 06 */	lbz r0, 6(r31)
/* 803273A0 00323F80  98 1E 00 01 */	stb r0, 1(r30)
/* 803273A4 00323F84  88 1F 00 05 */	lbz r0, 5(r31)
/* 803273A8 00323F88  98 1E 00 02 */	stb r0, 2(r30)
/* 803273AC 00323F8C  88 1F 00 04 */	lbz r0, 4(r31)
/* 803273B0 00323F90  98 1E 00 03 */	stb r0, 3(r30)
/* 803273B4 00323F94  88 1F 00 03 */	lbz r0, 3(r31)
/* 803273B8 00323F98  98 1E 00 04 */	stb r0, 4(r30)
/* 803273BC 00323F9C  88 1F 00 02 */	lbz r0, 2(r31)
/* 803273C0 00323FA0  98 1E 00 05 */	stb r0, 5(r30)
/* 803273C4 00323FA4  88 1F 00 01 */	lbz r0, 1(r31)
/* 803273C8 00323FA8  98 1E 00 06 */	stb r0, 6(r30)
/* 803273CC 00323FAC  88 1F 00 00 */	lbz r0, 0(r31)
/* 803273D0 00323FB0  98 1E 00 07 */	stb r0, 7(r30)
lbl_803273D4:
/* 803273D4 00323FB4  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 803273D8 00323FB8  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 803273DC 00323FBC  38 21 00 18 */	addi r1, r1, 0x18
/* 803273E0 00323FC0  80 01 00 04 */	lwz r0, 4(r1)
/* 803273E4 00323FC4  7C 08 03 A6 */	mtlr r0
/* 803273E8 00323FC8  4E 80 00 20 */	blr 

.global TRKReadBuffer_ui8
TRKReadBuffer_ui8:
/* 803273EC 00323FCC  7C 08 02 A6 */	mflr r0
/* 803273F0 00323FD0  90 01 00 04 */	stw r0, 4(r1)
/* 803273F4 00323FD4  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 803273F8 00323FD8  93 E1 00 14 */	stw r31, 0x14(r1)
/* 803273FC 00323FDC  3B E0 00 00 */	li r31, 0
/* 80327400 00323FE0  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80327404 00323FE4  3B C5 00 00 */	addi r30, r5, 0
/* 80327408 00323FE8  93 A1 00 0C */	stw r29, 0xc(r1)
/* 8032740C 00323FEC  3B A4 00 00 */	addi r29, r4, 0
/* 80327410 00323FF0  93 81 00 08 */	stw r28, 8(r1)
/* 80327414 00323FF4  3B 83 00 00 */	addi r28, r3, 0
/* 80327418 00323FF8  38 60 00 00 */	li r3, 0
/* 8032741C 00323FFC  48 00 00 14 */	b lbl_80327430
lbl_80327420:
/* 80327420 00324000  38 7C 00 00 */	addi r3, r28, 0
/* 80327424 00324004  7C 9D FA 14 */	add r4, r29, r31
/* 80327428 00324008  4B FF FD E1 */	bl TRKReadBuffer1_ui8
/* 8032742C 0032400C  3B FF 00 01 */	addi r31, r31, 1
lbl_80327430:
/* 80327430 00324010  2C 03 00 00 */	cmpwi r3, 0
/* 80327434 00324014  40 82 00 0C */	bne lbl_80327440
/* 80327438 00324018  7C 1F F0 00 */	cmpw r31, r30
/* 8032743C 0032401C  41 80 FF E4 */	blt lbl_80327420
lbl_80327440:
/* 80327440 00324020  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 80327444 00324024  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 80327448 00324028  83 A1 00 0C */	lwz r29, 0xc(r1)
/* 8032744C 0032402C  83 81 00 08 */	lwz r28, 8(r1)
/* 80327450 00324030  38 21 00 18 */	addi r1, r1, 0x18
/* 80327454 00324034  80 01 00 04 */	lwz r0, 4(r1)
/* 80327458 00324038  7C 08 03 A6 */	mtlr r0
/* 8032745C 0032403C  4E 80 00 20 */	blr 

.global TRKReadBuffer_ui32
TRKReadBuffer_ui32:
/* 80327460 00324040  7C 08 02 A6 */	mflr r0
/* 80327464 00324044  90 01 00 04 */	stw r0, 4(r1)
/* 80327468 00324048  94 21 FF E8 */	stwu r1, -0x18(r1)
/* 8032746C 0032404C  93 E1 00 14 */	stw r31, 0x14(r1)
/* 80327470 00324050  93 C1 00 10 */	stw r30, 0x10(r1)
/* 80327474 00324054  3B C0 00 00 */	li r30, 0
/* 80327478 00324058  57 C0 10 3A */	slwi r0, r30, 2
/* 8032747C 0032405C  93 A1 00 0C */	stw r29, 0xc(r1)
/* 80327480 00324060  7F E4 02 14 */	add r31, r4, r0
/* 80327484 00324064  3B A5 00 00 */	addi r29, r5, 0
/* 80327488 00324068  93 81 00 08 */	stw r28, 8(r1)
/* 8032748C 0032406C  3B 83 00 00 */	addi r28, r3, 0
/* 80327490 00324070  38 60 00 00 */	li r3, 0
/* 80327494 00324074  48 00 00 18 */	b lbl_803274AC
lbl_80327498:
/* 80327498 00324078  38 7C 00 00 */	addi r3, r28, 0
/* 8032749C 0032407C  38 9F 00 00 */	addi r4, r31, 0
/* 803274A0 00324080  4B FF FE 0D */	bl TRKReadBuffer1_ui32
/* 803274A4 00324084  3B DE 00 01 */	addi r30, r30, 1
/* 803274A8 00324088  3B FF 00 04 */	addi r31, r31, 4
lbl_803274AC:
/* 803274AC 0032408C  2C 03 00 00 */	cmpwi r3, 0
/* 803274B0 00324090  40 82 00 0C */	bne lbl_803274BC
/* 803274B4 00324094  7C 1E E8 00 */	cmpw r30, r29
/* 803274B8 00324098  41 80 FF E0 */	blt lbl_80327498
lbl_803274BC:
/* 803274BC 0032409C  83 E1 00 14 */	lwz r31, 0x14(r1)
/* 803274C0 003240A0  83 C1 00 10 */	lwz r30, 0x10(r1)
/* 803274C4 003240A4  83 A1 00 0C */	lwz r29, 0xc(r1)
/* 803274C8 003240A8  83 81 00 08 */	lwz r28, 8(r1)
/* 803274CC 003240AC  38 21 00 18 */	addi r1, r1, 0x18
/* 803274D0 003240B0  80 01 00 04 */	lwz r0, 4(r1)
/* 803274D4 003240B4  7C 08 03 A6 */	mtlr r0
/* 803274D8 003240B8  4E 80 00 20 */	blr 
