#ifndef WEBDRIVERXX_KEYS_H
#define WEBDRIVERXX_KEYS_H 

#include <string>
#include <vector>

namespace webdriverxx {
namespace keys { 

const char *const Null = "\xee\x80\x80";
const char *const Cancel = "\xee\x80\x81";
const char *const Help = "\xee\x80\x82";
const char *const Backspace = "\xee\x80\x83";
const char *const Tab = "\xee\x80\x84";
const char *const Clear = "\xee\x80\x85";
const char *const Return = "\xee\x80\x86";
const char *const Enter = "\xee\x80\x87";
const char *const Shift = "\xee\x80\x88";
const char *const Control = "\xee\x80\x89";
const char *const Alt = "\xee\x80\x8a";
const char *const Pause = "\xee\x80\x8b";
const char *const Escape = "\xee\x80\x8c";
const char *const Space = "\xee\x80\x8d";
const char *const PageUp = "\xee\x80\x8e";
const char *const PageDown = "\xee\x80\x8f";
const char *const End = "\xee\x80\x90";
const char *const Home = "\xee\x80\x91";
const char *const Left = "\xee\x80\x92";
const char *const Up = "\xee\x80\x93";
const char *const Right = "\xee\x80\x94";
const char *const Down = "\xee\x80\x95";
const char *const Insert = "\xee\x80\x96";
const char *const Delete = "\xee\x80\x97";
const char *const Semicolon = "\xee\x80\x98";
const char *const Equals = "\xee\x80\x99";
const char *const Numpad0 = "\xee\x80\x9a";
const char *const Numpad1 = "\xee\x80\x9b";
const char *const Numpad2 = "\xee\x80\x9c";
const char *const Numpad3 = "\xee\x80\x9d";
const char *const Numpad4 = "\xee\x80\x9e";
const char *const Numpad5 = "\xee\x80\x9f";
const char *const Numpad6 = "\xee\x80\xa0";
const char *const Numpad7 = "\xee\x80\xa1";
const char *const Numpad8 = "\xee\x80\xa2";
const char *const Numpad9 = "\xee\x80\xa3";
const char *const Multiply = "\xee\x80\xa4";
const char *const Add = "\xee\x80\xa5";
const char *const Separator = "\xee\x80\xa6";
const char *const Subtract = "\xee\x80\xa7";
const char *const Decimal = "\xee\x80\xa8";
const char *const Divide = "\xee\x80\xa9";
const char *const F1 = "\xee\x80\xb1";
const char *const F2 = "\xee\x80\xb2";
const char *const F3 = "\xee\x80\xb3";
const char *const F4 = "\xee\x80\xb4";
const char *const F5 = "\xee\x80\xb5";
const char *const F6 = "\xee\x80\xb6";
const char *const F7 = "\xee\x80\xb7";
const char *const F8 = "\xee\x80\xb8";
const char *const F9 = "\xee\x80\xb9";
const char *const F10 = "\xee\x80\xba";
const char *const F11 = "\xee\x80\xbb";
const char *const F12 = "\xee\x80\xbc";
const char *const Command = "\xee\x80\xbd";
const char *const Meta = Command;

} // namespace keys 

namespace detail {
class Keyboard;
} // namespace detail

class Shortcut // copyable
{
public:
	Shortcut& operator << (const std::string& key) {
		keys_.push_back(key);
		return *this;
	}

	Shortcut& operator << (const char* key) {
		keys_.push_back(key);
		return *this;
	}

private:
	friend class detail::Keyboard;
	std::vector<std::string> keys_;
};

} // namespace webdriverxx 

#endif
