#ifndef __MINWINBASE_H__
#define __MINWINBASE_H__

#include <windef.h>
#include <xboxkrnl/ntstatus.h>

typedef struct _FILETIME {
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME, *LPFILETIME;

typedef struct _OVERLAPPED
{
    ULONG_PTR Internal;
    ULONG_PTR InternalHigh;
    DWORD Offset;
    DWORD OffsetHigh;
    HANDLE hEvent;
} OVERLAPPED, *LPOVERLAPPED;

typedef struct _SYSTEMTIME 
{
    WORD wYear;
    WORD wMonth;
    WORD wDayOfWeek;
    WORD wDay;
    WORD wHour;
    WORD wMinute;
    WORD wSecond;
    WORD wMilliseconds;
} SYSTEMTIME, *PSYSTEMTIME, *LPSYSTEMTIME;

#define STILL_ACTIVE                       STATUS_PENDING
#define EXCEPTION_ACCESS_VIOLATION         STATUS_ACCESS_VIOLATION
#define EXCEPTION_DATATYPE_MISALIGNMENT    STATUS_DATATYPE_MISALIGNMENT
#define EXCEPTION_BREAKPOINT               STATUS_BREAKPOINT
#define EXCEPTION_SINGLE_STEP              STATUS_SINGLE_STEP
#define EXCEPTION_ARRAY_BOUNDS_EXCEEDED    STATUS_ARRAY_BOUNDS_EXCEEDED
#define EXCEPTION_FLT_DENORMAL_OPERAND     STATUS_FLOAT_DENORMAL_OPERAND
#define EXCEPTION_FLT_DIVIDE_BY_ZERO       STATUS_FLOAT_DIVIDE_BY_ZERO
#define EXCEPTION_FLT_INEXACT_RESULT       STATUS_FLOAT_INEXACT_RESULT
#define EXCEPTION_FLT_INVALID_OPERATION    STATUS_FLOAT_INVALID_OPERATION
#define EXCEPTION_FLT_OVERFLOW             STATUS_FLOAT_OVERFLOW
#define EXCEPTION_FLT_STACK_CHECK          STATUS_FLOAT_STACK_CHECK
#define EXCEPTION_FLT_UNDERFLOW            STATUS_FLOAT_UNDERFLOW
#define EXCEPTION_INT_DIVIDE_BY_ZERO       STATUS_INTEGER_DIVIDE_BY_ZERO
#define EXCEPTION_INT_OVERFLOW             STATUS_INTEGER_OVERFLOW
#define EXCEPTION_PRIV_INSTRUCTION         STATUS_PRIVILEGED_INSTRUCTION
#define EXCEPTION_IN_PAGE_ERROR            STATUS_IN_PAGE_ERROR
#define EXCEPTION_ILLEGAL_INSTRUCTION      STATUS_ILLEGAL_INSTRUCTION
#define EXCEPTION_NONCONTINUABLE_EXCEPTION STATUS_NONCONTINUABLE_EXCEPTION
#define EXCEPTION_STACK_OVERFLOW           STATUS_STACK_OVERFLOW
#define EXCEPTION_INVALID_DISPOSITION      STATUS_INVALID_DISPOSITION
#define EXCEPTION_GUARD_PAGE               STATUS_GUARD_PAGE_VIOLATION
#define EXCEPTION_INVALID_HANDLE           STATUS_INVALID_HANDLE

#endif
