# OpenXenium PCB.
This board was designed using [Autodesk Eagle](https://www.autodesk.com/products/eagle/overview). You can edit the `.brd` and `.sch` with this program.

You can order via KitSpace: https://kitspace.org/boards/github.com/ryzee119/openxenium/.

## Printed Circuit Board
When fabricating your own, you can download the premade gerbers from the `Release` section or generate your own. Suggested PCB properties are:  <br>
*2 layers, 40x37mm, 1.6mm thick, HASL, 1oz copper, no castellated holes, any colour you want!*<br>

## Bill of Materials
All the passive components listed (Resistors, capacitors etc) are listed for reference only. Any equivalents you find would be suitable. Use your best judgement. 
You should check this list against the schematic to ensure nothing is missed.  
**Digikey Quick Cart: https://www.digikey.com.au/short/pnvbrn**  

| Qty | Value/Model | Description | Marking | URL (Passive components provided as sample only) |
| --- | --- | --- | --- | --- |
| 1 | XC9572XL-10VQG64C | IC CPLD 72MC 10NS 64VQFP | U1 | https://www.digikey.com.au/short/p2475b |
| 1 | AM29LV160MT-100EI (legacy) or S29AL016J70TFI010 | 16MBIT PARALLEL FLASH MEMORY 48TSOP | U2 | https://www.digikey.com.au/short/pnv9rj |
| 1 | 19-237/R6GHBHC-A07/2T | LED RGB CLEAR 4SMD. COMMON ANODE | LED1 | https://www.digikey.com.au/short/p2475q |
| 1 | SM10B-SRSS-TB| JST SM CONN HEADER SMD R/A 10POS 1MM | J1 | [https://www.digikey.com/short/p247b3](https://www.digikey.com/short/p247b3)|
| 2 | CL10B104KB8NNNC | CAP CER 0.1UF 50V 0603 | C1,C2 | https://www.digikey.com.au/short/p247rf |
| 1 | JMK107ABJ106MA-T | CAP CER 10UF 6.3V 0603 | C4 | https://www.digikey.com.au/short/p247rc |
| 3 | RK73B1JTTD680J | RES 68 OHM 5% 1/8W 0603 | R1,R2,R3 | https://www.digikey.com.au/short/p247rp |
| 1 | RMCF0603JJ1K00| RES 1K OHM 5% 1/10W 0603 | R5 | https://www.digikey.com.au/short/p247bf |
| 4 | IRLML6246TRPBF | MOSFET N-CH 20V 4.1A SOT-23 | Q1,Q2,Q3,Q4| https://www.digikey.com.au/short/p247bm |
| 1 | PPTC072LFBN-RC | PPTC072LFBN-RC | LPC | https://www.digikey.com.au/short/pnvbcc |

## High Res Assembled Photo
![High Res Photo](https://github.com/Ryzee119/OpenXenium/blob/master/Images/openxenium3.jpg?raw=true)
By Ryzee119
