<?
//Include the header
View::show_header('Uploading Rules', 'rules');
?>
<!-- Uploading Rules -->
<div class="thin">
	<div class="header">
		<h2>Uploading Rules</h2>
	</div>
<!-- Uploading Rules Index Links -->
	<br />
	<form class="search_form" name="rules" onsubmit="return false" action="">
		<input type="text" id="search_string" value="Filter (empty to reset)" />
		<span id="Index">Example: The search term <strong>FLAC</strong> returns all rules containing <strong>FLAC</strong>. The search term <strong>FLAC+trump</strong> returns all rules containing both <strong>FLAC</strong> and <strong>trump</strong>.</span>
	</form>
	<br />
	<div class="before_rules">
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="Introk"><a href="#Intro"><strong>Introduction</strong></a></li>
				<li id="h1k"><a href="#h1">1. <strong>Uploading Rules</strong></a>
					<ul>
						<li id="h1.1k"><a href="#h1.1">1.1. <strong>General</strong></a></li>
						<li id="h1.2k"><a href="#h1.2">1.2. <strong>Specifically Banned</strong></a></li>
						<li id="h1.3k"><a href="#h1.3">1.3. <strong>Scene Uploads</strong></a></li>
					</ul>
				</li>
				<li id="h2k"><a href="#h2">2. <strong>Music</strong></a>
					<ul>
						<li id="h2.1k"><a href="#h2.1">2.1. <strong>General</strong></a></li>
						<li id="h2.2k"><a href="#h2.2">2.2. <strong>Duplicates &amp; Trumping</strong></a>
							<ul>
								<li id="r2.2.9k"><a href="#r2.2.9">2.2.9. <strong>Lossy rules</strong></a></li>
								<li id="r2.2.10k"><a href="#r2.2.10">2.2.10. <strong>Lossless rules</strong></a></li>
								<li id="r2.2.11k"><a href="#r2.2.11">2.2.11. <strong>Editions and Releases rules</strong></a></li>
							</ul>
						</li>
						<li id="h2.3k"><a href="#h2.3">2.3. <strong>Formatting</strong></a></li>
						<li id="h2.4k"><a href="#h2.4">2.4. <strong>Bonus Content</strong></a></li>
						<li id="h2.5k"><a href="#h2.5">2.5. <strong>Vinyl</strong></a></li>
						<li id="h2.6k"><a href="#h2.6">2.6. <strong>Live Music and Soundboards</strong></a>
							<ul>
								<li id="r2.6.9.1k"><a href="#r2.6.9.1">2.6.9.1. <strong>Allowed Live Music</strong></a></li>
								<li id="r2.6.9.2k"><a href="#r2.6.9.2">2.6.9.2. <strong>Disallowed Live Music</strong></a></li>
							</ul>
						</li>
						<li id="h2.7k"><a href="#h2.7">2.7. <strong>Multichannel</strong></a></li>
						<li id="h2.8k"><a href="#h2.8">2.8. <strong>SACD</strong></a></li>
						<li id="h2.9k"><a href="#h2.9">2.9. <strong>Blu-ray</strong></a></li>
						<li id="h2.10k"><a href="#h2.10">2.10. <strong>Cassettes</strong></a></li>
					</ul>
				</li>
				<li id="h3k"><a href="#h3">3. <strong>Comedy (Audio) &amp; Audiobooks</strong></a></li>
				<li id="h4k"><a href="#h4">4. <strong>Applications</strong></a>
					<ul>
						<li id="h4.1k"><a href="#h4.1">4.1. <strong>General</strong></a></li>
						<li id="h4.2k"><a href="#h4.2">4.2. <strong>Duplicates &amp; Trumping</strong></a></li>
					</ul>
				</li>
				<li id="h5k"><a href="#h5">5. <strong>Comic Books</strong></a>
					<ul>
						<li id="h5.1k"><a href="#h5.1">5.1. <strong>General</strong></a></li>
						<li id="h5.2k"><a href="#h5.2">5.2. <strong>Multi-comic</strong></a></li>
						<li id="h5.3k"><a href="#h5.3">5.3. <strong>Duplicates &amp; Trumping</strong></a></li>
						<li id="h5.4k"><a href="#h5.4">5.4. <strong>Formatting</strong></a></li>
					</ul>
				</li>
				<li id="h6k"><a href="#h6">6. <strong>ebooks, eLearning Books &amp; Sheet Music</strong></a></li>
				<li id="h7k"><a href="#h7">7. <strong>eLearning Videos</strong></a></li>
			</ul>
		</div>
	</div>
<!-- Actual Uploading Rules -->
	<div id="actual_rules">
		<div class="before_rules">
			<h4 id="Intro"><a href="#Introk"><strong>&uarr;</strong></a> Introduction</h4>
			<div class="box pad" style="padding: 10px 10px 10px 20px;">
				<p>The uploading rules below are overwhelmingly long and detailed for a reason. The length is necessary to explain the rules clearly and thoroughly. A summary of each rule is in <span style="font-weight: bold;">bold text</span> before the actual rule for easier reading. You may also find the corresponding rule sections in the <a href="#Index">Index</a>. The corresponding <a href="#">&uarr;</a> (move one level up) and <a href="#Index">rule section links</a> (move down into the document) help provide quick navigation.</p>
				<p>Before you upload anything, if you are still unsure of what a rule means, PLEASE ask your questions at any of the following points of site user support: <a href="staff.php">First-Line Support</a>, <a href="forums.php?action=viewforum&amp;forumid=8">the Help Forum</a>, or <a href="wiki.php?action=article&amp;name=IRC"><?=BOT_HELP_CHAN?> on IRC</a>. Send a <a href="staffpm.php">Staff PM</a> addressed to staff if other support has directed you to a moderator or if support has been unhelpful in your particular case. If you find any dead or broken links in the upload rules, send a <a href="staffpm.php">Staff PM</a> addressed to staff, and include in your message the upload rule number (e.g. <a href="#r2.4.3">2.4.3</a>) and preferably the correct link to replace the broken one.</p>
			</div>
		</div>
		<h4 id="h1"><a href="#h1k"><strong>&uarr;</strong></a> <a href="#h1">1.</a> Uploading Rules</h4>

		<h5 id="h1.1"><a href="#h1.1k"><strong>&uarr;</strong></a> <a href="#h1.1">1.1.</a> General</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r1.1.1"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.1">1.1.1.</a>
					<strong>Only music, applications, comic books, ebooks, comedy (audio), audiobooks, and music-related eLearning videos are allowed on the site.</strong>
				</li>
				<li id="r1.1.2"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.2">1.1.2.</a>
					<strong>Duplicate torrents in any category are not allowed.</strong> There are some exceptions to this rule, which are outlined in their relevant sections below.
				</li>
				<li id="r1.1.3"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.3">1.1.3.</a>
					<strong>No freely available content in non-music sections.</strong> If you could just download something from the web, so can everyone else. Each main section explains in greater detail what "freely available" means in the context of that section. See <a href="#r2.1.9">2.1.9</a> in regards to freely available music. See <a href="#r4.1.3">4.1.3</a> in regards to freely available applications.
				</li>
				<li id="r1.1.4"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.4">1.1.4.</a>
					<strong>Seed complete copies of your uploads.</strong> Do not upload a torrent unless you intend to seed until there are at least 1.0 distributed copies. Seeding past this minimum is strongly encouraged.
				</li>
				<li id="r1.1.5"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.5">1.1.5.</a>
					<strong>No advertising or personal credits.</strong> Providing artist, album, label, or retailer information is not considered advertising.
				</li>
				<ul>
					<li id="r1.1.5.1"><a href="#h1.1.5"><strong>&uarr;_</strong></a> <a href="#r1.1.5.1">1.1.5.1</a>
						<strong>Do not advertise sites, groups, or persons in torrent contents (e.g., folder names, file names, or file tags).</strong> Exceptions: untouched scene uploads are exempt from this rule. For analog uploads, ripper credits may be included in a lineage text file, in a folder name, or in an optional file tag field (e.g. "comment" or "ripped by"), but never in a required tag field).
					</li>
					<li id="r1.1.5.2"><a href="#h1.1.5"><strong>&uarr;_</strong></a> <a href="#r1.1.5.2">1.1.5.2</a>
						<strong>Do not advertise sites, groups, or persons in torrent descriptions.</strong> Exception: torrent source information (e.g. ripper, scene group, or original uploader credit) is allowed in torrent descriptions.
					</li>
				</ul>
				<li id="r1.1.6"><a href="#h1.1"><strong>&uarr;_</strong></a> <a href="#r1.1.6">1.1.6.</a>
					<strong>Archived files in uploads are not allowed.</strong> Exceptions: The sections that allow archived files (e.g., zip, rar, iso, etc.) are the following:
					<ul>
						<li>Comic Books (.cbr and .cbz).</li>
						<li>Scene released torrents in non-music categories.</li>
						<li>Sheet music may be individually archived.</li>
					</ul>
				</li>
			</ul>
		</div>
		<h5 id="h1.2"><a href="#h1.2k"><strong>&uarr;</strong></a> <a href="#h1.2">1.2.</a> Specifically Banned</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r1.2.1"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.1">1.2.1.</a>
					<strong>Anything not specifically allowed below.</strong> If you have any doubts, ask before uploading.
				</li>
				<li id="r1.2.2"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.2">1.2.2.</a>
					<strong>Any car parts and car data programs.</strong> This ban includes programs like AllData and vendor-specific diagnostic programs such as Carsoft.
				</li>
				<li id="r1.2.3"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.3">1.2.3.</a>
					<strong>Videos of any kind (other than eLearning Videos).</strong> No movies, no TV shows, no concerts, and no data/video tracks from enhanced CDs.
				</li>
				<li id="r1.2.4"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.4">1.2.4.</a>
					<strong>Pornography or nudity of any kind unless it is part of the official packaging for a commercial audio release.</strong> This ban includes pictures, erotic comic books or hentai, sex manuals, erotic magazines, etc.
				</li>
				<li id="r1.2.5"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.5">1.2.5.</a>
					<strong>Games of any kind.</strong> No games of any kind for PC, Mac, Linux, mobile devices, or any other platform are allowed.
				</li>
				<li id="r1.2.6"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.6">1.2.6.</a>
					<strong>Collections of pictures or wallpapers are not applications.</strong> You may not upload them to any category. Commercially available template and clip art packs are acceptable for the application category (see <a href="#r4.1.9">4.1.9</a>).
				</li>
				<li id="r1.2.7"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.7">1.2.7.</a>
					<strong>User compilations in any category.</strong> All releases, packs, or collections must be reasonably official as specified in each category.
				</li>
				<li id="r1.2.8"><a href="#h1.2"><strong>&uarr;_</strong></a> <a href="#r1.2.8">1.2.8.</a>
					<strong>DRM-restricted files.</strong> Files must not be encrypted or be in a restricted format that impedes sharing. You are also highly encouraged to remove personal information from any non-DRM protected files (such as iTunes Plus releases).
				</li>
			</ul>
		</div>
		<h5 id="h1.3"><a href="#h1.3k"><strong>&uarr;</strong></a> <a href="#h1.3">1.3.</a> Scene Uploads</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r1.3.1"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.1">1.3.1.</a>
					<strong>You may give credit to the release group (optional).</strong> If you really want to give credit to the release group, mention the full release name, including group name, in the Release description section only. Do not add this information to the Album description section.
				</li>
				<li id="r1.3.2"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.2">1.3.2.</a>
					<strong>No NFO art pasted in the album description.</strong> Unedited NFOs are allowed within the specific torrent Release description - not in the Album page description. If you must include some information from the NFO in the Album description or Release description, include only the tracklist, album notes, and other essential information. Specific encoding settings belong in the Release description.
				</li>
				<li id="r1.3.3"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.3">1.3.3.</a>
					<strong>Use the actual album title on the <a href="upload.php">upload page</a>; do not use the scene-given title.</strong> Naming your album_titles_like_this or your.albums.like.this is not allowed. Use the actual release title and artist. Do not use the title from the torrent folder or NFO for the scene release.
				</li>
				<li id="r1.3.4"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.4">1.3.4.</a>
					<strong>Scene releases must be complete (as released) to use the Scene label.</strong> If you've changed the tags, unpacked the archive, removed any files, split the tracks, or altered the track naming, then it is no longer a scene release. It should not be labeled as such. If any of these changes has taken place, file names should not include any reference to the release group (see <a href="#r1.1.5">1.1.5</a>, <a href="#r2.3.2">2.3.2</a>, and <a href="#r2.3.11">2.3.11</a>).
				</li>
				<li id="r1.3.5"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.5">1.3.5.</a>
					<strong>No protected archives.</strong> Archived releases must not be password protected.
				</li>
				<li id="r1.3.6"><a href="#h1.3"><strong>&uarr;_</strong></a> <a href="#r1.3.6">1.3.6.</a>
					<strong>Scene releases in each torrent category must conform to the rules specified for their respective sections.</strong> For example, music scene releases must adhere to the music quality and formatting rules no matter how the original files were released. If the scene archives were password protected, you cannot upload them to this site unmodified. Exceptions: You may upload scene releases that originally do not fit in the rules if you can make the necessary changes within the rules. However, these modified uploads must not be labeled as scene.
				</li>
			</ul>
		</div>
		<h4 id="h2"><a href="#h2k"><strong>&uarr;</strong></a> <a href="#h2">2.</a> Music</h4>

		<h5 id="h2.1"><a href="#h2.1k"><strong>&uarr;</strong></a> <a href="#h2.1">2.1.</a> General</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>

				<li id="r2.1.1"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.1">2.1.1.</a> <strong>The only formats allowed for music are:</strong>
					<ul>
						<li><strong>Lossy:</strong> MP3, AAC, AC3, DTS</li>
						<li><strong>Lossless:</strong> FLAC (maximum 24-bit depth, maximum 192 kHz sampling rate)</li>
					</ul>
					<span style="font-style: italic;">Only standard versions of each format are allowed. Hybrid formats that combine both lossless and lossy audio data in the same file, such as DTS-HD, mp3HD, and HD-AAC, are not allowed. AC3 and DTS are reserved for commercial media sources and only if they contain such tracks; transcoding from any other source, including lossless (e.g., PCM and MLP formats), is not allowed.</span>
				</li>
				<li id="r2.1.2"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.2">2.1.2.</a> <strong>No transcodes or re-encodes of lossy releases are acceptable here.</strong>
					<ul>
						<li id="r2.1.2.1"><a href="#r2.1.2"><strong>&uarr;_</strong></a> <a href="#r2.1.2.1">2.1.2.1.</a> <strong>The only acceptable transcodes are releases that were transcoded from a lossless source (e.g., CD, SBD, DAT, Vinyl, SACD, or LPCM).</strong> Please refer to <a href="wiki.php?action=article&amp;id=14">this wiki</a> for more information on transcodes and how to detect them.</li>
						<li id="r2.1.2.2"><a href="#r2.1.2"><strong>&uarr;_</strong></a> <a href="#r2.1.2.2">2.1.2.2.</a> <strong>Official lossy-mastered releases are not considered transcodes.</strong> They are allowed on the site. See <a href="wiki.php?action=article&amp;id=364">this wiki</a> for further information.</li>
						<li id="r2.1.2.3"><a href="#r2.1.2"><strong>&uarr;_</strong></a> <a href="#r2.1.2.3">2.1.2.3.</a> <strong>Releases from Bandcamp, Beatport, and similar online retailers are considered official lossy-mastered releases when lossy mastered by the artist or label.</strong> A non-lossy mastered release from any source may trump a lossy mastered release from a WEB source. And if the same WEB retailer revises their release and subsequently supplies a non-lossy mastered release, the new source may trump the original upload.</li>
					</ul>
				</li>
				<li id="r2.1.3"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.3">2.1.3.</a> <strong>Music releases must have an average bitrate of at least 192 kbps regardless of the format.</strong> Exceptions: The following VBR encodes may go under the 192 kbps limit: LAME V2 (VBR), V1 (VBR), V0 (VBR), APS (VBR), APX (VBR), MP3 192 (VBR), and AAC ~192 (VBR) to AAC ~256 (VBR) releases. See <a href="wiki.php?action=article&amp;id=11">this wiki</a> for more information on encoding options.</li>
				<li id="r2.1.4"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.4">2.1.4.</a> <strong>Bitrates must accurately reflect encoder presets or the average bitrate of the audio files.</strong> You are responsible for supplying correct format and bitrate information on the <a href="upload.php">upload page</a>. See <a href="wiki.php?action=article&amp;id=714">this wiki</a> for further information.</li>
				<li id="r2.1.5"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.5">2.1.5.</a> <strong>Albums must not be ripped or uploaded as a single track.</strong>
					<ul>
						<li id="r2.1.5.1"><a href="#r2.1.5"><strong>&uarr;_</strong></a> <a href="#r2.1.5.1">2.1.5.1.</a> <strong>If the tracks on the original CD were separate, you must rip them to separate files.</strong> Unsplit rips may be present on the site but are NOT the preferred format for lossless rips. Any unsplit FLAC rips lacking a cue sheet will be deleted outright. Any unsplit FLAC rip that includes a cue sheet will be trumpable by a properly split FLAC torrent. CDs with single tracks can be uploaded without prior splitting. See <a href="wiki.php?action=article&amp;id=947">this wiki</a> for information on unsplit rips. Information about splitting rips can be <a href="wiki.php?action=article&amp;id=111">found here</a>. Users who upload unsplit rips will be warned.</li>
						<li id="r2.1.5.2"><a href="#r2.1.5"><strong>&uarr;_</strong></a> <a href="#r2.1.5.2">2.1.5.2.</a> <strong>Gapless DJ or professional mixes released as MP3+CUE images are allowed as unseparated album images on the site.</strong> This includes scene DJ mixes. You cannot take a previously split collection of tracks and upload it as an unsplit mix because the original form of those audio tracks was not a single unsplit file. Such torrents will be removed when reported. Split and unsplit versions do not count as duplicates of one another and may coexist.</li>
						<li id="r2.1.5.3"><a href="#r2.1.5"><strong>&uarr;_</strong></a> <a href="#r2.1.5.3">2.1.5.3.</a> <strong>For albums that contain separate tracks, unsplit MP3 albums are allowed for continuous albums and mixes only and must include a cue sheet.</strong> If there is no reason for the album to be uploaded unsplit, or if the torrent is lacking a cue sheet, it will be deleted. Exception: If the retail version of an unsplit MP3 album is sold without a cue sheet, you may upload the unsplit rip without a cue sheet.</li>
					</ul>
				</li>
				<li id="r2.1.6"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.6">2.1.6.</a> <strong>All music torrents must be encoded with a single encoder using the same settings.</strong>
					<ul>
						<li id="r2.1.6.1"><a href="#r2.1.6"><strong>&uarr;_</strong></a> <a href="#r2.1.6.1">2.1.6.1.</a> <strong>This means that you cannot create a torrent that contains both CBR and VBR files, nor can you upload torrents containing a mix of APS (VBR)/V2 (VBR) and APX (VBR)/V0 (VBR) files.</strong> Likewise, this means that you cannot upload torrents containing files of varying bit depths or sampling rates. Exceptions: If the source media was delivered in different bit depths (e.g., 16-bit and 24-bit) or sampling rates (e.g., 48 kHz and 96 kHz) you may upload a torrent containing audio files with different attributes.</li>
						<li id="r2.1.6.2"><a href="#r2.1.6"><strong>&uarr;_</strong></a> <a href="#r2.1.6.2">2.1.6.2.</a> <strong>Some WEB-sourced albums are only available in hybrid collections (e.g., albums consisting of both 24-bit files and 16-bit files, 96 kHz-sampled and 48 kHz-sampled files, or stereophonic and monophonic files).</strong> If the online retailer supplies the files with such inconsistency, they are acceptable on the site. When requested by the staff, you must be able to provide proof of the WEB-sourcing in the form of web store receipts and album information indicating the non-uniform nature of the audio files. Label them according to the highest bit depth or sampling rate and be sure to note the variation in audio quality in the torrent description (e.g., Tracks 1, 2, and 3 are encoded at 24 bits while Tracks 4, 5, 6, and 7 are encoded at 16 bits).</li>
						<li id="r2.1.6.3"><a href="#r2.1.6"><strong>&uarr;_</strong></a> <a href="#r2.1.6.3">2.1.6.3.</a> <strong>Including other kinds of audio quality differences in a torrent (e.g., duplicate lossy files in a lossless torrent) is prohibited.</strong> This kind of release is referred to as a "mutt rip".</li>
					</ul>
				</li>
				<li id="r2.1.7"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.7">2.1.7.</a> <strong>Use only the allowed container formats for audio files.</strong> Use .m4a and .mp4 for AAC, and .flac for FLAC only. All other formats should not be encapsulated in random containers (e.g., FLAC must not be in an Ogg container, MP3 must not be in an .m4a container, and so forth). Exceptions: DTS CD-sourced audio rips, although contained in WAV, should have the .dts extension (see <a href="#h2.7">2.7</a>).</li>
				<li id="r2.1.8"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.8">2.1.8.</a> <strong>Music not sourced from vinyl must not contain pops, clicks, or skips.</strong> They will be deleted for rip/encode errors if reported. Music sourced from vinyl must follow the rules <a href="#h2.5">found here</a>.</li>
				<li id="r2.1.9"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.9">2.1.9.</a> <strong>Freely available music is allowed.</strong> Uploaded music may be freely available on the web (come from official sources such as record labels, band web sites, or the <a href="https://www.archive.org/index.php" target="_blank">Internet Archive</a>). Uploads can come from other torrent sites, but you are responsible for determining the audio quality of the music (e.g., that it is not transcoded, that it does not contain an edited log, that it is not a user compilation, etc.). Users are highly encouraged to provide a link to the source of their upload when uploading freely available music. However, this is not required and the lack of such a link to further information is not grounds for reporting a torrent. All freely available music must conform to both quality rules and formatting rules. This means it must be tagged correctly, not be a transcode, have separate tracks, and so forth. Freely available music uploads should have the "WEB" media format if no other source media (e.g., CD, DVD, etc.) can be established for the files.</li>
				<li id="r2.1.10"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.10">2.1.10.</a> <strong>Clearly label water-marked or voice-over releases.</strong> Watermarks or voice-overs must be clearly indicated in the torrent description. The torrent will be deleted for quality misrepresentation if this information is not noted.</li>
				<li id="r2.1.11"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.11">2.1.11.</a> <strong>Music ripped from the radio (Satellite or FM), television, the web, or podcasts are not allowed.</strong> See <a href="wiki.php?action=article&amp;id=948">this wiki</a> for the difference between web rips and the WEB category.</li>
				<li id="r2.1.12"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.12">2.1.12.</a> <strong>No unofficial audience recordings may be uploaded.</strong> These include but are not limited to AUD (Audience), IEM (In Ear Monitor), ALD (Assistive Listening Device), Mini-Disc, and Matrix-sourced recordings (see <a href="#r2.6.3">2.6.3</a>).</li>
				<li id="r2.1.13"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.13">2.1.13.</a> <strong>Tape (VHS, Video-8, etc.) music sources are not allowed, except for cassette rips and certain soundboards.</strong> See <a href="#h2.6">2.6</a> for further information.</li>
				<li id="r2.1.14"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.14">2.1.14.</a> <strong>The WEB media category is for digital downloads only.</strong> Digital downloads released only on the internet from internet sources cannot be given the CD media label on the <a href="upload.php">upload page</a>. This includes downloads from the iTunes Store, LiveDownloads, Beatport, Amazon.com, Rhapsody, and other web stores. Scene releases with no source information must be labeled as WEB. Freely available music with no source information must also be labeled as WEB. If possible, indicate the source of your files (e.g., the specific web store) in the torrent description. You are responsible for determining whether the downloaded files conform to <?=SITE_NAME?>'s rules for music quality. Note: Do not confuse WEB-sourced files with web rips (see <a href="wiki.php?action=article&amp;id=948">this wiki</a>). WEB media torrents are not always web rips (meaning <a href="wiki.php?action=article&amp;id=14">transcodes</a>). Please check the spectrals before assuming that they are web rips.</li>
				<li id="r2.1.15"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.15">2.1.15.</a> <strong>WEB uploads must be uploaded at the bit depths and sampling rates they were sold at.</strong> WEB uploads of the same audio with different sampling rates or bit depths may coexist if that is how they are sold or distributed. This means that if, for example, an album is sold with a bit depth of 24 bits and a sampling rate of 88.2 kHz, it must be uploaded directly with no modifications to the audio stream. An existing WEB upload of the same material with a bit depth of 24 and a sampling rate of 96 kHz may coexist with the new 24/88.2 upload but does not trump it. See <a href="#r2.1.6.2">2.1.6.2</a> for more information.</li>
				<li id="r2.1.16"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.16">2.1.16.</a> <strong>User-made compilations are not allowed.</strong>
					<ul>
						<li id="r2.1.16.1"><a href="#r2.1.16"><strong>&uarr;_</strong></a> <a href="#r2.1.16.1">2.1.16.1.</a> <strong>These are defined as compilations made by the uploader or anyone else who does not officially represent the artist or the label. </strong> Compilations must be reasonably official. For example, "34 of my favourite Grateful Dead songs" is not a reasonably official collection. Compiling a release from a list, such as a Top 100 Billboard Chart, is not allowed. User-made and unofficial multichannel mixes are also not allowed. See <a href="wiki.php?action=article&amp;id=973">this wiki</a> for more information.</li>
						<li id="r2.1.16.2"><a href="#r2.1.16"><strong>&uarr;_</strong></a> <a href="#r2.1.16.2">2.1.16.2.</a> <strong>Exceptions: Bootlegs are allowed if they meet quality standards for music and are proven to be retail releases in either a digital or physical form.</strong> Bootlegs/mixtapes assembled and available from internet-only sources (e.g., music blogs, message boards, etc.) are not considered official enough for this site.</li>
					</ul>
				</li>
				<li id="r2.1.17"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.17">2.1.17.</a> <strong>No comedy, audiobook, or spoken word releases may be uploaded as music.</strong> These torrents must not be grouped with other formats from the same release (i.e., they need to have individual torrent pages). See <a href="#r3.2">3.2</a> and <a href="wiki.php?action=article&amp;id=955">this wiki</a> for more information.</li>
				<li id="r2.1.18"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.18">2.1.18.</a> <strong>Sound sample packs must be uploaded as applications.</strong> See <a href="#r4.1.9">4.1.9</a> for more information.</li>
				<li id="r2.1.19"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.19">2.1.19.</a> <strong>All music torrents must represent a complete release, and may not be missing tracks (or discs in the case of a multi-disc release).</strong>
					<ul>
						<li id="r2.1.19.1"><a href="#r2.1.19"><strong>&uarr;_</strong></a> <a href="#r2.1.19.1">2.1.19.1.</a> <strong>If an album is released as a multi-disc set (or box set) of CDs or vinyl discs, then it must be uploaded as a single torrent.</strong> Preferably, each individual CD rip in a multi-disc set should be organized in its own folder (see <a href="#r2.3.15">2.3.15</a>).</li>
						<li id="r2.1.19.2"><a href="#r2.1.19"><strong>&uarr;_</strong></a> <a href="#r2.1.19.2">2.1.19.2.</a> <strong>A single track (e.g., one MP3 file) cannot be uploaded on its own unless it is an officially released single.</strong> If a specific track can only be found on an album, the entire album must be uploaded in the torrent.</li>
						<li id="r2.1.19.3"><a href="#r2.1.19"><strong>&uarr;_</strong></a> <a href="#r2.1.19.3">2.1.19.3.</a> <strong>Bonus discs may be uploaded separately in accordance with <a href="#h2.4">2.4</a>.</strong> Please note that individual bonus tracks cannot be uploaded without the rest of the album. Bonus tracks are not bonus discs. Enhanced audio CDs with data or video tracks must be uploaded without the non-audio tracks. If you want to share the videos or data, you may host the files off-site with a file sharing service and include the link to that service in your torrent description.</li>
					</ul>
				</li>
				<li id="r2.1.20"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.20">2.1.20.</a> <strong>User made discographies may not be uploaded.</strong> Multi-album torrents are not allowed on the site under any circumstances. That means no discographies, Pitchfork compilations, etc. If releases (e.g., CD singles) were never released as a bundled set, do not upload them together. Live soundboard material should be uploaded as one torrent per night, per show, or per venue. Including more than one show in a torrent results in a multi-album torrent. Exceptions: Only official boxsets and official compilation collections can contain multiple albums.</li>
				<li id="r2.1.21"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.21">2.1.21.</a> <strong><a href="wiki.php?action=article&amp;id=386">Pre-emphasis</a> is allowed in lossless torrents only.</strong> Lossless FLAC torrents with pre-emphasis are allowed on the site. They are allowed to coexist with lossless de-emphasized torrents (both in their separate album edition groups). In contrast, lossy formats may not have pre-emphasis and will be deleted if uploaded.</li>
				<li id="r2.1.22"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.22">2.1.22.</a> <strong>Edition Information must be provided for digitally-sourced torrents.</strong> Digitally-sourced (including CD-sourced) rips of albums that were first released before the availability of their source medium must have accurate edition information. For example, if a CD rip is of an album whose original release date was 1957, predating the creation and distribution of CDs, then the uploader must make note of the correct year in which the CD was pressed, and preferably note the catalog identification as well. Rips for which Edition Information cannot be provided must be marked as an "Unknown Release". Under no circumstances may you guess or feign knowledge of the Edition Information. See <a href="wiki.php?action=article&amp;id=367">this wiki</a> for more information on album editions.</li>
				<li id="r2.1.23"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.23">2.1.23.</a> <strong>Audio can only be ripped from a video game CD under very specific circumstances. Audio ripped from a video game DVD is not allowed on site.</strong>
					<ul>
						<li id="r2.1.23.1"><a href="#r2.1.23"><strong>&uarr;_</strong></a> <a href="#r2.1.23.1">2.1.23.1.</a> <strong>This audio layer must comply with the Red Book standard for audio data.</strong> If there is no Red Book audio on the game disc, you may not upload a rip of the disc. Be prepared to provide extensive information on any audio that is ripped from a gaming disc (see <a href="wiki.php?action=article&amp;id=953">this wiki</a> for information about providing proof).</li>
						<li id="r2.1.23.2"><a href="#r2.1.23"><strong>&uarr;_</strong></a> <a href="#r2.1.23.2">2.1.23.2.</a> <strong>The audio must meet the minimum requirements for music on the site (see <a href="#r2.1.3">2.1.3</a> and <a href="#r2.1.6">2.1.6</a>).</strong> </li>
						<li id="r2.1.23.3"><a href="#r2.1.23"><strong>&uarr;_</strong></a> <a href="#r2.1.23.3">2.1.23.3.</a> <strong>Officially-released game soundtracks, which adhere to Red Book standards, are always allowed.</strong> </li>
					</ul>
				</li>
				<li id="r2.1.24"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.24">2.1.24.</a> <strong>AAC torrents may only be uploaded if they represent editions unavailable on What.CD in any other format sourced from the same medium and edition (e.g., an iTunes AAC WEB release can co-exist with a CD release of the same edition).</strong> See <a href="#r2.2.9.11">2.2.9.11</a> for information about trumping AAC torrents.</li>
				<li id="r2.1.25"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.25">2.1.25.</a> <strong>No HDCD content may be uploaded to the site.</strong> There are inherent problems with ripping this format, and other forms of high-resolution audio are both more prevalent and preferred at this time (e.g., vinyl, SACD, Blu-ray, etc.). Any CD bearing the HDCD logo can still be ripped using the usual methods for ripping normal audio CDs. See <a href="wiki.php?action=article&amp;id=875">this wiki</a> for more details on the media format.</li>
				<li id="r2.1.26"><a href="#h2.1"><strong>&uarr;_</strong></a> <a href="#r2.1.26">2.1.26.</a> <strong> Downsampling of digital sources is allowed for certain media types.</strong> Downsampling of CD sources is strictly prohibited. Downsampling of WEB sources is allowed for audio files sampled at 88.2 kHz and above. If the WEB source is already sampled at a rate of either 44.1 kHz or 48 kHz you may not downsample the audio files any further. Downsampling of SACD, DVD, or Blu-ray sources is allowed in certain cases. See <a href="#r2.8.5">2.8.5</a>, <a href="#r2.7.3">2.7.3</a>, and <a href="#r2.9.5">2.9.5</a> for more information.</li>
			</ul>
		</div>
		<h5 id="h2.2"><a href="#h2.2k"><strong>&uarr;</strong></a> <a href="#h2.2">2.2.</a> Duplicates &amp; Trumping</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.2.0"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.0">2.2.0.</a> <strong>Overview</strong>
					<p style="text-align: center;">
						<img src="static/common/trumpchart.png" alt="Audio Dupe and Trump Chart" /><br /><br />
						<em>This chart is an overview of how the dupe and trump rules work.</em>
					</p>
				</li>
				<li id="r2.2.1"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.1">2.2.1.</a> <strong>Upload an allowed format if it doesn't already exist on the site.</strong> If there is no existing torrent of the album in the format you've chosen, you can upload it in any bitrate that averages at least 192 kbps.</li>
				<li id="r2.2.2"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.2">2.2.2.</a> <strong>Torrents that have the same bitrates, formats, and comparable or identical sampling rates for the same music release are duplicates.</strong> If a torrent is already present on the site in the format and bitrate you wanted to upload, you are not allowed to upload it - it's a duplicate (dupe). So if there's a 192 kbps CBR MP3 torrent on the site, you are not allowed to upload another 192 kbps CBR MP3 torrent for the same release. Similarly, if a torrent is already present on the site in the format and at the sampling rate you wanted to upload, you are not allowed to upload it - it's a duplicate (dupe). So if there's a 48 kHz WEB FLAC torrent on the site, you are not allowed to upload a 44.1 kHz WEB FLAC torrent for the same release. You cannot trump an existing torrent with another version solely because the new version includes album art. Exceptions: Different editions and source media do not count as dupes. See <a href="#r2.2.11">2.2.11</a> for more information.</li>
				<li id="r2.2.3"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.3">2.2.3.</a> <strong>Report all trumped and duplicated torrents.</strong> If you trump a torrent or notice a duplicate torrent, please use the report link (RP) to notify staff for removal of the old or duplicate torrent. This process is particularly vital for lossless rips. If you are uploading a superior rip to the current one in the same format on the site, report the older torrent and include a link to your new torrent in the report. Your torrent will be deleted as a dupe if the older torrent is not reported. Note: Trump - This occurs when a new torrent is uploaded in a preferred bitrate or quality (as specified by the lossy-, lossless-, and edition-specific rules below) and replaces the older version that exists on the site. Dupe - This occurs when a new torrent is uploaded in a bitrate or quality that is equal to the existing older version on the site. Because the two torrents cannot coexist, the most recent upload is considered a duplicate.</li>
				<li id="r2.2.4"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.4">2.2.4.</a> <strong>Dupe rules also apply to previous uploads.</strong> All of the dupe rules below concerning music formats may apply to torrents uploaded at an earlier time. For example, if you upload an album in 192 kbps MP3, someone can upload the same album in 320 kbps at a later date and trump your 192 kbps MP3.</li>
				<li id="r2.2.5"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.5">2.2.5.</a> <strong>Scene and non-scene torrents for the same release, in the same bitrate and format, are dupes.</strong> The Scene label does not make the torrents unique from one another. If a scene V2 (VBR) of an album from CD is already uploaded, you may not upload another V2 (VBR) of the same album from CD.</li>
				<li id="r2.2.6"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.6">2.2.6.</a> <strong>All vinyl torrents must be ripped at the correct speed.</strong> You must rip all vinyl albums at the speed with which they were intended to be played (see <a href="#r2.5.7">2.5.7</a>).</li>
				<li id="r2.2.7"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.7">2.2.7.</a> <strong>Complete or untouched releases replace incomplete or watermarked versions.</strong> Watermarked promos containing voice-overs and similar imperfections can be trumped by a non-watermarked release. Releases missing hidden or pre-gap tracks can be replaced by proper rips that include the entire range of tracks. These hidden or pre-gap tracks should be in their own file, not appended to the beginning of track one. Releases where the hidden or pre-gap track is appended to the first track can be trumped by one where the track is in a separate file.</li>
				<li id="r2.2.8"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.8">2.2.8.</a> <strong>Torrents that have been inactive (e.g., not seeded) for two weeks may be trumped by the identical torrent (e.g., reseeded) or by a brand new rip or encode (see <a href="wiki.php?action=article&amp;id=663">this wiki</a> for the torrent inactivity rules) of the album.</strong> If you have the original torrent files for the inactive torrent, it is preferable to reseed those original files instead of uploading a new torrent. Uploading a replacement torrent should be done only when the files from the original torrent cannot be recovered or are unavailable.</li>
				<li id="r2.2.9"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.9">2.2.9.</a> <strong>Lossy rules</strong>
					<ul>
						<li id="r2.2.9.1"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.1">2.2.9.1.</a> <strong>Higher bitrate CBR (constant bitrate) and ABR (average bitrate) torrents replace lower ones.</strong> Once a CBR (constant bitrate) rip has been uploaded, no CBR rips of that bitrate or lower can be uploaded. In the same manner, once an ABR (average bitrate) rip has been uploaded, no ABR rips of that bitrate or lower can be uploaded. For example, if a 320 kbps CBR rip is already on the site, you are not allowed to upload a 256 kbps CBR. ABR and CBR may be interchangeably trumped. A CBR can trump a lower bitrate ABR and an ABR may trump a lower bitrate CBR. You may not upload a 192 kbps CBR if a 256 kbps ABR of the same release is already up. For more information, see the Wikipedia articles on <a href="https://en.wikipedia.org/wiki/Average_bitrate" target="_blank">average bitrate</a>, <a href="https://en.wikipedia.org/wiki/Constant_bitrate" target="_blank">constant bitrate</a>, and <a href="https://en.wikipedia.org/wiki/Variable_bitrate" target="_blank">variable bitrate</a>.</li>
						<li id="r2.2.9.2"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.2">2.2.9.2.</a> <strong>Lossy format torrents with .log files do not replace equivalent existing torrents.</strong> If you want to upload a lossy format (e.g., MP3) torrent that contains a log, when that format already exists in the same medium and album edition (but without the log), your new torrent will be considered a dupe. For example, a V2 (VBR) MP3 torrent with a log cannot replace a V2 (VBR) MP3 without a log. The same standard applies for lossy audio torrents with .m3u, .cue, and other additions such as artwork. Exceptions: If an existing torrent contains encode/rip errors, you may upload another copy that does not have errors. The bad torrent needs to be reported (with clear information about which tracks and what time points are affected) or your torrent will be deleted as a dupe. Also, see <a href="#r2.3.8">2.3.8</a> through <a href="#r2.3.16">2.3.16</a> for replacing poorly named and tagged torrents.</li>
						<li id="r2.2.9.3"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.3">2.2.9.3.</a> <strong>V0 (VBR), V2 (VBR), and 320 CBR MP3 are allowed at any time.</strong> You may upload a V0 (VBR), V2 (VBR) or 320 CBR MP3 as long as another rip with the same bitrate and format doesn't already exist. So if a V0 (VBR) is on the site, you may still upload a V2 (VBR) or 320 CBR MP3 of the same release.</li>
						<li id="r2.2.9.4"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.4">2.2.9.4.</a> <strong>V2 (VBR) replaces APS (VBR), and both replace CBR rips under 256 kbps, 192 (ABR), and rips averaging 192 (VBR) to 210 (VBR).</strong> Once a rip with either the V2 (VBR) or APS (VBR) LAME encoding preset has been uploaded, you are not allowed to upload any CBR torrents under 256 kbps bitrate. Furthermore, a V2 (VBR) or APS (VBR) rip will trump all indiscriminate VBR rips of similar bitrate. A V2 (VBR) rip will replace a 192 (VBR) rip or 210 (VBR) rip, for example. Also, a V2 (VBR) will replace a 192 (ABR) torrent.</li>
						<li id="r2.2.9.5"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.5">2.2.9.5.</a> <strong>V0 (VBR) replaces APX (VBR), and both replace CBR rips under 320 kbps, V1 (VBR), all (ABR) rips, and all other non-LAME preset (VBR) rips.</strong> Once a rip with either the V0 (VBR) or APX (VBR) LAME encoding preset has been uploaded, you are not allowed to upload any CBR torrents under 320 kbps bitrate. Furthermore, a V0 (VBR) or APX (VBR) rip will trump all indiscriminate VBR rips (of 192 kbps average bitrate or higher). A V0 (VBR) rip will replace a 256 (VBR) rip, for example. You may not upload a V1 (VBR) LAME encoding preset if either V0 (VBR) or APX (VBR) are already present.</li>
						<li id="r2.2.9.6"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.6">2.2.9.6.</a> <strong>No constant bitrate encodes higher than 320 CBR are allowed on the site.</strong> You may upload MP3 files from 192 kbps to 320 kbps if no torrent exists in that format for a release. Any CBR bitrates under 192 kbps and bitrates higher than 320 kbps will be deleted. See <a href="#r2.2.9.1">2.2.9.1</a> for more information.</li>
						<li id="r2.2.9.7"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.7">2.2.9.7.</a> <strong>Non-LAME preset VBR rips do not replace each other.</strong> Similar bitrate VBR encodes are considered dupes. Thus, a 192 (VBR) is allowed to coexist with a significantly higher VBR encode. You may not upload a 224 (VBR) if a 256 (VBR) is already present, nor vice versa.</li>
						<li id="r2.2.9.8"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.8">2.2.9.8.</a> <strong>V2 (VBR) and V0 (VBR) LAME encodes trump APS (VBR) and APX (VBR) respectively.</strong> V2 (VBR) trumps an APS (VBR) encode of the same release. Once a V2 (VBR) is uploaded, you may not upload an APS (VBR) encode. V0 (VBR) trumps an APX (VBR) encode of the same release. Once a V0 (VBR) is uploaded, you may not upload an APX (VBR) encode.</li>
						<li id="r2.2.9.9"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.9">2.2.9.9.</a> <strong>Encoding profiles/object types at the same bitrate are not unique uploads.</strong> A 256 (VBR) in LC profile is a dupe if a 256 (VBR) HE object type encode already exists on the site. Similarly, different extensions (.m4a and .mp4) count as dupes if available in the same bitrate.</li>
						<li id="r2.2.9.10"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.10">2.2.9.10.</a> <strong>VBR AAC encodes can be trumped by 256 CBR encodes.</strong> Any VBR AAC encode, regardless of encoder used, may be deleted in favor of 256 CBR encodes. This includes 320 (VBR) encodes or encodes made with Nero presets.</li>
						<li id="r2.2.9.11"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.11">2.2.9.11.</a> <strong>An AAC encode can be trumped by an allowed encode of the same medium and edition.</strong> Note: For WEB torrents, comparisons of audio quality and source reliability will determine whether or not an MP3 may trump an AAC (at the discretion of the moderator involved).</li>
						<li id="r2.2.9.12"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.12">2.2.9.12.</a> <strong>Only one lossy vinyl rip in a specific bitrate is allowed per edition.</strong> See <a href="#r2.5.2">2.5.2</a>.</li>
						<li id="r2.2.9.13"><a href="#r2.2.9"><strong>&uarr;_</strong></a> <a href="#r2.2.9.13">2.2.9.13.</a> <strong>Any lossy formats must be encoded at the same sampling rate as their lossless source.</strong> FLAC files from a CD rip (sampled at 44.1 kHz) can only be transcoded to 44.1 kHz lossy formats. Any 48 kHz lossy formats for the same release that are uploaded after the 44.1 kHz torrents are on the site are considered dupes. FLAC files from a WEB FLAC (sampled at 48 kHz) can only be transcoded to 48 kHz lossy formats. If the 48 kHz FLAC torrent is uploaded, and the lossy formats are populated for this album at 48 kHz, no 44.1 kHz torrents (lossless or lossy) may be uploaded because those later torrents will be considered dupes.</li>
					</ul>
				</li>
				<li id="r2.2.10"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.10">2.2.10.</a> <strong>Lossless rules</strong>
					<ul>
						<li id="r2.2.10.1"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.1">2.2.10.1.</a> <strong>All FLAC CD rips must come from official CD sources.</strong>
							<ul>
								<li id="r2.2.10.1.1"><a href="#r2.2.10.1"><strong>&uarr;_</strong></a> <a href="#r2.2.10.1.1">2.2.10.1.1.</a> <strong>Rips must be taken from commercially pressed or official (e.g., artist- or label-approved) CD sources.</strong> They may not come from CD-R copies of the same pressed CDs.</li>
								<li id="r2.2.10.1.2"><a href="#r2.2.10.1"><strong>&uarr;_</strong></a> <a href="#r2.2.10.1.2">2.2.10.1.2.</a> <strong>Exceptions: If the release is only distributed on CD-R by the label or artist, then that is acceptable.</strong> See <a href="wiki.php?action=article&amp;id=954">this wiki</a> for more information on CD-R releases.</li>
							</ul>
						</li>
						<li id="r2.2.10.2"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.2">2.2.10.2.</a> <strong>A FLAC torrent without a log (or with a log from a non-EAC or non-XLD ripping tool like dBpoweramp or Rubyripper) may be trumped by a FLAC torrent with a log from an approved ripping tool that scores either 100% or &lt;100% because of non-audio deductions.</strong> For example, an <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> log that scores 50% (because of CRC mismatches or other audio deductions) cannot trump a Rubyripper log. See <a href="wiki.php?action=article&amp;id=921">this wiki</a> for more information on approved ripping tools. Also, see <a href="wiki.php?action=article&amp;id=693">this wiki</a> for setting up <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> and <a href="wiki.php?action=article&amp;id=706">this wiki</a> for ripping with EAC. See <a href="wiki.php?action=article&amp;id=146">this wiki</a> for ripping with <a href="http://tmkk.undo.jp/xld/index_e.html" target="_blank">XLD</a>. Please make sure the log file has the ".log" extension so that it can display properly on the torrent page.</li>
						<li id="r2.2.10.3"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.3">2.2.10.3.</a> <strong>A FLAC upload with an <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> or <a href="http://tmkk.undo.jp/xld/index_e.html" target="_blank">XLD</a> rip log that scores 100% on the <a href="logchecker.php">log checker</a> replaces one with a lower score.</strong> No log scoring less than 100% can trump an already existing one that scores under 100%. For example, a FLAC+log rip that scores 50% in the log checker cannot be trumped by a FLAC+log rip that scores 80%. <?=SITE_NAME?> recommends <a href="wiki.php?action=article&amp;id=693">this guide for EAC</a>, and <a href="wiki.php?action=article&amp;id=146">this guide for XLD</a>. See <a href="wiki.php?action=article&amp;id=155">this wiki</a> for more information on the site log checker. Note: A FLAC upload with a log that scores 95% for not defeating the audio cache may be rescored to 100% following the procedure outlined in <a href="wiki.php?action=article&amp;id=219">this wiki</a>.</li>
						<li id="r2.2.10.4"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.4">2.2.10.4.</a> <strong>A FLAC upload with <span style="font-weight: bold;">only non-audio deductions</span> in the log (see <a href="wiki.php?action=article&amp;id=888">this wiki</a>) may replace a FLAC upload with a log that scores 0% or contains audio deductions.</strong> For example, a range rip that has AccurateRip scores of two or higher and assorted non-audio deductions (e.g., burst mode, audio cache, pre-gaps, C2 pointers, etc.) can trump a log that has audio deductions for mismatching CRCs.</li>
						<li id="r2.2.10.5"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.5">2.2.10.5.</a> <strong><a href="http://tmkk.undo.jp/xld/index_e.html" target="_blank">XLD</a> and <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> logs in languages other than English require a manual log checker score adjustment by staff.</strong> The current log checker cannot parse non-English logs made by EAC and XLD. However, a special exception is made for foreign-language logs since the rip quality is equivalent to English logs. Please report your torrent with the "RP" button and select "Log Rescore Request" for the reason of the report so staff can score your torrent manually. <span style="font-weight: bold;">Do not translate the log yourself</span> (see <a href="#r2.2.10.9">2.2.10.9</a>).</li>
						<li id="r2.2.10.6"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.6">2.2.10.6.</a> <strong>Range rips of hidden tracks or regular range rips (acceptable under strict conditions) require manual score adjustment.</strong>
							<ul>
								<li id="r2.2.10.6.1"><a href="#r2.2.10.6"><strong>&uarr;_</strong></a> <a href="#r2.2.10.6.1">2.2.10.6.1.</a> <strong>The new log checker cannot accurately score range-ripped hidden tracks appended to proper rip logs.</strong> If you have created a 100% rip with a hidden track, but the log checker has decreased your score for the hidden track, report the torrent and the log score will be corrected by staff.</li>
								<li id="r2.2.10.6.2"><a href="#r2.2.10.6"><strong>&uarr;_</strong></a> <a href="#r2.2.10.6.2">2.2.10.6.2.</a> <strong>If you created a CD range rip that has matching CRCs for test and copy, and where every track has an AccurateRip score of 2 or more, then you may submit your torrent for manual score adjustment.</strong> It will be rescored, assuming no other problems, to 99%.</li>
								<li id="r2.2.10.6.3"><a href="#r2.2.10.6"><strong>&uarr;_</strong></a> <a href="#r2.2.10.6.3">2.2.10.6.3.</a> <strong>The CD image rip must be split with <a href="http://www.cuetools.net/wiki/CUETools" target="_blank">CUETools</a>, <a href="http://tmkk.undo.jp/xld/index_e.html" target="_blank">XLD</a>, or <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a>.</strong> No other splitter is acceptable for a score adjustment. You will not receive a score adjustment for copy-only range rips approved with AccurateRip, nor for range rips done with test and copy without AccurateRip enabled. See <a href="wiki.php?action=article&amp;id=111">this wiki</a> for information on splitting image rips with EAC.</li>
							</ul>
						</li>
						<li id="r2.2.10.7"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.7">2.2.10.7.</a> <strong>A 100% log rip lacking a cue sheet can be replaced by another 100% log rip with a noncompliant cue sheet.</strong> See <a href="wiki.php?action=article&amp;id=168">this wiki</a> for more information on cue sheets.
							<ul>
								<li id="r2.2.10.7.1"><a href="#r2.2.10.7"><strong>&uarr;_</strong></a> <a href="#r2.2.10.7.1">2.2.10.7.1.</a> <strong>A 100% log rip without a cue sheet can be replaced by a 100% log rip with a noncompliant cue sheet ONLY when the included cue sheet is materially different from "a cue generated from the ripping log". Examples of a material difference include additional or correct indices, properly detected pre-gap lengths, and <a href="wiki.php?action=article&amp;id=386">pre-emphasis</a> flags.</strong> If you upload a torrent with a cue sheet that provides nothing additional beyond what is contained in the rip log of the preexisting torrent, it will be deleted as a dupe.</li>
								<li id="r2.2.10.7.2"><a href="#r2.2.10.7"><strong>&uarr;_</strong></a> <a href="#r2.2.10.7.2">2.2.10.7.2.</a> <strong>Exceptions: An <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> 0.95 rip with a 100% log and no cue file, uploaded before September 14, 2010, may be trumped by a torrent that scores 100% under the current log checker requirements.</strong> </li>
							</ul>
						</li>
						<li id="r2.2.10.8"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.8">2.2.10.8.</a> <strong>FLAC rips that contain ID3 tags or other non-compliant tags for FLAC may be trumped by rips with identical scores that have the faulty tags removed and replaced with the standard for each format.</strong> Enabling ID3 tags in <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a> when ripping to FLAC may prevent some players from playing the files because of the inclusion of ID3 headers. If you wish to trump a FLAC rip that was ripped with ID3 tags enabled, upload the corrected torrent with the proper Vorbis comments and report the old torrent. Add information about your tag clean-up in the "Release description", or your torrent may be deleted as a dupe. Do not edit the log and change the ID3 tag setting to "No". Note: A simple way of getting rid of the ID3 header is to decompress the files to WAV, then compressing the files to FLAC, and adding the proper Vorbis comments.</li>
						<li id="r2.2.10.9"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.9">2.2.10.9.</a> <strong>No log editing is permitted.</strong>
							<ul>
								<li id="r2.2.10.9.1"><a href="#r2.2.10.9"><strong>&uarr;_</strong></a> <a href="#r2.2.10.9.1">2.2.10.9.1.</a> <strong>Forging log data is a serious misrepresentation of quality, and will result in a warning and the loss of your uploading privileges when the edited log is found.</strong> We recommend that you do not open the rip log file for any reason. However, if you must open the rip log, do not edit anything in the file for any reason. If you discover that one of your software settings is incorrect in the ripping software preferences, you must rip the CD again with the proper settings. Do not consolidate logs under any circumstances. If you must re-rip specific tracks or an entire disc and the rip results happen to have the new log appended to the original, leave them as is. Do not remove any part of either log, and never copy/paste parts of a new log over an old log.</li>
								<li id="r2.2.10.9.2"><a href="#r2.2.10.9"><strong>&uarr;_</strong></a> <a href="#r2.2.10.9.2">2.2.10.9.2.</a> <strong>If you find that an appended log has not been scored properly, please report the torrent and use the log rescore option.</strong> </li>
							</ul>
						</li>
						<li id="r2.2.10.10"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.10">2.2.10.10.</a> <strong>FLAC files must be compressed.</strong> We strongly recommend that FLAC files be compressed to Level 8. Lack of compression can increase the torrent size by 5% or more. Any torrents that have uncompressed FLAC files may be reported and trumped.</li>
						<li id="r2.2.10.11"><a href="#r2.2.10"><strong>&uarr;_</strong></a> <a href="#r2.2.10.11">2.2.10.11.</a> <strong>Any lossless formats must be encoded at the same sampling rate as their lossless source material.</strong> Lossless files from a Red Book-compliant CD rip (sampled at 44.1 kHz) can only be encoded to 44.1 kHz FLAC files for uploading in lossless torrents. Any 48 kHz lossless torrents for the same release are considered dupes. FLAC files from a WEB FLAC (sampled at 48 kHz) can only be uploaded as 48 kHz FLAC torrents. Any 44.1 kHz torrents for the same release are considered dupes. When albums are available in a number of different lossless formats (44.1 kHz, 48 kHz, 96 kHz, etc.) the first lossless torrent that is uploaded to the site may remain while all subsequent versions are considered dupes. See <a href="#r2.2.2">2.2.2</a> and <a href="#r2.2.9.13">2.2.9.13</a> for more information.</li>
					</ul>
				</li>
				<li id="r2.2.11"><a href="#h2.2"><strong>&uarr;_</strong></a> <a href="#r2.2.11">2.2.11.</a> <strong>Editions and Releases rules</strong>
					<ul>
						<li id="r2.2.11.1"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.1">2.2.11.1.</a> <strong>Different editions and source media count as separate releases.</strong>
							<ul>
								<li id="r2.2.11.1.1"><a href="#r2.2.11.1"><strong>&uarr;_</strong></a> <a href="#r2.2.11.1.1">2.2.11.1.1.</a> <strong>A rip from a different medium (e.g., vinyl) or release (e.g., a remaster) of an already existing torrent counts as a different edition.</strong> The dupe rules do not apply to the two different album editions, nor do they apply to two differently sourced torrents. So if a FLAC ripped from a CD is already up, you are still allowed to upload a FLAC ripped from vinyl. And if a 320 kbps CBR MP3 release for an original mastering of an album was uploaded, you are still allowed to upload a 320 kbps CBR MP3 remaster. See <a href="wiki.php?action=article&amp;id=375">this wiki</a> for the procedure on how to enter album edition information for a torrent.</li>
								<li id="r2.2.11.1.2"><a href="#r2.2.11.1"><strong>&uarr;_</strong></a> <a href="#r2.2.11.1.2">2.2.11.1.2.</a> <strong>Only one edition of each unofficial live recording is allowed.</strong> See <a href="#r2.6.2">2.6.2</a>.</li>
							</ul>
						</li>
						<li id="r2.2.11.2"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.2">2.2.11.2.</a> <strong>Rip log information (ToC, peak levels, and pre-gaps), tracklist, and running order determine distinct editions, not catalog information.</strong> Merely having different catalog numbers or CD packaging is not enough to justify a new, distinct edition, though differences in year, label (imprint), or catalog number determine distinct releases. Though different editions may coexist, distinct releases that are not also distinct editions may not, and are considered dupes. See <a href="wiki.php?action=article&amp;id=367">this wiki</a> for more information.</li>
						<li id="r2.2.11.3"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.3">2.2.11.3.</a> <strong>Multiple releases may be grouped into one edition.</strong> In such a case, torrents belonging to any of the releases determined to be in the same edition are considered dupes. Conversely, release groups may be split into more than one edition when it is determined that there is a material difference in audio content (different editions that have the same catalog information are known as "silent remasters"), in which case other formats may be uploaded for both editions.</li>
						<li id="r2.2.11.4"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.4">2.2.11.4.</a> <strong>Lossless uploads with edition information trump lossless rips with nonexistent or insufficient logs and no release information.</strong> An insufficient log is a log that doesn't provide any information (e.g., ToC, peak levels, and pre-gaps) about the audio being ripped.</li>
						<li id="r2.2.11.5"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.5">2.2.11.5.</a> <strong>If a lossless torrent has no release information (an "unknown release") but does have a log containing ToC, peak level, and pre-gap information, it cannot be trumped by a lossless torrent with release information unless the "lossless unknown release torrent" can be determined to be the same edition as a lossless torrent for which the release information is known.</strong> If such an identification can be made, the "lossless unknown release torrent" (and all lossy torrents that can be identified as transcodes of it) is moved into the same edition as the lossless torrent with edition information, and the merged torrents are then subject to dupe and trump rules as per <a href="#r2.2.11.2">2.2.11.2</a>. If the rip log is incomplete (missing ToC, peak level, or pre-gap information) and the information available matches a torrent in an edition whose release information is known, the torrent whose release information is known trumps the torrent whose release information is unknown.</li>
						<li id="r2.2.11.6"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.6">2.2.11.6.</a> <strong>Lossy torrents with release information trump unknown release torrents if they share the same tracklist and running order, with one exception.</strong> If it can be established that a lossy Unknown Release torrent is a transcode of an Unknown Release FLAC, and the Unknown Release FLAC is moved into an edition whose release information is known as per <a href="#r2.2.11.5">2.2.11.5</a>, then all lossy transcodes of it are moved with it and are treated as any other lossy torrents already present in the edition as per <a href="#r2.2.11.2">2.2.11.2</a>.</li>
						<li id="r2.2.11.7"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.7">2.2.11.7.</a> <strong>Bonus disc-only uploads can coexist with the complete set in accordance with the trumping rules.</strong> A bonus disc-only release can be trumped by an upload containing the "full" original album + bonus discs, in the same format, in accordance with the usual trumping rules (see <a href="#h2.4">2.4</a> for the rules specific to bonus materials).</li>
						<li id="r2.2.11.8"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.8">2.2.11.8.</a> <strong>Unknown Release torrents may be trumped by seemingly identical torrents whose Edition Information can be verified.</strong> Torrents marked as "Unknown Release" are eligible to be trumped by rips sourced from the same medium, with the same track listing and running order, whose source Edition Information is provided and can be verified.</li>
						<li id="r2.2.11.9"><a href="#r2.2.11"><strong>&uarr;_</strong></a> <a href="#r2.2.11.9">2.2.11.9.</a> <strong>Only one lossless and two 24-bit lossless vinyl rips are allowed per edition.</strong> A poor sounding lossless rip may be trumped by a better sounding lossless rip, regardless of lineage information. The same quality trump can occur for 24-bit lossless rips. To trump an older torrent for a better sounding version, <span style="font-weight: bold;">you need to report it with clear information about how your rip sounds better than the other one</span> (e.g., specific tracks where the audio is appreciably improved, specific time points that demonstrate the improvement, etc.). Rips of extremely poor quality may be deleted outright if reported. All quality trumps/deletions of this nature are at the discretion of the moderator involved. See <a href="#h2.5">2.5</a>.</li>
					</ul>
				</li>
			</ul>
		</div>
		<h5 id="h2.3"><a href="#h2.3k"><strong>&uarr;</strong></a> <a href="#h2.3">2.3.</a> Formatting</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.3.1"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.1">2.3.1.</a> <strong>Music releases must be in a directory that contains the music.</strong> This includes single track releases, which must be enclosed in a torrent folder even if there is only one file in the torrent. No music may be compressed in an archive (e.g., .rar, .zip, .tar, .iso). Scene archives of music must be unpacked and not labeled as "scene".</li>
				<li id="r2.3.2"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.2">2.3.2.</a> <strong>Name your directories with meaningful titles, such as "Artist - Album (Year) - Format". The minimum acceptable is "Album" although it is preferable to include more information.</strong> If the directory name does not include this minimum then another user can rename the directory, re-upload, and report your torrent for deletion. In addition, torrent folders that are named using the scene convention will be trumpable if the Scene label is absent from the torrent.</li>
				<li id="r2.3.3"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.3">2.3.3.</a> <strong>Avoid creating unnecessary nested folders (such as an extra folder for the actual album) inside your properly named directory.</strong> A torrent with unnecessary nested folders is trumpable by a torrent with such folders removed. For single disc albums, all audio files must be included in the main torrent folder. For multi-disc albums, the main torrent folder may include one sub-folder that holds the audio file contents for each disc in the box set, e.g., the main torrent folder is &quot;<samp>Adele - 19 (2008) - FLAC</samp>&quot; while appropriate sub-folders may include &quot;<samp>19 (Disc 1of2)</samp>&quot; or &quot;<samp>19</samp>&quot; and &quot;<samp>Live From The Hotel Cafe (Disc 2of2)</samp>&quot; or &quot;<samp>Acoustic Set Live From The Hotel Cafe, Los Angeles</samp>&quot;. Additional folders are unnecessary because they do nothing to improve the organization of the torrent. If you are uncertain about what to do for other cases, PM a staff member for guidance.</li>
				<li id="r2.3.4"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.4">2.3.4.</a> <strong>Label your torrents according to site standards.</strong> Follow the <a href="wiki.php?action=article&amp;id=159">torrent naming guide</a> for help on how to name your uploaded torrents properly. Use the Edition Information box on the <a href="upload.php">upload page</a> to denote different editions or versions of an album (e.g., censored version versus an uncensored version). If you need help merging or editing your upload, please request help in <a href="forums.php?action=viewforum&amp;forumid=61">this forum</a>. For the album category/release type, follow the <a href="wiki.php?action=article&amp;id=202">guidelines here</a>.</li>
				<li id="r2.3.5"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.5">2.3.5.</a> <strong>Torrents should never have [REQ] or [REQUEST] in the title or artist name.</strong> If you fill a request using the <a href="requests.php">Requests system</a>, everyone who voted for it will be automatically notified.</li>
				<li id="r2.3.6"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.6">2.3.6.</a> <strong>Torrent album titles must accurately reflect the actual album titles.</strong> Use proper capitalization when naming your albums. Typing the album titles in all lowercase letters or all capital letters is unacceptable and makes the torrent trumpable. For detailed information on naming practices see <a href="wiki.php?action=article&amp;id=369">this wiki</a> and <a href="wiki.php?action=article&amp;id=317">this wiki</a>. Any descriptions like [Advance] or [CDM] (if you must use them) should be entered in the Edition Information box on the <a href="upload.php">upload page</a>, not in the title. Exceptions: If the album uses special capitalization, then you may follow that convention.</li>
				<li id="r2.3.7"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.7">2.3.7.</a> <strong>The Artist field in the torrent name should contain only the artist name.</strong> Do not add additional information about the artist in the artist field unless the album credits the artist in that manner. For example, "Artist X (of Band Y)" or "Band X (feat. Artist Y)". It is recommended that you search existing torrents for the artist name so that you can be sure that you name the artist the exact same way. A torrent with a proper artist name will be grouped with the existing torrents for that artist on a common artist page, and thus will be easy to find. Capitalization problems will also make a torrent trumpable. Labeling the artist incorrectly prevents your torrent from being grouped with the other torrents for the same artist. See <a href="wiki.php?action=article&amp;id=369">this wiki</a> for more information.</li>
				<li id="r2.3.8"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.8">2.3.8.</a> <strong>The year of the original recording should be used for the "Year" field on the <a href="upload.php">upload page</a>.</strong> Use the recording year for "Year of the original release" (if you can establish it), and use the option to add the release year for the album or edition you are uploading in the Edition Information on the <a href="upload.php">upload page</a>. For example, all editions of The Beatles (White Album) would have 1968 in the main Year box. However, each of the various mono pressings, remasters, re-releases, expanded editions, reconstructions, etc. would have its respective release year in the Edition Information box.</li>
				<li id="r2.3.9"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.9">2.3.9.</a> <strong>All lossless analog rips should include clear information about source lineage.</strong> All lossless SACD digital layer analog rips and vinyl rips must include clear information about recording equipment used (see <a href="#h2.8">2.8</a>). If you used a USB turntable for a vinyl rip, clearly indicate this in your lineage information. Also include all intermediate steps up to lossless encoding, such as the program used for mastering, sound card used, etc. Lossless analog rips missing rip information can be trumped by better documented lossless analog rips of equal or better quality. In order to trump a lossless analog rip without a lineage, this lineage must be included as a .txt or .log file within the new torrent.</li>
				<li id="r2.3.10"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.10">2.3.10.</a> <strong>All lossless soundboard recordings must include clear information about source lineage.</strong> This information should be displayed in the torrent description. Optionally, the uploader may include the information in a .txt or .log file within the torrent. Lossless soundboard recordings missing lineage information will be deleted if reported (see <a href="#r2.6.7">2.6.7</a>).</li>
				<li id="r2.3.11"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.11">2.3.11.</a> <strong>File names must accurately reflect the song titles.</strong> You may not have file names like <samp>01track.mp3</samp>, <samp>02track.mp3</samp>, etc. Torrents containing files that are named with incorrect song titles can be trumped by properly labeled torrents. Also, torrents that are sourced from the scene but do not have the Scene label must comply with site naming rules (no release group names in the file names, no advertisements in the file names, etc.). Note that these must be substantial improvements such as the removal of garbage characters. Small changes such as diacritical marks are insufficient grounds for trumping. English translations of song titles in file names are encouraged but not necessary for foreign language song titles. If all the letters in the track titles are capitalized, the torrent is trumpable. Exceptions: Rare albums featuring no track listing or untitled tracks may have file names like <samp>01track.mp3</samp>, <samp>02track.mp3</samp>, and so forth. Please note this track list in the "Album description". If foreign language characters create playback problems for some systems and cannot be coherently translated, file names such as "<samp>01track</samp>" are acceptable for those few cases.</li>
				<li id="r2.3.12"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.12">2.3.12.</a> <strong>The maximum character length for files is 180 characters.</strong> Path length values must not be so long that they cause incompatibility problems with operating systems and media players. For example, &quot;<samp>My Artist Name - My Album Name (2012) - FLAC/01 - Long Track Name for the First Track.flac</samp>&quot; is a typical torrent folder that contains the audio files. This path name consists of 90 characters. As of September 01, 2012, new torrents will be trumpable if their path lengths exceed 180 characters. This limit includes the number of characters in the main torrent folder (in this case, 46 characters), any sub-folders, and files within that torrent folder. For example, unnecessarily nested folders will count towards this limit; lengthy classical music file names will count towards this limit. Torrents that were uploaded prior to September 01, 2012 with character lengths that are longer than 180 characters may remain on the site. However, torrents with exceedingly long path lengths will only remain on the site at the discretion of staff.</li>
				<li id="r2.3.13"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.13">2.3.13.</a> <strong>Track numbers are required in file names (e.g., "<samp>01 - TrackName.mp3</samp>").</strong> If a torrent without track numbers in the file names is uploaded, then a torrent with the track numbers in the file names can take its place. When formatted properly, file names will sort in order by track number or playing order. Also see <a href="#r2.3.14">2.3.14</a>. Exception: Track numbers are not required for single-track torrents.</li>
				<li id="r2.3.14"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.14">2.3.14.</a> <strong>When formatted properly, file names will alphabetically sort into the original playing order of the release.</strong>
					<ul>
						<li id="r2.3.14.1"><a href="#r2.3.14"><strong>&uarr;_</strong></a> <a href="#r2.3.14.1">2.3.14.1.</a><strong>For albums with more than one artist, if the name of the artist is in the file name, it must come after the track number in order for the tracks to sort into the correct order.</strong> For example, &quot;<samp>01 - U2 - Where the Streets Have No Name.flac</samp>&quot; is a properly formatted file name for a multiple-artist album. &quot;<samp>U2 - 01 - Where the Streets Have No Name.mp3</samp>&quot; is not correct in the context of a compilation album because the resultant file list will sort in alphabetical order by artist rather than by numerical track number. <strong>Note:</strong> there is no requirement for artist names to be in the track file names, other than <a href="#r2.3.16.2">2.3.16.2.</a> Torrents that have improperly-formatted or incomplete file names will be trumpable.</li>
						<li id="r2.3.14.2"><a href="#r2.3.14"><strong>&uarr;_</strong></a> <a href="#r2.3.14.2">2.3.14.2.</a><strong>If a torrent has subfolders for multiple discs of a release, these subfolders must sort by disc order.</strong> If each disc has a title (<a href="torrents.php?id=62329">torrents.php?id=62329</a>, for example) and the discs are not numbered, this rule does not apply, and each subdirectory should have the disc name included.</li>
					</ul>
				</li>
				<li id="r2.3.15"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.15">2.3.15.</a> <strong>Multiple-disc torrents cannot have tracks with the same numbers in one directory.</strong> You may place all the tracks for disc one in one directory and all the tracks for disc two in another directory. If you prefer to use one directory for all the audio files, you must use successive numbering. For example, disc one has 15 tracks and disc two has 20 tracks. You may either number tracks in disc one as #01-#15 and those of disc two as #16-#35 in the same directory, or you may add a disc number before the track numbers such that the numbers are #1 06 for Disc One Track 06, and #2 03 for Disc 2 Track 03, and so forth.</li>
				<li id="r2.3.16"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.16">2.3.16.</a> <strong>Properly tag your music files.</strong>
				<ul>
					<li id="r2.3.16.1"><a href="#r2.3.16"><strong>&uarr;_</strong></a> <a href="#r2.3.16.1">2.3.16.1.</a>Certain meta tags (e.g., ID3, Vorbis) are required on all music uploads. Make sure to use the proper format tags for your files (e.g., no ID3 tags for FLAC&#8202;&mdash;&#8202;see <a href="#r2.2.10.8">2.2.10.8</a>). ID3v2 tags for files are highly recommended over ID3v1.</li>
					<li id="r2.3.16.2"><a href="#r2.3.16"><strong>&uarr;_</strong></a> <a href="#r2.3.16.2">2.3.16.2.</a>ID3 tags are recommended for AC3 torrents, but are not mandatory because the format does not natively support file metadata tagging (for AC3, the file names become the vehicle for correctly labeling media files). Because of this lack of support, the Album and Artist information must be included in the torrent folder for AC3 and DTS files. In addition, the Track Number and Track Title information must be included in the file names for AC3 and DTS files; for various artists compilations, the Track Artist must be included in the file names as well, ensuring that they also satisfy <a href="#r2.3.14">2.3.14.</a></li>
					<li id="r2.3.16.3"><a href="#r2.3.16"><strong>&uarr;_</strong></a> <a href="#r2.3.16.3">2.3.16.3.</a>Torrents uploaded with both good ID3v1 tags and blank ID3v2 tags (a dual set of tags) are trumpable by torrents with either just good ID3v1 tags or good ID3v2 tags (a single set of tags). See <a href="wiki.php?action=article&amp;id=170">this wiki</a> for more information on ID3 tags.</li>
					<li id="r2.3.16.4"><a href="#r2.3.16"><strong>&uarr;_</strong></a> <a href="#r2.3.16.4">2.3.16.4.</a>If you upload an album missing one or more of the required tags, then another user may add the tags, re-upload, and report your torrent for deletion. The required tags are:
						<ul>
							<li>Artist</li>
							<li>Album</li>
							<li>Title</li>
							<li>Track Number</li>
						</ul>
					</li>
				</ul>
				<span style="font-style: italic;">Note: The "Year" tag is optional but strongly encouraged. However, if missing or incorrect, this is not grounds for trumping a torrent.</span>
				</li>
				<li id="r2.3.17"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.17">2.3.17.</a> <strong>The torrent artist for classical works should use the full composer name.</strong> Before uploading see <a href="wiki.php?action=article&amp;id=700">this wiki</a> for guidelines on uploading classical music torrents. Also, consult <a href="wiki.php?action=article&amp;id=691">this wiki</a> for a full explanation of the classical music tagging system.</li>
				<li id="r2.3.18"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.18">2.3.18.</a> <strong>Newly re-tagged torrents trumping badly tagged torrents must reflect a substantial improvement over the previous tags.</strong> Small changes that include replacing ASCII characters with proper foreign language characters with diacritical marks, fixing slight misspellings, or missing an alternate spelling of an artist (e.g., excluding "The" before a band name) are insufficient grounds for replacing other torrents. Artist names that are misspelled in the tags are grounds for trumping; this includes character accents and characters that mean one letter in one language and a different letter in another language. Improper capitalization in the tags is grounds for trumping; this includes artist tags (or composer tags) that contain names that are all capitalized or track titles that are all capitalized. Tags with multiple entries in the same tag (e.g., track number and track title in the track title tags; or track number, artist, and track title in the artist tags) are subject to trumping. You may trump a release if the tags do not follow the data from a reputable music cataloguing service such as <a href="https://musicbrainz.org/" target="_blank">MusicBrainz</a> or <a href="http://www.discogs.com/" target="_blank">Discogs</a>. In the case of a conflict between reputable listings, either tagged version is equally preferred on the site and cannot trump the other. For example, an album is tagged differently in <a href="https://musicbrainz.org/" target="_blank">MusicBrainz</a> and in <a href="http://www.discogs.com/" target="_blank">Discogs</a>. Either style of tagging is permitted; neither is "better" than the other. In that case, any newly tagged torrents replacing an already properly tagged torrent, which follows good tagging convention, will result in a dupe. Note: For classical music, please follow these <a href="wiki.php?action=article&amp;id=691">tagging guidelines</a>.</li>
				<li id="r2.3.19"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.19">2.3.19.</a> <strong>Avoid embedding large images in file metadata.</strong> The combined size of embedded images and padding may not exceed 512 KiB per file. You may include the artwork separately if it is too big. When removing embedded images, make sure that the padding is removed or reduced to a few kilobytes. Refer to <a href="wiki.php?action=article&amp;id=1206">this wiki article</a> for more information.</li>
				<li id="r2.3.20"><a href="#h2.3"><strong>&uarr;_</strong></a> <a href="#r2.3.20">2.3.20.</a> <strong>Leading spaces are not allowed in any file or folder names.</strong> Leading spaces cause usability and interoperability problems among various operating systems and programs. Torrents with file or folder names that contain leading space characters are trumpable.</li>
			</ul>
		</div>
		<h5 id="h2.4"><a href="#h2.4k"><strong>&uarr;</strong></a> <a href="#h2.4">2.4.</a> Bonus Content</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.4.1"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.1">2.4.1.</a> <strong>All music torrents must represent a complete release, and may not be missing tracks or discs (see <a href="#r2.1.19">2.1.19</a>).</strong> Bonus tracks or bonus discs should be uploaded as a complete release with the main album. Do not cobble together main album and bonus content from different sources if you do not have the complete release. Such torrents will be regarded as mutt rips or user compilations, and a staff member may ask for proof of the torrent's authenticity.</li>
				<li id="r2.4.2"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.2">2.4.2.</a> <strong>A FLAC bonus disc-only release is not automatically deleted due to the presence of the complete set (Album + Bonus disc).</strong> An upload consisting solely of a bonus disc can only be trumped by the complete set when the trumping torrent's log score qualifies based on the usual lossless rules (see <a href="#r2.2.10">2.2.10</a>). No bonus disc-only upload can trump a complete set that has a total score of 100%.</li>
				<li id="r2.4.3"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.3">2.4.3.</a> <strong>When a "perfect" FLAC rip (with a log scoring 100%) of the complete release (including the bonus disc) is uploaded, all bonus disc-only torrents are considered dupes of the complete set.</strong> </li>
				<li id="r2.4.4"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.4">2.4.4.</a> <strong>A lossy bonus disc-only torrent can be trumped by the complete set in the same format and bitrate.</strong> </li>
				<li id="r2.4.5"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.5">2.4.5.</a> <strong>Exclusive bonus content from services such as iTunes or Amazon may be uploaded in a separate torrent but may be trumped by a complete torrent containing the full digital release and bonus material.</strong> For instance, an iTunes release that contains two iTunes bonus tracks may have a torrent uploaded of solely the two bonus tracks, though it remains trumpable by the complete iTunes release that includes the bonus material.</li>
				<li id="r2.4.6"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.6">2.4.6.</a> <strong>Lossy bonus content which is otherwise unavailable may be uploaded in a separate torrent and must not be included in the same torrent as the original album, as to avoid creating mutt rips in accordance with <a href="#r2.1.6.3">2.1.6.3</a>.</strong> This includes, but is not limited to: Bonus MP3 content provided in the data portion of a CD, "subscription" bonus material where content is released (gradually or wholly) to subscribers or fan club members, or downloadable exclusives for purchasers of a release. All lossy bonus content must meet the minimum bitrate requirements of <a href="#r2.1.3">2.1.3</a>.</li>
				<li id="r2.4.7"><a href="#h2.4"><strong>&uarr;_</strong></a> <a href="#r2.4.7">2.4.7.</a> <strong>Mixed media sets are to be uploaded as one torrent per medium.</strong> For example, a release which contains a CD, a vinyl, and a cassette in one package must be uploaded as three separate torrents, with one torrent containing the CD content, another torrent containing the vinyl content, and another torrent containing the cassette content (in compliance with the tape rip requirements in <a href="#h2.10">2.10</a>).</li>
			</ul>
		</div>
		<h5 id="h2.5"><a href="#h2.5k"><strong>&uarr;</strong></a> <a href="#h2.5">2.5.</a> Vinyl</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.5.1"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.1">2.5.1.</a> <strong>Downsampling of analog rips is allowed.</strong> Analog rips that have been downsampled may be uploaded (e.g., a 24/96 vinyl rip downsampled to 16/44.1). Any downsampled torrents must include the specific programs and methods used to downsample in addition to the lineage for the original rip or it will be deleted.</li>
				<li id="r2.5.2"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.2">2.5.2.</a> <strong>Only one lossy vinyl rip in a specific bitrate is allowed per edition.</strong> Once someone has uploaded a lossy format vinyl rip (in MP3), you may not upload another copy in the same bitrate. It does not matter whether or not the lossy files are of differing sampling rates. For example, if a 44.1 kHz V2 (VBR) copy is already up, you may not upload the same album in V2 (VBR) at 48 kHz.</li>
				<li id="r2.5.3"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.3">2.5.3.</a> <strong>Only one 16-bit lossless vinyl rip is allowed per edition.</strong> Lossless 16-bit vinyl rips must have a sampling rate of either 44.1 kHz or 48 kHz. Upsampling of rips is strictly forbidden. See <a href="wiki.php?action=article&amp;id=78">this wiki</a> for vinyl ripping information and <a href="wiki.php?action=article&amp;id=117">this wiki</a> for general information on the vinyl medium.</li>
				<li id="r2.5.4"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.4">2.5.4.</a> <strong>A maximum of two 24-bit lossless vinyl rips are allowed per edition: A lossless 24-bit rip with sampling rate equal to 192 kHz and a lossless 24-bit rip with sampling rate equal to 44.1, 48, 88.2, or 96 kHz.</strong> Lossless 24/96 vinyl rips trump 24/44.1, 24/48, and 24/88.2 rips. Two or more lossless 24-bit vinyl rips with sampling rates equal to 44.1, 48, or 88.2 kHz are considered dupes. So a 24/88.2 rip and a 24/48 rip of the same material are considered dupes. Rips must sound as good as or better than the rips they are attempting to trump (see <a href="#r2.2.11.9">2.2.11.9</a> for examples of trumping proofs). Upsampling of rips is strictly forbidden. See <a href="wiki.php?action=article&amp;id=118">this wiki</a> for more information on 24-bit vinyl ripping.</li>
				<li id="r2.5.5"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5">2.5.5.</a> <strong>Vinyl rips may be trumped by better-sounding rips of the same bit depth, regardless of lineage information (see <a href="#r2.3.9">2.3.9</a>).</strong>
					<ul>
						<li id="r2.5.5.1"><a href="#r2.5.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5.1">2.5.5.1.</a> <strong>Lossless 16-bit rips may be trumped by better-sounding lossless 16/44.1 or 16/48 rips.</strong> </li>
						<li id="r2.5.5.2"><a href="#r2.5.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5.2">2.5.5.2.</a> <strong>Lossless 24-bit rips with sampling rate equal to 44.1, 48, 88.2, or 96 kHz may be trumped by better-sounding lossless 24/96 rips.</strong> </li>
						<li id="r2.5.5.3"><a href="#r2.5.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5.3">2.5.5.3.</a> <strong>Lossless 24-bit rips with sampling rate equal to 192 kHz may be trumped by better-sounding lossless 24/192 rips.</strong> </li>
						<li id="r2.5.5.4"><a href="#r2.5.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4">2.5.5.4.</a> <strong>Lossy vinyl rips may be trumped by substantially better-sounding lossy vinyl rips when the difference in quality is obvious.</strong> To trump an old rip with a new torrent that may be a better sounding version, you need to report it with clear information about how your rip sounds better than the other one, with references to specific tracks and time positions to justify your report (see <a href="#r2.2.11.9">2.2.11.9</a>). The following are acceptable reasons to both report and/or remove a torrent.
							<ul>
								<li id="r2.5.5.4.1"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.1">2.5.5.4.1.</a> <strong>The vinyl audio was captured at the wrong playback speed.</strong> </li>
								<li id="r2.5.5.4.2"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.2">2.5.5.4.2.</a> <strong>At least one track has a constant level of static.</strong> </li>
								<li id="r2.5.5.4.3"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.3">2.5.5.4.3.</a> <strong>At least one track has a noticeable pop or click.</strong> This pop must be visible in the frequency spectrals for the track and should last 1/20th of a second.</li>
								<li id="r2.5.5.4.4"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.4">2.5.5.4.4.</a> <strong>There is noticeable wobbling during playback.</strong> </li>
								<li id="r2.5.5.4.5"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.5">2.5.5.4.5.</a> <strong>The needle drop is audible.</strong> </li>
								<li id="r2.5.5.4.6"><a href="#r2.5.5.4"><strong>&uarr;_</strong></a> <a href="#r2.5.5.4.6">2.5.5.4.6.</a> <strong>At least one track is truncated or improperly split.</strong> </li>
							</ul>
						</li>
						<li id="r2.5.5.5"><a href="#r2.5.5"><strong>&uarr;_</strong></a> <a href="#r2.5.5.5">2.5.5.5.</a> <strong>Rips of extremely poor quality (lossy or lossless) may be deleted outright if reported.</strong> All quality trumps/deletions of this nature are at the discretion of the moderator involved.</li>
					</ul>
				</li>
				<li id="r2.5.6"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.6">2.5.6.</a> <strong>Lossy transcodes of lossless vinyl rips trumped under rule <a href="#r2.2.11.9">2.2.11.9</a> and the rules in this section are trumpable by lossy transcodes of the trumping vinyl rips.</strong> For example, lossy torrent A and lossless torrent A exist on the site. A new vinyl rip (lossless torrent B) is uploaded and trumps lossless torrent A (the old vinyl rip). All lossy transcodes from lossless torrent B will automatically trump the corresponding lossy torrents transcoded from lossless torrent A; only the torrent B formats will remain on the site. So that the correct source for the lossless rip can be easily identified, you are strongly encouraged to mention or link to the vinyl rip that you are using for the lossless-to-lossy transcode and to reproduce its lineage in the release description of transcodes that you upload.</li>
				<li id="r2.5.7"><a href="#h2.5"><strong>&uarr;_</strong></a> <a href="#r2.5.7">2.5.7.</a> <strong>All vinyl torrents must be ripped at the correct speed.</strong> You must rip all vinyl albums using the speed at which they were intended to be played. For example, you may not rip a 45 rpm vinyl at 33 rpm and upload it to the site. In addition, turntables that have been improperly calibrated, and therefore play back LPs at an incorrect speed, will cause pitch changes that are noticeable. Any such vinyl albums that were captured at the wrong playback speed will be deleted once reported.</li>
			</ul>
		</div>
		<h5 id="h2.6"><a href="#h2.6k"><strong>&uarr;</strong></a> <a href="#h2.6">2.6.</a> Live Music and Soundboards</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.6.1"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.1">2.6.1.</a> <strong>Live soundboard material should be uploaded as one torrent per show.</strong> </li>
				<li id="r2.6.2"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.2">2.6.2.</a> <strong>Only one edition of each unofficial live recording is allowed.</strong> Such bootlegs and mixtapes can be unofficially remastered several times, and such constant remastering is of little consequence on a site where bootlegs are not the primary focus. Only one unofficial soundboard recording of each show is allowed, and it should be uploaded on the torrent page in the absence of any edition information. See <a href="wiki.php?action=article&amp;id=750">this wiki</a> for more information on how live music is organized on the site.</li>
				<li id="r2.6.3"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.3">2.6.3.</a> <strong>No unofficial audience recordings.</strong>
					<ul>
						<li id="r2.6.3.1"><a href="#r2.6.3"><strong>&uarr;_</strong></a> <a href="#r2.6.3.1">2.6.3.1.</a> <strong>AUD (Audience), IEM (In Ear Monitor), ALD (Assistive Listening Device), Mini-Disc, and Matrix-sourced recordings cannot be uploaded.</strong> </li>
						<li id="r2.6.3.2"><a href="#r2.6.3"><strong>&uarr;_</strong></a> <a href="#r2.6.3.2">2.6.3.2.</a> <strong>Officially-remastered AUD/IEM/ALD/Mini-Disc/Matrix recordings are allowed.</strong> These may be re-appropriated recordings released with the artist's or their label's consent. Bonus tracks from such recording sources are also exempt. Be prepared to provide clear proofs of such re-releases to the staff when asked.</li>
					</ul>
				</li>
				<li id="r2.6.4"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.4">2.6.4.</a> <strong>Soundboards must comprise complete shows.</strong> Incomplete shows will be deleted.</li>
				<li id="r2.6.5"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.5">2.6.5.</a> <strong>Soundboards may not include soundchecks.</strong> Those uploaded with a soundcheck will be deleted.</li>
				<li id="r2.6.6"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.6">2.6.6.</a> <strong>One tape generation and one CD-R generation are allowed for each soundboard upload.</strong>
					<ul>
						<li id="r2.6.6.1"><a href="#r2.6.6"><strong>&uarr;_</strong></a> <a href="#r2.6.6.1">2.6.6.1.</a> <strong>The tape generation must be the first generation.</strong> For example, there can be a master tape and then a subsequent tape (with no other transfer in between). Any additional tape generations beyond the secondary tape will require staff approval.</li>
						<li id="r2.6.6.2"><a href="#r2.6.6"><strong>&uarr;_</strong></a> <a href="#r2.6.6.2">2.6.6.2.</a> <strong>If a limited number of tracks (at the discretion of the staff member involved) have been patched with a short amount of tape-sourced data you may still upload the recording but this information must be clearly stated in the lineage and the album description.</strong> </li>
					</ul>
				</li>
				<li id="r2.6.7"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.7">2.6.7.</a> <strong>Include lineage information for each soundboard recording (see <a href="#r2.3.10">2.3.10</a>).</strong>
					<ul>
						<li id="r2.6.7.1"><a href="#r2.6.7"><strong>&uarr;_</strong></a> <a href="#r2.6.7.1">2.6.7.1.</a> <strong>Lineage information for a soundboard recording is highly recommended.</strong> </li>
						<li id="r2.6.7.2"><a href="#r2.6.7"><strong>&uarr;_</strong></a> <a href="#r2.6.7.2">2.6.7.2.</a> <strong>If a soundboard is uploaded without a lineage, and a lineage is later found that contains more than one tape or CD-R generation, then the uploader will be warned and the torrent deleted.</strong></li>
						<li id="r2.6.7.3"><a href="#r2.6.7"><strong>&uarr;_</strong></a> <a href="#r2.6.7.3">2.6.7.3.</a> <strong>No lineage editing or misrepresentation will be tolerated.</strong> Doing so will result in the loss of upload privileges. If you are unsure of a lineage, then do not provide it. Do NOT guess.</li>
					</ul>
				</li>
				<li id="r2.6.8"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.8">2.6.8.</a> <strong>Soundboards must be uploaded according to <a href="wiki.php?action=article&amp;id=159">this naming and uploading guide</a> and according to <a href="wiki.php?action=article&amp;id=750">this wiki</a> on site organization.</strong> </li>
				<li id="r2.6.9"><a href="#h2.6"><strong>&uarr;_</strong></a> <a href="#r2.6.9">2.6.9.</a> <strong>The following lists should illustrate when Live music may or may not be uploaded.</strong>
					<ul>
						<li id="r2.6.9.1"><a href="#r2.6.9"><strong>&uarr;_</strong></a> <a href="#r2.6.9.1">2.6.9.1.</a> <strong>Allowed Live Music</strong>
							<ul>
								<li>Live album bought from an online retailer</li>
								<li>CD bought from a brick &amp; mortar store</li>
								<li>Soundboard recording that follows the Live Music rules</li>
								<li>Soundboard recording that has been adopted by the artist</li>
								<li>WEB-sourced live bootleg (released by the artist or a record label)</li>
								<li>CD-sourced live bootleg (released by the artist or a record label)</li>
								<li>Bootleg album that was later sanctioned by the record label</li>
								<li>Soundboard recordings containing a tape generation in the lineage; this will require staff approval unless the tape generation is the first generation</li>
							</ul>
						</li>
						<li id="r2.6.9.2"><a href="#r2.6.9"><strong>&uarr;_</strong></a> <a href="#r2.6.9.2">2.6.9.2.</a> <strong>Disallowed Live Music</strong>
							<ul>
								<li>Unofficial live mix of a studio album (no artist or record label involvement)</li>
								<li>Vanity House mix</li>
								<li>Incomplete soundboard recordings</li>
								<li>Soundboard recordings containing sound checks or other non-performance portions</li>
								<li>Collection of random live tracks from a single artist</li>
								<li>Collection of random live tracks from multiple artists</li>
								<li>Collection of remixed live tracks</li>
								<li>Radio broadcast of a live performance</li>
							</ul>
						</li>
					</ul>
				</li>
			</ul>
		</div>
		<h5 id="h2.7"><a href="#h2.7k"><strong>&uarr;</strong></a> <a href="#h2.7">2.7.</a> Multichannel</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.7.1"><a href="#h2.7"><strong>&uarr;_</strong></a> <a href="#r2.7.1">2.7.1.</a> <strong>The only lossy multichannel audio formats allowed are AC3 and DTS.</strong> If the source is DTS or AC3, do not transcode to other formats. Exceptions: Transcoding is allowed if the source is lossless (LPCM or MLP). Those should be compressed with multichannel FLAC. See <a href="wiki.php?action=article&amp;id=143">this wiki</a> for more information.</li>
				<li id="r2.7.2"><a href="#h2.7"><strong>&uarr;_</strong></a> <a href="#r2.7.2">2.7.2.</a> <strong>DTS-CD rips cannot be re-compressed to a lossless codec and they must be kept as WAV files with the .dts extension.</strong> </li>
				<li id="r2.7.3"><a href="#h2.7"><strong>&uarr;_</strong></a> <a href="#r2.7.3">2.7.3.</a> <strong>A multichannel lossless rip of multichannel source media must have the same number of and arrangement of channels as the source media.</strong> In addition, the rip must be encoded at the same bit depth and sampling rate as the original stream. Downsampled versions of the original source material may be trumped by a torrent containing audio files encoded at the original bit depth and sampling rate as the files on disc.</li>
				<li id="r2.7.4"><a href="#h2.7"><strong>&uarr;_</strong></a> <a href="#r2.7.4">2.7.4.</a> <strong>A multichannel rip of source media that includes both multichannel and stereo streams may coexist with a rip of the stereo stream off the same media.</strong> A rip of the stereo stream trumps a downmix of the multichannel rip. However, if there is no rip of a stereo stream uploaded, a stereo downmix of a rip from the multichannel stream may coexist with a multichannel rip of the same stream. For example, a DVD-Audio disc may include both stereo LPCM (Linear Pulse-Code Modulation) audio and 5.1 MLP (Meridian Lossless Packing) audio. In this case, a stereo rip of the LPCM stream could coexist with a 5.1 rip of the MLP stream, and the stereo LPCM rip would trump a stereo downmix of a multichannel MLP stream rip. If no stereo LPCM rip of this source media was uploaded, a stereo downmix of the MLP stream could coexist with a 5.1 multichannel rip of the MLP stream.</li>
				<li id="r2.7.5"><a href="#h2.7"><strong>&uarr;_</strong></a> <a href="#r2.7.5">2.7.5.</a> <strong>Be aware of the special tagging rules for AC3 torrents (see <a href="#r2.3.16">2.3.16</a>).</strong> </li>
			</ul>
		</div>
		<h5 id="h2.8"><a href="#h2.8k"><strong>&uarr;</strong></a> <a href="#h2.8">2.8.</a> SACD</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.8.1"><a href="#h2.8"><strong>&uarr;_</strong></a> <a href="#r2.8.1">2.8.1.</a> <strong>Digital rips produced by the PlayStation 3 (PS3) - SACD ripper process (see <a href="wiki.php?action=article&amp;id=922">this wiki</a>) trump any other SACD digital or analog rips (e.g., Oppo method, analog output to ADC, DSD stream from a SACD player, etc.).</strong> Non-PS3 digital SACD rips trump analog SACD rips. Torrents containing a 88.2 kHz digitally-sourced PCM stream compressed with FLAC are trumpable by new digital rips made directly from the SACD disc using the PS3-SACD ripper method. See <a href="wiki.php?action=article&amp;id=922">this wiki</a> for more information on the SACD format. Note: This means that you cannot download another user's uncompressed DSD source files and manipulate those.</li>
				<li id="r2.8.2"><a href="#h2.8"><strong>&uarr;_</strong></a> <a href="#r2.8.2">2.8.2.</a> <strong>Analog SACD rips may have a sampling rate equal to 88.2 or 96 kHz and may be trumped at any time by a digital 24/88.2 SACD rip.</strong> If a digital SACD rip has frequencies higher than 44.1 kHz, contact a moderator privately for approval to upload a 24-bit rip with a sampling rate greater than 88.2 kHz.</li>
				<li id="r2.8.3"><a href="#h2.8"><strong>&uarr;_</strong></a> <a href="#r2.8.3">2.8.3.</a> <strong>SACD hybrid rip sources must be properly labeled.</strong>
					<ul>
						<li id="r2.8.3.1"><a href="#r2.8.3"><strong>&uarr;_</strong></a> <a href="#r2.8.3.1">2.8.3.1.</a> <strong>SACD hybrid discs ripped from the CD layer should be labeled as CD and not SACD.</strong> If you used your CD/DVD drive and a CD ripper (such as <a href="http://www.exactaudiocopy.de/" target="_blank">EAC</a>) to extract the audio, then label it as "CD" sourced because it is not true 24-bit audio.</li>
						<li id="r2.8.3.2"><a href="#r2.8.3"><strong>&uarr;_</strong></a> <a href="#r2.8.3.2">2.8.3.2.</a> <strong>If the rip came from the genuine digital SACD layer via a PS3 player or through a SACD player mod or line out, it should be 24-bit quality SACD.</strong> You may include "SACD Hybrid" in the Edition Information box on the <a href="upload.php">upload page</a>.</li>
					</ul>
				</li>
				<li id="r2.8.4"><a href="#h2.8"><strong>&uarr;_</strong></a> <a href="#r2.8.4">2.8.4.</a> <strong>Lineage information for an SACD capture is required and should be included in the torrent folder.</strong>
					<ul>
						<li id="r2.8.4.1"><a href="#r2.8.4"><strong>&uarr;_</strong></a> <a href="#r2.8.4.1">2.8.4.1.</a> <strong>Both digital and analog SACD rips require lineage information that includes the SACD ripping process, equipment used, applicable conversion software (with the conversion settings), and any post-capture software mastering that was performed.</strong> Any torrents that lack this lineage information are trumpable.</li>
						<li id="r2.8.4.2"><a href="#r2.8.4"><strong>&uarr;_</strong></a> <a href="#r2.8.4.2">2.8.4.2.</a> <strong>Digital rips that use the Saracon or Philips converters will trump foobar rips that use the SACD_input converter; all three of these rips would trump a digital rip that uses the Audiogate converter.</strong> </li>
						<li id="r2.8.4.3"><a href="#r2.8.4"><strong>&uarr;_</strong></a> <a href="#r2.8.4.3">2.8.4.3.</a> <strong>Digital rips created from the Saracon and Philips converters must be "de-clicked" (PM a moderator for details on the process, which consists of trimming 53 samples from the DFF file and then prepending and appending 12 samples back onto the file during the conversion process).</strong> </li>
						<li id="r2.8.4.4"><a href="#r2.8.4"><strong>&uarr;_</strong></a> <a href="#r2.8.4.4">2.8.4.4.</a> <strong>No lineage editing or misrepresentation will be tolerated.</strong> Doing so will result in the loss of upload privileges. If you are unsure of a lineage, then do not provide it. Do NOT guess.</li>
					</ul>
				</li>
				<li id="r2.8.5"><a href="#h2.8"><strong>&uarr;_</strong></a> <a href="#r2.8.5">2.8.5.</a> <strong> Downsampling of SACD sources is allowed in certain cases.</strong>
					<ul>
						<li id="r2.8.5.1"><a href="#r2.8.5"><strong>&uarr;_</strong></a> <a href="#r2.8.5.1">2.8.5.1.</a> <strong> A multichannel lossless rip must have the same number of and arrangement of channels as the source media.</strong> In addition, the rip must be encoded at the same bit depth and sampling rate as the original stream. Downsampled versions of the original source material may be trumped by a torrent containing audio files ripped directly from the disc at the bit depth and sampling rate originally found on disc. For example, there is a 192 kHz track and a 44.1 kHz track on the SACD. A user uploads only the 192 kHz track and that source is subsequently downsampled to 44.1 kHz. Another user who rips the actual 44.1 kHz track from the original disc may trump the downsampled torrent.</li>
						<li id="r2.8.5.2"><a href="#r2.8.5"><strong>&uarr;_</strong></a> <a href="#r2.8.5.2">2.8.5.2.</a> <strong>Downmixing of SACD sources is prohibited.</strong> Do not downmix a 5.1 (or higher) channel mix to stereo and upload the resulting audio files. You may still downconvert lossless audio sources from 24-bit to 16-bit.</li>
						<li id="r2.8.5.3"><a href="#r2.8.5"><strong>&uarr;_</strong></a> <a href="#r2.8.5.3">2.8.5.3.</a> <strong> All lossy SACD torrents must be uploaded in a Red Book-compliant form.</strong> Any stereo lossless sources must be downconverted to 16 bits and downsampled to 44.1 kHz before they are transcoded to lossy MP3 formats. No other bit depth or sampling rate is allowed for lossy SACD torrents.</li>
					</ul>
				</li>
			</ul>
		</div>
		<h5 id="h2.9"><a href="#h2.9k"><strong>&uarr;</strong></a> <a href="#h2.9">2.9.</a> Blu-ray</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.9.1"><a href="#h2.9"><strong>&uarr;_</strong></a> <a href="#r2.9.1">2.9.1.</a> <strong>Only digital rips of the lossless audio track from a Blu-ray disc may be uploaded (see <a href="wiki.php?action=article&amp;id=926">this wiki</a> and <a href="wiki.php?action=article&amp;id=854">this wiki</a> for more information).</strong> Analog Blu-ray rips are forbidden. Blu-ray discs may contain all of the following formats: Dolby Digital (AC3), DTS, Dolby Digital Plus (AC3), DTS-HD, PCM, Dolby TrueHD, DTS-HD Master Audio. Only PCM, Dolby TrueHD, and DTS-HD Master Audio contain truly lossless audio material on the Blu-ray disc. See <a href="#r2.1.1">2.1.1</a> and <a href="#r2.7.1">2.7.1 </a> for more information on multichannel audio material on the site.</li>
				<li id="r2.9.2"><a href="#h2.9"><strong>&uarr;_</strong></a> <a href="#r2.9.2">2.9.2.</a> <strong> Uploading movie audio tracks is prohibited.</strong> For example, the Inception Blu-ray disc set features a DTS-HD Master Audio 5.1 surround sound track for the entire movie, which cannot be uploaded, and a DTS-HD Master Audio 5.1 surround sound mix of the movie soundtrack, which can be uploaded. Uploading movie audio tracks will result in a warning and the loss of your uploading privileges.</li>
				<li id="r2.9.3"><a href="#h2.9"><strong>&uarr;_</strong></a> <a href="#r2.9.3">2.9.3.</a> <strong> Blu-ray rip sources must be properly labeled.</strong>
					<ul>
						<li id="r2.9.3.1"><a href="#r2.9.3"><strong>&uarr;_</strong></a> <a href="#r2.9.3.1">2.9.3.1.</a> <strong> If the source was lossy (e.g., AC3 or DTS) do not transcode to other formats.</strong> </li>
						<li id="r2.9.3.2"><a href="#r2.9.3"><strong>&uarr;_</strong></a> <a href="#r2.9.3.2">2.9.3.2.</a> <strong> If the source was a genuine lossless track, identify the track in the album edition field, e.g., "16-bit PCM" or "24-bit DTS-HD MA 5.1".</strong> Sampling rate information may also be included (e.g., "16/48 LPCM") in the album edition field. </li>
					</ul>
				</li>
				<li id="r2.9.4"><a href="#h2.9"><strong>&uarr;_</strong></a> <a href="#r2.9.4">2.9.4.</a> <strong>Lineage information for a Blu-ray transfer is required and should be included in the torrent folder.</strong>
					<ul>
						<li id="r2.9.4.1"><a href="#r2.9.4"><strong>&uarr;_</strong></a> <a href="#r2.9.4.1">2.9.4.1.</a> <strong> All Blu-ray rips require lineage information that includes the identity of the Blu-ray source, any software used for ripping and encoding, disc drive and other equipment used, and details of the transfer process.</strong> Any torrents that lack this lineage information are trumpable.</li>
						<li id="r2.9.4.2"><a href="#r2.9.4"><strong>&uarr;_</strong></a> <a href="#r2.9.4.2">2.9.4.2.</a> <strong>No lineage editing or misrepresentation will be tolerated.</strong> Doing so will result in the loss of upload privileges. If you are unsure of a lineage, then do not provide it. Do NOT guess.</li>
					</ul>
				</li>
				<li id="r2.9.5"><a href="#h2.9"><strong>&uarr;_</strong></a> <a href="#r2.9.5">2.9.5.</a> <strong> Downsampling of Blu-ray sources is allowed in certain cases.</strong>
					<ul>
						<li id="r2.9.5.1"><a href="#r2.9.5"><strong>&uarr;_</strong></a> <a href="#r2.9.5.1">2.9.5.1.</a> <strong> A multichannel lossless rip must have the same number of and arrangement of channels as the source media.</strong> In addition, the rip must be encoded at the same bit depth and sampling rate as the original stream. Downsampled versions of the original source material may be trumped by a torrent containing audio files ripped directly from the disc at the bit depth and sampling rate originally found on disc. For example, there is a 96 kHz track and a 44.1 kHz track on the Blu-ray disc. A user uploads only the 96 kHz track and that source is subsequently downsampled to 44.1 kHz. Another user who rips the actual 44.1 kHz track from the original disc may trump the downsampled torrent.</li>
						<li id="r2.9.5.2"><a href="#r2.9.5"><strong>&uarr;_</strong></a> <a href="#r2.9.5.2">2.9.5.2.</a> <strong> Downmixing of Blu-ray sources is prohibited.</strong> Do not downmix a 5.1 (or higher) channel mix to stereo and upload the resulting audio files. You may still downconvert lossless audio sources from 24-bit to 16-bit.</li>
						<li id="r2.9.5.3"><a href="#r2.9.5"><strong>&uarr;_</strong></a> <a href="#r2.9.5.3">2.9.5.3.</a> <strong> All lossy Blu-ray torrents must be uploaded in a Red Book-compliant form.</strong> Any stereo lossless sources must be downconverted to 16 bits and downsampled to 44.1 kHz before they are transcoded to lossy MP3 formats. No other bit depth or sampling rate is allowed for lossy Blu-ray torrents.</li>
						<li id="r2.9.5.4"><a href="#r2.9.5"><strong>&uarr;_</strong></a> <a href="#r2.9.5.4">2.9.5.4.</a> <strong> Do not downsample, downmix, transcode or otherwise manipulate any lossy Blu-ray format (e.g., Dolby Digital (AC3), DTS, Dolby Digital Plus (AC3), and DTS-HD).</strong> </li>
					</ul>
				</li>
			</ul>
		</div>
		<h5 id="h2.10"><a href="#h2.10k"><strong>&uarr;</strong></a> <a href="#h2.10">2.10.</a> Cassettes</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r2.10.1"><a href="#h2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.1">2.10.1.</a> <strong>Cassettes are allowed under strict conditions.</strong> "Cassettes" include compact cassettes, 8-track tape cartridges, and non-cassette consumer reel-to-reel audio tape recordings.
					<ul>
						<li id="r2.10.1.1"><a href="#r2.10.1"><strong>&uarr;_</strong></a> <a href="#r2.10.1.1">2.10.1.1.</a> <strong>Cassette releases may not be uploaded if the release exists on the site in any other format.</strong> A non-cassette release may trump a cassette release. A bonus track which only appears on the cassette release is considered exclusive content for that release, and the full cassette release may be uploaded. A different mastering or a different track order is not sufficient to justify the upload of a cassette rip.</li>
						<li id="r2.10.1.2"><a href="#r2.10.1"><strong>&uarr;_</strong></a> <a href="#r2.10.1.2">2.10.1.2.</a> <strong>Rips must be made from official (e.g., artist- or label-approved) cassette sources;</strong> secondhand copies are prohibited. Bootlegs are often secondhand copies and may be deleted outright if they do not meet high quality audio standards. Please see rule <a href="#r2.10.8">2.10.8</a>.</li>
					</ul>
				</li>
				<li id="r2.10.2"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.2">2.10.2.</a> <strong>All cassette rips should include clear information about lineage.</strong> Include a description of the ripping hardware if this is a personal rip or if a rip downloaded elsewhere includes this information. It is strongly recommended that uploaders include a photo of the cassette and artwork in the torrent description. Any torrents that lack lineage information are trumpable by those that have lineage information.</li>
				<li id="r2.10.3"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.3">2.10.3.</a> <strong>Cassette uploads must be ripped at a sample rate of 44.1 kHz or 48 kHz and 88.2 kHz or 96 kHz.</strong> Cassette uploads with sample rates above 96 kHz may be deleted at moderator discretion. Lossy transcodes of cassette FLACs must retain the sample rate of the original FLAC if it is 44.1 kHz or 48 kHz. 44.1 kHz and 48 kHz rips may not exist concurrently; 88.2 kHz and 96 kHz may not exist concurrently; if one is already available, the other is considered a dupe unless a substantial improvement in audio quality is evident (see rule <a href="#r2.10.6">2.10.6</a>).</li>
				<li id="r2.10.4"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.4">2.10.4.</a> <strong>Cassette rips will be trumped by an upload of the same release in any other medium.</strong> A cassette edition with bonus tracks not available in another edition is not subject to trumping.</li>
				<li id="r2.10.5"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.5">2.10.5.</a> <strong>Cassette rips are subject to the duplicates and trumping rules outlined in rule <a href="#h2.2">2.2</a>.</strong></li>
				<li id="r2.10.6"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.6">2.10.6.</a> <strong>Cassette rips can be trumped if a substantially better-sounding version is uploaded.</strong> To trump an old rip with a new torrent that may be a better-sounding version, you need to report it with clear information about how your rip sounds better than the other one, with references to specific tracks and time positions to justify your report. All quality trumps/deletions of this nature are at the discretion of the moderator involved.</li>
				<li id="r2.10.7"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.7">2.10.7.</a> <strong>Cassette rips of extremely poor quality (lossy or lossless) may be deleted outright if reported.</strong> All quality trumps/deletions of this nature are at the discretion of the moderator involved.</li>
				<li id="r2.10.8"><a href="#r2.10"><strong>&uarr;_</strong></a> <a href="#r2.10.8">2.10.8.</a> <strong>Exceptions to any of the above rules may be made at a moderator's discretion.</strong> Please contact staff <em>before uploading</em> with detailed reasons why such an exception should be considered. Examples: a higher sample rate for a high quality reel-to-reel recording, a cassette release that was subsequently released on brickwalled CD master, a lower sample rate for a good rip of a Type I cassette, a good rip of a second generation tape with rare content. This is not an exhaustive list of possible reasons to grant an exception.</li>
			</ul>
		</div>
		<h4 id="h3"><a href="#h3k"><strong>&uarr;</strong></a> <a href="#h3">3.</a> Comedy (Audio) &amp; Audiobooks</h4>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r3.1"><a href="#r3.1k"><strong>&uarr;_</strong></a> <a href="#r3.1">3.1.</a> The only formats allowed for comedy and audiobooks are those listed below:
					<ul>
						<li>MP3, AAC, FLAC</li>
						<li id="r3.1.1"><a href="#r3.1"><strong>&uarr;_</strong></a> <a href="#r3.1.1">3.1.1.</a> <strong>Lossless audio files are allowed at all times, in accordance with the dupe rules (see <a href="#r3.9">3.9</a>).</strong> </li>
						<li id="r3.1.2"><a href="#r3.1"><strong>&uarr;_</strong></a> <a href="#r3.1.2">3.1.2.</a> <strong>Lossy comedy and audiobook torrents must have a minimum average bitrate of 32 kbps (for MP3 and AAC).</strong> </li>
					</ul>
				</li>
				<li id="r3.2"><a href="#r3.2k"><strong>&uarr;_</strong></a> <a href="#r3.2">3.2.</a> <strong>No music is permitted in these two categories. They are for spoken word only. See <a href="wiki.php?action=article&amp;id=955">this wiki</a> for more information.</strong> For example, if a comedy artist performs a stand-up routine that is recorded on CD, this would be classified as a Comedy album. If this same artist sings some funny songs on an album, this would be classified as a Comedy album. If this same artist produces a music CD with no hint of comedic material (e.g., spoken word tracks), this would be classified as a music album (see <a href="#h2.1">2.1</a>). </li>
				<li id="r3.3"><a href="#r3.3k"><strong>&uarr;_</strong></a> <a href="#r3.3">3.3.</a> <strong>No radio talk shows or podcasts are allowed.</strong> <?=SITE_NAME?> is primarily a music site, and those recordings do not belong in any torrent category. </li>
				<li id="r3.4"><a href="#r3.4k"><strong>&uarr;_</strong></a> <a href="#r3.4">3.4.</a> <strong>Comedy and audiobooks must not be freely available.</strong> Free audiobooks and comedy releases from official sources may not be uploaded. Exceptions: Uploads that are at a different bitrate from those freely available are allowed. If a comedy album in 96 kbps CBR MP3 is freely available, you may still upload a V8 (VBR) or higher bitrate torrent of the freely available torrent if it does not already exist on the site. </li>
				<li id="r3.5"><a href="#r3.5k"><strong>&uarr;_</strong></a> <a href="#r3.5">3.5.</a> <strong>Releases must be unarchived and consist of a single release.</strong> Comedy and audiobook releases should not be archived in a file (e.g., .zip or .rar). The torrent must consist of a directory containing the audio files. Only one release per torrent is allowed. You may not bundle multiple audiobooks or comedy releases into one torrent. See <a href="#r1.2.7">1.2.7</a> and <a href="#r2.1.20">2.1.20</a>. </li>
				<li id="r3.6"><a href="#r3.6k"><strong>&uarr;_</strong></a> <a href="#r3.6">3.6.</a> <strong>All comedy and audiobook releases must have an average bitrate of at least 32 kbps</strong>. However, higher bitrates are preferred over this minimum requirement.
					<ul>
						<li id="r3.6.1"><a href="#r3.6"><strong>&uarr;_</strong></a> <a href="#r3.6.1">3.6.1.</a> <strong>V0 (VBR), V2 (VBR), and V8 (VBR) MP3 torrents for the same album are allowed at all times.</strong> </li>
						<li id="r3.6.2"><a href="#r3.6"><strong>&uarr;_</strong></a> <a href="#r3.6.2">3.6.2.</a> <strong>V8 (VBR) replaces V3 (VBR) through V7 (VBR) and replaces CBR rips between 32 kbps and 191 kbps.</strong> Once a rip with a V8 (VBR) encoding preset has been uploaded, you are not allowed to upload any V3 (VBR) through V7 (VBR) torrents or any CBR torrents under 192 kbps.</li>
						<li id="r3.6.3"><a href="#r3.6"><strong>&uarr;_</strong></a> <a href="#r3.6.3">3.6.3.</a> <strong>V2 (VBR) replaces CBR rips between 192 kbps and 320 kbps.</strong> Once a rip with a V2 (VBR) encoding preset has been uploaded, you are not allowed to upload any CBR torrents.</li>
						<li id="r3.6.4"><a href="#r3.6"><strong>&uarr;_</strong></a> <a href="#r3.6.4">3.6.4.</a> <strong>V0 (VBR) replaces V1 (VBR) and replaces CBR rips at 320 kbps and above.</strong> Once a rip with a V0 (VBR) encoding preset has been uploaded, you are not allowed to upload a V1 (VBR) torrent or any CBR torrents at 320 kbps and above.</li>
						<li id="r3.6.5"><a href="#r3.6"><strong>&uarr;_</strong></a> <a href="#r3.6.5">3.6.5.</a> <strong>The preferred AAC bitrate is 64 kbps.</strong> All other AAC bitrates may be trumped by a 64 kbps upload. Once a 64 kbps AAC torrent has been uploaded, no further AAC uploads are allowed for that album.</li>
					</ul>
				</li>
				<li id="r3.7"><a href="#r3.7k"><strong>&uarr;_</strong></a> <a href="#r3.7">3.7.</a> <strong>Lossy sources, including lossy transcodes, are allowed in this section only.</strong> The source may come from cassette, VHS (audio), radio, or a higher bitrate lossy file. While the sharing of transcoded material is strongly discouraged for music, the audio quality is less important for spoken word material. Note: You may not transcode a lower bitrate file to a higher bitrate file and upload it here. For example, if you find a 32 kbps CBR WMA you cannot transcode it to 64 kbps CBR MP3 and share this on the site.</li>
				<li id="r3.8"><a href="#r3.8k"><strong>&uarr;_</strong></a> <a href="#r3.8">3.8.</a> <strong>Online audiobook sources may carry only low bitrate audio files.</strong> Audiobook sources such as <a href="http://www.audible.com/">audible.com</a> have standard audio quality levels that may be at or below the standards for the site (see <a href="#r3.1.2">3.1.2</a>). Please make sure that you know the audio quality of your source material (e.g., many audiobook retailers only supply 64 kbps files) before you transcode to V8 (VBR), V2 (VBR), or V0 (VBR). Transcoding from a lower bitrate file to a higher bitrate file is forbidden.</li>
				<li id="r3.9"><a href="#r3.9k"><strong>&uarr;_</strong></a> <a href="#r3.9">3.9.</a> <strong>Duplicate torrents of the same bitrate and format are not allowed.</strong> No uploads of the same bitrate and format are allowed to coexist on the site. See <a href="#r3.6">3.6</a>.</li>
				<li id="r3.10"><a href="#r3.10k"><strong>&uarr;_</strong></a> <a href="#r3.10">3.10.</a> <strong>Scene and non-scene versions of the same release, bitrate, and format are dupes.</strong> The Scene label does not make torrents unique from one another. If a V2 (VBR) torrent for an album on CD is already uploaded, you may not upload another V2 (VBR) scene release of the same album on CD.</li>
				<li id="r3.11"><a href="#r3.11k"><strong>&uarr;_</strong></a> <a href="#r3.11">3.11.</a> <strong>Releases must follow the usual formatting guidelines for file names and tags.</strong> Audiobooks and comedy must follow the formatting rules outlined in section <a href="#h2.3">2.3</a>. This means that file names must include track numbers, audio files must have metatags, etc.</li>
				<li id="r3.12"><a href="#r3.12k"><strong>&uarr;_</strong></a> <a href="#r3.12">3.12.</a> <strong>Do not upload multiple formats for a Comedy or audiobook album onto the same album page.</strong> Each format should have its own torrent page. Likewise, do not group existing single-torrent Comedy and audiobook releases onto a single common album page with multiple formats. Grouping torrents in these non-music categories as if they were music torrents causes a number of database and organizational problems on the site.</li>
			</ul>
		</div>

		<h4 id="h4"><a href="#h4k"><strong>&uarr;</strong></a> <a href="#h4">4.</a> Applications</h4>
		<h5 id="h4.1"><a href="#h4.1k"><strong>&uarr;</strong></a> <a href="#h4.1">4.1.</a> General</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r4.1.1"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.1">4.1.1.</a> <strong>App releases can be either a torrent of a directory or a single archive.</strong>
					<ul>
						<li id="r4.1.1.1"><a href="#r4.1.1"><strong>&uarr;_</strong></a> <a href="#r4.1.1.1">4.1.1.1.</a> <strong>Scene released applications may be archived but must not be password protected.</strong> If archives were originally password protected and had the protection removed, they cannot be represented as official scene releases and should not be labeled as scene torrents. The file hashes between protected and unprotected archives are different, resulting in a modification of the original files. Some packs and collections cannot be archived (see <a href="#r4.1.9">4.1.9</a>).</li>
						<li id="r4.1.1.2"><a href="#r4.1.1"><strong>&uarr;_</strong></a> <a href="#r4.1.1.2">4.1.1.2.</a> <strong>Mac applications must be archived for them to function.</strong> Mac applications uploaded as .app directories will require a CHMOD operation, which is unnecessary when the application is properly archived (e.g., .dmg, .zip, etc.).</li>
					</ul>
				</li>
				<li id="r4.1.2"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.2">4.1.2.</a> <strong>All applications must come with a crack, keygen, or other method of ensuring that downloaders can install them easily.</strong> App torrents with keygens, cracks, or patches that do not work or torrents missing clear installation instructions will be deleted if reported. No exceptions.</li>
				<li id="r4.1.3"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.3">4.1.3.</a> <strong>App releases must not be freely available tools.</strong> Application releases cannot be freely downloaded anywhere from any official source. Nor may you upload open source applications where the source code is available for free. Closed or shareware installers like Crossover Office are allowed. Note: If all official sources stop hosting and remove a freely available application and its source code from their site(s) due to varying reasons (e.g., legal concerns, dead development, etc.), the application ceases to be freely available. You may then upload it in that case.</li>
				<li id="r4.1.4"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.4">4.1.4.</a> <strong>Release descriptions for applications must contain good information about the application.</strong> You should either have a small description of the program (either taken from its web site or from an NFO file) or a link to the information&#8202;&mdash;&#8202;but ideally both. Torrents missing this information will be deleted when reported.</li>
				<li id="r4.1.5"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.5">4.1.5.</a> <strong>The torrent title must have a descriptive name.</strong> The torrent title should at least include the application name and release version. Optionally, you may include additional labels for operating system and method of circumvention (e.g., crack, patch, keygen, or serial). For example, "AcrylicApps Wallet v3.0.1.493 MacOSX Cracked".</li>
				<li id="r4.1.6"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.6">4.1.6.</a> <strong>Use relevant tags for your torrent.</strong> Add all applicable default <a href="?p=tag">Gazelle tags</a> to help downloaders find your torrent. The default tags are apps.mac for Mac applications, apps.windows for Windows applications, and apps.sound for audio applications. You may add additional tags if the default ones do not apply (such as apps.linux).</li>
				<li id="r4.1.7"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.7">4.1.7.</a> <strong>Games of any kind are prohibited (see <a href="#r1.2.5">1.2.5</a>).</strong> </li>
				<li id="r4.1.8"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.8">4.1.8.</a> <strong>Application "packs" are not allowed.</strong> That means no 0-day packs or "video utilities" compilations. Also, packaging multiple versions of the same application into a single torrent is not allowed (e.g., Adobe Acrobat 8 and Adobe Acrobat 9 in a single torrent). Exceptions: The applications are from the same company and an official release. For example, Adobe CS and Macromedia Studio packaged in one set.</li>
				<li id="r4.1.9"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.9">4.1.9.</a> <strong>Sound sample packs, template collections, and font collections are allowed if they are official releases, not freely available, and unarchived.</strong> Sound sample packs, template collections, and font collections must be official compilations and they must not be uploaded as an archive. The files contained inside the torrent must not be archived so that users can see what the pack contains. That means if sound sample packs are in WAV format, they must be uploaded as WAV. If the font collection, template collection, or sound sample pack was originally released as an archive, you must unpack the files before uploading them in a torrent. None of the contents in these packs and collections may be freely available.</li>
				<li id="r4.1.10"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.10">4.1.10.</a> <strong>Application components such as plug-ins, add-ons, expansions, filters, and so forth may be uploaded in a collection if they correspond to a particular application.</strong> You may upload plug-ins, expansions, add-ons, filters, and other application components as collections provided they are compatible to a particular application and version. For example, you may not upload a megapack of all filters for Adobe Photoshop CS2, CS3, and CS4. But you may upload a pack of Adobe Photoshop CS4 filters.</li>
				<li id="r4.1.11"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.11">4.1.11.</a> <strong>Collections of cracks, keygens or serials are not allowed.</strong> The crack, keygen, or serial for an application must be in a torrent with its corresponding application. It cannot be uploaded separately from the application.</li>
				<li id="r4.1.12"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.12">4.1.12.</a> <strong>Torrents containing hacking or cracking tools are prohibited.</strong> </li>
				<li id="r4.1.13"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.13">4.1.13.</a> <strong>Never post serial numbers in torrent descriptions.</strong> Serial numbers should be in a text file contained within the torrent. If a serial number is posted in the torrent description and not included as a text file in the torrent folder, the torrent will be removed when reported. No exceptions.</li>
				<li id="r4.1.14"><a href="#h4.1"><strong>&uarr;_</strong></a> <a href="#r4.1.14">4.1.14.</a> <strong>All applications must be complete.</strong> If an application consists of multiple CDs or DVDs, these should all be uploaded as one torrent and not as separate torrents. This also applies to scene uploads where multiple CDs or DVDs were released separately.</li>
			</ul>
		</div>
		<h5 id="h4.2"><a href="#h4.2k"><strong>&uarr;</strong></a> <a href="#h4.2">4.2.</a> Duplicates &amp; Trumping</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r4.2.1"><a href="#h4.2"><strong>&uarr;_</strong></a> <a href="#r4.2.1">4.2.1.</a> <strong>Applications having the same version number are dupes.</strong> An application may have older versions than those already uploaded. Those are not dupes. Only identical versions are duplicates. Note: Not everyone has updated to the latest operating system. In such cases, older versions of applications may still be useful for a number of users.</li>
				<li id="r4.2.2"><a href="#h4.2"><strong>&uarr;_</strong></a> <a href="#r4.2.2">4.2.2.</a> <strong>A scene archived torrent may coexist with an unarchived torrent of the same application version.</strong> If both a scene archive and an unarchived copy are uploaded of the same application and version, both may stay on the site. Any subsequent uploads of the same torrent in either form (with identical install methods) are dupes.</li>
				<li id="r4.2.3"><a href="#h4.2"><strong>&uarr;_</strong></a> <a href="#r4.2.3">4.2.3.</a> <strong>Different language editions of the same application and version are unique.</strong> Multi-language versions and single language versions of different languages are not considered dupes.</li>
				<li id="r4.2.4"><a href="#h4.2"><strong>&uarr;_</strong></a> <a href="#r4.2.4">4.2.4.</a> <strong>Existing application torrents can be trumped by other torrents with better install methods.</strong> Applications with serial keys may be trumped by crack/patch versions or torrents with keygens. Once an application with either a crack/patch or keygen is uploaded to the site, no other identical application with a different installation method is allowed. Report the older torrent when you are trumping it with a torrent of the same application containing an improved method of installation.</li>
				<li id="r4.2.5"><a href="#h4.2"><strong>&uarr;_</strong></a> <a href="#r4.2.5">4.2.5.</a> <strong>Applications that no longer work will be deleted when reported.</strong> If the install method for an application no longer works (e.g., the developer has coded a patch, the install method is no longer supported, etc.) the torrent will be removed.</li>
			</ul>
		</div>

		<h4 id="h5"><a href="#h5k"><strong>&uarr;</strong></a> <a href="#h5">5.</a> Comic Books</h4>
		<h5 id="h5.1"><a href="#h5.1k"><strong>&uarr;</strong></a> <a href="#h5.1">5.1.</a> General</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r5.1.1"><a href="#h5.1"><strong>&uarr;_</strong></a> <a href="#r5.1.1">5.1.1.</a> <strong>Comic books must be uploaded in the following specified formats, according to descending preference:</strong>
					<ul>
						<li>A rar archive (Preferably with the .cbr extension)</li>
						<li>A zip archive (Preferably with the .cbz extension)</li>
						<li>A PDF file</li>
						<li>A directory containing only the images themselves</li>
					</ul>
				</li>
				<li id="r5.1.2"><a href="#h5.1"><strong>&uarr;_</strong></a> <a href="#r5.1.2">5.1.2.</a> <strong>Pages must be scanned cleanly and be of good quality.</strong> Scans of poor quality will be deleted, especially if the quality is so poor as to render the image difficult to read. Poorer quality scans may be acceptable for very old or rare comics with staff approval.</li>
				<li id="r5.1.3"><a href="#h5.1"><strong>&uarr;_</strong></a> <a href="#r5.1.3">5.1.3.</a> <strong>Comic books must not be freely available.</strong> Comics must be official publications and cannot be taken for free from official sources. You may upload comics from other torrent and unofficial distribution sites, but it is your responsibility to make sure that they conform to our quality and formatting rules for comic books. Note: If all official sources stop hosting a comic and remove the official freely available release from their site(s), the release ceases to be freely available. You may only upload it at that time.</li>
				<li id="r5.1.4"><a href="#h5.1"><strong>&uarr;_</strong></a> <a href="#r5.1.4">5.1.4.</a> <strong>0-Day comic uploads are allowed and encouraged.</strong> </li>
			</ul>
		</div>

		<h5 id="h5.2"><a href="#h5.2k"><strong>&uarr;</strong></a> <a href="#h5.2">5.2.</a> Multi-comic</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r5.2.1"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.1">5.2.1.</a> <strong>Multi-comic and series packs must follow site formatting requirements.</strong> Multi-comic and series packs are both accepted and encouraged but care must be taken to make a valid compilation. The rules in this section outline the requirements for multi-comic torrents.</li>
				<li id="r5.2.2"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.2">5.2.2.</a> <strong>0-Day comic packs are allowed.</strong> Make sure such uploads are synchronized with any previous packs. 0-Day comic uploads must not be missing any of their corresponding DCP or Minutemen scans for that time period.</li>
				<li id="r5.2.3"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.3">5.2.3.</a> <strong>Collections may not span more than one comic title.</strong> You may not include multiple, different comic titles in a single collection, e.g., "The Amazing Spider-Man #1" and "The Incredible Hulk #1". Exceptions: Titles may contain more than one comic title if either of the following is true: it's a recognized comic crossover/event or it's a DCP weekly release.</li>
				<li id="r5.2.4"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.4">5.2.4.</a> <strong>Any "multi-part" comic enveloping the whole event is allowed as a single torrent.</strong> Whole events may be uploaded together. For example, the comics "<samp>Buffy the Vampire Slayer Season Eight - 2007 - part 1.cbr</samp>" and "<samp>Buffy the Vampire Slayer Season Eight - 2007 - The Long Way Home Part 2.cbr</samp>" can be uploaded as a single torrent provided there are only 2 parts to "The Long Way Home".</li>
				<li id="r5.2.5"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.5">5.2.5.</a> <strong>Torrents containing complete volumes of comics may be uploaded.</strong> For example, "The Amazing Spider-Man Vol. 1 #1-#441" can be uploaded.</li>
				<li id="r5.2.6"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.6">5.2.6.</a> <strong>Torrents spanning multiple volumes are too large and must be uploaded as separate volumes.</strong> </li>
				<li id="r5.2.7"><a href="#h5.2"><strong>&uarr;_</strong></a> <a href="#r5.2.7">5.2.7.</a> <strong>Torrents containing specific #Number-#CurrentDay issues are allowed only if the comics appear in no other pack.</strong> For example, if #1-#35 are already on the site and the current issue is #50, #1-#50 is NOT allowed to be uploaded, but #36-#50 is allowed.</li>
			</ul>
		</div>

		<h5 id="h5.3"><a href="#h5.3k"><strong>&uarr;</strong></a> <a href="#h5.3">5.3.</a> Duplicates &amp; Trumping</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r5.3.1"><a href="#h5.3"><strong>&uarr;_</strong></a> <a href="#r5.3.1">5.3.1.</a> <strong>A dupe of a single comic is defined as two scans of the same book by the same scanner, where the same pages have been scanned.</strong> The scanner may be an individual, a release group, or a scanning device. Exceptions: The following examples are NOT dupes:
					<ul>
						<li>Two copies of the same book by the same scanner, but one is a c2c copy and the other is a "no ads" copy</li>
						<li>Two scans of the same book by different scanners</li>
						<li>Two scans of the same book by the same scanner, when the copy you're uploading contains fixes</li>
					</ul>
				</li>
				<li id="r5.3.2"><a href="#h5.3"><strong>&uarr;_</strong></a> <a href="#r5.3.2">5.3.2.</a> <strong>Releases in .cbz and .cbr are always allowed, with preference given to the earliest upload.</strong> In the event of a dupe occurring between a .cbr and a .cbz, the earliest upload remains. In the event of any other dupe, the order listed in <a href="#r5.1.1">5.1.1</a> determines which torrent is kept. For example, if a PDF is uploaded followed by a .cbr, the .cbr remains on the site and the PDF is deleted as a trump. If a .cbz is uploaded followed by a PDF, the .cbz remains on the site and the PDF is deleted as a dupe.</li>
				<li id="r5.3.3"><a href="#h5.3"><strong>&uarr;_</strong></a> <a href="#r5.3.3">5.3.3.</a> <strong>Multi-comic collections and packs must conform to either of these collection types in order of preference.</strong>
					<ul>
						<li id="r5.3.3.1"><a href="#r5.3.3"><strong>&uarr;_</strong></a> <a href="#r5.3.3.1">5.3.3.1.</a> <strong>A torrent consisting of issues #1-50 is currently on the site.</strong> The only packs that are allowed to contain any of the comics before #50 are a #1-100 pack or a complete volume pack.</li>
						<li id="r5.3.3.2"><a href="#r5.3.3"><strong>&uarr;_</strong></a> <a href="#r5.3.3.2">5.3.3.2.</a> <strong>Packs consisting of #1-#10, #11-#20, #21- #40, etc.</strong> are allowed only if the comics appear in no other pack. Each pack must contain at least 10 new comics.</li>
						<li id="r5.3.3.3"><a href="#r5.3.3"><strong>&uarr;_</strong></a> <a href="#r5.3.3.3">5.3.3.3.</a> <strong>Packs consisting of #1-#100, #101-#200, etc.</strong> are allowed only if they are not a complete volume pack.</li>
						<li id="r5.3.3.4"><a href="#r5.3.3"><strong>&uarr;_</strong></a> <a href="#r5.3.3.4">5.3.3.4.</a> <strong>A pack composed of #1-#EndOfVolume is allowed at any time.</strong> </li>
					</ul>
				</li>
				<li id="r5.3.4"><a href="#h5.3"><strong>&uarr;_</strong></a> <a href="#r5.3.4">5.3.4.</a> <strong>Complete volume or series packs will trump any torrent consisting of the same comic issues.</strong> See <a href="#r5.3.1">5.3.1</a> for details on what constitutes a duplicate comic. For example, the complete volume "The Amazing Spider-Man Vol. 1 #1-#441" will trump any torrents containing those issues, e.g., "The Amazing Spider-Man #1-#50" or "The Amazing Spider-Man #150-#200" or "The Amazing Spider-Man #300-#310," etc. Exception: If the image quality of the comic issue(s) in a torrent is higher than the quality of the corresponding comic(s) in a complete volume or series pack, the higher quality version may coexist on the site with the complete collection.</li>
			</ul>
		</div>

		<h5 id="h5.4"><a href="#h5.4k"><strong>&uarr;</strong></a> <a href="#h5.4">5.4.</a> Formatting</h5>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r5.4.1"><a href="#h5.4"><strong>&uarr;_</strong></a> <a href="#r5.4.1">5.4.1.</a> <strong>All comic page scans must have zero-padded numbers and may be archived in .pdf, .rar (.cbr) or .zip (.cbz) files.</strong> The contents of the archive or directory must be image files (either JPEG or PNG), which are named sequentially so that they display in the correct order by <a href="https://en.wikipedia.org/wiki/Comparison_of_image_viewers" target="_blank">comic reading software</a> such as <a href="http://www.cdisplay.me/" target="_blank">CDisplay</a> and <a href="http://www.feedface.com/software/ffview.html" target="_blank">FFView</a>. The page numbers and books must be zero-padded for this same reason. For example, this constitutes good numbering: <samp>file01.jpg</samp>, <samp>file02.jpg</samp>,... <samp>file30.jpg</samp>; and this constitutes bad numbering: <samp>file1.jpg</samp>, <samp>file2.jpg</samp>, <samp>file3.jpg</samp>,... <samp>file30.jpg</samp>.</li>
				<li id="r5.4.2"><a href="#h5.4"><strong>&uarr;_</strong></a> <a href="#r5.4.2">5.4.2.</a> <strong>Comic book archive file names must be informative.</strong> The archive names should include at least the book's name (e.g., "Uncanny X-Men"), the volume (if there's more than one volume for that book), and the issue number. Including the cover year, scanner information (to differentiate between different scans of the same book), and the issue's title (e.g., "Days of Future Past") is strongly recommended. For example: <samp>Buffy the Vampire Slayer Season Eight - #01 - 2007 - The Long Way Home Part 1.cbr</samp> and <samp>Amazing Spiderman - Volume 1 - #10 - 1964.cbz</samp>.</li>
				<li id="r5.4.3"><a href="#h5.4"><strong>&uarr;_</strong></a> <a href="#r5.4.3">5.4.3.</a> <strong>The directory name should uniquely identify its contents.</strong> You should include the title, as well as the issue numbers included (if applicable). The title, volume, cover year, and story name can often be found in small type at the bottom of the page opposite the inside cover. Directories should be named with the title of the series and the issue numbers. For example: <samp>../Buffy the Vampire Slayer Season Eight - #01-#08/</samp> and <samp>../Amazing Spiderman - Volume 1 - #10-#20/</samp>.</li>
			</ul>
		</div>

		<h4 id="h6"><a href="#h6k"><strong>&uarr;</strong></a> <a href="#h6">6.</a> ebooks, eLearning Books &amp; Sheet Music</h4>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r6.1"><a href="#r6.1k"><strong>&uarr;_</strong></a> <a href="#r6.1">6.1.</a> <strong>Individual releases can be either a torrent of a directory, an archive, or the original format (e.g., .epub, .pdf, .chm, .txt, etc.).</strong> Neither the individual release or archive can be password protected. Note: ebooks cannot be uploaded in an archive. Users must be able to see the ebook format that is in the torrent.</li>
				<li id="r6.2"><a href="#r6.2k"><strong>&uarr;_</strong></a> <a href="#r6.2">6.2.</a> <strong>Uploading a pack of ebooks in one archive (e.g., .tar, .rar, .zip) is prohibited.</strong> ebook collections cannot be uploaded. Exception: ebooks that come in a retail set may be uploaded in a single torrent.</li>
				<li id="r6.3"><a href="#r6.3k"><strong>&uarr;_</strong></a> <a href="#r6.3">6.3.</a> <strong>ebook pages must be of good quality (in other words, legible with little or no artifacting) and must be scanned cleanly (if the pages were hand-scanned).</strong> Poor quality scans will be deleted, especially if the quality is so poor that the resulting image is difficult to read. Judgments on quality are at the discretion of the moderator involved.</li>
				<li id="r6.4"><a href="#r6.4k"><strong>&uarr;_</strong></a> <a href="#r6.4">6.4.</a> <strong>Only published ebooks are allowed.</strong> Freely available ebooks are not allowed. This rule also covers recipes and cookbooks. Only official publications are allowed.</li>
				<li id="r6.5"><a href="#r6.5k"><strong>&uarr;_</strong></a> <a href="#r6.5">6.5.</a> <strong>Collections/packs of ebooks are prohibited, even if each title is somehow related to other ebook titles in some way.</strong> All ebooks must be uploaded individually and cannot be archived (users must be able to see the ebook format in the torrent).</li>
				<li id="r6.6"><a href="#r6.6k"><strong>&uarr;_</strong></a> <a href="#r6.6">6.6.</a> <strong>Two identical ebooks or two identical sheet music uploads are dupes of one another.</strong> The same ebook and sheet music titles in the same format (e.g., .epub, .pdf, .chm, .txt, etc.) are dupes.</li>
				<li id="r6.7"><a href="#r6.7k"><strong>&uarr;_</strong></a> <a href="#r6.7">6.7.</a> <strong>Manually-scanned, scanned and OCR'ed (optical character recognized), and retail ebooks are all allowed on the site.</strong> OCR'ed ebooks may trump manually-scanned versions, while untouched retail ebooks will trump both hand-scanned and OCR'ed versions.</li>
				<li id="r6.8"><a href="#r6.8k"><strong>&uarr;_</strong></a> <a href="#r6.8">6.8.</a> <strong>Include proper <a href="?p=tag">Gazelle tags</a> for your ebook and sheet music uploads.</strong> You are strongly encouraged to use the appropriate default tags with your uploads. That way other users can find your uploads easily through the tag search system. Sheet music should use the sheet.music tag. ebooks should at least contain the fiction tag or the non.fiction tag depending on the content. You may add additional tags if the defaults do not apply or are not enough to describe the torrent contents.</li>
			</ul>
		</div>

		<h4 id="h7"><a href="#h7k"><strong>&uarr;</strong></a> <a href="#h7">7.</a> eLearning Videos</h4>
		<div class="box pad" style="padding: 10px 10px 10px 20px;">
			<ul>
				<li id="r7.1"><a href="#h7"><strong>&uarr;_</strong></a> <a href="#r7.1">7.1.</a> <strong>The eLearning Videos category is only for tutorial videos on specific topics pertaining to music (see <a href="#r7.3">7.3</a> in this section).</strong> Any video clips mentioned in <a href="#h1.2">Section 1.2</a> cannot be uploaded to the eLearning Videos category.</li>
				<li id="r7.2"><a href="#h7"><strong>&uarr;_</strong></a> <a href="#r7.2">7.2.</a> <strong>No freely available eLearning videos are allowed.</strong> You may not upload videos that are officially hosted from university sites, the author's site, the Internet Archive, or the publisher's site. You may upload videos from other torrent sites as long as they conform to the rules in this section.</li>
				<li id="r7.3"><a href="#h7"><strong>&uarr;_</strong></a> <a href="#r7.3">7.3.</a> <strong>Tutorials on how to use musical instruments, vocal training, producing music, or otherwise learning the theory and practice of music are the only allowed topics.</strong> No material outside of these topics is allowed. For example, instruction videos about Kung Fu training, dance lessons, beer brewing, or photography are not permitted here. What is considered allowable under these topics is ultimately at the discretion of the staff.</li>
				<li id="r7.4"><a href="#h7"><strong>&uarr;_</strong></a> <a href="#r7.4">7.4.</a> <strong>eLearning Videos must be either in a video file format (.mkv, .avi, .mov, .mp4, etc.) or a disk image (.iso, .bin/.cue, etc.).</strong> Only one video file format and one disk image format are allowed per video. The same video in another file format or within another disk image type is a dupe. Torrents should not be uploaded in compressed archives. Such torrents will be removed when reported.</li>
				<li id="r7.5"><a href="#h7"><strong>&uarr;_</strong></a> <a href="#r7.5">7.5.</a> <strong>eLearning video uploads must contain an informative description and use proper <a href="?p=tag">Gazelle tags</a>.</strong> Uploads should include a proper description and/or a link to further information. Using the elearning.videos <a href="?p=tag">Gazelle tags</a> is strongly encouraged.</li>
			</ul>
		</div>
	</div>
<!-- END Other Sections -->
<? include('jump.php'); ?>
</div>
<?
View::show_footer();
?>
