/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.EventDispatcher;
import irc.ListenerGroup;
import irc.gui.sbox.AWTChanList;
import irc.gui.sbox.AWTChannel;
import irc.gui.sbox.AWTDCCChat;
import irc.gui.sbox.AWTDefaultSource;
import irc.gui.sbox.AWTQuery;
import irc.gui.sbox.AWTStatus;
import irc.gui.sbox.BaseAWTSource;
import irc.gui.sbox.BaseAWTSourceListener;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxPanel;
import irc.gui.sbox.SboxTaskBarListener;
import irc.gui.sbox.TaskBarItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class SboxTaskBar
extends SboxPanel
implements MouseListener,
MouseMotionListener,
BaseAWTSourceListener {
    public ListenerGroup _listeners;
    public TaskBarItem _active = null;
    public TaskBarItem _pressed = null;
    public Vector _items;
    public Font _font = new Font("", 0, 12);
    public Image _buffer;
    public int _iwidth;
    public int _ileft = 60;
    public int _zorder = 0;
    public boolean _handCursor = false;
    public int _overX = -1;
    public int _overY = -1;
    public int _maxWidth;
    public int _visibleItemCount = 0;
    public int _itemCount = 0;

    public SboxTaskBar(SboxConfiguration sboxConfiguration) {
        super(sboxConfiguration);
        this._listeners = new ListenerGroup();
        this._items = new Vector();
        this.computeWidth();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._maxWidth = sboxConfiguration.getI("taskbaritemwidth");
    }

    public void release() {
        this._buffer = null;
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        super.release();
    }

    public void addSboxTaskBarListener(SboxTaskBarListener sboxTaskBarListener) {
        this._listeners.addListener((Object)sboxTaskBarListener);
    }

    public void removeSboxTaskBarListener(SboxTaskBarListener sboxTaskBarListener) {
        this._listeners.removeListener((Object)sboxTaskBarListener);
    }

    public TaskBarItem findItem(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return null;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            if (((TaskBarItem)this._items.elementAt((int)i)).source != baseAWTSource) continue;
            return (TaskBarItem)this._items.elementAt(i);
        }
        return null;
    }

    public void removeFromVector(Vector vector, Object object) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) != object) continue;
            vector.removeElementAt(i);
        }
    }

    public void setBase(int n) {
    }

    public synchronized void enter(BaseAWTSource baseAWTSource, boolean bl) {
        ++this._visibleItemCount;
        TaskBarItem taskBarItem = new TaskBarItem(baseAWTSource, 0, this._visibleItemCount, bl);
        baseAWTSource.addBaseAWTSourceListener(this);
        this._items.insertElementAt(taskBarItem, this._items.size());
        ++this._itemCount;
        this._listeners.sendEvent("AWTSourceAdded", (Object)this, (Object)baseAWTSource);
        if (bl) {
            this.activate(baseAWTSource);
        }
        this._buffer = null;
        this.repaint();
    }

    public synchronized void leave(BaseAWTSource baseAWTSource) {
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        baseAWTSource.removeBaseAWTSourceListener(this);
        --this._itemCount;
        --this._visibleItemCount;
        boolean bl = this.getActive() == baseAWTSource;
        this.removeFromVector(this._items, taskBarItem);
        if (bl) {
            this.activate(null);
        }
        this._listeners.sendEvent("AWTSourceRemoved", (Object)this, (Object)baseAWTSource);
        this._buffer = null;
        this.repaint();
    }

    public int getCount() {
        return this._itemCount;
    }

    public void addChannel(AWTChannel aWTChannel, boolean bl) {
        this.enter(aWTChannel, bl);
    }

    public void removeChannel(AWTChannel aWTChannel) {
        this.leave(aWTChannel);
    }

    public void addStatus(AWTStatus aWTStatus, boolean bl) {
        this.enter(aWTStatus, bl);
    }

    public void removeStatus(AWTStatus aWTStatus) {
        this.leave(aWTStatus);
    }

    public void addDefaultSource(AWTDefaultSource aWTDefaultSource, boolean bl) {
        this.enter(aWTDefaultSource, bl);
    }

    public void removeDefaultSource(AWTDefaultSource aWTDefaultSource) {
        this.leave(aWTDefaultSource);
    }

    public void addQuery(AWTQuery aWTQuery, boolean bl) {
        this.enter(aWTQuery, bl);
    }

    public void removeQuery(AWTQuery aWTQuery) {
        this.leave(aWTQuery);
    }

    public void addChanList(AWTChanList aWTChanList, boolean bl) {
        this.enter(aWTChanList, bl);
    }

    public void removeChanList(AWTChanList aWTChanList) {
        this.leave(aWTChanList);
    }

    public void addDCCChat(AWTDCCChat aWTDCCChat, boolean bl) {
        this.enter(aWTDCCChat, bl);
    }

    public void removeDCCChat(AWTDCCChat aWTDCCChat) {
        this.leave(aWTDCCChat);
    }

    public BaseAWTSource findFirst() {
        TaskBarItem taskBarItem = null;
        int n = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            TaskBarItem taskBarItem2 = (TaskBarItem)this._items.elementAt(i);
            if (taskBarItem2.zorder <= n) continue;
            n = taskBarItem2.zorder;
            taskBarItem = taskBarItem2;
        }
        if (taskBarItem == null) {
            return null;
        }
        return taskBarItem.source;
    }

    public BaseAWTSource[] getZOrderedSources() {
        int n;
        TaskBarItem[] taskBarItemArray = new TaskBarItem[this._items.size()];
        for (n = 0; n < taskBarItemArray.length; ++n) {
            taskBarItemArray[n] = (TaskBarItem)this._items.elementAt(n);
        }
        for (n = 0; n < taskBarItemArray.length - 1; ++n) {
            TaskBarItem taskBarItem = taskBarItemArray[n];
            int n2 = taskBarItem.zorder;
            int n3 = n;
            for (int i = n + 1; i < taskBarItemArray.length; ++i) {
                taskBarItem = taskBarItemArray[i];
                if (taskBarItem.zorder <= n2) continue;
                n2 = taskBarItem.zorder;
                n3 = i;
            }
            TaskBarItem taskBarItem2 = taskBarItemArray[n];
            taskBarItemArray[n] = taskBarItemArray[n3];
            taskBarItemArray[n3] = taskBarItem2;
        }
        BaseAWTSource[] baseAWTSourceArray = new BaseAWTSource[taskBarItemArray.length];
        for (int i = 0; i < baseAWTSourceArray.length; ++i) {
            baseAWTSourceArray[i] = taskBarItemArray[i].source;
        }
        return baseAWTSourceArray;
    }

    public void show(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem.visible) {
            return;
        }
        taskBarItem.visible = true;
        ++this._visibleItemCount;
        this._buffer = null;
        this.repaint();
    }

    public void hide(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (!taskBarItem.visible) {
            return;
        }
        taskBarItem.visible = false;
        --this._visibleItemCount;
        this._buffer = null;
        this.repaint();
    }

    public void activate(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            baseAWTSource = this.findFirst();
        }
        if (baseAWTSource == null) {
            return;
        }
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem == this._active) {
            return;
        }
        if (!taskBarItem.visible) {
            return;
        }
        if (this._active != null) {
            this._listeners.sendEvent("AWTSourceDesactivated", (Object)this, (Object)this._active.source);
        }
        this._active = taskBarItem;
        if (this._active != null) {
            this._active.zorder = this._zorder++;
            this._active.eventWaiting = false;
            this._listeners.sendEvent("AWTSourceActivated", (Object)this, (Object)this._active.source);
        } else {
            this._listeners.sendEvent("AWTSourceActivated", (Object)this, null);
        }
        baseAWTSource.requestFocus();
        this._buffer = null;
        this.repaint();
    }

    public BaseAWTSource getActive() {
        if (this._active == null) {
            return null;
        }
        return this._active.source;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, this.getItemHeight() + 10);
    }

    public int getItemWidth() {
        return this._iwidth;
    }

    public int getItemHeight() {
        return this._font.getSize() + 4;
    }

    public synchronized void computeWidth() {
        int n = this.getSize().width - 63;
        int n2 = this._visibleItemCount;
        this._iwidth = n2 != 0 ? Math.min(this._maxWidth, (n -= 9 * n2) / n2) : this._maxWidth;
    }

    public int getX(int n) {
        return n * (this.getItemWidth() + 9) + this._ileft;
    }

    public int getCol(int n) {
        return (n - this._ileft) / (9 + this.getItemWidth());
    }

    public int getY(int n) {
        return 4 + (this.getItemHeight() + 8) * n;
    }

    public int getRow(int n) {
        return (n - 4) / (8 + this.getItemHeight());
    }

    public void drawItem(Graphics graphics, int n, int n2, Color color, String string) {
        int n3 = this.getX(n);
        int n4 = this.getY(n2);
        int n5 = this.getItemWidth();
        int n6 = this.getItemHeight();
        graphics.setClip(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
        graphics.setColor(color);
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(0));
        graphics.drawRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(1));
        graphics.drawRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        n4 += n6;
        int n7 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n3 + (n5 - n7) / 2, (n4 -= (n6 - this._font.getSize()) / 2) - 1);
        graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
    }

    public void drawItem(Graphics graphics, TaskBarItem taskBarItem, int n) {
        int n2 = taskBarItem.row;
        Color color = this.getColor(5);
        if (taskBarItem == this._active || taskBarItem == this._pressed) {
            color = this.getColor(7);
        }
        if (taskBarItem != this._active && taskBarItem.eventWaiting) {
            color = this.getColor(8);
        }
        this.drawItem(graphics, n++, n2, color, taskBarItem.source.getShortTitle());
    }

    public void update(Graphics graphics) {
        int n;
        int n2;
        Object object;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != n3 || this._buffer.getHeight(this) != n4)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            try {
                this._buffer = this.createImage(n3, n4);
                object = this._buffer.getGraphics();
            }
            catch (Throwable throwable) {
                return;
            }
            ((Graphics)object).setFont(new Font("", 0, 12));
            int n5 = 10;
            this._ileft = 25 + n5;
            this.computeWidth();
            ((Graphics)object).setColor(this.getColor(6));
            ((Graphics)object).fillRect(0, 0, n3, n4);
            n2 = 0;
            Enumeration enumeration = this._items.elements();
            while (enumeration.hasMoreElements()) {
                TaskBarItem taskBarItem = (TaskBarItem)enumeration.nextElement();
                if (!taskBarItem.visible) continue;
                this.drawItem((Graphics)object, taskBarItem, n2++);
                taskBarItem.col = n2;
            }
            ((Graphics)object).setColor(this.getColor(5));
            ((Graphics)object).fillRect(5, 6, n5 + 2, n4 - 12);
            for (n = 6; n < n4 / 2; ++n) {
                ((Graphics)object).drawLine(n5 + n, n, n5 + n, n4 / 2);
                ((Graphics)object).drawLine(n5 + n, n4 - n, n5 + n, n4 / 2);
            }
            ((Graphics)object).setColor(this.getColor(1));
            ((Graphics)object).drawLine(5, 6, 5, n4 - 6);
            ((Graphics)object).drawLine(5, 6, n5 + 5, 6);
            ((Graphics)object).drawLine(5, n4 - 6, n5 + 5, n4 - 6);
            ((Graphics)object).drawLine(n5 + 6, 6, n5 + 13, n4 / 2);
            ((Graphics)object).drawLine(n5 + 6, n4 - 6, n5 + 13, n4 / 2);
        }
        if (this._buffer != null) {
            graphics.drawImage(this._buffer, 0, 0, this);
        }
        if ((object = this.getItemAt(this._overX, this._overY)) != null) {
            String string = ((TaskBarItem)object).source.getShortTitle();
            n2 = graphics.getFontMetrics().stringWidth(string);
            int n6 = this.getX(this.getCol(this._overX)) + (this.getItemWidth() - n2) / 2 - 2;
            n = this.getY(this.getRow(this._overY)) - (this.getItemHeight() - this._font.getSize()) / 2 - 1;
            int n7 = this.getItemHeight();
            if (string.length() > 0 && n2 >= this.getItemWidth()) {
                if (n6 + n2 + 5 >= n3) {
                    n6 = n3 - n2 - 5;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                graphics.setColor(this.getAlphaColor(this.getColor(5), 200));
                graphics.fillRect(n6, n, n2 + 4, n7 + 4);
                graphics.setColor(this.getColor(1));
                graphics.drawRect(n6, n, n2 + 4, n7 + 4);
                graphics.drawString(string, n6 + 2, n + n7);
            }
        }
    }

    public Color getAlphaColor(Color color, int n) {
        try {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        catch (Throwable throwable) {
            return color;
        }
    }

    public TaskBarItem getItemAt(int n, int n2) {
        int n3;
        int n4 = this.getRow(n2);
        if ((n -= this.getX(n3 = this.getCol(n))) >= this.getItemWidth() || (n2 -= this.getY(n4)) >= this.getItemHeight()) {
            return null;
        }
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n5 = 0;
        Enumeration enumeration = this._items.elements();
        while (enumeration.hasMoreElements()) {
            TaskBarItem taskBarItem = (TaskBarItem)enumeration.nextElement();
            if (!taskBarItem.visible || taskBarItem.row != n4) continue;
            if (n5 == n3) {
                return taskBarItem;
            }
            ++n5;
        }
        return null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TaskBarItem taskBarItem;
        TaskBarItem taskBarItem2 = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        if (taskBarItem2 != null) {
            if (!this._handCursor) {
                this.setCursor(new Cursor(12));
                this._handCursor = true;
            }
        } else if (this._handCursor) {
            this.setCursor(new Cursor(0));
            this._handCursor = false;
        }
        if ((taskBarItem = this.getItemAt(this._overX, this._overY)) != taskBarItem2) {
            this._overX = mouseEvent.getX();
            this._overY = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TaskBarItem taskBarItem;
        this._pressed = taskBarItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        this._buffer = null;
        this.repaint();
        if (this._pressed != null) {
            this._listeners.sendEventAsync("eventOccured", (Object)this, (Object)this._pressed.source, (Object)mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._pressed = null;
        TaskBarItem taskBarItem = this.getItemAt(mouseEvent.getX(), mouseEvent.getY());
        try {
            if ((mouseEvent.getModifiers() & 0x10) != 0 && taskBarItem != null) {
                EventDispatcher.dispatchEventAsyncAndWaitEx((Object)this, (String)"activate", (Object[])new Object[]{taskBarItem.source});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._buffer = null;
        this.repaint();
    }

    public void titleChanged(BaseAWTSource baseAWTSource) {
        this._buffer = null;
        this.repaint();
    }

    public void eventOccured(BaseAWTSource baseAWTSource) {
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        if (taskBarItem == null) {
            return;
        }
        if (taskBarItem == this._active) {
            return;
        }
        taskBarItem.eventWaiting = true;
        this._buffer = null;
        this.repaint();
    }
}

