/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.IRCServer;
import irc.Query;
import irc.QueryListener;
import irc.ReplyServerListener;
import irc.Source;
import irc.gui.sbox.BaseAWTSource;
import irc.gui.sbox.NickMenuHandler;
import irc.gui.sbox.SboxConfiguration;
import irc.style.StyledList;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Locale;

public class AWTQuery
extends BaseAWTSource
implements QueryListener,
ReplyServerListener {
    private NickMenuHandler _menu;

    public AWTQuery(SboxConfiguration sboxConfiguration, Query query) {
        super(sboxConfiguration, (Source)query);
        this._menu = new NickMenuHandler(sboxConfiguration, this, (Source)query);
        query.addQueryListener((QueryListener)this);
        query.getIRCServer().addReplyServerListener((ReplyServerListener)this);
        this.update();
    }

    public void release() {
        ((Query)this._source).removeQueryListeners((QueryListener)this);
        ((Query)this._source).getIRCServer().removeReplyServerListener((ReplyServerListener)this);
        this._menu.release();
        this._menu = null;
        super.release();
    }

    private void update() {
        String string = ((Query)this._source).getWhois();
        String[] stringArray = new String[]{this._source.getName() + ":" + this._sboxConfiguration.getIRCConfiguration().formatASL(string), this._source.getServer().getNick() + ":" + this._sboxConfiguration.getIRCConfiguration().formatASL(this._source.getServer().getUserName())};
        this._list.setNickList(stringArray);
        this.title();
    }

    private void title() {
        String string = ((Query)this._source).getWhois();
        if (string.length() > 0) {
            this.setTitle(this._source.getName() + " (" + this._sboxConfiguration.getIRCConfiguration().formatASL(string) + ")");
        } else {
            this.setTitle(this._source.getName());
        }
    }

    public void nickChanged(String string, Query query) {
        this.update();
    }

    public void whoisChanged(String string, Query query) {
        this.update();
    }

    private String whois(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            return ((Query)this._source).getWhois();
        }
        if (string.equals(this._source.getServer().getNick().toLowerCase(Locale.ENGLISH))) {
            return this._source.getServer().getUserName();
        }
        return "";
    }

    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._sboxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, this.whois(string), (Component)this._list, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.nickEvent(styledList, string, mouseEvent);
        }
    }

    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        if (string2.equals("301") && stringArray[1].toLowerCase(Locale.ENGLISH).equals(this._source.getName().toLowerCase(Locale.ENGLISH))) {
            String string3 = this.getText(34322, stringArray[1]) + " :";
            for (int i = 2; i < stringArray.length; ++i) {
                string3 = string3 + " " + stringArray[i];
            }
            this._source.report(string3);
        }
        return Boolean.FALSE;
    }
}

