/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.ChanList;
import irc.ChanListListener;
import irc.ChannelInfo;
import irc.Source;
import irc.gui.sbox.BaseAWTSource;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxHorizontalScrollBar;
import irc.gui.sbox.SboxScrollBar;
import irc.style.StyledList;
import java.awt.Component;

public class AWTChanList
extends BaseAWTSource
implements ChanListListener {
    protected SboxHorizontalScrollBar _hscroll;

    public AWTChanList(SboxConfiguration sboxConfiguration, ChanList chanList) {
        super(sboxConfiguration, (Source)chanList, true);
        chanList.addChanListListener((ChanListListener)this);
        this._hscroll = new SboxHorizontalScrollBar(this._sboxConfiguration, 0, 0, 0.1);
        this._hscroll.addSboxScrollBarListener(this);
        this._list.setWrap(false);
        this.remove((Component)this._textField);
        this.add((Component)this._hscroll, "South");
        this.setTitle(this.getText(34307, this.getChanList().getName()));
        this._list.clear(1024);
    }

    public void release() {
        ((ChanList)this._source).removeChanListListeners((ChanListListener)this);
        this._hscroll.removeSboxScrollBarListener(this);
        this._hscroll.release();
        this._hscroll = null;
        super.release();
    }

    public String getShortTitle() {
        return this.getText(34580);
    }

    public void setFieldText(String string) {
    }

    public String getFieldText() {
        return "";
    }

    public void validateText() {
    }

    public ChanList getChanList() {
        return (ChanList)this.getSource();
    }

    public void channelBegin(ChanList chanList) {
        this.clear(this.getSource());
        this.print(this._sboxConfiguration.getText(34308));
        this._list.setFirst(0);
    }

    private void sort(ChannelInfo[] channelInfoArray, int n, int n2, int n3) {
        if (n3 < 50) {
            if (n < n2) {
                int n4 = (n + n2) / 2;
                ChannelInfo channelInfo = channelInfoArray[n4];
                channelInfoArray[n4] = channelInfoArray[n];
                channelInfoArray[n] = channelInfo;
                int n5 = n;
                ChannelInfo channelInfo2 = channelInfoArray[n5];
                for (int i = n; i <= n2; ++i) {
                    if (channelInfoArray[i].userCount <= channelInfo2.userCount) continue;
                    channelInfo = channelInfoArray[++n5];
                    channelInfoArray[n5] = channelInfoArray[i];
                    channelInfoArray[i] = channelInfo;
                }
                channelInfo = channelInfoArray[n5];
                channelInfoArray[n5] = channelInfoArray[n];
                channelInfoArray[n] = channelInfo;
                this.sort(channelInfoArray, n, n5 - 1, n3 + 1);
                this.sort(channelInfoArray, n5 + 1, n2, n3 + 1);
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                ChannelInfo channelInfo = channelInfoArray[i];
                int n6 = i;
                int n7 = channelInfo.userCount;
                for (int j = i + 1; j <= n2; ++j) {
                    if (channelInfoArray[j].userCount <= n7) continue;
                    channelInfo = channelInfoArray[j];
                    n6 = j;
                    n7 = channelInfo.userCount;
                }
                ChannelInfo channelInfo3 = channelInfoArray[i];
                channelInfoArray[i] = channelInfoArray[n6];
                channelInfoArray[n6] = channelInfo3;
            }
        }
    }

    private void sort(ChannelInfo[] channelInfoArray) {
        this.sort(channelInfoArray, 0, channelInfoArray.length - 1, 0);
    }

    public void channelEnd(ChanList chanList) {
        ChannelInfo[] channelInfoArray = this.getChanList().getChannels();
        this.sort(channelInfoArray);
        int n = channelInfoArray.length;
        if (n > 1024) {
            n = 1024;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.format(channelInfoArray[i]);
        }
        this.clear(this.getSource());
        this._list.addLines(stringArray);
        this._list.setFirst(0);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
    }

    private String format(ChannelInfo channelInfo) {
        int n;
        String string = channelInfo.name;
        String string2 = "" + channelInfo.userCount;
        for (n = 0; n < 20 - channelInfo.name.length(); ++n) {
            string = string + " ";
        }
        string = string + "   " + channelInfo.userCount;
        for (n = 0; n < 5 - string2.length(); ++n) {
            string = string + " ";
        }
        string = string + "   " + channelInfo.topic;
        return string;
    }

    public void channelAdded(ChannelInfo channelInfo, ChanList chanList) {
        int n = this.getChanList().getChannelCount();
        int n2 = this.getChanList().getIgnoredChannelCount() + n;
        if (n2 % 100 == 0) {
            this.clear(this.getSource());
            this.print(this._sboxConfiguration.getText(34308) + " (" + n + "/" + n2 + ")");
            this._list.setFirst(0);
        }
    }

    public void valueChanged(SboxScrollBar sboxScrollBar) {
        if (sboxScrollBar == this._hscroll) {
            this._list.setLeft(this._hscroll.getValue() * 10);
        } else {
            super.valueChanged(sboxScrollBar);
        }
    }

    public void virtualSizeChanged(StyledList styledList) {
        this._hscroll.setMaximum(this._list.getLogicalWidth() / 10);
        super.virtualSizeChanged(styledList);
    }
}

