/*
 * Decompiled with CFR 0.152.
 */
package irc.dcc;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.Source;
import irc.dcc.DCCFileListener;
import irc.dcc.prv.DCCFileHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DCCFile
extends Source {
    private OutputStream _os;
    private InputStream _is;
    private File _file;
    private ListenerGroup _listeners = new ListenerGroup();
    private boolean _down = false;
    private int _size;
    private int _count;
    private DCCFileHandler _handler;

    public DCCFile(IRCConfiguration iRCConfiguration, File file, DCCFileHandler dCCFileHandler) {
        super(iRCConfiguration, dCCFileHandler);
        this._handler = dCCFileHandler;
        this._count = 0;
        this._file = file;
    }

    public void addDCCFileListener(DCCFileListener dCCFileListener) {
        this._listeners.addListener(dCCFileListener);
    }

    public void removeDCCFileListener(DCCFileListener dCCFileListener) {
        this._listeners.removeListener(dCCFileListener);
    }

    public void prepareSend() {
        try {
            this._size = this._ircConfiguration.getSecurityProvider().getFileSize(this._file);
            this._is = new BufferedInputStream(this._ircConfiguration.getSecurityProvider().getFileInputStream(this._file));
            this._down = false;
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("prepareSend failure", exception, "plouf@pjirc.com");
        }
    }

    public int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this._is.read(byArray, n, n2);
        if (n3 >= 0) {
            this._count += n3;
            this._listeners.sendEventAsync("transmitted", new Integer(this._count), this);
        }
        return n3;
    }

    public int getSize() {
        return this._size;
    }

    public boolean isUploading() {
        return !this.isDownloading();
    }

    public boolean isDownloading() {
        return this._down;
    }

    public void fileSent() {
        try {
            this._listeners.sendEventAsync("finished", this);
            this._is.close();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("fileSent failure", exception, "plouf@pjirc.com");
        }
    }

    public void fileSentFailed() {
        try {
            this._listeners.sendEventAsync("failed", this);
            this._is.close();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("fileSentFailed failure", exception, "plouf@pjirc.com");
        }
    }

    public void prepareReceive(int n) {
        this._down = true;
        this._size = n;
        try {
            this._os = new BufferedOutputStream(this._ircConfiguration.getSecurityProvider().getFileOutputStream(this._file));
        }
        catch (Exception exception) {
            this._os = null;
        }
    }

    public void bytesReceived(byte[] byArray, int n, int n2) throws IOException {
        this._count += n2;
        this._os.write(byArray, n, n2);
        this._listeners.sendEventAsync("transmitted", new Integer(this._count), this);
    }

    public void fileReceived() {
        try {
            this._listeners.sendEventAsync("finished", this);
            this._os.close();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("fileReceived failure", exception, "plouf@pjirc.com");
        }
    }

    public void fileReceiveFailed() {
        try {
            this._listeners.sendEventAsync("failed", this);
            this._os.close();
        }
        catch (Exception exception) {
            this._ircConfiguration.internalError("fileReceiveFailed failure", exception, "plouf@pjirc.com");
        }
    }

    public String getName() {
        return this._file.getName();
    }

    public void leave() {
        this._handler.close();
        this._handler.leave();
    }

    public boolean talkable() {
        return false;
    }

    public String getType() {
        return "DCCFile";
    }
}

