/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.MyPushbackStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CodingHandler
extends IRCObject {
    private MyPushbackStream _is;
    private OutputStream _os;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private int _coding;
    public static final int CODING_ASCII = 0;
    public static final int CODING_PUAP = 1;
    public static final int CODING_UTF_8 = 2;
    public static final int CODING_LOCAL_CHARSET = 3;

    public CodingHandler(IRCConfiguration iRCConfiguration, InputStream inputStream, OutputStream outputStream) {
        super(iRCConfiguration);
        this._coding = iRCConfiguration.getI("coding");
        if (this._coding != 3) {
            this._is = new MyPushbackStream(inputStream);
            this._os = outputStream;
            this._reader = null;
            this._writer = null;
        } else {
            this._is = null;
            this._os = null;
            this._reader = new BufferedReader(new InputStreamReader(inputStream));
            this._writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    public void close() throws IOException {
        if (this._is != null) {
            this._is.close();
        }
        if (this._os != null) {
            this._os.close();
        }
        if (this._reader != null) {
            this._reader.close();
        }
        if (this._writer != null) {
            this._writer.close();
        }
        this._is = null;
        this._os = null;
        this._reader = null;
        this._writer = null;
    }

    public String read() throws IOException {
        if (this._coding != 3) {
            String string = this.readUTF();
            return CodingHandler.asciiToWide(string);
        }
        return this._reader.readLine();
    }

    public void write(String string) throws IOException {
        if (this._coding == 0) {
            this.writeASCII(string);
        } else if (this._coding == 1) {
            this.writePUAP(string);
        } else if (this._coding == 2) {
            this.writeUTF(string);
        } else if (this._coding == 3) {
            this.writeCHARSET(string);
        } else {
            this.writePUAP(string);
        }
        if (this._os != null) {
            this._os.flush();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    private void writeCHARSET(String string) throws IOException {
        this._writer.write(string, 0, string.length());
        this._writer.newLine();
    }

    private void writeASCII(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this._os.write((byte)string.charAt(i));
        }
        this._os.write(13);
        this._os.write(10);
    }

    private void writePUAP(String string) throws IOException {
        this.writeASCII(CodingHandler.wideToAscii(string));
    }

    private String readUTF() throws IOException {
        String string = "";
        String string2 = "";
        boolean bl = true;
        char c = '\u0000';
        int n = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n2 = this._is.read();
            if ((n2 == 10 || n2 == 13) && string2.length() == 0) continue;
            if (n2 == -1) {
                if (string2.length() == 0) {
                    throw new IOException("EOF reached");
                }
                if (n != 0) {
                    bl = false;
                }
                if (bl) {
                    return string;
                }
                return string2;
            }
            if (n2 == 10 || n2 == 13) {
                if (n != 0) {
                    bl = false;
                }
                if (this._is.available() >= 1) {
                    n2 = this._is.read();
                }
                if (n2 != 10 && n2 != 13) {
                    this._is.unread((byte)n2);
                }
                if (bl) {
                    return string;
                }
                return string2;
            }
            string2 = string2 + (char)n2;
            if (!bl) continue;
            if (n2 < 128) {
                if (n != 0) {
                    bl = false;
                    continue;
                }
                string = string + (char)n2;
                continue;
            }
            if (n2 < 192) {
                if (n == 0) {
                    bl = false;
                    continue;
                }
                c = (char)(c << 6 | n2 - 128 & 0x3F);
                if (--n != 0) continue;
                string = string + c;
                c = '\u0000';
                continue;
            }
            if (n2 < 224) {
                if (n != 0) {
                    bl = false;
                    continue;
                }
                n = 1;
                c = (char)(n2 - 192);
                continue;
            }
            if (n != 0) {
                bl = false;
                continue;
            }
            n = 2;
            c = (char)(n2 - 224);
        }
        return null;
    }

    private void writeUTF(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u007f') {
                this._os.write((byte)c);
                continue;
            }
            if (c < '\u07ff') {
                this._os.write((byte)(192 + (c >> 6)));
                this._os.write((byte)(128 + (c & 0x3F)));
                continue;
            }
            this._os.write((byte)(224 + (c >> 12)));
            this._os.write((byte)(128 + (c >> 6 & 0x3F)));
            this._os.write((byte)(128 + (c & 0x3F)));
        }
        this._os.write(10);
        this._os.write(13);
    }

    private static String asciiToWide(String string) {
        try {
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\u001e') {
                    String string3 = string.substring(i + 1, i + 5);
                    i += 4;
                    int n = Integer.parseInt(string3, 16);
                    string2 = string2 + (char)n;
                    continue;
                }
                string2 = string2 + string.charAt(i);
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String wideToAscii(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                string2 = string2 + '\u001e';
                String string3 = Integer.toHexString(c);
                while (string3.length() < 4) {
                    string3 = "0" + string3;
                }
                string2 = string2 + string3;
                continue;
            }
            string2 = string2 + (char)c;
        }
        return string2;
    }
}

