/*
 * Decompiled with CFR 0.152.
 */
package irc.security;

import irc.EventDispatcher;
import irc.security.DefaultSecuredProvider;
import irc.security.SecuredProvider;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SecurityProvider
implements ActionListener {
    private SecuredProvider _provider;
    private boolean _answer;

    public SecurityProvider() {
        if (this.tryProvider("MS")) {
            return;
        }
        this._provider = new DefaultSecuredProvider();
    }

    private boolean tryProvider(String string) {
        SecuredProvider securedProvider = this._provider;
        try {
            Class<?> clazz = Class.forName("irc.security.prv.Specific" + string + "SecuredProvider");
            this._provider = (SecuredProvider)clazz.newInstance();
            if (!this._provider.tryProvider()) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception exception) {
            this._provider = securedProvider;
            return false;
        }
    }

    public String getProviderName() {
        return this._provider.getName();
    }

    public Socket getSocket(String string, int n) throws UnknownHostException, IOException {
        try {
            Socket socket = (Socket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSocket", new Object[]{string, new Integer(n)});
            return socket;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    public ServerSocket getServerSocket(int n) throws IOException {
        try {
            return (ServerSocket)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getServerSocket", new Object[]{new Integer(n)});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getClass().getName() + " : " + throwable.getMessage());
        }
    }

    public boolean confirm(Frame frame, String string, String string2) {
        Dialog dialog;
        Frame frame2 = null;
        if (frame == null) {
            frame2 = new Frame();
            dialog = new Dialog(frame2, string, true);
        } else {
            dialog = new Dialog(frame, string, true);
        }
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)new Label(string2), "Center");
        Button button = new Button("Yes");
        Button button2 = new Button("No");
        Panel panel = new Panel();
        dialog.setResizable(false);
        dialog.add((Component)panel, "South");
        panel.add(button);
        panel.add(button2);
        button.addActionListener(this);
        button2.addActionListener(this);
        dialog.pack();
        this._answer = false;
        dialog.show();
        button.removeActionListener(this);
        button2.removeActionListener(this);
        dialog.hide();
        dialog.dispose();
        dialog = null;
        if (frame2 != null) {
            frame2.hide();
            frame2.dispose();
            frame2 = null;
        }
        return this._answer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        this._answer = false;
        if (button.getLabel().equals("Yes")) {
            this._answer = true;
        }
        ((Window)button.getParent().getParent()).hide();
    }

    public FileInputStream getFileInputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file read action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileInputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileInputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public FileOutputStream getFileOutputStream(File file) throws IOException {
        if (!this.confirm(null, "Security warning", "Authorize file write action on " + file + "?")) {
            throw new IOException("User denied access");
        }
        try {
            return (FileOutputStream)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileOutputStream", new Object[]{file});
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.getMessage());
        }
    }

    public int getFileSize(File file) {
        try {
            return (Integer)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getFileSize", new Object[]{file});
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public File getLoadFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLoadFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{string});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public File getSaveFile(String string, String string2) {
        try {
            return (File)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getSaveFile", new Object[]{string, string2});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public InetAddress getLocalHost() throws UnknownHostException {
        try {
            return (InetAddress)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "getLocalHost", new Object[0]);
        }
        catch (InterruptedException interruptedException) {
            throw new UnknownHostException("Unable to resolve");
        }
        catch (Throwable throwable) {
            throw new UnknownHostException(throwable.getMessage());
        }
    }

    public String resolve(InetAddress inetAddress) {
        try {
            return (String)EventDispatcher.dispatchEventAsyncAndWaitExSecurity(this._provider, "resolve", new Object[]{inetAddress});
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

