/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.Interpretor;
import irc.ListenerGroup;
import irc.NullInterpretor;
import irc.Server;
import irc.SourceListener;
import java.util.Locale;

public abstract class Source
extends IRCObject {
    protected Server _server;
    private ListenerGroup _listeners = new ListenerGroup();
    protected Interpretor _in;

    public Source(IRCConfiguration iRCConfiguration, Server server) {
        super(iRCConfiguration);
        this._in = new NullInterpretor(iRCConfiguration);
        this._server = server;
    }

    public void release() {
        this._in = new NullInterpretor(this._ircConfiguration);
        super.release();
    }

    public abstract String getName();

    public abstract String getType();

    public abstract boolean talkable();

    public abstract void leave();

    public void setInterpretor(Interpretor interpretor) {
        this._in = interpretor;
    }

    public void sendString(String string) {
        this._in.sendString(this, string);
    }

    public void sendUserString(String string) {
        if (!string.startsWith("/")) {
            this.sendString(string);
        } else {
            String string2 = string.substring(1).trim();
            int n = string2.indexOf(32);
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if (this._ircConfiguration.mayCommand(string2)) {
                this.sendString(string);
            }
        }
    }

    public Interpretor getInterpretor() {
        return this._in;
    }

    public void clear() {
        this._listeners.sendEvent("clear", this);
    }

    public void messageReceived(String string, String string2) {
        if (string2.startsWith("\u0001")) {
            string2 = string2.substring(1);
            string2 = string2.substring(0, string2.length() - 1);
            String string3 = "";
            String string4 = "";
            int n = string2.indexOf(32);
            if (n == -1) {
                string3 = string2.toLowerCase(Locale.ENGLISH);
            } else {
                string3 = string2.substring(0, n).toLowerCase(Locale.ENGLISH);
                string4 = string2.substring(n + 1);
            }
            if (string3.equals("action")) {
                this.action(string, string4);
            } else {
                this.getServer().sendStatusMessage("\u0002\u00034[" + string + " " + string3.toUpperCase(Locale.ENGLISH) + "]");
            }
        } else {
            this._listeners.sendEvent("messageReceived", string, string2, this);
        }
    }

    public void noticeReceived(String string, String string2) {
        this._listeners.sendEvent("noticeReceived", string, string2, this);
    }

    public void action(String string, String string2) {
        this._listeners.sendEvent("action", string, string2, this);
    }

    public void report(String string) {
        this._listeners.sendEvent("reportReceived", string, this);
    }

    public void addSourceListener(SourceListener sourceListener) {
        this._listeners.addListener(sourceListener);
    }

    public void removeSourceListener(SourceListener sourceListener) {
        this._listeners.removeListener(sourceListener);
    }

    public Server getServer() {
        return this._server;
    }

    public boolean mayDefault() {
        return true;
    }
}

