/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.ReplyServerListener;
import irc.Source;
import irc.StatusInterpretor;
import irc.StatusListener;
import java.util.Date;

public class Status
extends IRCSource
implements ReplyServerListener {
    private ListenerGroup _listeners;

    public Status(IRCConfiguration iRCConfiguration, IRCServer iRCServer) {
        super(iRCConfiguration, iRCServer);
        iRCServer.addReplyServerListener(this);
        this._listeners = new ListenerGroup();
        this.setInterpretor(new StatusInterpretor(iRCConfiguration));
    }

    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public String getType() {
        return "Status";
    }

    public String getName() {
        return this.getServerName();
    }

    public String getServerName() {
        return this.getIRCServer().getServerName();
    }

    public boolean talkable() {
        return false;
    }

    public void leave() {
        if (!this._ircConfiguration.getB("multiserver")) {
            return;
        }
        this.getIRCServer().leaveStatus(this.getName());
    }

    public String getNick() {
        return this._server.getNick();
    }

    public String getMode() {
        return this.getIRCServer().getMode();
    }

    public void addStatusListener(StatusListener statusListener) {
        this._listeners.addListener(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this._listeners.removeListener(statusListener);
    }

    public void nickChanged(String string) {
        this._listeners.sendEvent("nickChanged", string, this);
    }

    public void modeChanged(String string) {
        this._listeners.sendEvent("modeChanged", string, this);
    }

    public void invited(String string, String string2) {
        this._listeners.sendEvent("invited", string, string2, this);
    }

    public Boolean replyReceived(String string, String string2, String[] stringArray, IRCServer iRCServer) {
        int n;
        if (string2.equals("322")) {
            return Boolean.FALSE;
        }
        if (this._ircConfiguration.getB("useinfo") && (n = new Integer(string2).intValue()) >= 300 && n != 372) {
            return Boolean.FALSE;
        }
        if (string2.equals("401")) {
            Source source = this.getIRCServer().getDefaultSource();
            String string3 = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string3 = string3 + " " + stringArray[i];
            }
            string3 = string3.substring(1);
            if (source != null) {
                source.report(string3);
            }
        } else if (string2.equals("317")) {
            if (stringArray.length > 3) {
                String string4 = stringArray[2];
                long l = Long.parseLong(string4);
                long l2 = l % 60L;
                long l3 = l / 60L % 60L;
                long l4 = l / 3600L % 24L;
                long l5 = l / 86400L % 7L;
                long l6 = l / 604800L;
                String string5 = "";
                if (l > 604800L) {
                    string5 = string5 + l6 + " weeks ";
                }
                if (l > 86400L) {
                    string5 = string5 + l5 + " days ";
                }
                if (l > 3600L) {
                    string5 = string5 + l4 + " hours ";
                }
                if (l > 60L) {
                    string5 = string5 + l3 + " minutes ";
                }
                string5 = string5 + l2 + " seconds";
                string5 = string5.trim();
                String string6 = new Date(1000L * Long.parseLong(stringArray[3])).toString();
                this.report(this._ircConfiguration.getText(2305, stringArray[1], string5));
                this.report(this._ircConfiguration.getText(2306, stringArray[1], string6));
            }
        } else {
            String string7 = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string7 = string7 + " " + stringArray[i];
            }
            string7 = string7.substring(1);
            this.report(string7);
        }
        return Boolean.FALSE;
    }
}

