/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.IRCConfiguration;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.ServerManager;
import irc.Source;
import irc.dcc.prv.DCCChatServer;
import irc.dcc.prv.DCCFileHandler;
import java.io.File;
import java.util.Date;
import java.util.Locale;

public class CTCPInterpretor
extends BasicInterpretor {
    protected ServerManager _mgr;

    public CTCPInterpretor(IRCConfiguration iRCConfiguration, Interpretor interpretor, ServerManager serverManager) {
        super(iRCConfiguration, interpretor);
        this._mgr = serverManager;
    }

    private void send(Server server, String string, String string2) {
        server.say(string, "\u0001" + string2 + "\u0001");
    }

    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        try {
            if (string.equals("ctcp")) {
                this.test(string, stringArray, 1);
                if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("ping")) {
                    this.test(string, stringArray, 2);
                    this.send(source.getServer(), stringArray[2], "PING " + new Date().getTime());
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("action")) {
                    this.test(string, stringArray, 2);
                    if (source.talkable()) {
                        this.send(source.getServer(), source.getName(), "ACTION " + stringArray2[2]);
                        source.action(source.getServer().getNick(), stringArray2[2]);
                    } else {
                        source.report(this.getText(1));
                    }
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("dcc")) {
                    this.test(string, stringArray, 2);
                    if (stringArray[2].toLowerCase(Locale.ENGLISH).equals("chat") && this._ircConfiguration.getB("allowdccchat")) {
                        this.test(string, stringArray, 3);
                        Server server = source.getServer();
                        String string2 = stringArray[3];
                        try {
                            DCCChatServer dCCChatServer = new DCCChatServer(this._ircConfiguration, server.getNick(), string2);
                            String string3 = dCCChatServer.openPassive();
                            if (string3.length() == 0) {
                                dCCChatServer.sendStatusMessage(this.getText(265));
                            } else {
                                this.send(server, string2, "DCC CHAT chat " + string3);
                            }
                            this._mgr.newServer(dCCChatServer, false);
                        }
                        catch (Throwable throwable) {
                            this._ircConfiguration.internalError("dcc chat error", throwable, "plouf@pjirc.com");
                        }
                    } else if (stringArray[2].toLowerCase(Locale.ENGLISH).equals("send") && this._ircConfiguration.getB("allowdccfile")) {
                        String string4 = null;
                        this.test(string, stringArray, 3);
                        if (stringArray.length > 4) {
                            string4 = stringArray2[4];
                        }
                        Server server = source.getServer();
                        String string5 = stringArray[3];
                        try {
                            File file = string4 != null ? new File(string4) : this._ircConfiguration.getSecurityProvider().getLoadFile("Send file");
                            DCCFileHandler dCCFileHandler = new DCCFileHandler(this._ircConfiguration, string5, file);
                            char c = '\"';
                            String string6 = file.getName();
                            if (string6.indexOf(" ") != -1) {
                                string6 = c + string6 + c;
                            }
                            String string7 = string6 + " " + dCCFileHandler.send();
                            this.send(server, string5, "DCC SEND " + string7);
                            this._mgr.newServer(dCCFileHandler, false);
                        }
                        catch (Throwable throwable) {
                            this._ircConfiguration.internalError("dcc send error", throwable, "plouf@pjirc.com");
                        }
                    } else {
                        source.report(this.getText(2, stringArray[2]));
                    }
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("raw")) {
                    this.test(string, stringArray, 3);
                    this.send(source.getServer(), stringArray[2], stringArray2[3]);
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("sound")) {
                    this.test(string, stringArray, 2);
                    this.send(source.getServer(), source.getName(), "SOUND " + stringArray[2]);
                } else {
                    this.test(string, stringArray, 2);
                    this.send(source.getServer(), stringArray[2], stringArray[1]);
                }
            } else {
                super.handleCommand(source, string, stringArray, stringArray2);
            }
        }
        catch (NotEnoughParametersException notEnoughParametersException) {
            source.report(this.getText(3, notEnoughParametersException.getMessage()));
        }
    }
}

