/*
 * Decompiled with CFR 0.152.
 */
package irc.tree;

import irc.tree.Comparator;
import irc.tree.TreeTraversalListener;
import java.util.Vector;

class TreeNode {
    public TreeNode left;
    public TreeNode right;
    public Vector objects;
    private Comparator _comparator;

    public TreeNode(Object object, Comparator comparator) {
        this._comparator = comparator;
        this.objects = new Vector(1, 0);
        this.objects.insertElementAt(object, this.objects.size());
        this.left = new TreeNode(comparator);
        this.right = new TreeNode(comparator);
    }

    public TreeNode(Comparator comparator) {
        this._comparator = comparator;
        this.objects = new Vector(1, 0);
        this.left = null;
        this.right = null;
    }

    public boolean external() {
        return this.left == null || this.right == null;
    }

    public TreeNode remove(Object object) throws Exception {
        if (this.external()) {
            throw new Exception();
        }
        int n = this._comparator.compare(object, this.objects.elementAt(0));
        if (n == 0) {
            this.objects.removeElement(object);
            if (this.objects.size() == 0) {
                if (this.left.external()) {
                    return this.right;
                }
                if (this.right.external()) {
                    return this.left;
                }
                return this.right.addTree(this.left);
            }
            return this;
        }
        if (n < 0) {
            this.left = this.left.remove(object);
            return this;
        }
        this.right = this.right.remove(object);
        return this;
    }

    private TreeNode addTree(TreeNode treeNode) throws Exception {
        if (this.external()) {
            return treeNode;
        }
        if (treeNode.external()) {
            return this;
        }
        int n = this._comparator.compare(treeNode.objects.elementAt(0), this.objects.elementAt(0));
        if (n == 0) {
            throw new Exception();
        }
        if (n < 0) {
            this.left = this.left.addTree(treeNode);
            return this;
        }
        this.right = this.right.addTree(treeNode);
        return this;
    }

    public TreeNode add(Object object) throws Exception {
        if (this.external()) {
            return new TreeNode(object, this._comparator);
        }
        int n = this._comparator.compare(object, this.objects.elementAt(0));
        if (n == 0) {
            this.objects.insertElementAt(object, this.objects.size());
            return this;
        }
        if (n < 0) {
            this.left = this.left.add(object);
            return this;
        }
        this.right = this.right.add(object);
        return this;
    }

    public void inorder(TreeTraversalListener treeTraversalListener, Object object) {
        if (this.external()) {
            return;
        }
        this.left.inorder(treeTraversalListener, object);
        for (int i = 0; i < this.objects.size(); ++i) {
            treeTraversalListener.nextItem(this.objects.elementAt(i), object);
        }
        this.right.inorder(treeTraversalListener, object);
    }
}

