/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxNickList;
import irc.gui.sbox.SboxNickListListener;
import irc.gui.sbox.SboxPanel;
import irc.gui.sbox.SboxScrollBar;
import irc.gui.sbox.SboxScrollBarListener;
import irc.gui.sbox.SboxSeparator;
import irc.gui.sbox.SboxVerticalScrollBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;

public class ScrollableSboxNickList
extends SboxPanel
implements SboxScrollBarListener {
    private SboxNickList _list;
    private SboxVerticalScrollBar _scroll;

    public ScrollableSboxNickList(SboxConfiguration sboxConfiguration, char[] cArray) {
        super(sboxConfiguration);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this._list = new SboxNickList(sboxConfiguration, cArray);
        this._scroll = new SboxVerticalScrollBar(sboxConfiguration, 0, 0, 0.1);
        this._scroll.addSboxScrollBarListener(this);
        panel.add((Component)this._list, "Center");
        panel.add((Component)this._scroll, "East");
        this.add((Component)panel, "Center");
        this.add((Component)new SboxSeparator(2), "West");
        this.add((Component)new SboxSeparator(3), "East");
        this.add((Component)new SboxSeparator(0), "North");
        this.add((Component)new SboxSeparator(1), "South");
    }

    public void release() {
        this._scroll.removeSboxScrollBarListener(this);
        this._list.release();
        this._scroll.release();
        this._list = null;
        this._scroll = null;
        super.release();
    }

    public void addSboxNickListListener(SboxNickListListener sboxNickListListener) {
        this._list.addSboxNickListListener(sboxNickListListener);
    }

    public void removeSboxNickListListener(SboxNickListListener sboxNickListListener) {
        this._list.removeSboxNickListListener(sboxNickListListener);
    }

    public void set(String[] stringArray) {
        this._list.set(stringArray);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void add(String string) {
        this._list.add(string);
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void removeAll() {
        this._list.removeAll();
        this._scroll.setMaximum(this._list.getNickCount() - 1);
    }

    public void valueChanged(SboxScrollBar sboxScrollBar) {
        this._list.setBase(sboxScrollBar.getValue());
    }

    public void dispose() {
        this._list.dispose();
    }
}

