/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.StyleContext;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxMenuBarListener;
import irc.gui.sbox.SboxPanel;
import irc.style.DecodedLine;
import irc.style.DrawResult;
import irc.style.FormattedStringDrawer;
import irc.style.FormattedStringDrawerListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class SboxMenuBar
extends SboxPanel
implements MouseListener,
MouseMotionListener,
Runnable,
FormattedStringDrawerListener {
    private int _pressedIndex;
    private boolean _closePressed;
    private boolean _dockPressed;
    private ListenerGroup _listeners;
    private boolean _connected;
    private boolean _title;
    private Image _buffer;
    private FormattedStringDrawer _drawer;
    private String _titleString;
    private DecodedLine _decodedTitle;
    private int _connectIndex;
    private int _chanlistIndex;
    private int _aboutIndex;
    private int _helpIndex;
    private int _titleLeft = 0;
    private int _mouseDownX;
    private boolean _mouseScroll;
    private DrawResult _drawResult;
    private boolean _terminated;
    private boolean _redrawTitle;
    private Thread _scrollThread;
    private Object _scrollLock;
    private boolean _freeze;
    private int _scrollDelay;

    public SboxMenuBar(SboxConfiguration sboxConfiguration) {
        this(sboxConfiguration, false);
    }

    public SboxMenuBar(SboxConfiguration sboxConfiguration, boolean bl) {
        super(sboxConfiguration);
        this._title = bl;
        this._mouseScroll = false;
        this._titleString = "";
        IRCConfiguration iRCConfiguration = sboxConfiguration.getIRCConfiguration();
        this._drawer = new FormattedStringDrawer(iRCConfiguration, iRCConfiguration.getDefaultStyleContext(), (FormattedStringDrawerListener)this);
        this._decodedTitle = this._drawer.decodeLine(this._titleString);
        this._connected = false;
        this._pressedIndex = -1;
        this._closePressed = false;
        this._dockPressed = false;
        this._listeners = new ListenerGroup();
        int n = 0;
        if (sboxConfiguration.getB("showconnect")) {
            this._connectIndex = n++;
        }
        if (sboxConfiguration.getB("showchanlist")) {
            this._chanlistIndex = n++;
        }
        if (sboxConfiguration.getB("showabout")) {
            this._aboutIndex = n++;
        }
        if (sboxConfiguration.getB("showhelp")) {
            this._helpIndex = n++;
        }
        this._scrollDelay = sboxConfiguration.getI("scrollspeed");
        if (this._scrollDelay != 0) {
            this._scrollDelay = 1000 / this._scrollDelay;
        }
        this._drawResult = new DrawResult();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._terminated = false;
        this._redrawTitle = false;
        this._scrollLock = new Object();
        if (this._scrollDelay > 0) {
            this._scrollThread = new Thread(this);
            this._scrollThread.start();
        }
    }

    public void release() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void setTitle(String string, StyleContext styleContext) {
        this._drawer.setStyleContext(styleContext);
        this._titleString = string;
        this._decodedTitle = this._drawer.decodeLine(this._titleString);
        this._buffer = null;
        this.repaint();
    }

    public void addSboxMenuBarListener(SboxMenuBarListener sboxMenuBarListener) {
        this._listeners.addListener((Object)sboxMenuBarListener);
    }

    public void removeSboxMenuBarListener(SboxMenuBarListener sboxMenuBarListener) {
        this._listeners.removeListener((Object)sboxMenuBarListener);
    }

    public void setConnected(boolean bl) {
        this._connected = bl;
        this._buffer = null;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this._title) {
            return new Dimension(16, this.getItemHeight() + this.getTitleHeight() + 4);
        }
        return new Dimension(16, this.getItemHeight() + 4);
    }

    private int getClosePositionX() {
        int n = this.getSize().width;
        return n - 18;
    }

    private int getClosePositionY() {
        return this.getY(0) + 1;
    }

    private int getDockPositionX() {
        int n = this.getSize().width;
        if (!this._sboxConfiguration.getB("showclose")) {
            return n - 18;
        }
        return n - 18 - 18;
    }

    private int getDockPositionY() {
        return this.getY(0) + 1;
    }

    private boolean isClosePressed(int n, int n2) {
        if (!this._sboxConfiguration.getB("showclose")) {
            return false;
        }
        if ((n -= this.getClosePositionX()) < 0) {
            return false;
        }
        if (n >= 16) {
            return false;
        }
        if ((n2 -= this.getClosePositionY()) < 0) {
            return false;
        }
        return n2 < 16;
    }

    private boolean isDockPressed(int n, int n2) {
        if (!this._sboxConfiguration.getB("showdock")) {
            return false;
        }
        if ((n -= this.getDockPositionX()) < 0) {
            return false;
        }
        if (n >= 16) {
            return false;
        }
        if ((n2 -= this.getDockPositionY()) < 0) {
            return false;
        }
        return n2 < 16;
    }

    private int getItemWidth() {
        return 100;
    }

    private int getItemHeight() {
        return 17;
    }

    private int getIconWidth() {
        return 16;
    }

    private int getIconHeight() {
        return this.getItemHeight() - 4;
    }

    private int getX(int n) {
        return n * (this.getItemWidth() + 8) + 2;
    }

    private int getPos(int n) {
        return (n - 2) / (this.getItemWidth() + 8);
    }

    private int getY(int n) {
        if (!this._title) {
            return 2;
        }
        return 2 + this.getTitleHeight() * 0;
    }

    private int getTitleY() {
        return this.getItemHeight() + 4;
    }

    private int getTitleHeight() {
        return 18;
    }

    private int getIndex(int n) {
        int n2 = this.getPos(n);
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 4) {
            return -1;
        }
        if ((n -= this.getX(n2)) >= this.getItemWidth()) {
            return -1;
        }
        return n2;
    }

    private int getIndex(int n, int n2) {
        if (n2 < this.getY(0)) {
            return -1;
        }
        if ((n2 -= this.getY(0)) >= this.getItemHeight()) {
            return -1;
        }
        return this.getIndex(n);
    }

    private void drawTitle(Graphics graphics, int n) {
        int n2 = this.getSize().width;
        graphics.setColor(this._drawer.getColor(0));
        graphics.fillRect(0, n, n2, this.getTitleHeight());
        graphics.setClip(0, n, n2, this.getTitleHeight());
        this._drawer.draw(this._decodedTitle, graphics, 5 + this._titleLeft, n2 - 5 + this._titleLeft, n + this.getTitleHeight() - 2, 0, n2 - 1, false, false, this._drawResult);
        graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        this.drawSeparator(graphics, 0, n, n2, this.getTitleHeight());
    }

    private void drawDisconnectIcon(Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(new Color(0xAFAFAF));
        graphics.drawLine(n, n2 + n4 / 2 - 1, n + 5, n2 + n4 / 2 - 1);
        graphics.drawLine(n + n3 - 1, n2 + n4 / 2 - 1, n + n3 - 5, n2 + n4 / 2 - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 + n4 / 2, n + 4, n2 + n4 / 2);
        graphics.drawLine(n + n3 - 1, n2 + n4 / 2, n + n3 - 6, n2 + n4 / 2);
        graphics.drawLine(n + 4, n2 + n4 / 2 + 1, n + 7, n2 + n4 / 2 - 2);
        graphics.drawLine(n + 8, n2 + n4 / 2 + 1, n + 11, n2 + n4 / 2 - 2);
    }

    private void drawConnectIcon(Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(new Color(0xA2A2A2));
        graphics.drawLine(n, n2 + n4 / 2 - 1, n + n3 - 1, n2 + n4 / 2 - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 + n4 / 2, n + n3 - 1, n2 + n4 / 2);
        graphics.setColor(new Color(0x960000));
        graphics.drawLine(n + 2, n2 + 2, n + 14, n2 + 2);
        graphics.drawLine(n + 12, n2, n + 14, n2 + 2);
        graphics.drawLine(n + 12, n2 + 4, n + 14, n2 + 2);
        graphics.setColor(new Color(2775952));
        graphics.drawLine(n + 2, n2 + 9, n + 14, n2 + 9);
        graphics.drawLine(n + 2, n2 + 9, n + 4, n2 + 7);
        graphics.drawLine(n + 2, n2 + 9, n + 4, n2 + 11);
    }

    private void drawChanListIcon(Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(++n, n2 + 1, n + 9, n2 + 1);
        graphics.drawLine(n, n2 + 3, n + 5, n2 + 3);
        graphics.drawLine(n, n2 + 5, n + 12, n2 + 5);
        graphics.drawLine(n, n2 + 7, n + 11, n2 + 7);
        graphics.drawLine(n, n2 + 9, n + 9, n2 + 9);
        graphics.drawLine(n, n2 + 11, n + 13, n2 + 11);
    }

    private void drawHelpIcon(Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.fillRect((n += 4) + 0, ++n2 + 0, 2, 3);
        graphics.fillRect(n + 2, n2 + 0, 4, 2);
        graphics.fillRect(n + 6, n2 + 0, 2, 6);
        graphics.fillRect(n + 3, n2 + 4, 3, 2);
        graphics.fillRect(n + 3, n2 + 6, 2, 2);
        graphics.fillRect(n + 3, n2 + 9, 2, 2);
    }

    private void drawAboutIcon(Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.getIconHeight();
        graphics.setColor(new Color(0xEFEFEF));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 5, n2 + 4, n + 8, n2 + 4);
        graphics.drawLine(n + 5, n2 + 11, n + 10, n2 + 11);
        graphics.fillRect(n + 7, n2 + 4, 2, 7);
        graphics.fillRect(n + 7, n2 + 1, 2, 2);
    }

    private void drawCloseButtonCross(Graphics graphics, int n, int n2) {
        int n3 = 13;
        int n4 = 11;
        graphics.setColor(this.getColor(9));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getColor(0));
        for (int i = 0; i < 4; ++i) {
            graphics.drawLine(n + 3 + i, n2 + 2 + i, n + 4 + i, n2 + 2 + i);
            graphics.drawLine(n + 9 - i, n2 + 2 + i, n + 10 - i, n2 + 2 + i);
            graphics.drawLine(n + 3 + i, n2 + 8 - i, n + 4 + i, n2 + 8 - i);
            graphics.drawLine(n + 9 - i, n2 + 8 - i, n + 10 - i, n2 + 8 - i);
        }
    }

    private void drawDockButtonInternal(Graphics graphics, int n, int n2) {
        int n3 = 13;
        int n4 = 11;
        graphics.setColor(this.getColor(9));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getColor(0));
        int n5 = 4;
        int n6 = 1;
        graphics.drawRect(n + n5, n2 + n6, 6, 5);
        graphics.drawLine(n + n5 + 1, n2 + n6 + 1, n + n5 + 6, n2 + n6 + 1);
        n5 = 2;
        n6 = 4;
        graphics.setColor(this.getColor(0));
        graphics.drawRect(n + n5, n2 + n6, 6, 5);
        graphics.drawLine(n + n5 + 1, n2 + n6 + 1, n + n5 + 6, n2 + n6 + 1);
        graphics.setColor(this.getColor(9));
        graphics.fillRect(n + n5 + 1, n2 + n6 + 2, 5, 3);
    }

    private void drawItem(Graphics graphics, int n, int n2, boolean bl, String string) {
        int n3 = this.getItemWidth();
        int n4 = this.getItemHeight();
        int n5 = this.getIconWidth();
        graphics.setColor(this.getColor(5));
        if (bl) {
            graphics.setColor(this.getColor(7));
        }
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(this.getColor(0));
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(this.getColor(1));
        graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        graphics.drawLine(n + n5 + 2, n2 + 1, n + n5 + 2, n2 + n4 - 2);
        int n6 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n + n5 + 3 + ((n3 -= 5 + n5) - n6) / 2, n2 + n4 - 4);
    }

    private void drawDisconnectItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawItem(graphics, n, n2, bl, this.getText(34579));
        this.drawDisconnectIcon(graphics, n + 2, n2 + 2);
    }

    private void drawConnectItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawItem(graphics, n, n2, bl, this.getText(34584));
        this.drawConnectIcon(graphics, n + 2, n2 + 2);
    }

    private void drawChanListItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawItem(graphics, n, n2, bl, this.getText(34580));
        this.drawChanListIcon(graphics, n + 2, n2 + 2);
    }

    private void drawAboutItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawItem(graphics, n, n2, bl, this.getText(34585));
        this.drawAboutIcon(graphics, n + 2, n2 + 2);
    }

    private void drawHelpItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawItem(graphics, n, n2, bl, this.getText(34581));
        this.drawHelpIcon(graphics, n + 2, n2 + 2);
    }

    private void drawSmallButton(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = 16;
        int n4 = 16;
        if (!bl) {
            graphics.setColor(this.getColor(1));
            graphics.drawLine(n + 0, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + 0, n2 + 1, n + 0, n2 + n4 - 2);
            graphics.setColor(this.getColor(0));
            graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + 0, n2 + n4 - 2);
            graphics.setColor(this.getColor(2));
            graphics.drawLine(n + n3 - 2, n2 + n4 - 3, n + n3 - 2, n2 + 2);
            graphics.drawLine(n + n3 - 2, n2 + n4 - 3, n + 1, n2 + n4 - 3);
        } else {
            graphics.setColor(this.getColor(0));
            graphics.drawLine(n + 0, n2 + 1, n + n3 - 2, n2 + 1);
            graphics.drawLine(n + 0, n2 + 1, n + 0, n2 + n4 - 2);
            graphics.setColor(this.getColor(1));
            graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 2, n + 0, n2 + n4 - 2);
            graphics.setColor(this.getColor(2));
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + n4 - 3);
            graphics.drawLine(n + 1, n2 + 2, n + n3 - 2, n2 + 2);
        }
    }

    private void drawCloseButtonItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawSmallButton(graphics, n, n2, bl);
        if (!bl) {
            this.drawCloseButtonCross(graphics, n + 1, n2 + 2);
        } else {
            this.drawCloseButtonCross(graphics, n + 2, n2 + 3);
        }
    }

    private void drawDockButtonItem(Graphics graphics, int n, int n2, boolean bl) {
        this.drawSmallButton(graphics, n, n2, bl);
        if (!bl) {
            this.drawDockButtonInternal(graphics, n + 1, n2 + 2);
        } else {
            this.drawDockButtonInternal(graphics, n + 2, n2 + 3);
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != n || this._buffer.getHeight(this) != n2)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            Graphics graphics2;
            try {
                this._buffer = this.createImage(n, n2);
                graphics2 = this._buffer.getGraphics();
            }
            catch (Throwable throwable) {
                return;
            }
            graphics2.setFont(new Font("", 0, 12));
            graphics2.setColor(this.getColor(6));
            graphics2.fillRect(0, 0, n, n2);
            if (this._sboxConfiguration.getB("showconnect")) {
                if (!this._connected) {
                    this.drawConnectItem(graphics2, this.getX(this._connectIndex), this.getY(0), this._pressedIndex == this._connectIndex);
                } else {
                    this.drawDisconnectItem(graphics2, this.getX(this._connectIndex), this.getY(0), this._pressedIndex == this._connectIndex);
                }
            }
            if (this._sboxConfiguration.getB("showchanlist")) {
                this.drawChanListItem(graphics2, this.getX(this._chanlistIndex), this.getY(0), this._pressedIndex == this._chanlistIndex);
            }
            if (this._sboxConfiguration.getB("showabout")) {
                this.drawAboutItem(graphics2, this.getX(this._aboutIndex), this.getY(0), this._pressedIndex == this._aboutIndex);
            }
            if (this._sboxConfiguration.getB("showhelp")) {
                this.drawHelpItem(graphics2, this.getX(this._helpIndex), this.getY(0), this._pressedIndex == this._helpIndex);
            }
            if (this._sboxConfiguration.getB("showclose")) {
                this.drawCloseButtonItem(graphics2, this.getClosePositionX(), this.getClosePositionY(), this._closePressed);
            }
            if (this._sboxConfiguration.getB("showdock")) {
                this.drawDockButtonItem(graphics2, this.getDockPositionX(), this.getDockPositionY(), this._dockPressed);
            }
            if (this._title) {
                this.drawTitle(graphics2, this.getTitleY());
            }
        } else {
            Graphics graphics3 = this._buffer.getGraphics();
            if (this._redrawTitle) {
                this.drawTitle(graphics3, this.getTitleY());
            }
        }
        this._redrawTitle = false;
        if (this._buffer != null) {
            graphics.drawImage(this._buffer, 0, 0, this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._pressedIndex = this.getIndex(mouseEvent.getX(), mouseEvent.getY());
        this._closePressed = this.isClosePressed(mouseEvent.getX(), mouseEvent.getY());
        this._dockPressed = this.isDockPressed(mouseEvent.getX(), mouseEvent.getY());
        this._buffer = null;
        if (this._title && mouseEvent.getY() >= this.getTitleY()) {
            this._mouseDownX = mouseEvent.getX();
            this._mouseScroll = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._mouseScroll = false;
        int n = this.getIndex(mouseEvent.getX(), mouseEvent.getY());
        boolean bl = this.isClosePressed(mouseEvent.getX(), mouseEvent.getY());
        boolean bl2 = this.isDockPressed(mouseEvent.getX(), mouseEvent.getY());
        if (n == this._connectIndex && this._sboxConfiguration.getB("showconnect")) {
            this._listeners.sendEventAsync("connectionClicked", (Object)this);
        }
        if (n == this._chanlistIndex && this._sboxConfiguration.getB("showchanlist")) {
            this._listeners.sendEventAsync("chanListClicked", (Object)this);
        }
        if (n == this._aboutIndex && this._sboxConfiguration.getB("showabout")) {
            this._listeners.sendEventAsync("aboutClicked", (Object)this);
        }
        if (n == this._helpIndex && this._sboxConfiguration.getB("showhelp")) {
            this._listeners.sendEventAsync("helpClicked", (Object)this);
        }
        if (bl) {
            this._listeners.sendEventAsync("closeClicked", (Object)this);
        }
        if (bl2) {
            this._listeners.sendEventAsync("dockClicked", (Object)this);
        }
        this._closePressed = false;
        this._dockPressed = false;
        this._pressedIndex = -1;
        this._buffer = null;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._title && mouseEvent.getY() >= this.getTitleY()) {
            if (!this.getCursor().equals(new Cursor(11))) {
                this.setCursor(new Cursor(11));
            }
        } else if (!this.getCursor().equals(new Cursor(0))) {
            this.setCursor(new Cursor(0));
        }
    }

    public void dispose() {
        this._terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollTitle(int n) {
        Object object = this._scrollLock;
        synchronized (object) {
            if (this._drawResult.rectangle == null) {
                return;
            }
            this._titleLeft -= n;
            int n2 = -this._drawResult.rectangle.width;
            int n3 = this.getSize().width;
            if (this._titleLeft > n3) {
                this._titleLeft = n2;
            }
            if (this._titleLeft < n2) {
                this._titleLeft = n3;
            }
            this._redrawTitle = true;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._mouseScroll) {
            return;
        }
        if (this._drawResult.rectangle == null) {
            return;
        }
        int n = this._mouseDownX - mouseEvent.getX();
        this.scrollTitle(n);
        this._freeze = true;
        this._mouseDownX = mouseEvent.getX();
    }

    public void run() {
        while (!this._terminated) {
            if (!this._freeze) {
                this.scrollTitle(4);
            }
            try {
                if (this._freeze) {
                    Thread.sleep(2000L);
                    this._freeze = false;
                    continue;
                }
                Thread.sleep(this._scrollDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Boolean displayUpdated(Object object, Integer n) {
        if (this._drawResult == null) {
            return Boolean.FALSE;
        }
        for (int i = 0; i < this._drawResult.updateHandles.size(); ++i) {
            if (this._drawResult.updateHandles.elementAt(i) != object) continue;
            this._redrawTitle = true;
            this.repaint();
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

