/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.gui.sbox.BaseAWTSource;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxTaskBar;
import irc.gui.sbox.TaskBarItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Enumeration;

public class SboxTaskBarWest
extends SboxTaskBar {
    public SboxTaskBarWest(SboxConfiguration sboxConfiguration) {
        super(sboxConfiguration);
    }

    public void release() {
        super.release();
    }

    public TaskBarItem findItem(BaseAWTSource baseAWTSource) {
        if (baseAWTSource == null) {
            return null;
        }
        for (int i = 0; i < this._items.size(); ++i) {
            if (((TaskBarItem)this._items.elementAt((int)i)).source != baseAWTSource) continue;
            return (TaskBarItem)this._items.elementAt(i);
        }
        return null;
    }

    public synchronized void enter(BaseAWTSource baseAWTSource, boolean bl) {
        ++this._visibleItemCount;
        TaskBarItem taskBarItem = new TaskBarItem(baseAWTSource, this._visibleItemCount, 0, bl);
        baseAWTSource.addBaseAWTSourceListener(this);
        this._items.insertElementAt(taskBarItem, this._items.size());
        ++this._itemCount;
        this._listeners.sendEvent("AWTSourceAdded", (Object)this, (Object)baseAWTSource);
        if (bl) {
            this.activate(baseAWTSource);
        }
        this._buffer = null;
        this.repaint();
    }

    public synchronized void leave(BaseAWTSource baseAWTSource) {
        TaskBarItem taskBarItem = this.findItem(baseAWTSource);
        baseAWTSource.removeBaseAWTSourceListener(this);
        --this._itemCount;
        --this._visibleItemCount;
        boolean bl = this.getActive() == baseAWTSource;
        this.removeFromVector(this._items, taskBarItem);
        if (bl) {
            this.activate(null);
        }
        this._listeners.sendEvent("AWTSourceRemoved", (Object)this, (Object)baseAWTSource);
        this._buffer = null;
        this.repaint();
    }

    public BaseAWTSource findFirst() {
        TaskBarItem taskBarItem = null;
        int n = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            TaskBarItem taskBarItem2 = (TaskBarItem)this._items.elementAt(i);
            if (taskBarItem2.zorder <= n) continue;
            n = taskBarItem2.zorder;
            taskBarItem = taskBarItem2;
        }
        if (taskBarItem == null) {
            return null;
        }
        return taskBarItem.source;
    }

    public BaseAWTSource[] getZOrderedSources() {
        int n;
        TaskBarItem[] taskBarItemArray = new TaskBarItem[this._items.size()];
        for (n = 0; n < taskBarItemArray.length; ++n) {
            taskBarItemArray[n] = (TaskBarItem)this._items.elementAt(n);
        }
        for (n = 0; n < taskBarItemArray.length - 1; ++n) {
            TaskBarItem taskBarItem = taskBarItemArray[n];
            int n2 = taskBarItem.zorder;
            int n3 = n;
            for (int i = n + 1; i < taskBarItemArray.length; ++i) {
                taskBarItem = taskBarItemArray[i];
                if (taskBarItem.zorder <= n2) continue;
                n2 = taskBarItem.zorder;
                n3 = i;
            }
            TaskBarItem taskBarItem2 = taskBarItemArray[n];
            taskBarItemArray[n] = taskBarItemArray[n3];
            taskBarItemArray[n3] = taskBarItem2;
        }
        BaseAWTSource[] baseAWTSourceArray = new BaseAWTSource[taskBarItemArray.length];
        for (int i = 0; i < baseAWTSourceArray.length; ++i) {
            baseAWTSourceArray[i] = taskBarItemArray[i].source;
        }
        return baseAWTSourceArray;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._maxWidth, this.getSize().height);
    }

    public int getItemWidth() {
        return this._iwidth;
    }

    public int getItemHeight() {
        return this._font.getSize() + 4;
    }

    public synchronized void computeWidth() {
        int n = this.getSize().width;
        this._iwidth = Math.min(this._maxWidth, n -= 9);
    }

    public int getX(int n) {
        return n * (this.getItemWidth() + 9) + this._ileft;
    }

    public int getCol(int n) {
        return (n - this._ileft) / (9 + this.getItemWidth());
    }

    public int getY(int n) {
        return 4 + (this.getItemHeight() + 2) * n;
    }

    public int getRow(int n) {
        return (n - 4) / (2 + this.getItemHeight());
    }

    public void drawItem(Graphics graphics, int n, int n2, Color color, String string) {
        int n3 = this.getX(n);
        int n4 = this.getY(n2);
        int n5 = this.getItemWidth();
        int n6 = this.getItemHeight();
        graphics.setClip(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
        graphics.setColor(color);
        graphics.fillRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(0));
        graphics.drawRect(n3, n4, n5, n6);
        graphics.setColor(this.getColor(1));
        graphics.drawRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        n4 += n6;
        int n7 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n3 + (n5 - n7) / 2, (n4 -= (n6 - this._font.getSize()) / 2) - 1);
        graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
    }

    public void drawItem(Graphics graphics, TaskBarItem taskBarItem, int n) {
        int n2 = 0;
        Color color = this.getColor(5);
        if (taskBarItem == this._active || taskBarItem == this._pressed) {
            color = this.getColor(7);
        }
        if (taskBarItem != this._active && taskBarItem.eventWaiting) {
            color = this.getColor(8);
        }
        this.drawItem(graphics, n2, n++, color, taskBarItem.source.getShortTitle());
    }

    public void update(Graphics graphics) {
        Object object;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (this._buffer != null && (this._buffer.getWidth(this) != n || this._buffer.getHeight(this) != n2)) {
            this._buffer = null;
        }
        if (this._buffer == null) {
            try {
                this._buffer = this.createImage(n, n2);
                object = this._buffer.getGraphics();
            }
            catch (Throwable throwable) {
                return;
            }
            ((Graphics)object).setFont(new Font("", 0, 12));
            this._ileft = 6;
            this.computeWidth();
            ((Graphics)object).setColor(this.getColor(6));
            ((Graphics)object).fillRect(0, 0, n, n2);
            int n3 = 0;
            Enumeration enumeration = this._items.elements();
            while (enumeration.hasMoreElements()) {
                TaskBarItem taskBarItem = (TaskBarItem)enumeration.nextElement();
                if (!taskBarItem.visible) continue;
                this.drawItem((Graphics)object, taskBarItem, n3++);
                taskBarItem.row = n3;
            }
        }
        if (this._buffer != null) {
            graphics.drawImage(this._buffer, 0, 0, this);
        }
        if ((object = this.getItemAt(this._overX, this._overY)) != null) {
            String string = ((TaskBarItem)object).source.getShortTitle();
            int n4 = graphics.getFontMetrics().stringWidth(string);
            int n5 = this.getX(this.getCol(this._overX)) + (this.getItemWidth() - n4) / 2 - 2;
            int n6 = this.getY(this.getRow(this._overY)) - (this.getItemHeight() - this._font.getSize()) / 2 - 1;
            int n7 = this.getItemHeight();
            if (string.length() > 0 && n4 >= this.getItemWidth()) {
                if (n5 + n4 + 5 >= n) {
                    n5 = n - n4 - 5;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.setColor(this.getAlphaColor(this.getColor(5), 200));
                graphics.fillRect(n5, n6, n4 + 4, n7 + 4);
                graphics.setColor(this.getColor(1));
                graphics.drawRect(n5, n6, n4 + 4, n7 + 4);
                graphics.drawString(string, n5 + 2, n6 + n7);
            }
        }
    }

    public TaskBarItem getItemAt(int n, int n2) {
        int n3;
        int n4 = this.getRow(n2);
        if ((n -= this.getX(n3 = this.getCol(n))) >= this.getItemWidth() || (n2 -= this.getY(n4)) >= this.getItemHeight()) {
            return null;
        }
        if (n < 0 || n2 < 0) {
            return null;
        }
        int n5 = 0;
        Enumeration enumeration = this._items.elements();
        while (enumeration.hasMoreElements()) {
            TaskBarItem taskBarItem = (TaskBarItem)enumeration.nextElement();
            if (!taskBarItem.visible) continue;
            if (n5 == n4) {
                return taskBarItem;
            }
            ++n5;
        }
        return null;
    }
}

