/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.NotEnoughParametersException;
import irc.RootInterpretor;
import irc.Source;
import irc.gui.sbox.BaseAWTSource;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxMDIInterface;
import java.util.Enumeration;
import java.util.Locale;

public class AWTInterpretor
extends RootInterpretor {
    private SboxMDIInterface _mdi;
    private SboxConfiguration _config;

    public AWTInterpretor(SboxConfiguration sboxConfiguration, SboxMDIInterface sboxMDIInterface) {
        super(sboxConfiguration.getIRCConfiguration());
        this._mdi = sboxMDIInterface;
        this._config = sboxConfiguration;
    }

    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        block29: {
            try {
                if (string.equals("dock")) {
                    BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source);
                    if (baseAWTSource != null) {
                        this._mdi.dock(baseAWTSource);
                    }
                    break block29;
                }
                if (string.equals("undock")) {
                    BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source);
                    if (baseAWTSource != null) {
                        this._mdi.undock(baseAWTSource);
                    }
                    break block29;
                }
                if (string.equals("color")) {
                    int n;
                    this.test(string, stringArray, 1);
                    BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source);
                    if (baseAWTSource == null) break block29;
                    String string2 = stringArray[1];
                    String string3 = "";
                    int n2 = string2.indexOf(",");
                    if (n2 >= 0) {
                        string3 = string2.substring(n2 + 1);
                        string2 = string2.substring(0, n2);
                    }
                    try {
                        n = Integer.parseInt(string2);
                        baseAWTSource.setFrontColor(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        n = Integer.parseInt(string3);
                        baseAWTSource.setBackColor(n);
                    }
                    catch (Exception exception) {}
                    break block29;
                }
                if (string.equals("bold")) {
                    this.test(string, stringArray, 1);
                    BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source);
                    if (baseAWTSource != null) {
                        if (stringArray[1].equals("1")) {
                            baseAWTSource.setBold(true);
                        } else if (stringArray[1].equals("0")) {
                            baseAWTSource.setBold(false);
                        }
                    }
                    break block29;
                }
                if (string.equals("underline")) {
                    this.test(string, stringArray, 1);
                    BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source);
                    if (baseAWTSource != null) {
                        if (stringArray[1].equals("1")) {
                            baseAWTSource.setUnderline(true);
                        } else if (stringArray[1].equals("0")) {
                            baseAWTSource.setUnderline(false);
                        }
                    }
                    break block29;
                }
                if (string.equals("highlight")) {
                    this.test(string, stringArray, 1);
                    for (int i = 1; i < stringArray.length; ++i) {
                        this._config.addHighLightWord(stringArray[i]);
                    }
                    break block29;
                }
                if (string.equals("unhighlight")) {
                    this.test(string, stringArray, 1);
                    for (int i = 1; i < stringArray.length; ++i) {
                        this._config.removeHighLightWord(stringArray[i]);
                    }
                    break block29;
                }
                if (string.equals("focus")) {
                    this.test(string, stringArray, 2);
                    Enumeration enumeration = source.getServer().getSources();
                    while (enumeration.hasMoreElements()) {
                        Source source2 = (Source)enumeration.nextElement();
                        if (!source2.getType().equals(stringArray[1]) || !source2.getName().toLowerCase(Locale.ENGLISH).equals(stringArray[2].toLowerCase(Locale.ENGLISH))) continue;
                        BaseAWTSource baseAWTSource = this._mdi.findBaseAWTSource(source2);
                        if (baseAWTSource != null) {
                            this._mdi.setActive(baseAWTSource);
                        }
                        break block29;
                    }
                    break block29;
                }
                super.handleCommand(source, string, stringArray, stringArray2);
            }
            catch (NotEnoughParametersException notEnoughParametersException) {
                source.report(this.getText(3, notEnoughParametersException.getMessage()));
            }
        }
    }
}

