#include "log.h"
#include "lib_put_user.h"

#define TEST_ADDR 0xc0008000

// For local vector: check as a stand-alone binary
#ifdef LOCAL
int main(void) {

// For remote vector: check as a lib
#else
int put_user_check_exploitability(void) {
#endif

  unsigned long int value = 0;

  LOGD("Checking put user exploitability");
  // Just check if we are able to read in kernel space
  if(read_value_at_address(TEST_ADDR, &value) < 0) {
    LOGD("Vuln not present");
    return 0;
  }
  else {
    LOGD("The device appears to be exploitable");
    return 1;
  }

}
