package x;

import java.util.HashSet;
import java.util.Iterator;

/**
 * A HashSet where a custom iterator can be given. Calls Iterator.next()
 * when the toString() is called.
 */
public class MyHashSet extends HashSet<Object> {

	private static final long serialVersionUID = -3575746442518083846L;
	
	Iterator<Object> iter;
	
	public MyHashSet(Iterator<Object> iter) {
		this.iter = iter;
	}	
	
	@Override
	public Iterator<Object> iterator() {		
		return iter;
	}
	
}
