package x;


import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;

import com.sun.jndi.toolkit.dir.ContextEnumerator;
import com.sun.jndi.toolkit.url.GenericURLContext;

/**
 * This class calls close() on the Context given in the Constructor
 * when the next-method is called on it after construction.
 */
@SuppressWarnings("all")
public class Context_close_Caller extends ContextEnumerator /* implements Iterator */ {

	public Context_close_Caller(Context context, int i) throws NamingException {
		super(context, i);
	}

	public static Context_close_Caller create(Context ctx) {
	    MyNamingEnumeration mySubNamEnum = new MyNamingEnumeration();
	    mySubNamEnum.values.add(new Binding("Datteln/Dattel", "Wurst2"));
	    mySubNamEnum.values.add(new Binding("Datteln/Birne", ctx, true));
	    
	    MyNamingEnumeration myNamEnum = new MyNamingEnumeration();
	    myNamEnum.values.add(new Binding("Apfel", "Wurst"));
	    myNamEnum.values.add(new Binding("Datteln", new MyGenericURLContext(ctx,mySubNamEnum), true));
	    
	    MyGenericURLContext urlCtx = new MyGenericURLContext( new MyGenericURLContext(null, myNamEnum), null );
	    
	    try {
	    	Context_close_Caller inst = new Context_close_Caller(urlCtx, 2);
	    	// Iterate two times... the next call here will do the trick.
//	    	System.out.println("---------------------------");
	    	inst.next();
	    	inst.next();
//		    System.out.println("Root context :"+inst.next()); // 
//		    System.out.println("First child :"+inst.next()); // 
			return inst;
		} catch (NamingException e) {
			throw new RuntimeException("Creation of Context_close_Caller failed.");
		}
	}

	int numElements = 1;
	
	public boolean hasNext() {
		return numElements-->0; // I love the arrow operator.
	}

	public void remove() {
	}
		

	public static class MyGenericURLContext extends GenericURLContext {

		Context rootContext;
		
		MyNamingEnumeration myNamingEnumeration;
			
		public MyGenericURLContext(Context rootContext,MyNamingEnumeration myNamingEnumeration) {
			super( new Hashtable<Object,Object>() );
			this.rootContext = rootContext;
			this.myNamingEnumeration = myNamingEnumeration;
		}

		int count;
		
		@Override
		protected ResolveResult getRootURLContext(String s, Hashtable hashtable)
				throws NamingException {
//			System.out.println("call to getRootContext with String '"+s+"'!");
			count++;
	    	return new ResolveResult(rootContext, "");
		}

		
		@Override
		public NamingEnumeration<Binding> listBindings(Name name)
				throws NamingException {		
			return myNamingEnumeration == null ? super.listBindings(name) :myNamingEnumeration;
		}

		@Override
		public NamingEnumeration<Binding> listBindings(String name)
				throws NamingException {
			return myNamingEnumeration == null ? super.listBindings(name) :myNamingEnumeration;
		}

	}
	
	public static class MyNamingEnumeration implements NamingEnumeration {
	
		public List values = new ArrayList();
		
		int position = 0;
		
		@Override
		public boolean hasMoreElements() {
			return position < values.size();
		}
	
		@Override
		public Object nextElement() {
			Object next = values.get(position);
			position++;
			return next;
		}
	
		@Override
		public Object next() throws NamingException {
			return nextElement();
		}
	
		@Override
		public boolean hasMore() throws NamingException {
			return hasMoreElements();
		}
	
		@Override
		public void close() throws NamingException {
		}
	
	}

	
}
