
#ifndef CTL_CODE
	#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
	((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
	)
#endif
#ifndef METHOD_BUFFERED
	#define METHOD_BUFFERED	0
#endif
#ifndef FILE_WRITE_ACCESS
	#define FILE_WRITE_ACCESS ( 0x0002 )
#endif

#define FILE_DEVICE_H4DRIVER 0x00008234

#define ADMIN_FUNCTION 	0x0882
#define UNHOOK_FUNCTION 0x0883
#define ADDPID_FUNCTION 0x0884
#define REG_FUNCTION	0x0885
#define THAW_FUNCTION	0x0886
#define FREEZE_FUNCTION 0x0887

#define IOCTL_UNHOOK CTL_CODE(FILE_DEVICE_H4DRIVER, UNHOOK_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS) // 0x8234A20C
#define IOCTL_ADDPID CTL_CODE(FILE_DEVICE_H4DRIVER, ADDPID_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS) // 0x8234A210
#define IOCTL_ADMIN  CTL_CODE(FILE_DEVICE_H4DRIVER, ADMIN_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS)  // 0x8234A208
#define IOCTL_REG 	 CTL_CODE(FILE_DEVICE_H4DRIVER, REG_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS)    // 0x8234A214
#define IOCTL_THAW   CTL_CODE(FILE_DEVICE_H4DRIVER, THAW_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS)   
#define IOCTL_FREEZE CTL_CODE(FILE_DEVICE_H4DRIVER, FREEZE_FUNCTION, METHOD_BUFFERED, FILE_WRITE_ACCESS) 

#define STATUS_INFO_LENGTH_MISMATCH      ((NTSTATUS)0xC0000004L)
#define STATUS_SUCCESS 0

typedef DWORD PROCESSINFOCLASS;
typedef struct _SYSTEM_HANDLE_INFORMATION {
	ULONG  ProcessId;
	UCHAR  ObjectTypeNumber;
	UCHAR  Flags;
	USHORT Handle;
	PVOID  Object;
	ACCESS_MASK  GrantedAccess;
} SYSTEM_HANDLE_INFORMATION, *PSYSTEM_HANDLE_INFORMATION;
#define SystemHandleInformation 16

#ifdef __cplusplus
extern "C" {
#endif
typedef NTSTATUS (__stdcall *NtQuerySystemInformation_t) (unsigned int, PVOID, ULONG, PULONG);
typedef DWORD (WINAPI *ZWQUERYSYSTEMINFORMATION)(
   PROCESSINFOCLASS ProcessInformationClass,
   PVOID ProcessInformation,
   ULONG ProcessInformationLength,
   PULONG ReturnLength
);
#ifdef __cplusplus
}
#endif

extern BOOL GetAdmin(DWORD pid);
extern void *FindTokenObject(HANDLE Handle);
