﻿# Author
FreeMenDontAskPermission (FreeMenDontAsk)

# Version
1.0

#### Description 
This is a 3D Printable G19 frame that is compatible with the P80 style rail system.

#### 1. Tools and Parts List
Below is a list of tools, parts and materials you should need to complete this project.

##### Off the shelf Glock parts:
* Complete G19 upper (dressed or finished upper, barrel, recoil spring assembly)
* Complete G19 lower parts kit (from Midway USA or elsewhere)
* P80 Rail set (must be taken from a P80 frame, rails are not sold seperate)

##### Print Settings
For a light duty/workable frames:
* Material: eSun PLA+
* Print Temp: 235 C
* Bed Temp: 60 C
* Bed Prep: Wipe clean, apply a thick layer of Elmer’s glue stick. Kapton tape is recommended since this frame will really stick to the bed tight if you use the STL with the raft.
* Infill: 100%, Rectilinear Fill
* Enclosure: None
* Orientation: not super critical but using the STL with the raft will result in far less warp. Warp is the enemy of this project.
* Supports: full, hexagonal infill, sheathing on infill optional but recommended if your slicer supports it.

Remember that PLA will not stand up to hot environments. While the gun itself won’t hold enough heat to hurt the frame (I dumped 50 rounds as quick as I could load them without issue), having this frame sit in a hot car would damage it.

For a heavy duty/durable frames:
* Material: Zytel or Glass filled Zytel
* Print Temp: 287 C
* Bed Temp: 100 C
* Bed Prep: Wipe clean, apply a thick layer of Elmer’s glue stick. Kapton tape is recommended since this frame will really stick to the bed tight if you use the STL with the raft.
* Infill: 100%, Rectilinear Fill
* Enclosure: None needed, but it will not hurt if you use one.
* Orientation: not super critical but using the STL with the raft will result in far less warp. Warp is the enemy of this project.

If you use glass filled Zytel, you may need to coat the outside of the frame with fiberglass resin because the glass fill is very abrasive. Either Zytel frame will stand up to excessive amounts of abuse. Boiling the Zytel frame in water after printing will help layer adhesion without warping the part.

#### Assembly 
Important items to note for assembly are noted in the instructional videos, but some are important enough to mentioned in this Readme as well:

* Holes must be drilled to size. Don’t try and hammer the pins in. They should go in easy.
* If the locking block pin holes don’t line up, don’t try and force the pins through.

In general: 
* Remove all support material
* Add front rail section
* Add locking block
* Add slide lock
* Add trigger bar/housing assembly
* Remove trigger bar/housing assembly once fitment is verified
* Screw in rear rails
* Reinstall trigger assembly
* Pin in the locking block, trigger assembly, and slide stop
* Ensure the rails are flat/on the same plane using a straightedge
* Ensure fitment of the slide with barrel and spring removed
* Ensure fitment and function of the pistol with barrel and spring installed
* Function test! Function test! Function test! Rack that slide real hard.

#### Troubleshooting 

##### Dead Triggers or No Reset
This is perhaps the most common issue I ran into. It is caused when the trigger bar does not pop up as it should when the slide recoils. If your right hand rear rail is too wide, it will cause dead triggers. If it is not screwed in such that it fits parallel to the frame, it will cause dead triggers. I ended up dremeling my right rear rail down some on the inside to add some clearance. This may or may not help you. Remember to grind down the screws if they protrude through the rail section at all. I will also point out one spot on the frame that might benefit from a bit of sanding to help fix dead triggers.

##### Locking Block will not Line Up
More fitment work is needed for the locking block. Watch that section of the instructional video closely.


