
# Welcome Contributors

When contributing, please first discuss the change you wish to make via issue, before making the actual change.

We want to make contributing to this project as easy and transparent as possible.

Please note we have a Code Of Conduct, please follow it in all your interactions with the project.


# FAQ

Whats Nim?

- Its just like Cython, but faster and more elegant syntax, we can say Nim is more Pythonic than Cython, 
is a proper programming language instead of an experimental pseudo-lang alternative syntax, it also runs on the Browser Frontend.


# Development Process

[We use Github Flow](https://guides.github.com/introduction/flow/index.html), so all code changes happen via Pull Requests:

1. Fork the repo from latest working `master` and create a new branch.
2. Change the code on the new branch, update the documentation, test it locally.
3. Send a new Pull Request!, follow the Feedback from the Peer Reviews so it gets Merged faster.


# How to Contribute if you cant code

- [Make Nim Fan Art and Memes](https://t.me/addstickers/nimlang).
- Give a Talk about Nim-based Python libs at your local meetup.
- Talk about Nim-based Python libs on your social networks.
- [Writing tutorials and blog posts](https://dev.to/juancarlospaco/self-firejailing-web-framework-h5l).
- Improving documentations.
- UX and Design improvements.
- Make Benchmarks of Nim-based libs Vs other frameworks.
- Mention Nim-based Python libs on discussions about Python.
- Submitting bugs and feature requests.

Are all examples of very helpful contributions!.


# Style Guide

- Follow [NEP1](https://nim-lang.org/docs/nep1.html).
- Keep API human-friendly, but at the same time use performant algos, thats the Nim way.
- Try to use naming that makes sense :)


# Your Responsibilities

- Write detailed bug reports with sample code.
- Write meaningful human-friendly Commit Messages.
- Ensure Linux platform and Latest Stable Nim compatibility.
- Discuss things transparently and get community feedback.
- Do not add any Types to the codebase unless absolutely needed.
- Prefer standard library as much as possible instead of third party modules.
- Document how to use the new features and pros/cons if any.
- Be welcoming to newcomers and encourage diverse new contributors from all backgrounds.
