

# MasterHide

MasterHide is a x64 Windows Driver created to monitor/hide or block access from processes, objects, files ( whatever you want, your imagination is the limit here ) using SSDT/Shadow SSDT hooks. 
It can also manipulate another driver ( klhk.sys ) which the original idea and implementation came from [KasperskyHook](https://github.com/iPower/KasperskyHook/) by [iPower](https://github.com/iPower), i'm using a submodule from the latest commit as i'm writing this.

# KasperskyHook

This techniques modifies klhk.sys aka "Kaspersky Lab service driver".
This driver is the antivirus legitimate driver, more information can be found on the [original repo](https://github.com/iPower/KasperskyHook/).

The original intetion was to monitor malware behavior on the system and the main goal is not to bypass antivirus or anticheats solutions, but, that can be done anyway.

## Compatibility
##### Lets call 'Kaspersky hooks' everything that can be done modifying klhk.sys ok?

When the definition `USE_KASPERSKY` is set the project will use _Kaspersky hooks_ that is compatible on Windows 7/8/8.1 and 10, Intel and AMD supported but Virtualization should be enabled on the BIOS.

When `USE_KASPERSKY` is not set the project will use SSDT and Shadow SSDT, that is hardcoded to Windows 7 7601 SP1 (x64 of course) only, it can also be said that **PatchGuard NEEDS TO BE TURNED OFF HERE** as there's checks for those.

## Hooks
I've left some, both Shadow and SSDT normal hooks, for example on the project. 
Those are:

  - NtQuerySystemInformation
  - NtOpenProcess
  - NtAllocateVirtualMemory
  - NtFreeVirtualMemory
  - NtWriteVirtualMemory
  - NtLoadDriver
  - NtDeviceIoControlFile
  - NtUserFindWindowEx
  - NtUserWindowFromPoint
  - NtUserBuildHwndList
  - NtGetForegroundWindow
  - NtUserQueryWindow

## Issues
I've debugged the driver several times using Verifier tool to prevent memory leaks and heap corruption but there's some bugs that can be naturally found with more use or with addition of additional hooks.
The already known issues are:

  - Shadow SSDT is not stable on Windows 7
  
As i said more bugs can be found in the future, the project is not 100% stable.

## Compilation, Installation and Usage

Visual Studio 2019 required with SDK/WDK 1903
Compilation is simple, just open the project and build it using the IDE.

No driver certificate is given here, either load the driver with test signing mode enabled or sign it yourself using a valid certificate.

A debug log is generated by default, you can use a tool like DebugViewer to see those logs.
Use TestHide.exe to check if things are actually working.

KasperskyHook can be used without triggering the PatchGuard, no actually hooks can be found or checked in a normal way.

**Important note:** _KasperskyHookLoader.exe_ should be used to load the Driver if `USE_KASPERSKY` flag enabled, otherwise you can just load the driver using a ordinary way.

## Credits

[iPower](https://github.com/iPower) creator of KasperskyHook
[zer0m0n](https://github.com/conix-security/zer0m0n) Some code can or was based on this project.

Most other things can be found on Google, the code looks like shit yes but the main goal here is to have a PoC of something actually working.

## Demo

![Cheat Engine process not visible on process list](https://i.imgur.com/DG8qjFw.png)

![Cheat Engine process not found or visible via windows using blacklisted methods](https://i.imgur.com/DG8qjFw.png)
