#define _CRT_SECURE_NO_WARNINGS

#include <Windows.h>
#include <stdio.h>

#define BUFFER_SIZE 512


DWORD InstallDriver(char* driverName, char* binaryPath);
DWORD ControlDriver(char* driverName, char* cmd);
DWORD DeleteDriver(char* driverName);


void usage(void)
{
	fprintf(stdout,
		"DriverLoader: a kernel mode driver install&uninstall tool\n\n"
		"usage: DriverLoader <drivername> [options]\n\n"
		"options:\n"
		"/i              Install driver\n"
	    "/d              Uninstall driver\n"
		"/s              Start driver\n"
		"/k              Stop driver\n\n"
		"examples:\n"
		"DriverLoader yourdriver.sys /i\n"
		"DriverLoader yourdriver.sys /d\n\n");
}


int main(int argc, char** argv)
{
	if (argc < 2)
	{
		usage();
		return -1;
	}

	DWORD errCode = 0;

	char driverDirectory[BUFFER_SIZE] = { 0 };
	char driverPath[BUFFER_SIZE * 2] = { 0 };
	char driverName[BUFFER_SIZE] = { 0 };

	errCode = GetCurrentDirectory(BUFFER_SIZE, driverDirectory);
	if (errCode == 0 || errCode > BUFFER_SIZE)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error getting current directory, code: %#X", errCode);
		return errCode;
	}

	snprintf(driverPath, BUFFER_SIZE, "%s\\%s", driverDirectory, argv[1]);
	snprintf(driverName, BUFFER_SIZE, "%s", argv[1]);
	fprintf(stdout, "Driver name: %s\n", driverName);
	fprintf(stdout, "Driver path: %s\n", driverPath);

	if (argv[2] == NULL || strcmp(argv[2], "/i") == 0)
	{
		fprintf(stdout, "OP: Install driver\n");
		errCode = InstallDriver(driverName, driverPath);
	}
	else if (strcmp(argv[2], "/d") == 0)
	{
		fprintf(stdout, "OP: Delete driver\n");
		errCode = DeleteDriver(driverName);
	}
	else 
	{
		fprintf(stdout, "OP: Control driver\n");
		errCode = ControlDriver(driverName, argv[2]);
	}

	if (errCode != 0)
	{
		fprintf(stderr, "Error occured, code: %#X\n", errCode);
	}

	return errCode;
}


DWORD InstallDriver(char* driverName, char* binaryPath)
{
	DWORD errCode = 0;
	SC_HANDLE hService = NULL;
	SC_HANDLE hServiceMgr = NULL;

	hServiceMgr = OpenSCManager(
		NULL,
		NULL,
		SC_MANAGER_ALL_ACCESS
	);

	if (hServiceMgr == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error opening SCM\n");
		return errCode;
	}

	fprintf(stdout, "SCM opened\nInstalling driver\n");

	hService = CreateService(
		hServiceMgr,
		driverName,
		driverName,
		SERVICE_ALL_ACCESS,
		SERVICE_KERNEL_DRIVER,
		SERVICE_DEMAND_START,
		SERVICE_ERROR_NORMAL,
		binaryPath,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL
	);

	if (hService == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error installing driver\n");
		CloseServiceHandle(hServiceMgr);
		return errCode;
	}

	fprintf(stdout, "Driver Installed\n");
	CloseServiceHandle(hService);
	CloseServiceHandle(hServiceMgr);

	return errCode;
}


DWORD ControlDriver(char* driverName, char* cmd)
{
	DWORD errCode = 0;
	SC_HANDLE hService = NULL;
	SC_HANDLE hServiceMgr = NULL;
	SERVICE_STATUS svcStat = { 0 };

	hServiceMgr = OpenSCManager(
		NULL,
		NULL,
		SC_MANAGER_ALL_ACCESS
	);

	if (hServiceMgr == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error opening SCM\n");
		return errCode;
	}

	fprintf(stdout, "SCM opened\nOpening driver\n");

	hService = OpenService(
		hServiceMgr,
		driverName,
		SERVICE_ALL_ACCESS
	);

	if (hService == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error opening driver\n");
		CloseServiceHandle(hServiceMgr);
		return errCode;
	}

	fprintf(stdout, "Driver opened\n");

	if (strcmp(cmd, "/s") == 0)
	{
		fprintf(stdout, "Starting driver\n");
		if (StartService(
			hService,
			0,
			NULL
		) == 0)
		{
			errCode = GetLastError();
			fprintf(stderr, "Error starting driver\n");
		}
	}
	else if (strcmp(cmd, "/k") == 0)
	{
		fprintf(stdout, "Stopping driver\n");
		if (ControlService(
			hService,
			SERVICE_CONTROL_STOP,
			&svcStat
		) == 0)
		{
			errCode = GetLastError();
			fprintf(stderr, "Error stopping driver\n");
		}
	}
	else
	{
		fprintf(stderr, "Unknown parameter: %s\n", cmd);
		errCode = STATUS_INVALID_PARAMETER;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hServiceMgr);

	return errCode;
}


DWORD DeleteDriver(char* driverName)
{
	DWORD errCode = 0;
	SC_HANDLE hService = NULL;
	SC_HANDLE hServiceMgr = NULL;

	hServiceMgr = OpenSCManager(
		NULL,
		NULL,
		SC_MANAGER_ALL_ACCESS
	);

	if (hServiceMgr == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error opening SCM\n");
		return errCode;
	}

	fprintf(stdout, "SCM opened\nOpening driver\n");

	hService = OpenService(
		hServiceMgr,
		driverName,
		SERVICE_ALL_ACCESS
	);

	if (hService == NULL)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error opening driver\n");
		CloseServiceHandle(hServiceMgr);
		return errCode;
	}

	fprintf(stdout, "Service opened\nUninstalling driver\n");

	if (DeleteService(hService) == 0)
	{
		errCode = GetLastError();
		fprintf(stderr, "Error uninstalling driver\n");
		CloseServiceHandle(hService);
		CloseServiceHandle(hServiceMgr);
		return errCode;
	}

	fprintf(stdout, "Driver uninstalled\n");
	CloseServiceHandle(hService);
	CloseServiceHandle(hServiceMgr);

	return errCode;
}
